/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import java.util.ArrayDeque;

abstract class WeakObjectPoolBase<T> {
    final ArrayDeque<T> cache = new ArrayDeque();
    private final int initSize;
    private final int maxSize;
    int leased = 0;

    public WeakObjectPoolBase(int initSize) {
        this.initSize = initSize;
        this.maxSize = 2 * initSize;
    }

    public T pop() {
        ++this.leased;
        T obj = this.cache.poll();
        return obj == null ? this.newInstance() : obj;
    }

    public boolean push(T obj) {
        --this.leased;
        assert (obj != null);
        if (this.cache.size() < this.maxSize) {
            this.clear(obj);
            this.cache.push(obj);
            return true;
        }
        this.close(obj);
        return false;
    }

    public int resetLeased() {
        int l = this.leased;
        this.leased = 0;
        return l;
    }

    public int size() {
        return this.cache.size();
    }

    void clear(T obj) {
    }

    void close(T obj) {
    }

    final void fill() {
        for (int i = 0; i < this.initSize; ++i) {
            this.cache.add(this.newInstance());
        }
    }

    abstract T newInstance();
}

