/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.histogram.org.HdrHistogram;

import io.questdb.std.histogram.org.HdrHistogram.AbstractHistogram;
import io.questdb.std.histogram.org.HdrHistogram.AbstractHistogramIterator;
import io.questdb.std.histogram.org.HdrHistogram.HistogramIterationValue;
import java.util.Iterator;

public class LogarithmicIterator
extends AbstractHistogramIterator
implements Iterator<HistogramIterationValue> {
    long currentStepHighestValueReportingLevel;
    long currentStepLowestValueReportingLevel;
    double logBase;
    double nextValueReportingLevel;
    long valueUnitsInFirstBucket;

    public LogarithmicIterator(AbstractHistogram histogram, long valueUnitsInFirstBucket, double logBase) {
        this.reset(histogram, valueUnitsInFirstBucket, logBase);
    }

    @Override
    public boolean hasNext() {
        if (super.hasNext()) {
            return true;
        }
        return this.histogram.lowestEquivalentValue((long)this.nextValueReportingLevel) < this.nextValueAtIndex;
    }

    public void reset(long valueUnitsInFirstBucket, double logBase) {
        this.reset(this.histogram, valueUnitsInFirstBucket, logBase);
    }

    private void reset(AbstractHistogram histogram, long valueUnitsInFirstBucket, double logBase) {
        super.resetIterator(histogram);
        this.logBase = logBase;
        this.valueUnitsInFirstBucket = valueUnitsInFirstBucket;
        this.nextValueReportingLevel = valueUnitsInFirstBucket;
        this.currentStepHighestValueReportingLevel = (long)this.nextValueReportingLevel - 1L;
        this.currentStepLowestValueReportingLevel = histogram.lowestEquivalentValue(this.currentStepHighestValueReportingLevel);
    }

    @Override
    long getValueIteratedTo() {
        return this.currentStepHighestValueReportingLevel;
    }

    @Override
    void incrementIterationLevel() {
        this.nextValueReportingLevel *= this.logBase;
        this.currentStepHighestValueReportingLevel = (long)this.nextValueReportingLevel - 1L;
        this.currentStepLowestValueReportingLevel = this.histogram.lowestEquivalentValue(this.currentStepHighestValueReportingLevel);
    }

    @Override
    boolean reachedIterationLevel() {
        return this.currentValueAtIndex >= this.currentStepLowestValueReportingLevel || this.currentIndex >= this.histogram.countsArrayLength - 1;
    }
}

