/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.str;

import io.questdb.cairo.CairoException;
import io.questdb.griffin.engine.functions.str.TrimType;
import io.questdb.std.Chars;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ThreadLocal;
import io.questdb.std.Unsafe;
import io.questdb.std.Vect;
import io.questdb.std.str.DirectUtf8Sequence;
import io.questdb.std.str.DirectUtf8Sink;
import io.questdb.std.str.MutableUtf16Sink;
import io.questdb.std.str.StringSink;
import io.questdb.std.str.Utf16Sink;
import io.questdb.std.str.Utf8Sequence;
import io.questdb.std.str.Utf8Sink;
import io.questdb.std.str.Utf8String;
import io.questdb.std.str.Utf8StringSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Utf8s {
    private static final long ASCII_MASK = -9187201950435737472L;
    private static final char[] HEX_CHARS = "0123456789ABCDEF".toCharArray();
    private static final ThreadLocal<StringSink> tlSink = new ThreadLocal<StringSink>(StringSink::new);

    private Utf8s() {
    }

    public static int compare(Utf8Sequence l, Utf8Sequence r) {
        if (l == r) {
            return 0;
        }
        if (l == null) {
            return -1;
        }
        if (r == null) {
            return 1;
        }
        int ll = l.size();
        int rl = r.size();
        int min = Math.min(ll, rl);
        for (int i = 0; i < min; ++i) {
            int k = Numbers.compareUnsigned(l.byteAt(i), r.byteAt(i));
            if (k == 0) continue;
            return k;
        }
        return Integer.compare(ll, rl);
    }

    public static boolean contains(@NotNull Utf8Sequence sequence, @NotNull Utf8Sequence term) {
        return Utf8s.indexOf(sequence, 0, sequence.size(), term) != -1;
    }

    public static boolean containsAscii(@NotNull Utf8Sequence sequence, @NotNull CharSequence asciiTerm) {
        return Utf8s.indexOfAscii(sequence, 0, sequence.size(), asciiTerm) != -1;
    }

    public static boolean containsLowerCaseAscii(@NotNull Utf8Sequence sequence, @NotNull Utf8Sequence asciiTerm) {
        return Utf8s.indexOfLowerCaseAscii(sequence, 0, sequence.size(), asciiTerm) != -1;
    }

    public static CharSequence directUtf8ToUtf16(@NotNull DirectUtf8Sequence utf8CharSeq, @NotNull MutableUtf16Sink tempSink) {
        if (utf8CharSeq.isAscii()) {
            return utf8CharSeq.asAsciiCharSequence();
        }
        Utf8s.utf8ToUtf16Unchecked(utf8CharSeq, tempSink);
        return tempSink;
    }

    public static int encodeUtf16Char(@NotNull Utf8Sink sink, @NotNull CharSequence cs, int hi, int i, char c) {
        if (c < '\u0800') {
            sink.put((byte)(0xC0 | c >> 6));
            sink.put((byte)(0x80 | c & 0x3F));
        } else if (Character.isSurrogate(c)) {
            i = Utf8s.encodeUtf16Surrogate(sink, c, cs, i, hi);
        } else {
            sink.put((byte)(0xE0 | c >> 12));
            sink.put((byte)(0x80 | c >> 6 & 0x3F));
            sink.put((byte)(0x80 | c & 0x3F));
        }
        return i;
    }

    public static boolean encodeUtf16WithLimit(@NotNull Utf8Sink sink, @NotNull CharSequence cs, int maxBytes) {
        int len = cs.length();
        int bytes = 0;
        int i = 0;
        while (i < len) {
            int c;
            if ((c = cs.charAt(i++)) < 128) {
                if (bytes + 1 > maxBytes) {
                    return false;
                }
                sink.putAscii((char)c);
                ++bytes;
                continue;
            }
            if (c < 2048) {
                if (bytes + 2 > maxBytes) {
                    return false;
                }
                sink.put((byte)(0xC0 | c >> 6));
                sink.put((byte)(0x80 | c & 0x3F));
                bytes += 2;
                continue;
            }
            if (Character.isSurrogate((char)c)) {
                boolean valid = Character.isHighSurrogate((char)c);
                int dword = c;
                if (valid) {
                    char c2;
                    if (len - i < 1) {
                        valid = false;
                    } else if (Character.isLowSurrogate(c2 = cs.charAt(i++))) {
                        dword = Character.toCodePoint((char)c, c2);
                    } else {
                        valid = false;
                    }
                }
                if (!valid) {
                    if (bytes + 1 > maxBytes) {
                        return false;
                    }
                    sink.putAscii('?');
                    ++bytes;
                    continue;
                }
                if (bytes + 4 > maxBytes) {
                    return false;
                }
                sink.put((byte)(0xF0 | dword >> 18));
                sink.put((byte)(0x80 | dword >> 12 & 0x3F));
                sink.put((byte)(0x80 | dword >> 6 & 0x3F));
                sink.put((byte)(0x80 | dword & 0x3F));
                bytes += 4;
                continue;
            }
            if (bytes + 3 > maxBytes) {
                return false;
            }
            sink.put((byte)(0xE0 | c >> 12));
            sink.put((byte)(0x80 | c >> 6 & 0x3F));
            sink.put((byte)(0x80 | c & 0x3F));
            bytes += 3;
        }
        return true;
    }

    public static boolean endsWith(@NotNull Utf8Sequence seq, @NotNull Utf8Sequence endsWith) {
        int endsWithSize = endsWith.size();
        if (endsWithSize == 0) {
            return true;
        }
        int seqSize = seq.size();
        return seqSize >= endsWithSize && Utf8s.equalSuffixBytes(seq, endsWith, seqSize, endsWithSize);
    }

    public static boolean endsWithAscii(@NotNull Utf8Sequence seq, @NotNull CharSequence endsAscii) {
        int l = endsAscii.length();
        if (l == 0) {
            return true;
        }
        int size = seq.size();
        return size != 0 && size >= l && Utf8s.equalsAscii(endsAscii, seq, size - l, size);
    }

    public static boolean endsWithAscii(@NotNull Utf8Sequence us, char asciiChar) {
        int size = us.size();
        return size != 0 && asciiChar == us.byteAt(size - 1);
    }

    public static boolean endsWithLowerCaseAscii(@NotNull Utf8Sequence seq, @NotNull Utf8Sequence asciiEnds) {
        int size = asciiEnds.size();
        if (size == 0) {
            return true;
        }
        int seqSize = seq.size();
        return seqSize != 0 && seqSize >= size && Utf8s.equalsAsciiLowerCase(asciiEnds, seq, seqSize - size, seqSize);
    }

    public static boolean equals(@NotNull DirectUtf8Sequence l, @NotNull Utf8String r) {
        int lSize = l.size();
        return lSize == r.size() && Utf8s.dataEquals(l, r, 0, lSize);
    }

    public static boolean equals(@NotNull Utf8Sequence l, long lSixPrefix, @NotNull Utf8Sequence r, long rSixPrefix) {
        int lSize = l.size();
        return lSize == r.size() && lSixPrefix == rSixPrefix && Utf8s.dataEquals(l, r, 6, lSize);
    }

    public static boolean equals(@Nullable Utf8Sequence l, @Nullable Utf8Sequence r) {
        if (l == null && r == null) {
            return true;
        }
        if (l == null || r == null) {
            return false;
        }
        int lSize = l.size();
        return lSize == r.size() && l.zeroPaddedSixPrefix() == r.zeroPaddedSixPrefix() && Utf8s.dataEquals(l, r, 6, lSize);
    }

    public static boolean equals(@NotNull Utf8Sequence l, int lLo, int lHi, @NotNull Utf8Sequence r, int rLo, int rHi) {
        if (l == r) {
            return true;
        }
        int ll = lHi - lLo;
        if (ll != rHi - rLo) {
            return false;
        }
        for (int i = 0; i < ll; ++i) {
            if (l.byteAt(i + lLo) == r.byteAt(i + rLo)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(DirectUtf8Sink l, long rPtr, int rLen) {
        if (l.size() != rLen) {
            return false;
        }
        return Vect.memeq(l.ptr(), rPtr, rLen);
    }

    public static boolean equalsAscii(@NotNull CharSequence lAsciiSeq, int lLo, int lHi, @NotNull Utf8Sequence rSeq, int rLo, int rHi) {
        int ll = lHi - lLo;
        if (ll != rHi - rLo) {
            return false;
        }
        for (int i = 0; i < ll; ++i) {
            if (lAsciiSeq.charAt(i + lLo) == rSeq.byteAt(i + rLo)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsAscii(@NotNull CharSequence asciiSeq, @NotNull Utf8Sequence seq) {
        int len = asciiSeq.length();
        if (len != seq.size()) {
            return false;
        }
        for (int index = 0; index < len; ++index) {
            if (asciiSeq.charAt(index) == seq.byteAt(index)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsAscii(@NotNull CharSequence asciiSeq, long rLo, long rHi) {
        int rLen = (int)(rHi - rLo);
        if (rLen != asciiSeq.length()) {
            return false;
        }
        for (int i = 0; i < rLen; ++i) {
            if (asciiSeq.charAt(i) == (char)Unsafe.getUnsafe().getByte(rLo + (long)i)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsAscii(@NotNull CharSequence lAsciiSeq, @NotNull Utf8Sequence rSeq, int rLo, int rHi) {
        int ll = lAsciiSeq.length();
        if (ll != rHi - rLo) {
            return false;
        }
        for (int i = 0; i < ll; ++i) {
            if (lAsciiSeq.charAt(i) == rSeq.byteAt(i + rLo)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIgnoreCaseAscii(@NotNull Utf8Sequence lSeq, @NotNull Utf8Sequence rSeq) {
        int size = lSeq.size();
        if (size != rSeq.size()) {
            return false;
        }
        for (int index = 0; index < size; ++index) {
            if (Utf8s.toLowerCaseAscii(lSeq.byteAt(index)) == Utf8s.toLowerCaseAscii(rSeq.byteAt(index))) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIgnoreCaseAscii(@NotNull Utf8Sequence lSeq, int lLo, int lHi, @NotNull Utf8Sequence rSeq, int rLo, int rHi) {
        if (lSeq == rSeq) {
            return true;
        }
        int ll = lHi - lLo;
        if (ll != rHi - rLo) {
            return false;
        }
        for (int i = 0; i < ll; ++i) {
            if (Utf8s.toLowerCaseAscii(lSeq.byteAt(i + lLo)) == Utf8s.toLowerCaseAscii(rSeq.byteAt(i + rLo))) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIgnoreCaseAscii(@NotNull CharSequence asciiSeq, @NotNull Utf8Sequence seq) {
        int len = asciiSeq.length();
        if (len != seq.size()) {
            return false;
        }
        for (int index = 0; index < len; ++index) {
            if (Chars.toLowerCaseAscii(asciiSeq.charAt(index)) == Utf8s.toLowerCaseAscii(seq.byteAt(index))) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsNcAscii(@NotNull CharSequence asciiSeq, @Nullable Utf8Sequence seq) {
        return seq != null && Utf8s.equalsAscii(asciiSeq, seq);
    }

    public static boolean equalsUtf16(CharSequence l, Utf8Sequence r) {
        return Utf8s.equalsUtf16(l, 0, l.length(), r, 0, r.size());
    }

    public static boolean equalsUtf16(CharSequence c, int ci, int cn, Utf8Sequence u, int ui, int un) {
        block4: while (ui < un && ci < cn) {
            int bytes = Utf8s.utf16Equals(c, ci, cn, u, ui, un);
            switch (bytes) {
                case 4: {
                    ++ci;
                }
                case 1: 
                case 2: 
                case 3: {
                    ++ci;
                    ui += bytes;
                    continue block4;
                }
            }
            return false;
        }
        return ui == un && ci == cn;
    }

    public static boolean equalsUtf16Nc(CharSequence l, Utf8Sequence r) {
        if (l == null || r == null) {
            return l == r;
        }
        return Utf8s.equalsUtf16(l, r);
    }

    public static int getUtf8Codepoint(int b1, int b2, int b3, int b4) {
        return b1 << 18 ^ b2 << 12 ^ b3 << 6 ^ b4 ^ 0x381F80;
    }

    public static int getUtf8SequenceType(long lo, long hi) {
        long p = lo;
        int sequenceType = 0;
        while (p < hi) {
            byte b = Unsafe.getUnsafe().getByte(p);
            if (b < 0) {
                int n = Utf8s.validateUtf8MultiByte(p, hi, b);
                if (n == -1) {
                    return -1;
                }
                p += (long)n;
                sequenceType = 1;
                continue;
            }
            ++p;
        }
        return sequenceType;
    }

    public static boolean greaterThan(@Nullable Utf8Sequence l, @Nullable Utf8Sequence r) {
        if (l == null || r == null) {
            return false;
        }
        int ll = l.size();
        int rl = r.size();
        int min = Math.min(ll, rl);
        for (int i = 0; i < min; ++i) {
            int k = Numbers.compareUnsigned(l.byteAt(i), r.byteAt(i));
            if (k == 0) continue;
            return k > 0;
        }
        return ll > rl;
    }

    public static int hashCode(@NotNull Utf8Sequence value) {
        int size = value.size();
        if (size == 0) {
            return 0;
        }
        int h = 0;
        for (int p = 0; p < size; ++p) {
            h = 31 * h + value.byteAt(p);
        }
        return h;
    }

    public static int hashCode(@NotNull Utf8Sequence value, int lo, int hi) {
        if (hi == lo) {
            return 0;
        }
        int h = 0;
        for (int p = lo; p < hi; ++p) {
            h = 31 * h + value.byteAt(p);
        }
        return h;
    }

    public static int indexOf(@NotNull Utf8Sequence seq, int seqLo, int seqHi, @NotNull Utf8Sequence term) {
        int termSize = term.size();
        if (termSize == 0) {
            return 0;
        }
        byte first = term.byteAt(0);
        int max = seqHi - termSize;
        for (int i = seqLo; i <= max; ++i) {
            if (seq.byteAt(i) != first) {
                while (++i <= max && seq.byteAt(i) != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + termSize - 1;
            int k = 1;
            while (j < end && seq.byteAt(j) == term.byteAt(k)) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(@NotNull Utf8Sequence seq, int seqLo, int seqHi, @NotNull Utf8Sequence term, int occurrence) {
        if (occurrence == 0) {
            return -1;
        }
        int termSize = term.size();
        if (termSize == 0) {
            return 0;
        }
        byte first = term.byteAt(0);
        int max = seqHi - termSize;
        int count = 0;
        if (occurrence > 0) {
            for (int i = seqLo; i <= max; ++i) {
                if (seq.byteAt(i) != first) {
                    while (++i <= max && seq.byteAt(i) != first) {
                    }
                }
                if (i > max) continue;
                int j = i + 1;
                int end = j + termSize - 1;
                int k = 1;
                while (j < end && seq.byteAt(j) == term.byteAt(k)) {
                    ++j;
                    ++k;
                }
                if (j != end || ++count != occurrence) continue;
                return i;
            }
        } else {
            for (int i = seqHi - termSize; i >= seqLo; --i) {
                if (seq.byteAt(i) != first) {
                    while (--i >= seqLo && seq.byteAt(i) != first) {
                    }
                }
                if (i < seqLo) continue;
                int j = i + 1;
                int end = j + termSize - 1;
                int k = 1;
                while (j < end && seq.byteAt(j) == term.byteAt(k)) {
                    ++j;
                    ++k;
                }
                if (j != end || --count != occurrence) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOfAscii(@NotNull Utf8Sequence seq, char asciiChar) {
        return Utf8s.indexOfAscii(seq, 0, asciiChar);
    }

    public static int indexOfAscii(@NotNull Utf8Sequence seq, int seqLo, char asciiChar) {
        return Utf8s.indexOfAscii(seq, seqLo, seq.size(), asciiChar);
    }

    public static int indexOfAscii(@NotNull Utf8Sequence seq, int seqLo, int seqHi, char asciiChar) {
        return Utf8s.indexOfAscii(seq, seqLo, seqHi, asciiChar, 1);
    }

    public static int indexOfAscii(@NotNull Utf8Sequence seq, int seqLo, int seqHi, @NotNull CharSequence asciiTerm) {
        int termLen = asciiTerm.length();
        if (termLen == 0) {
            return 0;
        }
        byte first = (byte)asciiTerm.charAt(0);
        int max = seqHi - termLen;
        for (int i = seqLo; i <= max; ++i) {
            if (seq.byteAt(i) != first) {
                while (++i <= max && seq.byteAt(i) != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + termLen - 1;
            int k = 1;
            while (j < end && seq.byteAt(j) == asciiTerm.charAt(k)) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfAscii(@NotNull Utf8Sequence seq, int seqLo, int seqHi, @NotNull CharSequence asciiTerm, int occurrence) {
        int termLen = asciiTerm.length();
        if (termLen == 0) {
            return -1;
        }
        if (occurrence == 0) {
            return -1;
        }
        int foundIndex = -1;
        int count = 0;
        if (occurrence > 0) {
            for (int i = seqLo; i < seqHi; ++i) {
                if (foundIndex == -1) {
                    if (seqHi - i < termLen) {
                        return -1;
                    }
                    if (seq.byteAt(i) == asciiTerm.charAt(0)) {
                        foundIndex = i;
                    }
                } else if (seq.byteAt(i) != asciiTerm.charAt(i - foundIndex)) {
                    i = foundIndex;
                    foundIndex = -1;
                }
                if (foundIndex == -1 || i - foundIndex != termLen - 1) continue;
                if (++count == occurrence) {
                    return foundIndex;
                }
                foundIndex = -1;
            }
        } else {
            for (int i = seqHi - 1; i >= seqLo; --i) {
                if (foundIndex == -1) {
                    if (i - seqLo + 1 < termLen) {
                        return -1;
                    }
                    if (seq.byteAt(i) == asciiTerm.charAt(termLen - 1)) {
                        foundIndex = i;
                    }
                } else if (seq.byteAt(i) != asciiTerm.charAt(termLen - 1 + i - foundIndex)) {
                    i = foundIndex;
                    foundIndex = -1;
                }
                if (foundIndex == -1 || foundIndex - i != termLen - 1) continue;
                if (--count == occurrence) {
                    return foundIndex + 1 - termLen;
                }
                foundIndex = -1;
            }
        }
        return -1;
    }

    public static int indexOfAscii(@NotNull Utf8Sequence seq, int seqLo, int seqHi, char asciiChar, int occurrence) {
        if (occurrence == 0) {
            return -1;
        }
        int count = 0;
        if (occurrence > 0) {
            for (int i = seqLo; i < seqHi; ++i) {
                if (seq.byteAt(i) != asciiChar || ++count != occurrence) continue;
                return i;
            }
        } else {
            for (int i = seqHi - 1; i >= seqLo; --i) {
                if (seq.byteAt(i) != asciiChar || --count != occurrence) continue;
                return i;
            }
        }
        return -1;
    }

    public static int indexOfLowerCaseAscii(@NotNull Utf8Sequence seq, int seqLo, int seqHi, @NotNull Utf8Sequence termLC) {
        int termSize = termLC.size();
        if (termSize == 0) {
            return 0;
        }
        byte first = termLC.byteAt(0);
        int max = seqHi - termSize;
        for (int i = seqLo; i <= max; ++i) {
            if (Utf8s.toLowerCaseAscii(seq.byteAt(i)) != first) {
                while (++i <= max && Utf8s.toLowerCaseAscii(seq.byteAt(i)) != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + termSize - 1;
            int k = 1;
            while (j < end && Utf8s.toLowerCaseAscii(seq.byteAt(j)) == termLC.byteAt(k)) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    public static boolean isAscii(Utf8Sequence utf8) {
        if (utf8 != null) {
            int kl = utf8.size();
            for (int k = 0; k < kl; ++k) {
                if (utf8.byteAt(k) >= 0) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isAscii(long w) {
        return (w & 0x8080808080808080L) == 0L;
    }

    public static boolean isAscii(long ptr, int size) {
        long i = 0L;
        while (i + 7L < (long)size) {
            if (Utf8s.isAscii(Unsafe.getUnsafe().getLong(ptr + i))) {
                return false;
            }
            i += 8L;
        }
        while (i < (long)size) {
            if (Unsafe.getUnsafe().getByte(ptr + i) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int lastIndexOfAscii(@NotNull Utf8Sequence seq, char asciiTerm) {
        for (int i = seq.size() - 1; i > -1; --i) {
            if (seq.byteAt(i) != asciiTerm) continue;
            return i;
        }
        return -1;
    }

    public static int length(Utf8Sequence value) {
        int i;
        if (value == null) {
            return -1;
        }
        int size = value.size();
        if (value.isAscii()) {
            return size;
        }
        int continuationByteCount = 0;
        for (i = 0; i <= size - 8; i += 8) {
            long c = value.longAt(i);
            long x = c & 0x8080808080808080L;
            long y = (c ^ 0xFFFFFFFFFFFFFFFFL) << 1;
            long swarDelta = x & y;
            int delta = Long.bitCount(swarDelta);
            continuationByteCount += delta;
        }
        while (i < size) {
            byte c = value.byteAt(i);
            int x = c & 0x80;
            int y = ~c << 1;
            int delta = (x & y) >>> 7;
            continuationByteCount += delta;
            ++i;
        }
        return size - continuationByteCount;
    }

    public static boolean lessThan(@Nullable Utf8Sequence l, @Nullable Utf8Sequence r) {
        if (l == null || r == null) {
            return false;
        }
        int ll = l.size();
        int rl = r.size();
        int min = Math.min(ll, rl);
        for (int i = 0; i < min; ++i) {
            int k = Numbers.compareUnsigned(l.byteAt(i), r.byteAt(i));
            if (k == 0) continue;
            return k < 0;
        }
        return ll < rl;
    }

    public static boolean lessThan(@Nullable Utf8Sequence l, @Nullable Utf8Sequence r, boolean negated) {
        boolean eq = Utf8s.equals(l, r);
        return negated ? eq || Utf8s.greaterThan(l, r) : !eq && Utf8s.lessThan(l, r);
    }

    public static int lowerCaseAsciiHashCode(@NotNull Utf8Sequence value) {
        int size = value.size();
        if (size == 0) {
            return 0;
        }
        int h = 0;
        for (int p = 0; p < size; ++p) {
            h = 31 * h + Utf8s.toLowerCaseAscii(value.byteAt(p));
        }
        return h;
    }

    public static int lowerCaseAsciiHashCode(@NotNull Utf8Sequence value, int lo, int hi) {
        if (hi == lo) {
            return 0;
        }
        int h = 0;
        for (int p = lo; p < hi; ++p) {
            h = 31 * h + Utf8s.toLowerCaseAscii(value.byteAt(p));
        }
        return h;
    }

    public static void putSafe(long lo, long hi, @NotNull Utf8Sink sink) {
        long p = lo;
        while (p < hi) {
            byte b = Unsafe.getUnsafe().getByte(p);
            if (b < 0) {
                int n = Utf8s.putMultibyteSafe(p, hi, b, sink);
                p += (long)n;
                continue;
            }
            char c = (char)b;
            if (!Character.isISOControl(c)) {
                sink.put(c);
            } else {
                Utf8s.putNonAsciiAsHex(sink, b);
            }
            ++p;
        }
    }

    public static void putSafe(@NotNull Utf8Sequence source, @NotNull Utf8Sink sink) {
        Utf8s.putSafe(source, 0, source.size(), sink);
    }

    public static void putSafe(@NotNull Utf8Sequence source, int lo, int hi, @NotNull Utf8Sink sink) {
        int pos = lo;
        while (pos < hi) {
            byte b = source.byteAt(pos);
            if (b < 0) {
                int n = Utf8s.putMultibyteSafe(source, pos, hi, b, sink);
                pos += n;
                continue;
            }
            char c = (char)b;
            if (!Character.isISOControl(c)) {
                sink.put(c);
            } else {
                Utf8s.putNonAsciiAsHex(sink, b);
            }
            ++pos;
        }
    }

    public static boolean startsWith(@NotNull Utf8Sequence seq, @NotNull Utf8Sequence startsWith) {
        int startsWithSize = startsWith.size();
        return startsWithSize == 0 || seq.size() >= startsWithSize && Utf8s.equalPrefixBytes(seq, seq.zeroPaddedSixPrefix(), startsWith, startsWith.zeroPaddedSixPrefix(), startsWithSize);
    }

    public static boolean startsWith(@NotNull Utf8Sequence seq, long seqSixPrefix, @NotNull Utf8Sequence startsWith, long startsWithSixPrefix) {
        int startsWithSize = startsWith.size();
        return startsWithSize == 0 || seq.size() >= startsWithSize && Utf8s.equalPrefixBytes(seq, seqSixPrefix, startsWith, startsWithSixPrefix, startsWithSize);
    }

    public static boolean startsWithAscii(@NotNull Utf8Sequence seq, @NotNull CharSequence asciiStarts) {
        int len = asciiStarts.length();
        return seq.size() >= len && Utf8s.equalsAscii(asciiStarts, seq, 0, len);
    }

    public static boolean startsWithLowerCaseAscii(@NotNull Utf8Sequence seq, @NotNull Utf8Sequence asciiStarts) {
        int size = asciiStarts.size();
        if (size == 0) {
            return true;
        }
        return seq.size() >= size && Utf8s.equalsAsciiLowerCase(asciiStarts, seq, size);
    }

    public static void strCpy(@NotNull Utf8Sequence src, int destLen, long destAddr) {
        for (int i = 0; i < destLen; ++i) {
            Unsafe.getUnsafe().putByte(destAddr + (long)i, src.byteAt(i));
        }
    }

    public static void strCpy(long srcLo, long srcHi, @NotNull Utf8Sink dest) {
        for (long i = srcLo; i < srcHi; ++i) {
            dest.putAny(Unsafe.getUnsafe().getByte(i));
        }
    }

    public static int strCpy(@NotNull Utf8Sequence seq, int charLo, int charHi, @NotNull Utf8Sink sink) {
        if (seq.isAscii()) {
            for (int i = charLo; i < charHi; ++i) {
                sink.putAscii((char)seq.byteAt(i));
            }
            return charHi - charLo;
        }
        return Utf8s.strCpyNonAscii(seq, charLo, charHi, sink);
    }

    public static void strCpyAscii(char @NotNull [] srcChars, int srcLo, int srcLen, long destAddr) {
        for (int i = 0; i < srcLen; ++i) {
            Unsafe.getUnsafe().putByte(destAddr + (long)i, (byte)srcChars[i + srcLo]);
        }
    }

    public static long strCpyAscii(@NotNull CharSequence asciiSrc, long destAddr) {
        Utf8s.strCpyAscii(asciiSrc, asciiSrc.length(), destAddr);
        return destAddr;
    }

    public static void strCpyAscii(@NotNull CharSequence asciiSrc, int srcLen, long destAddr) {
        Utf8s.strCpyAscii(asciiSrc, 0, srcLen, destAddr);
    }

    public static void strCpyAscii(@NotNull CharSequence asciiSrc, int srcLo, int srcLen, long destAddr) {
        for (int i = 0; i < srcLen; ++i) {
            Unsafe.getUnsafe().putByte(destAddr + (long)i, (byte)asciiSrc.charAt(srcLo + i));
        }
    }

    public static String stringFromUtf8Bytes(long lo, long hi) {
        if (hi == lo) {
            return "";
        }
        StringSink b = Utf8s.getThreadLocalSink();
        if (!Utf8s.utf8ToUtf16(lo, hi, b)) {
            throw CairoException.nonCritical().put("cannot convert invalid UTF-8 sequence to UTF-16");
        }
        return ((Object)b).toString();
    }

    public static String stringFromUtf8Bytes(@NotNull Utf8Sequence seq) {
        if (seq.size() == 0) {
            return "";
        }
        StringSink b = Utf8s.getThreadLocalSink();
        if (!Utf8s.utf8ToUtf16(seq, b)) {
            throw CairoException.nonCritical().put("cannot convert invalid UTF-8 sequence to UTF-16");
        }
        return ((Object)b).toString();
    }

    public static String stringFromUtf8BytesSafe(@NotNull Utf8Sequence seq) {
        if (seq.size() == 0) {
            return "";
        }
        StringSink b = Utf8s.getThreadLocalSink();
        Utf8s.utf8ToUtf16(seq, b);
        return ((Object)b).toString();
    }

    public static int strpos(@NotNull Utf8Sequence haystack, @NotNull Utf8Sequence needle) {
        int substrSize = needle.size();
        if (substrSize < 1) {
            return 1;
        }
        int strSize = haystack.size();
        if (strSize < 1) {
            return 0;
        }
        int strPos = 0;
        int n = strSize - substrSize + 1;
        block0: for (int i = 0; i < n; ++i) {
            byte c = haystack.byteAt(i);
            if ((c & 0xC0) != 128) {
                ++strPos;
            }
            if (c != needle.byteAt(0)) continue;
            for (int k = 1; k < substrSize; ++k) {
                if (haystack.byteAt(i + k) != needle.byteAt(k)) continue block0;
            }
            return strPos;
        }
        return 0;
    }

    public static String toString(@NotNull Utf8Sequence us, int start, int end, byte unescapeAscii) {
        Utf8StringSink sink = Misc.getThreadLocalUtf8Sink();
        int lastChar = end - 1;
        for (int i = start; i < end; ++i) {
            byte b = us.byteAt(i);
            sink.putAny(b);
            if (b != unescapeAscii || i >= lastChar || us.byteAt(i + 1) != unescapeAscii) continue;
            ++i;
        }
        return ((Object)sink).toString();
    }

    public static String toString(@Nullable Utf8Sequence s) {
        return s == null ? null : s.toString();
    }

    public static Utf8String toUtf8String(@Nullable Utf8Sequence s) {
        return s == null ? null : Utf8String.newInstance(s);
    }

    public static void trim(TrimType type, Utf8Sequence source, Utf8Sink sink) {
        int start;
        if (source == null || source.size() == 0) {
            return;
        }
        int limit = source.size();
        if (type != TrimType.RTRIM) {
            for (start = 0; start < limit && source.byteAt(start) == 32; ++start) {
            }
        }
        if (type != TrimType.LTRIM) {
            while (limit > start && source.byteAt(limit - 1) == 32) {
                --limit;
            }
        }
        sink.putAny(source, start, limit);
    }

    public static int utf8Bytes(CharSequence sequence) {
        int count = 0;
        int len = sequence.length();
        for (int i = 0; i < len; ++i) {
            char ch = sequence.charAt(i);
            if (ch < '\u0080') {
                ++count;
                continue;
            }
            if (ch < '\u0800') {
                count += 2;
                continue;
            }
            if (Character.isSurrogate(ch)) {
                if (Character.isHighSurrogate(ch)) {
                    if (i + 1 < len && Character.isLowSurrogate(sequence.charAt(i + 1))) {
                        count += 4;
                        ++i;
                        continue;
                    }
                    ++count;
                    continue;
                }
                ++count;
                continue;
            }
            count += 3;
        }
        return count;
    }

    public static int utf8CharDecode(Utf8Sequence seq) {
        return Utf8s.utf8CharDecode(seq, 0);
    }

    public static int utf8CharDecode(Utf8Sequence seq, int offset) {
        int size = seq.size() - offset;
        if (size > 0) {
            byte b1 = seq.byteAt(offset);
            if (b1 < 0) {
                if (b1 >> 5 == -2 && (b1 & 0x1E) != 0 && size > 1) {
                    byte b2 = seq.byteAt(offset + 1);
                    if (Utf8s.isNotContinuation(b2)) {
                        return 0;
                    }
                    return Numbers.encodeLowHighShorts((short)2, (short)(b1 << 6 ^ b2 ^ 0xF80));
                }
                if (b1 >> 4 == -2 && size > 2) {
                    byte b3;
                    byte b2 = seq.byteAt(offset + 1);
                    if (Utf8s.isMalformed3(b1, b2, b3 = seq.byteAt(offset + 2))) {
                        return 0;
                    }
                    char c = Utf8s.utf8ToChar(b1, b2, b3);
                    if (Character.isSurrogate(c)) {
                        return 0;
                    }
                    return Numbers.encodeLowHighShorts((short)3, (short)c);
                }
                return 0;
            }
            return Numbers.encodeLowHighShorts((short)1, b1);
        }
        return 0;
    }

    public static int utf8DecodeMultiByte(long lo, long hi, byte b, Utf16Sink sink) {
        if (b >> 5 == -2 && (b & 0x1E) != 0) {
            return Utf8s.utf8Decode2Bytes(lo, hi, (int)b, sink);
        }
        if (b >> 4 == -2) {
            return Utf8s.utf8Decode3Bytes(lo, hi, b, sink);
        }
        return Utf8s.utf8Decode4Bytes(lo, hi, (int)b, sink);
    }

    public static char utf8ToChar(byte b1, byte b2, byte b3) {
        return (char)(b1 << 12 ^ b2 << 6 ^ b3 ^ 0xFFFE1F80);
    }

    public static boolean utf8ToUtf16(long lo, long hi, @NotNull Utf16Sink sink) {
        long p = lo;
        while (p < hi) {
            byte b = Unsafe.getUnsafe().getByte(p);
            if (b < 0) {
                int n = Utf8s.utf8DecodeMultiByte(p, hi, b, sink);
                if (n == -1) {
                    return false;
                }
                p += (long)n;
                continue;
            }
            sink.put((char)b);
            ++p;
        }
        return true;
    }

    public static boolean utf8ToUtf16(@NotNull Utf8Sequence seq, int seqLo, int seqHi, @NotNull Utf16Sink sink) {
        int i = seqLo;
        while (i < seqHi) {
            byte b = seq.byteAt(i);
            if (b < 0) {
                int n = Utf8s.utf8DecodeMultiByte(seq, i, b, sink);
                if (n == -1) {
                    return false;
                }
                i += n;
                continue;
            }
            sink.put((char)b);
            ++i;
        }
        return true;
    }

    public static boolean utf8ToUtf16(@NotNull Utf8Sequence seq, @NotNull Utf16Sink sink) {
        return Utf8s.utf8ToUtf16(seq, 0, seq.size(), sink);
    }

    public static int utf8ToUtf16(@NotNull Utf8Sequence seq, @NotNull Utf16Sink sink, byte terminator) {
        assert (terminator >= 0) : "terminator must be ASCII character";
        int i = 0;
        int size = seq.size();
        while (i < size) {
            byte b = seq.byteAt(i);
            if (b == terminator) {
                return i;
            }
            if (b < 0) {
                int n = Utf8s.utf8DecodeMultiByte(seq, i, b, sink);
                if (n == -1) {
                    return -1;
                }
                i += n;
                continue;
            }
            sink.put((char)b);
            ++i;
        }
        return i;
    }

    public static boolean utf8ToUtf16EscConsecutiveQuotes(long lo, long hi, @NotNull Utf16Sink sink) {
        long p = lo;
        int quoteCount = 0;
        while (p < hi) {
            byte b = Unsafe.getUnsafe().getByte(p);
            if (b < 0) {
                int n = Utf8s.utf8DecodeMultiByte(p, hi, b, sink);
                if (n == -1) {
                    return false;
                }
                p += (long)n;
                continue;
            }
            if (b == 34) {
                if (quoteCount++ % 2 == 0) {
                    sink.put('\"');
                }
            } else {
                quoteCount = 0;
                sink.put((char)b);
            }
            ++p;
        }
        return true;
    }

    public static void utf8ToUtf16Unchecked(@NotNull DirectUtf8Sequence utf8CharSeq, @NotNull MutableUtf16Sink tempSink) {
        tempSink.clear();
        if (!Utf8s.utf8ToUtf16(utf8CharSeq.lo(), utf8CharSeq.hi(), tempSink)) {
            throw CairoException.nonCritical().put("invalid UTF8 in value for ").put(utf8CharSeq);
        }
    }

    public static boolean utf8ToUtf16Z(long lo, Utf16Sink sink) {
        byte b;
        long p = lo;
        while ((b = Unsafe.getUnsafe().getByte(p)) != 0) {
            if (b < 0) {
                int n = Utf8s.utf8DecodeMultiByteZ(p, b, sink);
                if (n == -1) {
                    return false;
                }
                p += (long)n;
                continue;
            }
            sink.put((char)b);
            ++p;
        }
        return true;
    }

    public static void utf8ZCopy(long addr, Utf8Sink sink) {
        byte b;
        long p = addr;
        while ((b = Unsafe.getUnsafe().getByte(p++)) != 0) {
            sink.putAny(b);
        }
    }

    public static int validateUtf8(@NotNull Utf8Sequence seq) {
        if (seq.isAscii()) {
            return seq.size();
        }
        int len = 0;
        int i = 0;
        int hi = seq.size();
        while (i < hi) {
            byte b = seq.byteAt(i);
            if (b < 0) {
                int n = Utf8s.validateUtf8MultiByte(seq, i, b);
                if (n == -1) {
                    return -1;
                }
                i += n;
            } else {
                ++i;
            }
            ++len;
        }
        return len;
    }

    public static int validateUtf8MultiByte(long lo, long hi, byte b) {
        if (b >> 5 == -2 && (b & 0x1E) != 0) {
            return Utf8s.validateUtf8Decode2Bytes(lo, hi);
        }
        if (b >> 4 == -2) {
            return Utf8s.validateUtf8Decode3Bytes(lo, hi, b);
        }
        return Utf8s.validateUtf8Decode4Bytes(lo, hi, (int)b);
    }

    public static long zeroPaddedSixPrefix(@NotNull Utf8Sequence seq) {
        int size = seq.size();
        if (size >= 8) {
            return seq.longAt(0) & 0xFFFFFFFFFFFFL;
        }
        long limit = Math.min(size, 6);
        long result = 0L;
        int i = 0;
        while ((long)i < limit) {
            result |= ((long)seq.byteAt(i) & 0xFFL) << 8 * i;
            ++i;
        }
        return result;
    }

    private static boolean dataEquals(@NotNull Utf8Sequence l, @NotNull Utf8Sequence r, int start, int limit) {
        int i;
        for (i = start; i <= limit - 8; i += 8) {
            if (l.longAt(i) == r.longAt(i)) continue;
            return false;
        }
        if (i <= limit - 4) {
            if (l.intAt(i) != r.intAt(i)) {
                return false;
            }
            i += 4;
        }
        if (i <= limit - 2) {
            if (l.shortAt(i) != r.shortAt(i)) {
                return false;
            }
            i += 2;
        }
        return i >= limit || l.byteAt(i) == r.byteAt(i);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int encodeUtf16Surrogate(@NotNull Utf8Sink sink, char c, @NotNull CharSequence in, int pos, int hi) {
        int dword;
        if (Character.isHighSurrogate((char)c)) {
            char c2;
            if (hi - pos < 1) {
                sink.putAscii('?');
                return pos;
            }
            if (!Character.isLowSurrogate(c2 = in.charAt(pos++))) {
                sink.putAscii('?');
                return pos;
            }
            dword = Character.toCodePoint((char)c, c2);
        } else {
            if (Character.isLowSurrogate((char)c)) {
                sink.putAscii('?');
                return pos;
            }
            dword = c;
        }
        sink.put((byte)(0xF0 | dword >> 18));
        sink.put((byte)(0x80 | dword >> 12 & 0x3F));
        sink.put((byte)(0x80 | dword >> 6 & 0x3F));
        sink.put((byte)(0x80 | dword & 0x3F));
        return pos;
    }

    private static boolean equalPrefixBytes(@NotNull Utf8Sequence l, long lSixPrefix, @NotNull Utf8Sequence r, long rSixPrefix, int prefixSize) {
        long prefixMask = (1L << 8 * Math.min(6, prefixSize)) - 1L;
        return ((lSixPrefix ^ rSixPrefix) & prefixMask) == 0L && Utf8s.dataEquals(l, r, 6, prefixSize);
    }

    private static boolean equalSuffixBytes(@NotNull Utf8Sequence seq, @NotNull Utf8Sequence suffix, int seqSize, int suffixSize) {
        int i;
        int seqLo = seqSize - suffixSize;
        for (i = 0; i <= suffixSize - 8; i += 8) {
            if (suffix.longAt(i) == seq.longAt(i + seqLo)) continue;
            return false;
        }
        while (i < suffixSize) {
            if (suffix.byteAt(i) != seq.byteAt(i + seqLo)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean equalsAsciiLowerCase(@NotNull Utf8Sequence lLC, @NotNull Utf8Sequence r, int size) {
        for (int i = 0; i < size; ++i) {
            if (lLC.byteAt(i) == Utf8s.toLowerCaseAscii(r.byteAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean equalsAsciiLowerCase(@NotNull Utf8Sequence lLC, @NotNull Utf8Sequence r, int rLo, int rHi) {
        int ls = lLC.size();
        if (ls != rHi - rLo) {
            return false;
        }
        for (int i = 0; i < ls; ++i) {
            if (lLC.byteAt(i) == Utf8s.toLowerCaseAscii(r.byteAt(i + rLo))) continue;
            return false;
        }
        return true;
    }

    private static StringSink getThreadLocalSink() {
        StringSink b = tlSink.get();
        b.clear();
        return b;
    }

    private static boolean isMalformed3(int b1, int b2, int b3) {
        return b1 == -32 && (b2 & 0xE0) == 128 || (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128;
    }

    private static boolean isMalformed4(int b2, int b3, int b4) {
        return (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128 || (b4 & 0xC0) != 128;
    }

    private static boolean isNotContinuation(int b) {
        return (b & 0xC0) != 128;
    }

    private static void put2BytesSafe(byte b1, @NotNull Utf8Sink sink, byte b2) {
        if (Utf8s.isNotContinuation(b2)) {
            Utf8s.putNonAsciiAsHex(sink, b1);
            Utf8s.putNonAsciiAsHex(sink, b2);
            return;
        }
        sink.put(b1);
        sink.put(b2);
    }

    private static int put3BytesSafe(byte b1, byte b2, byte b3, @NotNull Utf8Sink sink) {
        if (!Utf8s.isMalformed3(b1, b2, b3)) {
            char c = Utf8s.utf8ToChar(b1, b2, b3);
            if (!Character.isSurrogate(c)) {
                sink.put(b1);
                sink.put(b2);
                sink.put(b3);
            }
        } else {
            Utf8s.putNonAsciiAsHex(sink, b1);
            Utf8s.putNonAsciiAsHex(sink, b2);
            Utf8s.putNonAsciiAsHex(sink, b3);
        }
        return 3;
    }

    private static void put4ByteSafe(byte b1, byte b2, byte b3, byte b4, @NotNull Utf8Sink sink) {
        int codePoint;
        if (!Utf8s.isMalformed4(b2, b3, b4) && Character.isSupplementaryCodePoint(codePoint = Utf8s.getUtf8Codepoint(b1, b2, b3, b4))) {
            sink.put(Character.highSurrogate(codePoint));
            sink.put(Character.lowSurrogate(codePoint));
            return;
        }
        Utf8s.putNonAsciiAsHex(sink, b1);
        Utf8s.putNonAsciiAsHex(sink, b2);
        Utf8s.putNonAsciiAsHex(sink, b3);
        Utf8s.putNonAsciiAsHex(sink, b4);
    }

    private static int putInvalidBytes(long lo, long hi, byte b, @NotNull Utf8Sink sink) {
        Utf8s.putNonAsciiAsHex(sink, b);
        int i = 1;
        while (lo + (long)i < hi) {
            byte val = Unsafe.getUnsafe().getByte(lo + (long)i);
            if (val >= 0) {
                --i;
                break;
            }
            Utf8s.putNonAsciiAsHex(sink, val);
            ++i;
        }
        return i + 1;
    }

    private static int putInvalidBytes(@NotNull Utf8Sequence source, int lo, int hi, byte b, @NotNull Utf8Sink sink) {
        Utf8s.putNonAsciiAsHex(sink, b);
        int i = 1;
        while (lo + i < hi) {
            byte val = source.byteAt(lo + i);
            if (val >= 0) {
                --i;
                break;
            }
            Utf8s.putNonAsciiAsHex(sink, val);
            ++i;
        }
        return i + 1;
    }

    private static int putMultibyteSafe(long lo, long hi, byte b, @NotNull Utf8Sink sink) {
        if (b >> 5 == -2 && (b & 0x1E) != 0) {
            return Utf8s.putUpTo2BytesSafe(lo, hi, b, sink);
        }
        if (b >> 4 == -2) {
            return Utf8s.putUpTo3BytesSafe(lo, hi, b, sink);
        }
        if (b >> 3 == -2) {
            return Utf8s.putUpTo4BytesSafe(lo, hi, b, sink);
        }
        return Utf8s.putInvalidBytes(lo, hi, b, sink);
    }

    private static int putMultibyteSafe(@NotNull Utf8Sequence source, int lo, int hi, byte b, @NotNull Utf8Sink sink) {
        if (b >> 5 == -2 && (b & 0x1E) != 0) {
            return Utf8s.putUpTo2BytesSafe(source, lo, hi, b, sink);
        }
        if (b >> 4 == -2) {
            return Utf8s.putUpTo3BytesSafe(source, lo, hi, b, sink);
        }
        if (b >> 3 == -2) {
            return Utf8s.putUpTo4BytesSafe(source, lo, hi, b, sink);
        }
        return Utf8s.putInvalidBytes(source, lo, hi, b, sink);
    }

    private static void putNonAsciiAsHex(@NotNull Utf8Sink sink, byte b) {
        if (b >= 32 && b < 127) {
            sink.putAny(b);
            return;
        }
        sink.putAny((byte)92);
        sink.putAny((byte)120);
        sink.put(HEX_CHARS[(b & 0xFF) >>> 4]);
        sink.put(HEX_CHARS[b & 0xF]);
    }

    private static int putUpTo2BytesSafe(long lo, long hi, byte b1, @NotNull Utf8Sink sink) {
        if (hi - lo >= 2L) {
            byte b2 = Unsafe.getUnsafe().getByte(lo + 1L);
            Utf8s.put2BytesSafe(b1, sink, b2);
            return 2;
        }
        Utf8s.putNonAsciiAsHex(sink, b1);
        return 1;
    }

    private static int putUpTo2BytesSafe(@NotNull Utf8Sequence source, int lo, int hi, byte b1, @NotNull Utf8Sink sink) {
        if (hi - lo >= 2) {
            byte b2 = source.byteAt(lo + 1);
            Utf8s.put2BytesSafe(b1, sink, b2);
            return 2;
        }
        Utf8s.putNonAsciiAsHex(sink, b1);
        return 1;
    }

    private static int putUpTo3BytesSafe(long lo, long hi, byte b1, @NotNull Utf8Sink sink) {
        if (hi - lo >= 3L) {
            byte b2 = Unsafe.getUnsafe().getByte(lo + 1L);
            byte b3 = Unsafe.getUnsafe().getByte(lo + 2L);
            return Utf8s.put3BytesSafe(b1, b2, b3, sink);
        }
        Utf8s.putNonAsciiAsHex(sink, b1);
        if (hi - lo > 1L) {
            Utf8s.putNonAsciiAsHex(sink, Unsafe.getUnsafe().getByte(lo + 1L));
            return 2;
        }
        return 1;
    }

    private static int putUpTo3BytesSafe(@NotNull Utf8Sequence source, int lo, int hi, byte b1, @NotNull Utf8Sink sink) {
        if (hi - lo >= 3) {
            byte b2 = source.byteAt(lo + 1);
            byte b3 = source.byteAt(lo + 2);
            return Utf8s.put3BytesSafe(b1, b2, b3, sink);
        }
        Utf8s.putNonAsciiAsHex(sink, b1);
        if (hi - lo > 1) {
            Utf8s.putNonAsciiAsHex(sink, source.byteAt(lo + 1));
            return 2;
        }
        return 1;
    }

    private static int putUpTo4BytesSafe(long lo, long hi, byte b, @NotNull Utf8Sink sink) {
        if (hi - lo >= 4L) {
            byte b2 = Unsafe.getUnsafe().getByte(lo + 1L);
            byte b3 = Unsafe.getUnsafe().getByte(lo + 2L);
            byte b4 = Unsafe.getUnsafe().getByte(lo + 3L);
            Utf8s.put4ByteSafe(b, b2, b3, b4, sink);
            return 4;
        }
        Utf8s.putNonAsciiAsHex(sink, b);
        if (hi - lo > 1L) {
            Utf8s.putNonAsciiAsHex(sink, Unsafe.getUnsafe().getByte(lo + 1L));
            if (hi - lo > 2L) {
                Utf8s.putNonAsciiAsHex(sink, Unsafe.getUnsafe().getByte(lo + 2L));
                if (hi - lo > 3L) {
                    Utf8s.putNonAsciiAsHex(sink, Unsafe.getUnsafe().getByte(lo + 3L));
                    return 4;
                }
                return 3;
            }
            return 2;
        }
        return 1;
    }

    private static int putUpTo4BytesSafe(@NotNull Utf8Sequence source, int lo, int hi, byte b, @NotNull Utf8Sink sink) {
        if (hi - lo >= 4) {
            byte b2 = source.byteAt(lo + 1);
            byte b3 = source.byteAt(lo + 2);
            byte b4 = source.byteAt(lo + 3);
            Utf8s.put4ByteSafe(b, b2, b3, b4, sink);
            return 4;
        }
        Utf8s.putNonAsciiAsHex(sink, b);
        if (hi - lo > 1) {
            Utf8s.putNonAsciiAsHex(sink, source.byteAt(lo + 1));
            if (hi - lo > 2) {
                Utf8s.putNonAsciiAsHex(sink, source.byteAt(lo + 2));
                if (hi - lo > 3) {
                    Utf8s.putNonAsciiAsHex(sink, source.byteAt(lo + 3));
                    return 4;
                }
                return 3;
            }
            return 2;
        }
        return 1;
    }

    private static int strCpyNonAscii(@NotNull Utf8Sequence seq, int charLo, int charHi, @NotNull Utf8Sink sink) {
        int bytesCopied = 0;
        int i = 0;
        int hi = seq.size();
        for (int charPos = 0; i < hi && charPos < charHi; ++charPos) {
            byte b = seq.byteAt(i);
            if (b < 0) {
                int n = Utf8s.validateUtf8MultiByte(seq, i, b);
                if (n == -1) {
                    return -1;
                }
                if (charPos >= charLo) {
                    sink.put(b);
                    for (int j = 1; j < n; ++j) {
                        sink.put(seq.byteAt(i + j));
                    }
                    bytesCopied += n;
                }
                i += n;
                continue;
            }
            if (charPos >= charLo) {
                sink.putAscii((char)b);
                ++bytesCopied;
            }
            ++i;
        }
        return bytesCopied;
    }

    private static byte toLowerCaseAscii(byte b) {
        return b > 64 && b < 91 ? (byte)(b + 32) : b;
    }

    private static int utf16Equals(CharSequence c, int ci, int cn, Utf8Sequence u, int ui, int un) {
        byte b = u.byteAt(ui);
        if ((b & 0x80) == 0) {
            return c.charAt(ci) == b ? 1 : -1;
        }
        if ((b & 0xE0) == 192) {
            return Utf8s.utf16Equals2Bytes(c, ci, cn, b, u, ui + 1, un);
        }
        if ((b & 0xF0) == 224) {
            return Utf8s.utf16Equals3Bytes(c, ci, cn, b, u, ui + 1, un);
        }
        return Utf8s.utf16Equals4Bytes(c, ci, cn, b, u, ui + 1, un);
    }

    private static int utf16Equals2Bytes(CharSequence c, int ci, int cn, byte b1, Utf8Sequence u, int ui, int un) {
        if (ui < un && ci < cn) {
            byte b2 = u.byteAt(ui);
            char c1 = (char)(b1 << 6 ^ b2 ^ 0xF80);
            return c.charAt(ci) == c1 ? 2 : -1;
        }
        return -1;
    }

    private static int utf16Equals3Bytes(CharSequence c, int ci, int cn, byte b1, Utf8Sequence u, int ui, int un) {
        if (ui + 1 < un && ci < cn) {
            byte b2 = u.byteAt(ui++);
            byte b3 = u.byteAt(ui);
            char c1 = Utf8s.utf8ToChar(b1, b2, b3);
            return c.charAt(ci) == c1 ? 3 : -1;
        }
        return -1;
    }

    private static int utf16Equals4Bytes(CharSequence c, int ci, int cn, byte b1, Utf8Sequence u, int ui, int un) {
        if (ui + 2 < un && ci + 1 < cn) {
            byte b4;
            byte b3;
            byte b2;
            if (Utf8s.isMalformed4(b2 = u.byteAt(ui++), b3 = u.byteAt(ui++), b4 = u.byteAt(ui))) {
                return -1;
            }
            int codePoint = Utf8s.getUtf8Codepoint(b1, b2, b3, b4);
            char c1 = c.charAt(ci++);
            char c2 = c.charAt(ci);
            if (Character.isSupplementaryCodePoint(codePoint)) {
                return c1 == Character.highSurrogate(codePoint) && c2 == Character.lowSurrogate(codePoint) ? 4 : -1;
            }
        }
        return -1;
    }

    private static int utf8Decode2Bytes(@NotNull Utf8Sequence seq, int index, int b1, @NotNull Utf16Sink sink) {
        if (seq.size() - index < 2) {
            return -1;
        }
        byte b2 = seq.byteAt(index + 1);
        if (Utf8s.isNotContinuation(b2)) {
            return -1;
        }
        sink.put((char)(b1 << 6 ^ b2 ^ 0xF80));
        return 2;
    }

    private static int utf8Decode2Bytes(long lo, long hi, int b1, @NotNull Utf16Sink sink) {
        if (hi - lo < 2L) {
            return -1;
        }
        byte b2 = Unsafe.getUnsafe().getByte(lo + 1L);
        if (Utf8s.isNotContinuation(b2)) {
            return -1;
        }
        sink.put((char)(b1 << 6 ^ b2 ^ 0xF80));
        return 2;
    }

    private static int utf8Decode2BytesZ(long lo, int b1, @NotNull Utf16Sink sink) {
        byte b2 = Unsafe.getUnsafe().getByte(lo + 1L);
        if (b2 == 0) {
            return -1;
        }
        if (Utf8s.isNotContinuation(b2)) {
            return -1;
        }
        sink.put((char)(b1 << 6 ^ b2 ^ 0xF80));
        return 2;
    }

    private static int utf8Decode3Byte0(byte b1, @NotNull Utf16Sink sink, byte b2, byte b3) {
        if (Utf8s.isMalformed3(b1, b2, b3)) {
            return -1;
        }
        char c = Utf8s.utf8ToChar(b1, b2, b3);
        if (Character.isSurrogate(c)) {
            return -1;
        }
        sink.put(c);
        return 3;
    }

    private static int utf8Decode3Bytes(long lo, long hi, byte b1, @NotNull Utf16Sink sink) {
        if (hi - lo < 3L) {
            return -1;
        }
        byte b2 = Unsafe.getUnsafe().getByte(lo + 1L);
        byte b3 = Unsafe.getUnsafe().getByte(lo + 2L);
        return Utf8s.utf8Decode3Byte0(b1, sink, b2, b3);
    }

    private static int utf8Decode3Bytes(@NotNull Utf8Sequence seq, int index, byte b1, @NotNull Utf16Sink sink) {
        if (seq.size() - index < 3) {
            return -1;
        }
        byte b2 = seq.byteAt(index + 1);
        byte b3 = seq.byteAt(index + 2);
        return Utf8s.utf8Decode3Byte0(b1, sink, b2, b3);
    }

    private static int utf8Decode3BytesZ(long lo, byte b1, @NotNull Utf16Sink sink) {
        byte b2 = Unsafe.getUnsafe().getByte(lo + 1L);
        if (b2 == 0) {
            return -1;
        }
        byte b3 = Unsafe.getUnsafe().getByte(lo + 2L);
        if (b3 == 0) {
            return -1;
        }
        return Utf8s.utf8Decode3Byte0(b1, sink, b2, b3);
    }

    private static int utf8Decode4Bytes(long lo, long hi, int b, @NotNull Utf16Sink sink) {
        if (b >> 3 != -2 || hi - lo < 4L) {
            return -1;
        }
        byte b2 = Unsafe.getUnsafe().getByte(lo + 1L);
        byte b3 = Unsafe.getUnsafe().getByte(lo + 2L);
        byte b4 = Unsafe.getUnsafe().getByte(lo + 3L);
        return Utf8s.utf8Decode4Bytes0(b, sink, b2, b3, b4);
    }

    private static int utf8Decode4Bytes(@NotNull Utf8Sequence seq, int index, int b, @NotNull Utf16Sink sink) {
        if (b >> 3 != -2 || seq.size() - index < 4) {
            return -1;
        }
        byte b2 = seq.byteAt(index + 1);
        byte b3 = seq.byteAt(index + 2);
        byte b4 = seq.byteAt(index + 3);
        return Utf8s.utf8Decode4Bytes0(b, sink, b2, b3, b4);
    }

    private static int utf8Decode4Bytes0(int b, @NotNull Utf16Sink sink, byte b2, byte b3, byte b4) {
        if (Utf8s.isMalformed4(b2, b3, b4)) {
            return -1;
        }
        int codePoint = Utf8s.getUtf8Codepoint(b, b2, b3, b4);
        if (Character.isSupplementaryCodePoint(codePoint)) {
            sink.put(Character.highSurrogate(codePoint));
            sink.put(Character.lowSurrogate(codePoint));
            return 4;
        }
        return -1;
    }

    private static int utf8Decode4BytesZ(long lo, int b, Utf16Sink sink) {
        if (b >> 3 != -2) {
            return -1;
        }
        byte b2 = Unsafe.getUnsafe().getByte(lo + 1L);
        if (b2 == 0) {
            return -1;
        }
        byte b3 = Unsafe.getUnsafe().getByte(lo + 2L);
        if (b3 == 0) {
            return -1;
        }
        byte b4 = Unsafe.getUnsafe().getByte(lo + 3L);
        if (b4 == 0) {
            return -1;
        }
        return Utf8s.utf8Decode4Bytes0(b, sink, b2, b3, b4);
    }

    private static int utf8DecodeMultiByte(Utf8Sequence seq, int index, byte b, @NotNull Utf16Sink sink) {
        if (b >> 5 == -2 && (b & 0x1E) != 0) {
            return Utf8s.utf8Decode2Bytes(seq, index, (int)b, sink);
        }
        if (b >> 4 == -2) {
            return Utf8s.utf8Decode3Bytes(seq, index, b, sink);
        }
        return Utf8s.utf8Decode4Bytes(seq, index, (int)b, sink);
    }

    private static int utf8DecodeMultiByteZ(long lo, byte b, @NotNull Utf16Sink sink) {
        if (b >> 5 == -2 && (b & 0x1E) != 0) {
            return Utf8s.utf8Decode2BytesZ(lo, b, sink);
        }
        if (b >> 4 == -2) {
            return Utf8s.utf8Decode3BytesZ(lo, b, sink);
        }
        return Utf8s.utf8Decode4BytesZ(lo, b, sink);
    }

    private static int validateUtf8Decode2Bytes(@NotNull Utf8Sequence seq, int index) {
        if (seq.size() - index < 2) {
            return -1;
        }
        byte b2 = seq.byteAt(index + 1);
        if (Utf8s.isNotContinuation(b2)) {
            return -1;
        }
        return 2;
    }

    private static int validateUtf8Decode2Bytes(long lo, long hi) {
        if (hi - lo < 2L) {
            return -1;
        }
        byte b2 = Unsafe.getUnsafe().getByte(lo + 1L);
        if (Utf8s.isNotContinuation(b2)) {
            return -1;
        }
        return 2;
    }

    private static int validateUtf8Decode3Bytes(long lo, long hi, byte b1) {
        byte b3;
        if (hi - lo < 3L) {
            return -1;
        }
        byte b2 = Unsafe.getUnsafe().getByte(lo + 1L);
        if (Utf8s.isMalformed3(b1, b2, b3 = Unsafe.getUnsafe().getByte(lo + 2L))) {
            return -1;
        }
        char c = Utf8s.utf8ToChar(b1, b2, b3);
        if (Character.isSurrogate(c)) {
            return -1;
        }
        return 3;
    }

    private static int validateUtf8Decode3Bytes(@NotNull Utf8Sequence seq, int index, byte b1) {
        byte b3;
        if (seq.size() - index < 3) {
            return -1;
        }
        byte b2 = seq.byteAt(index + 1);
        if (Utf8s.isMalformed3(b1, b2, b3 = seq.byteAt(index + 2))) {
            return -1;
        }
        char c = Utf8s.utf8ToChar(b1, b2, b3);
        if (Character.isSurrogate(c)) {
            return -1;
        }
        return 3;
    }

    private static int validateUtf8Decode4Bytes(long lo, long hi, int b) {
        byte b4;
        byte b3;
        if (b >> 3 != -2 || hi - lo < 4L) {
            return -1;
        }
        byte b2 = Unsafe.getUnsafe().getByte(lo + 1L);
        if (Utf8s.isMalformed4(b2, b3 = Unsafe.getUnsafe().getByte(lo + 2L), b4 = Unsafe.getUnsafe().getByte(lo + 3L))) {
            return -1;
        }
        int codePoint = Utf8s.getUtf8Codepoint(b, b2, b3, b4);
        if (!Character.isSupplementaryCodePoint(codePoint)) {
            return -1;
        }
        return 4;
    }

    private static int validateUtf8Decode4Bytes(@NotNull Utf8Sequence seq, int index, int b) {
        byte b4;
        byte b3;
        if (b >> 3 != -2 || seq.size() - index < 4) {
            return -1;
        }
        byte b2 = seq.byteAt(index + 1);
        if (Utf8s.isMalformed4(b2, b3 = seq.byteAt(index + 2), b4 = seq.byteAt(index + 3))) {
            return -1;
        }
        int codePoint = Utf8s.getUtf8Codepoint(b, b2, b3, b4);
        if (!Character.isSupplementaryCodePoint(codePoint)) {
            return -1;
        }
        return 4;
    }

    private static int validateUtf8MultiByte(Utf8Sequence seq, int index, byte b) {
        if (b >> 5 == -2 && (b & 0x1E) != 0) {
            return Utf8s.validateUtf8Decode2Bytes(seq, index);
        }
        if (b >> 4 == -2) {
            return Utf8s.validateUtf8Decode3Bytes(seq, index, b);
        }
        return Utf8s.validateUtf8Decode4Bytes(seq, index, (int)b);
    }
}

