/*
 * Decompiled with CFR 0.152.
 */
package com.obs.log;

import com.obs.log.AbstractLog4jLogger;
import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.log.LoggerMethodHolder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Logger;

public class Log4jLogger
extends AbstractLog4jLogger
implements ILogger {
    private static final Logger ILOG = Logger.getLogger(Log4jLogger.class.getName());

    Log4jLogger(Object logger) {
        super(logger);
    }

    @Override
    public boolean isInfoEnabled() {
        try {
            return this.logger != null && Log4jLoggerMethodHolder.infoLevel != null && (Boolean)Log4jLoggerMethodHolder.isEnabledFor.invoke(this.logger, Log4jLoggerMethodHolder.infoLevel) != false;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return false;
        }
    }

    @Override
    public boolean isWarnEnabled() {
        try {
            return this.logger != null && Log4jLoggerMethodHolder.warnLevel != null && (Boolean)Log4jLoggerMethodHolder.isEnabledFor.invoke(this.logger, Log4jLoggerMethodHolder.warnLevel) != false;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return false;
        }
    }

    @Override
    public boolean isErrorEnabled() {
        try {
            return this.logger != null && Log4jLoggerMethodHolder.errorLevel != null && (Boolean)Log4jLoggerMethodHolder.isEnabledFor.invoke(this.logger, Log4jLoggerMethodHolder.errorLevel) != false;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return false;
        }
    }

    @Override
    public boolean isDebugEnabled() {
        try {
            return this.logger != null && Log4jLoggerMethodHolder.debugLevel != null && (Boolean)Log4jLoggerMethodHolder.isEnabledFor.invoke(this.logger, Log4jLoggerMethodHolder.debugLevel) != false;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return false;
        }
    }

    @Override
    public boolean isTraceEnabled() {
        try {
            return this.logger != null && Log4jLoggerMethodHolder.traceLevel != null && (Boolean)Log4jLoggerMethodHolder.isEnabledFor.invoke(this.logger, Log4jLoggerMethodHolder.traceLevel) != false;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return false;
        }
    }

    private static class Log4jLoggerMethodHolder
    extends LoggerMethodHolder {
        private static Method isEnabledFor;
        private static Class<?> priority;
        private static Class<?> level;
        private static Object infoLevel;
        private static Object debugLevel;
        private static Object errorLevel;
        private static Object warnLevel;
        private static Object traceLevel;

        private Log4jLoggerMethodHolder() {
        }

        static {
            try {
                if (LoggerBuilder.GetLoggerHolder.loggerClass != null) {
                    priority = Class.forName("org.apache.log4j.Priority");
                    isEnabledFor = LoggerBuilder.GetLoggerHolder.loggerClass.getMethod("isEnabledFor", priority);
                    level = Class.forName("org.apache.log4j.Level");
                    infoLevel = level.getField("INFO").get(level);
                    debugLevel = level.getField("DEBUG").get(level);
                    errorLevel = level.getField("ERROR").get(level);
                    warnLevel = level.getField("WARN").get(level);
                    traceLevel = level.getField("TRACE").get(level);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException e) {
                ILOG.warning(e.getMessage());
            }
        }
    }
}

