/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.concurrency.limits.limit.window;

import com.netflix.concurrency.limits.limit.window.SampleWindow;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongArray;

class ImmutablePercentileSampleWindow
implements SampleWindow {
    private final long minRtt;
    private final int maxInFlight;
    private final boolean didDrop;
    private final AtomicLongArray observedRtts;
    private final int sampleCount;
    private final double percentile;

    ImmutablePercentileSampleWindow(double percentile, int windowSize) {
        this.minRtt = Long.MAX_VALUE;
        this.maxInFlight = 0;
        this.didDrop = false;
        this.observedRtts = new AtomicLongArray(windowSize);
        this.sampleCount = 0;
        this.percentile = percentile;
    }

    private ImmutablePercentileSampleWindow(long minRtt, int maxInFlight, boolean didDrop, AtomicLongArray observedRtts, int sampleCount, double percentile) {
        this.minRtt = minRtt;
        this.maxInFlight = maxInFlight;
        this.didDrop = didDrop;
        this.observedRtts = observedRtts;
        this.sampleCount = sampleCount;
        this.percentile = percentile;
    }

    @Override
    public ImmutablePercentileSampleWindow addSample(long rtt, int inflight, boolean didDrop) {
        if (this.sampleCount >= this.observedRtts.length()) {
            return this;
        }
        this.observedRtts.set(this.sampleCount, rtt);
        return new ImmutablePercentileSampleWindow(Math.min(this.minRtt, rtt), Math.max(inflight, this.maxInFlight), this.didDrop || didDrop, this.observedRtts, this.sampleCount + 1, this.percentile);
    }

    @Override
    public long getCandidateRttNanos() {
        return this.minRtt;
    }

    @Override
    public long getTrackedRttNanos() {
        if (this.sampleCount == 0) {
            return 0L;
        }
        long[] copyOfObservedRtts = new long[this.sampleCount];
        for (int i = 0; i < this.sampleCount; ++i) {
            copyOfObservedRtts[i] = this.observedRtts.get(i);
        }
        Arrays.sort(copyOfObservedRtts);
        int rttIndex = (int)Math.round((double)this.sampleCount * this.percentile);
        int zeroBasedRttIndex = rttIndex - 1;
        return copyOfObservedRtts[zeroBasedRttIndex];
    }

    @Override
    public int getMaxInFlight() {
        return this.maxInFlight;
    }

    @Override
    public int getSampleCount() {
        return this.sampleCount;
    }

    @Override
    public boolean didDrop() {
        return this.didDrop;
    }

    public String toString() {
        return "ImmutablePercentileSampleWindow [minRtt=" + (double)TimeUnit.NANOSECONDS.toMicros(this.minRtt) / 1000.0 + ", p" + this.percentile + " rtt=" + (double)TimeUnit.NANOSECONDS.toMicros(this.getTrackedRttNanos()) / 1000.0 + ", maxInFlight=" + this.maxInFlight + ", sampleCount=" + this.sampleCount + ", didDrop=" + this.didDrop + "]";
    }
}

