/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.validation.constraints.NotNull;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.apache.hertzbeat.common.util.CommonUtil;
import org.apache.hertzbeat.common.util.ResponseUtil;
import org.apache.hertzbeat.manager.pojo.dto.TemplateConfig;
import org.apache.hertzbeat.manager.service.ConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/config"}, produces={"application/json"})
@Tag(name="Generate Configuration API")
public class GeneralConfigController {
    private static final Logger log = LoggerFactory.getLogger(GeneralConfigController.class);
    private static final Set<String> ZONE_IDS = ZoneId.getAvailableZoneIds();
    @Resource
    private ConfigService configService;

    @PostMapping(path={"/{type}"})
    @Operation(summary="Save or update common config", description="Save or update common config")
    public ResponseEntity<Message<String>> saveOrUpdateConfig(@Parameter(description="Config Type", example="email") @PathVariable(value="type") @NotNull String type, @RequestBody Object config) {
        this.configService.saveConfig(type, config);
        return ResponseEntity.ok((Object)Message.success((String)"Update config success"));
    }

    @GetMapping(path={"/{type}"})
    @Operation(summary="Get the sender config", description="Get the sender config")
    public ResponseEntity<Message<Object>> getConfig(@Parameter(description="Config Type", example="email") @PathVariable(value="type") @NotNull String type) {
        return ResponseUtil.handle(() -> this.configService.getConfig(type));
    }

    @PutMapping(path={"/template/{app}"})
    @Operation(summary="Update the app template config")
    public ResponseEntity<Message<Void>> updateTemplateAppConfig(@PathVariable(value="app") @NotNull String app, @RequestBody TemplateConfig.AppTemplate template) {
        return ResponseUtil.handle(() -> this.configService.updateTemplateAppConfig(app, template));
    }

    @GetMapping(path={"/timezones"})
    @Operation(summary="Get all available timezones and their current UTC offset", description="Get all available timezones and their current UTC offset")
    public ResponseEntity<Message<List<Map<String, String>>>> getTimezones() {
        List timezones = ZONE_IDS.stream().map(id -> {
            try {
                ZoneId zoneId = ZoneId.of(id);
                ZonedDateTime now = ZonedDateTime.now(zoneId);
                int totalSeconds = now.getOffset().getTotalSeconds();
                String offset = String.format("UTC%+03d:%02d", totalSeconds / 3600, Math.abs(totalSeconds / 60 % 60));
                String displayName = zoneId.getDisplayName(TextStyle.FULL, Locale.getDefault());
                return Map.of("zoneId", id, "offset", offset, "displayName", displayName);
            }
            catch (Exception e) {
                String errorMsg = CommonUtil.getMessageFromThrowable((Throwable)e);
                log.warn("Query Timezone failed. {} ", (Object)errorMsg);
                return null;
            }
        }).filter(t -> Objects.nonNull(t) && Objects.nonNull(t.get("zoneId"))).sorted(Comparator.comparing(m -> (String)m.get("zoneId"))).collect(Collectors.toList());
        return ResponseEntity.ok((Object)Message.success(timezones));
    }
}

