/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.scheduler.netty.process;

import com.google.protobuf.ByteString;
import io.netty.channel.ChannelHandlerContext;
import java.net.InetSocketAddress;
import org.apache.commons.lang3.StringUtils;
import org.apache.hertzbeat.common.entity.dto.CollectorInfo;
import org.apache.hertzbeat.common.entity.dto.ServerInfo;
import org.apache.hertzbeat.common.entity.message.ClusterMsg;
import org.apache.hertzbeat.common.util.AesUtil;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.apache.hertzbeat.manager.scheduler.netty.ManageServer;
import org.apache.hertzbeat.remoting.netty.NettyRemotingProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectorOnlineProcessor
implements NettyRemotingProcessor {
    private static final Logger log = LoggerFactory.getLogger(CollectorOnlineProcessor.class);
    private final ManageServer manageServer;

    public CollectorOnlineProcessor(ManageServer manageServer) {
        this.manageServer = manageServer;
    }

    public ClusterMsg.Message handle(ChannelHandlerContext ctx, ClusterMsg.Message message) {
        String collector = message.getIdentity();
        log.info("the collector {} actively requests to go online.", (Object)collector);
        String msg = message.getMsg().toStringUtf8();
        CollectorInfo collectorInfo = (CollectorInfo)JsonUtil.fromJson((String)msg, CollectorInfo.class);
        if (collectorInfo != null && StringUtils.isBlank((CharSequence)collectorInfo.getIp())) {
            InetSocketAddress socketAddress = (InetSocketAddress)ctx.channel().remoteAddress();
            String clientIP = socketAddress.getAddress().getHostAddress();
            collectorInfo.setIp(clientIP);
        }
        this.manageServer.addChannel(collector, ctx.channel());
        this.manageServer.getCollectorAndJobScheduler().collectorGoOnline(collector, collectorInfo);
        ServerInfo serverInfo = ServerInfo.builder().aesSecret(AesUtil.getDefaultSecretKey()).build();
        return ClusterMsg.Message.newBuilder().setIdentity(message.getIdentity()).setDirection(ClusterMsg.Direction.RESPONSE).setMsg(ByteString.copyFromUtf8((String)JsonUtil.toJson((Object)serverInfo))).setType(ClusterMsg.MessageType.GO_ONLINE).build();
    }
}

