/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.encoding.decoder;

import java.nio.ByteBuffer;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;

public abstract class GorillaDecoderV2
extends Decoder {
    protected boolean firstValueWasRead = false;
    protected int storedLeadingZeros = Integer.MAX_VALUE;
    protected int storedTrailingZeros = 0;
    protected boolean hasNext = true;
    private byte buffer = 0;
    private int bitsLeft = 0;

    protected GorillaDecoderV2() {
        super(TSEncoding.GORILLA);
    }

    @Override
    public final boolean hasNext(ByteBuffer in) {
        return this.hasNext;
    }

    @Override
    public void reset() {
        this.firstValueWasRead = false;
        this.storedLeadingZeros = Integer.MAX_VALUE;
        this.storedTrailingZeros = 0;
        this.hasNext = true;
        this.buffer = 0;
        this.bitsLeft = 0;
    }

    protected boolean readBit(ByteBuffer in) {
        boolean bit = (this.buffer >> this.bitsLeft - 1 & 1) == 1;
        --this.bitsLeft;
        this.flipByte(in);
        return bit;
    }

    protected long readLong(int bits, ByteBuffer in) {
        long value = 0L;
        while (bits > 0) {
            byte d;
            if (bits > this.bitsLeft || bits == 8) {
                d = (byte)(this.buffer & (1 << this.bitsLeft) - 1);
                value = (value << this.bitsLeft) + (long)(d & 0xFF);
                bits -= this.bitsLeft;
                this.bitsLeft = 0;
            } else {
                d = (byte)(this.buffer >>> this.bitsLeft - bits & (1 << bits) - 1);
                value = (value << bits) + (long)(d & 0xFF);
                this.bitsLeft -= bits;
                bits = 0;
            }
            this.flipByte(in);
        }
        return value;
    }

    protected byte readNextClearBit(int maxBits, ByteBuffer in) {
        byte value = 0;
        for (int i = 0; i < maxBits; ++i) {
            value = (byte)(value << 1);
            if (!this.readBit(in)) break;
            value = (byte)(value | 1);
        }
        return value;
    }

    protected void flipByte(ByteBuffer in) {
        if (this.bitsLeft == 0) {
            this.buffer = in.get();
            this.bitsLeft = 8;
        }
    }
}

