/*
 * Decompiled with CFR 0.152.
 */
package com.usthe.sureness.matcher;

import com.usthe.sureness.matcher.PathTreeProvider;
import com.usthe.sureness.matcher.TreePathRoleMatcher;
import com.usthe.sureness.matcher.util.TirePathTree;
import com.usthe.sureness.mgt.SurenessNoInitException;
import com.usthe.sureness.subject.Subject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPathRoleMatcher
implements TreePathRoleMatcher {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPathRoleMatcher.class);
    private static final String LEFT_CON = "[";
    private static final String RIGHT_CON = "]";
    private static final String NULL_ROLE = "[]";
    private static final String EXCLUDE_ROLE = "exclude";
    private final TirePathTree root = new TirePathTree();
    private final TirePathTree excludeRoot = new TirePathTree();
    private List<PathTreeProvider> pathTreeProviderList;
    private volatile boolean isTreeInit;

    @Override
    public void matchRole(Subject subject) {
        if (!this.isTreeInit) {
            logger.error("DefaultPathRoleMatcher -> root tree is not init");
            throw new SurenessNoInitException("DefaultPathRoleMatcher -> root tree is not init");
        }
        String targetResource = (String)subject.getTargetResource();
        String matchRoleString = this.root.searchPathFilterRoles(targetResource);
        if (Objects.nonNull(matchRoleString) && matchRoleString.startsWith(LEFT_CON) && matchRoleString.endsWith(RIGHT_CON)) {
            if (NULL_ROLE.equals(matchRoleString)) {
                subject.setSupportRoles(new ArrayList(0));
            } else {
                String[] roles = matchRoleString.substring(1, matchRoleString.length() - 1).split(",");
                subject.setSupportRoles(Arrays.asList(roles));
            }
        }
    }

    @Override
    public void buildTree() {
        this.isTreeInit = false;
        this.checkComponentInit();
        HashSet<String> resources = new HashSet<String>();
        Set<String> excludeResources = new HashSet<String>();
        this.iterateOverPathTreeProviderList(resources, excludeResources);
        this.root.buildTree(resources);
        excludeResources = excludeResources.stream().map(resource -> resource.concat("===").concat(EXCLUDE_ROLE).toLowerCase()).collect(Collectors.toSet());
        this.excludeRoot.buildTree(excludeResources);
        this.isTreeInit = true;
    }

    @Override
    public void rebuildTree() {
        this.checkComponentInit();
        HashSet<String> resources = new HashSet<String>();
        Set<String> excludeResources = new HashSet<String>();
        this.iterateOverPathTreeProviderList(resources, excludeResources);
        this.root.rebuildTree(resources);
        excludeResources = excludeResources.stream().map(resource -> resource.concat("===").concat(EXCLUDE_ROLE).toLowerCase()).collect(Collectors.toSet());
        this.excludeRoot.rebuildTree(excludeResources);
    }

    @Override
    public boolean isExcludedResource(Subject request) {
        this.checkComponentInit();
        String exclude = this.excludeRoot.searchPathFilterRoles((String)request.getTargetResource());
        return Objects.nonNull(exclude) && exclude.equals(EXCLUDE_ROLE);
    }

    private void checkComponentInit() {
        if (Objects.isNull(this.pathTreeProviderList)) {
            throw new SurenessNoInitException("DefaultPathRoleMatcher init error : component init not complete");
        }
    }

    private void clearTree() {
        this.root.clearTree();
        this.excludeRoot.clearTree();
    }

    public void setPathTreeProvider(PathTreeProvider pathTreeProvider) {
        if (Objects.isNull(this.pathTreeProviderList)) {
            this.pathTreeProviderList = new LinkedList<PathTreeProvider>();
        }
        this.pathTreeProviderList.add(pathTreeProvider);
    }

    public void setPathTreeProviderList(List<PathTreeProvider> providerList) {
        this.pathTreeProviderList = providerList;
    }

    public DefaultPathRoleMatcher addPathTreeProvider(PathTreeProvider pathTreeProvider) {
        if (this.pathTreeProviderList == null) {
            this.pathTreeProviderList = new LinkedList<PathTreeProvider>();
        }
        this.pathTreeProviderList.add(pathTreeProvider);
        return this;
    }

    private void iterateOverPathTreeProviderList(Set<String> resources, Set<String> excludeResources) {
        for (PathTreeProvider provider : this.pathTreeProviderList) {
            Set<String> resourceTmp = provider.providePathData();
            Set<String> excludeResourceTmp = provider.provideExcludedResource();
            if (Objects.nonNull(resourceTmp)) {
                resources.addAll(resourceTmp);
            } else {
                logger.warn("sureness - pathTreeProvider: {} providePathData is null", (Object)provider);
            }
            if (Objects.nonNull(excludeResourceTmp)) {
                excludeResources.addAll(excludeResourceTmp);
                continue;
            }
            logger.warn("sureness - pathTreeProvider: {} provideExcludedResource is null", (Object)provider);
        }
    }
}

