/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.optimizer.AbstractBucketJoinProc;
import org.apache.hadoop.hive.ql.optimizer.BucketJoinProcCtx;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;

public class BucketMapjoinProc
extends AbstractBucketJoinProc
implements SemanticNodeProcessor {
    public BucketMapjoinProc(ParseContext pGraphContext) {
        super(pGraphContext);
    }

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
        BucketJoinProcCtx context = (BucketJoinProcCtx)procCtx;
        MapJoinOperator mapJoinOperator = (MapJoinOperator)nd;
        boolean convert = this.canConvertMapJoinToBucketMapJoin(mapJoinOperator, context);
        HiveConf conf = context.getConf();
        if (!convert && conf.getBoolVar(HiveConf.ConfVars.HIVE_ENFORCE_BUCKET_MAPJOIN)) {
            throw new SemanticException(ErrorMsg.BUCKET_MAPJOIN_NOT_POSSIBLE.getMsg());
        }
        if (convert) {
            this.convertMapJoinToBucketMapJoin(mapJoinOperator, context);
        }
        return null;
    }

    public static void checkAndConvertBucketMapJoin(ParseContext pGraphContext, MapJoinOperator mapJoinOp, String baseBigAlias, List<String> joinAliases) throws SemanticException {
        BucketJoinProcCtx ctx = new BucketJoinProcCtx(pGraphContext.getConf());
        BucketMapjoinProc proc = new BucketMapjoinProc(pGraphContext);
        Map<Byte, List<ExprNodeDesc>> keysMap = ((MapJoinDesc)mapJoinOp.getConf()).getKeys();
        if (proc.checkConvertBucketMapJoin(ctx, ((MapJoinDesc)mapJoinOp.getConf()).getAliasToOpInfo(), keysMap, baseBigAlias, joinAliases)) {
            proc.convertMapJoinToBucketMapJoin(mapJoinOp, ctx);
        }
    }
}

