/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.pcr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.ExpressionWalker;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.lib.SemanticRule;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.ConstantPropagateProcFactory;
import org.apache.hadoop.hive.ql.optimizer.pcr.PcrExprProcCtx;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartExprEvalUtils;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDynamicListDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFStruct;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PcrExprProcFactory {
    public static final Logger LOG = LoggerFactory.getLogger((String)PcrExprProcFactory.class.getName());

    static Object evalExprWithPart(ExprNodeDesc expr, Partition p) throws SemanticException {
        try {
            return PartExprEvalUtils.evalExprWithPart(expr, p);
        }
        catch (HiveException e) {
            throw new SemanticException((Throwable)e);
        }
    }

    static Boolean ifResultsAgree(Boolean[] resultVector) {
        Boolean result = null;
        for (Boolean b : resultVector) {
            if (b == null) {
                return null;
            }
            if (result == null) {
                result = b;
                continue;
            }
            if (result.equals(b)) continue;
            return null;
        }
        return result;
    }

    static Object ifResultsAgree(Object[] resultVector) {
        Object result = null;
        for (Object b : resultVector) {
            if (b == null) {
                return null;
            }
            if (result == null) {
                result = b;
                continue;
            }
            if (result.equals(b)) continue;
            return null;
        }
        return result;
    }

    static NodeInfoWrapper getResultWrapFromResults(Boolean[] results, ExprNodeGenericFuncDesc fd, Object[] nodeOutputs) {
        Boolean ifAgree = PcrExprProcFactory.ifResultsAgree(results);
        if (ifAgree == null) {
            return new NodeInfoWrapper(WalkState.DIVIDED, results, PcrExprProcFactory.getOutExpr(fd, nodeOutputs));
        }
        if (ifAgree.booleanValue()) {
            return new NodeInfoWrapper(WalkState.TRUE, null, new ExprNodeConstantDesc(fd.getTypeInfo(), Boolean.TRUE));
        }
        return new NodeInfoWrapper(WalkState.FALSE, null, new ExprNodeConstantDesc(fd.getTypeInfo(), Boolean.FALSE));
    }

    private PcrExprProcFactory() {
    }

    static Boolean opAnd(Boolean ... ops) {
        boolean anyNull = false;
        for (Boolean op : ops) {
            if (op == null) {
                anyNull = true;
                continue;
            }
            if (!op.equals(Boolean.FALSE)) continue;
            return Boolean.FALSE;
        }
        if (anyNull) {
            return null;
        }
        return Boolean.TRUE;
    }

    static Boolean opOr(Boolean ... ops) {
        boolean anyNull = false;
        for (Boolean op : ops) {
            if (op == null) {
                anyNull = true;
                continue;
            }
            if (!op.equals(Boolean.TRUE)) continue;
            return Boolean.TRUE;
        }
        if (anyNull) {
            return null;
        }
        return Boolean.FALSE;
    }

    static Boolean opNot(Boolean op) {
        if (op != null) {
            if (op.equals(Boolean.TRUE)) {
                return Boolean.FALSE;
            }
            if (op.equals(Boolean.FALSE)) {
                return Boolean.TRUE;
            }
        }
        return null;
    }

    public static ExprNodeGenericFuncDesc getOutExpr(ExprNodeGenericFuncDesc funcExpr, Object[] nodeOutputs) {
        ArrayList<ExprNodeDesc> children = new ArrayList<ExprNodeDesc>();
        if (nodeOutputs != null) {
            for (Object child : nodeOutputs) {
                NodeInfoWrapper wrapper = (NodeInfoWrapper)child;
                children.add(wrapper.outExpr);
            }
        }
        funcExpr.setChildren(children);
        return funcExpr;
    }

    public static SemanticNodeProcessor getDefaultExprProcessor() {
        return new DefaultExprProcessor();
    }

    public static SemanticNodeProcessor getGenericFuncProcessor() {
        return new GenericFuncExprProcessor();
    }

    public static SemanticNodeProcessor getFieldProcessor() {
        return new FieldExprProcessor();
    }

    public static SemanticNodeProcessor getColumnProcessor() {
        return new ColumnExprProcessor();
    }

    public static NodeInfoWrapper walkExprTree(String tabAlias, List<Partition> parts, List<VirtualColumn> vcs, ExprNodeDesc pred) throws SemanticException {
        PcrExprProcCtx pprCtx = new PcrExprProcCtx(tabAlias, parts, vcs);
        LinkedHashMap<SemanticRule, SemanticNodeProcessor> exprRules = new LinkedHashMap<SemanticRule, SemanticNodeProcessor>();
        exprRules.put(new RuleRegExp("R1", ExprNodeColumnDesc.class.getName() + "%"), PcrExprProcFactory.getColumnProcessor());
        exprRules.put(new RuleRegExp("R2", ExprNodeFieldDesc.class.getName() + "%"), PcrExprProcFactory.getFieldProcessor());
        exprRules.put(new RuleRegExp("R5", ExprNodeGenericFuncDesc.class.getName() + "%"), PcrExprProcFactory.getGenericFuncProcessor());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(PcrExprProcFactory.getDefaultExprProcessor(), exprRules, pprCtx);
        ExpressionWalker egw = new ExpressionWalker(disp);
        ArrayList<Node> startNodes = new ArrayList<Node>();
        startNodes.add(pred);
        HashMap<Node, Object> outputMap = new HashMap<Node, Object>();
        egw.startWalking(startNodes, outputMap);
        return (NodeInfoWrapper)outputMap.get(pred);
    }

    public static class NodeInfoWrapper {
        WalkState state;
        public Boolean[] ResultVector;
        public ExprNodeDesc outExpr;

        public NodeInfoWrapper(WalkState state, Boolean[] resultVector, ExprNodeDesc outExpr) {
            this.state = state;
            this.ResultVector = resultVector;
            this.outExpr = outExpr;
        }
    }

    public static enum WalkState {
        PART_COL,
        TRUE,
        FALSE,
        CONSTANT,
        UNKNOWN,
        DIVIDED,
        PART_COL_STRUCT;

    }

    public static class DefaultExprProcessor
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            if (nd instanceof ExprNodeConstantDesc) {
                return new NodeInfoWrapper(WalkState.CONSTANT, null, (ExprNodeDesc)nd);
            }
            return new NodeInfoWrapper(WalkState.UNKNOWN, null, (ExprNodeDesc)nd);
        }
    }

    public static class GenericFuncExprProcessor
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            PcrExprProcCtx ctx = (PcrExprProcCtx)procCtx;
            ExprNodeGenericFuncDesc fd = (ExprNodeGenericFuncDesc)nd;
            if (LOG.isDebugEnabled()) {
                String err = "Processing " + fd.getExprString() + " " + fd.getGenericUDF().getUdfName() + " outputs ";
                Object[] objectArray = nodeOutputs;
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    Object child = objectArray[i];
                    NodeInfoWrapper wrapper = (NodeInfoWrapper)child;
                    err = err + "{" + String.valueOf((Object)wrapper.state) + ", " + String.valueOf(wrapper.outExpr) + "}, ";
                }
                LOG.debug(err);
            }
            if (FunctionRegistry.isOpNot(fd)) {
                return this.handleUdfNot(ctx, fd, nodeOutputs);
            }
            if (FunctionRegistry.isOpAnd(fd)) {
                return this.handleUdfAnd(ctx, fd, nodeOutputs);
            }
            if (FunctionRegistry.isOpOr(fd)) {
                return this.handleUdfOr(ctx, fd, nodeOutputs);
            }
            if (FunctionRegistry.isIn(fd)) {
                List<ExprNodeDesc> children = fd.getChildren();
                for (int i = 1; i < children.size(); ++i) {
                    if (!(children.get(i) instanceof ExprNodeDynamicListDesc)) continue;
                    return new NodeInfoWrapper(WalkState.UNKNOWN, null, PcrExprProcFactory.getOutExpr(fd, nodeOutputs));
                }
                return this.handleDeterministicUdf(ctx, fd, nodeOutputs);
            }
            if (fd.getGenericUDF() instanceof GenericUDFStruct) {
                for (Object child : nodeOutputs) {
                    NodeInfoWrapper wrapper = (NodeInfoWrapper)child;
                    if (wrapper.state == WalkState.PART_COL) continue;
                    return this.handleDeterministicUdf(ctx, fd, nodeOutputs);
                }
                return new NodeInfoWrapper(WalkState.PART_COL_STRUCT, null, PcrExprProcFactory.getOutExpr(fd, nodeOutputs));
            }
            if (!FunctionRegistry.isConsistentWithinQuery(fd.getGenericUDF())) {
                return new NodeInfoWrapper(WalkState.UNKNOWN, null, PcrExprProcFactory.getOutExpr(fd, nodeOutputs));
            }
            return this.handleDeterministicUdf(ctx, fd, nodeOutputs);
        }

        private Object handleDeterministicUdf(PcrExprProcCtx ctx, ExprNodeGenericFuncDesc fd, Object ... nodeOutputs) throws SemanticException {
            Boolean has_part_col = this.checkForPartColsAndUnknown(nodeOutputs);
            if (has_part_col == null) {
                return new NodeInfoWrapper(WalkState.UNKNOWN, null, PcrExprProcFactory.getOutExpr(fd, nodeOutputs));
            }
            if (has_part_col.booleanValue() && fd.getTypeInfo().getCategory() == ObjectInspector.Category.PRIMITIVE) {
                if (fd.getTypeInfo().equals((Object)TypeInfoFactory.booleanTypeInfo)) {
                    Boolean[] results = new Boolean[ctx.getPartList().size()];
                    for (int i = 0; i < ctx.getPartList().size(); ++i) {
                        results[i] = (Boolean)PcrExprProcFactory.evalExprWithPart(fd, ctx.getPartList().get(i));
                    }
                    return PcrExprProcFactory.getResultWrapFromResults(results, fd, nodeOutputs);
                }
                Object[] results = new Object[ctx.getPartList().size()];
                for (int i = 0; i < ctx.getPartList().size(); ++i) {
                    results[i] = PcrExprProcFactory.evalExprWithPart(fd, ctx.getPartList().get(i));
                }
                Object result = PcrExprProcFactory.ifResultsAgree(results);
                if (result == null) {
                    return new NodeInfoWrapper(WalkState.UNKNOWN, null, PcrExprProcFactory.getOutExpr(fd, nodeOutputs));
                }
                return new NodeInfoWrapper(WalkState.CONSTANT, null, new ExprNodeConstantDesc(fd.getTypeInfo(), result));
            }
            ExprNodeGenericFuncDesc desc = PcrExprProcFactory.getOutExpr(fd, nodeOutputs);
            ExprNodeDesc foldedDesc = ConstantPropagateProcFactory.foldExpr(desc);
            if (foldedDesc instanceof ExprNodeConstantDesc) {
                ExprNodeConstantDesc constant = (ExprNodeConstantDesc)foldedDesc;
                if (Boolean.TRUE.equals(constant.getValue())) {
                    return new NodeInfoWrapper(WalkState.TRUE, null, constant);
                }
                if (Boolean.FALSE.equals(constant.getValue())) {
                    return new NodeInfoWrapper(WalkState.FALSE, null, constant);
                }
                return new NodeInfoWrapper(WalkState.CONSTANT, null, constant);
            }
            return new NodeInfoWrapper(WalkState.CONSTANT, null, desc);
        }

        private Boolean checkForPartColsAndUnknown(Object ... nodeOutputs) {
            boolean has_part_col = false;
            for (Object child : nodeOutputs) {
                NodeInfoWrapper wrapper = (NodeInfoWrapper)child;
                if (wrapper.state == WalkState.UNKNOWN) {
                    return null;
                }
                if (wrapper.state != WalkState.PART_COL && wrapper.state != WalkState.PART_COL_STRUCT) continue;
                has_part_col = true;
            }
            return has_part_col;
        }

        private Object handleUdfOr(PcrExprProcCtx ctx, ExprNodeGenericFuncDesc fd, Object ... nodeOutputs) {
            boolean anyUnknown = false;
            boolean allDivided = true;
            ArrayList<NodeInfoWrapper> newNodeOutputsList = new ArrayList<NodeInfoWrapper>(nodeOutputs.length);
            for (int i = 0; i < nodeOutputs.length; ++i) {
                NodeInfoWrapper c = (NodeInfoWrapper)nodeOutputs[i];
                if (c.state == WalkState.TRUE) {
                    return c;
                }
                if (c.state == WalkState.UNKNOWN) {
                    anyUnknown = true;
                }
                if (c.state != WalkState.DIVIDED) {
                    allDivided = false;
                }
                if (c.state == WalkState.FALSE) continue;
                newNodeOutputsList.add(c);
            }
            if (newNodeOutputsList.isEmpty()) {
                return new NodeInfoWrapper(WalkState.FALSE, null, new ExprNodeConstantDesc(fd.getTypeInfo(), Boolean.FALSE));
            }
            if (newNodeOutputsList.size() == 1) {
                return newNodeOutputsList.get(0);
            }
            Object[] newNodeOutputs = newNodeOutputsList.toArray();
            if (anyUnknown) {
                return new NodeInfoWrapper(WalkState.UNKNOWN, null, PcrExprProcFactory.getOutExpr(fd, newNodeOutputs));
            }
            if (allDivided) {
                Boolean[] results = new Boolean[ctx.getPartList().size()];
                for (int i = 0; i < ctx.getPartList().size(); ++i) {
                    Boolean[] orArray = new Boolean[newNodeOutputs.length];
                    for (int j = 0; j < newNodeOutputs.length; ++j) {
                        orArray[j] = ((NodeInfoWrapper)newNodeOutputs[j]).ResultVector[i];
                    }
                    results[i] = PcrExprProcFactory.opOr(orArray);
                }
                return PcrExprProcFactory.getResultWrapFromResults(results, fd, newNodeOutputs);
            }
            return new NodeInfoWrapper(WalkState.UNKNOWN, null, PcrExprProcFactory.getOutExpr(fd, newNodeOutputs));
        }

        private Object handleUdfAnd(PcrExprProcCtx ctx, ExprNodeGenericFuncDesc fd, Object ... nodeOutputs) {
            boolean anyUnknown = false;
            boolean allDivided = true;
            ArrayList<NodeInfoWrapper> newNodeOutputsList = new ArrayList<NodeInfoWrapper>(nodeOutputs.length);
            for (int i = 0; i < nodeOutputs.length; ++i) {
                NodeInfoWrapper c = (NodeInfoWrapper)nodeOutputs[i];
                if (c.state == WalkState.FALSE) {
                    return c;
                }
                if (c.state == WalkState.UNKNOWN) {
                    anyUnknown = true;
                }
                if (c.state != WalkState.DIVIDED) {
                    allDivided = false;
                }
                if (c.state == WalkState.TRUE) continue;
                newNodeOutputsList.add(c);
            }
            if (newNodeOutputsList.isEmpty()) {
                return new NodeInfoWrapper(WalkState.TRUE, null, new ExprNodeConstantDesc(fd.getTypeInfo(), Boolean.TRUE));
            }
            if (newNodeOutputsList.size() == 1) {
                return newNodeOutputsList.get(0);
            }
            Object[] newNodeOutputs = newNodeOutputsList.toArray();
            if (anyUnknown) {
                return new NodeInfoWrapper(WalkState.UNKNOWN, null, PcrExprProcFactory.getOutExpr(fd, newNodeOutputs));
            }
            if (allDivided) {
                Boolean[] results = new Boolean[ctx.getPartList().size()];
                for (int i = 0; i < ctx.getPartList().size(); ++i) {
                    Boolean[] andArray = new Boolean[newNodeOutputs.length];
                    for (int j = 0; j < newNodeOutputs.length; ++j) {
                        andArray[j] = ((NodeInfoWrapper)newNodeOutputs[j]).ResultVector[i];
                    }
                    results[i] = PcrExprProcFactory.opAnd(andArray);
                }
                return PcrExprProcFactory.getResultWrapFromResults(results, fd, newNodeOutputs);
            }
            return new NodeInfoWrapper(WalkState.UNKNOWN, null, PcrExprProcFactory.getOutExpr(fd, newNodeOutputs));
        }

        private Object handleUdfNot(PcrExprProcCtx ctx, ExprNodeGenericFuncDesc fd, Object ... nodeOutputs) {
            assert (nodeOutputs.length == 1);
            NodeInfoWrapper wrapper = (NodeInfoWrapper)nodeOutputs[0];
            if (wrapper.state == WalkState.TRUE) {
                ExprNodeConstantDesc falseDesc = new ExprNodeConstantDesc(wrapper.outExpr.getTypeInfo(), Boolean.FALSE);
                return new NodeInfoWrapper(WalkState.FALSE, null, falseDesc);
            }
            if (wrapper.state == WalkState.FALSE) {
                ExprNodeConstantDesc trueDesc = new ExprNodeConstantDesc(wrapper.outExpr.getTypeInfo(), Boolean.TRUE);
                return new NodeInfoWrapper(WalkState.TRUE, null, trueDesc);
            }
            if (wrapper.state == WalkState.DIVIDED) {
                Boolean[] results = new Boolean[ctx.getPartList().size()];
                for (int i = 0; i < ctx.getPartList().size(); ++i) {
                    results[i] = PcrExprProcFactory.opNot(wrapper.ResultVector[i]);
                }
                return new NodeInfoWrapper(WalkState.DIVIDED, results, PcrExprProcFactory.getOutExpr(fd, nodeOutputs));
            }
            return new NodeInfoWrapper(wrapper.state, null, PcrExprProcFactory.getOutExpr(fd, nodeOutputs));
        }
    }

    public static class FieldExprProcessor
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ExprNodeFieldDesc fnd = (ExprNodeFieldDesc)nd;
            boolean unknown = false;
            for (Object child : nodeOutputs) {
                NodeInfoWrapper wrapper = (NodeInfoWrapper)child;
                if (wrapper.state != WalkState.UNKNOWN) continue;
                unknown = true;
                break;
            }
            if (unknown) {
                return new NodeInfoWrapper(WalkState.UNKNOWN, null, fnd);
            }
            return new NodeInfoWrapper(WalkState.CONSTANT, null, fnd);
        }
    }

    public static class ColumnExprProcessor
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ExprNodeColumnDesc cd = (ExprNodeColumnDesc)nd;
            PcrExprProcCtx epc = (PcrExprProcCtx)procCtx;
            if (cd.getTabAlias().equalsIgnoreCase(epc.getTabAlias()) && cd.getIsPartitionColOrVirtualCol() && !VirtualColumn.VIRTUAL_COLUMN_NAMES.contains((Object)cd.getColumn().toUpperCase())) {
                return new NodeInfoWrapper(WalkState.PART_COL, null, cd);
            }
            return new NodeInfoWrapper(WalkState.UNKNOWN, null, cd);
        }
    }
}

