/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.math.IntMath;
import com.google.common.math.LongMath;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.security.AccessControlException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.antlr.runtime.ClassicToken;
import org.antlr.runtime.CommonToken;
import org.antlr.runtime.Token;
import org.antlr.runtime.TokenRewriteStream;
import org.antlr.runtime.tree.Tree;
import org.antlr.runtime.tree.TreeVisitor;
import org.antlr.runtime.tree.TreeVisitorAction;
import org.apache.calcite.sql.SqlKind;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.StringInternUtils;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SourceTable;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryProperties;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.cache.results.CacheUsage;
import org.apache.hadoop.hive.ql.cache.results.QueryResultsCache;
import org.apache.hadoop.hive.ql.ddl.DDLDesc;
import org.apache.hadoop.hive.ql.ddl.DDLDescWithTableProperties;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.misc.hooks.InsertCommitHookDesc;
import org.apache.hadoop.hive.ql.ddl.table.create.CreateTableDesc;
import org.apache.hadoop.hive.ql.ddl.table.misc.preinsert.PreInsertTableDesc;
import org.apache.hadoop.hive.ql.ddl.table.misc.properties.AlterTableUnsetPropertiesDesc;
import org.apache.hadoop.hive.ql.ddl.view.create.AbstractCreateViewAnalyzer;
import org.apache.hadoop.hive.ql.ddl.view.create.CreateMaterializedViewDesc;
import org.apache.hadoop.hive.ql.ddl.view.materialized.update.MaterializedViewUpdateDesc;
import org.apache.hadoop.hive.ql.exec.AbstractMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.ArchiveUtils;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.ExprNodeEvaluatorFactory;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.FunctionUtils;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.RecordReader;
import org.apache.hadoop.hive.ql.exec.RecordWriter;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SMBMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.WindowFunctionInfo;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidInputFormat;
import org.apache.hadoop.hive.ql.io.AcidOutputFormat;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.CombineHiveInputFormat;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.NullRowsInputFormat;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.SemanticDispatcher;
import org.apache.hadoop.hive.ql.lockmgr.DbTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.metadata.DefaultConstraint;
import org.apache.hadoop.hive.ql.metadata.DummyPartition;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveUtils;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.MaterializationValidationResult;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.Optimizer;
import org.apache.hadoop.hive.ql.optimizer.QueryPlanPostProcessor;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.ASTBuilder;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.HiveOpConverterPostProc;
import org.apache.hadoop.hive.ql.optimizer.lineage.Generator;
import org.apache.hadoop.hive.ql.optimizer.unionproc.UnionProcContext;
import org.apache.hadoop.hive.ql.parse.ASTErrorUtils;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.ASTNodeOrigin;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ColumnAccessAnalyzer;
import org.apache.hadoop.hive.ql.parse.ColumnAccessInfo;
import org.apache.hadoop.hive.ql.parse.ColumnStatsAutoGatherContext;
import org.apache.hadoop.hive.ql.parse.ColumnStatsSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.ExplainConfiguration;
import org.apache.hadoop.hive.ql.parse.GlobalLimitCtx;
import org.apache.hadoop.hive.ql.parse.HiveTableName;
import org.apache.hadoop.hive.ql.parse.ImmutableCommonToken;
import org.apache.hadoop.hive.ql.parse.JoinCond;
import org.apache.hadoop.hive.ql.parse.JoinType;
import org.apache.hadoop.hive.ql.parse.MaskAndFilterInfo;
import org.apache.hadoop.hive.ql.parse.OpParseContext;
import org.apache.hadoop.hive.ql.parse.PTFInvocationSpec;
import org.apache.hadoop.hive.ql.parse.PTFTranslator;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.ParseResult;
import org.apache.hadoop.hive.ql.parse.ParseUtils;
import org.apache.hadoop.hive.ql.parse.PartitionTransform;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.QB;
import org.apache.hadoop.hive.ql.parse.QBExpr;
import org.apache.hadoop.hive.ql.parse.QBJoinTree;
import org.apache.hadoop.hive.ql.parse.QBMetaData;
import org.apache.hadoop.hive.ql.parse.QBParseInfo;
import org.apache.hadoop.hive.ql.parse.QBSubQuery;
import org.apache.hadoop.hive.ql.parse.QBSystemVersion;
import org.apache.hadoop.hive.ql.parse.QueryTables;
import org.apache.hadoop.hive.ql.parse.RowResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.SemiJoinHint;
import org.apache.hadoop.hive.ql.parse.SplitSample;
import org.apache.hadoop.hive.ql.parse.StorageFormat;
import org.apache.hadoop.hive.ql.parse.SubQueryUtils;
import org.apache.hadoop.hive.ql.parse.TableAccessAnalyzer;
import org.apache.hadoop.hive.ql.parse.TableMask;
import org.apache.hadoop.hive.ql.parse.TableSample;
import org.apache.hadoop.hive.ql.parse.TaskCompiler;
import org.apache.hadoop.hive.ql.parse.TaskCompilerFactory;
import org.apache.hadoop.hive.ql.parse.UnparseTranslator;
import org.apache.hadoop.hive.ql.parse.WindowingComponentizer;
import org.apache.hadoop.hive.ql.parse.WindowingSpec;
import org.apache.hadoop.hive.ql.parse.type.ExprNodeTypeCheck;
import org.apache.hadoop.hive.ql.parse.type.TypeCheckCtx;
import org.apache.hadoop.hive.ql.parse.type.TypeCheckProcFactory;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.apache.hadoop.hive.ql.plan.DynamicPartitionCtx;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnListDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.ForwardDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.LateralViewForwardDesc;
import org.apache.hadoop.hive.ql.plan.LateralViewJoinDesc;
import org.apache.hadoop.hive.ql.plan.LimitDesc;
import org.apache.hadoop.hive.ql.plan.ListBucketingCtx;
import org.apache.hadoop.hive.ql.plan.LoadFileDesc;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PTFDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.ScriptDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.Statistics;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.UDTFDesc;
import org.apache.hadoop.hive.ql.plan.UnionDesc;
import org.apache.hadoop.hive.ql.plan.mapper.AuxOpTreeSignature;
import org.apache.hadoop.hive.ql.plan.ptf.OrderExpressionDef;
import org.apache.hadoop.hive.ql.plan.ptf.PTFExpressionDef;
import org.apache.hadoop.hive.ql.plan.ptf.PartitionedTableFunctionDef;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.session.SessionStateUtil;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFArray;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCardinalityViolation;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFHash;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFMurmurHash;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFSurrogateKey;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTFInline;
import org.apache.hadoop.hive.ql.util.DirectionUtils;
import org.apache.hadoop.hive.ql.util.NullOrdering;
import org.apache.hadoop.hive.ql.util.ResourceDownloader;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.DelimitedJSONSerDe;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.MetadataTypedColumnsetSerDe;
import org.apache.hadoop.hive.serde2.NoOpFetchFormatter;
import org.apache.hadoop.hive.serde2.NullStructSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinarySerDe2;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorConverters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaConstantStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.thrift.ThriftJDBCBinarySerDe;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.ReflectionUtils;

public class SemanticAnalyzer
extends BaseSemanticAnalyzer {
    public static final String DUMMY_DATABASE = "_dummy_database";
    public static final String DUMMY_TABLE = "_dummy_table";
    public static final String SUBQUERY_TAG_1 = "-subquery1";
    public static final String SUBQUERY_TAG_2 = "-subquery2";
    private static final int AUTOGEN_COLALIAS_PRFX_MAXLENGTH = 20;
    public static final String VALUES_TMP_TABLE_NAME_PREFIX = "Values__Tmp__Table__";
    protected static final String MATERIALIZATION_MARKER = "$MATERIALIZATION";
    private static final String RESULTS_CACHE_KEY_TOKEN_REWRITE_PROGRAM = "RESULTS_CACHE_KEY_PROGRAM";
    private Map<TableScanOperator, ExprNodeDesc> opToPartPruner;
    private Map<TableScanOperator, PrunedPartitionList> opToPartList;
    protected Map<String, TableScanOperator> topOps;
    protected Map<Operator<? extends OperatorDesc>, OpParseContext> opParseCtx;
    private List<LoadTableDesc> loadTableWork;
    private List<LoadFileDesc> loadFileWork;
    private final List<ColumnStatsAutoGatherContext> columnStatsAutoGatherContexts;
    private final Map<JoinOperator, QBJoinTree> joinContext;
    private final Map<SMBMapJoinOperator, QBJoinTree> smbMapJoinContext;
    private final List<ReduceSinkOperator> reduceSinkOperatorsAddedByEnforceBucketingSorting;
    private QB qb;
    protected ASTNode ast;
    private int destTableId = 1;
    private UnionProcContext uCtx = null;
    private List<AbstractMapJoinOperator<? extends MapJoinDesc>> listMapJoinOpsNoReducer;
    private Map<TableScanOperator, FilterDesc.SampleDesc> opToSamplePruner;
    private final Map<TableScanOperator, Map<String, ExprNodeDesc>> opToPartToSkewedPruner;
    private Map<SelectOperator, org.apache.hadoop.hive.ql.metadata.Table> viewProjectToTableSchema;
    private Operator<? extends OperatorDesc> sinkOp;
    private final Map<String, SplitSample> nameToSplitSample;
    private final Map<GroupByOperator, Set<String>> groupOpToInputTables;
    protected Map<String, PrunedPartitionList> prunedPartitions;
    protected List<FieldSchema> resultSchema;
    protected List<FieldSchema> originalResultSchema;
    protected CreateMaterializedViewDesc createVwDesc;
    private MaterializedViewUpdateDesc materializedViewUpdateDesc;
    protected List<String> viewsExpanded;
    protected ASTNode viewSelect;
    protected final UnparseTranslator unparseTranslator;
    private final GlobalLimitCtx globalLimitCtx;
    protected final String autogenColAliasPrfxLbl;
    private final boolean autogenColAliasPrfxIncludeFuncName;
    private final Map<String, ReadEntity> viewAliasToInput;
    private boolean mergeIsDirect;
    private boolean noscan;
    protected boolean forViewCreation;
    private String fqViewName;
    protected MaterializationRebuildMode mvRebuildMode = MaterializationRebuildMode.NONE;
    protected volatile boolean disableJoinMerge = false;
    protected final boolean defaultJoinMerge;
    protected Map<String, TableScanOperator> topOpsCopy = null;
    protected final Map<String, CTEClause> aliasToCTEs;
    private List<String> ctesExpanded = new ArrayList<String>();
    private boolean rootTasksResolved;
    protected TableMask tableMask;
    protected CreateTableDesc tableDesc;
    protected BaseSemanticAnalyzer.AnalyzeRewriteContext analyzeRewrite;
    private WriteEntity acidAnalyzeTable;
    QueryTables tabNameToTabObject;
    private static final Set<Integer> IGNORED_TOKENS = Sets.newHashSet((Object[])new Integer[]{1048, 1130, 1326, 946, 1002, 1235});
    private String invalidResultCacheReason;
    private MaterializationValidationResult materializationValidationResult;
    private final NullOrdering defaultNullOrder;
    private static final CommonToken SELECTDI_TOKEN = new ImmutableCommonToken(1197, "TOK_SELECTDI");
    private static final CommonToken SELEXPR_TOKEN = new ImmutableCommonToken(1198, "TOK_SELEXPR");
    private static final CommonToken TABLEORCOL_TOKEN = new ImmutableCommonToken(1276, "TOK_TABLE_OR_COL");
    private static final CommonToken DOT_TOKEN = new ImmutableCommonToken(16, ".");
    private int subQueryExpressionAliasCounter = 0;
    protected static final ObjectMapper JSON_OBJECT_MAPPER = new ObjectMapper();
    private final CTEClause rootClause = new CTEClause(this, null, null, null);
    Path dummyPath;

    public SemanticAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
        this.opToPartPruner = new HashMap<TableScanOperator, ExprNodeDesc>();
        this.opToPartList = new HashMap<TableScanOperator, PrunedPartitionList>();
        this.opToSamplePruner = new HashMap<TableScanOperator, FilterDesc.SampleDesc>();
        this.nameToSplitSample = new HashMap<String, SplitSample>();
        this.topOps = new LinkedHashMap<String, TableScanOperator>();
        this.loadTableWork = new ArrayList<LoadTableDesc>();
        this.loadFileWork = new ArrayList<LoadFileDesc>();
        this.columnStatsAutoGatherContexts = new ArrayList<ColumnStatsAutoGatherContext>();
        this.opParseCtx = new LinkedHashMap<Operator<? extends OperatorDesc>, OpParseContext>();
        this.joinContext = new HashMap<JoinOperator, QBJoinTree>();
        this.smbMapJoinContext = new HashMap<SMBMapJoinOperator, QBJoinTree>();
        this.reduceSinkOperatorsAddedByEnforceBucketingSorting = new ArrayList<ReduceSinkOperator>();
        this.listMapJoinOpsNoReducer = new ArrayList<AbstractMapJoinOperator<? extends MapJoinDesc>>();
        this.groupOpToInputTables = new HashMap<GroupByOperator, Set<String>>();
        this.prunedPartitions = new HashMap<String, PrunedPartitionList>();
        this.unparseTranslator = new UnparseTranslator((Configuration)this.conf);
        this.autogenColAliasPrfxLbl = HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_AUTOGEN_COLUMNALIAS_PREFIX_LABEL);
        this.autogenColAliasPrfxIncludeFuncName = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_AUTOGEN_COLUMNALIAS_PREFIX_INCLUDEFUNCNAME);
        this.queryProperties = new QueryProperties();
        this.opToPartToSkewedPruner = new HashMap<TableScanOperator, Map<String, ExprNodeDesc>>();
        this.aliasToCTEs = new HashMap<String, CTEClause>();
        this.globalLimitCtx = new GlobalLimitCtx();
        this.viewAliasToInput = new HashMap<String, ReadEntity>();
        this.mergeIsDirect = true;
        this.noscan = false;
        this.tabNameToTabObject = new QueryTables();
        this.disableJoinMerge = this.defaultJoinMerge = !HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MERGE_NWAY_JOINS);
        this.defaultNullOrder = NullOrdering.defaultNullOrder((Configuration)this.conf);
    }

    @Override
    protected void reset(boolean clearCache) {
        super.reset(true);
        if (clearCache) {
            this.prunedPartitions.clear();
            if (this.ctx != null) {
                this.ctx.getOpContext().getColStatsCache().clear();
            }
            this.mergeIsDirect = true;
        } else {
            this.mergeIsDirect = false;
        }
        this.loadTableWork.clear();
        this.loadFileWork.clear();
        this.columnStatsAutoGatherContexts.clear();
        this.topOps.clear();
        this.destTableId = 1;
        this.idToTableNameMap.clear();
        this.qb = null;
        this.ast = null;
        this.uCtx = null;
        this.joinContext.clear();
        this.smbMapJoinContext.clear();
        this.opParseCtx.clear();
        this.groupOpToInputTables.clear();
        this.disableJoinMerge = this.defaultJoinMerge;
        this.aliasToCTEs.clear();
        this.opToPartPruner.clear();
        this.opToPartList.clear();
        this.opToPartToSkewedPruner.clear();
        this.opToSamplePruner.clear();
        this.nameToSplitSample.clear();
        this.resultSchema = null;
        this.createVwDesc = null;
        this.materializedViewUpdateDesc = null;
        this.viewsExpanded = null;
        this.viewSelect = null;
        this.ctesExpanded.clear();
        this.globalLimitCtx.disableOpt();
        this.viewAliasToInput.clear();
        this.reduceSinkOperatorsAddedByEnforceBucketingSorting.clear();
        this.listMapJoinOpsNoReducer.clear();
        this.unparseTranslator.clear();
        this.queryProperties.clear();
        this.outputs.clear();
        if (this.ctx != null && this.ctx.enableUnparse()) {
            this.unparseTranslator.enable();
        }
    }

    void initParseCtx(ParseContext pctx) {
        this.opToPartPruner = pctx.getOpToPartPruner();
        this.opToPartList = pctx.getOpToPartList();
        this.opToSamplePruner = pctx.getOpToSamplePruner();
        this.topOps = pctx.getTopOps();
        this.loadTableWork = pctx.getLoadTableWork();
        this.loadFileWork = pctx.getLoadFileWork();
        this.ctx = pctx.getContext();
        this.destTableId = pctx.getDestTableId();
        this.idToTableNameMap = pctx.getIdToTableNameMap();
        this.uCtx = pctx.getUCtx();
        this.listMapJoinOpsNoReducer = pctx.getListMapJoinOpsNoReducer();
        this.prunedPartitions = pctx.getPrunedPartitions();
        this.tabNameToTabObject = pctx.getTabNameToTabObject();
        this.fetchTask = pctx.getFetchTask();
        this.setLineageInfo(pctx.getLineageInfo());
    }

    @Override
    public ParseContext getParseContext() {
        this.copyInfoToQueryProperties(this.queryProperties);
        return new ParseContext(this.queryState, this.opToPartPruner, this.opToPartList, this.topOps, new HashSet<JoinOperator>(this.joinContext.keySet()), new HashSet<SMBMapJoinOperator>(this.smbMapJoinContext.keySet()), this.loadTableWork, this.loadFileWork, this.columnStatsAutoGatherContexts, this.ctx, this.idToTableNameMap, this.destTableId, this.uCtx, this.listMapJoinOpsNoReducer, this.prunedPartitions, this.tabNameToTabObject, this.opToSamplePruner, this.globalLimitCtx, this.nameToSplitSample, this.inputs, this.rootTasks, this.opToPartToSkewedPruner, this.viewAliasToInput, this.reduceSinkOperatorsAddedByEnforceBucketingSorting, this.analyzeRewrite, this.tableDesc, this.createVwDesc, this.materializedViewUpdateDesc, this.queryProperties, this.viewProjectToTableSchema);
    }

    public CompilationOpContext getOpContext() {
        return this.ctx.getOpContext();
    }

    static String genPartValueString(String partColType, String partVal) {
        Object returnVal = partVal;
        returnVal = partColType.equals("string") || partColType.contains("varchar") || partColType.contains("char") ? "'" + SemanticAnalyzer.escapeSQLString(partVal) + "'" : (partColType.equals("tinyint") ? partVal + "Y" : (partColType.equals("smallint") ? partVal + "S" : (partColType.equals("int") ? partVal : (partColType.equals("bigint") ? partVal + "L" : (partColType.contains("decimal") ? partVal + "BD" : (partColType.equals("date") || partColType.equals("timestamp") ? partColType + " '" + SemanticAnalyzer.escapeSQLString(partVal) + "'" : "'" + SemanticAnalyzer.escapeSQLString(partVal) + "'"))))));
        return returnVal;
    }

    private void doPhase1QBExpr(ASTNode ast, QBExpr qbexpr, String id, String alias, ASTNode tabColNames, Map<String, CTEClause> aliasToCTEs) throws SemanticException {
        this.doPhase1QBExpr(ast, qbexpr, id, alias, false, tabColNames, aliasToCTEs);
    }

    private void doPhase1QBExpr(ASTNode ast, QBExpr qbexpr, String id, String alias, ASTNode tabColNames) throws SemanticException {
        this.doPhase1QBExpr(ast, qbexpr, id, alias, false, tabColNames, this.aliasToCTEs);
    }

    void doPhase1QBExpr(ASTNode ast, QBExpr qbexpr, String id, String alias, boolean insideView, ASTNode tabColNames) throws SemanticException {
        this.doPhase1QBExpr(ast, qbexpr, id, alias, insideView, tabColNames, this.aliasToCTEs);
    }

    void doPhase1QBExpr(ASTNode ast, QBExpr qbexpr, String id, String alias, boolean insideView, ASTNode tabColNames, Map<String, CTEClause> aliasToCTEs) throws SemanticException {
        assert (ast.getToken() != null);
        if (ast.getToken().getType() == 1161) {
            QB qb = new QB(id, alias, true);
            qb.setInsideView(insideView);
            Phase1Ctx ctx_1 = this.initPhase1Ctx();
            qb.getParseInfo().setColAliases(tabColNames);
            this.doPhase1(ast, qb, ctx_1, null, aliasToCTEs);
            qbexpr.setOpcode(QBExpr.Opcode.NULLOP);
            qbexpr.setQB(qb);
        } else {
            switch (ast.getToken().getType()) {
                case 1301: {
                    qbexpr.setOpcode(QBExpr.Opcode.UNION);
                    break;
                }
                case 1062: {
                    this.queryProperties.setHasIntersect(true);
                    qbexpr.setOpcode(QBExpr.Opcode.INTERSECTALL);
                    break;
                }
                case 1063: {
                    this.queryProperties.setHasIntersect(true);
                    qbexpr.setOpcode(QBExpr.Opcode.INTERSECT);
                    break;
                }
                case 1020: {
                    this.queryProperties.setHasExcept(true);
                    qbexpr.setOpcode(QBExpr.Opcode.EXCEPTALL);
                    break;
                }
                case 1021: {
                    this.queryProperties.setHasExcept(true);
                    qbexpr.setOpcode(QBExpr.Opcode.EXCEPT);
                    break;
                }
                default: {
                    throw new SemanticException(ErrorMsg.UNSUPPORTED_SET_OPERATOR.getMsg("Type " + ast.getToken().getType()));
                }
            }
            assert (ast.getChild(0) != null);
            QBExpr qbexpr1 = new QBExpr(alias + SUBQUERY_TAG_1);
            this.doPhase1QBExpr((ASTNode)ast.getChild(0), qbexpr1, id, alias + SUBQUERY_TAG_1, insideView, tabColNames, aliasToCTEs);
            qbexpr.setQBExpr1(qbexpr1);
            assert (ast.getChild(1) != null);
            QBExpr qbexpr2 = new QBExpr(alias + SUBQUERY_TAG_2);
            this.doPhase1QBExpr((ASTNode)ast.getChild(1), qbexpr2, id, alias + SUBQUERY_TAG_2, insideView, tabColNames, aliasToCTEs);
            qbexpr.setQBExpr2(qbexpr2);
        }
    }

    private Map<String, ASTNode> doPhase1GetAggregationsFromSelect(ASTNode selExpr, QB qb, String dest) throws SemanticException {
        LinkedHashMap<String, ASTNode> aggregationTrees = new LinkedHashMap<String, ASTNode>();
        ArrayList<ASTNode> wdwFns = new ArrayList<ASTNode>();
        for (int i = 0; i < selExpr.getChildCount(); ++i) {
            ASTNode function = (ASTNode)selExpr.getChild(i);
            if (function.getType() == 1198 || function.getType() == 1243) {
                function = (ASTNode)function.getChild(0);
            }
            this.doPhase1GetAllAggregations(function, qb, aggregationTrees, wdwFns, null);
        }
        for (ASTNode wdwFn : wdwFns) {
            WindowingSpec spec = qb.getWindowingSpec(dest);
            if (spec == null) {
                this.queryProperties.setHasWindowing(true);
                spec = new WindowingSpec();
                qb.addDestToWindowingSpec(dest, spec);
            }
            Map<String, ASTNode> wExprsInDest = qb.getParseInfo().getWindowingExprsForClause(dest);
            int wColIdx = spec.getWindowExpressions() == null ? 0 : spec.getWindowExpressions().size();
            WindowingSpec.WindowFunctionSpec wFnSpec = this.processWindowFunction(wdwFn, (ASTNode)wdwFn.getChild(wdwFn.getChildCount() - 1));
            if (wExprsInDest != null && wExprsInDest.containsKey(wFnSpec.getExpression().toStringTree())) continue;
            wFnSpec.setAlias(wFnSpec.getName() + "_window_" + wColIdx);
            spec.addWindowFunction(wFnSpec);
            qb.getParseInfo().addWindowingExprToClause(dest, wFnSpec.getExpression());
        }
        return aggregationTrees;
    }

    private void doPhase1WhereClause(ASTNode expressionTree, QB qb) throws SemanticException {
        int exprTokenType = expressionTree.getToken().getType();
        if (exprTokenType == 1243) {
            qb.addSubqExprAlias(expressionTree, this);
            return;
        }
        for (int i = 0; i < expressionTree.getChildCount(); ++i) {
            this.doPhase1WhereClause((ASTNode)expressionTree.getChild(i), qb);
        }
    }

    protected boolean isInsertInto(QBParseInfo qbp, String dest) {
        if (qbp == null || dest == null) {
            return false;
        }
        ASTNode destNode = qbp.getDestForClause(dest);
        return destNode != null && destNode.getType() == 1249;
    }

    private boolean isValueClause(ASTNode select) {
        ASTNode selectChildExpr;
        ASTNode selectExpr;
        if (select == null) {
            return false;
        }
        if (select.getChildCount() == 1 && (selectExpr = (ASTNode)select.getChild(0)).getChildCount() == 1 && (selectChildExpr = (ASTNode)selectExpr.getChild(0)).getType() == 1039) {
            ASTNode inline = (ASTNode)selectChildExpr.getChild(0);
            ASTNode func = (ASTNode)selectChildExpr.getChild(1);
            if (inline.getText().equals(GenericUDTFInline.class.getAnnotation(Description.class).name()) && func.getType() == 1039) {
                ASTNode arrayNode = (ASTNode)func.getChild(0);
                ASTNode funcNode = (ASTNode)func.getChild(1);
                if (arrayNode.getText().equals(GenericUDFArray.class.getAnnotation(Description.class).name()) && funcNode.getType() == 1039) {
                    return true;
                }
            }
        }
        return false;
    }

    protected List<String> getDefaultConstraints(org.apache.hadoop.hive.ql.metadata.Table tbl, List<String> targetSchema) throws SemanticException {
        Map<String, String> colNameToDefaultVal = this.getColNameToDefaultValueMap(tbl);
        ArrayList<String> defaultConstraints = new ArrayList<String>();
        if (targetSchema != null && !targetSchema.isEmpty()) {
            for (String colName : targetSchema) {
                defaultConstraints.add(colNameToDefaultVal.get(colName));
            }
        } else {
            for (FieldSchema fs : tbl.getCols()) {
                defaultConstraints.add(colNameToDefaultVal.get(fs.getName()));
            }
        }
        return defaultConstraints;
    }

    protected Map<String, String> getColNameToDefaultValueMap(org.apache.hadoop.hive.ql.metadata.Table tbl) throws SemanticException {
        Map<String, String> colNameToDefaultVal = null;
        if (tbl.getStorageHandler() != null && tbl.getStorageHandler().supportsDefaultColumnValues(tbl.getParameters())) {
            return Collections.emptyMap();
        }
        try {
            DefaultConstraint dc = Hive.get().getEnabledDefaultConstraints(tbl.getDbName(), tbl.getTableName());
            colNameToDefaultVal = dc.getColNameToDefaultValueMap();
        }
        catch (Exception e) {
            if (e instanceof SemanticException) {
                throw (SemanticException)((Object)e);
            }
            throw new RuntimeException(e);
        }
        return colNameToDefaultVal;
    }

    private ASTNode getNodeReplacementforDefault(String newValue) throws SemanticException {
        ASTNode newNode = null;
        if (newValue == null) {
            newNode = ASTBuilder.construct(1105, "TOK_NULL").node();
        } else {
            try {
                newNode = new ParseDriver().parseExpression(newValue);
            }
            catch (Exception e) {
                throw new SemanticException("Error while parsing default value for DEFAULT keyword: " + newValue + ". Error message: " + e.getMessage());
            }
        }
        return newNode;
    }

    private void replaceDefaultKeywordForUpdate(ASTNode selectExprs, org.apache.hadoop.hive.ql.metadata.Table targetTable) throws SemanticException {
        List<String> defaultConstraints = null;
        for (int i = 0; i < selectExprs.getChildCount(); ++i) {
            ASTNode selectExpr = (ASTNode)selectExprs.getChild(i);
            if (selectExpr.getChildCount() != 1 || selectExpr.getChild(0).getType() != 1276 || i == 0 && !selectExpr.getChild(0).getChild(0).getText().equals("ROW__ID") || selectExpr.getChild(0).getChild(0).getType() != 990) continue;
            if (defaultConstraints == null) {
                defaultConstraints = this.getDefaultConstraints(targetTable, null);
            }
            ASTNode newNode = this.getNodeReplacementforDefault(defaultConstraints.get(i - 1));
            selectExpr.replaceChildren(0, 0, (Object)newNode);
            if (!this.LOG.isDebugEnabled()) continue;
            this.LOG.debug("DEFAULT keyword replacement - Inserted {} for table: {}", (Object)newNode.getText(), (Object)targetTable.getTableName());
        }
    }

    private void replaceDefaultKeyword(ASTNode valueArrClause, org.apache.hadoop.hive.ql.metadata.Table targetTable, List<String> targetSchema) throws SemanticException {
        List<String> defaultConstraints = null;
        for (int i = 1; i < valueArrClause.getChildCount(); ++i) {
            ASTNode valueClause = (ASTNode)valueArrClause.getChild(i);
            for (int j = 1; j < valueClause.getChildCount(); ++j) {
                if (valueClause.getChild(j).getType() != 1276 || valueClause.getChild(j).getChild(0).getType() != 990) continue;
                if (defaultConstraints == null) {
                    defaultConstraints = this.getDefaultConstraints(targetTable, targetSchema);
                }
                ASTNode newNode = this.getNodeReplacementforDefault(defaultConstraints.get(j - 1));
                valueClause.replaceChildren(j, j, (Object)newNode);
                this.LOG.debug("DEFAULT keyword replacement - Inserted {} for table: {}", (Object)newNode.getText(), (Object)targetTable.getTableName());
            }
        }
    }

    private void doPhase1GetColumnAliasesFromSelect(ASTNode selectExpr, QBParseInfo qbp, String dest) throws SemanticException {
        if (this.isInsertInto(qbp, dest)) {
            ASTNode tblAst = qbp.getDestForClause(dest);
            String tableName = SemanticAnalyzer.getUnescapedName((ASTNode)tblAst.getChild(0));
            try {
                if (this.isValueClause(selectExpr)) {
                    targetTable = this.getTableObjectByName(tableName);
                    this.replaceDefaultKeyword((ASTNode)selectExpr.getChild(0).getChild(0).getChild(1), targetTable, qbp.getDestSchemaForClause(dest));
                } else if (this.updating(dest)) {
                    targetTable = this.getTableObjectByName(tableName);
                    this.replaceDefaultKeywordForUpdate(selectExpr, targetTable);
                }
            }
            catch (Exception e) {
                if (e instanceof SemanticException) {
                    throw (SemanticException)((Object)e);
                }
                throw new RuntimeException(e);
            }
        }
        for (int i = 0; i < selectExpr.getChildCount(); ++i) {
            ASTNode selExpr = (ASTNode)selectExpr.getChild(i);
            if (selExpr.getToken().getType() != 1198 || selExpr.getChildCount() != 2) continue;
            String columnAlias = SemanticAnalyzer.unescapeIdentifier(selExpr.getChild(1).getText());
            qbp.setExprToColumnAlias((ASTNode)selExpr.getChild(0), columnAlias);
        }
    }

    private void doPhase1GetAllAggregations(ASTNode expressionTree, QB qb, Map<String, ASTNode> aggregations, List<ASTNode> wdwFns, ASTNode wndParent) throws SemanticException {
        boolean parentIsWindowSpec;
        int exprTokenType = expressionTree.getToken().getType();
        if (exprTokenType == 1243) {
            qb.addSubqExprAlias(expressionTree, this);
            return;
        }
        boolean bl = parentIsWindowSpec = wndParent != null;
        if (exprTokenType == 1039 || exprTokenType == 1040 || exprTokenType == 1041) {
            assert (expressionTree.getChildCount() != 0);
            Tree lastChild = expressionTree.getChild(expressionTree.getChildCount() - 1);
            if (lastChild.getType() == 1326) {
                wdwFns.add(expressionTree);
                for (Node child : expressionTree.getChildren()) {
                    this.doPhase1GetAllAggregations((ASTNode)child, qb, aggregations, wdwFns, expressionTree);
                }
                return;
            }
            if (lastChild.getType() == 1328) {
                this.transformWithinGroup(expressionTree, lastChild);
            }
            if (expressionTree.getChild(0).getType() == 24) {
                String functionName = SemanticAnalyzer.unescapeIdentifier(expressionTree.getChild(0).getText());
                if (FunctionRegistry.getFunctionInfo(functionName) == null) {
                    throw new SemanticException(ErrorMsg.INVALID_FUNCTION.getMsg(functionName));
                }
                if (FunctionRegistry.impliesOrder(functionName) && !parentIsWindowSpec) {
                    throw new SemanticException(ErrorMsg.MISSING_OVER_CLAUSE.getMsg(functionName));
                }
                if (FunctionRegistry.getGenericUDAFResolver(functionName) != null) {
                    if (this.containsLeadLagUDF(expressionTree) && !parentIsWindowSpec) {
                        throw new SemanticException(ErrorMsg.MISSING_OVER_CLAUSE.getMsg(functionName));
                    }
                    aggregations.put(expressionTree.toStringTree(), expressionTree);
                    FunctionInfo fi = FunctionRegistry.getFunctionInfo(functionName);
                    if (!fi.isNative()) {
                        this.unparseTranslator.addIdentifierTranslation((ASTNode)expressionTree.getChild(0));
                    }
                    return;
                }
            }
        }
        for (int i = 0; i < expressionTree.getChildCount(); ++i) {
            this.doPhase1GetAllAggregations((ASTNode)expressionTree.getChild(i), qb, aggregations, wdwFns, wndParent);
        }
    }

    private void transformWithinGroup(ASTNode expressionTree, Tree withinGroupNode) throws SemanticException {
        if (this.isCBOExecuted()) {
            return;
        }
        Tree functionNameNode = expressionTree.getChild(0);
        if (!FunctionRegistry.isOrderedAggregate(functionNameNode.getText())) {
            throw new SemanticException(ErrorMsg.WITHIN_GROUP_NOT_ALLOWED, new String[]{functionNameNode.getText()});
        }
        ArrayList<Tree> parameters = new ArrayList<Tree>(expressionTree.getChildCount() - 2);
        for (int i = 1; i < expressionTree.getChildCount() - 1; ++i) {
            parameters.add(expressionTree.getChild(i));
        }
        while (expressionTree.getChildCount() > 1) {
            expressionTree.deleteChild(1);
        }
        Tree orderByNode = withinGroupNode.getChild(0);
        if (parameters.size() != orderByNode.getChildCount()) {
            throw new SemanticException(ErrorMsg.WITHIN_GROUP_PARAMETER_MISMATCH, new String[]{Integer.toString(parameters.size()), Integer.toString(orderByNode.getChildCount())});
        }
        for (int i = 0; i < orderByNode.getChildCount(); ++i) {
            expressionTree.addChild((Tree)parameters.get(i));
            Tree tabSortColNameNode = orderByNode.getChild(i);
            Tree nullsNode = tabSortColNameNode.getChild(0);
            ASTNode sortKey = (ASTNode)tabSortColNameNode.getChild(0).getChild(0);
            expressionTree.addChild((Tree)sortKey);
            expressionTree.addChild((Tree)ASTBuilder.createAST(428, Integer.toString(DirectionUtils.tokenToCode(tabSortColNameNode.getType()))));
            expressionTree.addChild((Tree)ASTBuilder.createAST(428, Integer.toString(NullOrdering.fromToken(nullsNode.getType()).getCode())));
        }
    }

    private List<ASTNode> doPhase1GetDistinctFuncExprs(Map<String, ASTNode> aggregationTrees) {
        ArrayList<ASTNode> exprs = new ArrayList<ASTNode>();
        for (Map.Entry<String, ASTNode> entry : aggregationTrees.entrySet()) {
            ASTNode value = entry.getValue();
            assert (value != null);
            if (value.getToken().getType() != 1040) continue;
            exprs.add(value);
        }
        return exprs;
    }

    public static String generateErrorMessage(ASTNode ast, String message) {
        StringBuilder sb = new StringBuilder();
        if (ast == null) {
            sb.append(message).append(". Cannot tell the position of null AST.");
            return sb.toString();
        }
        sb.append(ast.getLine());
        sb.append(":");
        sb.append(ast.getCharPositionInLine());
        sb.append(" ");
        sb.append(message);
        sb.append(". Error encountered near token '");
        sb.append(ASTErrorUtils.getText((ASTNode)ast));
        sb.append("'");
        return sb.toString();
    }

    protected ASTNode getAST() {
        return this.ast;
    }

    protected void setAST(ASTNode newAST) {
        this.ast = newAST;
    }

    private String findSimpleTableName(ASTNode tabref, int aliasIndex) throws SemanticException {
        assert (tabref.getType() == 1280);
        ASTNode tableTree = (ASTNode)tabref.getChild(0);
        String alias = aliasIndex != 0 ? SemanticAnalyzer.unescapeIdentifier(tabref.getChild(aliasIndex).getText()) : SemanticAnalyzer.getUnescapedUnqualifiedTableName(tableTree);
        return alias;
    }

    private String processTable(QB qb, ASTNode tabref) throws SemanticException {
        int[] indexes = SemanticAnalyzer.findTabRefIdxs(tabref);
        int aliasIndex = indexes[0];
        int propsIndex = indexes[1];
        int tsampleIndex = indexes[2];
        int ssampleIndex = indexes[3];
        int asOfTimeIndex = indexes[4];
        int asOfVersionIndex = indexes[5];
        int asOfVersionFromIndex = indexes[6];
        ASTNode tableTree = (ASTNode)tabref.getChild(0);
        String tabIdName = HiveUtils.getLowerCaseTableName(SemanticAnalyzer.getUnescapedName(tableTree));
        String alias = this.findSimpleTableName(tabref, aliasIndex);
        if (propsIndex >= 0) {
            Tree propsAST = tabref.getChild(propsIndex);
            Map<String, String> props = SemanticAnalyzer.getProps((ASTNode)propsAST.getChild(0));
            if ("TRUE".equals(props.get("insideView"))) {
                qb.getAliasInsideView().add(alias.toLowerCase());
            }
            qb.setTabProps(alias, props);
        }
        if (asOfTimeIndex != -1 || asOfVersionIndex != -1 || asOfVersionFromIndex != -1) {
            String asOfVersion = asOfVersionIndex == -1 ? null : this.getAsOfValue(tabref, asOfVersionIndex);
            String asOfVersionFrom = asOfVersionFromIndex == -1 ? null : tabref.getChild(asOfVersionFromIndex).getChild(0).getText();
            String asOfTime = asOfTimeIndex == -1 ? null : this.getAsOfValue(tabref, asOfTimeIndex);
            qb.setSystemVersion(alias, new QBSystemVersion(asOfVersion, asOfVersionFrom, asOfTime));
        }
        if (qb.exists(alias)) {
            throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.AMBIGUOUS_TABLE_ALIAS.getMsg(), (Tree)tabref.getChild(aliasIndex)));
        }
        if (tsampleIndex >= 0) {
            sampleClause = (ASTNode)tabref.getChild(tsampleIndex);
            ArrayList<ASTNode> sampleCols = new ArrayList<ASTNode>();
            if (sampleClause.getChildCount() > 2) {
                for (int i = 2; i < sampleClause.getChildCount(); ++i) {
                    sampleCols.add((ASTNode)sampleClause.getChild(i));
                }
            }
            if (sampleCols.size() > 2) {
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage((ASTNode)tabref.getChild(0), ErrorMsg.SAMPLE_RESTRICTION.getMsg()));
            }
            TableSample tabSample = new TableSample(SemanticAnalyzer.unescapeIdentifier(sampleClause.getChild(0).getText()), SemanticAnalyzer.unescapeIdentifier(sampleClause.getChild(1).getText()), sampleCols);
            qb.getParseInfo().setTabSample(alias, tabSample);
            if (this.unparseTranslator.isEnabled()) {
                for (ASTNode sampleCol : sampleCols) {
                    this.unparseTranslator.addIdentifierTranslation((ASTNode)sampleCol.getChild(0));
                }
            }
        } else if (ssampleIndex >= 0) {
            SplitSample sample;
            sampleClause = (ASTNode)tabref.getChild(ssampleIndex);
            Tree type = sampleClause.getChild(0);
            Tree numerator = sampleClause.getChild(1);
            String value = SemanticAnalyzer.unescapeIdentifier(numerator.getText());
            if (type.getType() == 1139) {
                this.assertCombineInputFormat(numerator, "Percentage");
                double percent = Double.valueOf(value);
                if (percent < 0.0 || percent > 100.0) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage((ASTNode)numerator, "Sampling percentage should be between 0 and 100"));
                }
                int seedNum = this.conf.getIntVar(HiveConf.ConfVars.HIVE_SAMPLE_RANDOM_NUM);
                sample = new SplitSample(percent, seedNum);
            } else if (type.getType() == 1193) {
                sample = new SplitSample(Integer.parseInt(value));
            } else {
                assert (type.getType() == 1084);
                this.assertCombineInputFormat(numerator, "Total Length");
                long length = Integer.parseInt(value.substring(0, value.length() - 1));
                char last = value.charAt(value.length() - 1);
                if (last == 'k' || last == 'K') {
                    length <<= 10;
                } else if (last == 'm' || last == 'M') {
                    length <<= 20;
                } else if (last == 'g' || last == 'G') {
                    length <<= 30;
                }
                int seedNum = this.conf.getIntVar(HiveConf.ConfVars.HIVE_SAMPLE_RANDOM_NUM);
                sample = new SplitSample(length, seedNum);
            }
            String alias_id = this.getAliasId(alias, qb);
            this.nameToSplitSample.put(alias_id, sample);
        }
        qb.setTabAlias(alias, tabIdName);
        if (qb.isInsideView()) {
            qb.getAliasInsideView().add(alias.toLowerCase());
        }
        qb.addAlias(alias);
        qb.getParseInfo().setSrcForAlias(alias, tableTree);
        if (!this.aliasToCTEs.containsKey(tabIdName)) {
            this.unparseTranslator.addTableNameTranslation(tableTree, SessionState.get().getCurrentDatabase());
            if (aliasIndex != 0) {
                this.unparseTranslator.addIdentifierTranslation((ASTNode)tabref.getChild(aliasIndex));
            }
        }
        return alias;
    }

    private String getAsOfValue(ASTNode tabref, int asOfIndex) throws SemanticException {
        String asOfValue = null;
        if (asOfIndex != -1) {
            ASTNode expr = (ASTNode)tabref.getChild(asOfIndex).getChild(0);
            if (expr.getChildCount() > 0) {
                ExprNodeDesc desc = this.genExprNodeDesc(expr, new RowResolver(), false, true);
                ExprNodeConstantDesc c = (ExprNodeConstantDesc)desc;
                asOfValue = String.valueOf(c.getValue());
            } else {
                asOfValue = SemanticAnalyzer.stripQuotes(expr.getText());
            }
        }
        return asOfValue;
    }

    Map<String, SplitSample> getNameToSplitSampleMap() {
        return this.nameToSplitSample;
    }

    private void assertCombineInputFormat(Tree numerator, String message) throws SemanticException {
        String inputFormat;
        String string = inputFormat = this.conf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez") ? HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TEZ_INPUT_FORMAT) : HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_INPUT_FORMAT);
        if (!inputFormat.equals(CombineHiveInputFormat.class.getName())) {
            throw new SemanticException(SemanticAnalyzer.generateErrorMessage((ASTNode)numerator, message + " sampling is not supported in " + inputFormat));
        }
    }

    private String processSubQuery(QB qb, ASTNode subq) throws SemanticException {
        if (subq.getChildCount() != 2) {
            throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.NO_SUBQUERY_ALIAS.getMsg(), (ASTNode)subq));
        }
        ASTNode subqref = (ASTNode)subq.getChild(0);
        String alias = SemanticAnalyzer.unescapeIdentifier(subq.getChild(1).getText());
        QBExpr qbexpr = new QBExpr(alias, subqref);
        this.doPhase1QBExpr(subqref, qbexpr, qb.getId(), alias, qb.isInsideView(), null);
        if (qb.exists(alias)) {
            throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.AMBIGUOUS_TABLE_ALIAS.getMsg(), (Tree)subq.getChild(1)));
        }
        qb.setSubqAlias(alias, qbexpr);
        qb.addAlias(alias);
        this.unparseTranslator.addIdentifierTranslation((ASTNode)subq.getChild(1));
        return alias;
    }

    private void processLateralViewSelect(ASTNode lateralViewSelect) throws SemanticException {
        ASTNode selExprToken = (ASTNode)lateralViewSelect.getChild(0);
        if (selExprToken.getToken().getType() != 1198) {
            throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.LATERAL_VIEW_INVALID_CHILD.getMsg(), (ASTNode)selExprToken));
        }
        block5: for (Object o : selExprToken.getChildren()) {
            ASTNode node = (ASTNode)o;
            switch (node.getToken().getType()) {
                case 1039: {
                    continue block5;
                }
                case 24: {
                    this.unparseTranslator.addIdentifierTranslation(node);
                    continue block5;
                }
                case 1250: {
                    this.unparseTranslator.addIdentifierTranslation((ASTNode)node.getChild(0));
                    continue block5;
                }
            }
            throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.LATERAL_VIEW_INVALID_CHILD.getMsg(), (ASTNode)selExprToken));
        }
    }

    private void processCTE(QB qb, ASTNode ctes, Map<String, CTEClause> aliasToCTEs) throws SemanticException {
        int numCTEs = ctes.getChildCount();
        for (int i = 0; i < numCTEs; ++i) {
            ASTNode cte = (ASTNode)ctes.getChild(i);
            ASTNode cteQry = (ASTNode)cte.getChild(0);
            String alias = SemanticAnalyzer.unescapeIdentifier(cte.getChild(1).getText());
            ASTNode withColList = cte.getChildCount() == 3 ? (ASTNode)cte.getChild(2) : null;
            String qName = this.getAliasId(alias, qb);
            if (aliasToCTEs.containsKey(qName)) {
                throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.AMBIGUOUS_TABLE_ALIAS.getMsg(), (Tree)cte.getChild(1)));
            }
            aliasToCTEs.put(qName, new CTEClause(this, qName, cteQry, withColList));
        }
    }

    private CTEClause findCTEFromName(QB qb, String cteName, Map<String, CTEClause> aliasToCTEs) {
        StringBuilder qId = new StringBuilder();
        if (qb.getId() != null) {
            qId.append(qb.getId());
        }
        while (qId.length() > 0) {
            String nm = String.valueOf(qId) + ":" + cteName;
            CTEClause cte = aliasToCTEs.get(nm);
            if (cte != null) {
                return cte;
            }
            int lastIndex = qId.lastIndexOf(":");
            lastIndex = lastIndex < 0 ? 0 : lastIndex;
            qId.setLength(lastIndex);
        }
        return aliasToCTEs.get(cteName);
    }

    private void addCTEAsSubQuery(QB qb, String cteName, String cteAlias) throws SemanticException {
        cteAlias = cteAlias == null ? cteName : cteAlias;
        CTEClause cte = this.findCTEFromName(qb, cteName, this.aliasToCTEs);
        ASTNode cteQryNode = cte.cteNode;
        QBExpr cteQBExpr = new QBExpr(cteAlias);
        this.doPhase1QBExpr(cteQryNode, cteQBExpr, qb.getId(), cteAlias, cte.withColList);
        qb.rewriteCTEToSubq(cteAlias, cteName, cteQBExpr);
    }

    @Override
    public List<Task<?>> getAllRootTasks() {
        if (!this.rootTasksResolved) {
            LinkedHashMap<CTEClause, LinkedHashSet<CTEClause>> realDependencies = this.listRealDependencies();
            this.linkRealDependencies(realDependencies);
            this.rootTasks = this.toRealRootTasks(realDependencies);
            this.rootTasksResolved = true;
        }
        return this.rootTasks;
    }

    @Override
    public Set<ReadEntity> getAllInputs() {
        HashSet<ReadEntity> readEntities = new HashSet<ReadEntity>(this.getInputs());
        for (CTEClause cte : this.rootClause.asExecutionOrder()) {
            if (cte.source == null) continue;
            readEntities.addAll(cte.source.getInputs());
        }
        return readEntities;
    }

    @Override
    public Set<WriteEntity> getAllOutputs() {
        HashSet<WriteEntity> writeEntities = new HashSet<WriteEntity>(this.getOutputs());
        for (CTEClause cte : this.rootClause.asExecutionOrder()) {
            if (cte.source == null) continue;
            writeEntities.addAll(cte.source.getOutputs());
        }
        return writeEntities;
    }

    private List<Task<?>> getRealTasks(CTEClause cte) {
        if (cte == this.rootClause) {
            return this.rootTasks;
        }
        return cte.getTasks();
    }

    private void linkRealDependencies(LinkedHashMap<CTEClause, LinkedHashSet<CTEClause>> realDependencies) {
        LinkedHashMap dependentTasks = new LinkedHashMap();
        for (CTEClause child : realDependencies.keySet()) {
            for (CTEClause parent : realDependencies.get(child)) {
                if (!dependentTasks.containsKey(parent)) {
                    dependentTasks.put(parent, new ArrayList());
                }
                ((List)dependentTasks.get(parent)).addAll(this.getRealTasks(child));
            }
        }
        for (CTEClause parent : dependentTasks.keySet()) {
            List<Task<?>> sources = Task.findLeafs(this.getRealTasks(parent));
            SemanticAnalyzer.linkTasks(sources, (Iterable)dependentTasks.get(parent));
        }
    }

    private static void linkTasks(List<Task<?>> sources, Iterable<Task<?>> sinks) {
        for (Task<?> source : sources) {
            for (Task<?> sink : sinks) {
                source.addDependentTask(sink);
            }
        }
    }

    private List<Task<?>> toRealRootTasks(LinkedHashMap<CTEClause, LinkedHashSet<CTEClause>> realDependencies) {
        ArrayList realRootTasks = new ArrayList();
        for (CTEClause cte : realDependencies.keySet()) {
            if (!realDependencies.get(cte).isEmpty()) continue;
            realRootTasks.addAll(this.getRealTasks(cte));
        }
        return realRootTasks;
    }

    private LinkedHashMap<CTEClause, LinkedHashSet<CTEClause>> listRealDependencies() {
        LinkedHashMap<CTEClause, LinkedHashSet<CTEClause>> realDependencies = new LinkedHashMap<CTEClause, LinkedHashSet<CTEClause>>();
        for (CTEClause child : this.rootClause.asExecutionOrder()) {
            if (this.getRealTasks(child) == null) continue;
            LinkedHashSet<CTEClause> parents = new LinkedHashSet<CTEClause>();
            this.collectRealDependencies(child, parents);
            realDependencies.put(child, parents);
        }
        return realDependencies;
    }

    private void collectRealDependencies(CTEClause cte, LinkedHashSet<CTEClause> realDependencies) {
        for (CTEClause parent : cte.parents) {
            if (this.getRealTasks(parent) == null) {
                this.collectRealDependencies(parent, realDependencies);
                continue;
            }
            realDependencies.add(parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    org.apache.hadoop.hive.ql.metadata.Table materializeCTE(String cteName, CTEClause cte) throws HiveException {
        ASTNode createTable = new ASTNode((Token)new ClassicToken(961));
        ASTNode tableName = new ASTNode((Token)new ClassicToken(1279));
        tableName.addChild((Tree)new ASTNode((Token)new ClassicToken(24, cteName)));
        ASTNode temporary = new ASTNode((Token)new ClassicToken(355, MATERIALIZATION_MARKER));
        createTable.addChild((Tree)tableName);
        createTable.addChild((Tree)temporary);
        createTable.addChild((Tree)cte.cteNode);
        SemanticAnalyzer analyzer = new SemanticAnalyzer(this.queryState);
        analyzer.initCtx(this.ctx);
        analyzer.init(false);
        analyzer.aliasToCTEs.putAll(this.aliasToCTEs);
        HiveOperation operation = this.queryState.getHiveOperation();
        try {
            analyzer.analyzeInternal(createTable);
        }
        finally {
            this.queryState.setCommandType(operation);
        }
        org.apache.hadoop.hive.ql.metadata.Table table = analyzer.tableDesc.toTable(this.conf);
        Path location = table.getDataLocation();
        try {
            location.getFileSystem((Configuration)this.conf).mkdirs(location);
        }
        catch (IOException e) {
            throw new HiveException((Throwable)e);
        }
        table.setMaterializedTable(true);
        this.LOG.info("{} will be materialized into {}", (Object)cteName, (Object)location);
        cte.source = analyzer;
        this.ctx.addMaterializedTable(cteName, table, this.getMaterializedTableStats(analyzer.getSinkOp()));
        return table;
    }

    protected Statistics getMaterializedTableStats(Operator<?> sinkOp) {
        Statistics tableStats = sinkOp.getStatistics().clone();
        if (tableStats.getColumnStatsState() == Statistics.State.NONE || sinkOp.getNumParent() == 0) {
            return tableStats;
        }
        List<String> parentColumnNames = sinkOp.getParentOperators().get(0).getSchema().getColumnNames();
        List<String> childColumnNames = sinkOp.getSchema().getColumnNames();
        if (parentColumnNames.size() != childColumnNames.size()) {
            this.LOG.warn("The number of columns of FileSinkOperator is inconsistent. Parent = {}, Child = {}", parentColumnNames, childColumnNames);
            tableStats.setColumnStatsState(Statistics.State.NONE);
            return tableStats;
        }
        HashMap<String, String> mapping = new HashMap<String, String>(parentColumnNames.size());
        for (int i = 0; i < parentColumnNames.size(); ++i) {
            mapping.put(parentColumnNames.get(i), childColumnNames.get(i));
        }
        List<ColStatistics> colStatsList = tableStats.getColumnStats();
        if (!mapping.keySet().equals(colStatsList.stream().map(ColStatistics::getColumnName).collect(Collectors.toSet()))) {
            this.LOG.warn("The column statistics are inconsistent with the expected column names. Actual = {}, Expected = {}", colStatsList, parentColumnNames);
            tableStats.setColumnStatsState(Statistics.State.NONE);
            return tableStats;
        }
        for (ColStatistics colStats : colStatsList) {
            colStats.setColumnName((String)mapping.get(colStats.getColumnName()));
        }
        tableStats.setColumnStats(colStatsList);
        return tableStats;
    }

    static boolean isJoinToken(ASTNode node) {
        return node.getToken().getType() == 1077 || node.getToken().getType() == 970 || SemanticAnalyzer.isOuterJoinToken(node) || node.getToken().getType() == 1083 || node.getToken().getType() == 1081 || node.getToken().getType() == 1305;
    }

    private static boolean isOuterJoinToken(ASTNode node) {
        return node.getToken().getType() == 1082 || node.getToken().getType() == 1189 || node.getToken().getType() == 1038;
    }

    private void processJoin(QB qb, ASTNode join) throws SemanticException {
        int numChildren = join.getChildCount();
        if (numChildren != 2 && numChildren != 3 && numChildren != 4 && join.getToken().getType() != 1305) {
            throw new SemanticException(SemanticAnalyzer.generateErrorMessage(join, "Join with multiple children"));
        }
        this.queryProperties.incrementJoinCount(SemanticAnalyzer.isOuterJoinToken(join));
        for (int num = 0; num < numChildren; ++num) {
            ASTNode child = (ASTNode)join.getChild(num);
            if (child.getToken().getType() == 1280) {
                this.processTable(qb, child);
                continue;
            }
            if (child.getToken().getType() == 1242) {
                this.processSubQuery(qb, child);
                continue;
            }
            if (child.getToken().getType() == 1159) {
                String inputAlias;
                this.queryProperties.setHasPTF(true);
                this.processPTF(qb, child);
                PTFInvocationSpec ptfInvocationSpec = qb.getPTFInvocationSpec(child);
                String string = inputAlias = ptfInvocationSpec == null ? null : ptfInvocationSpec.getFunction().getAlias();
                if (inputAlias != null) continue;
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage(child, "PTF invocation in a Join must have an alias"));
            }
            if (child.getToken().getType() == 1079 || child.getToken().getType() == 1080) {
                throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.LATERAL_VIEW_WITH_JOIN.getMsg(), (ASTNode)join));
            }
            if (!SemanticAnalyzer.isJoinToken(child)) continue;
            this.processJoin(qb, child);
        }
    }

    private String processLateralView(QB qb, ASTNode lateralView) throws SemanticException {
        int numChildren = lateralView.getChildCount();
        assert (numChildren == 2);
        if (!this.isCBOSupportedLateralView(lateralView)) {
            this.queryProperties.setCBOSupportedLateralViews(false);
        }
        ASTNode next = (ASTNode)lateralView.getChild(1);
        String alias = null;
        switch (next.getToken().getType()) {
            case 1280: {
                alias = this.processTable(qb, next);
                break;
            }
            case 1242: {
                alias = this.processSubQuery(qb, next);
                break;
            }
            case 1079: 
            case 1080: {
                alias = this.processLateralView(qb, next);
                break;
            }
            default: {
                throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.LATERAL_VIEW_INVALID_CHILD.getMsg(), (ASTNode)lateralView));
            }
        }
        this.processLateralViewSelect((ASTNode)lateralView.getChild(0));
        alias = alias.toLowerCase();
        qb.getParseInfo().addLateralViewForAlias(alias, lateralView);
        qb.addAlias(alias);
        return alias;
    }

    protected boolean doPhase1(ASTNode ast, QB qb, Phase1Ctx ctx_1, PlannerContext plannerCtx) throws SemanticException {
        return this.doPhase1(ast, qb, ctx_1, plannerCtx, this.aliasToCTEs);
    }

    boolean doPhase1(ASTNode ast, QB qb, Phase1Ctx ctx_1, PlannerContext plannerCtx, Map<String, CTEClause> aliasToCTEs) throws SemanticException {
        boolean phase1Result = true;
        QBParseInfo qbp = qb.getParseInfo();
        boolean skipRecursion = false;
        if (ast.getToken() != null) {
            skipRecursion = true;
            switch (ast.getToken().getType()) {
                case 1197: {
                    qb.countSelDi();
                }
                case 1196: {
                    qb.countSel();
                    qbp.setSelExprForClause(ctx_1.dest, ast);
                    int posn = 0;
                    if (((ASTNode)ast.getChild(0)).getType() == 430) {
                        posn = this.processQueryHint((ASTNode)ast.getChild(0), qbp, posn);
                    }
                    if (ast.getChild(posn).getChild(0).getType() == 1293) {
                        this.queryProperties.setUsesScript(true);
                    }
                    Map<String, ASTNode> aggregations = this.doPhase1GetAggregationsFromSelect(ast, qb, ctx_1.dest);
                    this.doPhase1GetColumnAliasesFromSelect(ast, qbp, ctx_1.dest);
                    qbp.setAggregationExprsForClause(ctx_1.dest, aggregations);
                    qbp.setDistinctFuncExprsForClause(ctx_1.dest, this.doPhase1GetDistinctFuncExprs(aggregations));
                    break;
                }
                case 1323: {
                    qbp.setWhrExprForClause(ctx_1.dest, ast);
                    if (!SubQueryUtils.findSubQueries((ASTNode)ast.getChild(0)).isEmpty()) {
                        this.queryProperties.setFilterWithSubQuery(true);
                    }
                    this.doPhase1WhereClause(ast, qb);
                    break;
                }
                case 1060: {
                    String currentDatabase = SessionState.get().getCurrentDatabase();
                    String tab_name = SemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0).getChild(0), currentDatabase);
                    qbp.addInsertIntoTable(tab_name, ast);
                    this.setSqlKind(SqlKind.INSERT);
                }
                case 998: {
                    ctx_1.dest = this.ctx.getDestNamePrefix(ast, qb).toString() + ctx_1.nextNum;
                    ++ctx_1.nextNum;
                    boolean isTmpFileDest = false;
                    if (ast.getChildCount() > 0 && ast.getChild(0) instanceof ASTNode) {
                        ASTNode ch = (ASTNode)ast.getChild(0);
                        if (ch.getToken().getType() == 1000 && ch.getChildCount() > 0 && ch.getChild(0) instanceof ASTNode) {
                            boolean bl = isTmpFileDest = (ch = (ASTNode)ch.getChild(0)).getToken().getType() == 1291;
                            if (ch.getToken().getType() == 439) {
                                qbp.setInsertOverwriteDirectory(true);
                                this.queryProperties.setQueryType(QueryProperties.QueryType.DML);
                                this.setSqlKind(SqlKind.INSERT);
                            }
                        } else if (ast.getToken().getType() == 998 && ast.getChild(0).getType() == 1249) {
                            String fullTableName = SemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0).getChild(0), SessionState.get().getCurrentDatabase());
                            qbp.getInsertOverwriteTables().put(fullTableName.toLowerCase(), ast);
                            qbp.setDestToOpType(ctx_1.dest, true);
                            this.setSqlKind(SqlKind.INSERT);
                        }
                    }
                    if (qbp.getIsSubQ() && !isTmpFileDest) {
                        throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.NO_INSERT_INSUBQUERY.getMsg(), (ASTNode)ast));
                    }
                    qbp.setDestForClause(ctx_1.dest, (ASTNode)ast.getChild(0));
                    this.handleInsertStatementSpecPhase1(ast, qbp, ctx_1);
                    if (qbp.getClauseNamesForDest().size() == 2) {
                        this.queryProperties.setMultiDestQuery(true);
                    }
                    if (plannerCtx != null && !this.queryProperties.hasMultiDestQuery()) {
                        plannerCtx.setInsertToken(ast, isTmpFileDest);
                        break;
                    }
                    if (plannerCtx == null || qbp.getClauseNamesForDest().size() != 2) break;
                    plannerCtx.resetToken();
                    plannerCtx.setMultiInsertToken((ASTNode)qbp.getQueryFrom().getChild(0));
                    break;
                }
                case 1036: {
                    ASTNode frm;
                    int child_count = ast.getChildCount();
                    if (child_count != 1) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, "Multiple Children " + child_count));
                    }
                    if (!qbp.getIsSubQ()) {
                        qbp.setQueryFromExpr(ast);
                    }
                    if ((frm = (ASTNode)ast.getChild(0)).getToken().getType() == 1280) {
                        this.processTable(qb, frm);
                        break;
                    }
                    if (frm.getToken().getType() == 1242) {
                        this.processSubQuery(qb, frm);
                        break;
                    }
                    if (frm.getToken().getType() == 1079 || frm.getToken().getType() == 1080) {
                        this.queryProperties.setHasLateralViews(true);
                        this.processLateralView(qb, frm);
                        break;
                    }
                    if (SemanticAnalyzer.isJoinToken(frm)) {
                        this.processJoin(qb, frm);
                        qbp.setJoinExpr(frm);
                        break;
                    }
                    if (frm.getToken().getType() != 1159) break;
                    this.queryProperties.setHasPTF(true);
                    this.processPTF(qb, frm);
                    break;
                }
                case 946: {
                    this.queryProperties.setHasClusterBy(true);
                    qbp.setClusterByExprForClause(ctx_1.dest, ast);
                    break;
                }
                case 1002: {
                    this.queryProperties.setHasDistributeBy(true);
                    qbp.setDistributeByExprForClause(ctx_1.dest, ast);
                    if (qbp.getClusterByForClause(ctx_1.dest) != null) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, ErrorMsg.CLUSTERBY_DISTRIBUTEBY_CONFLICT.getMsg()));
                    }
                    if (qbp.getOrderByForClause(ctx_1.dest) == null) break;
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, ErrorMsg.ORDERBY_DISTRIBUTEBY_CONFLICT.getMsg()));
                }
                case 1235: {
                    this.queryProperties.setHasSortBy(true);
                    qbp.setSortByExprForClause(ctx_1.dest, ast);
                    if (qbp.getClusterByForClause(ctx_1.dest) != null) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, ErrorMsg.CLUSTERBY_SORTBY_CONFLICT.getMsg()));
                    }
                    if (qbp.getOrderByForClause(ctx_1.dest) == null) break;
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, ErrorMsg.ORDERBY_SORTBY_CONFLICT.getMsg()));
                }
                case 1130: {
                    this.queryProperties.setHasOrderBy(true);
                    qbp.setOrderByExprForClause(ctx_1.dest, ast);
                    if (qbp.getClusterByForClause(ctx_1.dest) != null) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, ErrorMsg.CLUSTERBY_ORDERBY_CONFLICT.getMsg()));
                    }
                    qbp.addAggregationExprsForClause(ctx_1.dest, this.doPhase1GetAggregationsFromSelect(ast, qb, ctx_1.dest));
                    break;
                }
                case 972: 
                case 1048: 
                case 1049: 
                case 1192: {
                    this.queryProperties.setHasGroupBy(true);
                    if (qbp.getJoinExpr() != null) {
                        this.queryProperties.setHasJoinFollowedByGroupBy(true);
                    }
                    qbp.setGroupByExprForClause(ctx_1.dest, ast);
                    skipRecursion = true;
                    if (ast.getToken().getType() == 1192) {
                        qbp.getDestRollups().add(ctx_1.dest);
                        break;
                    }
                    if (ast.getToken().getType() == 972) {
                        qbp.getDestCubes().add(ctx_1.dest);
                        break;
                    }
                    if (ast.getToken().getType() != 1049) break;
                    qbp.getDestGroupingSets().add(ctx_1.dest);
                    break;
                }
                case 1051: {
                    qbp.setHavingExprForClause(ctx_1.dest, ast);
                    qbp.addAggregationExprsForClause(ctx_1.dest, this.doPhase1GetAggregationsFromSelect(ast, qb, ctx_1.dest));
                    qbp.setDistinctFuncExprsForClause(ctx_1.dest, this.doPhase1GetDistinctFuncExprs(qbp.getAggregationExprsForClause(ctx_1.dest)));
                    break;
                }
                case 1160: {
                    this.queryProperties.setHasQualify(true);
                    qbp.setQualifyExprForClause(ctx_1.dest, ast);
                    qbp.addAggregationExprsForClause(ctx_1.dest, this.doPhase1GetAggregationsFromSelect(ast, qb, ctx_1.dest));
                    break;
                }
                case 408: {
                    if (!qb.hasWindowingSpec(ctx_1.dest)) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, "Query has no Cluster/Distribute By; but has a Window definition"));
                    }
                    this.handleQueryWindowClauses(qb, ctx_1, ast);
                    break;
                }
                case 1088: {
                    this.queryProperties.setHasLimit(true);
                    if (ast.getChildCount() == 2) {
                        qbp.setDestLimit(ctx_1.dest, Integer.valueOf(ast.getChild(0).getText()), Integer.valueOf(ast.getChild(1).getText()));
                        break;
                    }
                    qbp.setDestLimit(ctx_1.dest, 0, Integer.valueOf(ast.getChild(0).getText()));
                    break;
                }
                case 929: {
                    String table_name = SemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0).getChild(0)).toLowerCase();
                    qb.setTabAlias(table_name, table_name);
                    qb.addAlias(table_name);
                    qb.getParseInfo().setIsAnalyzeCommand(true);
                    qb.getParseInfo().setNoScanAnalyzeCommand(this.noscan);
                    HiveConf.setVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.DYNAMIC_PARTITIONING_MODE, (String)"nonstrict");
                    HiveConf.setVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAPRED_MODE, (String)"nonstrict");
                    break;
                }
                case 1301: {
                    if (!qbp.getIsSubQ()) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, ErrorMsg.UNION_NOTIN_SUBQ.getMsg()));
                    }
                    skipRecursion = false;
                    break;
                }
                case 1059: {
                    ASTNode destination = (ASTNode)ast.getChild(0);
                    Tree tab = destination.getChild(0);
                    if (destination.getChildCount() == 2 && tab.getChildCount() == 2 && destination.getChild(1).getType() == 1055) {
                        String tableName = SemanticAnalyzer.getUnescapedName((ASTNode)tab.getChild(0), SessionState.get().getCurrentDatabase());
                        Tree partitions = tab.getChild(1);
                        int childCount = partitions.getChildCount();
                        HashMap<String, String> partition = new HashMap<String, String>();
                        for (int i = 0; i < childCount; ++i) {
                            String partitionName = partitions.getChild(i).getChild(0).getText();
                            partitionName = partitionName.toLowerCase();
                            Tree pvalue = partitions.getChild(i).getChild(1);
                            if (pvalue == null) break;
                            String partitionVal = SemanticAnalyzer.stripQuotes(pvalue.getText());
                            partition.put(partitionName, partitionVal);
                        }
                        if (childCount != partition.size()) {
                            throw new SemanticException(ErrorMsg.INSERT_INTO_DYNAMICPARTITION_IFNOTEXISTS.getMsg(((Object)partition).toString()));
                        }
                        org.apache.hadoop.hive.ql.metadata.Table table = null;
                        try {
                            table = this.getTableObjectByName(tableName);
                        }
                        catch (HiveException ex) {
                            throw new SemanticException((Throwable)ex);
                        }
                        try {
                            org.apache.hadoop.hive.ql.metadata.Partition parMetaData = this.db.getPartition(table, partition, false);
                            if (parMetaData != null) {
                                phase1Result = false;
                                skipRecursion = true;
                                this.LOG.info("Partition already exists so insert into overwrite skipped for partition : {}", (Object)parMetaData);
                                break;
                            }
                        }
                        catch (HiveException e) {
                            this.LOG.info("Error while getting metadata : ", (Throwable)e);
                        }
                        SemanticAnalyzer.validatePartSpec(table, partition, (ASTNode)tab, this.conf, false);
                    }
                    skipRecursion = false;
                    break;
                }
                case 1079: 
                case 1080: {
                    assert (ast.getChildCount() == 1);
                    qb.getParseInfo().getDestToLateralView().put(ctx_1.dest, ast);
                    break;
                }
                case 971: {
                    this.processCTE(qb, ast, aliasToCTEs);
                    break;
                }
                case 430: {
                    this.processQueryHint(ast, qbp, 0);
                }
                default: {
                    skipRecursion = false;
                }
            }
        }
        if (!skipRecursion) {
            int child_count = ast.getChildCount();
            for (int child_pos = 0; child_pos < child_count && phase1Result; ++child_pos) {
                phase1Result = this.doPhase1((ASTNode)ast.getChild(child_pos), qb, ctx_1, plannerCtx, aliasToCTEs);
            }
        }
        return phase1Result;
    }

    private int processQueryHint(ASTNode ast, QBParseInfo qbp, int posn) throws SemanticException {
        ParseDriver pd = new ParseDriver();
        String queryHintStr = ast.getText();
        this.LOG.debug("QUERY HINT: {} ", (Object)queryHintStr);
        try {
            ASTNode hintNode = pd.parseHint(queryHintStr);
            qbp.setHints(hintNode);
        }
        catch (ParseException e) {
            throw new SemanticException("failed to parse query hint: " + e.getMessage(), (Throwable)e);
        }
        return posn + 1;
    }

    private void handleInsertStatementSpecPhase1(ASTNode ast, QBParseInfo qbp, Phase1Ctx ctx_1) throws SemanticException {
        boolean hasSpecificColumns;
        ASTNode tabColName = (ASTNode)ast.getChild(1);
        boolean bl = hasSpecificColumns = tabColName != null && tabColName.getType() == 1253;
        if (ast.getType() == 1060) {
            org.apache.hadoop.hive.ql.metadata.Table targetTable;
            ArrayList<String> targetColumnNames;
            String fullTableName = SemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0).getChild(0), SessionState.get().getCurrentDatabase());
            List<Object> list = targetColumnNames = hasSpecificColumns ? this.processTableColumnNames(tabColName, fullTableName) : new ArrayList();
            if (hasSpecificColumns) {
                qbp.setDestSchemaForClause(ctx_1.dest, targetColumnNames);
            }
            try {
                targetTable = this.getTableObjectByName(fullTableName);
            }
            catch (HiveException ex) {
                this.LOG.error("Error processing HiveParser.TOK_DESTINATION: " + ex.getMessage(), (Throwable)ex);
                throw new SemanticException((Throwable)ex);
            }
            if (targetTable == null) {
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, "Unable to access metadata for table " + fullTableName));
            }
            ColumnAccessInfo cai = new ColumnAccessInfo();
            if (!hasSpecificColumns) {
                for (FieldSchema col : targetTable.getCols()) {
                    targetColumnNames.add(col.getName());
                }
            }
            String completeTableName = targetTable.getCompleteName();
            for (String string : targetColumnNames) {
                cai.add(completeTableName, string);
            }
            this.setUpdateColumnAccessInfo(cai);
            HashSet<String> targetColumns = new HashSet<String>(targetColumnNames);
            for (FieldSchema f : targetTable.getCols()) {
                targetColumns.remove(f.getName());
            }
            if (!targetColumns.isEmpty()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                if (ast.getChild(0) != null && ast.getChild(0).getType() == 1249) {
                    ASTNode tokTab = (ASTNode)ast.getChild(0);
                    ASTNode tokPartSpec = (ASTNode)tokTab.getFirstChildWithType(1136);
                    if (tokPartSpec != null) {
                        for (Node n : tokPartSpec.getChildren()) {
                            ASTNode tokPartVal = null;
                            if (n instanceof ASTNode) {
                                tokPartVal = (ASTNode)n;
                            }
                            if (tokPartVal == null || tokPartVal.getType() != 1137 || tokPartVal.getChildCount() != 1) continue;
                            assert (tokPartVal.getChild(0).getType() == 24) : "Expected column name; found tokType=" + tokPartVal.getType();
                            arrayList.add(tokPartVal.getChild(0).getText());
                        }
                        for (String colName : arrayList) {
                            targetColumns.remove(colName);
                        }
                    } else {
                        for (FieldSchema f : targetTable.getPartCols()) {
                            targetColumns.remove(f.getName());
                        }
                    }
                }
                if (!targetColumns.isEmpty()) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(tabColName, "'" + String.valueOf(targetColumns.size() == 1 ? targetColumns.iterator().next() : targetColumns) + "' in insert schema specification " + (targetColumns.size() == 1 ? "is" : "are") + " not found among regular columns of " + fullTableName + " nor dynamic partition columns."));
                }
            }
        }
    }

    protected List<String> processTableColumnNames(ASTNode tabColName, String tableName) throws SemanticException {
        if (tabColName == null) {
            return Collections.emptyList();
        }
        ArrayList<String> targetColNames = new ArrayList<String>(tabColName.getChildren().size());
        for (Node col : tabColName.getChildren()) {
            assert (((ASTNode)col).getType() == 24) : "expected token 24 found " + ((ASTNode)col).getType();
            targetColNames.add(((ASTNode)col).getText().toLowerCase());
        }
        HashSet targetColumns = new HashSet(targetColNames);
        if (targetColNames.size() != targetColumns.size()) {
            throw new SemanticException(SemanticAnalyzer.generateErrorMessage(tabColName, "Duplicate column name detected in " + tableName + " table schema specification"));
        }
        return targetColNames;
    }

    private Map<String, CTEClause> getMaterializationMetadata(QB qb) throws SemanticException {
        if (qb.isCTAS()) {
            return null;
        }
        HashMap<String, CTEClause> materializationAliasToCTEs = new HashMap<String, CTEClause>(this.aliasToCTEs);
        try {
            this.gatherCTEReferences(qb, this.rootClause, materializationAliasToCTEs);
            int threshold = HiveConf.getIntVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CTE_MATERIALIZE_THRESHOLD);
            for (CTEClause cte : Sets.newHashSet(materializationAliasToCTEs.values())) {
                if (threshold < 0 || cte.reference < threshold) continue;
                cte.materialize = !HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CTE_MATERIALIZE_FULL_AGGREGATE_ONLY) || cte.qbExpr.getQB().getParseInfo().isFullyAggregate();
            }
        }
        catch (HiveException e) {
            this.LOG.error("Failed to get Materialization Metadata", (Throwable)e);
            if (e instanceof SemanticException) {
                throw (SemanticException)((Object)e);
            }
            throw new SemanticException(e.getMessage(), (Throwable)e);
        }
        return materializationAliasToCTEs;
    }

    private void gatherCTEReferences(QBExpr qbexpr, CTEClause parent, Map<String, CTEClause> materializationAliasToCTEs) throws HiveException {
        if (qbexpr.getOpcode() == QBExpr.Opcode.NULLOP) {
            this.gatherCTEReferences(qbexpr.getQB(), parent, materializationAliasToCTEs);
        } else {
            this.gatherCTEReferences(qbexpr.getQBExpr1(), parent, materializationAliasToCTEs);
            this.gatherCTEReferences(qbexpr.getQBExpr2(), parent, materializationAliasToCTEs);
        }
    }

    private void gatherCTEReferences(QB qb, CTEClause current, Map<String, CTEClause> materializationAliasToCTEs) throws HiveException {
        for (String alias : qb.getTabAliases()) {
            String tabName = qb.getTabNameForAlias(alias);
            String cteName = tabName.toLowerCase();
            CTEClause cte = this.findCTEFromName(qb, cteName, materializationAliasToCTEs);
            if (cte == null) continue;
            ++cte.reference;
            current.parents.add(cte);
            if (cte.qbExpr != null) continue;
            cte.qbExpr = new QBExpr(cteName);
            this.doPhase1QBExpr(cte.cteNode, cte.qbExpr, qb.getId(), cteName, cte.withColList, materializationAliasToCTEs);
            this.gatherCTEReferences(cte.qbExpr, cte, materializationAliasToCTEs);
        }
        for (String alias : qb.getSubqAliases()) {
            this.gatherCTEReferences(qb.getSubqForAlias(alias), current, materializationAliasToCTEs);
        }
        for (String alias : qb.getSubqExprAliases()) {
            this.gatherCTEReferences(qb.getSubqExprForAlias(alias), current, materializationAliasToCTEs);
        }
    }

    private void checkRecursiveCTE(CTEClause current, Set<String> path) throws SemanticException {
        for (CTEClause child : current.parents) {
            if (path.contains(child.alias)) {
                throw new SemanticException("Recursive cte " + child.alias + " detected (cycle: " + StringUtils.join(path, (String)" -> ") + " -> " + child.alias + ").");
            }
            path.add(child.alias);
            this.checkRecursiveCTE(child, path);
            path.remove(child.alias);
        }
    }

    void getMetaData(QB qb) throws SemanticException {
        this.getMetaData(qb, false);
    }

    protected void getMetaData(QB qb, boolean enableMaterialization) throws SemanticException {
        try {
            Map<String, CTEClause> materializationAliasToCTEs = null;
            if (enableMaterialization) {
                materializationAliasToCTEs = this.getMaterializationMetadata(qb);
            }
            this.checkRecursiveCTE(this.rootClause, new HashSet<String>());
            this.getMetaData(qb, null);
            if (materializationAliasToCTEs != null && !materializationAliasToCTEs.isEmpty()) {
                this.aliasToCTEs.putAll(materializationAliasToCTEs);
            }
        }
        catch (HiveException e) {
            if (e instanceof SemanticException) {
                throw (SemanticException)((Object)e);
            }
            throw new SemanticException(e.getMessage(), (Throwable)e);
        }
    }

    private void getMetaData(QBExpr qbexpr, ReadEntity parentInput) throws HiveException {
        if (qbexpr.getOpcode() == QBExpr.Opcode.NULLOP) {
            this.getMetaData(qbexpr.getQB(), parentInput);
        } else {
            this.getMetaData(qbexpr.getQBExpr1(), parentInput);
            this.getMetaData(qbexpr.getQBExpr2(), parentInput);
        }
    }

    private void getMetaData(QB qb, ReadEntity parentInput) throws HiveException {
        BaseSemanticAnalyzer.TableSpec ts;
        this.LOG.info("Get metadata for source tables");
        ArrayList<String> tabAliases = new ArrayList<String>(qb.getTabAliases());
        HashMap<String, Pair> aliasToViewInfo = new HashMap<String, Pair>();
        HashMap<String, String> sqAliasToCTEName = new HashMap<String, String>();
        for (String alias : tabAliases) {
            org.apache.hadoop.hive.ql.metadata.Table tab;
            String tabName = qb.getTabNameForAlias(alias);
            String cteName = tabName.toLowerCase();
            org.apache.hadoop.hive.ql.metadata.Table table = tab = this.aliasToCTEs.containsKey(tabName) ? null : this.getTableObjectByName(tabName, false);
            if (tab != null) {
                org.apache.hadoop.hive.ql.metadata.Table newTab;
                tab = newTab = tab.makeCopy();
            }
            if (tab == null || tab.getDbName().equals(SessionState.get().getCurrentDatabase())) {
                org.apache.hadoop.hive.ql.metadata.Table materializedTab = this.ctx.getMaterializedTable(cteName);
                if (materializedTab == null) {
                    CTEClause cte = this.findCTEFromName(qb, cteName, this.aliasToCTEs);
                    if (cte != null) {
                        if (!cte.materialize) {
                            this.addCTEAsSubQuery(qb, cteName, alias);
                            sqAliasToCTEName.put(alias, cteName);
                            continue;
                        }
                        tab = this.materializeCTE(cteName, cte);
                    }
                } else {
                    tab = materializedTab;
                }
            }
            if (tab == null) {
                if (tabName.equals("_dummy_database._dummy_table")) continue;
                ASTNode src = qb.getParseInfo().getSrcForAlias(alias);
                if (null != src) {
                    if (src.getChildCount() == 3) {
                        throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg() + " '" + src.getChild(2).getText() + "'");
                    }
                    throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_TABLE.getMsg(), (ASTNode)src));
                }
                throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(alias));
            }
            QBSystemVersion asOf = qb.getSystemVersionForAlias(alias);
            if (asOf != null) {
                if (!Optional.ofNullable(tab.getStorageHandler()).map(HiveStorageHandler::isTimeTravelAllowed).orElse(false).booleanValue()) {
                    throw new SemanticException(ErrorMsg.TIME_TRAVEL_NOT_ALLOWED, new String[]{alias});
                }
                tab.setAsOfVersion(asOf.getAsOfVersion());
                tab.setVersionIntervalFrom(asOf.getFromVersion());
                tab.setAsOfTimestamp(asOf.getAsOfTime());
            }
            if (tab.isView()) {
                if (qb.getParseInfo().isAnalyzeCommand()) {
                    throw new SemanticException(ErrorMsg.ANALYZE_VIEW.getMsg());
                }
                String fullViewName = tab.getFullyQualifiedName();
                if (this.viewsExpanded.contains(fullViewName)) {
                    throw new SemanticException("Recursive view " + fullViewName + " detected (cycle: " + StringUtils.join(this.viewsExpanded, (String)" -> ") + " -> " + fullViewName + ").");
                }
                this.replaceViewReferenceWithDefinition(qb, tab, tabName, alias);
                if (qb.isInsideView() && parentInput == null) {
                    parentInput = PlanUtils.getParentViewInfo(this.getAliasId(alias, qb), this.viewAliasToInput);
                }
                ReadEntity viewInput = new ReadEntity(tab, parentInput, !qb.isInsideView());
                viewInput = PlanUtils.addInput(this.inputs, viewInput);
                aliasToViewInfo.put(alias, Pair.of((Object)fullViewName, (Object)viewInput));
                String aliasId = this.getAliasId(alias, qb);
                if (aliasId != null) {
                    aliasId = aliasId.replace(SUBQUERY_TAG_1, "").replace(SUBQUERY_TAG_2, "");
                }
                this.viewAliasToInput.put(aliasId, viewInput);
                continue;
            }
            if (!InputFormat.class.isAssignableFrom(tab.getInputFormatClass())) {
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage(qb.getParseInfo().getSrcForAlias(alias), ErrorMsg.INVALID_INPUT_FORMAT_TYPE.getMsg()));
            }
            qb.getMetaData().setSrcForAlias(alias, tab);
            if (qb.getParseInfo().isAnalyzeCommand()) {
                ts = new BaseSemanticAnalyzer.TableSpec(this.db, this.conf, (ASTNode)this.ast.getChild(0), true, this.noscan);
                if (ts.specType == BaseSemanticAnalyzer.TableSpec.SpecType.DYNAMIC_PARTITION) {
                    try {
                        ts.partitions = this.db.getPartitionsByNames(ts.tableHandle, ts.partSpec);
                    }
                    catch (HiveException e) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(qb.getParseInfo().getSrcForAlias(alias), "Cannot get partitions for " + String.valueOf(ts.partSpec)), (Throwable)e);
                    }
                }
                tab.setTableSpec(ts);
                qb.getParseInfo().addTableSpec(alias, ts);
            }
            ReadEntity parentViewInfo = PlanUtils.getParentViewInfo(this.getAliasId(alias, qb), this.viewAliasToInput);
            if (PlanUtils.isValuesTempTable(alias)) continue;
            PlanUtils.addInput(this.inputs, new ReadEntity(tab, parentViewInfo, parentViewInfo == null), this.mergeIsDirect);
        }
        this.LOG.info("Get metadata for subqueries");
        for (String alias : qb.getSubqAliases()) {
            boolean wasView = aliasToViewInfo.containsKey(alias);
            boolean wasCTE = sqAliasToCTEName.containsKey(alias);
            ReadEntity newParentInput = null;
            if (wasView) {
                this.viewsExpanded.add((String)((Pair)aliasToViewInfo.get(alias)).getLeft());
                newParentInput = (ReadEntity)((Pair)aliasToViewInfo.get(alias)).getRight();
            } else if (wasCTE) {
                this.ctesExpanded.add((String)sqAliasToCTEName.get(alias));
            }
            QBExpr qbexpr = qb.getSubqForAlias(alias);
            if (qbexpr.getQB() != null && (wasView || qb.isInsideView())) {
                qbexpr.getQB().setInsideView(true);
            }
            this.getMetaData(qbexpr, newParentInput);
            if (wasView) {
                this.viewsExpanded.remove(this.viewsExpanded.size() - 1);
                continue;
            }
            if (!wasCTE) continue;
            this.ctesExpanded.remove(this.ctesExpanded.size() - 1);
        }
        BaseSemanticAnalyzer.RowFormatParams rowFormatParams = new BaseSemanticAnalyzer.RowFormatParams();
        StorageFormat storageFormat = new StorageFormat((Configuration)this.conf);
        this.LOG.info("Get metadata for destination tables");
        QBParseInfo qbp = qb.getParseInfo();
        block16: for (String name : qbp.getClauseNamesForDest()) {
            ASTNode ast = qbp.getDestForClause(name);
            switch (ast.getToken().getType()) {
                case 1249: {
                    boolean isFullAcid;
                    ts = new BaseSemanticAnalyzer.TableSpec(this.db, this.conf, ast);
                    if (ts.tableHandle.isView() || this.mvRebuildMode == MaterializationRebuildMode.NONE && ts.tableHandle.isMaterializedView()) {
                        throw new SemanticException(ErrorMsg.DML_AGAINST_VIEW.getMsg());
                    }
                    Class<? extends OutputFormat> outputFormatClass = ts.tableHandle.getOutputFormatClass();
                    if (!ts.tableHandle.isNonNative() && !HiveOutputFormat.class.isAssignableFrom(outputFormatClass)) {
                        throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_OUTPUT_FORMAT_TYPE.getMsg(), (ASTNode)ast, (String)("The class is " + outputFormatClass.toString())));
                    }
                    boolean isTableWrittenTo = qb.getParseInfo().isInsertIntoTable(ts.tableHandle.getDbName(), ts.tableHandle.getTableName(), ts.tableHandle.getSnapshotRef());
                    assert (isTableWrittenTo |= qb.getParseInfo().getInsertOverwriteTables().get(SemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0), ts.tableHandle.getDbName()).toLowerCase()) != null) : "Inconsistent data structure detected: we are writing to " + String.valueOf(ts.tableHandle) + " in " + name + " but it's not in isInsertIntoTable() or getInsertOverwriteTables()";
                    Boolean isTableTag = Optional.ofNullable(ts.tableHandle.getSnapshotRef()).map(HiveUtils::isTableTag).orElse(false);
                    if (isTableTag.booleanValue()) {
                        throw new UnsupportedOperationException("Don't support write (insert/delete/update/merge) to iceberg tag " + HiveUtils.getTableSnapshotRef(ts.tableHandle.getSnapshotRef()));
                    }
                    boolean isWriteOperation = this.updating(name) || this.deleting(name);
                    boolean bl = isFullAcid = AcidUtils.isFullAcidTable(ts.tableHandle) || AcidUtils.isNonNativeAcidTable(ts.tableHandle);
                    if (isWriteOperation && !isFullAcid) {
                        if (!AcidUtils.isInsertOnlyTable(ts.tableHandle)) {
                            throw new SemanticException(ErrorMsg.ACID_OP_ON_NONACID_TABLE, new String[]{ts.getTableName().getTable()});
                        }
                        throw new SemanticException(ErrorMsg.ACID_OP_ON_INSERTONLYTRAN_TABLE, new String[]{ts.getTableName().getTable()});
                    }
                    if (ts.specType != BaseSemanticAnalyzer.TableSpec.SpecType.STATIC_PARTITION) {
                        qb.getMetaData().setDestForAlias(name, ts.tableHandle);
                        if (ts.partSpec != null && ts.partSpec.size() > 0) {
                            qb.getMetaData().setPartSpecForAlias(name, ts.partSpec);
                        }
                    } else {
                        qb.getMetaData().setDestForAlias(name, ts.partHandle);
                        if (ts.tableHandle.hasNonNativePartitionSupport() && ts.partSpec != null && ts.partSpec.size() > 0) {
                            qb.getMetaData().setPartSpecForAlias(name, ts.partSpec);
                        }
                    }
                    if (!HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_AUTOGATHER)) continue block16;
                    qb.getParseInfo().addTableSpec(ts.getTableName().getTable().toLowerCase(), ts);
                    continue block16;
                }
                case 1000: {
                    String fname = SemanticAnalyzer.stripQuotes(ast.getChild(0).getText());
                    if (!qb.getParseInfo().getIsSubQ() && ((ASTNode)ast.getChild(0)).getToken().getType() == 1291) {
                        if (qb.isCTAS() || qb.isMaterializedView()) {
                            Path location;
                            qb.setIsQuery(false);
                            this.ctx.setResDir(null);
                            this.ctx.setResFile(null);
                            if (qb.isMaterializedView() && qb.getViewDesc() != null && qb.getViewDesc().getLocation() != null) {
                                location = new Path(qb.getViewDesc().getLocation());
                            } else if (qb.isCTAS() && qb.getTableDesc().getLocation() != null) {
                                location = new Path(qb.getTableDesc().getLocation());
                            } else {
                                String tableName = SemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
                                String[] names = Utilities.getDbTableName(tableName);
                                try {
                                    String destTableDb;
                                    Warehouse wh = new Warehouse((Configuration)this.conf);
                                    String string = destTableDb = qb.getTableDesc() != null ? qb.getTableDesc().getDatabaseName() : null;
                                    if (destTableDb == null) {
                                        destTableDb = names[0];
                                    }
                                    boolean useExternal = false;
                                    if (qb.isMaterializedView()) {
                                        useExternal = !AcidUtils.isTransactionalView(qb.getViewDesc()) && !this.makeAcid();
                                    } else {
                                        boolean bl = useExternal = qb.getTableDesc() == null || qb.getTableDesc().isTemporary() || qb.getTableDesc().isExternal() || !this.makeAcid();
                                    }
                                    location = useExternal ? wh.getDatabaseExternalPath(this.db.getDatabase(destTableDb)) : wh.getDatabaseManagedPath(this.db.getDatabase(destTableDb));
                                }
                                catch (MetaException e) {
                                    throw new SemanticException((Throwable)e);
                                }
                            }
                            try {
                                CreateTableDesc tblDesc = qb.getTableDesc();
                                fname = tblDesc != null && tblDesc.isTemporary() && AcidUtils.isInsertOnlyTable(tblDesc.getTblProps()) ? FileUtils.makeQualified((Path)location, (Configuration)this.conf).toString() : this.ctx.getExtTmpPathRelTo(FileUtils.makeQualified((Path)location, (Configuration)this.conf)).toString();
                            }
                            catch (Exception e) {
                                throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, "Error creating temporary folder on: " + location.toString()), (Throwable)e);
                            }
                            if (HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_AUTOGATHER)) {
                                BaseSemanticAnalyzer.TableSpec ts2 = new BaseSemanticAnalyzer.TableSpec(this.db, this.conf, this.ast);
                                qb.getParseInfo().addTableSpec(ts2.getTableName().getTable().toLowerCase(), ts2);
                            }
                        } else {
                            qb.setIsQuery(true);
                            Path stagingPath = SemanticAnalyzer.getStagingDirectoryPathname(qb, this.conf, this.ctx);
                            fname = stagingPath.toString();
                            this.ctx.setResDir(stagingPath);
                        }
                    }
                    boolean isDfsFile = true;
                    if (ast.getChildCount() >= 2 && ast.getChild(1).getText().toLowerCase().equals("local")) {
                        isDfsFile = false;
                    }
                    qb.getMetaData().setDestForAlias(name, fname, isDfsFile);
                    CreateTableDesc directoryDesc = new CreateTableDesc();
                    boolean directoryDescIsSet = false;
                    int numCh = ast.getChildCount();
                    block17: for (int num = 1; num < numCh; ++num) {
                        ASTNode child = (ASTNode)ast.getChild(num);
                        if (child == null) continue;
                        if (storageFormat.fillStorageFormat(child)) {
                            directoryDesc.setInputFormat(storageFormat.getInputFormat());
                            directoryDesc.setOutputFormat(storageFormat.getOutputFormat());
                            directoryDesc.setSerde(storageFormat.getSerde());
                            directoryDescIsSet = true;
                            continue;
                        }
                        switch (child.getToken().getType()) {
                            case 1267: {
                                rowFormatParams.analyzeRowFormat(child);
                                directoryDesc.setFieldDelim(rowFormatParams.getFieldDelim());
                                directoryDesc.setLineDelim(rowFormatParams.getLineDelim());
                                directoryDesc.setCollItemDelim(rowFormatParams.getCollItemDelim());
                                directoryDesc.setMapKeyDelim(rowFormatParams.getMapKeyDelim());
                                directoryDesc.setFieldEscape(rowFormatParams.getFieldEscape());
                                directoryDesc.setNullFormat(rowFormatParams.getNullFormat());
                                directoryDescIsSet = true;
                                continue block17;
                            }
                            case 1273: {
                                ASTNode serdeChild = (ASTNode)child.getChild(0);
                                storageFormat.setSerde(SemanticAnalyzer.unescapeSQLString(serdeChild.getChild(0).getText()));
                                directoryDesc.setSerde(storageFormat.getSerde());
                                if (serdeChild.getChildCount() > 1) {
                                    directoryDesc.setSerdeProps(new HashMap<String, String>());
                                    SemanticAnalyzer.readProps((ASTNode)serdeChild.getChild(1).getChild(0), directoryDesc.getSerdeProps());
                                }
                                directoryDescIsSet = true;
                            }
                        }
                    }
                    if (!directoryDescIsSet) continue block16;
                    qb.setDirectoryDesc(directoryDesc);
                    continue block16;
                }
            }
            throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, "Unknown Token Type " + ast.getToken().getType()));
        }
    }

    private static boolean isPathEncrypted(Path path, HiveConf conf) throws HiveException {
        try {
            HadoopShims.HdfsEncryptionShim hdfsEncryptionShim = SessionState.get().getHdfsEncryptionShim(path.getFileSystem((Configuration)conf), conf);
            if (hdfsEncryptionShim != null && hdfsEncryptionShim.isPathEncrypted(path)) {
                return true;
            }
        }
        catch (Exception e) {
            throw new HiveException("Unable to determine if " + String.valueOf(path) + " is encrypted: " + String.valueOf(e), (Throwable)e);
        }
        return false;
    }

    private static int comparePathKeyStrength(Path p1, Path p2, HiveConf conf) throws HiveException {
        try {
            HadoopShims.HdfsEncryptionShim hdfsEncryptionShim1 = SessionState.get().getHdfsEncryptionShim(p1.getFileSystem((Configuration)conf), conf);
            HadoopShims.HdfsEncryptionShim hdfsEncryptionShim2 = SessionState.get().getHdfsEncryptionShim(p2.getFileSystem((Configuration)conf), conf);
            if (hdfsEncryptionShim1 != null && hdfsEncryptionShim2 != null) {
                return hdfsEncryptionShim1.comparePathKeyStrength(p1, p2, hdfsEncryptionShim2);
            }
        }
        catch (Exception e) {
            throw new HiveException("Unable to compare key strength for " + String.valueOf(p1) + " and " + String.valueOf(p2) + " : " + String.valueOf(e), (Throwable)e);
        }
        return 0;
    }

    private static boolean isPathReadOnly(Path path) throws HiveException {
        HiveConf conf = SessionState.get().getConf();
        try {
            FileSystem fs = path.getFileSystem((Configuration)conf);
            UserGroupInformation ugi = Utils.getUGI();
            FileStatus status = fs.getFileStatus(path);
            FileUtils.checkFileAccessWithImpersonation((FileSystem)fs, (FileStatus)status, (FsAction)FsAction.WRITE, (String)ugi.getUserName());
            return false;
        }
        catch (AccessControlException e) {
            return true;
        }
        catch (Exception e) {
            throw new HiveException("Unable to determine if " + String.valueOf(path) + " is read only: " + String.valueOf(e), (Throwable)e);
        }
    }

    private static Path getStrongestEncryptedTablePath(QB qb, HiveConf conf) throws HiveException {
        ArrayList<String> tabAliases = new ArrayList<String>(qb.getTabAliases());
        Path strongestPath = null;
        for (String alias : tabAliases) {
            Path tablePath;
            org.apache.hadoop.hive.ql.metadata.Table tab = qb.getMetaData().getTableForAlias(alias);
            if (tab == null || (tablePath = tab.getDataLocation()) == null || !"hdfs".equalsIgnoreCase(tablePath.toUri().getScheme()) || !SemanticAnalyzer.isPathEncrypted(tablePath, conf)) continue;
            if (strongestPath == null) {
                strongestPath = tablePath;
                continue;
            }
            if (SemanticAnalyzer.comparePathKeyStrength(tablePath, strongestPath, conf) <= 0) continue;
            strongestPath = tablePath;
        }
        return strongestPath;
    }

    static Path getStagingDirectoryPathname(QB qb, HiveConf conf, Context ctx) throws HiveException {
        Path stagingPath = null;
        Path tablePath = null;
        if (DFSUtilClient.isHDFSEncryptionEnabled((Configuration)conf)) {
            tablePath = SemanticAnalyzer.getStrongestEncryptedTablePath(qb, conf);
        }
        if (tablePath != null) {
            if (SemanticAnalyzer.isPathReadOnly(tablePath)) {
                Path tmpPath = ctx.getMRTmpPath();
                if (SemanticAnalyzer.comparePathKeyStrength(tablePath, tmpPath, conf) < 0) {
                    throw new HiveException("Read-only encrypted tables cannot be read if the scratch directory is not encrypted (or encryption is weak)");
                }
                stagingPath = tmpPath;
            }
            if (stagingPath == null) {
                stagingPath = ctx.getMRTmpPath(tablePath.toUri());
            }
        } else {
            stagingPath = ctx.getMRTmpPath(false);
        }
        return stagingPath;
    }

    private void replaceViewReferenceWithDefinition(QB qb, org.apache.hadoop.hive.ql.metadata.Table tab, String tab_name, String alias) throws SemanticException {
        ASTNode viewTree;
        final ASTNodeOrigin viewOrigin = new ASTNodeOrigin("VIEW", tab.getTableName(), tab.getViewExpandedText(), alias, qb.getParseInfo().getSrcForAlias(alias));
        try {
            String viewFullyQualifiedName = tab.getCompleteName();
            String viewText = tab.getViewExpandedText();
            TableMask viewMask = new TableMask(this, this.conf, false);
            viewTree = ParseUtils.parse(viewText, this.ctx, tab.getCompleteName());
            if (viewMask.isEnabled() && this.analyzeRewrite == null) {
                ParseResult parseResult = this.rewriteASTWithMaskAndFilter(viewMask, viewTree, this.ctx.getViewTokenRewriteStream(viewFullyQualifiedName), this.ctx, this.db);
                viewTree = parseResult.getTree();
            }
            SemanticDispatcher nodeOriginDispatcher = new SemanticDispatcher(){

                @Override
                public Object dispatch(Node nd, Stack<Node> stack, Object ... nodeOutputs) {
                    ((ASTNode)nd).setOrigin(viewOrigin);
                    return null;
                }
            };
            DefaultGraphWalker nodeOriginTagger = new DefaultGraphWalker(nodeOriginDispatcher);
            nodeOriginTagger.startWalking(Collections.singleton(viewTree), null);
        }
        catch (ParseException e) {
            this.LOG.error("Failed to replaceViewReferenceWithDefinition", (Throwable)e);
            StringBuilder sb = new StringBuilder();
            sb.append(e.getMessage());
            ASTErrorUtils.renderOrigin((StringBuilder)sb, (ASTNodeOrigin)viewOrigin);
            throw new SemanticException(sb.toString(), (Throwable)e);
        }
        QBExpr qbexpr = new QBExpr(alias);
        this.doPhase1QBExpr(viewTree, qbexpr, qb.getId(), alias, true, null);
        if (!this.skipAuthorization() && !qb.isInsideView() || HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_COLLECT_SCANCOLS)) {
            qb.rewriteViewToSubq(alias, tab_name, qbexpr, tab);
        } else {
            qb.rewriteViewToSubq(alias, tab_name, qbexpr, null);
        }
    }

    private boolean isPresent(String[] list, String elem) {
        for (String s : list) {
            if (!s.toLowerCase().equals(elem)) continue;
            return true;
        }
        return false;
    }

    private String findAlias(ASTNode columnRef, Map<String, Operator> aliasToOpInfo) throws SemanticException {
        String colName = SemanticAnalyzer.unescapeIdentifier(columnRef.getChild(0).getText().toLowerCase());
        String tabAlias = null;
        if (aliasToOpInfo != null) {
            for (Map.Entry<String, Operator> opEntry : aliasToOpInfo.entrySet()) {
                Operator op = opEntry.getValue();
                RowResolver rr = this.opParseCtx.get(op).getRowResolver();
                ColumnInfo colInfo = rr.get(null, colName);
                if (colInfo == null) continue;
                if (tabAlias == null) {
                    tabAlias = opEntry.getKey();
                    continue;
                }
                throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.AMBIGUOUS_TABLE_ALIAS.getMsg(), (Tree)columnRef.getChild(0)));
            }
        }
        if (tabAlias == null) {
            throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_TABLE_ALIAS.getMsg(), (Tree)columnRef.getChild(0)));
        }
        return tabAlias;
    }

    void parseJoinCondPopulateAlias(QBJoinTree joinTree, ASTNode condn, List<String> leftAliases, List<String> rightAliases, List<String> fields, Map<String, Operator> aliasToOpInfo) throws SemanticException {
        switch (condn.getToken().getType()) {
            case 1276: {
                String tableOrCol = SemanticAnalyzer.unescapeIdentifier(condn.getChild(0).getText().toLowerCase());
                this.unparseTranslator.addIdentifierTranslation((ASTNode)condn.getChild(0));
                if (this.isPresent(joinTree.getLeftAliases(), tableOrCol)) {
                    if (leftAliases.contains(tableOrCol)) break;
                    leftAliases.add(tableOrCol);
                    break;
                }
                if (this.isPresent(joinTree.getRightAliases(), tableOrCol)) {
                    if (rightAliases.contains(tableOrCol)) break;
                    rightAliases.add(tableOrCol);
                    break;
                }
                tableOrCol = this.findAlias(condn, aliasToOpInfo);
                if (this.isPresent(joinTree.getLeftAliases(), tableOrCol)) {
                    if (leftAliases.contains(tableOrCol)) break;
                    leftAliases.add(tableOrCol);
                    break;
                }
                if (!rightAliases.contains(tableOrCol)) {
                    rightAliases.add(tableOrCol);
                }
                if (joinTree.getNoSemiJoin()) break;
                joinTree.addRHSSemijoinColumns(tableOrCol, condn);
                break;
            }
            case 24: {
                if (fields != null) {
                    fields.add(SemanticAnalyzer.unescapeIdentifier(condn.getToken().getText().toLowerCase()));
                }
                this.unparseTranslator.addIdentifierTranslation(condn);
                break;
            }
            case 25: 
            case 147: 
            case 372: 
            case 427: 
            case 428: 
            case 439: 
            case 944: 
            case 982: 
            case 1064: 
            case 1065: 
            case 1066: 
            case 1067: 
            case 1068: 
            case 1069: 
            case 1070: 
            case 1071: 
            case 1072: 
            case 1073: 
            case 1105: 
            case 1240: 
            case 1287: 
            case 1289: {
                break;
            }
            case 1039: {
                for (int i = 1; i < condn.getChildCount(); ++i) {
                    this.parseJoinCondPopulateAlias(joinTree, (ASTNode)condn.getChild(i), leftAliases, rightAliases, null, aliasToOpInfo);
                }
                break;
            }
            default: {
                if (condn.getChildCount() == 1) {
                    this.parseJoinCondPopulateAlias(joinTree, (ASTNode)condn.getChild(0), leftAliases, rightAliases, null, aliasToOpInfo);
                    break;
                }
                if (condn.getChildCount() == 2) {
                    ArrayList<String> fields1 = null;
                    if (!joinTree.getNoSemiJoin() && condn.getToken().getType() == 16) {
                        fields1 = new ArrayList<String>();
                        int rhssize = rightAliases.size();
                        this.parseJoinCondPopulateAlias(joinTree, (ASTNode)condn.getChild(0), leftAliases, rightAliases, null, aliasToOpInfo);
                        String rhsAlias = null;
                        if (rightAliases.size() > rhssize) {
                            rhsAlias = rightAliases.get(rightAliases.size() - 1);
                        }
                        this.parseJoinCondPopulateAlias(joinTree, (ASTNode)condn.getChild(1), leftAliases, rightAliases, fields1, aliasToOpInfo);
                        if (rhsAlias == null || fields1.size() <= 0) break;
                        joinTree.addRHSSemijoinColumns(rhsAlias, condn);
                        break;
                    }
                    this.parseJoinCondPopulateAlias(joinTree, (ASTNode)condn.getChild(0), leftAliases, rightAliases, null, aliasToOpInfo);
                    this.parseJoinCondPopulateAlias(joinTree, (ASTNode)condn.getChild(1), leftAliases, rightAliases, fields1, aliasToOpInfo);
                    break;
                }
                throw new SemanticException(condn.toStringTree() + " encountered with " + condn.getChildCount() + " children");
            }
        }
    }

    private void populateAliases(List<String> leftAliases, List<String> rightAliases, ASTNode condn, QBJoinTree joinTree, List<String> leftSrc) {
        if (leftAliases.size() != 0 && rightAliases.size() != 0) {
            joinTree.addPostJoinFilter(condn);
            return;
        }
        if (rightAliases.size() != 0) {
            assert (rightAliases.size() == 1);
            joinTree.getExpressions().get(1).add(condn);
        } else if (leftAliases.size() != 0) {
            joinTree.getExpressions().get(0).add(condn);
            for (String s : leftAliases) {
                if (leftSrc.contains(s)) continue;
                leftSrc.add(s);
            }
        } else {
            joinTree.addPostJoinFilter(condn);
        }
    }

    /*
     * WARNING - void declaration
     */
    void applyEqualityPredicateToQBJoinTree(QBJoinTree joinTree, JoinType type, List<String> leftSrc, ASTNode joinCond, ASTNode leftCondn, ASTNode rightCondn, List<String> leftCondAl1, List<String> leftCondAl2, List<String> rightCondAl1, List<String> rightCondAl2) {
        if (leftCondAl1.size() != 0) {
            if (rightCondAl1.size() != 0 || rightCondAl1.size() == 0 && rightCondAl2.size() == 0) {
                if (type.equals((Object)JoinType.LEFTOUTER) || type.equals((Object)JoinType.FULLOUTER)) {
                    joinTree.getFilters().get(0).add(joinCond);
                } else {
                    if (rightCondAl1.size() != 0) {
                        QBJoinTree leftTree = joinTree.getJoinSrc();
                        ArrayList<String> leftTreeLeftSrc = new ArrayList<String>();
                        if (leftTree != null && leftTree.getNoOuterJoin()) {
                            void var16_26;
                            String leftTreeRightSource = leftTree.getRightAliases() != null && leftTree.getRightAliases().length > 0 ? leftTree.getRightAliases()[0] : null;
                            boolean leftHasRightReference = false;
                            for (String string : leftCondAl1) {
                                if (!string.equals(leftTreeRightSource)) continue;
                                leftHasRightReference = true;
                                break;
                            }
                            boolean rightHasRightReference = false;
                            for (String r : rightCondAl1) {
                                if (!r.equals(leftTreeRightSource)) continue;
                                rightHasRightReference = true;
                                break;
                            }
                            boolean bl = false;
                            if (!leftHasRightReference && !rightHasRightReference) {
                                this.applyEqualityPredicateToQBJoinTree(leftTree, type, leftTreeLeftSrc, joinCond, leftCondn, rightCondn, leftCondAl1, leftCondAl2, rightCondAl1, rightCondAl2);
                                boolean bl2 = true;
                            } else if (!leftHasRightReference && rightHasRightReference && rightCondAl1.size() == 1) {
                                this.applyEqualityPredicateToQBJoinTree(leftTree, type, leftTreeLeftSrc, joinCond, leftCondn, rightCondn, leftCondAl1, leftCondAl2, rightCondAl2, rightCondAl1);
                                boolean bl3 = true;
                            } else if (leftHasRightReference && !rightHasRightReference && leftCondAl1.size() == 1) {
                                this.applyEqualityPredicateToQBJoinTree(leftTree, type, leftTreeLeftSrc, joinCond, leftCondn, rightCondn, leftCondAl2, leftCondAl1, rightCondAl1, rightCondAl2);
                                boolean bl4 = true;
                            }
                            if (leftTreeLeftSrc.size() == 1) {
                                leftTree.setLeftAlias((String)leftTreeLeftSrc.get(0));
                            }
                            if (var16_26 != false) {
                                return;
                            }
                        }
                    }
                    joinTree.getFiltersForPushing().get(0).add(joinCond);
                }
            } else if (rightCondAl2.size() != 0) {
                this.populateAliases(leftCondAl1, leftCondAl2, leftCondn, joinTree, leftSrc);
                this.populateAliases(rightCondAl1, rightCondAl2, rightCondn, joinTree, leftSrc);
                boolean nullsafe = joinCond.getToken().getType() == 19;
                joinTree.getNullSafes().add(nullsafe);
            }
        } else if (leftCondAl2.size() != 0) {
            if (rightCondAl2.size() != 0 || rightCondAl1.size() == 0 && rightCondAl2.size() == 0) {
                if (type.equals((Object)JoinType.RIGHTOUTER) || type.equals((Object)JoinType.FULLOUTER)) {
                    joinTree.getFilters().get(1).add(joinCond);
                } else {
                    joinTree.getFiltersForPushing().get(1).add(joinCond);
                }
            } else if (rightCondAl1.size() != 0) {
                this.populateAliases(leftCondAl1, leftCondAl2, leftCondn, joinTree, leftSrc);
                this.populateAliases(rightCondAl1, rightCondAl2, rightCondn, joinTree, leftSrc);
                boolean nullsafe = joinCond.getToken().getType() == 19;
                joinTree.getNullSafes().add(nullsafe);
            }
        } else if (rightCondAl1.size() != 0) {
            if (type.equals((Object)JoinType.LEFTOUTER) || type.equals((Object)JoinType.FULLOUTER)) {
                joinTree.getFilters().get(0).add(joinCond);
            } else {
                joinTree.getFiltersForPushing().get(0).add(joinCond);
            }
        } else if (type.equals((Object)JoinType.RIGHTOUTER) || type.equals((Object)JoinType.FULLOUTER)) {
            joinTree.getFilters().get(1).add(joinCond);
        } else if (type.equals((Object)JoinType.LEFTSEMI)) {
            joinTree.getExpressions().get(0).add(leftCondn);
            joinTree.getExpressions().get(1).add(rightCondn);
            boolean nullsafe = joinCond.getToken().getType() == 19;
            joinTree.getNullSafes().add(nullsafe);
            joinTree.getFiltersForPushing().get(1).add(joinCond);
        } else {
            joinTree.getFiltersForPushing().get(1).add(joinCond);
        }
    }

    private void parseJoinCondition(QBJoinTree joinTree, ASTNode joinCond, List<String> leftSrc, Map<String, Operator> aliasToOpInfo) throws SemanticException {
        if (joinCond == null) {
            return;
        }
        JoinCond cond = joinTree.getJoinCond()[0];
        JoinType type = cond.getJoinType();
        this.parseJoinCondition(joinTree, joinCond, leftSrc, type, aliasToOpInfo);
        List<List<ASTNode>> filters = joinTree.getFilters();
        if (type == JoinType.LEFTOUTER || type == JoinType.FULLOUTER) {
            joinTree.addFilterMapping(cond.getLeft(), cond.getRight(), filters.get(0).size());
        }
        if (type == JoinType.RIGHTOUTER || type == JoinType.FULLOUTER) {
            joinTree.addFilterMapping(cond.getRight(), cond.getLeft(), filters.get(1).size());
        }
    }

    private void parseJoinCondition(QBJoinTree joinTree, ASTNode joinCond, List<String> leftSrc, JoinType type, Map<String, Operator> aliasToOpInfo) throws SemanticException {
        if (joinCond == null) {
            return;
        }
        switch (joinCond.getToken().getType()) {
            case 246: {
                this.parseJoinCondPopulateAlias(joinTree, (ASTNode)joinCond.getChild(0), new ArrayList<String>(), new ArrayList<String>(), null, aliasToOpInfo);
                this.parseJoinCondPopulateAlias(joinTree, (ASTNode)joinCond.getChild(1), new ArrayList<String>(), new ArrayList<String>(), null, aliasToOpInfo);
                joinTree.addPostJoinFilter(joinCond);
                break;
            }
            case 36: {
                this.parseJoinCondition(joinTree, (ASTNode)joinCond.getChild(0), leftSrc, type, aliasToOpInfo);
                this.parseJoinCondition(joinTree, (ASTNode)joinCond.getChild(1), leftSrc, type, aliasToOpInfo);
                break;
            }
            case 18: 
            case 19: {
                ASTNode leftCondn = (ASTNode)joinCond.getChild(0);
                ArrayList<String> leftCondAl1 = new ArrayList<String>();
                ArrayList<String> leftCondAl2 = new ArrayList<String>();
                this.parseJoinCondPopulateAlias(joinTree, leftCondn, leftCondAl1, leftCondAl2, null, aliasToOpInfo);
                ASTNode rightCondn = (ASTNode)joinCond.getChild(1);
                ArrayList<String> rightCondAl1 = new ArrayList<String>();
                ArrayList<String> rightCondAl2 = new ArrayList<String>();
                this.parseJoinCondPopulateAlias(joinTree, rightCondn, rightCondAl1, rightCondAl2, null, aliasToOpInfo);
                if (leftCondAl1.size() != 0 && leftCondAl2.size() != 0 || rightCondAl1.size() != 0 && rightCondAl2.size() != 0) {
                    joinTree.addPostJoinFilter(joinCond);
                    break;
                }
                this.applyEqualityPredicateToQBJoinTree(joinTree, type, leftSrc, joinCond, leftCondn, rightCondn, leftCondAl1, leftCondAl2, rightCondAl1, rightCondAl2);
                break;
            }
            default: {
                int ci;
                boolean isFunction = joinCond.getType() == 1039;
                int childrenBegin = isFunction ? 1 : 0;
                ArrayList leftAlias = new ArrayList(joinCond.getChildCount() - childrenBegin);
                ArrayList rightAlias = new ArrayList(joinCond.getChildCount() - childrenBegin);
                for (ci = 0; ci < joinCond.getChildCount() - childrenBegin; ++ci) {
                    ArrayList left = new ArrayList();
                    ArrayList arrayList = new ArrayList();
                    leftAlias.add(left);
                    rightAlias.add(arrayList);
                }
                for (ci = childrenBegin; ci < joinCond.getChildCount(); ++ci) {
                    this.parseJoinCondPopulateAlias(joinTree, (ASTNode)joinCond.getChild(ci), (List)leftAlias.get(ci - childrenBegin), (List)rightAlias.get(ci - childrenBegin), null, aliasToOpInfo);
                }
                boolean leftAliasNull = true;
                for (List list : leftAlias) {
                    if (list.size() == 0) continue;
                    leftAliasNull = false;
                    break;
                }
                boolean rightAliasNull = true;
                for (List list : rightAlias) {
                    if (list.size() == 0) continue;
                    rightAliasNull = false;
                    break;
                }
                if (!leftAliasNull && !rightAliasNull) {
                    joinTree.addPostJoinFilter(joinCond);
                    break;
                }
                if (!leftAliasNull) {
                    if (type.equals((Object)JoinType.LEFTOUTER) || type.equals((Object)JoinType.FULLOUTER)) {
                        joinTree.getFilters().get(0).add(joinCond);
                        break;
                    }
                    joinTree.getFiltersForPushing().get(0).add(joinCond);
                    break;
                }
                if (type.equals((Object)JoinType.RIGHTOUTER) || type.equals((Object)JoinType.FULLOUTER)) {
                    joinTree.getFilters().get(1).add(joinCond);
                    break;
                }
                joinTree.getFiltersForPushing().get(1).add(joinCond);
            }
        }
    }

    private void extractJoinCondsFromWhereClause(QBJoinTree joinTree, ASTNode predicate, Map<String, Operator> aliasToOpInfo) {
        switch (predicate.getType()) {
            case 36: {
                this.extractJoinCondsFromWhereClause(joinTree, (ASTNode)predicate.getChild(0), aliasToOpInfo);
                this.extractJoinCondsFromWhereClause(joinTree, (ASTNode)predicate.getChild(1), aliasToOpInfo);
                break;
            }
            case 18: 
            case 19: {
                ASTNode leftCondn = (ASTNode)predicate.getChild(0);
                ArrayList<String> leftCondAl1 = new ArrayList<String>();
                ArrayList<String> leftCondAl2 = new ArrayList<String>();
                try {
                    this.parseJoinCondPopulateAlias(joinTree, leftCondn, leftCondAl1, leftCondAl2, null, aliasToOpInfo);
                }
                catch (SemanticException se) {
                    return;
                }
                ASTNode rightCondn = (ASTNode)predicate.getChild(1);
                ArrayList<String> rightCondAl1 = new ArrayList<String>();
                ArrayList<String> rightCondAl2 = new ArrayList<String>();
                try {
                    this.parseJoinCondPopulateAlias(joinTree, rightCondn, rightCondAl1, rightCondAl2, null, aliasToOpInfo);
                }
                catch (SemanticException se) {
                    return;
                }
                if (leftCondAl1.size() != 0 && leftCondAl2.size() != 0 || rightCondAl1.size() != 0 && rightCondAl2.size() != 0) {
                    return;
                }
                if (leftCondAl1.size() == 0 && leftCondAl2.size() == 0 || rightCondAl1.size() == 0 && rightCondAl2.size() == 0) {
                    return;
                }
                ArrayList<String> leftSrc = new ArrayList<String>();
                JoinCond cond = joinTree.getJoinCond()[0];
                JoinType type = cond.getJoinType();
                this.applyEqualityPredicateToQBJoinTree(joinTree, type, leftSrc, predicate, leftCondn, rightCondn, leftCondAl1, leftCondAl2, rightCondAl1, rightCondAl2);
                if (leftSrc.size() != 1) break;
                joinTree.setLeftAlias((String)leftSrc.get(0));
                break;
            }
            default: {
                return;
            }
        }
    }

    <T extends OperatorDesc> Operator<T> putOpInsertMap(Operator<T> op, RowResolver rr) {
        OpParseContext ctx = new OpParseContext(rr);
        this.opParseCtx.put(op, ctx);
        op.augmentPlan();
        return op;
    }

    private Operator genHavingPlan(String dest, QB qb, Operator input, Map<String, Operator> aliasToOpInfo) throws SemanticException {
        ASTNode havingExpr = qb.getParseInfo().getHavingForClause(dest);
        OpParseContext inputCtx = this.opParseCtx.get(input);
        RowResolver inputRR = inputCtx.getRowResolver();
        Map<ASTNode, String> exprToColumnAlias = qb.getParseInfo().getAllExprToColumnAlias();
        inputRR.putAll(exprToColumnAlias);
        ASTNode condn = (ASTNode)havingExpr.getChild(0);
        if (!this.isCBOExecuted() && !qb.getParseInfo().getDestToGroupBy().isEmpty()) {
            String destClauseName = qb.getParseInfo().getClauseNames().iterator().next();
            boolean cubeRollupGrpSetPresent = !qb.getParseInfo().getDestRollups().isEmpty() || !qb.getParseInfo().getDestGroupingSets().isEmpty() || !qb.getParseInfo().getDestCubes().isEmpty();
            condn = this.rewriteGroupingFunctionAST(this.getGroupByForClause(qb.getParseInfo(), destClauseName), condn, !cubeRollupGrpSetPresent);
        }
        Operator output = this.genFilterPlan(condn, qb, input, aliasToOpInfo, true, false);
        output = this.putOpInsertMap(output, inputRR);
        return output;
    }

    protected ASTNode rewriteGroupingFunctionAST(final List<ASTNode> grpByAstExprs, ASTNode targetNode, final boolean noneSet) {
        TreeVisitorAction action = new TreeVisitorAction(){

            public Object pre(Object t) {
                return t;
            }

            public Object post(Object t) {
                ASTNode func;
                ASTNode root = (ASTNode)t;
                if (root.getType() == 1039 && "grouping".equalsIgnoreCase((func = (ASTNode)ParseDriver.adaptor.getChild((Object)root, 0)).getText()) && func.getChildCount() == 0) {
                    ASTNode childGroupingID;
                    int numberOperands = ParseDriver.adaptor.getChildCount((Object)root);
                    ASTNode newRoot = new ASTNode();
                    ASTNode groupingFunc = (ASTNode)ParseDriver.adaptor.create(24, "grouping");
                    ParseDriver.adaptor.addChild((Object)groupingFunc, ParseDriver.adaptor.create(24, "rewritten"));
                    newRoot.addChild((Tree)groupingFunc);
                    if (noneSet) {
                        childGroupingID = (ASTNode)ParseDriver.adaptor.create(25, "0L");
                    } else {
                        childGroupingID = (ASTNode)ParseDriver.adaptor.create(1276, "TOK_TABLE_OR_COL");
                        ParseDriver.adaptor.addChild((Object)childGroupingID, ParseDriver.adaptor.create(24, VirtualColumn.GROUPINGID.getName()));
                    }
                    newRoot.addChild((Tree)childGroupingID);
                    block0: for (int i = 1; i < numberOperands; ++i) {
                        ASTNode c = (ASTNode)ParseDriver.adaptor.getChild((Object)root, i);
                        for (int j = 0; j < grpByAstExprs.size(); ++j) {
                            ASTNode grpByExpr = (ASTNode)grpByAstExprs.get(j);
                            if (!grpByExpr.toStringTree().equals(c.toStringTree())) continue;
                            ASTNode childN = (ASTNode)ParseDriver.adaptor.create(25, String.valueOf(IntMath.mod((int)(-j - 1), (int)grpByAstExprs.size())) + "L");
                            newRoot.addChild((Tree)childN);
                            continue block0;
                        }
                    }
                    if (numberOperands + 1 != ParseDriver.adaptor.getChildCount((Object)newRoot)) {
                        throw new RuntimeException(ErrorMsg.HIVE_GROUPING_FUNCTION_EXPR_NOT_IN_GROUPBY.getMsg());
                    }
                    root.replaceChildren(0, numberOperands - 1, (Object)newRoot);
                }
                return t;
            }
        };
        return (ASTNode)new TreeVisitor(ParseDriver.adaptor).visit((Object)targetNode, action);
    }

    private Operator genPlanForSubQueryPredicate(QB qbSQ, SubQueryUtils.ISubQueryJoinInfo subQueryPredicate) throws SemanticException {
        qbSQ.setSubQueryDef(subQueryPredicate.getSubQuery());
        Phase1Ctx ctx_1 = this.initPhase1Ctx();
        this.doPhase1(subQueryPredicate.getSubQueryAST(), qbSQ, ctx_1, null);
        this.getMetaData(qbSQ);
        return this.genPlan(qbSQ);
    }

    private Operator genFilterPlan(ASTNode searchCond, QB qb, Operator input, Map<String, Operator> aliasToOpInfo, boolean forHavingClause, boolean forGroupByClause) throws SemanticException {
        OpParseContext inputCtx = this.opParseCtx.get(input);
        RowResolver inputRR = inputCtx.getRowResolver();
        List<ASTNode> subQueriesInOriginalTree = SubQueryUtils.findSubQueries(searchCond);
        if (subQueriesInOriginalTree.size() > 0) {
            if (qb.getSubQueryPredicateDef() != null) {
                throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg(), (ASTNode)subQueriesInOriginalTree.get(0), (String)"Nested SubQuery expressions are not supported."));
            }
            if (subQueriesInOriginalTree.size() > 1) {
                throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.UNSUPPORTED_SUBQUERY_EXPRESSION.getMsg(), (ASTNode)subQueriesInOriginalTree.get(1), (String)"Only 1 SubQuery expression is supported."));
            }
            ASTNode clonedSearchCond = (ASTNode)SubQueryUtils.adaptor.dupTree((Object)searchCond);
            List<ASTNode> subQueries = SubQueryUtils.findSubQueries(clonedSearchCond);
            for (int i = 0; i < subQueries.size(); ++i) {
                ASTNode subQueryAST = subQueries.get(i);
                ASTNode originalSubQueryAST = subQueriesInOriginalTree.get(i);
                int sqIdx = qb.incrNumSubQueryPredicates();
                clonedSearchCond = SubQueryUtils.rewriteParentQueryWhere(clonedSearchCond, subQueryAST);
                QBSubQuery subQuery = SubQueryUtils.buildSubQuery(qb.getId(), sqIdx, subQueryAST, originalSubQueryAST, this.ctx);
                if (!forHavingClause) {
                    qb.setWhereClauseSubQueryPredicate(subQuery);
                } else {
                    qb.setHavingClauseSubQueryPredicate(subQuery);
                }
                String havingInputAlias = null;
                if (forHavingClause) {
                    havingInputAlias = "gby_sq" + sqIdx;
                    aliasToOpInfo.put(havingInputAlias, input);
                }
                subQuery.validateAndRewriteAST(inputRR, forHavingClause, havingInputAlias, aliasToOpInfo.keySet());
                QB qbSQ = new QB(subQuery.getOuterQueryId(), subQuery.getAlias(), true);
                qbSQ.setInsideView(qb.isInsideView());
                Operator sqPlanTopOp = this.genPlanForSubQueryPredicate(qbSQ, subQuery);
                aliasToOpInfo.put(subQuery.getAlias(), sqPlanTopOp);
                RowResolver sqRR = this.opParseCtx.get(sqPlanTopOp).getRowResolver();
                if (subQuery.getOperator().getType() != QBSubQuery.SubQueryType.EXISTS && subQuery.getOperator().getType() != QBSubQuery.SubQueryType.NOT_EXISTS && sqRR.getColumnInfos().size() - subQuery.getNumOfCorrelationExprsAddedToSQSelect() > 1) {
                    throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_SUBQUERY_EXPRESSION.getMsg(), (ASTNode)subQueryAST, (String)"SubQuery can contain only 1 item in Select List."));
                }
                if (subQuery.getNotInCheck() != null) {
                    QBSubQuery.NotInCheck notInCheck = subQuery.getNotInCheck();
                    notInCheck.setSQRR(sqRR);
                    QB qbSQ_nic = new QB(subQuery.getOuterQueryId(), notInCheck.getAlias(), true);
                    Operator sqnicPlanTopOp = this.genPlanForSubQueryPredicate(qbSQ_nic, notInCheck);
                    aliasToOpInfo.put(notInCheck.getAlias(), sqnicPlanTopOp);
                    QBJoinTree joinTree_nic = this.genSQJoinTree(qb, notInCheck, input, aliasToOpInfo);
                    this.pushJoinFilters(qb, joinTree_nic, aliasToOpInfo, false);
                    input = this.genJoinOperator(qbSQ_nic, joinTree_nic, aliasToOpInfo, input);
                    inputRR = this.opParseCtx.get(input).getRowResolver();
                    if (forHavingClause) {
                        aliasToOpInfo.put(havingInputAlias, input);
                    }
                }
                subQuery.buildJoinCondition(inputRR, sqRR, forHavingClause, havingInputAlias);
                QBJoinTree joinTree = this.genSQJoinTree(qb, subQuery, input, aliasToOpInfo);
                this.pushJoinFilters(qb, joinTree, aliasToOpInfo, false);
                boolean notInCheckPresent = subQuery.getNotInCheck() != null && !qb.isMultiDestQuery();
                input = this.genJoinOperator(qbSQ, joinTree, aliasToOpInfo, input, notInCheckPresent);
                searchCond = subQuery.updateOuterQueryFilter(clonedSearchCond);
            }
        }
        return this.genFilterPlan(qb, searchCond, input, forHavingClause || forGroupByClause);
    }

    private Operator genFilterPlan(QB qb, ASTNode condn, Operator input, boolean useCaching) throws SemanticException {
        OpParseContext inputCtx = this.opParseCtx.get(input);
        RowResolver inputRR = inputCtx.getRowResolver();
        ExprNodeDesc filterCond = this.genExprNodeDesc(condn, inputRR, useCaching, this.isCBOExecuted());
        if (filterCond instanceof ExprNodeConstantDesc) {
            ExprNodeConstantDesc c = (ExprNodeConstantDesc)filterCond;
            if (Boolean.TRUE.equals(c.getValue())) {
                return input;
            }
            if (ExprNodeDescUtils.isNullConstant(c)) {
                filterCond = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, false);
            }
        }
        if (!filterCond.getTypeInfo().accept((TypeInfo)TypeInfoFactory.booleanTypeInfo)) {
            filterCond = filterCond.getTypeInfo().getCategory() == ObjectInspector.Category.PRIMITIVE ? (ExprNodeDesc)ExprNodeTypeCheck.getExprNodeDefaultExprProcessor().createConversionCast(filterCond, TypeInfoFactory.booleanTypeInfo) : (ExprNodeDesc)ExprNodeTypeCheck.getExprNodeDefaultExprProcessor().getFuncExprNodeDesc("isnotnull", filterCond);
        }
        Operator<FilterDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new FilterDesc(filterCond, false), new RowSchema(inputRR.getColumnInfos()), input, new Operator[0]), inputRR);
        this.ctx.getPlanMapper().link(condn, output);
        this.LOG.debug("Created Filter Plan for {} row schema: {}", (Object)qb.getId(), (Object)inputRR.toString());
        return output;
    }

    private Operator genNotNullFilterForJoinSourcePlan(QB qb, Operator input, QBJoinTree joinTree, ExprNodeDesc[] joinKeys) throws SemanticException {
        return this.genNotNullFilterForJoinSourcePlan(qb, input, joinTree, joinKeys, false);
    }

    private Operator genNotNullFilterForJoinSourcePlan(QB qb, Operator input, QBJoinTree joinTree, ExprNodeDesc[] joinKeys, boolean OuternotInCheck) throws SemanticException {
        if (qb == null || joinTree == null) {
            return input;
        }
        if (!joinTree.getNoOuterJoin() && !OuternotInCheck) {
            return input;
        }
        if (joinKeys == null || joinKeys.length == 0) {
            return input;
        }
        ArrayListMultimap hashes = ArrayListMultimap.create();
        if (input instanceof FilterOperator) {
            ExprNodeDescUtils.getExprNodeColumnDesc(Arrays.asList(((FilterDesc)input.getConf()).getPredicate()), (Multimap<Integer, ExprNodeColumnDesc>)hashes);
        }
        ExprNodeGenericFuncDesc filterPred = null;
        List<Boolean> nullSafes = joinTree.getNullSafes();
        for (int i = 0; i < joinKeys.length; ++i) {
            if (nullSafes.get(i).booleanValue() || joinKeys[i] instanceof ExprNodeColumnDesc && ((ExprNodeColumnDesc)joinKeys[i]).getIsPartitionColOrVirtualCol()) continue;
            boolean skip = false;
            for (ExprNodeColumnDesc node : hashes.get((Object)joinKeys[i].hashCode())) {
                if (!node.isSame(joinKeys[i])) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            ArrayList<ExprNodeDesc> args = new ArrayList<ExprNodeDesc>();
            args.add(joinKeys[i]);
            ExprNodeGenericFuncDesc nextExpr = ExprNodeGenericFuncDesc.newInstance(FunctionRegistry.getFunctionInfo("isnotnull").getGenericUDF(), args);
            filterPred = filterPred == null ? nextExpr : ExprNodeDescUtils.mergePredicates(filterPred, nextExpr);
        }
        if (filterPred == null) {
            return input;
        }
        OpParseContext inputCtx = this.opParseCtx.get(input);
        RowResolver inputRR = inputCtx.getRowResolver();
        if (input instanceof FilterOperator) {
            FilterOperator f = (FilterOperator)input;
            ArrayList<ExprNodeDesc> preds = new ArrayList<ExprNodeDesc>();
            preds.add(((FilterDesc)f.getConf()).getPredicate());
            preds.add(filterPred);
            ((FilterDesc)f.getConf()).setPredicate(ExprNodeDescUtils.mergePredicates(preds));
            return input;
        }
        FilterDesc filterDesc = new FilterDesc(filterPred, false);
        filterDesc.setGenerated(true);
        Operator<FilterDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(filterDesc, new RowSchema(inputRR.getColumnInfos()), input, new Operator[0]), inputRR);
        this.LOG.debug("Created Filter Plan for {} row schema: {}", (Object)qb.getId(), (Object)inputRR);
        return output;
    }

    Integer genExprNodeDescRegex(String colRegex, String tabAlias, ASTNode sel, List<ExprNodeDesc> exprList, Set<ColumnInfo> excludeCols, RowResolver input, RowResolver colSrcRR, Integer pos, RowResolver output, List<String> aliases, boolean ensureUniqueCols) throws SemanticException {
        ArrayList<Pair<ColumnInfo, RowResolver>> colList = new ArrayList<Pair<ColumnInfo, RowResolver>>();
        Integer i = this.genColListRegex(colRegex, tabAlias, sel, colList, excludeCols, input, colSrcRR, pos, output, aliases, ensureUniqueCols);
        for (Pair pair : colList) {
            exprList.add(ExprNodeTypeCheck.toExprNode((ColumnInfo)pair.getLeft(), (RowResolver)pair.getRight()));
        }
        return i;
    }

    Integer genColListRegex(String colRegex, String tabAlias, ASTNode sel, List<Pair<ColumnInfo, RowResolver>> colList, Set<ColumnInfo> excludeCols, RowResolver input, RowResolver colSrcRR, Integer pos, RowResolver output, List<String> aliases, boolean ensureUniqueCols) throws SemanticException {
        if (colSrcRR == null) {
            colSrcRR = input;
        }
        if (tabAlias != null && !colSrcRR.hasTableAlias(tabAlias)) {
            throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_TABLE_ALIAS.getMsg(), (ASTNode)sel));
        }
        Pattern regex = null;
        try {
            regex = Pattern.compile(colRegex, 2);
        }
        catch (PatternSyntaxException e) {
            throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_COLUMN.getMsg(), (ASTNode)sel, (String)e.getMessage()));
        }
        StringBuilder replacementText = new StringBuilder();
        int matched = 0;
        if (!aliases.contains("")) {
            aliases.add("");
        }
        HashMap<ColumnInfo, ColumnInfo> inputColsProcessed = new HashMap<ColumnInfo, ColumnInfo>();
        if (colSrcRR.getNamedJoinInfo() != null) {
            Map<String, ColumnInfo> leftMap = colSrcRR.getFieldMap(colSrcRR.getNamedJoinInfo().getAliases().get(0));
            Map<String, ColumnInfo> rightMap = colSrcRR.getFieldMap(colSrcRR.getNamedJoinInfo().getAliases().get(1));
            Map<String, ColumnInfo> chosenMap = null;
            chosenMap = colSrcRR.getNamedJoinInfo().getHiveJoinType() != JoinType.RIGHTOUTER ? leftMap : rightMap;
            for (String columnName : colSrcRR.getNamedJoinInfo().getNamedColumns()) {
                for (Map.Entry<String, ColumnInfo> entry : chosenMap.entrySet()) {
                    ColumnInfo colInfo = entry.getValue();
                    if (!columnName.equals(colInfo.getAlias())) continue;
                    String name = colInfo.getInternalName();
                    String[] tmp = colSrcRR.reverseLookup(name);
                    if (tabAlias != null && !tmp[0].equalsIgnoreCase(tabAlias) || colInfo.getIsVirtualCol() && colInfo.isHiddenVirtualCol()) continue;
                    ColumnInfo oColInfo = (ColumnInfo)inputColsProcessed.get(colInfo);
                    if (oColInfo == null) {
                        colList.add((Pair<ColumnInfo, RowResolver>)Pair.of((Object)colInfo, (Object)colSrcRR));
                        oColInfo = new ColumnInfo(SemanticAnalyzer.getColumnInternalName(pos), colInfo.getType(), colInfo.getTabAlias(), colInfo.getIsVirtualCol(), colInfo.isHiddenVirtualCol());
                        inputColsProcessed.put(colInfo, oColInfo);
                    }
                    if (ensureUniqueCols) {
                        if (!output.putWithCheck(tmp[0], tmp[1], null, oColInfo)) {
                            throw new CalciteSemanticException("Cannot add column to RR: " + tmp[0] + "." + tmp[1] + " => " + String.valueOf(oColInfo) + " due to duplication, see previous warnings", CalciteSemanticException.UnsupportedFeature.Duplicates_in_RR);
                        }
                    } else {
                        output.put(tmp[0], tmp[1], oColInfo);
                    }
                    Integer n = pos;
                    pos = pos + 1;
                    ++matched;
                    if (!this.unparseTranslator.isEnabled() && (!this.tableMask.isEnabled() || this.analyzeRewrite != null)) continue;
                    if (replacementText.length() > 0) {
                        replacementText.append(", ");
                    }
                    replacementText.append(HiveUtils.unparseIdentifier(tmp[0], (Configuration)this.conf));
                    replacementText.append(".");
                    replacementText.append(HiveUtils.unparseIdentifier(tmp[1], (Configuration)this.conf));
                }
            }
        }
        for (String alias : aliases) {
            Map<String, ColumnInfo> fMap = colSrcRR.getFieldMap(alias);
            if (fMap == null) continue;
            for (Map.Entry<String, ColumnInfo> entry : fMap.entrySet()) {
                ColumnInfo oColInfo;
                ColumnInfo colInfo = entry.getValue();
                if (colSrcRR.getNamedJoinInfo() != null && colSrcRR.getNamedJoinInfo().getNamedColumns().contains(colInfo.getAlias()) || excludeCols != null && excludeCols.contains(colInfo)) continue;
                String name = colInfo.getInternalName();
                String[] tmp = colSrcRR.reverseLookup(name);
                if (tabAlias != null && !tmp[0].equalsIgnoreCase(tabAlias) || colInfo.getIsVirtualCol() && colInfo.isHiddenVirtualCol() || !regex.matcher(tmp[1]).matches()) continue;
                if (input != colSrcRR) {
                    colInfo = input.get(tabAlias, tmp[1]);
                    if (colInfo == null) {
                        this.LOG.error("Cannot find colInfo for {}.{}, derived from [{}], in [{}]", new Object[]{tabAlias, tmp[1], colSrcRR, input});
                        throw new SemanticException(ErrorMsg.NON_KEY_EXPR_IN_GROUPBY, new String[]{tmp[1]});
                    }
                    name = colInfo.getInternalName();
                    tmp = input.reverseLookup(name);
                    if (this.LOG.isDebugEnabled()) {
                        String oldCol = name + " => " + (String)(tmp == null ? "null" : tmp[0] + "." + tmp[1]);
                        String newCol = name + " => " + (String)(tmp == null ? "null" : tmp[0] + "." + tmp[1]);
                        this.LOG.debug("Translated [" + oldCol + "] to [" + newCol + "]");
                    }
                }
                if ((oColInfo = (ColumnInfo)inputColsProcessed.get(colInfo)) == null) {
                    colList.add((Pair<ColumnInfo, RowResolver>)Pair.of((Object)colInfo, (Object)input));
                    oColInfo = new ColumnInfo(SemanticAnalyzer.getColumnInternalName(pos), colInfo.getType(), colInfo.getTabAlias(), colInfo.getIsVirtualCol(), colInfo.isHiddenVirtualCol());
                    inputColsProcessed.put(colInfo, oColInfo);
                }
                assert (Objects.nonNull(tmp));
                if (ensureUniqueCols) {
                    if (!output.putWithCheck(tmp[0], tmp[1], oColInfo.getInternalName(), oColInfo)) {
                        throw new CalciteSemanticException("Cannot add column to RR: " + tmp[0] + "." + tmp[1] + " => " + String.valueOf(oColInfo) + " due to duplication, see previous warnings", CalciteSemanticException.UnsupportedFeature.Duplicates_in_RR);
                    }
                } else {
                    output.put(tmp[0], tmp[1], oColInfo);
                }
                Integer n = pos;
                pos = pos + 1;
                ++matched;
                if (!this.unparseTranslator.isEnabled() && !this.tableMask.isEnabled()) continue;
                if (replacementText.length() > 0) {
                    replacementText.append(", ");
                }
                replacementText.append(HiveUtils.unparseIdentifier(tmp[0], (Configuration)this.conf));
                replacementText.append(".");
                replacementText.append(HiveUtils.unparseIdentifier(tmp[1], (Configuration)this.conf));
            }
        }
        if (matched == 0) {
            throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_COLUMN.getMsg(), (ASTNode)sel));
        }
        this.unparseTranslator.addTranslation(sel, replacementText.toString());
        if (this.tableMask.isEnabled()) {
            this.tableMask.addTranslation(sel, replacementText.toString());
        }
        return pos;
    }

    public static String getColumnInternalName(int pos) {
        return HiveConf.getColumnInternalName((int)pos);
    }

    private String getScriptProgName(String cmd) {
        int end = cmd.indexOf(" ");
        return end == -1 ? cmd : cmd.substring(0, end);
    }

    private String getScriptArgs(String cmd) {
        int end = cmd.indexOf(" ");
        return end == -1 ? "" : cmd.substring(end, cmd.length());
    }

    private String fetchFilesNotInLocalFilesystem(String cmd) {
        SessionState ss = SessionState.get();
        String progName = this.getScriptProgName(cmd);
        if (!ResourceDownloader.isFileUri(progName)) {
            String filePath = ss.add_resource(SessionState.ResourceType.FILE, progName);
            Path p = new Path(filePath);
            String fileName = p.getName();
            String scriptArgs = this.getScriptArgs(cmd);
            return fileName + scriptArgs;
        }
        return cmd;
    }

    private TableDesc getTableDescFromSerDe(ASTNode child, String cols, String colTypes) throws SemanticException {
        if (child.getType() == 1200) {
            String serdeName = SemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
            Class<?> serdeClass = null;
            try {
                serdeClass = Class.forName(serdeName, true, Utilities.getSessionSpecifiedClassLoader());
            }
            catch (ClassNotFoundException e) {
                throw new SemanticException((Throwable)e);
            }
            TableDesc tblDesc = PlanUtils.getTableDesc(serdeClass, Integer.toString(9), cols, colTypes, null, false);
            if (child.getChildCount() == 2) {
                ASTNode prop = (ASTNode)((ASTNode)child.getChild(1)).getChild(0);
                for (int propChild = 0; propChild < prop.getChildCount(); ++propChild) {
                    String key = SemanticAnalyzer.unescapeSQLString(prop.getChild(propChild).getChild(0).getText());
                    String value = SemanticAnalyzer.unescapeSQLString(prop.getChild(propChild).getChild(1).getText());
                    tblDesc.getProperties().setProperty(key, value);
                }
            }
            return tblDesc;
        }
        if (child.getType() == 1201) {
            TableDesc tblDesc = PlanUtils.getDefaultTableDesc(Integer.toString(1), cols, colTypes, false);
            int numChildRowFormat = child.getChildCount();
            block10: for (int numC = 0; numC < numChildRowFormat; ++numC) {
                ASTNode rowChild = (ASTNode)child.getChild(numC);
                switch (rowChild.getToken().getType()) {
                    case 1269: {
                        String fieldDelim = SemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText());
                        tblDesc.getProperties().setProperty("field.delim", fieldDelim);
                        tblDesc.getProperties().setProperty("serialization.format", fieldDelim);
                        if (rowChild.getChildCount() < 2) continue block10;
                        String fieldEscape = SemanticAnalyzer.unescapeSQLString(rowChild.getChild(1).getText());
                        tblDesc.getProperties().setProperty("escape.delim", fieldEscape);
                        continue block10;
                    }
                    case 1268: {
                        tblDesc.getProperties().setProperty("collection.delim", SemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText()));
                        continue block10;
                    }
                    case 1271: {
                        tblDesc.getProperties().setProperty("mapkey.delim", SemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText()));
                        continue block10;
                    }
                    case 1270: {
                        String lineDelim = SemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText());
                        tblDesc.getProperties().setProperty("line.delim", lineDelim);
                        if (lineDelim.equals("\n") || lineDelim.equals("10")) continue block10;
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage(rowChild, ErrorMsg.LINES_TERMINATED_BY_NON_NEWLINE.getMsg()));
                    }
                    case 1272: {
                        String nullFormat = SemanticAnalyzer.unescapeSQLString(rowChild.getChild(0).getText());
                        tblDesc.getProperties().setProperty("serialization.null.format", nullFormat);
                        continue block10;
                    }
                    default: {
                        assert (false);
                        continue block10;
                    }
                }
            }
            return tblDesc;
        }
        return null;
    }

    private void failIfColAliasExists(Set<String> nameSet, String name) throws SemanticException {
        if (nameSet.contains(name)) {
            throw new SemanticException(ErrorMsg.COLUMN_ALIAS_ALREADY_EXISTS.getMsg(name));
        }
        nameSet.add(name);
    }

    private Operator genScriptPlan(ASTNode trfm, QB qb, Operator input) throws SemanticException {
        Class<?> serde;
        int i;
        ArrayList<ColumnInfo> outputCols = new ArrayList<ColumnInfo>();
        int inputSerDeNum = 1;
        int inputRecordWriterNum = 2;
        int outputSerDeNum = 4;
        int outputRecordReaderNum = 5;
        int outputColsNum = 6;
        boolean outputColNames = false;
        boolean outputColSchemas = false;
        int execPos = 3;
        boolean defaultOutputCols = false;
        if (trfm.getChildCount() > outputColsNum) {
            ASTNode outCols = (ASTNode)trfm.getChild(outputColsNum);
            if (outCols.getType() == 842) {
                outputColNames = true;
            } else if (outCols.getType() == 1252) {
                outputColSchemas = true;
            }
        }
        if (!outputColNames && !outputColSchemas) {
            String intName = SemanticAnalyzer.getColumnInternalName(0);
            ColumnInfo colInfo = new ColumnInfo(intName, (TypeInfo)TypeInfoFactory.stringTypeInfo, null, false);
            colInfo.setAlias("key");
            outputCols.add(colInfo);
            intName = SemanticAnalyzer.getColumnInternalName(1);
            colInfo = new ColumnInfo(intName, (TypeInfo)TypeInfoFactory.stringTypeInfo, null, false);
            colInfo.setAlias("value");
            outputCols.add(colInfo);
            defaultOutputCols = true;
        } else {
            ASTNode collist = (ASTNode)trfm.getChild(outputColsNum);
            int ccount = collist.getChildCount();
            HashSet<String> colAliasNamesDuplicateCheck = new HashSet<String>();
            if (outputColNames) {
                for (i = 0; i < ccount; ++i) {
                    String colAlias = SemanticAnalyzer.unescapeIdentifier(((ASTNode)collist.getChild(i)).getText()).toLowerCase();
                    this.failIfColAliasExists(colAliasNamesDuplicateCheck, colAlias);
                    String intName = SemanticAnalyzer.getColumnInternalName(i);
                    ColumnInfo colInfo = new ColumnInfo(intName, (TypeInfo)TypeInfoFactory.stringTypeInfo, null, false);
                    colInfo.setAlias(colAlias);
                    outputCols.add(colInfo);
                }
            } else {
                for (i = 0; i < ccount; ++i) {
                    ASTNode child = (ASTNode)collist.getChild(i);
                    assert (child.getType() == 1251);
                    String colAlias = SemanticAnalyzer.unescapeIdentifier(((ASTNode)child.getChild(0)).getText()).toLowerCase();
                    this.failIfColAliasExists(colAliasNamesDuplicateCheck, colAlias);
                    String intName = SemanticAnalyzer.getColumnInternalName(i);
                    ColumnInfo colInfo = new ColumnInfo(intName, TypeInfoUtils.getTypeInfoFromTypeString((String)SemanticAnalyzer.getTypeStringFromAST((ASTNode)child.getChild(1))), null, false);
                    colInfo.setAlias(colAlias);
                    outputCols.add(colInfo);
                }
            }
        }
        RowResolver out_rwsch = new RowResolver();
        StringBuilder columns = new StringBuilder();
        StringBuilder columnTypes = new StringBuilder();
        for (i = 0; i < outputCols.size(); ++i) {
            if (i != 0) {
                columns.append(",");
                columnTypes.append(",");
            }
            columns.append(((ColumnInfo)outputCols.get(i)).getInternalName());
            columnTypes.append(((ColumnInfo)outputCols.get(i)).getType().getTypeName());
            out_rwsch.put(qb.getParseInfo().getAlias(), ((ColumnInfo)outputCols.get(i)).getAlias(), (ColumnInfo)outputCols.get(i));
        }
        StringBuilder inpColumns = new StringBuilder();
        StringBuilder inpColumnTypes = new StringBuilder();
        List<ColumnInfo> inputSchema = this.opParseCtx.get(input).getRowResolver().getColumnInfos();
        for (int i2 = 0; i2 < inputSchema.size(); ++i2) {
            if (i2 != 0) {
                inpColumns.append(",");
                inpColumnTypes.append(",");
            }
            inpColumns.append(inputSchema.get(i2).getInternalName());
            inpColumnTypes.append(inputSchema.get(i2).getType().getTypeName());
        }
        String defaultSerdeName = this.conf.getVar(HiveConf.ConfVars.HIVE_SCRIPT_SERDE);
        try {
            serde = Class.forName(defaultSerdeName, true, Utilities.getSessionSpecifiedClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new SemanticException((Throwable)e);
        }
        int fieldSeparator = 9;
        if (HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SCRIPT_ESCAPE)) {
            fieldSeparator = 1;
        }
        TableDesc inInfo = trfm.getChild(inputSerDeNum).getChildCount() > 0 ? this.getTableDescFromSerDe((ASTNode)((ASTNode)trfm.getChild(inputSerDeNum)).getChild(0), inpColumns.toString(), inpColumnTypes.toString()) : PlanUtils.getTableDesc(DelimitedJSONSerDe.class, Integer.toString(fieldSeparator), inpColumns.toString(), inpColumnTypes.toString(), null, false);
        TableDesc outInfo = trfm.getChild(outputSerDeNum).getChildCount() > 0 ? this.getTableDescFromSerDe((ASTNode)((ASTNode)trfm.getChild(outputSerDeNum)).getChild(0), columns.toString(), columnTypes.toString()) : PlanUtils.getTableDesc(serde, Integer.toString(fieldSeparator), columns.toString(), columnTypes.toString(), null, defaultOutputCols);
        TableDesc errInfo = PlanUtils.getTableDesc(serde, Integer.toString(9), "KEY");
        Class<? extends RecordReader> outRecordReader = this.getRecordReader((ASTNode)trfm.getChild(outputRecordReaderNum));
        Class<? extends RecordWriter> inRecordWriter = this.getRecordWriter((ASTNode)trfm.getChild(inputRecordWriterNum));
        Class<? extends RecordReader> errRecordReader = this.getDefaultRecordReader();
        Operator<ScriptDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new ScriptDesc(this.fetchFilesNotInLocalFilesystem(SemanticAnalyzer.stripQuotes(trfm.getChild(execPos).getText())), inInfo, inRecordWriter, outInfo, outRecordReader, errRecordReader, errInfo), new RowSchema(out_rwsch.getColumnInfos()), input, new Operator[0]), out_rwsch);
        output.setColumnExprMap(new HashMap<String, ExprNodeDesc>());
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_CAPTURE_TRANSFORM_ENTITY)) {
            String scriptCmd = this.getScriptProgName(SemanticAnalyzer.stripQuotes(trfm.getChild(execPos).getText()));
            this.getInputs().add(new ReadEntity(new Path(scriptCmd), ResourceDownloader.isFileUri(scriptCmd)));
        }
        return output;
    }

    private Class<? extends RecordReader> getRecordReader(ASTNode node) throws SemanticException {
        String name = node.getChildCount() == 0 ? this.conf.getVar(HiveConf.ConfVars.HIVE_SCRIPT_RECORD_READER) : SemanticAnalyzer.unescapeSQLString(node.getChild(0).getText());
        try {
            return Class.forName(name, true, Utilities.getSessionSpecifiedClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new SemanticException((Throwable)e);
        }
    }

    private Class<? extends RecordReader> getDefaultRecordReader() throws SemanticException {
        String name = this.conf.getVar(HiveConf.ConfVars.HIVE_SCRIPT_RECORD_READER);
        try {
            return Class.forName(name, true, Utilities.getSessionSpecifiedClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new SemanticException((Throwable)e);
        }
    }

    private Class<? extends RecordWriter> getRecordWriter(ASTNode node) throws SemanticException {
        String name = node.getChildCount() == 0 ? this.conf.getVar(HiveConf.ConfVars.HIVE_SCRIPT_RECORD_WRITER) : SemanticAnalyzer.unescapeSQLString(node.getChild(0).getText());
        try {
            return Class.forName(name, true, Utilities.getSessionSpecifiedClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new SemanticException((Throwable)e);
        }
    }

    private List<Long> getGroupingSetsForRollup(int size) {
        ArrayList<Long> groupingSetKeys = new ArrayList<Long>();
        for (int i = 0; i <= size; ++i) {
            groupingSetKeys.add((1L << i) - 1L);
        }
        return groupingSetKeys;
    }

    private List<Long> getGroupingSetsForCube(int size) {
        long count = 1L << size;
        ArrayList<Long> results = new ArrayList<Long>();
        for (long i = 0L; i < count; ++i) {
            results.add(i);
        }
        return results;
    }

    Pair<List<ASTNode>, List<Long>> getGroupByGroupingSetsForClause(QBParseInfo parseInfo, String dest) throws SemanticException {
        List<Object> groupingSets = new ArrayList();
        List<ASTNode> groupByExprs = this.getGroupByForClause(parseInfo, dest);
        if (parseInfo.getDestRollups().contains(dest)) {
            groupingSets = this.getGroupingSetsForRollup(groupByExprs.size());
        } else if (parseInfo.getDestCubes().contains(dest)) {
            groupingSets = this.getGroupingSetsForCube(groupByExprs.size());
        } else if (parseInfo.getDestGroupingSets().contains(dest)) {
            groupingSets = this.getGroupingSets(groupByExprs, parseInfo, dest);
        }
        if (!groupingSets.isEmpty() && groupByExprs.size() > 64) {
            throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_SIZE_LIMIT.getMsg());
        }
        return Pair.of(groupByExprs, groupingSets);
    }

    private List<Long> getGroupingSets(List<ASTNode> groupByExpr, QBParseInfo parseInfo, String dest) throws SemanticException {
        HashMap<String, Integer> exprPos = new HashMap<String, Integer>();
        for (int i = 0; i < groupByExpr.size(); ++i) {
            ASTNode node = groupByExpr.get(i);
            exprPos.put(node.toStringTree(), i);
        }
        ASTNode root = parseInfo.getGroupByForClause(dest);
        ArrayList<Long> result = new ArrayList<Long>(root == null ? 0 : root.getChildCount());
        if (root != null) {
            for (int i = 0; i < root.getChildCount(); ++i) {
                ASTNode child = (ASTNode)root.getChild(i);
                if (child.getType() != 1050) continue;
                long bitmap = LongMath.pow((long)2L, (int)groupByExpr.size()) - 1L;
                for (int j = 0; j < child.getChildCount(); ++j) {
                    String treeAsString = child.getChild(j).toStringTree();
                    Integer pos = (Integer)exprPos.get(treeAsString);
                    if (pos == null) {
                        throw new SemanticException(SemanticAnalyzer.generateErrorMessage((ASTNode)child.getChild(j), ErrorMsg.HIVE_GROUPING_SETS_EXPR_NOT_IN_GROUPBY.getErrorCodedMsg()));
                    }
                    bitmap = this.unsetBit(bitmap, groupByExpr.size() - pos - 1);
                    this.unparseTranslator.addCopyTranslation((ASTNode)child.getChild(j), groupByExpr.get(pos));
                }
                result.add(bitmap);
            }
        }
        if (this.checkForEmptyGroupingSets(result, LongMath.pow((long)2L, (int)groupByExpr.size()) - 1L)) {
            throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_EMPTY.getMsg());
        }
        return result;
    }

    private boolean checkForEmptyGroupingSets(List<Long> bitmaps, long groupingIdAllSet) {
        boolean ret = true;
        for (long mask : bitmaps) {
            ret &= mask == groupingIdAllSet;
        }
        return ret;
    }

    public static long setBit(long bitmap, int bitIdx) {
        return bitmap | 1L << bitIdx;
    }

    private long unsetBit(long bitmap, int bitIdx) {
        return bitmap & (1L << bitIdx ^ 0xFFFFFFFFFFFFFFFFL);
    }

    List<ASTNode> getGroupByForClause(QBParseInfo parseInfo, String dest) throws SemanticException {
        ASTNode selectExpr = parseInfo.getSelForClause(dest);
        Collection<ASTNode> aggregateFunction = parseInfo.getDestToAggregationExprs().get(dest).values();
        if (!(this instanceof CalcitePlanner) && this.isSelectDistinct(selectExpr) && this.hasGroupBySibling(selectExpr)) {
            throw new SemanticException("SELECT DISTINCT with GROUP BY is only supported with CBO");
        }
        if (this.isSelectDistinct(selectExpr) && !this.hasGroupBySibling(selectExpr) && !this.isAggregateInSelect((Node)selectExpr, aggregateFunction)) {
            ArrayList<ASTNode> result = new ArrayList<ASTNode>(selectExpr.getChildCount());
            for (int i = 0; i < selectExpr.getChildCount(); ++i) {
                if (((ASTNode)selectExpr.getChild(i)).getToken().getType() == 430) continue;
                ASTNode grpbyExpr = (ASTNode)selectExpr.getChild(i).getChild(0);
                result.add(grpbyExpr);
            }
            return result;
        }
        ASTNode grpByExprs = parseInfo.getGroupByForClause(dest);
        ArrayList<ASTNode> result = new ArrayList<ASTNode>(grpByExprs == null ? 0 : grpByExprs.getChildCount());
        if (grpByExprs != null) {
            for (int i = 0; i < grpByExprs.getChildCount(); ++i) {
                ASTNode grpbyExpr = (ASTNode)grpByExprs.getChild(i);
                if (grpbyExpr.getType() == 1050) continue;
                result.add(grpbyExpr);
            }
        }
        return result;
    }

    protected boolean hasGroupBySibling(ASTNode selectExpr) {
        boolean isGroupBy = false;
        if (selectExpr.getParent() != null && selectExpr.getParent() instanceof Node) {
            for (Node sibling : ((Node)selectExpr.getParent()).getChildren()) {
                isGroupBy |= sibling instanceof ASTNode && ((ASTNode)sibling).getType() == 1048;
            }
        }
        return isGroupBy;
    }

    protected boolean isSelectDistinct(ASTNode expr) {
        return expr.getType() == 1197;
    }

    private boolean isAggregateInSelect(Node node, Collection<ASTNode> aggregateFunction) {
        if (node.getChildren() == null) {
            return false;
        }
        for (Node child : node.getChildren()) {
            if (!aggregateFunction.contains(child) && !this.isAggregateInSelect(child, aggregateFunction)) continue;
            return true;
        }
        return false;
    }

    static String[] getColAlias(ASTNode selExpr, String defaultName, RowResolver inputRR, boolean includeFuncName, int colNum) {
        Object colAlias = null;
        String tabAlias = null;
        String[] colRef = new String[2];
        if (selExpr.getChildCount() == 2 || selExpr.getChildCount() == 3 && selExpr.getChild(2).getType() == 1326) {
            colAlias = SemanticAnalyzer.unescapeIdentifier(selExpr.getChild(1).getText().toLowerCase());
            colRef[0] = tabAlias;
            colRef[1] = colAlias;
            return colRef;
        }
        ASTNode root = (ASTNode)selExpr.getChild(0);
        if (root.getType() == 1276) {
            colAlias = BaseSemanticAnalyzer.unescapeIdentifier(root.getChild(0).getText().toLowerCase());
            colRef[0] = tabAlias;
            colRef[1] = colAlias;
            return colRef;
        }
        if (root.getType() == 16) {
            ASTNode col;
            String t;
            ASTNode tab = (ASTNode)root.getChild(0);
            if (tab.getType() == 1276 && inputRR.hasTableAlias(t = SemanticAnalyzer.unescapeIdentifier(tab.getChild(0).getText()))) {
                tabAlias = t;
            }
            if ((col = (ASTNode)root.getChild(1)).getType() == 24) {
                colAlias = SemanticAnalyzer.unescapeIdentifier(col.getText().toLowerCase());
            }
        }
        if (includeFuncName && root.getType() == 1039) {
            String expr_flattened = root.toStringTree();
            String expr_no_tok = expr_flattened.replaceAll("tok_\\S+", "");
            String expr_formatted = expr_no_tok.replaceAll("\\W", " ").trim().replaceAll("\\s+", "_");
            if (expr_formatted.length() > 20) {
                expr_formatted = expr_formatted.substring(0, 20);
            }
            colAlias = expr_formatted.concat("_" + colNum);
        }
        if (colAlias == null) {
            colAlias = defaultName + colNum;
        }
        colRef[0] = tabAlias;
        colRef[1] = colAlias;
        return colRef;
    }

    static boolean isRegex(String pattern, HiveConf conf) {
        String qIdSupport = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_QUOTEDID_SUPPORT);
        if (!"none".equals(qIdSupport)) {
            return false;
        }
        for (int i = 0; i < pattern.length(); ++i) {
            if (Character.isLetterOrDigit(pattern.charAt(i)) || pattern.charAt(i) == '_') continue;
            return true;
        }
        return false;
    }

    private Operator<?> genSelectPlan(String dest, QB qb, Operator<?> input, Operator<?> inputForSelectStar) throws SemanticException {
        ASTNode selExprList = qb.getParseInfo().getSelForClause(dest);
        Operator<?> op = this.genSelectPlan(dest, selExprList, qb, input, inputForSelectStar, false);
        this.LOG.debug("Created Select Plan for clause: {}", (Object)dest);
        return op;
    }

    private Operator<?> genSelectPlan(String dest, ASTNode selExprList, QB qb, Operator<?> input, Operator<?> inputForSelectStar, boolean outerLV) throws SemanticException {
        int startPosn;
        boolean isInTransform;
        boolean hintPresent;
        this.LOG.debug("tree: {}", (Object)selExprList.toStringTree());
        ArrayList<ExprNodeDesc> colList = new ArrayList<ExprNodeDesc>();
        RowResolver out_rwsch = new RowResolver();
        ASTNode trfm = null;
        Integer pos = 0;
        RowResolver inputRR = this.opParseCtx.get(input).getRowResolver();
        RowResolver starRR = null;
        if (inputForSelectStar != null && inputForSelectStar != input) {
            starRR = this.opParseCtx.get(inputForSelectStar).getRowResolver();
        }
        boolean selectStar = false;
        int posn = 0;
        boolean bl = hintPresent = selExprList.getChild(0).getType() == 430;
        if (hintPresent) {
            ++posn;
        }
        boolean bl2 = isInTransform = selExprList.getChild(posn).getChild(0).getType() == 1293;
        if (isInTransform) {
            this.queryProperties.setUsesScript(true);
            this.globalLimitCtx.setHasTransformOrUDTF(true);
            trfm = (ASTNode)selExprList.getChild(posn).getChild(0);
        }
        boolean isUDTF = false;
        String udtfTableAlias = null;
        ArrayList<String> udtfColAliases = new ArrayList<String>();
        ASTNode udtfExpr = (ASTNode)selExprList.getChild(posn).getChild(0);
        GenericUDTF genericUDTF = null;
        int udtfExprType = udtfExpr.getType();
        if (udtfExprType == 1039 || udtfExprType == 1041) {
            String funcName = TypeCheckProcFactory.getFunctionText(udtfExpr, true);
            FunctionInfo fi = FunctionRegistry.getFunctionInfo(funcName);
            if (fi != null) {
                genericUDTF = fi.getGenericUDTF();
            }
            boolean bl3 = isUDTF = genericUDTF != null;
            if (isUDTF) {
                this.globalLimitCtx.setHasTransformOrUDTF(true);
            }
            if (isUDTF && !fi.isNative()) {
                this.unparseTranslator.addIdentifierTranslation((ASTNode)udtfExpr.getChild(0));
            }
            if (isUDTF && (selectStar = udtfExprType == 1041)) {
                this.genExprNodeDescRegex(".*", null, (ASTNode)udtfExpr.getChild(0), colList, null, inputRR, starRR, pos, out_rwsch, qb.getAliases(), false);
            }
        }
        if (isUDTF) {
            if (selExprList.getChildCount() > 1) {
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage((ASTNode)selExprList.getChild(1), ErrorMsg.UDTF_MULTIPLE_EXPR.getMsg()));
            }
            ASTNode selExpr = (ASTNode)selExprList.getChild(posn);
            block4: for (int i = 1; i < selExpr.getChildCount(); ++i) {
                ASTNode selExprChild = (ASTNode)selExpr.getChild(i);
                switch (selExprChild.getType()) {
                    case 24: {
                        udtfColAliases.add(SemanticAnalyzer.unescapeIdentifier(selExprChild.getText().toLowerCase()));
                        this.unparseTranslator.addIdentifierTranslation(selExprChild);
                        continue block4;
                    }
                    case 1250: {
                        assert (selExprChild.getChildCount() == 1);
                        udtfTableAlias = SemanticAnalyzer.unescapeIdentifier(selExprChild.getChild(0).getText());
                        qb.addAlias(udtfTableAlias);
                        this.unparseTranslator.addIdentifierTranslation((ASTNode)selExprChild.getChild(0));
                        continue block4;
                    }
                    default: {
                        assert (false);
                        continue block4;
                    }
                }
            }
            this.LOG.debug("UDTF table alias is {}", udtfTableAlias);
            this.LOG.debug("UDTF col aliases are {}", udtfColAliases);
        }
        ASTNode exprList = isInTransform ? (ASTNode)trfm.getChild(0) : (isUDTF ? udtfExpr : selExprList);
        this.LOG.debug("genSelectPlan: input = {} starRr = {}", (Object)inputRR, (Object)starRR);
        int n = startPosn = isUDTF ? posn + 1 : posn;
        if (isInTransform) {
            startPosn = 0;
        }
        boolean cubeRollupGrpSetPresent = !qb.getParseInfo().getDestRollups().isEmpty() || !qb.getParseInfo().getDestGroupingSets().isEmpty() || !qb.getParseInfo().getDestCubes().isEmpty();
        HashSet<CallSite> colAliases = new HashSet<CallSite>();
        int offset = 0;
        for (int i = startPosn; i < exprList.getChildCount(); ++i) {
            ExprNodeColumnDesc colExp;
            String[] altMapping;
            ExprNodeDesc exp;
            String recommended;
            ASTNode expr;
            Object colAlias;
            String tabAlias;
            boolean isWindowSpec;
            ASTNode child = (ASTNode)exprList.getChild(i);
            boolean hasAsClause = !isInTransform && child.getChildCount() == 2;
            boolean bl4 = isWindowSpec = child.getChildCount() == 3 && child.getChild(2).getType() == 1326;
            if (!(isWindowSpec || isInTransform || isUDTF || child.getChildCount() <= 2)) {
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage((ASTNode)child.getChild(2), ErrorMsg.INVALID_AS.getMsg()));
            }
            if (isInTransform || isUDTF) {
                tabAlias = null;
                colAlias = this.autogenColAliasPrfxLbl + i;
                expr = child;
            } else {
                expr = (ASTNode)child.getChild(0);
                String[] colRef = SemanticAnalyzer.getColAlias(child, this.autogenColAliasPrfxLbl, inputRR, this.autogenColAliasPrfxIncludeFuncName, i + offset);
                tabAlias = colRef[0];
                colAlias = colRef[1];
                if (hasAsClause) {
                    this.unparseTranslator.addIdentifierTranslation((ASTNode)child.getChild(1));
                }
            }
            colAliases.add((CallSite)colAlias);
            if (expr.getType() == 843) {
                int initPos = pos;
                pos = this.genExprNodeDescRegex(".*", expr.getChildCount() == 0 ? null : SemanticAnalyzer.getUnescapedName((ASTNode)expr.getChild(0)).toLowerCase(), expr, colList, null, inputRR, starRR, pos, out_rwsch, qb.getAliases(), false);
                if (this.unparseTranslator.isEnabled()) {
                    offset += pos - initPos - 1;
                }
                selectStar = true;
                continue;
            }
            if (expr.getType() == 1276 && !hasAsClause && !inputRR.getIsExprResolver() && SemanticAnalyzer.isRegex(SemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getText()), this.conf)) {
                pos = this.genExprNodeDescRegex(SemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getText()), null, expr, colList, null, inputRR, starRR, pos, out_rwsch, qb.getAliases(), false);
                continue;
            }
            if (expr.getType() == 16 && expr.getChild(0).getType() == 1276 && inputRR.hasTableAlias(SemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getChild(0).getText().toLowerCase())) && !hasAsClause && !inputRR.getIsExprResolver() && SemanticAnalyzer.isRegex(SemanticAnalyzer.unescapeIdentifier(expr.getChild(1).getText()), this.conf)) {
                pos = this.genExprNodeDescRegex(SemanticAnalyzer.unescapeIdentifier(expr.getChild(1).getText()), SemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getChild(0).getText().toLowerCase()), expr, colList, null, inputRR, starRR, pos, out_rwsch, qb.getAliases(), false);
                continue;
            }
            TypeCheckCtx tcCtx = new TypeCheckCtx(inputRR, true, this.isCBOExecuted());
            tcCtx.setAllowStatefulFunctions(true);
            tcCtx.setAllowDistinctFunctions(false);
            if (!this.isCBOExecuted() && !qb.getParseInfo().getDestToGroupBy().isEmpty()) {
                expr = this.rewriteGroupingFunctionAST(this.getGroupByForClause(qb.getParseInfo(), dest), expr, !cubeRollupGrpSetPresent);
            }
            if ((recommended = this.recommendName(exp = this.genExprNodeDesc(expr, inputRR, tcCtx), (String)colAlias)) != null && !colAliases.contains(recommended) && out_rwsch.get(null, recommended) == null) {
                colAlias = recommended;
            }
            colList.add(exp);
            ColumnInfo colInfo = new ColumnInfo(SemanticAnalyzer.getColumnInternalName(pos), exp.getWritableObjectInspector(), tabAlias, false);
            colInfo.setSkewedCol(exp instanceof ExprNodeColumnDesc && ((ExprNodeColumnDesc)exp).isSkewedCol());
            out_rwsch.put(tabAlias, (String)colAlias, colInfo);
            if (exp instanceof ExprNodeColumnDesc && (altMapping = inputRR.getAlternateMappings((colExp = (ExprNodeColumnDesc)exp).getColumn())) != null) {
                out_rwsch.put(altMapping[0], altMapping[1], colInfo);
            }
            Integer n2 = pos;
            pos = pos + 1;
        }
        Operator<?> output = this.generateSelectOperator(dest, selExprList, qb, input, exprList, out_rwsch, colList, selectStar, posn);
        if (isInTransform) {
            output = this.genScriptPlan(trfm, qb, output);
        }
        if (isUDTF) {
            output = this.genUDTFPlan(genericUDTF, udtfTableAlias, udtfColAliases, qb, output, outerLV);
            if (!HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CBO_ENABLED) && qb.getParseInfo().getDestSchemaForClause(dest) != null) {
                List<ExprNodeDesc> expColList = this.explodeColListForUDTF(colList);
                output = this.generateSelectOperator(dest, selExprList, qb, output, exprList, this.opParseCtx.get(output).getRowResolver(), expColList, selectStar, posn);
            }
        }
        this.LOG.debug("Created Select Plan row schema: {}", (Object)out_rwsch);
        return output;
    }

    private Operator<?> generateSelectOperator(String dest, ASTNode selExprList, QB qb, Operator<?> input, ASTNode exprList, RowResolver out_rwsch, List<ExprNodeDesc> colList, boolean selectStar, int posn) throws SemanticException {
        selectStar = selectStar && exprList.getChildCount() == posn + 1;
        out_rwsch = this.handleInsertStatementSpec(colList, dest, out_rwsch, qb, selExprList);
        ArrayList<String> columnNames = new ArrayList<String>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        for (int i = 0; i < colList.size(); ++i) {
            String outputCol = SemanticAnalyzer.getColumnInternalName(i);
            colExprMap.put(outputCol, colList.get(i));
            columnNames.add(outputCol);
        }
        Operator<SelectDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new SelectDesc(colList, columnNames, selectStar), new RowSchema(out_rwsch.getColumnInfos()), input, new Operator[0]), out_rwsch);
        output.setColumnExprMap(colExprMap);
        return output;
    }

    private RowResolver getColForInsertStmtSpec(Map<String, ExprNodeDesc> targetCol2Projection, org.apache.hadoop.hive.ql.metadata.Table target, Map<String, ColumnInfo> targetCol2ColumnInfo, int colListPos, List<TypeInfo> targetTableColTypes, List<ExprNodeDesc> newColList, List<String> targetTableColNames) throws SemanticException {
        RowResolver newOutputRR = new RowResolver();
        Map<String, String> colNameToDefaultVal = null;
        if (targetCol2Projection.size() < targetTableColNames.size()) {
            colNameToDefaultVal = this.getColNameToDefaultValueMap(target);
        }
        HashSet<String> missingColumns = new HashSet<String>();
        for (int i = 0; i < targetTableColNames.size(); ++i) {
            String f = targetTableColNames.get(i);
            if (targetCol2Projection.containsKey(f)) {
                newColList.add(targetCol2Projection.get(f));
                ColumnInfo ci = targetCol2ColumnInfo.get(f);
                ci.setInternalName(SemanticAnalyzer.getColumnInternalName(colListPos));
                newOutputRR.put(ci.getTabAlias(), ci.getInternalName(), ci);
            } else {
                assert (colNameToDefaultVal != null);
                missingColumns.add(f);
                ExprNodeDesc exp = null;
                if (colNameToDefaultVal.containsKey(f)) {
                    String defaultValue = colNameToDefaultVal.get(f);
                    ParseDriver parseDriver = new ParseDriver();
                    try {
                        ASTNode defValAst = parseDriver.parseExpression(defaultValue);
                        exp = ExprNodeTypeCheck.genExprNode(defValAst, new TypeCheckCtx(null)).get(defValAst);
                    }
                    catch (Exception e) {
                        throw new SemanticException("Error while parsing default value: " + defaultValue + ". Error message: " + e.getMessage());
                    }
                    this.LOG.debug("Added default value from metastore: {}", (Object)exp);
                } else {
                    exp = new ExprNodeConstantDesc(targetTableColTypes.get(i), null);
                }
                newColList.add(exp);
                String tableAlias = null;
                ColumnInfo colInfo = new ColumnInfo(SemanticAnalyzer.getColumnInternalName(colListPos), ((ExprNodeDesc)exp).getWritableObjectInspector(), tableAlias, false);
                newOutputRR.put(colInfo.getTabAlias(), colInfo.getInternalName(), colInfo);
            }
            ++colListPos;
        }
        SessionStateUtil.addResource((Configuration)this.conf, "missingColumns", missingColumns);
        return newOutputRR;
    }

    List<ExprNodeDesc> explodeColListForUDTF(List<ExprNodeDesc> colList) {
        ArrayList<ExprNodeDesc> expColList = new ArrayList<ExprNodeDesc>();
        ListTypeInfo typeInfo = (ListTypeInfo)colList.get(0).getTypeInfo();
        StructTypeInfo elementTypeInfo = (StructTypeInfo)typeInfo.getListElementTypeInfo();
        List fieldNames = elementTypeInfo.getAllStructFieldNames();
        List typeInfos = elementTypeInfo.getAllStructFieldTypeInfos();
        for (int i = 0; i < fieldNames.size(); ++i) {
            ExprNodeColumnDesc colDesc = new ExprNodeColumnDesc();
            colDesc.setColumn((String)fieldNames.get(i));
            colDesc.setTypeInfo((TypeInfo)typeInfos.get(i));
            expColList.add(colDesc);
        }
        return expColList;
    }

    RowResolver handleInsertStatementSpec(List<ExprNodeDesc> col_list, String dest, RowResolver outputRR, QB qb, ASTNode selExprList) throws SemanticException {
        org.apache.hadoop.hive.ql.metadata.Partition partition;
        List<String> targetTableSchema = qb.getParseInfo().getDestSchemaForClause(dest);
        if (targetTableSchema == null) {
            return outputRR;
        }
        if (targetTableSchema.size() != col_list.size()) {
            if (!HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CBO_ENABLED) && col_list.get(0).getTypeInfo() instanceof ListTypeInfo && targetTableSchema.size() == this.explodeColListForUDTF(col_list).size()) {
                return outputRR;
            }
            org.apache.hadoop.hive.ql.metadata.Table target = qb.getMetaData().getDestTableForAlias(dest);
            org.apache.hadoop.hive.ql.metadata.Partition partition2 = target == null ? qb.getMetaData().getDestPartitionForAlias(dest) : null;
            throw new SemanticException(SemanticAnalyzer.generateErrorMessage(selExprList, "Expected " + targetTableSchema.size() + " columns for " + dest + (String)(target != null ? "/" + target.getCompleteName() : (partition2 != null ? "/" + partition2.getCompleteName() : "")) + "; select produces " + col_list.size() + " columns"));
        }
        HashMap<String, ExprNodeDesc> targetCol2Projection = new HashMap<String, ExprNodeDesc>();
        HashMap<String, ColumnInfo> targetCol2ColumnInfo = new HashMap<String, ColumnInfo>();
        int colListPos = 0;
        for (String targetCol : targetTableSchema) {
            targetCol2ColumnInfo.put(targetCol, outputRR.getColumnInfos().get(colListPos));
            targetCol2Projection.put(targetCol, col_list.get(colListPos++));
        }
        org.apache.hadoop.hive.ql.metadata.Table target = qb.getMetaData().getDestTableForAlias(dest);
        org.apache.hadoop.hive.ql.metadata.Partition partition2 = partition = target == null ? qb.getMetaData().getDestPartitionForAlias(dest) : null;
        if (target == null && partition == null) {
            throw new SemanticException(SemanticAnalyzer.generateErrorMessage(selExprList, "No table/partition found in QB metadata for dest='" + dest + "'"));
        }
        ArrayList<ExprNodeDesc> newColList = new ArrayList<ExprNodeDesc>();
        colListPos = 0;
        List<FieldSchema> targetTableCols = target != null ? target.getCols() : partition.getCols();
        ArrayList<String> targetTableColNames = new ArrayList<String>();
        ArrayList<TypeInfo> targetTableColTypes = new ArrayList<TypeInfo>();
        for (FieldSchema fieldSchema : targetTableCols) {
            targetTableColNames.add(fieldSchema.getName());
            targetTableColTypes.add(TypeInfoUtils.getTypeInfoFromTypeString((String)fieldSchema.getType()));
        }
        Map<String, String> partSpec = qb.getMetaData().getPartSpecForAlias(dest);
        if (partSpec != null && 2 != qb.getMetaData().getDestTypeForAlias(dest)) {
            for (Map.Entry<String, String> entry : partSpec.entrySet()) {
                if (entry.getValue() != null) continue;
                targetTableColNames.add(entry.getKey());
                targetTableColTypes.add((TypeInfo)TypeInfoFactory.stringTypeInfo);
            }
        }
        org.apache.hadoop.hive.ql.metadata.Table table = target == null ? partition.getTable() : target;
        RowResolver rowResolver = this.getColForInsertStmtSpec(targetCol2Projection, table, targetCol2ColumnInfo, colListPos, targetTableColTypes, newColList, targetTableColNames);
        col_list.clear();
        col_list.addAll(newColList);
        return rowResolver;
    }

    String recommendName(ExprNodeDesc exp, String colAlias) {
        if (!colAlias.startsWith(this.autogenColAliasPrfxLbl)) {
            return null;
        }
        String column = ExprNodeDescUtils.recommendInputName(exp);
        if (column != null && !column.startsWith(this.autogenColAliasPrfxLbl)) {
            return column;
        }
        return null;
    }

    String getAutogenColAliasPrfxLbl() {
        return this.autogenColAliasPrfxLbl;
    }

    boolean autogenColAliasPrfxIncludeFuncName() {
        return this.autogenColAliasPrfxIncludeFuncName;
    }

    static List<ObjectInspector> getWritableObjectInspector(List<ExprNodeDesc> exprs) {
        return exprs.stream().map(ExprNodeDesc::getWritableObjectInspector).collect(Collectors.toList());
    }

    public static GenericUDAFEvaluator getGenericUDAFEvaluator(String aggName, List<ExprNodeDesc> aggParameters, ASTNode aggTree, boolean isDistinct, boolean isAllColumns) throws SemanticException {
        return SemanticAnalyzer.getGenericUDAFEvaluator2(aggName, SemanticAnalyzer.getWritableObjectInspector(aggParameters), aggTree, isDistinct, isAllColumns);
    }

    public static GenericUDAFEvaluator getGenericUDAFEvaluator2(String aggName, List<ObjectInspector> aggParameterOIs, ASTNode aggTree, boolean isDistinct, boolean isAllColumns) throws SemanticException {
        GenericUDAFEvaluator result = FunctionRegistry.getGenericUDAFEvaluator(aggName, aggParameterOIs, isDistinct, isAllColumns);
        if (null == result) {
            String reason = "Looking for UDAF Evaluator\"" + aggName + "\" with parameters " + String.valueOf(aggParameterOIs);
            throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_FUNCTION_SIGNATURE.getMsg(), (ASTNode)((ASTNode)aggTree.getChild(0)), (String)reason));
        }
        return result;
    }

    public static GenericUDAFInfo getGenericUDAFInfo(GenericUDAFEvaluator evaluator, GenericUDAFEvaluator.Mode emode, List<ExprNodeDesc> aggParameters) throws SemanticException {
        GenericUDAFInfo udafInfo = SemanticAnalyzer.getGenericUDAFInfo2(evaluator, emode, SemanticAnalyzer.getWritableObjectInspector(aggParameters));
        udafInfo.convertedParameters = aggParameters;
        return udafInfo;
    }

    public static GenericUDAFInfo getGenericUDAFInfo2(GenericUDAFEvaluator evaluator, GenericUDAFEvaluator.Mode emode, List<ObjectInspector> aggOIs) throws SemanticException {
        GenericUDAFInfo r = new GenericUDAFInfo();
        r.genericUDAFEvaluator = evaluator;
        ObjectInspector returnOI = null;
        try {
            ObjectInspector[] aggOIArray = new ObjectInspector[aggOIs.size()];
            for (int ii = 0; ii < aggOIs.size(); ++ii) {
                aggOIArray[ii] = aggOIs.get(ii);
            }
            returnOI = r.genericUDAFEvaluator.init(emode, aggOIArray);
            r.returnType = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)returnOI);
        }
        catch (HiveException e) {
            throw new SemanticException((Throwable)e);
        }
        return r;
    }

    public static GenericUDAFEvaluator.Mode groupByDescModeToUDAFMode(GroupByDesc.Mode mode, boolean isDistinct) {
        switch (mode) {
            case COMPLETE: {
                return GenericUDAFEvaluator.Mode.COMPLETE;
            }
            case HASH: 
            case PARTIAL1: {
                return GenericUDAFEvaluator.Mode.PARTIAL1;
            }
            case PARTIAL2: {
                return GenericUDAFEvaluator.Mode.PARTIAL2;
            }
            case PARTIALS: {
                return isDistinct ? GenericUDAFEvaluator.Mode.PARTIAL1 : GenericUDAFEvaluator.Mode.PARTIAL2;
            }
            case FINAL: {
                return GenericUDAFEvaluator.Mode.FINAL;
            }
            case MERGEPARTIAL: {
                return isDistinct ? GenericUDAFEvaluator.Mode.COMPLETE : GenericUDAFEvaluator.Mode.FINAL;
            }
        }
        throw new RuntimeException("internal error in groupByDescModeToUDAFMode");
    }

    public static ExprNodeDesc isConstantParameterInAggregationParameters(String internalName, List<ExprNodeDesc> reduceValues) {
        ExprNodeDesc reduceValue;
        int pos;
        String[] terms = internalName.split("\\.");
        if (terms.length != 2 || reduceValues == null) {
            return null;
        }
        if (Utilities.ReduceField.VALUE.toString().equals(terms[0]) && (pos = HiveConf.getPositionFromInternalName((String)terms[1])) >= 0 && pos < reduceValues.size() && (reduceValue = reduceValues.get(pos)) != null && reduceValue.getWritableObjectInspector() instanceof ConstantObjectInspector) {
            return reduceValue;
        }
        return null;
    }

    private Operator genGroupByPlanGroupByOperator(QBParseInfo parseInfo, String dest, Operator input, ReduceSinkOperator rs, GroupByDesc.Mode mode, Map<String, GenericUDAFEvaluator> genericUDAFEvaluators) throws SemanticException {
        RowResolver groupByInputRowResolver = this.opParseCtx.get(input).getRowResolver();
        RowResolver groupByOutputRowResolver = new RowResolver();
        groupByOutputRowResolver.setIsExprResolver(true);
        ArrayList<ExprNodeDesc> groupByKeys = new ArrayList<ExprNodeDesc>();
        ArrayList<AggregationDesc> aggregations = new ArrayList<AggregationDesc>();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        List<ASTNode> grpByExprs = this.getGroupByForClause(parseInfo, dest);
        for (int i = 0; i < grpByExprs.size(); ++i) {
            ASTNode grpbyExpr = grpByExprs.get(i);
            ColumnInfo exprInfo = groupByInputRowResolver.getExpression(grpbyExpr);
            if (exprInfo == null) {
                throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_COLUMN.getMsg(), (ASTNode)grpbyExpr));
            }
            groupByKeys.add(new ExprNodeColumnDesc(exprInfo.getType(), exprInfo.getInternalName(), "", false));
            String field = SemanticAnalyzer.getColumnInternalName(i);
            outputColumnNames.add(field);
            ColumnInfo oColInfo = new ColumnInfo(field, exprInfo.getType(), null, false);
            groupByOutputRowResolver.putExpression(grpbyExpr, oColInfo);
            this.addAlternateGByKeyMappings(grpbyExpr, oColInfo, input, groupByOutputRowResolver);
            colExprMap.put(field, (ExprNodeDesc)groupByKeys.get(groupByKeys.size() - 1));
        }
        Map<String, ASTNode> aggregationTrees = parseInfo.getAggregationExprsForClause(dest);
        assert (aggregationTrees != null);
        String lastKeyColName = null;
        List<String> inputKeyCols = ((ReduceSinkDesc)rs.getConf()).getOutputKeyColumnNames();
        if (inputKeyCols.size() > 0) {
            lastKeyColName = inputKeyCols.get(inputKeyCols.size() - 1);
        }
        List<ExprNodeDesc> reduceValues = ((ReduceSinkDesc)rs.getConf()).getValueCols();
        int numDistinctUDFs = 0;
        for (Map.Entry<String, ASTNode> entry : aggregationTrees.entrySet()) {
            ASTNode value = entry.getValue();
            String aggName = SemanticAnalyzer.unescapeIdentifier(value.getChild(0).getText());
            boolean isDistinct = value.getType() == 1040;
            boolean isAllColumns = value.getType() == 1041;
            ArrayList<ExprNodeDesc> aggParameters = new ArrayList<ExprNodeDesc>();
            for (int i = 1; i < value.getChildCount(); ++i) {
                ASTNode paraExpr = (ASTNode)value.getChild(i);
                ColumnInfo paraExprInfo = groupByInputRowResolver.getExpression(paraExpr);
                if (paraExprInfo == null) {
                    throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_COLUMN.getMsg(), (ASTNode)paraExpr));
                }
                Object paraExpression = paraExprInfo.getInternalName();
                assert (paraExpression != null);
                if (isDistinct && lastKeyColName != null) {
                    paraExpression = Utilities.ReduceField.KEY.name() + "." + lastKeyColName + ":" + numDistinctUDFs + "." + SemanticAnalyzer.getColumnInternalName(i - 1);
                }
                ExprNodeDesc expr = new ExprNodeColumnDesc(paraExprInfo.getType(), (String)paraExpression, paraExprInfo.getTabAlias(), paraExprInfo.getIsVirtualCol());
                ExprNodeDesc reduceValue = SemanticAnalyzer.isConstantParameterInAggregationParameters(paraExprInfo.getInternalName(), reduceValues);
                if (reduceValue != null) {
                    expr = reduceValue;
                }
                aggParameters.add(expr);
            }
            if (isDistinct) {
                ++numDistinctUDFs;
            }
            GenericUDAFEvaluator.Mode amode = SemanticAnalyzer.groupByDescModeToUDAFMode(mode, isDistinct);
            GenericUDAFEvaluator genericUDAFEvaluator = SemanticAnalyzer.getGenericUDAFEvaluator(aggName, aggParameters, value, isDistinct, isAllColumns);
            assert (genericUDAFEvaluator != null);
            GenericUDAFInfo udaf = SemanticAnalyzer.getGenericUDAFInfo(genericUDAFEvaluator, amode, aggParameters);
            aggregations.add(new AggregationDesc(aggName.toLowerCase(), udaf.genericUDAFEvaluator, udaf.convertedParameters, isDistinct, amode));
            String field = SemanticAnalyzer.getColumnInternalName(groupByKeys.size() + aggregations.size() - 1);
            outputColumnNames.add(field);
            groupByOutputRowResolver.putExpression(value, new ColumnInfo(field, udaf.returnType, "", false));
            if (genericUDAFEvaluators == null) continue;
            genericUDAFEvaluators.put(entry.getKey(), genericUDAFEvaluator);
        }
        float groupByMemoryUsage = HiveConf.getFloatVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAP_AGGR_HASH_MEMORY);
        float memoryThreshold = HiveConf.getFloatVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAP_AGGR_MEMORY_THRESHOLD);
        float minReductionHashAggr = HiveConf.getFloatVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAP_AGGR_HASH_MIN_REDUCTION);
        float minReductionHashAggrLowerBound = HiveConf.getFloatVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAP_AGGR_HASH_MIN_REDUCTION_LOWER_BOUND);
        float hashAggrFlushPercent = HiveConf.getFloatVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAP_AGGR_HASH_FLUSH_SIZE_PERCENT);
        Operator<GroupByDesc> op = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new GroupByDesc(mode, outputColumnNames, groupByKeys, aggregations, false, groupByMemoryUsage, memoryThreshold, minReductionHashAggr, minReductionHashAggrLowerBound, hashAggrFlushPercent, null, false, -1, numDistinctUDFs > 0), new RowSchema(groupByOutputRowResolver.getColumnInfos()), input, new Operator[0]), groupByOutputRowResolver);
        op.setColumnExprMap(colExprMap);
        return op;
    }

    private void addGroupingSetKey(List<ExprNodeDesc> groupByKeys, RowResolver groupByInputRowResolver, RowResolver groupByOutputRowResolver, List<String> outputColumnNames, Map<String, ExprNodeDesc> colExprMap) throws SemanticException {
        String groupingSetColumnName = groupByInputRowResolver.get(null, VirtualColumn.GROUPINGID.getName()).getInternalName();
        ExprNodeColumnDesc inputExpr = new ExprNodeColumnDesc(VirtualColumn.GROUPINGID.getTypeInfo(), groupingSetColumnName, null, false);
        groupByKeys.add(inputExpr);
        String field = SemanticAnalyzer.getColumnInternalName(groupByKeys.size() - 1);
        outputColumnNames.add(field);
        groupByOutputRowResolver.put(null, VirtualColumn.GROUPINGID.getName(), new ColumnInfo(field, VirtualColumn.GROUPINGID.getTypeInfo(), null, true));
        colExprMap.put(field, groupByKeys.get(groupByKeys.size() - 1));
    }

    private void processGroupingSetReduceSinkOperator(RowResolver reduceSinkInputRowResolver, RowResolver reduceSinkOutputRowResolver, List<ExprNodeDesc> reduceKeys, List<String> outputKeyColumnNames, Map<String, ExprNodeDesc> colExprMap) throws SemanticException {
        String groupingSetColumnName = reduceSinkInputRowResolver.get(null, VirtualColumn.GROUPINGID.getName()).getInternalName();
        ExprNodeColumnDesc inputExpr = new ExprNodeColumnDesc(VirtualColumn.GROUPINGID.getTypeInfo(), groupingSetColumnName, null, false);
        reduceKeys.add(inputExpr);
        outputKeyColumnNames.add(SemanticAnalyzer.getColumnInternalName(reduceKeys.size() - 1));
        String field = Utilities.ReduceField.KEY.toString() + "." + SemanticAnalyzer.getColumnInternalName(reduceKeys.size() - 1);
        ColumnInfo colInfo = new ColumnInfo(field, reduceKeys.get(reduceKeys.size() - 1).getTypeInfo(), null, true);
        reduceSinkOutputRowResolver.put(null, VirtualColumn.GROUPINGID.getName(), colInfo);
        colExprMap.put(colInfo.getInternalName(), inputExpr);
    }

    private Operator genGroupByPlanGroupByOperator1(QBParseInfo parseInfo, String dest, Operator reduceSinkOperatorInfo, GroupByDesc.Mode mode, Map<String, GenericUDAFEvaluator> genericUDAFEvaluators, List<Long> groupingSets, boolean groupingSetsPresent, boolean groupingSetsNeedAdditionalMRJob) throws SemanticException {
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        RowResolver groupByInputRowResolver = this.opParseCtx.get(reduceSinkOperatorInfo).getRowResolver();
        RowResolver groupByOutputRowResolver = new RowResolver();
        groupByOutputRowResolver.setIsExprResolver(true);
        ArrayList<ExprNodeDesc> groupByKeys = new ArrayList<ExprNodeDesc>();
        ArrayList<AggregationDesc> aggregations = new ArrayList<AggregationDesc>();
        List<ASTNode> grpByExprs = this.getGroupByForClause(parseInfo, dest);
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        for (int i = 0; i < grpByExprs.size(); ++i) {
            ASTNode grpbyExpr = grpByExprs.get(i);
            ColumnInfo exprInfo = groupByInputRowResolver.getExpression(grpbyExpr);
            if (exprInfo == null) {
                throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_COLUMN.getMsg(), (ASTNode)grpbyExpr));
            }
            groupByKeys.add(new ExprNodeColumnDesc(exprInfo));
            String field = SemanticAnalyzer.getColumnInternalName(i);
            outputColumnNames.add(field);
            ColumnInfo oColInfo = new ColumnInfo(field, exprInfo.getType(), "", false);
            groupByOutputRowResolver.putExpression(grpbyExpr, oColInfo);
            this.addAlternateGByKeyMappings(grpbyExpr, oColInfo, reduceSinkOperatorInfo, groupByOutputRowResolver);
            colExprMap.put(field, (ExprNodeDesc)groupByKeys.get(groupByKeys.size() - 1));
        }
        int groupingSetsPosition = -1;
        if (groupingSetsPresent) {
            groupingSetsPosition = groupByKeys.size();
            if (!groupingSetsNeedAdditionalMRJob) {
                this.addGroupingSetKey(groupByKeys, groupByInputRowResolver, groupByOutputRowResolver, outputColumnNames, colExprMap);
            } else {
                this.createNewGroupingKey(groupByKeys, outputColumnNames, groupByOutputRowResolver, colExprMap);
            }
        }
        Map<String, ASTNode> aggregationTrees = parseInfo.getAggregationExprsForClause(dest);
        String lastKeyColName = null;
        List<ExprNodeDesc> reduceValues = null;
        if (reduceSinkOperatorInfo.getConf() instanceof ReduceSinkDesc) {
            List<String> inputKeyCols = ((ReduceSinkDesc)reduceSinkOperatorInfo.getConf()).getOutputKeyColumnNames();
            if (inputKeyCols.size() > 0) {
                lastKeyColName = inputKeyCols.get(inputKeyCols.size() - 1);
            }
            reduceValues = ((ReduceSinkDesc)reduceSinkOperatorInfo.getConf()).getValueCols();
        }
        int numDistinctUDFs = 0;
        boolean containsDistinctAggr = false;
        for (Map.Entry<String, ASTNode> entry : aggregationTrees.entrySet()) {
            ASTNode value = entry.getValue();
            String aggName = SemanticAnalyzer.unescapeIdentifier(value.getChild(0).getText());
            ArrayList<ExprNodeDesc> aggParameters = new ArrayList<ExprNodeDesc>();
            boolean isDistinct = value.getType() == 1040;
            boolean bl = containsDistinctAggr = containsDistinctAggr || isDistinct;
            if (isDistinct) {
                for (int i = 1; i < value.getChildCount(); ++i) {
                    ASTNode paraExpr = (ASTNode)value.getChild(i);
                    ColumnInfo paraExprInfo = groupByInputRowResolver.getExpression(paraExpr);
                    if (paraExprInfo == null) {
                        throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_COLUMN.getMsg(), (ASTNode)paraExpr));
                    }
                    Object paraExpression = paraExprInfo.getInternalName();
                    assert (paraExpression != null);
                    if (lastKeyColName != null) {
                        paraExpression = Utilities.ReduceField.KEY.name() + "." + lastKeyColName + ":" + numDistinctUDFs + "." + SemanticAnalyzer.getColumnInternalName(i - 1);
                    }
                    ExprNodeDesc expr = new ExprNodeColumnDesc(paraExprInfo.getType(), (String)paraExpression, paraExprInfo.getTabAlias(), paraExprInfo.getIsVirtualCol());
                    ExprNodeDesc reduceValue = SemanticAnalyzer.isConstantParameterInAggregationParameters(paraExprInfo.getInternalName(), reduceValues);
                    if (reduceValue != null) {
                        expr = reduceValue;
                    }
                    aggParameters.add(expr);
                }
            } else {
                ColumnInfo paraExprInfo = groupByInputRowResolver.getExpression(value);
                if (paraExprInfo == null) {
                    throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_COLUMN.getMsg(), (ASTNode)value));
                }
                String paraExpression = paraExprInfo.getInternalName();
                assert (paraExpression != null);
                aggParameters.add(new ExprNodeColumnDesc(paraExprInfo.getType(), paraExpression, paraExprInfo.getTabAlias(), paraExprInfo.getIsVirtualCol()));
            }
            if (isDistinct) {
                ++numDistinctUDFs;
            }
            GenericUDAFEvaluator.Mode amode = SemanticAnalyzer.groupByDescModeToUDAFMode(mode, isDistinct);
            GenericUDAFEvaluator genericUDAFEvaluator = null;
            genericUDAFEvaluator = genericUDAFEvaluators.get(entry.getKey());
            assert (genericUDAFEvaluator != null);
            GenericUDAFInfo udaf = SemanticAnalyzer.getGenericUDAFInfo(genericUDAFEvaluator, amode, aggParameters);
            aggregations.add(new AggregationDesc(aggName.toLowerCase(), udaf.genericUDAFEvaluator, udaf.convertedParameters, mode != GroupByDesc.Mode.FINAL && isDistinct, amode));
            String field = SemanticAnalyzer.getColumnInternalName(groupByKeys.size() + aggregations.size() - 1);
            outputColumnNames.add(field);
            groupByOutputRowResolver.putExpression(value, new ColumnInfo(field, udaf.returnType, "", false));
        }
        float groupByMemoryUsage = HiveConf.getFloatVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAP_AGGR_HASH_MEMORY);
        float memoryThreshold = HiveConf.getFloatVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAP_AGGR_MEMORY_THRESHOLD);
        float minReductionHashAggr = HiveConf.getFloatVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAP_AGGR_HASH_MIN_REDUCTION);
        float minReductionHashAggrLowerBound = HiveConf.getFloatVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAP_AGGR_HASH_MIN_REDUCTION_LOWER_BOUND);
        float hashAggrFlushPercent = HiveConf.getFloatVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAP_AGGR_HASH_FLUSH_SIZE_PERCENT);
        Operator<GroupByDesc> op = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new GroupByDesc(mode, outputColumnNames, groupByKeys, aggregations, groupByMemoryUsage, memoryThreshold, minReductionHashAggr, minReductionHashAggrLowerBound, hashAggrFlushPercent, groupingSets, groupingSetsPresent && groupingSetsNeedAdditionalMRJob, groupingSetsPosition, containsDistinctAggr), new RowSchema(groupByOutputRowResolver.getColumnInfos()), reduceSinkOperatorInfo, new Operator[0]), groupByOutputRowResolver);
        op.setColumnExprMap(colExprMap);
        return op;
    }

    private void createNewGroupingKey(List<ExprNodeDesc> groupByKeys, List<String> outputColumnNames, RowResolver groupByOutputRowResolver, Map<String, ExprNodeDesc> colExprMap) {
        ExprNodeConstantDesc constant = new ExprNodeConstantDesc(VirtualColumn.GROUPINGID.getTypeInfo(), 0L);
        groupByKeys.add(constant);
        String field = SemanticAnalyzer.getColumnInternalName(groupByKeys.size() - 1);
        outputColumnNames.add(field);
        groupByOutputRowResolver.put(null, VirtualColumn.GROUPINGID.getName(), new ColumnInfo(field, VirtualColumn.GROUPINGID.getTypeInfo(), null, true));
        colExprMap.put(field, constant);
    }

    private Operator genGroupByPlanMapGroupByOperator(QB qb, String dest, List<ASTNode> grpByExprs, Operator inputOperatorInfo, Map<String, GenericUDAFEvaluator> genericUDAFEvaluators, List<Long> groupingSetKeys, boolean groupingSetsPresent) throws SemanticException {
        RowResolver groupByInputRowResolver = this.opParseCtx.get(inputOperatorInfo).getRowResolver();
        QBParseInfo parseInfo = qb.getParseInfo();
        RowResolver groupByOutputRowResolver = new RowResolver();
        groupByOutputRowResolver.setIsExprResolver(true);
        ArrayList<ExprNodeDesc> groupByKeys = new ArrayList<ExprNodeDesc>();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        ArrayList<AggregationDesc> aggregations = new ArrayList<AggregationDesc>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        for (int i = 0; i < grpByExprs.size(); ++i) {
            ASTNode grpbyExpr = grpByExprs.get(i);
            ExprNodeDesc grpByExprNode = this.genExprNodeDesc(grpbyExpr, groupByInputRowResolver);
            if (grpByExprNode instanceof ExprNodeColumnDesc && ExprNodeDescUtils.indexOf(grpByExprNode, groupByKeys) >= 0) {
                grpByExprs.remove(i--);
                continue;
            }
            groupByKeys.add(grpByExprNode);
            String field = SemanticAnalyzer.getColumnInternalName(i);
            outputColumnNames.add(field);
            groupByOutputRowResolver.putExpression(grpbyExpr, new ColumnInfo(field, grpByExprNode.getTypeInfo(), "", false));
            colExprMap.put(field, (ExprNodeDesc)groupByKeys.get(groupByKeys.size() - 1));
        }
        int groupingSetsPosition = -1;
        if (groupingSetsPresent) {
            groupingSetsPosition = groupByKeys.size();
            this.createNewGroupingKey(groupByKeys, outputColumnNames, groupByOutputRowResolver, colExprMap);
        }
        if (!parseInfo.getDistinctFuncExprsForClause(dest).isEmpty()) {
            List<ASTNode> list = parseInfo.getDistinctFuncExprsForClause(dest);
            for (ASTNode value : list) {
                for (int i = 1; i < value.getChildCount(); ++i) {
                    ASTNode parameter = (ASTNode)value.getChild(i);
                    if (groupByOutputRowResolver.getExpression(parameter) != null) continue;
                    ExprNodeDesc distExprNode = this.genExprNodeDesc(parameter, groupByInputRowResolver);
                    groupByKeys.add(distExprNode);
                    String field = SemanticAnalyzer.getColumnInternalName(groupByKeys.size() - 1);
                    outputColumnNames.add(field);
                    groupByOutputRowResolver.putExpression(parameter, new ColumnInfo(field, distExprNode.getTypeInfo(), "", false));
                    colExprMap.put(field, (ExprNodeDesc)groupByKeys.get(groupByKeys.size() - 1));
                }
            }
        }
        Map<String, ASTNode> aggregationTrees = parseInfo.getAggregationExprsForClause(dest);
        assert (aggregationTrees != null);
        boolean containsDistinctAggr = false;
        for (Map.Entry entry : aggregationTrees.entrySet()) {
            ASTNode value = (ASTNode)entry.getValue();
            String aggName = SemanticAnalyzer.unescapeIdentifier(value.getChild(0).getText());
            ArrayList<ExprNodeDesc> aggParameters = new ArrayList<ExprNodeDesc>();
            for (int i = 1; i < value.getChildCount(); ++i) {
                ASTNode paraExpr = (ASTNode)value.getChild(i);
                ExprNodeDesc paraExprNode = this.genExprNodeDesc(paraExpr, groupByInputRowResolver);
                aggParameters.add(paraExprNode);
            }
            boolean isDistinct = value.getType() == 1040;
            containsDistinctAggr = containsDistinctAggr || isDistinct;
            boolean isAllColumns = value.getType() == 1041;
            GenericUDAFEvaluator.Mode amode = SemanticAnalyzer.groupByDescModeToUDAFMode(GroupByDesc.Mode.HASH, isDistinct);
            GenericUDAFEvaluator genericUDAFEvaluator = SemanticAnalyzer.getGenericUDAFEvaluator(aggName, aggParameters, value, isDistinct, isAllColumns);
            assert (genericUDAFEvaluator != null);
            GenericUDAFInfo udaf = SemanticAnalyzer.getGenericUDAFInfo(genericUDAFEvaluator, amode, aggParameters);
            aggregations.add(new AggregationDesc(aggName.toLowerCase(), udaf.genericUDAFEvaluator, udaf.convertedParameters, isDistinct, amode));
            String field = SemanticAnalyzer.getColumnInternalName(groupByKeys.size() + aggregations.size() - 1);
            outputColumnNames.add(field);
            if (groupByOutputRowResolver.getExpression(value) == null) {
                groupByOutputRowResolver.putExpression(value, new ColumnInfo(field, udaf.returnType, "", false));
            }
            if (genericUDAFEvaluators == null) continue;
            genericUDAFEvaluators.put((String)entry.getKey(), genericUDAFEvaluator);
        }
        float groupByMemoryUsage = HiveConf.getFloatVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAP_AGGR_HASH_MEMORY);
        float f = HiveConf.getFloatVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAP_AGGR_MEMORY_THRESHOLD);
        float minReductionHashAggr = HiveConf.getFloatVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAP_AGGR_HASH_MIN_REDUCTION);
        float minReductionHashAggrLowerBound = HiveConf.getFloatVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAP_AGGR_HASH_MIN_REDUCTION_LOWER_BOUND);
        float hashAggrFlushPercent = HiveConf.getFloatVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAP_AGGR_HASH_FLUSH_SIZE_PERCENT);
        Operator<GroupByDesc> op = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new GroupByDesc(GroupByDesc.Mode.HASH, outputColumnNames, groupByKeys, aggregations, false, groupByMemoryUsage, f, minReductionHashAggr, minReductionHashAggrLowerBound, hashAggrFlushPercent, groupingSetKeys, groupingSetsPresent, groupingSetsPosition, containsDistinctAggr), new RowSchema(groupByOutputRowResolver.getColumnInfos()), inputOperatorInfo, new Operator[0]), groupByOutputRowResolver);
        op.setColumnExprMap(colExprMap);
        return op;
    }

    private ReduceSinkOperator genGroupByPlanReduceSinkOperator(QB qb, String dest, Operator inputOperatorInfo, List<ASTNode> grpByExprs, int numPartitionFields, boolean changeNumPartitionFields, int numReducers, boolean mapAggrDone, boolean groupingSetsPresent) throws SemanticException {
        RowResolver reduceSinkInputRowResolver = this.opParseCtx.get(inputOperatorInfo).getRowResolver();
        QBParseInfo parseInfo = qb.getParseInfo();
        RowResolver reduceSinkOutputRowResolver = new RowResolver();
        reduceSinkOutputRowResolver.setIsExprResolver(true);
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        ArrayList<String> outputKeyColumnNames = new ArrayList<String>();
        ArrayList<String> outputValueColumnNames = new ArrayList<String>();
        List<ExprNodeDesc> reduceKeys = this.getReduceKeysForReduceSink(grpByExprs, reduceSinkInputRowResolver, reduceSinkOutputRowResolver, outputKeyColumnNames, colExprMap);
        int keyLength = reduceKeys.size();
        int numOfColsRmedFromkey = grpByExprs.size() - keyLength;
        if (groupingSetsPresent) {
            this.processGroupingSetReduceSinkOperator(reduceSinkInputRowResolver, reduceSinkOutputRowResolver, reduceKeys, outputKeyColumnNames, colExprMap);
            if (changeNumPartitionFields) {
                ++numPartitionFields;
            }
        }
        List<List<Integer>> distinctColIndices = this.getDistinctColIndicesForReduceSink(parseInfo, dest, reduceKeys, reduceSinkInputRowResolver, reduceSinkOutputRowResolver, outputKeyColumnNames, colExprMap);
        ArrayList<ExprNodeDesc> reduceValues = new ArrayList<ExprNodeDesc>();
        Map<String, ASTNode> aggregationTrees = parseInfo.getAggregationExprsForClause(dest);
        if (!mapAggrDone) {
            this.getReduceValuesForReduceSinkNoMapAgg(parseInfo, dest, reduceSinkInputRowResolver, reduceSinkOutputRowResolver, outputValueColumnNames, reduceValues, colExprMap);
        } else {
            int inputField = reduceKeys.size() + numOfColsRmedFromkey;
            for (Map.Entry<String, ASTNode> entry : aggregationTrees.entrySet()) {
                TypeInfo type = reduceSinkInputRowResolver.getColumnInfos().get(inputField).getType();
                ExprNodeColumnDesc exprDesc = new ExprNodeColumnDesc(type, SemanticAnalyzer.getColumnInternalName(inputField), "", false);
                reduceValues.add(exprDesc);
                ++inputField;
                String outputColName = SemanticAnalyzer.getColumnInternalName(reduceValues.size() - 1);
                outputValueColumnNames.add(outputColName);
                String internalName = Utilities.ReduceField.VALUE.toString() + "." + outputColName;
                reduceSinkOutputRowResolver.putExpression(entry.getValue(), new ColumnInfo(internalName, type, null, false));
                colExprMap.put(internalName, exprDesc);
            }
        }
        ReduceSinkOperator rsOp = (ReduceSinkOperator)this.putOpInsertMap(OperatorFactory.getAndMakeChild(PlanUtils.getReduceSinkDesc(reduceKeys, groupingSetsPresent ? keyLength + 1 : keyLength, reduceValues, distinctColIndices, outputKeyColumnNames, outputValueColumnNames, true, -1, numPartitionFields, numReducers, AcidUtils.Operation.NOT_ACID, this.defaultNullOrder), new RowSchema(reduceSinkOutputRowResolver.getColumnInfos()), inputOperatorInfo, new Operator[0]), reduceSinkOutputRowResolver);
        rsOp.setColumnExprMap(colExprMap);
        return rsOp;
    }

    private List<ExprNodeDesc> getReduceKeysForReduceSink(List<ASTNode> grpByExprs, RowResolver reduceSinkInputRowResolver, RowResolver reduceSinkOutputRowResolver, List<String> outputKeyColumnNames, Map<String, ExprNodeDesc> colExprMap) throws SemanticException {
        ArrayList<ExprNodeDesc> reduceKeys = new ArrayList<ExprNodeDesc>();
        for (ASTNode grpbyExpr : grpByExprs) {
            ExprNodeDesc inputExpr = this.genExprNodeDesc(grpbyExpr, reduceSinkInputRowResolver);
            ColumnInfo prev = reduceSinkOutputRowResolver.getExpression(grpbyExpr);
            if (prev != null && this.isConsistentWithinQuery(inputExpr)) {
                colExprMap.put(prev.getInternalName(), inputExpr);
                continue;
            }
            reduceKeys.add(inputExpr);
            outputKeyColumnNames.add(SemanticAnalyzer.getColumnInternalName(reduceKeys.size() - 1));
            String field = Utilities.ReduceField.KEY.toString() + "." + SemanticAnalyzer.getColumnInternalName(reduceKeys.size() - 1);
            ColumnInfo colInfo = new ColumnInfo(field, ((ExprNodeDesc)reduceKeys.get(reduceKeys.size() - 1)).getTypeInfo(), null, false);
            reduceSinkOutputRowResolver.putExpression(grpbyExpr, colInfo);
            colExprMap.put(colInfo.getInternalName(), inputExpr);
        }
        return reduceKeys;
    }

    private boolean isConsistentWithinQuery(ExprNodeDesc expr) throws SemanticException {
        try {
            return ExprNodeEvaluatorFactory.get(expr).isConsistentWithinQuery();
        }
        catch (Exception e) {
            throw new SemanticException((Throwable)e);
        }
    }

    private List<List<Integer>> getDistinctColIndicesForReduceSink(QBParseInfo parseInfo, String dest, List<ExprNodeDesc> reduceKeys, RowResolver reduceSinkInputRowResolver, RowResolver reduceSinkOutputRowResolver, List<String> outputKeyColumnNames, Map<String, ExprNodeDesc> colExprMap) throws SemanticException {
        ArrayList<List<Integer>> distinctColIndices = new ArrayList<List<Integer>>();
        if (!parseInfo.getDistinctFuncExprsForClause(dest).isEmpty()) {
            List<ASTNode> distFuncs = parseInfo.getDistinctFuncExprsForClause(dest);
            String colName = SemanticAnalyzer.getColumnInternalName(reduceKeys.size());
            outputKeyColumnNames.add(colName);
            for (int i = 0; i < distFuncs.size(); ++i) {
                ASTNode value = distFuncs.get(i);
                int numExprs = 0;
                ArrayList<Integer> distinctIndices = new ArrayList<Integer>();
                for (int j = 1; j < value.getChildCount(); ++j) {
                    int ri;
                    ASTNode parameter = (ASTNode)value.getChild(j);
                    ExprNodeDesc expr = this.genExprNodeDesc(parameter, reduceSinkInputRowResolver);
                    for (ri = 0; ri < reduceKeys.size() && !reduceKeys.get(ri).getExprString().equals(expr.getExprString()); ++ri) {
                    }
                    if (ri == reduceKeys.size()) {
                        String name = SemanticAnalyzer.getColumnInternalName(numExprs);
                        String field = Utilities.ReduceField.KEY.toString() + "." + colName + ":" + i + "." + name;
                        ColumnInfo colInfo = new ColumnInfo(field, expr.getTypeInfo(), null, false);
                        reduceSinkOutputRowResolver.putExpression(parameter, colInfo);
                        colExprMap.put(field, expr);
                        reduceKeys.add(expr);
                    }
                    distinctIndices.add(ri);
                    ++numExprs;
                }
                distinctColIndices.add(distinctIndices);
            }
        }
        return distinctColIndices;
    }

    private void getReduceValuesForReduceSinkNoMapAgg(QBParseInfo parseInfo, String dest, RowResolver reduceSinkInputRowResolver, RowResolver reduceSinkOutputRowResolver, List<String> outputValueColumnNames, List<ExprNodeDesc> reduceValues, Map<String, ExprNodeDesc> colExprMap) throws SemanticException {
        Map<String, ASTNode> aggregationTrees = parseInfo.getAggregationExprsForClause(dest);
        for (Map.Entry<String, ASTNode> entry : aggregationTrees.entrySet()) {
            ASTNode value = entry.getValue();
            for (int i = 1; i < value.getChildCount(); ++i) {
                ASTNode parameter = (ASTNode)value.getChild(i);
                if (reduceSinkOutputRowResolver.getExpression(parameter) != null) continue;
                ExprNodeDesc exprDesc = this.genExprNodeDesc(parameter, reduceSinkInputRowResolver);
                reduceValues.add(exprDesc);
                outputValueColumnNames.add(SemanticAnalyzer.getColumnInternalName(reduceValues.size() - 1));
                String field = Utilities.ReduceField.VALUE.toString() + "." + SemanticAnalyzer.getColumnInternalName(reduceValues.size() - 1);
                reduceSinkOutputRowResolver.putExpression(parameter, new ColumnInfo(field, reduceValues.get(reduceValues.size() - 1).getTypeInfo(), null, false));
                colExprMap.put(field, exprDesc);
            }
        }
    }

    private ReduceSinkOperator genCommonGroupByPlanReduceSinkOperator(QB qb, List<String> dests, Operator inputOperatorInfo) throws SemanticException {
        RowResolver reduceSinkInputRowResolver = this.opParseCtx.get(inputOperatorInfo).getRowResolver();
        QBParseInfo parseInfo = qb.getParseInfo();
        RowResolver reduceSinkOutputRowResolver = new RowResolver();
        reduceSinkOutputRowResolver.setIsExprResolver(true);
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        String dest = dests.get(0);
        ArrayList<String> outputKeyColumnNames = new ArrayList<String>();
        ArrayList<String> outputValueColumnNames = new ArrayList<String>();
        List<ASTNode> grpByExprs = this.getGroupByForClause(parseInfo, dest);
        List<ExprNodeDesc> reduceKeys = this.getReduceKeysForReduceSink(grpByExprs, reduceSinkInputRowResolver, reduceSinkOutputRowResolver, outputKeyColumnNames, colExprMap);
        int keyLength = reduceKeys.size();
        List<List<Integer>> distinctColIndices = this.getDistinctColIndicesForReduceSink(parseInfo, dest, reduceKeys, reduceSinkInputRowResolver, reduceSinkOutputRowResolver, outputKeyColumnNames, colExprMap);
        ArrayList<ExprNodeDesc> reduceValues = new ArrayList<ExprNodeDesc>();
        for (String destination : dests) {
            this.getReduceValuesForReduceSinkNoMapAgg(parseInfo, destination, reduceSinkInputRowResolver, reduceSinkOutputRowResolver, outputValueColumnNames, reduceValues, colExprMap);
            ASTNode whereClause = parseInfo.getWhrForClause(destination);
            if (whereClause == null) continue;
            assert (whereClause.getChildCount() == 1);
            ASTNode predicates = (ASTNode)whereClause.getChild(0);
            Map<ASTNode, ExprNodeDesc> nodeOutputs = this.genAllExprNodeDesc(predicates, reduceSinkInputRowResolver);
            this.removeMappingForKeys(predicates, nodeOutputs, reduceKeys);
            for (Map.Entry<ASTNode, ExprNodeDesc> entry : nodeOutputs.entrySet()) {
                ASTNode parameter = entry.getKey();
                ExprNodeDesc expression = entry.getValue();
                if (!(expression instanceof ExprNodeColumnDesc) && !ExprNodeConstantDesc.isFoldedFromCol(expression) || ExprNodeDescUtils.indexOf(expression, reduceValues) >= 0) continue;
                String internalName = SemanticAnalyzer.getColumnInternalName(reduceValues.size());
                String field = Utilities.ReduceField.VALUE.toString() + "." + internalName;
                reduceValues.add(expression);
                outputValueColumnNames.add(internalName);
                reduceSinkOutputRowResolver.putExpression(parameter, new ColumnInfo(field, expression.getTypeInfo(), null, false));
                colExprMap.put(field, expression);
            }
        }
        int numReducers = -1;
        if (grpByExprs.isEmpty()) {
            numReducers = 1;
        }
        ReduceSinkDesc rsDesc = PlanUtils.getReduceSinkDesc(reduceKeys, keyLength, reduceValues, distinctColIndices, outputKeyColumnNames, outputValueColumnNames, true, -1, keyLength, numReducers, AcidUtils.Operation.NOT_ACID, this.defaultNullOrder);
        ReduceSinkOperator rsOp = (ReduceSinkOperator)this.putOpInsertMap(OperatorFactory.getAndMakeChild(rsDesc, new RowSchema(reduceSinkOutputRowResolver.getColumnInfos()), inputOperatorInfo, new Operator[0]), reduceSinkOutputRowResolver);
        rsOp.setColumnExprMap(colExprMap);
        return rsOp;
    }

    private void removeMappingForKeys(ASTNode predicate, Map<ASTNode, ExprNodeDesc> mapping, List<ExprNodeDesc> keys) {
        ExprNodeDesc expr = mapping.get(predicate);
        if (expr != null && ExprNodeDescUtils.indexOf(expr, keys) >= 0) {
            this.removeRecursively(predicate, mapping);
        } else {
            for (int i = 0; i < predicate.getChildCount(); ++i) {
                this.removeMappingForKeys((ASTNode)predicate.getChild(i), mapping, keys);
            }
        }
    }

    private void removeRecursively(ASTNode current, Map<ASTNode, ExprNodeDesc> mapping) {
        mapping.remove(current);
        for (int i = 0; i < current.getChildCount(); ++i) {
            this.removeRecursively((ASTNode)current.getChild(i), mapping);
        }
    }

    private Operator genGroupByPlanReduceSinkOperator2MR(QBParseInfo parseInfo, String dest, Operator groupByOperatorInfo, int numPartitionFields, int numReducers, boolean groupingSetsPresent) throws SemanticException {
        RowResolver reduceSinkInputRowResolver2 = this.opParseCtx.get(groupByOperatorInfo).getRowResolver();
        RowResolver reduceSinkOutputRowResolver2 = new RowResolver();
        reduceSinkOutputRowResolver2.setIsExprResolver(true);
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        ArrayList<ExprNodeDesc> reduceKeys = new ArrayList<ExprNodeDesc>();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        List<ASTNode> grpByExprs = this.getGroupByForClause(parseInfo, dest);
        for (int i = 0; i < grpByExprs.size(); ++i) {
            ASTNode grpbyExpr = grpByExprs.get(i);
            String field = SemanticAnalyzer.getColumnInternalName(i);
            outputColumnNames.add(field);
            TypeInfo typeInfo = reduceSinkInputRowResolver2.getExpression(grpbyExpr).getType();
            ExprNodeColumnDesc exprNodeColumnDesc = new ExprNodeColumnDesc(typeInfo, field, "", false);
            reduceKeys.add(exprNodeColumnDesc);
            ColumnInfo colInfo = new ColumnInfo(Utilities.ReduceField.KEY.toString() + "." + field, typeInfo, "", false);
            reduceSinkOutputRowResolver2.putExpression(grpbyExpr, colInfo);
            colExprMap.put(colInfo.getInternalName(), exprNodeColumnDesc);
        }
        if (groupingSetsPresent) {
            this.processGroupingSetReduceSinkOperator(reduceSinkInputRowResolver2, reduceSinkOutputRowResolver2, reduceKeys, outputColumnNames, colExprMap);
        }
        ArrayList<ExprNodeDesc> reduceValues = new ArrayList<ExprNodeDesc>();
        int inputField = reduceKeys.size();
        Map<String, ASTNode> aggregationTrees = parseInfo.getAggregationExprsForClause(dest);
        for (Map.Entry entry : aggregationTrees.entrySet()) {
            String field = SemanticAnalyzer.getColumnInternalName(inputField);
            ASTNode t = (ASTNode)entry.getValue();
            TypeInfo typeInfo = reduceSinkInputRowResolver2.getExpression(t).getType();
            ExprNodeColumnDesc exprDesc = new ExprNodeColumnDesc(typeInfo, field, "", false);
            reduceValues.add(exprDesc);
            ++inputField;
            String col = SemanticAnalyzer.getColumnInternalName(reduceValues.size() - 1);
            outputColumnNames.add(col);
            ColumnInfo colInfo = new ColumnInfo(Utilities.ReduceField.VALUE.toString() + "." + col, typeInfo, "", false);
            reduceSinkOutputRowResolver2.putExpression(t, colInfo);
            colExprMap.put(colInfo.getInternalName(), exprDesc);
        }
        ReduceSinkOperator rsOp = (ReduceSinkOperator)this.putOpInsertMap(OperatorFactory.getAndMakeChild(PlanUtils.getReduceSinkDesc(reduceKeys, reduceValues, outputColumnNames, true, -1, numPartitionFields, numReducers, AcidUtils.Operation.NOT_ACID, this.defaultNullOrder), new RowSchema(reduceSinkOutputRowResolver2.getColumnInfos()), groupByOperatorInfo, new Operator[0]), reduceSinkOutputRowResolver2);
        rsOp.setColumnExprMap(colExprMap);
        return rsOp;
    }

    private Operator genGroupByPlanGroupByOperator2MR(QBParseInfo parseInfo, String dest, Operator reduceSinkOperatorInfo2, Map<String, GenericUDAFEvaluator> genericUDAFEvaluators, boolean groupingSetsPresent) throws SemanticException {
        RowResolver groupByInputRowResolver2 = this.opParseCtx.get(reduceSinkOperatorInfo2).getRowResolver();
        RowResolver groupByOutputRowResolver2 = new RowResolver();
        groupByOutputRowResolver2.setIsExprResolver(true);
        ArrayList<ExprNodeDesc> groupByKeys = new ArrayList<ExprNodeDesc>();
        ArrayList<AggregationDesc> aggregations = new ArrayList<AggregationDesc>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        List<ASTNode> grpByExprs = this.getGroupByForClause(parseInfo, dest);
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        for (int i = 0; i < grpByExprs.size(); ++i) {
            ASTNode grpbyExpr = grpByExprs.get(i);
            ColumnInfo exprInfo = groupByInputRowResolver2.getExpression(grpbyExpr);
            if (exprInfo == null) {
                throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_COLUMN.getMsg(), (ASTNode)grpbyExpr));
            }
            String expression = exprInfo.getInternalName();
            groupByKeys.add(new ExprNodeColumnDesc(exprInfo.getType(), expression, exprInfo.getTabAlias(), exprInfo.getIsVirtualCol()));
            String string = SemanticAnalyzer.getColumnInternalName(i);
            outputColumnNames.add(string);
            ColumnInfo oColInfo = new ColumnInfo(string, exprInfo.getType(), "", false);
            groupByOutputRowResolver2.putExpression(grpbyExpr, oColInfo);
            this.addAlternateGByKeyMappings(grpbyExpr, oColInfo, reduceSinkOperatorInfo2, groupByOutputRowResolver2);
            colExprMap.put(string, (ExprNodeDesc)groupByKeys.get(groupByKeys.size() - 1));
        }
        int groupingSetsPosition = -1;
        if (groupingSetsPresent) {
            groupingSetsPosition = groupByKeys.size();
            this.addGroupingSetKey(groupByKeys, groupByInputRowResolver2, groupByOutputRowResolver2, outputColumnNames, colExprMap);
        }
        Map<String, ASTNode> aggregationTrees = parseInfo.getAggregationExprsForClause(dest);
        boolean containsDistinctAggr = false;
        for (Map.Entry entry : aggregationTrees.entrySet()) {
            ArrayList<ExprNodeDesc> aggParameters = new ArrayList<ExprNodeDesc>();
            ASTNode value = (ASTNode)entry.getValue();
            ColumnInfo paraExprInfo = groupByInputRowResolver2.getExpression(value);
            if (paraExprInfo == null) {
                throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.INVALID_COLUMN.getMsg(), (ASTNode)value));
            }
            String paraExpression = paraExprInfo.getInternalName();
            assert (paraExpression != null);
            aggParameters.add(new ExprNodeColumnDesc(paraExprInfo.getType(), paraExpression, paraExprInfo.getTabAlias(), paraExprInfo.getIsVirtualCol()));
            String aggName = SemanticAnalyzer.unescapeIdentifier(value.getChild(0).getText());
            boolean isDistinct = value.getType() == 1040;
            containsDistinctAggr = containsDistinctAggr || isDistinct;
            GenericUDAFEvaluator.Mode amode = SemanticAnalyzer.groupByDescModeToUDAFMode(GroupByDesc.Mode.FINAL, isDistinct);
            GenericUDAFEvaluator genericUDAFEvaluator = genericUDAFEvaluators.get(entry.getKey());
            assert (genericUDAFEvaluator != null);
            GenericUDAFInfo udaf = SemanticAnalyzer.getGenericUDAFInfo(genericUDAFEvaluator, amode, aggParameters);
            aggregations.add(new AggregationDesc(aggName.toLowerCase(), udaf.genericUDAFEvaluator, udaf.convertedParameters, false, amode));
            String field = SemanticAnalyzer.getColumnInternalName(groupByKeys.size() + aggregations.size() - 1);
            outputColumnNames.add(field);
            groupByOutputRowResolver2.putExpression(value, new ColumnInfo(field, udaf.returnType, "", false));
        }
        float groupByMemoryUsage = HiveConf.getFloatVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAP_AGGR_HASH_MEMORY);
        float f = HiveConf.getFloatVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAP_AGGR_MEMORY_THRESHOLD);
        float minReductionHashAggr = HiveConf.getFloatVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAP_AGGR_HASH_MIN_REDUCTION);
        float minReductionHashAggrLowerBound = HiveConf.getFloatVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAP_AGGR_HASH_MIN_REDUCTION_LOWER_BOUND);
        float hashAggrFlushPercent = HiveConf.getFloatVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAP_AGGR_HASH_FLUSH_SIZE_PERCENT);
        Operator<GroupByDesc> op = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new GroupByDesc(GroupByDesc.Mode.FINAL, outputColumnNames, groupByKeys, aggregations, false, groupByMemoryUsage, f, minReductionHashAggr, minReductionHashAggrLowerBound, hashAggrFlushPercent, null, false, groupingSetsPosition, containsDistinctAggr), new RowSchema(groupByOutputRowResolver2.getColumnInfos()), reduceSinkOperatorInfo2, new Operator[0]), groupByOutputRowResolver2);
        op.setColumnExprMap(colExprMap);
        return op;
    }

    private Operator genGroupByPlan1MR(String dest, QB qb, Operator input) throws SemanticException {
        QBParseInfo parseInfo = qb.getParseInfo();
        int numReducers = -1;
        Pair<List<ASTNode>, List<Long>> grpByExprsGroupingSets = this.getGroupByGroupingSetsForClause(parseInfo, dest);
        List grpByExprs = (List)grpByExprsGroupingSets.getLeft();
        List groupingSets = (List)grpByExprsGroupingSets.getRight();
        if (grpByExprs.isEmpty()) {
            numReducers = 1;
        }
        if (!groupingSets.isEmpty()) {
            throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_AGGR_NOMAPAGGR.getMsg());
        }
        ReduceSinkOperator reduceSinkOperatorInfo = this.genGroupByPlanReduceSinkOperator(qb, dest, input, grpByExprs, grpByExprs.size(), false, numReducers, false, false);
        Operator groupByOperatorInfo = this.genGroupByPlanGroupByOperator(parseInfo, dest, reduceSinkOperatorInfo, reduceSinkOperatorInfo, GroupByDesc.Mode.COMPLETE, null);
        return groupByOperatorInfo;
    }

    private Operator genGroupByPlan1ReduceMultiGBY(List<String> dests, QB qb, Operator input, Map<String, Operator> aliasToOpInfo) throws SemanticException {
        Operator forwardOp;
        QBParseInfo parseInfo = qb.getParseInfo();
        ExprNodeDesc previous = null;
        Operator<FilterDesc> selectInput = input;
        ArrayList<ExprNodeDesc.ExprNodeDescEqualityWrapper> whereExpressions = new ArrayList<ExprNodeDesc.ExprNodeDescEqualityWrapper>();
        for (String dest : dests) {
            Pair<List<ASTNode>, List<Long>> grpByExprsGroupingSets = this.getGroupByGroupingSetsForClause(parseInfo, dest);
            List groupingSets = (List)grpByExprsGroupingSets.getRight();
            if (!groupingSets.isEmpty()) {
                throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_AGGR_NOMAPAGGR_MULTIGBY.getMsg());
            }
            ASTNode whereExpr = parseInfo.getWhrForClause(dest);
            if (whereExpr != null) {
                OpParseContext inputCtx = this.opParseCtx.get(input);
                RowResolver inputRR = inputCtx.getRowResolver();
                ExprNodeDesc current = this.genExprNodeDesc((ASTNode)whereExpr.getChild(0), inputRR);
                ExprNodeDesc.ExprNodeDescEqualityWrapper currentWrapped = new ExprNodeDesc.ExprNodeDescEqualityWrapper(current);
                if (whereExpressions.contains(currentWrapped)) continue;
                whereExpressions.add(currentWrapped);
                if (previous == null) {
                    previous = current;
                    continue;
                }
                GenericUDFOPOr or = new GenericUDFOPOr();
                ArrayList<ExprNodeDesc> expressions = new ArrayList<ExprNodeDesc>(2);
                expressions.add(current);
                expressions.add(previous);
                previous = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, (GenericUDF)or, expressions);
                continue;
            }
            previous = null;
            break;
        }
        if (previous != null) {
            OpParseContext inputCtx = this.opParseCtx.get(input);
            RowResolver inputRR = inputCtx.getRowResolver();
            FilterDesc orFilterDesc = new FilterDesc(previous, false);
            orFilterDesc.setGenerated(true);
            selectInput = this.putOpInsertMap(OperatorFactory.getAndMakeChild(orFilterDesc, new RowSchema(inputRR.getColumnInfos()), (Operator)input, new Operator[0]), inputRR);
        }
        Operator select = this.genSelectAllDesc(selectInput);
        ReduceSinkOperator reduceSinkOperatorInfo = this.genCommonGroupByPlanReduceSinkOperator(qb, dests, select);
        RowResolver reduceSinkOperatorInfoRR = this.opParseCtx.get(reduceSinkOperatorInfo).getRowResolver();
        Operator curr = forwardOp = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new ForwardDesc(), new RowSchema(reduceSinkOperatorInfoRR.getColumnInfos()), (Operator)reduceSinkOperatorInfo, new Operator[0]), reduceSinkOperatorInfoRR);
        for (String dest : dests) {
            curr = forwardOp;
            if (parseInfo.getWhrForClause(dest) != null) {
                ASTNode whereExpr = qb.getParseInfo().getWhrForClause(dest);
                curr = this.genFilterPlan((ASTNode)whereExpr.getChild(0), qb, forwardOp, aliasToOpInfo, false, true);
            }
            Operator groupByOperatorInfo = this.genGroupByPlanGroupByOperator(parseInfo, dest, curr, reduceSinkOperatorInfo, GroupByDesc.Mode.COMPLETE, null);
            curr = this.genPostGroupByBodyPlan(groupByOperatorInfo, dest, qb, aliasToOpInfo, null);
        }
        return curr;
    }

    private Operator genGroupByPlan2MR(String dest, QB qb, Operator input) throws SemanticException {
        QBParseInfo parseInfo = qb.getParseInfo();
        Pair<List<ASTNode>, List<Long>> grpByExprsGroupingSets = this.getGroupByGroupingSetsForClause(parseInfo, dest);
        List grpByExprs = (List)grpByExprsGroupingSets.getLeft();
        List groupingSets = (List)grpByExprsGroupingSets.getRight();
        if (!groupingSets.isEmpty()) {
            throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_AGGR_NOMAPAGGR.getMsg());
        }
        ReduceSinkOperator reduceSinkOperatorInfo = this.genGroupByPlanReduceSinkOperator(qb, dest, input, grpByExprs, parseInfo.getDistinctFuncExprsForClause(dest).isEmpty() ? -1 : Integer.MAX_VALUE, false, -1, false, false);
        LinkedHashMap<String, GenericUDAFEvaluator> genericUDAFEvaluators = new LinkedHashMap<String, GenericUDAFEvaluator>();
        GroupByOperator groupByOperatorInfo = (GroupByOperator)this.genGroupByPlanGroupByOperator(parseInfo, dest, reduceSinkOperatorInfo, reduceSinkOperatorInfo, GroupByDesc.Mode.PARTIAL1, genericUDAFEvaluators);
        int numReducers = -1;
        if (grpByExprs.isEmpty()) {
            numReducers = 1;
        }
        Operator reduceSinkOperatorInfo2 = this.genGroupByPlanReduceSinkOperator2MR(parseInfo, dest, groupByOperatorInfo, grpByExprs.size(), numReducers, false);
        Operator groupByOperatorInfo2 = this.genGroupByPlanGroupByOperator2MR(parseInfo, dest, reduceSinkOperatorInfo2, genericUDAFEvaluators, false);
        return groupByOperatorInfo2;
    }

    private boolean optimizeMapAggrGroupBy(String dest, QB qb) throws SemanticException {
        List<ASTNode> grpByExprs = this.getGroupByForClause(qb.getParseInfo(), dest);
        if (grpByExprs != null && !grpByExprs.isEmpty()) {
            return false;
        }
        return qb.getParseInfo().getDistinctFuncExprsForClause(dest).isEmpty();
    }

    private Operator genGroupByPlanMapAggrNoSkew(String dest, QB qb, Operator inputOperatorInfo) throws SemanticException {
        boolean isDistinct;
        QBParseInfo parseInfo = qb.getParseInfo();
        Pair<List<ASTNode>, List<Long>> grpByExprsGroupingSets = this.getGroupByGroupingSetsForClause(parseInfo, dest);
        List grpByExprs = (List)grpByExprsGroupingSets.getLeft();
        List groupingSets = (List)grpByExprsGroupingSets.getRight();
        boolean groupingSetsPresent = !groupingSets.isEmpty();
        int newMRJobGroupingSetsThreshold = this.conf.getIntVar(HiveConf.ConfVars.HIVE_NEW_JOB_GROUPING_SET_CARDINALITY);
        LinkedHashMap<String, GenericUDAFEvaluator> genericUDAFEvaluators = new LinkedHashMap<String, GenericUDAFEvaluator>();
        boolean groupingSetsNeedAdditionalMRJob = groupingSetsPresent && groupingSets.size() > newMRJobGroupingSetsThreshold;
        GroupByOperator groupByOperatorInfo = (GroupByOperator)this.genGroupByPlanMapGroupByOperator(qb, dest, grpByExprs, inputOperatorInfo, genericUDAFEvaluators, groupingSets, groupingSetsPresent && !groupingSetsNeedAdditionalMRJob);
        this.groupOpToInputTables.put(groupByOperatorInfo, this.opParseCtx.get(inputOperatorInfo).getRowResolver().getTableNames());
        int numReducers = -1;
        if (grpByExprs.isEmpty()) {
            numReducers = 1;
        }
        boolean bl = isDistinct = !qb.getParseInfo().getDistinctFuncExprsForClause(dest).isEmpty();
        if (groupingSetsNeedAdditionalMRJob && isDistinct) {
            String errorMsg = "The number of rows per input row due to grouping sets is " + groupingSets.size();
            throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_THRESHOLD_NOT_ALLOWED_WITH_DISTINCTS.getMsg(errorMsg));
        }
        ReduceSinkOperator reduceSinkOperatorInfo = this.genGroupByPlanReduceSinkOperator(qb, dest, groupByOperatorInfo, grpByExprs, grpByExprs.size(), true, numReducers, true, groupingSetsPresent && !groupingSetsNeedAdditionalMRJob);
        if (!groupingSetsPresent || !groupingSetsNeedAdditionalMRJob) {
            return this.genGroupByPlanGroupByOperator1(parseInfo, dest, reduceSinkOperatorInfo, GroupByDesc.Mode.MERGEPARTIAL, genericUDAFEvaluators, groupingSets, groupingSetsPresent, groupingSetsNeedAdditionalMRJob);
        }
        Operator groupByOperatorInfo2 = this.genGroupByPlanGroupByOperator1(parseInfo, dest, reduceSinkOperatorInfo, GroupByDesc.Mode.PARTIALS, genericUDAFEvaluators, groupingSets, groupingSetsPresent, groupingSetsNeedAdditionalMRJob);
        Operator reduceSinkOperatorInfo2 = this.genGroupByPlanReduceSinkOperator2MR(parseInfo, dest, groupByOperatorInfo2, grpByExprs.size() + 1, numReducers, groupingSetsPresent);
        return this.genGroupByPlanGroupByOperator2MR(parseInfo, dest, reduceSinkOperatorInfo2, genericUDAFEvaluators, groupingSetsPresent);
    }

    private Operator genGroupByPlanMapAggr2MR(String dest, QB qb, Operator inputOperatorInfo) throws SemanticException {
        boolean groupingSetsPresent;
        QBParseInfo parseInfo = qb.getParseInfo();
        Pair<List<ASTNode>, List<Long>> grpByExprsGroupingSets = this.getGroupByGroupingSetsForClause(parseInfo, dest);
        List grpByExprs = (List)grpByExprsGroupingSets.getLeft();
        List groupingSets = (List)grpByExprsGroupingSets.getRight();
        boolean bl = groupingSetsPresent = !groupingSets.isEmpty();
        if (groupingSetsPresent) {
            int newMRJobGroupingSetsThreshold = this.conf.getIntVar(HiveConf.ConfVars.HIVE_NEW_JOB_GROUPING_SET_CARDINALITY);
            if (groupingSets.size() > newMRJobGroupingSetsThreshold) {
                String errorMsg = "The number of rows per input row due to grouping sets is " + groupingSets.size();
                throw new SemanticException(ErrorMsg.HIVE_GROUPING_SETS_THRESHOLD_NOT_ALLOWED_WITH_SKEW.getMsg(errorMsg));
            }
        }
        LinkedHashMap<String, GenericUDAFEvaluator> genericUDAFEvaluators = new LinkedHashMap<String, GenericUDAFEvaluator>();
        GroupByOperator groupByOperatorInfo = (GroupByOperator)this.genGroupByPlanMapGroupByOperator(qb, dest, grpByExprs, inputOperatorInfo, genericUDAFEvaluators, groupingSets, groupingSetsPresent);
        this.groupOpToInputTables.put(groupByOperatorInfo, this.opParseCtx.get(inputOperatorInfo).getRowResolver().getTableNames());
        if (!this.optimizeMapAggrGroupBy(dest, qb)) {
            List<ASTNode> distinctFuncExprs = parseInfo.getDistinctFuncExprsForClause(dest);
            ReduceSinkOperator reduceSinkOperatorInfo = this.genGroupByPlanReduceSinkOperator(qb, dest, groupByOperatorInfo, grpByExprs, distinctFuncExprs.isEmpty() ? -1 : Integer.MAX_VALUE, false, -1, true, groupingSetsPresent);
            Operator groupByOperatorInfo2 = this.genGroupByPlanGroupByOperator1(parseInfo, dest, reduceSinkOperatorInfo, GroupByDesc.Mode.PARTIALS, genericUDAFEvaluators, groupingSets, groupingSetsPresent, false);
            int numReducers = -1;
            if (grpByExprs.isEmpty()) {
                numReducers = 1;
            }
            Operator reduceSinkOperatorInfo2 = this.genGroupByPlanReduceSinkOperator2MR(parseInfo, dest, groupByOperatorInfo2, grpByExprs.size(), numReducers, groupingSetsPresent);
            return this.genGroupByPlanGroupByOperator2MR(parseInfo, dest, reduceSinkOperatorInfo2, genericUDAFEvaluators, groupingSetsPresent);
        }
        assert (!groupingSetsPresent);
        ReduceSinkOperator reduceSinkOperatorInfo = this.genGroupByPlanReduceSinkOperator(qb, dest, groupByOperatorInfo, grpByExprs, grpByExprs.size(), false, 1, true, groupingSetsPresent);
        return this.genGroupByPlanGroupByOperator2MR(parseInfo, dest, reduceSinkOperatorInfo, genericUDAFEvaluators, false);
    }

    private int getReducersBucketing(int totalFiles, int maxReducers) {
        int numFiles = (int)Math.ceil((double)totalFiles / (double)maxReducers);
        while (totalFiles % numFiles != 0) {
            ++numFiles;
        }
        return totalFiles / numFiles;
    }

    /*
     * WARNING - void declaration
     */
    private Operator genBucketingSortingDest(String dest, Operator input, QB qb, TableDesc table_desc, org.apache.hadoop.hive.ql.metadata.Table dest_tab, SortBucketRSCtx ctx) throws SemanticException {
        boolean enforceBucketing = false;
        List<Object> partnCols = new ArrayList();
        List<Object> sortCols = new ArrayList();
        boolean multiFileSpray = false;
        int numFiles = 1;
        int totalFiles = 1;
        boolean isCompaction = false;
        if (dest_tab != null && dest_tab.getParameters() != null) {
            isCompaction = AcidUtils.isCompactionTable(dest_tab.getParameters());
        }
        StringBuilder order = new StringBuilder();
        StringBuilder nullOrder = new StringBuilder();
        if (dest_tab.getNumBuckets() > 0 && !dest_tab.getBucketCols().isEmpty()) {
            enforceBucketing = true;
            if (this.updating(dest) || this.deleting(dest)) {
                partnCols = this.getPartitionColsFromBucketColsForUpdateDelete(input, true);
                sortCols = this.getPartitionColsFromBucketColsForUpdateDelete(input, false);
                this.createSortOrderForUpdateDelete(sortCols, order, nullOrder);
            } else {
                partnCols = this.getPartitionColsFromBucketCols(dest, qb, dest_tab, table_desc, input, false);
            }
        } else if ((this.updating(dest) || this.deleting(dest)) && !AcidUtils.isNonNativeAcidTable(dest_tab)) {
            partnCols = this.getPartitionColsFromBucketColsForUpdateDelete(input, true);
            sortCols = this.getPartitionColsFromBucketColsForUpdateDelete(input, false);
            this.createSortOrderForUpdateDelete(sortCols, order, nullOrder);
            enforceBucketing = true;
        }
        if (dest_tab.getSortCols() != null && dest_tab.getSortCols().size() > 0) {
            sortCols = this.getSortCols(dest, qb, dest_tab, table_desc, input);
            this.getSortOrders(dest_tab, order, nullOrder);
            if (!enforceBucketing) {
                throw new SemanticException(ErrorMsg.TBL_SORTED_NOT_BUCKETED.getErrorCodedMsg(new String[]{dest_tab.getCompleteName()}));
            }
        } else if (HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SORT_WHEN_BUCKETING) && enforceBucketing && !this.updating(dest) && !this.deleting(dest)) {
            sortCols = new ArrayList();
            for (ExprNodeDesc exprNodeDesc : partnCols) {
                sortCols.add(exprNodeDesc.clone());
                order.append(DirectionUtils.codeToSign(1));
                nullOrder.append(NullOrdering.NULLS_FIRST.getSign());
            }
        }
        if (enforceBucketing) {
            void var17_22;
            int numBuckets;
            int n;
            AcidUtils.Operation acidOp = AcidUtils.isFullAcidTable(dest_tab) ? this.getAcidType(table_desc.getOutputFileFormatClass(), dest, AcidUtils.isInsertOnlyTable(dest_tab)) : AcidUtils.Operation.NOT_ACID;
            int n2 = this.conf.getIntVar(HiveConf.ConfVars.MAX_REDUCERS);
            if (this.conf.getIntVar(HiveConf.ConfVars.HADOOP_NUM_REDUCERS) > 0) {
                n = this.conf.getIntVar(HiveConf.ConfVars.HADOOP_NUM_REDUCERS);
            }
            if ((numBuckets = dest_tab.getNumBuckets()) > n) {
                this.LOG.debug("numBuckets is {} and maxReducers is {}", (Object)numBuckets, (Object)n);
                multiFileSpray = true;
                totalFiles = numBuckets;
                if (totalFiles % n == 0) {
                    numFiles = totalFiles / n;
                } else {
                    int n3 = this.getReducersBucketing(totalFiles, n);
                    numFiles = totalFiles / n3;
                }
            } else {
                int n4 = numBuckets;
            }
            input = this.genReduceSinkPlan(input, partnCols, sortCols, order.toString(), nullOrder.toString(), (int)var17_22, acidOp, isCompaction);
            this.reduceSinkOperatorsAddedByEnforceBucketingSorting.add((ReduceSinkOperator)input.getParentOperators().get(0));
            ctx.setMultiFileSpray(multiFileSpray);
            ctx.setNumFiles(numFiles);
            ctx.setTotalFiles(totalFiles);
        }
        return input;
    }

    private void createSortOrderForUpdateDelete(List<ExprNodeDesc> sortCols, StringBuilder sortOrder, StringBuilder nullSortOrder) {
        NullOrdering defaultNullOrder = NullOrdering.defaultNullOrder((Configuration)this.conf);
        for (int i = 0; i < sortCols.size(); ++i) {
            sortOrder.append(DirectionUtils.codeToSign(1));
            nullSortOrder.append(defaultNullOrder.getSign());
        }
    }

    private void genPartnCols(String dest, Operator input, QB qb, TableDesc table_desc, org.apache.hadoop.hive.ql.metadata.Table dest_tab, SortBucketRSCtx ctx) throws SemanticException {
        boolean enforceBucketing = false;
        List<ExprNodeDesc> partnColsNoConvert = new ArrayList<ExprNodeDesc>();
        if (dest_tab.getNumBuckets() > 0) {
            enforceBucketing = true;
            partnColsNoConvert = this.updating(dest) || this.deleting(dest) ? this.getPartitionColsFromBucketColsForUpdateDelete(input, false) : this.getPartitionColsFromBucketCols(dest, qb, dest_tab, table_desc, input, false);
        }
        if (dest_tab.getSortCols() != null && dest_tab.getSortCols().size() > 0) {
            if (!enforceBucketing) {
                throw new SemanticException(ErrorMsg.TBL_SORTED_NOT_BUCKETED.getErrorCodedMsg(new String[]{dest_tab.getCompleteName()}));
            }
            enforceBucketing = true;
        }
        if (enforceBucketing) {
            ctx.setPartnCols(partnColsNoConvert);
        }
    }

    private Operator genMaterializedViewDataOrgPlan(org.apache.hadoop.hive.ql.metadata.Table destinationTable, String sortColsStr, String distributeColsStr, RowResolver inputRR, Operator input) throws SemanticException {
        HashMap<String, Integer> colNameToIdx = new HashMap<String, Integer>();
        for (int i = 0; i < destinationTable.getCols().size(); ++i) {
            colNameToIdx.put(destinationTable.getCols().get(i).getName(), i);
        }
        List<ColumnInfo> colInfos = inputRR.getColumnInfos();
        ArrayList<ColumnInfo> sortColInfos = new ArrayList<ColumnInfo>();
        if (sortColsStr != null) {
            Utilities.decodeColumnNames(sortColsStr).forEach(s -> sortColInfos.add((ColumnInfo)colInfos.get((Integer)colNameToIdx.get(s))));
        }
        ArrayList<ColumnInfo> distributeColInfos = new ArrayList<ColumnInfo>();
        if (distributeColsStr != null) {
            Utilities.decodeColumnNames(distributeColsStr).forEach(s -> distributeColInfos.add((ColumnInfo)colInfos.get((Integer)colNameToIdx.get(s))));
        }
        return this.genMaterializedViewDataOrgPlan(sortColInfos, distributeColInfos, inputRR, input);
    }

    private Operator genMaterializedViewDataOrgPlan(List<ColumnInfo> sortColInfos, List<ColumnInfo> distributeColInfos, RowResolver inputRR, Operator input) {
        Set keys = sortColInfos.stream().map(ColumnInfo::getInternalName).collect(Collectors.toSet());
        Set distributeKeys = distributeColInfos.stream().map(ColumnInfo::getInternalName).collect(Collectors.toSet());
        ArrayList<ExprNodeDesc> keyCols = new ArrayList<ExprNodeDesc>();
        ArrayList<String> keyColNames = new ArrayList<String>();
        StringBuilder order = new StringBuilder();
        StringBuilder nullOrder = new StringBuilder();
        ArrayList<ExprNodeDesc> valCols = new ArrayList<ExprNodeDesc>();
        ArrayList<String> valColNames = new ArrayList<String>();
        ArrayList<ExprNodeDesc> partCols = new ArrayList<ExprNodeDesc>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        HashMap<String, CallSite> nameMapping = new HashMap<String, CallSite>();
        for (ColumnInfo ci : inputRR.getRowSchema().getSignature()) {
            ExprNodeColumnDesc e = new ExprNodeColumnDesc(ci);
            String columnName = ci.getInternalName();
            if (keys.contains(columnName)) {
                keyColNames.add(columnName);
                keyCols.add(e);
                colExprMap.put(String.valueOf((Object)Utilities.ReduceField.KEY) + "." + columnName, e);
                nameMapping.put(columnName, (CallSite)((Object)(String.valueOf((Object)Utilities.ReduceField.KEY) + "." + columnName)));
                order.append("+");
                nullOrder.append("a");
            } else {
                valColNames.add(columnName);
                valCols.add(e);
                colExprMap.put(String.valueOf((Object)Utilities.ReduceField.VALUE) + "." + columnName, e);
                nameMapping.put(columnName, (CallSite)((Object)(String.valueOf((Object)Utilities.ReduceField.VALUE) + "." + columnName)));
            }
            if (!distributeKeys.contains(columnName)) continue;
            partCols.add(e.clone());
        }
        List<FieldSchema> fields = PlanUtils.getFieldSchemasFromColumnList(keyCols, keyColNames, 0, "");
        TableDesc keyTable = PlanUtils.getReduceKeyTableDesc(fields, order.toString(), nullOrder.toString());
        List<FieldSchema> valFields = PlanUtils.getFieldSchemasFromColumnList(valCols, valColNames, 0, "");
        TableDesc valueTable = PlanUtils.getReduceValueTableDesc(valFields);
        ArrayList<List<Integer>> distinctColumnIndices = new ArrayList<List<Integer>>();
        ReduceSinkDesc rsConf = new ReduceSinkDesc(keyCols, keyCols.size(), valCols, keyColNames, distinctColumnIndices, valColNames, -1, partCols, -1, keyTable, valueTable, AcidUtils.Operation.NOT_ACID);
        RowResolver rsRR = new RowResolver();
        ArrayList<ColumnInfo> rsSignature = new ArrayList<ColumnInfo>();
        for (int index = 0; index < input.getSchema().getSignature().size(); ++index) {
            ColumnInfo colInfo = new ColumnInfo(input.getSchema().getSignature().get(index));
            String[] nm = inputRR.reverseLookup(colInfo.getInternalName());
            String[] nm2 = inputRR.getAlternateMappings(colInfo.getInternalName());
            colInfo.setInternalName((String)nameMapping.get(colInfo.getInternalName()));
            rsSignature.add(colInfo);
            rsRR.put(nm[0], nm[1], colInfo);
            if (nm2 == null) continue;
            rsRR.addMappingOnly(nm2[0], nm2[1], colInfo);
        }
        Operator<AbstractOperatorDesc> result = this.putOpInsertMap(OperatorFactory.getAndMakeChild(rsConf, new RowSchema(rsSignature), input, new Operator[0]), rsRR);
        result.setColumnExprMap(colExprMap);
        RowResolver selRR = new RowResolver();
        ArrayList<ColumnInfo> selSignature = new ArrayList<ColumnInfo>();
        ArrayList<ExprNodeDesc> columnExprs = new ArrayList<ExprNodeDesc>();
        ArrayList<String> colNames = new ArrayList<String>();
        HashMap<String, ExprNodeDesc> selColExprMap = new HashMap<String, ExprNodeDesc>();
        for (int index = 0; index < input.getSchema().getSignature().size(); ++index) {
            ExprNodeColumnDesc exprNodeDesc;
            String colName;
            ColumnInfo colInfo = new ColumnInfo(input.getSchema().getSignature().get(index));
            String[] nm = inputRR.reverseLookup(colInfo.getInternalName());
            String[] nm2 = inputRR.getAlternateMappings(colInfo.getInternalName());
            selSignature.add(colInfo);
            selRR.put(nm[0], nm[1], colInfo);
            if (nm2 != null) {
                selRR.addMappingOnly(nm2[0], nm2[1], colInfo);
            }
            if (keys.contains(colName = colInfo.getInternalName())) {
                exprNodeDesc = new ExprNodeColumnDesc(colInfo.getType(), Utilities.ReduceField.KEY.toString() + "." + colName, null, false);
                columnExprs.add(exprNodeDesc);
            } else {
                exprNodeDesc = new ExprNodeColumnDesc(colInfo.getType(), Utilities.ReduceField.VALUE.toString() + "." + colName, null, false);
                columnExprs.add(exprNodeDesc);
            }
            colNames.add(colName);
            selColExprMap.put(colName, exprNodeDesc);
        }
        SelectDesc selConf = new SelectDesc(columnExprs, colNames);
        result = this.putOpInsertMap(OperatorFactory.getAndMakeChild(selConf, new RowSchema(selSignature), result, new Operator[0]), selRR);
        result.setColumnExprMap(selColExprMap);
        return result;
    }

    private void setStatsForNonNativeTable(String dbName, String tableName) throws SemanticException {
        TableName qTableName = HiveTableName.ofNullable(tableName, dbName);
        HashMap<String, String> mapProp = new HashMap<String, String>();
        mapProp.put("COLUMN_STATS_ACCURATE", null);
        AlterTableUnsetPropertiesDesc alterTblDesc = new AlterTableUnsetPropertiesDesc(qTableName, null, null, false, mapProp, false, null);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), alterTblDesc)));
    }

    private boolean mergeCardinalityViolationBranch(Operator input) {
        ExprNodeDesc colExpr;
        SelectOperator selectOp;
        if (input instanceof SelectOperator && ((SelectDesc)(selectOp = (SelectOperator)input).getConf()).getColList().size() == 1 && (colExpr = ((SelectDesc)selectOp.getConf()).getColList().get(0)) instanceof ExprNodeGenericFuncDesc) {
            ExprNodeGenericFuncDesc func = (ExprNodeGenericFuncDesc)colExpr;
            return func.getGenericUDF() instanceof GenericUDFCardinalityViolation;
        }
        return false;
    }

    private Operator genConstraintsPlan(String dest, QB qb, Operator input) throws SemanticException {
        if (this.deleting(dest)) {
            return input;
        }
        if (this.updating(dest) && this.isCBOExecuted() && this.ctx.getOperation() != Context.Operation.MERGE) {
            return input;
        }
        if (this.mergeCardinalityViolationBranch(input)) {
            return input;
        }
        assert (input.getParentOperators().size() == 1);
        RowResolver inputRR = this.opParseCtx.get(input).getRowResolver();
        org.apache.hadoop.hive.ql.metadata.Table targetTable = this.getTargetTable(qb, dest);
        ExprNodeDesc combinedConstraintExpr = ExprNodeTypeCheck.genConstraintsExpr(this.conf, targetTable, this.updating(dest), inputRR);
        if (combinedConstraintExpr != null) {
            return this.putOpInsertMap(OperatorFactory.getAndMakeChild(new FilterDesc(combinedConstraintExpr, false), new RowSchema(inputRR.getColumnInfos()), input, new Operator[0]), inputRR);
        }
        return input;
    }

    protected org.apache.hadoop.hive.ql.metadata.Table getTargetTable(QB qb, String dest) throws SemanticException {
        Integer dest_type = qb.getMetaData().getDestTypeForAlias(dest);
        if (dest_type == 1) {
            return qb.getMetaData().getDestTableForAlias(dest);
        }
        if (dest_type == 2) {
            org.apache.hadoop.hive.ql.metadata.Partition dest_part = qb.getMetaData().getDestPartitionForAlias(dest);
            return dest_part.getTable();
        }
        throw new SemanticException("Generating constraint check plan: Invalid target type: " + dest);
    }

    private Path getDestinationFilePath(QB qb, String destinationFile, boolean isMmTable) {
        if (this.isResultsCacheEnabled() && this.queryTypeCanUseCache(qb)) {
            assert (!isMmTable);
            QueryResultsCache instance = QueryResultsCache.getInstance();
            if (instance != null) {
                Path resultCacheTopDir = instance.getCacheDirPath();
                String dirName = UUID.randomUUID().toString();
                Path resultDir = new Path(resultCacheTopDir, dirName);
                this.ctx.setFsResultCacheDirs(resultDir);
                return resultDir;
            }
        }
        return new Path(destinationFile);
    }

    protected Operator genFileSinkPlan(String dest, QB qb, Operator input) throws SemanticException {
        boolean destTableIsFullAcid;
        RowResolver inputRR = this.opParseCtx.get(input).getRowResolver();
        QBMetaData qbm = qb.getMetaData();
        Integer destType = qbm.getDestTypeForAlias(dest);
        org.apache.hadoop.hive.ql.metadata.Table destinationTable = null;
        boolean isDirectInsert = false;
        AcidUtils.Operation acidOperation = null;
        boolean destTableIsTemporary = false;
        boolean destTableIsMaterialization = false;
        org.apache.hadoop.hive.ql.metadata.Partition destinationPartition = null;
        Path queryTmpdir = null;
        String moveTaskId = null;
        Path destinationPath = null;
        TableDesc tableDescriptor = null;
        StructObjectInspector specificRowObjectInspector = null;
        int currentTableId = 0;
        boolean isLocal = false;
        SortBucketRSCtx rsCtx = new SortBucketRSCtx();
        DynamicPartitionCtx dpCtx = null;
        LoadTableDesc ltd = null;
        ListBucketingCtx lbCtx = null;
        Map<String, String> partSpec = null;
        boolean isMmTable = false;
        boolean isMmCreate = false;
        boolean isNonNativeTable = false;
        boolean isAlreadyContainsPartCols = false;
        Long writeId = null;
        HiveTxnManager txnMgr = this.getTxnMgr();
        switch (destType) {
            case 1: {
                LoadTableDesc.LoadFileType loadType;
                destinationTable = qbm.getDestTableForAlias(dest);
                boolean destTableIsTransactional = AcidUtils.isTransactionalTable(destinationTable);
                destTableIsFullAcid = AcidUtils.isFullAcidTable(destinationTable);
                destTableIsTemporary = destinationTable.isTemporary();
                this.checkExternalTable(destinationTable);
                partSpec = qbm.getPartSpecForAlias(dest);
                destinationPath = destinationTable.getPath();
                this.checkImmutableTable(qb, destinationTable, destinationPath, false);
                dpCtx = this.checkDynPart(qb, qbm, destinationTable, partSpec, dest);
                isNonNativeTable = destinationTable.isNonNative();
                isMmTable = AcidUtils.isInsertOnlyTable(destinationTable.getParameters());
                AcidUtils.Operation acidOp = AcidUtils.Operation.NOT_ACID;
                tableDescriptor = Utilities.getTableDesc(destinationTable);
                if (!isNonNativeTable && destTableIsTransactional) {
                    acidOp = this.getAcidType(tableDescriptor.getOutputFileFormatClass(), dest, isMmTable);
                }
                isDirectInsert = this.isDirectInsert(destTableIsFullAcid, acidOp);
                acidOperation = acidOp;
                queryTmpdir = this.getTmpDir(isNonNativeTable, isMmTable, isDirectInsert, destinationPath, dpCtx);
                moveTaskId = this.getMoveTaskId();
                if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                    Utilities.FILE_OP_LOGGER.trace("create filesink w/DEST_TABLE specifying " + String.valueOf(queryTmpdir) + " from " + String.valueOf(destinationPath));
                }
                if (dpCtx != null) {
                    dpCtx.setRootPath(queryTmpdir);
                }
                if (!qb.getIsQuery()) {
                    isAlreadyContainsPartCols = Optional.ofNullable(destinationTable).map(org.apache.hadoop.hive.ql.metadata.Table::hasNonNativePartitionSupport).orElse(Boolean.FALSE);
                    input = !this.updating(dest) && !this.deleting(dest) && isAlreadyContainsPartCols && destinationTable != null && partSpec != null ? this.genConversionSelectOperatorByAddPartition(dest, qb, input, destinationTable.getDeserializer(), destinationTable, partSpec) : this.genConversionSelectOperator(dest, qb, input, destinationTable.getDeserializer(), dpCtx, destinationTable.getPartitionKeys(), destinationTable);
                }
                input = this.genConstraintsPlan(dest, qb, input);
                if (destinationTable.isMaterializedView() && this.mvRebuildMode == MaterializationRebuildMode.INSERT_OVERWRITE_REBUILD) {
                    String sortColsStr = destinationTable.getProperty("materializedview.sort.columns");
                    String distributeColsStr = destinationTable.getProperty("materializedview.distribute.columns");
                    if (sortColsStr != null || distributeColsStr != null) {
                        input = this.genMaterializedViewDataOrgPlan(destinationTable, sortColsStr, distributeColsStr, inputRR, input);
                    }
                } else {
                    input = this.genBucketingSortingDest(dest, input, qb, tableDescriptor, destinationTable, rsCtx);
                }
                this.idToTableNameMap.put(String.valueOf(this.destTableId), destinationTable.getTableName());
                currentTableId = this.destTableId++;
                if (!isNonNativeTable || destinationTable.getStorageHandler().commitInMoveTask()) {
                    if (destTableIsTransactional) {
                        acidOp = this.getAcidType(tableDescriptor.getOutputFileFormatClass(), dest, isMmTable);
                        this.checkAcidConstraints();
                    } else {
                        lbCtx = this.constructListBucketingCtx(destinationTable.getSkewedColNames(), destinationTable.getSkewedColValues(), destinationTable.getSkewedColValueLocationMaps(), destinationTable.isStoredAsSubDirectories());
                    }
                    writeId = this.allocateTableWriteId(destinationTable.getFullTableName(), isMmTable || acidOp != AcidUtils.Operation.NOT_ACID);
                    boolean isReplace = !qb.getParseInfo().isInsertIntoTable(destinationTable.getDbName(), destinationTable.getTableName(), destinationTable.getSnapshotRef());
                    ltd = new LoadTableDesc(queryTmpdir, tableDescriptor, dpCtx, acidOp, isReplace, writeId);
                    if (writeId != null) {
                        ltd.setStmtId(txnMgr.getCurrentStmtId());
                    }
                    ltd.setMoveTaskId(moveTaskId);
                    boolean isInsertInto = qb.getParseInfo().isInsertIntoTable(destinationTable.getDbName(), destinationTable.getTableName(), destinationTable.getSnapshotRef());
                    loadType = isDirectInsert ? LoadTableDesc.LoadFileType.IGNORE : (!isInsertInto && !destTableIsTransactional ? LoadTableDesc.LoadFileType.REPLACE_ALL : LoadTableDesc.LoadFileType.KEEP_EXISTING);
                    ltd.setLoadFileType(loadType);
                    ltd.setInsertOverwrite(!isInsertInto);
                    ltd.setIsDirectInsert(isDirectInsert);
                    ltd.setLbCtx(lbCtx);
                    this.loadTableWork.add(ltd);
                } else {
                    this.setStatsForNonNativeTable(destinationTable.getDbName(), destinationTable.getTableName());
                    boolean overwrite = !qb.getParseInfo().isInsertIntoTable(destinationTable.getDbName(), destinationTable.getTableName(), destinationTable.getSnapshotRef());
                    this.createPreInsertDesc(destinationTable, overwrite);
                    ltd = new LoadTableDesc(queryTmpdir, tableDescriptor, (Map<String, String>)(partSpec == null ? ImmutableMap.of() : partSpec));
                    ltd.setInsertOverwrite(overwrite);
                    ltd.setLoadFileType(overwrite ? LoadTableDesc.LoadFileType.REPLACE_ALL : LoadTableDesc.LoadFileType.KEEP_EXISTING);
                }
                if (destinationTable.isMaterializedView()) {
                    this.materializedViewUpdateDesc = new MaterializedViewUpdateDesc(destinationTable.getFullyQualifiedName(), false, false, true);
                }
                WriteEntity output = this.generateTableWriteEntity(dest, destinationTable, partSpec, ltd, dpCtx);
                this.ctx.getLoadTableOutputMap().put(ltd, output);
                break;
            }
            case 2: {
                boolean isInsertInto;
                destinationPartition = qbm.getDestPartitionForAlias(dest);
                destinationTable = destinationPartition.getTable();
                boolean destTableIsTransactional = AcidUtils.isTransactionalTable(destinationTable);
                destTableIsFullAcid = AcidUtils.isFullAcidTable(destinationTable);
                this.checkExternalTable(destinationTable);
                Path partPath = destinationPartition.getDataLocation();
                this.checkImmutableTable(qb, destinationTable, partPath, true);
                destinationPath = partPath;
                if (MetaStoreUtils.isArchived((Partition)destinationPartition.getTPartition())) {
                    try {
                        String conflictingArchive = ArchiveUtils.conflictingArchiveNameOrNull(this.db, destinationTable, destinationPartition.getSpec());
                        String message = String.format("Insert conflict with existing archive: %s", conflictingArchive);
                        throw new SemanticException(message);
                    }
                    catch (SemanticException err) {
                        throw err;
                    }
                    catch (HiveException err) {
                        throw new SemanticException((Throwable)err);
                    }
                }
                isNonNativeTable = destinationTable.isNonNative();
                isMmTable = AcidUtils.isInsertOnlyTable(destinationTable.getParameters());
                AcidUtils.Operation acidOp = AcidUtils.Operation.NOT_ACID;
                tableDescriptor = Utilities.getTableDesc(destinationTable);
                if (!isNonNativeTable && destTableIsTransactional) {
                    acidOp = this.getAcidType(tableDescriptor.getOutputFileFormatClass(), dest, isMmTable);
                }
                isDirectInsert = this.isDirectInsert(destTableIsFullAcid, acidOp);
                acidOperation = acidOp;
                queryTmpdir = this.getTmpDir(isNonNativeTable, isMmTable, isDirectInsert, destinationPath, null);
                moveTaskId = this.getMoveTaskId();
                if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                    Utilities.FILE_OP_LOGGER.trace("create filesink w/DEST_PARTITION specifying " + String.valueOf(queryTmpdir) + " from " + String.valueOf(destinationPath));
                }
                if (destinationTable.hasNonNativePartitionSupport()) {
                    partSpec = qbm.getPartSpecForAlias(dest);
                }
                if (!qb.getIsQuery()) {
                    isAlreadyContainsPartCols = Optional.ofNullable(destinationTable).map(org.apache.hadoop.hive.ql.metadata.Table::hasNonNativePartitionSupport).orElse(Boolean.FALSE);
                    input = !this.updating(dest) && !this.deleting(dest) && isAlreadyContainsPartCols && destinationTable != null && partSpec != null ? this.genConversionSelectOperatorByAddPartition(dest, qb, input, destinationTable.getDeserializer(), destinationTable, partSpec) : this.genConversionSelectOperator(dest, qb, input, destinationTable.getDeserializer(), dpCtx, null, destinationTable);
                }
                input = this.genConstraintsPlan(dest, qb, input);
                if (destinationTable.isMaterializedView() && this.mvRebuildMode == MaterializationRebuildMode.INSERT_OVERWRITE_REBUILD) {
                    String sortColsStr = destinationTable.getProperty("materializedview.sort.columns");
                    String distributeColsStr = destinationTable.getProperty("materializedview.distribute.columns");
                    if (sortColsStr != null || distributeColsStr != null) {
                        input = this.genMaterializedViewDataOrgPlan(destinationTable, sortColsStr, distributeColsStr, inputRR, input);
                    }
                } else {
                    input = this.genBucketingSortingDest(dest, input, qb, tableDescriptor, destinationTable, rsCtx);
                }
                this.idToTableNameMap.put(String.valueOf(this.destTableId), destinationTable.getTableName());
                currentTableId = this.destTableId++;
                if (destTableIsTransactional) {
                    acidOp = this.getAcidType(tableDescriptor.getOutputFileFormatClass(), dest, isMmTable);
                    this.checkAcidConstraints();
                } else {
                    lbCtx = this.constructListBucketingCtx(destinationPartition.getSkewedColNames(), destinationPartition.getSkewedColValues(), destinationPartition.getSkewedColValueLocationMaps(), destinationPartition.isStoredAsSubDirectories());
                }
                writeId = this.allocateTableWriteId(destinationTable.getFullTableName(), isMmTable || acidOp != AcidUtils.Operation.NOT_ACID);
                ltd = new LoadTableDesc(queryTmpdir, tableDescriptor, destinationPartition.getSpec(), acidOp, writeId);
                if (writeId != null) {
                    ltd.setStmtId(txnMgr.getCurrentStmtId());
                }
                boolean bl = isInsertInto = !qb.getParseInfo().isDestToOpTypeInsertOverwrite(dest);
                LoadTableDesc.LoadFileType loadType = isDirectInsert ? LoadTableDesc.LoadFileType.IGNORE : (!isInsertInto && !destTableIsTransactional ? LoadTableDesc.LoadFileType.REPLACE_ALL : LoadTableDesc.LoadFileType.KEEP_EXISTING);
                ltd.setLoadFileType(loadType);
                ltd.setInsertOverwrite(!isInsertInto);
                ltd.setIsDirectInsert(isDirectInsert);
                ltd.setLbCtx(lbCtx);
                ltd.setMoveTaskId(moveTaskId);
                this.loadTableWork.add(ltd);
                if (destinationTable.hasNonNativePartitionSupport()) {
                    DummyPartition dummyPartition;
                    try {
                        String partName = Warehouse.makePartName(partSpec, (boolean)false);
                        dummyPartition = new DummyPartition(destinationTable, partName, partSpec);
                    }
                    catch (MetaException e) {
                        throw new SemanticException("Unable to construct name for dummy partition due to: ", (Throwable)e);
                    }
                    if (this.outputs.add(new WriteEntity((org.apache.hadoop.hive.ql.metadata.Partition)dummyPartition, this.determineWriteType(ltd, dest)))) break;
                    throw new SemanticException(ErrorMsg.OUTPUT_SPECIFIED_MULTIPLE_TIMES.getMsg(destinationTable.getTableName() + "@" + dummyPartition.getName()));
                }
                if (this.outputs.add(new WriteEntity(destinationPartition, this.determineWriteType(ltd, dest)))) break;
                throw new SemanticException(ErrorMsg.OUTPUT_SPECIFIED_MULTIPLE_TIMES.getMsg(destinationTable.getTableName() + "@" + destinationPartition.getName()));
            }
            case 5: {
                isLocal = true;
            }
            case 3: {
                boolean isPartitioned;
                String colTypes;
                String cols;
                DDLDescWithTableProperties ddlDesc;
                boolean destTableIsTransactional;
                destinationPath = this.getDestinationFilePath(qb, qbm.getDestFileForAlias(dest), isMmTable);
                ArrayList<FieldSchema> fieldSchemas = null;
                ArrayList<FieldSchema> partitionColumns = null;
                List<String> partitionColumnNames = null;
                Object sortColumns = null;
                List<String> sortColumnNames = null;
                ArrayList<FieldSchema> distributeColumns = null;
                List<String> distributeColumnNames = null;
                ArrayList<ColumnInfo> fileSinkColInfos = null;
                ArrayList<ColumnInfo> sortColInfos = null;
                ArrayList<ColumnInfo> distributeColInfos = null;
                Map<String, String> tblProps = null;
                CreateTableDesc tblDesc = qb.getTableDesc();
                CreateMaterializedViewDesc viewDesc = qb.getViewDesc();
                boolean createTableUseSuffix = false;
                DDLDescWithTableProperties dDLDescWithTableProperties = ddlDesc = tblDesc != null ? tblDesc : viewDesc;
                if (ddlDesc != null) {
                    fieldSchemas = new ArrayList<FieldSchema>();
                    partitionColumns = new ArrayList<FieldSchema>();
                    partitionColumnNames = ddlDesc.getPartColNames();
                    fileSinkColInfos = new ArrayList<ColumnInfo>();
                    destTableIsTemporary = ddlDesc.isTemporary();
                    destTableIsMaterialization = ddlDesc.isMaterialization();
                    tblProps = ddlDesc.getTblProps();
                    boolean bl = createTableUseSuffix = (HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_CREATE_TABLE_USE_SUFFIX) || HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ACID_LOCKLESS_READS_ENABLED)) && ddlDesc.getLocation() == null;
                }
                if (viewDesc != null) {
                    sortColumns = new ArrayList<FieldSchema>();
                    sortColumnNames = viewDesc.getSortColNames();
                    distributeColumns = new ArrayList<FieldSchema>();
                    distributeColumnNames = viewDesc.getDistributeColNames();
                    sortColInfos = new ArrayList<ColumnInfo>();
                    distributeColInfos = new ArrayList<ColumnInfo>();
                }
                boolean bl = destTableIsTransactional = tblProps != null && AcidUtils.isTablePropertyTransactional(tblProps);
                if (destTableIsTransactional) {
                    isNonNativeTable = MetaStoreUtils.isNonNativeTable(tblProps);
                    isMmTable = isMmCreate = AcidUtils.isInsertOnlyTable(tblProps);
                    writeId = this.allocateTableWriteId(ddlDesc.getFullTableName(), 0L);
                    if (!isNonNativeTable && !destTableIsTemporary && (qb.isCTAS() || qb.isMaterializedView())) {
                        destTableIsFullAcid = AcidUtils.isFullAcidTable(tblProps);
                        acidOperation = this.getAcidType(dest);
                        isDirectInsert = this.isDirectInsert(destTableIsFullAcid, acidOperation);
                        this.ctx.setLocation(this.getCtasOrCMVLocation(tblDesc, viewDesc, createTableUseSuffix));
                        if (isDirectInsert || isMmTable) {
                            destinationPath = this.ctx.getLocation();
                            if (createTableUseSuffix) {
                                ddlDesc.getTblProps().put("soft_delete", Boolean.TRUE.toString());
                            }
                            ddlDesc.setLocation(destinationPath.toString());
                        }
                    }
                    if (isMmTable || isDirectInsert) {
                        ddlDesc.setInitialWriteId(writeId);
                    }
                }
                if (dpCtx != null) {
                    throw new SemanticException("Dynamic partition context has already been created, this should not happen");
                }
                if (!CollectionUtils.isEmpty(partitionColumnNames)) {
                    ct = this.deriveFileSinkColTypes(inputRR, partitionColumnNames, sortColumnNames, distributeColumnNames, (List<FieldSchema>)fieldSchemas, (List<FieldSchema>)partitionColumns, (List<FieldSchema>)sortColumns, (List<FieldSchema>)distributeColumns, (List<ColumnInfo>)fileSinkColInfos, (List<ColumnInfo>)sortColInfos, (List<ColumnInfo>)distributeColInfos);
                    cols = ct.cols;
                    colTypes = ct.colTypes;
                    dpCtx = new DynamicPartitionCtx(partitionColumnNames, this.conf.getVar(HiveConf.ConfVars.DEFAULT_PARTITION_NAME), this.conf.getIntVar(HiveConf.ConfVars.DYNAMIC_PARTITION_MAX_PARTS_PER_NODE));
                    qbm.setDPCtx(dest, dpCtx);
                    isPartitioned = true;
                } else {
                    ct = this.deriveFileSinkColTypes(inputRR, sortColumnNames, distributeColumnNames, (List<FieldSchema>)fieldSchemas, (List<FieldSchema>)sortColumns, (List<FieldSchema>)distributeColumns, (List<ColumnInfo>)sortColInfos, (List<ColumnInfo>)distributeColInfos);
                    cols = ct.cols;
                    colTypes = ct.colTypes;
                    isPartitioned = false;
                }
                if (isLocal) {
                    assert (!isMmTable);
                    queryTmpdir = this.ctx.getMRTmpPath();
                    if (dpCtx != null && dpCtx.getSPPath() != null) {
                        queryTmpdir = new Path(queryTmpdir, dpCtx.getSPPath());
                    }
                } else {
                    try {
                        Path qPath = FileUtils.makeQualified((Path)destinationPath, (Configuration)this.conf);
                        queryTmpdir = this.getTmpDir(false, isMmTable, isDirectInsert, qPath, dpCtx);
                    }
                    catch (Exception e) {
                        throw new SemanticException("Error creating " + String.valueOf(destinationPath), (Throwable)e);
                    }
                }
                if (dpCtx != null) {
                    dpCtx.setRootPath(queryTmpdir);
                }
                if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                    Utilities.FILE_OP_LOGGER.trace("Setting query directory " + String.valueOf(queryTmpdir) + " from " + String.valueOf(destinationPath) + " (" + isMmTable + ")");
                }
                if (tblDesc != null) {
                    tblDesc.setCols(new ArrayList<FieldSchema>(fieldSchemas));
                    tblDesc.setPartCols(new ArrayList<FieldSchema>(partitionColumns));
                } else if (viewDesc != null) {
                    viewDesc.setCols(new ArrayList<FieldSchema>(fieldSchemas));
                    viewDesc.setPartCols(new ArrayList<FieldSchema>(partitionColumns));
                    if (viewDesc.isOrganized()) {
                        viewDesc.setSortCols(new ArrayList<FieldSchema>((Collection<FieldSchema>)sortColumns));
                        viewDesc.setDistributeCols(new ArrayList<FieldSchema>(distributeColumns));
                    }
                }
                boolean isDestTempFile = true;
                if (!this.ctx.isMRTmpFileURI(destinationPath.toUri().toString()) && !this.ctx.isResultCacheDir(destinationPath)) {
                    this.idToTableNameMap.put(String.valueOf(this.destTableId), destinationPath.toUri().toString());
                    currentTableId = this.destTableId++;
                    isDestTempFile = false;
                }
                try {
                    if (tblDesc == null) {
                        if (viewDesc != null) {
                            if (viewDesc.getStorageHandler() != null) {
                                viewDesc.setLocation(this.getCtasOrCMVLocation(tblDesc, viewDesc, createTableUseSuffix).toString());
                            }
                            tableDescriptor = PlanUtils.getTableDesc(viewDesc, cols, colTypes);
                        } else if (qb.getIsQuery()) {
                            Class<LazySimpleSerDe> serdeClass = LazySimpleSerDe.class;
                            String fileFormat = this.conf.getResultFileFormat().toString();
                            if (SessionState.get().getIsUsingThriftJDBCBinarySerDe()) {
                                serdeClass = ThriftJDBCBinarySerDe.class;
                                fileFormat = HiveConf.ResultFileFormat.SEQUENCEFILE.toString();
                                this.conf.set("list.sink.output.formatter", NoOpFetchFormatter.class.getName());
                            } else if (fileFormat.equals("Llap")) {
                                serdeClass = LazyBinarySerDe2.class;
                            }
                            tableDescriptor = PlanUtils.getDefaultQueryOutputTableDesc(cols, colTypes, fileFormat, serdeClass);
                        } else {
                            tableDescriptor = PlanUtils.getDefaultTableDesc(qb.getDirectoryDesc(), cols, colTypes);
                        }
                    } else {
                        if (tblDesc.isCTAS() && tblDesc.getStorageHandler() != null) {
                            tblDesc.toTable(this.conf).getStorageHandler().setTableLocationForCTAS(tblDesc, this.getCtasOrCMVLocation(tblDesc, viewDesc, false).toString());
                        }
                        tableDescriptor = PlanUtils.getTableDesc(tblDesc, cols, colTypes);
                    }
                }
                catch (HiveException e) {
                    throw new SemanticException((Throwable)e);
                }
                try {
                    specificRowObjectInspector = (StructObjectInspector)tableDescriptor.getDeserializer((Configuration)this.conf).getObjectInspector();
                }
                catch (Exception e) {
                    throw new SemanticException(e.getMessage(), (Throwable)e);
                }
                boolean isDfsDir = destType == 3;
                try {
                    if (tblDesc != null) {
                        org.apache.hadoop.hive.ql.metadata.Table t = tblDesc.toTable(this.conf);
                        destinationTable = tblDesc.isMaterialization() ? t : this.db.getTranslateTableDryrun(t.getTTable());
                    } else {
                        destinationTable = viewDesc != null ? viewDesc.toTable(this.conf) : null;
                    }
                }
                catch (HiveException e) {
                    throw new SemanticException((Throwable)e);
                }
                destTableIsFullAcid = AcidUtils.isFullAcidTable(destinationTable);
                if (viewDesc != null && viewDesc.isOrganized()) {
                    input = this.genMaterializedViewDataOrgPlan(sortColInfos, distributeColInfos, inputRR, input);
                }
                moveTaskId = this.getMoveTaskId();
                if (isPartitioned) {
                    RowResolver rowResolver = new RowResolver();
                    ArrayList<ExprNodeDesc> columnExprs = new ArrayList<ExprNodeDesc>();
                    ArrayList<String> colNames = new ArrayList<String>();
                    HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
                    for (int i = 0; i < fileSinkColInfos.size(); ++i) {
                        ColumnInfo ci = (ColumnInfo)fileSinkColInfos.get(i);
                        ExprNodeColumnDesc columnExpr = new ExprNodeColumnDesc(ci);
                        String name = SemanticAnalyzer.getColumnInternalName(i);
                        rowResolver.put("", name, new ColumnInfo(name, columnExpr.getTypeInfo(), "", false));
                        columnExprs.add(columnExpr);
                        colNames.add(name);
                        colExprMap.put(name, columnExpr);
                    }
                    input = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new SelectDesc(columnExprs, colNames), new RowSchema(rowResolver.getColumnInfos()), input, new Operator[0]), rowResolver);
                    input.setColumnExprMap(colExprMap);
                    isNonNativeTable = tableDescriptor.isNonNative();
                    if (!isNonNativeTable || destinationTable.getStorageHandler().commitInMoveTask()) {
                        AcidUtils.Operation acidOp = AcidUtils.Operation.NOT_ACID;
                        if (destTableIsTransactional) {
                            acidOp = this.getAcidType(tableDescriptor.getOutputFileFormatClass(), dest, isMmTable);
                            this.checkAcidConstraints();
                        }
                        ltd = new LoadTableDesc(queryTmpdir, tableDescriptor, dpCtx, acidOp, false, writeId);
                        if (writeId != null) {
                            ltd.setStmtId(txnMgr.getCurrentStmtId());
                        }
                        ltd.setLoadFileType(LoadTableDesc.LoadFileType.KEEP_EXISTING);
                        ltd.setInsertOverwrite(false);
                        ltd.setIsDirectInsert(isDirectInsert);
                        this.loadTableWork.add(ltd);
                    } else {
                        this.setStatsForNonNativeTable(tableDescriptor.getDbName(), tableDescriptor.getTableName());
                        ltd = new LoadTableDesc(queryTmpdir, tableDescriptor, dpCtx.getPartSpec());
                        ltd.setInsertOverwrite(false);
                        ltd.setLoadFileType(LoadTableDesc.LoadFileType.KEEP_EXISTING);
                    }
                    ltd.setMoveTaskId(moveTaskId);
                    ltd.setMdTable(destinationTable);
                    WriteEntity output = this.generateTableWriteEntity(dest, destinationTable, dpCtx.getPartSpec(), ltd, dpCtx);
                    this.ctx.getLoadTableOutputMap().put(ltd, output);
                    break;
                }
                LoadFileDesc loadFileDesc = new LoadFileDesc(tblDesc, viewDesc, queryTmpdir, destinationPath, isDfsDir, cols, colTypes, destTableIsFullAcid ? AcidUtils.Operation.INSERT : AcidUtils.Operation.NOT_ACID, isMmCreate);
                loadFileDesc.setMoveTaskId(moveTaskId);
                this.loadFileWork.add(loadFileDesc);
                try {
                    LocalFileSystem fs = isDfsDir ? destinationPath.getFileSystem((Configuration)this.conf) : FileSystem.getLocal((Configuration)this.conf);
                    Path qualifiedPath = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_RANGER_USE_FULLY_QUALIFIED_URL) ? fs.makeQualified(destinationPath) : destinationPath;
                    if (!this.outputs.add(new WriteEntity(qualifiedPath, !isDfsDir, isDestTempFile))) {
                        throw new SemanticException(ErrorMsg.OUTPUT_SPECIFIED_MULTIPLE_TIMES.getMsg(destinationPath.toUri().toString()));
                    }
                    break;
                }
                catch (IOException ex) {
                    throw new SemanticException("Error while getting the full qualified path for the given directory: " + ex.getMessage());
                }
            }
            default: {
                throw new SemanticException("Unknown destination type: " + destType);
            }
        }
        if (!(destType == 3 && qb.getIsQuery() || destinationTable == null || destinationTable.getStorageHandler() == null)) {
            try {
                input = !this.updating(dest) && !this.deleting(dest) && isAlreadyContainsPartCols && MapUtils.isNotEmpty(partSpec) ? this.genConversionSelectOperatorByAddPartition(dest, qb, input, destinationTable.getDeserializer(), destinationTable, null) : this.genConversionSelectOperator(dest, qb, input, destinationTable.getDeserializer(), dpCtx, null, destinationTable);
            }
            catch (Exception e) {
                throw new SemanticException((Throwable)e);
            }
        }
        inputRR = this.opParseCtx.get(input).getRowResolver();
        ArrayList<ColumnInfo> vecCol = new ArrayList<ColumnInfo>();
        if (this.updating(dest) || this.deleting(dest) || this.merging(dest)) {
            if (AcidUtils.isNonNativeAcidTable(destinationTable)) {
                destinationTable.getStorageHandler().acidVirtualColumns().stream().map(col -> new ColumnInfo(col.getName(), col.getTypeInfo(), "", true)).forEach(vecCol::add);
            } else {
                vecCol.add(new ColumnInfo(VirtualColumn.ROWID.getName(), VirtualColumn.ROWID.getTypeInfo(), "", true));
            }
        } else {
            try {
                StructObjectInspector rowObjectInspector = specificRowObjectInspector != null ? specificRowObjectInspector : (StructObjectInspector)destinationTable.getDeserializer().getObjectInspector();
                List fields = rowObjectInspector.getAllStructFieldRefs();
                for (StructField field : fields) {
                    vecCol.add(new ColumnInfo(field.getFieldName(), TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)field.getFieldObjectInspector()), "", false));
                }
            }
            catch (Exception e) {
                throw new SemanticException(e.getMessage(), (Throwable)e);
            }
        }
        RowSchema fsRS = new RowSchema(vecCol);
        boolean canBeMerged = destinationTable == null || destinationTable.getNumBuckets() <= 0 && (destinationTable.getSortCols() == null || destinationTable.getSortCols().size() <= 0);
        canBeMerged &= !destTableIsFullAcid;
        if (destinationTable != null && destinationTable.getStorageHandler() != null) {
            canBeMerged &= destinationTable.getStorageHandler().supportsMergeFiles();
            if (Context.Operation.DELETE.equals((Object)this.ctx.getOperation()) && !this.deleting(dest)) {
                canBeMerged = true;
            }
            if (Context.Operation.UPDATE.equals((Object)this.ctx.getOperation()) || Context.Operation.MERGE.equals((Object)this.ctx.getOperation())) {
                canBeMerged = false;
            }
        }
        if (destType == 1 || destType == 2) {
            this.genPartnCols(dest, input, qb, tableDescriptor, destinationTable, rsCtx);
        }
        FileSinkDesc fileSinkDesc = this.createFileSinkDesc(dest, tableDescriptor, destinationPartition, destinationPath, currentTableId, destTableIsFullAcid, destTableIsTemporary, destTableIsMaterialization, queryTmpdir, rsCtx, dpCtx, lbCtx, fsRS, canBeMerged, destinationTable, isMmCreate, destType, qb, isDirectInsert, acidOperation, moveTaskId);
        if (isMmCreate || (qb.isCTAS() || qb.isMaterializedView()) && isDirectInsert) {
            if (this.tableDesc != null) {
                this.tableDesc.setWriter(fileSinkDesc);
            } else {
                this.createVwDesc.setWriter(fileSinkDesc);
            }
        }
        if (fileSinkDesc.getInsertOverwrite() && ltd != null) {
            ltd.setInsertOverwrite(true);
        }
        if (null != tableDescriptor && this.useBatchingSerializer(tableDescriptor.getSerdeClassName())) {
            fileSinkDesc.setIsUsingBatchingSerDe(true);
        } else {
            fileSinkDesc.setIsUsingBatchingSerDe(false);
        }
        Operator<FileSinkDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(fileSinkDesc, fsRS, input, new Operator[0]), inputRR);
        if (!isDirectInsert || acidOperation == AcidUtils.Operation.INSERT) {
            this.handleLineage(destinationTable, ltd, output);
        }
        this.setWriteIdForSurrogateKeys(ltd, input);
        this.LOG.debug("Created FileSink Plan for clause: {}dest_path: {} row schema: {}", new Object[]{dest, destinationPath, inputRR});
        FileSinkOperator fso = (FileSinkOperator)output;
        ((FileSinkDesc)fso.getConf()).setTable(destinationTable);
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_AUTOGATHER) && this.conf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_COL_AUTOGATHER) && this.enableColumnStatsCollecting() && destinationTable != null && (!destinationTable.isNonNative() || destinationTable.getStorageHandler().commitInMoveTask()) && !destTableIsTemporary && !destTableIsMaterialization && ColumnStatsAutoGatherContext.canRunAutogatherStats(fso)) {
            if (destType == 1) {
                this.genAutoColumnStatsGatheringPipeline(destinationTable, partSpec, input, qb.getParseInfo().isInsertIntoTable(destinationTable.getDbName(), destinationTable.getTableName(), destinationTable.getSnapshotRef()), false);
            } else if (destType == 2) {
                this.genAutoColumnStatsGatheringPipeline(destinationTable, destinationPartition.getSpec(), input, qb.getParseInfo().isInsertIntoTable(destinationTable.getDbName(), destinationTable.getTableName(), destinationTable.getSnapshotRef()), false);
            } else if (destType == 5 || destType == 3) {
                this.genAutoColumnStatsGatheringPipeline(destinationTable, null, input, false, true);
            }
        }
        return output;
    }

    private Long allocateTableWriteId(TableName tableName, boolean isAcid) throws SemanticException {
        return isAcid ? this.allocateTableWriteId(tableName, null) : null;
    }

    private Long allocateTableWriteId(TableName tableName, Long defaultValue) throws SemanticException {
        if (this.ctx.getExplainConfig() != null) {
            return defaultValue;
        }
        this.queryState.getValidTxnList();
        try {
            return this.getTxnMgr().getTableWriteId(tableName.getDb(), tableName.getTable());
        }
        catch (LockException ex) {
            throw new SemanticException("Failed to allocate write Id", (Throwable)((Object)ex));
        }
    }

    protected boolean enableColumnStatsCollecting() {
        return true;
    }

    private Path getCtasOrCMVLocation(CreateTableDesc tblDesc, CreateMaterializedViewDesc viewDesc, boolean createTableWithSuffix) throws SemanticException {
        try {
            org.apache.hadoop.hive.ql.metadata.Table tbl;
            String protoName;
            if (tblDesc != null) {
                protoName = tblDesc.getDbTableName();
                tbl = tblDesc.toTable(this.conf);
                tbl = this.db.getTranslateTableDryrun(tbl.getTTable());
            } else {
                protoName = viewDesc.getViewName();
                tbl = viewDesc.toTable(this.conf);
            }
            String[] names = Utilities.getDbTableName(protoName);
            Warehouse wh = new Warehouse((Configuration)this.conf);
            Path location = tbl.getSd() == null || tbl.getSd().getLocation() == null ? wh.getDefaultTablePath(this.db.getDatabase(names[0]), names[1], false) : wh.getDnsPath(new Path(tbl.getSd().getLocation()));
            return location.suffix(Utilities.getTableOrMVSuffix(this.ctx, createTableWithSuffix));
        }
        catch (MetaException | HiveException e) {
            throw new SemanticException(e);
        }
    }

    private boolean isDirectInsert(boolean destTableIsFullAcid, AcidUtils.Operation acidOp) {
        boolean directInsert;
        if (this.ctx.getExplainAnalyze() == ExplainConfiguration.AnalyzeState.RUNNING) {
            return false;
        }
        boolean directInsertEnabled = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_ACID_DIRECT_INSERT_ENABLED);
        boolean bl = directInsert = directInsertEnabled && destTableIsFullAcid && acidOp != AcidUtils.Operation.NOT_ACID;
        if (this.LOG.isDebugEnabled() && directInsert) {
            this.LOG.debug("Direct insert for ACID tables is enabled.");
        }
        return directInsert;
    }

    private Path getTmpDir(boolean isNonNativeTable, boolean isMmTable, boolean isDirectInsert, Path destinationPath, DynamicPartitionCtx dpCtx) {
        Path destPath = null;
        destPath = isNonNativeTable || isMmTable || isDirectInsert ? destinationPath : (HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_USE_SCRATCHDIR_FOR_STAGING) ? this.ctx.getTempDirForInterimJobPath(destinationPath) : this.ctx.getTempDirForFinalJobPath(destinationPath));
        if (dpCtx != null && dpCtx.getSPPath() != null) {
            return new Path(destPath, dpCtx.getSPPath());
        }
        return destPath;
    }

    private String getMoveTaskId() {
        return this.ctx.getMoveTaskId();
    }

    private boolean useBatchingSerializer(String serdeClassName) {
        return SessionState.get().isHiveServerQuery() && this.hasSetBatchSerializer(serdeClassName);
    }

    private boolean hasSetBatchSerializer(String serdeClassName) {
        return serdeClassName.equalsIgnoreCase(ThriftJDBCBinarySerDe.class.getName()) && HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_THRIFT_RESULTSET_SERIALIZE_IN_TASKS);
    }

    private ColsAndTypes deriveFileSinkColTypes(RowResolver inputRR, List<String> sortColumnNames, List<String> distributeColumnNames, List<FieldSchema> fieldSchemas, List<FieldSchema> sortColumns, List<FieldSchema> distributeColumns, List<ColumnInfo> sortColInfos, List<ColumnInfo> distributeColInfos) throws SemanticException {
        return this.deriveFileSinkColTypes(inputRR, new ArrayList<String>(), sortColumnNames, distributeColumnNames, fieldSchemas, new ArrayList<FieldSchema>(), sortColumns, distributeColumns, new ArrayList<ColumnInfo>(), sortColInfos, distributeColInfos);
    }

    private ColsAndTypes deriveFileSinkColTypes(RowResolver inputRR, List<String> partitionColumnNames, List<String> sortColumnNames, List<String> distributeColumnNames, List<FieldSchema> columns, List<FieldSchema> partitionColumns, List<FieldSchema> sortColumns, List<FieldSchema> distributeColumns, List<ColumnInfo> fileSinkColInfos, List<ColumnInfo> sortColInfos, List<ColumnInfo> distributeColInfos) throws SemanticException {
        ColsAndTypes result = new ColsAndTypes("", "");
        ArrayList<String> allColumns = new ArrayList<String>();
        List<ColumnInfo> colInfos = inputRR.getColumnInfos();
        ArrayList<ColumnInfo> nonPartColInfos = new ArrayList<ColumnInfo>();
        TreeMap<Integer, Pair> partColInfos = new TreeMap<Integer, Pair>();
        TreeMap<Integer, Pair> sColInfos = new TreeMap<Integer, Pair>();
        TreeMap<Integer, Pair> dColInfos = new TreeMap<Integer, Pair>();
        boolean first = true;
        int numNonPartitionedCols = colInfos.size() - partitionColumnNames.size();
        if (numNonPartitionedCols <= 0) {
            throw new SemanticException("Too many partition columns declared");
        }
        for (ColumnInfo colInfo : colInfos) {
            String[] nm = inputRR.reverseLookup(colInfo.getInternalName());
            if (nm[1] != null) {
                colInfo.setAlias(nm[1]);
            }
            boolean isPartitionCol = false;
            String colName = colInfo.getInternalName();
            if (columns != null) {
                FieldSchema col = new FieldSchema();
                if (!"".equals(nm[0]) && nm[1] != null) {
                    colName = SemanticAnalyzer.unescapeIdentifier(colInfo.getAlias()).toLowerCase();
                }
                colName = this.fixCtasColumnName(colName);
                col.setName(colName);
                allColumns.add(colName);
                String typeName = colInfo.getType().getTypeName();
                if (typeName.equals("void")) {
                    throw new SemanticException(ErrorMsg.CTAS_CREATES_VOID_TYPE.getMsg(colName));
                }
                col.setType(typeName);
                int idx = partitionColumnNames.indexOf(colName);
                if (idx >= 0) {
                    partColInfos.put(idx, Pair.of((Object)col, (Object)colInfo));
                    isPartitionCol = true;
                } else {
                    if (sortColumnNames != null && (idx = sortColumnNames.indexOf(colName)) >= 0) {
                        sColInfos.put(idx, Pair.of((Object)col, (Object)colInfo));
                    }
                    if (distributeColumnNames != null && (idx = distributeColumnNames.indexOf(colName)) >= 0) {
                        dColInfos.put(idx, Pair.of((Object)col, (Object)colInfo));
                    }
                    columns.add(col);
                    nonPartColInfos.add(colInfo);
                }
            }
            if (isPartitionCol) continue;
            if (!first) {
                result.cols = result.cols.concat(",");
                result.colTypes = result.colTypes.concat(":");
            }
            first = false;
            result.cols = result.cols.concat(colName);
            String tName = colInfo.getType().getTypeName();
            if (tName.equals("void")) {
                result.colTypes = result.colTypes.concat("string");
                continue;
            }
            result.colTypes = result.colTypes.concat(tName);
        }
        if (partColInfos.size() != partitionColumnNames.size()) {
            throw new SemanticException("Table declaration contains partition columns that are not present in query result schema. Query columns: " + String.valueOf(allColumns) + ". Partition columns: " + String.valueOf(partitionColumnNames));
        }
        if (sortColumnNames != null && sColInfos.size() != sortColumnNames.size()) {
            throw new SemanticException("Table declaration contains cluster/sort columns that are not present in query result schema. Query columns: " + String.valueOf(allColumns) + ". Organization columns: " + String.valueOf(sortColumnNames));
        }
        if (distributeColumnNames != null && dColInfos.size() != distributeColumnNames.size()) {
            throw new SemanticException("Table declaration contains cluster/distribute columns that are not present in query result schema. Query columns: " + String.valueOf(allColumns) + ". Organization columns: " + String.valueOf(distributeColumnNames));
        }
        fileSinkColInfos.addAll(nonPartColInfos);
        partitionColumns.addAll(partColInfos.values().stream().map(Pair::getLeft).collect(Collectors.toList()));
        fileSinkColInfos.addAll(partColInfos.values().stream().map(Pair::getRight).collect(Collectors.toList()));
        if (sortColumnNames != null) {
            sortColumns.addAll(sColInfos.values().stream().map(Pair::getLeft).collect(Collectors.toList()));
            sortColInfos.addAll(sColInfos.values().stream().map(Pair::getRight).collect(Collectors.toList()));
        }
        if (distributeColumnNames != null) {
            distributeColumns.addAll(dColInfos.values().stream().map(Pair::getLeft).collect(Collectors.toList()));
            distributeColInfos.addAll(dColInfos.values().stream().map(Pair::getRight).collect(Collectors.toList()));
        }
        return result;
    }

    private FileSinkDesc createFileSinkDesc(String dest, TableDesc table_desc, org.apache.hadoop.hive.ql.metadata.Partition dest_part, Path dest_path, int currentTableId, boolean destTableIsAcid, boolean destTableIsTemporary, boolean destTableIsMaterialization, Path queryTmpdir, SortBucketRSCtx rsCtx, DynamicPartitionCtx dpCtx, ListBucketingCtx lbCtx, RowSchema fsRS, boolean canBeMerged, org.apache.hadoop.hive.ql.metadata.Table dest_tab, boolean isMmCtas, Integer dest_type, QB qb, boolean isDirectInsert, AcidUtils.Operation acidOperation, String moveTaskId) throws SemanticException {
        boolean isDestInsertOnly;
        boolean isInsertOverwrite = false;
        boolean isLocal = false;
        Context.Operation writeOperation = this.getWriteOperation(dest);
        switch (dest_type) {
            case 1: 
            case 2: {
                String destTableFullName = dest_tab.getCompleteName().replace('@', '.');
                Map<String, ASTNode> iowMap = qb.getParseInfo().getInsertOverwriteTables();
                if (iowMap.containsKey(destTableFullName) && qb.getParseInfo().isDestToOpTypeInsertOverwrite(dest)) {
                    isInsertOverwrite = true;
                }
                HiveStorageHandler storageHandler = dest_tab.getStorageHandler();
                if (!dest_tab.hasNonNativePartitionSupport()) break;
                DynamicPartitionCtx nonNativeDpCtx = storageHandler.createDPContext(this.conf, dest_tab, writeOperation);
                if (dpCtx != null || nonNativeDpCtx == null) break;
                dpCtx = nonNativeDpCtx;
                break;
            }
            case 5: {
                isLocal = true;
            }
            case 3: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected dest_type=" + String.valueOf(dest_tab));
            }
        }
        FileSinkDesc fileSinkDesc = new FileSinkDesc(queryTmpdir, table_desc, this.conf.getBoolVar(HiveConf.ConfVars.COMPRESS_RESULT), currentTableId, rsCtx.isMultiFileSpray(), canBeMerged, rsCtx.getNumFiles(), rsCtx.getTotalFiles(), rsCtx.getPartnCols(), dpCtx, dest_path, isMmCtas, isInsertOverwrite, qb.getIsQuery(), qb.isCTAS() || qb.isMaterializedView(), isDirectInsert, acidOperation, this.ctx.isDeleteBranchOfUpdate(dest));
        fileSinkDesc.setMoveTaskId(moveTaskId);
        boolean isHiveServerQuery = SessionState.get().isHiveServerQuery();
        fileSinkDesc.setHiveServerQuery(isHiveServerQuery);
        boolean bl = isDestInsertOnly = dest_part != null && dest_part.getTable() != null && AcidUtils.isInsertOnlyTable(dest_part.getTable().getParameters()) || table_desc != null && AcidUtils.isInsertOnlyTable(table_desc.getProperties());
        if (isDestInsertOnly) {
            fileSinkDesc.setWriteType(AcidUtils.Operation.INSERT);
            this.acidFileSinks.add(fileSinkDesc);
        }
        if (destTableIsAcid) {
            AcidUtils.Operation wt = this.updating(dest) ? AcidUtils.Operation.UPDATE : (this.deleting(dest) ? AcidUtils.Operation.DELETE : AcidUtils.Operation.INSERT);
            fileSinkDesc.setWriteType(wt);
            this.acidFileSinks.add(fileSinkDesc);
        }
        fileSinkDesc.setWriteOperation(writeOperation);
        fileSinkDesc.setTemporary(destTableIsTemporary);
        fileSinkDesc.setMaterialization(destTableIsMaterialization);
        if (lbCtx != null) {
            lbCtx.processRowSkewedIndex(fsRS);
            lbCtx.calculateSkewedValueSubDirList();
        }
        fileSinkDesc.setLbCtx(lbCtx);
        fileSinkDesc.setStatsAggPrefix(fileSinkDesc.getDirName().toString());
        if (!destTableIsMaterialization && HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_DBCLASS).equalsIgnoreCase(StatsSetupConst.StatDB.fs.name())) {
            String statsTmpLoc = isLocal ? this.ctx.getMRTmpPath().toString() : this.ctx.getTempDirForInterimJobPath(dest_path).toString();
            fileSinkDesc.setStatsTmpDir(statsTmpLoc);
            this.LOG.debug("Set stats collection dir : " + statsTmpLoc);
        }
        if (dest_part != null) {
            try {
                String staticSpec = Warehouse.makePartPath(dest_part.getSpec());
                fileSinkDesc.setStaticSpec(staticSpec);
            }
            catch (MetaException e) {
                throw new SemanticException((Throwable)e);
            }
        } else if (dpCtx != null) {
            fileSinkDesc.setStaticSpec(dpCtx.getSPPath());
        }
        return fileSinkDesc;
    }

    private void handleLineage(org.apache.hadoop.hive.ql.metadata.Table destinationTable, LoadTableDesc ltd, Operator output) throws SemanticException {
        if (ltd != null) {
            this.queryState.getLineageState().mapDirToOp(ltd.getSourcePath(), output);
        }
        if (HiveOperation.CREATETABLE_AS_SELECT.equals((Object)this.queryState.getHiveOperation())) {
            Path tlocation = null;
            String tName = Utilities.getDbTableName(this.tableDesc.getDbTableName())[1];
            try {
                String suffix = Utilities.getTableOrMVSuffix(this.ctx, AcidUtils.isTableSoftDeleteEnabled(destinationTable, this.conf));
                Warehouse wh = new Warehouse((Configuration)this.conf);
                tlocation = wh.getDefaultTablePath(this.db.getDatabase(this.tableDesc.getDatabaseName()), tName + suffix, this.tableDesc.isExternal());
                if (destinationTable != null && destinationTable.getSd() != null && destinationTable.getPath() != null) {
                    tlocation = destinationTable.getPath();
                }
            }
            catch (MetaException | HiveException e) {
                throw new SemanticException(e);
            }
            this.queryState.getLineageState().mapDirToOp(tlocation, output);
        } else if (HiveOperation.CREATE_MATERIALIZED_VIEW.equals((Object)this.queryState.getHiveOperation())) {
            Path tlocation;
            String[] dbTable = Utilities.getDbTableName(this.createVwDesc.getViewName());
            try {
                Warehouse wh = new Warehouse((Configuration)this.conf);
                Map<String, String> tblProps = this.createVwDesc.getTblProps();
                tlocation = wh.getDefaultTablePath(this.db.getDatabase(dbTable[0]), dbTable[1], tblProps == null || !AcidUtils.isTablePropertyTransactional(tblProps));
            }
            catch (MetaException | HiveException e) {
                throw new SemanticException(e);
            }
            this.queryState.getLineageState().mapDirToOp(tlocation, output);
        }
    }

    private void setWriteIdForSurrogateKeys(LoadTableDesc ltd, Operator input) {
        if (ltd == null) {
            return;
        }
        Map<String, ExprNodeDesc> columnExprMap = input.getConf().getColumnExprMap();
        if (columnExprMap != null) {
            for (ExprNodeDesc exprNodeDesc : columnExprMap.values()) {
                GenericUDF genericUDF;
                if (!(exprNodeDesc instanceof ExprNodeGenericFuncDesc) || !((genericUDF = ((ExprNodeGenericFuncDesc)exprNodeDesc).getGenericUDF()) instanceof GenericUDFSurrogateKey)) continue;
                ((GenericUDFSurrogateKey)genericUDF).setWriteId(ltd.getWriteId());
            }
        }
        for (Operator operator : input.getParentOperators()) {
            this.setWriteIdForSurrogateKeys(ltd, operator);
        }
    }

    private WriteEntity generateTableWriteEntity(String dest, org.apache.hadoop.hive.ql.metadata.Table dest_tab, Map<String, String> partSpec, LoadTableDesc ltd, DynamicPartitionCtx dpCtx) throws SemanticException {
        WriteEntity output = null;
        if (!(dpCtx != null && dpCtx.getNumDPCols() != 0 || this.outputs.add(output = new WriteEntity(dest_tab, this.determineWriteType(ltd, dest))) || this.allowOutputMultipleTimes())) {
            throw new SemanticException(ErrorMsg.OUTPUT_SPECIFIED_MULTIPLE_TIMES.getMsg(dest_tab.getTableName()));
        }
        if (dpCtx != null && dpCtx.getNumDPCols() >= 0) {
            if (dpCtx.getNumSPCols() == 0) {
                output = new WriteEntity(dest_tab, this.determineWriteType(ltd, dest), true);
                this.outputs.add(output);
                output.setDynamicPartitionWrite(true);
            } else {
                String ppath = dpCtx.getSPPath();
                ppath = ppath.substring(0, ppath.length() - 1);
                DummyPartition p = new DummyPartition(dest_tab, dest_tab.getDbName() + "@" + dest_tab.getTableName() + "@" + ppath, partSpec);
                WriteEntity.WriteType writeType = ltd.isInsertOverwrite() ? WriteEntity.WriteType.INSERT_OVERWRITE : this.getWriteType(dest);
                output = new WriteEntity(p, writeType, false);
                output.setDynamicPartitionWrite(true);
                this.outputs.add(output);
            }
        }
        return output;
    }

    protected boolean allowOutputMultipleTimes() {
        return false;
    }

    private void checkExternalTable(org.apache.hadoop.hive.ql.metadata.Table dest_tab) throws SemanticException {
        if (!this.conf.getBoolVar(HiveConf.ConfVars.HIVE_INSERT_INTO_EXTERNAL_TABLES) && dest_tab.getTableType().equals((Object)TableType.EXTERNAL_TABLE)) {
            throw new SemanticException(ErrorMsg.INSERT_EXTERNAL_TABLE.getMsg(dest_tab.getTableName()));
        }
    }

    private void checkImmutableTable(QB qb, org.apache.hadoop.hive.ql.metadata.Table dest_tab, Path dest_path, boolean isPart) throws SemanticException {
        if (!dest_tab.isImmutable() || !qb.getParseInfo().isInsertIntoTable(dest_tab.getDbName(), dest_tab.getTableName(), dest_tab.getSnapshotRef())) {
            return;
        }
        try {
            FileSystem fs = dest_path.getFileSystem((Configuration)this.conf);
            if (!org.apache.hadoop.hive.metastore.utils.FileUtils.isDirEmpty((FileSystem)fs, (Path)dest_path)) {
                this.LOG.warn("Attempted write into an immutable table : " + dest_tab.getTableName() + " : " + String.valueOf(dest_path));
                throw new SemanticException(ErrorMsg.INSERT_INTO_IMMUTABLE_TABLE.getMsg(dest_tab.getTableName()));
            }
        }
        catch (IOException ioe) {
            this.LOG.warn("Error while trying to determine if immutable table " + (isPart ? "partition " : "") + "has any data : " + dest_tab.getTableName() + " : " + String.valueOf(dest_path));
            throw new SemanticException(ErrorMsg.INSERT_INTO_IMMUTABLE_TABLE.getMsg(ioe.getMessage()));
        }
    }

    private DynamicPartitionCtx checkDynPart(QB qb, QBMetaData qbm, org.apache.hadoop.hive.ql.metadata.Table dest_tab, Map<String, String> partSpec, String dest) throws SemanticException {
        List<FieldSchema> parts = dest_tab.getPartitionKeys();
        if (parts == null || parts.isEmpty()) {
            return null;
        }
        if (partSpec == null || partSpec.isEmpty()) {
            throw new SemanticException(SemanticAnalyzer.generateErrorMessage(qb.getParseInfo().getDestForClause(dest), ErrorMsg.NEED_PARTITION_ERROR.getMsg()));
        }
        DynamicPartitionCtx dpCtx = qbm.getDPCtx(dest);
        if (dpCtx == null) {
            dest_tab.validatePartColumnNames(partSpec, false);
            dpCtx = new DynamicPartitionCtx(partSpec, this.conf.getVar(HiveConf.ConfVars.DEFAULT_PARTITION_NAME), this.conf.getIntVar(HiveConf.ConfVars.DYNAMIC_PARTITION_MAX_PARTS_PER_NODE));
            qbm.setDPCtx(dest, dpCtx);
        }
        SemanticAnalyzer.verifyDynamicPartitionEnabled(this.conf, qb, dest);
        if (dest_tab.getNumBuckets() > 0) {
            dpCtx.setNumBuckets(dest_tab.getNumBuckets());
        }
        return dpCtx;
    }

    private static void verifyDynamicPartitionEnabled(HiveConf conf, QB qb, String dest) throws SemanticException {
        if (!HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.DYNAMIC_PARTITIONING)) {
            throw new SemanticException(SemanticAnalyzer.generateErrorMessage(qb.getParseInfo().getDestForClause(dest), ErrorMsg.DYNAMIC_PARTITION_DISABLED.getMsg()));
        }
    }

    private void createPreInsertDesc(org.apache.hadoop.hive.ql.metadata.Table table, boolean overwrite) {
        PreInsertTableDesc preInsertTableDesc = new PreInsertTableDesc(table, overwrite);
        this.rootTasks.add(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), preInsertTableDesc)));
    }

    private void genAutoColumnStatsGatheringPipeline(org.apache.hadoop.hive.ql.metadata.Table table, Map<String, String> partSpec, Operator curr, boolean isInsertInto, boolean useTableValueConstructor) throws SemanticException {
        this.LOG.info("Generate an operator pipeline to autogather column stats for table " + table.getTableName() + " in query " + this.ctx.getCmd());
        ColumnStatsAutoGatherContext columnStatsAutoGatherContext = null;
        columnStatsAutoGatherContext = new ColumnStatsAutoGatherContext(this, this.conf, curr, table, partSpec, isInsertInto, this.ctx);
        if (useTableValueConstructor) {
            columnStatsAutoGatherContext.insertTableValuesAnalyzePipeline();
        } else {
            columnStatsAutoGatherContext.insertAnalyzePipeline();
        }
        this.columnStatsAutoGatherContexts.add(columnStatsAutoGatherContext);
    }

    String fixCtasColumnName(String colName) {
        return colName;
    }

    private void checkAcidConstraints() {
        this.conf.set("hive.doing.acid", "true");
        SessionState.get().getConf().set("hive.doing.acid", "true");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Operator genConversionSelectOperatorByAddPartition(String dest, QB qb, Operator input, Deserializer deserializer, org.apache.hadoop.hive.ql.metadata.Table table, Map<String, String> partitionSpec) throws SemanticException {
        StructObjectInspector oi = null;
        try {
            oi = (StructObjectInspector)deserializer.getObjectInspector();
        }
        catch (Exception e) {
            throw new SemanticException((Throwable)e);
        }
        List tableFields = oi.getAllStructFieldRefs();
        List<ColumnInfo> rowFields = this.opParseCtx.get(input).getRowResolver().getColumnInfos();
        int inColumnCnt = rowFields.size();
        int outColumnCnt = tableFields.size();
        long staticPartitionColumnCnt = partitionSpec != null ? partitionSpec.values().stream().filter(Objects::nonNull).count() : 0L;
        ArrayList<ExprNodeDesc> expressions = new ArrayList<ExprNodeDesc>(outColumnCnt);
        AtomicBoolean convert = new AtomicBoolean(false);
        if ((long)inColumnCnt + staticPartitionColumnCnt != (long)outColumnCnt) {
            String reason = "Table " + dest + " has " + outColumnCnt + " columns, but query has " + ((long)inColumnCnt + staticPartitionColumnCnt) + " columns.";
            throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.TARGET_TABLE_COLUMN_MISMATCH.getMsg(), (ASTNode)qb.getParseInfo().getDestForClause(dest), (String)reason));
        }
        int rowNum = 0;
        for (StructField tableField : tableFields) {
            ExprNodeDesc column;
            if (partitionSpec != null && partitionSpec.containsKey(tableField.getFieldName()) && partitionSpec.get(tableField.getFieldName()) != null) {
                TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)tableField.getFieldObjectInspector().getTypeName());
                if (tableField.getFieldObjectInspector().getCategory() != ObjectInspector.Category.PRIMITIVE) throw new SemanticException("Unable to use complex type as a partition type");
                AbstractPrimitiveJavaObjectInspector convertOI = PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveObjectInspector.PrimitiveCategory)((AbstractPrimitiveObjectInspector)tableField.getFieldObjectInspector()).getPrimitiveCategory());
                Object value = ObjectInspectorConverters.getConverter((ObjectInspector)new JavaConstantStringObjectInspector(partitionSpec.get(tableField.getFieldName())), (ObjectInspector)convertOI).convert((Object)partitionSpec.get(tableField.getFieldName()));
                column = new ExprNodeConstantDesc(typeInfo, value);
            } else if (partitionSpec != null && partitionSpec.containsKey(tableField.getFieldName()) && partitionSpec.get(tableField.getFieldName()) == null) {
                ColumnInfo inputColumn = rowFields.get(rowNum);
                TypeInfo inputTypeInfo = inputColumn.getType();
                column = new ExprNodeColumnDesc(inputTypeInfo, inputColumn.getInternalName(), "", true);
                ++rowNum;
            } else {
                column = this.handleConversion(tableField, rowFields.get(rowNum), convert, dest, rowNum);
                ++rowNum;
            }
            expressions.add(column);
        }
        if (expressions.size() != outColumnCnt) {
            String reason = "Table " + dest + " has " + outColumnCnt + " columns, but query has " + expressions.size() + " columns.";
            throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.TARGET_TABLE_COLUMN_MISMATCH.getMsg(), (ASTNode)qb.getParseInfo().getDestForClause(dest), (String)reason));
        }
        RowResolver rowResolver = new RowResolver();
        ArrayList<String> colNames = new ArrayList<String>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        for (int i = 0; i < expressions.size(); ++i) {
            String name = SemanticAnalyzer.getColumnInternalName(i);
            rowResolver.put("", name, new ColumnInfo(name, ((ExprNodeDesc)expressions.get(i)).getTypeInfo(), "", false));
            colNames.add(name);
            colExprMap.put(name, (ExprNodeDesc)expressions.get(i));
        }
        input = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new SelectDesc(expressions, colNames), new RowSchema(rowResolver.getColumnInfos()), input, new Operator[0]), rowResolver);
        input.setColumnExprMap(colExprMap);
        return input;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Operator genConversionSelectOperator(String dest, QB qb, Operator input, Deserializer deserializer, DynamicPartitionCtx dpCtx, List<FieldSchema> parts, org.apache.hadoop.hive.ql.metadata.Table table) throws SemanticException {
        oi = null;
        try {
            oi = (StructObjectInspector)deserializer.getObjectInspector();
        }
        catch (Exception e) {
            throw new SemanticException((Throwable)e);
        }
        tableFields = oi.getAllStructFieldRefs();
        dynPart = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.DYNAMIC_PARTITIONING);
        rowFields = this.opParseCtx.get(input).getRowResolver().getColumnInfos();
        inColumnCnt = rowFields.size();
        outColumnCnt = tableFields.size();
        alreadyContainsPartCols = Optional.ofNullable(table).map((Function<org.apache.hadoop.hive.ql.metadata.Table, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, hasNonNativePartitionSupport(), (Lorg/apache/hadoop/hive/ql/metadata/Table;)Ljava/lang/Boolean;)()).orElse(Boolean.FALSE);
        if (dynPart && dpCtx != null && !alreadyContainsPartCols) {
            outColumnCnt += dpCtx.getNumDPCols();
        }
        if (!(this.updating(dest) || this.deleting(dest) || this.merging(dest) || inColumnCnt == outColumnCnt)) {
            reason = "Table " + dest + " has " + outColumnCnt + " columns, but query has " + inColumnCnt + " columns.";
            throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.TARGET_TABLE_COLUMN_MISMATCH.getMsg(), (ASTNode)qb.getParseInfo().getDestForClause(dest), (String)reason));
        }
        converted = new AtomicBoolean(false);
        columnNumber = tableFields.size();
        expressions = new ArrayList<ExprNodeDesc>(columnNumber);
        if (!(deserializer instanceof MetadataTypedColumnsetSerDe) && !this.deleting(dest)) {
            virtualColumnSize = this.updating(dest) != false || this.merging(dest) != false ? AcidUtils.getAcidVirtualColumns(table).size() : 0;
            for (i = 0; i < virtualColumnSize; ++i) {
                expressions.add(new ExprNodeColumnDesc(rowFields.get(i).getType(), rowFields.get(i).getInternalName(), "", true));
            }
            rowFieldsOffset = expressions.size();
            for (i = 0; i < columnNumber; ++i) {
                column = this.handleConversion((StructField)tableFields.get(i), rowFields.get(rowFieldsOffset + i), converted, dest, i);
                expressions.add(column);
            }
            rowFieldsOffset = expressions.size();
            if (this.updating(dest) && AcidUtils.isNonNativeAcidTable(table) && rowFields.size() >= rowFieldsOffset + columnNumber) {
                for (i = 0; i < columnNumber; ++i) {
                    column = this.handleConversion((StructField)tableFields.get(i), rowFields.get(rowFieldsOffset - columnNumber + i), converted, dest, i);
                    expressions.add(column);
                }
            }
            rowFieldsOffset = expressions.size();
            ** if (!dynPart || dpCtx == null || dpCtx.getNumDPCols() <= 0) goto lbl64
            for (dpColIdx = 0; dpColIdx < rowFields.size() - rowFieldsOffset; ++dpColIdx) {
                inputColumn = rowFields.get(dpColIdx + rowFieldsOffset);
                inputTypeInfo = inputColumn.getType();
                column /* !! */  = new ExprNodeColumnDesc(inputTypeInfo, inputColumn.getInternalName(), "", true);
                if (this.conf.getBoolVar(HiveConf.ConfVars.DYNAMIC_PARTITION_CONVERT)) {
                    if (parts != null && !parts.isEmpty()) {
                        destPartitionName = dpCtx.getDPColNames().get(dpColIdx);
                        destPartitionFieldSchema = parts.stream().filter((Predicate<FieldSchema>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$genConversionSelectOperator$3(java.lang.String org.apache.hadoop.hive.metastore.api.FieldSchema ), (Lorg/apache/hadoop/hive/metastore/api/FieldSchema;)Z)((String)destPartitionName)).findFirst().orElse(null);
                        if (destPartitionFieldSchema == null) {
                            throw new IllegalStateException("Partition schema for dynamic partition " + destPartitionName + " not found in DynamicPartitionCtx.");
                        }
                        partitionType = destPartitionFieldSchema.getType();
                        if (partitionType == null) {
                            throw new IllegalStateException("Couldn't get FieldSchema for partition" + destPartitionFieldSchema.getName());
                        }
                        partitionTypeInfo = TypeInfoFactory.getPrimitiveTypeInfo((String)partitionType);
                        if (!partitionTypeInfo.equals((Object)inputTypeInfo)) {
                            column /* !! */  = (ExprNodeDesc)ExprNodeTypeCheck.getExprNodeDefaultExprProcessor().createConversionCast(column /* !! */ , partitionTypeInfo);
                            converted.set(true);
                        }
                    } else {
                        this.LOG.warn("Partition schema for dynamic partition " + inputColumn.getAlias() + " (" + inputColumn.getInternalName() + ") not found in DynamicPartitionCtx. This is expected with a CTAS.");
                    }
                }
                expressions.add(column /* !! */ );
lbl-1000:
                // 2 sources

                {
                    continue;
                }
            }
        }
lbl64:
        // 4 sources

        if (converted.get()) {
            rowResolver = new RowResolver();
            colNames = new ArrayList<String>();
            colExprMap = new HashMap<String, ExprNodeDesc>();
            for (i = 0; i < expressions.size(); ++i) {
                name = SemanticAnalyzer.getColumnInternalName(i);
                rowResolver.put("", name, new ColumnInfo(name, ((ExprNodeDesc)expressions.get(i)).getTypeInfo(), "", false));
                colNames.add(name);
                colExprMap.put(name, (ExprNodeDesc)expressions.get(i));
            }
            input = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new SelectDesc(expressions, colNames), new RowSchema(rowResolver.getColumnInfos()), (Operator)input, new Operator[0]), rowResolver);
            input.setColumnExprMap(colExprMap);
        }
        return input;
    }

    private ExprNodeDesc handleConversion(StructField tableField, ColumnInfo rowField, AtomicBoolean conversion, String dest, int columnNum) throws SemanticException {
        ObjectInspector tableFieldOI = tableField.getFieldObjectInspector();
        TypeInfo tableFieldTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)tableFieldOI);
        TypeInfo rowFieldTypeInfo = rowField.getType();
        ExprNodeDesc column = new ExprNodeColumnDesc(rowFieldTypeInfo, rowField.getInternalName(), "", false, rowField.isSkewedCol());
        if (!tableFieldTypeInfo.equals((Object)rowFieldTypeInfo)) {
            conversion.set(true);
            column = tableFieldTypeInfo.getCategory() != ObjectInspector.Category.PRIMITIVE ? null : (ExprNodeDesc)ExprNodeTypeCheck.getExprNodeDefaultExprProcessor().createConversionCast(column, (PrimitiveTypeInfo)tableFieldTypeInfo);
            if (column == null) {
                String reason = "Cannot convert column " + columnNum + " from " + String.valueOf(rowFieldTypeInfo) + " to " + String.valueOf(tableFieldTypeInfo) + ".";
                throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.TARGET_TABLE_COLUMN_MISMATCH.getMsg(), (ASTNode)this.qb.getParseInfo().getDestForClause(dest), (String)reason));
            }
        }
        return column;
    }

    private Operator genLimitPlan(String dest, Operator input, int offset, int limit) {
        RowResolver inputRR = this.opParseCtx.get(input).getRowResolver();
        LimitDesc limitDesc = new LimitDesc(offset, limit);
        this.globalLimitCtx.setLastReduceLimitDesc(limitDesc);
        Operator<LimitDesc> limitMap = this.putOpInsertMap(OperatorFactory.getAndMakeChild(limitDesc, new RowSchema(inputRR.getColumnInfos()), input, new Operator[0]), inputRR);
        this.LOG.debug("Created LimitOperator Plan for clause: {} row schema: {}", (Object)dest, (Object)inputRR);
        return limitMap;
    }

    private Operator genUDTFPlan(GenericUDTF genericUDTF, String outputTableAlias, List<String> colAliases, QB qb, Operator input, boolean outerLV) throws SemanticException {
        int numSuppliedAliases;
        QBParseInfo qbp = qb.getParseInfo();
        if (!qbp.getDestToGroupBy().isEmpty()) {
            throw new SemanticException(ErrorMsg.UDTF_NO_GROUP_BY.getMsg());
        }
        if (!qbp.getDestToDistributeBy().isEmpty()) {
            throw new SemanticException(ErrorMsg.UDTF_NO_DISTRIBUTE_BY.getMsg());
        }
        if (!qbp.getDestToSortBy().isEmpty()) {
            throw new SemanticException(ErrorMsg.UDTF_NO_SORT_BY.getMsg());
        }
        if (!qbp.getDestToClusterBy().isEmpty()) {
            throw new SemanticException(ErrorMsg.UDTF_NO_CLUSTER_BY.getMsg());
        }
        if (!qbp.getAliasToLateralViews().isEmpty()) {
            throw new SemanticException(ErrorMsg.UDTF_LATERAL_VIEW.getMsg());
        }
        this.LOG.debug("Table alias: {} Col aliases: {}", (Object)outputTableAlias, colAliases);
        RowResolver selectRR = this.opParseCtx.get(input).getRowResolver();
        List<ColumnInfo> inputCols = selectRR.getColumnInfos();
        ArrayList<String> colNames = new ArrayList<String>();
        ObjectInspector[] colOIs = new ObjectInspector[inputCols.size()];
        for (int i = 0; i < inputCols.size(); ++i) {
            colNames.add(inputCols.get(i).getInternalName());
            colOIs[i] = inputCols.get(i).getObjectInspector();
        }
        StandardStructObjectInspector rowOI = ObjectInspectorFactory.getStandardStructObjectInspector(colNames, Arrays.asList(colOIs));
        StructObjectInspector outputOI = genericUDTF.initialize((StructObjectInspector)rowOI);
        int numUdtfCols = outputOI.getAllStructFieldRefs().size();
        if (colAliases.isEmpty()) {
            for (StructField field : outputOI.getAllStructFieldRefs()) {
                colAliases.add(field.getFieldName());
            }
        }
        if (numUdtfCols != (numSuppliedAliases = colAliases.size())) {
            throw new SemanticException(ErrorMsg.UDTF_ALIAS_MISMATCH.getMsg("expected " + numUdtfCols + " aliases but got " + numSuppliedAliases));
        }
        ArrayList<ColumnInfo> udtfCols = new ArrayList<ColumnInfo>();
        Iterator<String> colAliasesIter = colAliases.iterator();
        for (StructField sf : outputOI.getAllStructFieldRefs()) {
            String colAlias = colAliasesIter.next();
            assert (colAlias != null);
            ColumnInfo col = new ColumnInfo(sf.getFieldName(), TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)sf.getFieldObjectInspector()), outputTableAlias, false);
            udtfCols.add(col);
        }
        RowResolver out_rwsch = new RowResolver();
        for (int i = 0; i < udtfCols.size(); ++i) {
            out_rwsch.put(outputTableAlias, colAliases.get(i), (ColumnInfo)udtfCols.get(i));
        }
        return this.putOpInsertMap(OperatorFactory.getAndMakeChild(new UDTFDesc(genericUDTF, outerLV), new RowSchema(out_rwsch.getColumnInfos()), input, new Operator[0]), out_rwsch);
    }

    private Operator genLimitMapRedPlan(String dest, QB qb, Operator input, int offset, int limit, boolean extraMRStep) throws SemanticException {
        Operator curr = this.genLimitPlan(dest, input, offset, limit);
        if (!extraMRStep || !HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_GROUPBY_LIMIT_EXTRASTEP)) {
            return curr;
        }
        curr = this.genReduceSinkPlan(dest, qb, curr, 1, false);
        return this.genLimitPlan(dest, curr, offset, limit);
    }

    private List<ExprNodeDesc> getPartitionColsFromBucketCols(String dest, QB qb, org.apache.hadoop.hive.ql.metadata.Table tab, TableDesc table_desc, Operator input, boolean convert) throws SemanticException {
        List<String> tabBucketCols = tab.getBucketCols();
        List<FieldSchema> tabCols = tab.getCols();
        ArrayList<Integer> posns = new ArrayList<Integer>();
        block0: for (String bucketCol : tabBucketCols) {
            int pos = 0;
            for (FieldSchema tabCol : tabCols) {
                if (bucketCol.equals(tabCol.getName())) {
                    posns.add(pos);
                    continue block0;
                }
                ++pos;
            }
        }
        return this.genConvertCol(dest, qb, table_desc, input, posns, convert);
    }

    private List<ExprNodeDesc> getPartitionColsFromBucketColsForUpdateDelete(Operator input, boolean convert) throws SemanticException {
        ColumnInfo rowField = this.opParseCtx.get(input).getRowResolver().getColumnInfos().get(0);
        TypeInfo rowFieldTypeInfo = rowField.getType();
        ExprNodeDesc column = new ExprNodeColumnDesc(rowFieldTypeInfo, rowField.getInternalName(), rowField.getTabAlias(), true);
        if (convert) {
            column = (ExprNodeDesc)ExprNodeTypeCheck.getExprNodeDefaultExprProcessor().createConversionCast(column, TypeInfoFactory.intTypeInfo);
        }
        return Collections.singletonList(column);
    }

    private List<ExprNodeDesc> genConvertCol(String dest, QB qb, TableDesc tableDesc, Operator input, List<Integer> posns, boolean convert) throws SemanticException {
        StructObjectInspector oi = null;
        try {
            AbstractSerDe deserializer = tableDesc.getSerDeClass().newInstance();
            deserializer.initialize((Configuration)this.conf, tableDesc.getProperties(), null);
            oi = (StructObjectInspector)deserializer.getObjectInspector();
        }
        catch (Exception e) {
            throw new SemanticException((Throwable)e);
        }
        List tableFields = oi.getAllStructFieldRefs();
        List<ColumnInfo> rowFields = this.opParseCtx.get(input).getRowResolver().getColumnInfos();
        int columnNumber = posns.size();
        ArrayList<ExprNodeDesc> expressions = new ArrayList<ExprNodeDesc>(columnNumber);
        for (Integer posn : posns) {
            ObjectInspector tableFieldOI = ((StructField)tableFields.get(posn)).getFieldObjectInspector();
            TypeInfo tableFieldTypeInfo = TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)tableFieldOI);
            TypeInfo rowFieldTypeInfo = rowFields.get(posn).getType();
            ExprNodeDesc column = new ExprNodeColumnDesc(rowFieldTypeInfo, rowFields.get(posn).getInternalName(), rowFields.get(posn).getTabAlias(), rowFields.get(posn).getIsVirtualCol());
            if (convert && !tableFieldTypeInfo.equals((Object)rowFieldTypeInfo) && (column = tableFieldTypeInfo.getCategory() != ObjectInspector.Category.PRIMITIVE ? null : (ExprNodeDesc)ExprNodeTypeCheck.getExprNodeDefaultExprProcessor().createConversionCast(column, (PrimitiveTypeInfo)tableFieldTypeInfo)) == null) {
                String reason = "Cannot convert column " + posn + " from " + String.valueOf(rowFieldTypeInfo) + " to " + String.valueOf(tableFieldTypeInfo) + ".";
                throw new SemanticException(ASTErrorUtils.getMsg((String)ErrorMsg.TARGET_TABLE_COLUMN_MISMATCH.getMsg(), (ASTNode)qb.getParseInfo().getDestForClause(dest), (String)reason));
            }
            expressions.add(column);
        }
        return expressions;
    }

    private List<ExprNodeDesc> getSortCols(String dest, QB qb, org.apache.hadoop.hive.ql.metadata.Table tab, TableDesc tableDesc, Operator input) throws SemanticException {
        List<Order> tabSortCols = tab.getSortCols();
        List<FieldSchema> tabCols = tab.getCols();
        ArrayList<Integer> posns = new ArrayList<Integer>();
        block0: for (Order sortCol : tabSortCols) {
            int pos = 0;
            for (FieldSchema tabCol : tabCols) {
                if (sortCol.getCol().equals(tabCol.getName())) {
                    posns.add(pos);
                    continue block0;
                }
                ++pos;
            }
        }
        return this.genConvertCol(dest, qb, tableDesc, input, posns, false);
    }

    private void getSortOrders(org.apache.hadoop.hive.ql.metadata.Table tab, StringBuilder order, StringBuilder nullOrder) {
        List<Order> tabSortCols = tab.getSortCols();
        List<FieldSchema> tabCols = tab.getCols();
        block0: for (Order sortCol : tabSortCols) {
            for (FieldSchema tabCol : tabCols) {
                if (!sortCol.getCol().equals(tabCol.getName())) continue;
                order.append(DirectionUtils.codeToSign(sortCol.getOrder()));
                nullOrder.append(sortCol.getOrder() == 1 ? (char)'a' : 'z');
                continue block0;
            }
        }
    }

    private Operator genReduceSinkPlan(String dest, QB qb, Operator<?> input, int numReducers, boolean hasOrderBy) throws SemanticException {
        Operator result;
        ASTNode sortExprs;
        RowResolver inputRR = this.opParseCtx.get(input).getRowResolver();
        ASTNode partitionExprs = qb.getParseInfo().getClusterByForClause(dest);
        if (partitionExprs == null) {
            partitionExprs = qb.getParseInfo().getDistributeByForClause(dest);
        }
        ArrayList<ExprNodeDesc> partCols = new ArrayList<ExprNodeDesc>();
        if (partitionExprs != null) {
            int ccount = partitionExprs.getChildCount();
            for (int i = 0; i < ccount; ++i) {
                ASTNode cl = (ASTNode)partitionExprs.getChild(i);
                partCols.add(this.genExprNodeDesc(cl, inputRR));
            }
        }
        if ((sortExprs = qb.getParseInfo().getClusterByForClause(dest)) == null) {
            sortExprs = qb.getParseInfo().getSortByForClause(dest);
        }
        if (sortExprs == null && (sortExprs = qb.getParseInfo().getOrderByForClause(dest)) != null) {
            String error;
            assert (numReducers == 1);
            if (qb.getParseInfo().getDestLimit(dest) == null && (error = HiveConf.StrictChecks.checkNoLimit((Configuration)this.conf)) != null) {
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage(sortExprs, error));
            }
        }
        ArrayList<ExprNodeDesc> sortCols = new ArrayList<ExprNodeDesc>();
        StringBuilder order = new StringBuilder();
        StringBuilder nullOrder = new StringBuilder();
        if (sortExprs != null) {
            int ccount = sortExprs.getChildCount();
            for (int i = 0; i < ccount; ++i) {
                ASTNode cl = (ASTNode)sortExprs.getChild(i);
                if (cl.getType() == 1281) {
                    order.append("+");
                    cl = (ASTNode)cl.getChild(0);
                    if (cl.getType() == 1106) {
                        nullOrder.append("a");
                    } else if (cl.getType() == 1107) {
                        nullOrder.append("z");
                    } else {
                        throw new SemanticException("Unexpected null ordering option: " + cl.getType());
                    }
                    cl = (ASTNode)cl.getChild(0);
                } else if (cl.getType() == 1282) {
                    order.append("-");
                    cl = (ASTNode)cl.getChild(0);
                    if (cl.getType() == 1106) {
                        nullOrder.append("a");
                    } else if (cl.getType() == 1107) {
                        nullOrder.append("z");
                    } else {
                        throw new SemanticException("Unexpected null ordering option: " + cl.getType());
                    }
                    cl = (ASTNode)cl.getChild(0);
                } else {
                    order.append("+");
                    nullOrder.append("a");
                }
                ExprNodeDesc exprNode = this.genExprNodeDesc(cl, inputRR);
                sortCols.add(exprNode);
            }
        }
        org.apache.hadoop.hive.ql.metadata.Table dest_tab = qb.getMetaData().getDestTableForAlias(dest);
        AcidUtils.Operation acidOp = AcidUtils.Operation.NOT_ACID;
        if (AcidUtils.isTransactionalTable(dest_tab)) {
            acidOp = this.getAcidType(Utilities.getTableDesc(dest_tab).getOutputFileFormatClass(), dest, AcidUtils.isInsertOnlyTable(dest_tab));
        }
        boolean isCompaction = false;
        if (dest_tab != null && dest_tab.getParameters() != null) {
            isCompaction = AcidUtils.isCompactionTable(dest_tab.getParameters());
        }
        if ((result = this.genReduceSinkPlan(input, partCols, sortCols, order.toString(), nullOrder.toString(), numReducers, acidOp, true, isCompaction)).getParentOperators().size() == 1 && result.getParentOperators().get(0) instanceof ReduceSinkOperator) {
            ((ReduceSinkDesc)((ReduceSinkOperator)result.getParentOperators().get(0)).getConf()).setHasOrderBy(hasOrderBy);
        }
        return result;
    }

    private Operator genReduceSinkPlan(Operator<?> input, List<ExprNodeDesc> partitionCols, List<ExprNodeDesc> sortCols, String sortOrder, String nullOrder, int numReducers, AcidUtils.Operation acidOp, boolean isCompaction) throws SemanticException {
        return this.genReduceSinkPlan(input, partitionCols, sortCols, sortOrder, nullOrder, numReducers, acidOp, false, isCompaction);
    }

    private Operator genReduceSinkPlan(Operator<?> input, List<ExprNodeDesc> partitionCols, List<ExprNodeDesc> sortCols, String sortOrder, String nullOrder, int numReducers, AcidUtils.Operation acidOp, boolean pullConstants, boolean isCompaction) throws SemanticException {
        RowResolver inputRR = this.opParseCtx.get(input).getRowResolver();
        Operator dummy = Operator.createDummy();
        dummy.setParentOperators(Arrays.asList(input));
        ArrayList<ExprNodeDesc> newSortCols = new ArrayList<ExprNodeDesc>();
        StringBuilder newSortOrder = new StringBuilder();
        StringBuilder newNullOrder = new StringBuilder();
        ArrayList<ExprNodeDesc> sortColsBack = new ArrayList<ExprNodeDesc>();
        for (int i = 0; i < sortCols.size(); ++i) {
            ExprNodeDesc sortCol = sortCols.get(i);
            if (pullConstants && sortCol instanceof ExprNodeConstantDesc) continue;
            newSortCols.add(sortCol);
            newSortOrder.append(sortOrder.charAt(i));
            newNullOrder.append(nullOrder.charAt(i));
            sortColsBack.add(ExprNodeDescUtils.backtrack(sortCol, dummy, input));
        }
        RowResolver rsRR = new RowResolver();
        ArrayList<String> outputColumns = new ArrayList<String>();
        ArrayList<ExprNodeDesc> valueCols = new ArrayList<ExprNodeDesc>();
        ArrayList<ExprNodeDesc> valueColsBack = new ArrayList<ExprNodeDesc>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        ArrayList<ExprNodeDesc> constantCols = new ArrayList<ExprNodeDesc>();
        List<ColumnInfo> columnInfos = inputRR.getColumnInfos();
        int[] index = new int[columnInfos.size()];
        for (int i = 0; i < index.length; ++i) {
            int vindex;
            int kindex;
            ColumnInfo colInfo = columnInfos.get(i);
            String[] nm = inputRR.reverseLookup(colInfo.getInternalName());
            String[] nm2 = inputRR.getAlternateMappings(colInfo.getInternalName());
            ExprNodeColumnDesc value = new ExprNodeColumnDesc(colInfo);
            ExprNodeDesc valueBack = ExprNodeDescUtils.backtrack(value, dummy, input);
            if (pullConstants && valueBack instanceof ExprNodeConstantDesc) {
                index[i] = Integer.MAX_VALUE;
                constantCols.add(valueBack);
                continue;
            }
            int n = kindex = valueBack == null ? -1 : ExprNodeDescUtils.indexOf(valueBack, sortColsBack);
            if (kindex >= 0) {
                index[i] = kindex;
                ColumnInfo newColInfo = new ColumnInfo(colInfo);
                newColInfo.setInternalName(String.valueOf((Object)Utilities.ReduceField.KEY) + ".reducesinkkey" + kindex);
                newColInfo.setTabAlias(nm[0]);
                rsRR.put(nm[0], nm[1], newColInfo);
                if (nm2 == null) continue;
                rsRR.addMappingOnly(nm2[0], nm2[1], newColInfo);
                continue;
            }
            int n2 = vindex = valueBack == null ? -1 : ExprNodeDescUtils.indexOf(valueBack, valueColsBack);
            if (vindex >= 0) {
                index[i] = -vindex - 1;
                continue;
            }
            index[i] = -valueCols.size() - 1;
            String outputColName = SemanticAnalyzer.getColumnInternalName(valueCols.size());
            valueCols.add(value);
            valueColsBack.add(valueBack);
            ColumnInfo newColInfo = new ColumnInfo(colInfo);
            newColInfo.setInternalName(String.valueOf((Object)Utilities.ReduceField.VALUE) + "." + outputColName);
            newColInfo.setTabAlias(nm[0]);
            rsRR.put(nm[0], nm[1], newColInfo);
            if (nm2 != null) {
                rsRR.addMappingOnly(nm2[0], nm2[1], newColInfo);
            }
            outputColumns.add(outputColName);
        }
        dummy.setParentOperators(null);
        ReduceSinkDesc rsdesc = PlanUtils.getReduceSinkDesc(newSortCols, valueCols, outputColumns, false, -1, partitionCols, newSortOrder.toString(), newNullOrder.toString(), this.defaultNullOrder, numReducers, acidOp, isCompaction);
        Operator<ReduceSinkDesc> interim = this.putOpInsertMap(OperatorFactory.getAndMakeChild(rsdesc, new RowSchema(rsRR.getColumnInfos()), input, new Operator[0]), rsRR);
        List<String> keyColNames = rsdesc.getOutputKeyColumnNames();
        for (int i = 0; i < keyColNames.size(); ++i) {
            colExprMap.put(String.valueOf((Object)Utilities.ReduceField.KEY) + "." + keyColNames.get(i), (ExprNodeDesc)newSortCols.get(i));
        }
        List<String> valueColNames = rsdesc.getOutputValueColumnNames();
        for (int i = 0; i < valueColNames.size(); ++i) {
            colExprMap.put(String.valueOf((Object)Utilities.ReduceField.VALUE) + "." + valueColNames.get(i), (ExprNodeDesc)valueCols.get(i));
        }
        interim.setColumnExprMap(colExprMap);
        RowResolver selectRR = new RowResolver();
        ArrayList<ExprNodeDesc> selCols = new ArrayList<ExprNodeDesc>();
        ArrayList<String> selOutputCols = new ArrayList<String>();
        HashMap<String, ExprNodeDesc> selColExprMap = new HashMap<String, ExprNodeDesc>();
        Iterator constants = constantCols.iterator();
        for (int i = 0; i < index.length; ++i) {
            ExprNodeDesc desc;
            ColumnInfo prev = columnInfos.get(i);
            String[] nm = inputRR.reverseLookup(prev.getInternalName());
            String[] nm2 = inputRR.getAlternateMappings(prev.getInternalName());
            ColumnInfo info = new ColumnInfo(prev);
            if (index[i] == Integer.MAX_VALUE) {
                desc = (ExprNodeDesc)constants.next();
            } else {
                String field = index[i] >= 0 ? String.valueOf((Object)Utilities.ReduceField.KEY) + "." + keyColNames.get(index[i]) : String.valueOf((Object)Utilities.ReduceField.VALUE) + "." + valueColNames.get(-index[i] - 1);
                desc = new ExprNodeColumnDesc(info.getType(), field, info.getTabAlias(), info.getIsVirtualCol());
            }
            selCols.add(desc);
            String internalName = SemanticAnalyzer.getColumnInternalName(i);
            info.setInternalName(internalName);
            selectRR.put(nm[0], nm[1], info);
            if (nm2 != null) {
                selectRR.addMappingOnly(nm2[0], nm2[1], info);
            }
            selOutputCols.add(internalName);
            selColExprMap.put(internalName, desc);
        }
        SelectDesc select = new SelectDesc(selCols, selOutputCols);
        Operator<SelectDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(select, new RowSchema(selectRR.getColumnInfos()), interim, new Operator[0]), selectRR);
        output.setColumnExprMap(selColExprMap);
        return output;
    }

    private Operator genJoinOperatorChildren(QBJoinTree join, Operator left, Operator[] right, Set<Integer> omitOpts, ExprNodeDesc[][] joinKeys) throws SemanticException {
        RowResolver outputRR = new RowResolver();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        Operator[] rightOps = new Operator[right.length];
        HashMap<String, Byte> reversedExprs = new HashMap<String, Byte>();
        HashMap<Byte, List<ExprNodeDesc>> exprMap = new HashMap<Byte, List<ExprNodeDesc>>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        HashMap<Integer, Set<String>> posToAliasMap = new HashMap<Integer, Set<String>>();
        HashMap<Byte, List<ExprNodeDesc>> filterMap = new HashMap<Byte, List<ExprNodeDesc>>();
        ArrayList<ColumnInfo> topSelectInputColumns = new ArrayList<ColumnInfo>();
        for (int pos = 0; pos < right.length; ++pos) {
            ReduceSinkOperator rs;
            Operator input;
            Operator operator = input = right[pos] == null ? left : right[pos];
            if (input == null) {
                input = left;
            }
            if ((rs = (ReduceSinkOperator)input).getNumParent() != 1) {
                throw new SemanticException("RS should have single parent");
            }
            Operator<OperatorDesc> parent = rs.getParentOperators().get(0);
            ReduceSinkDesc rsDesc = (ReduceSinkDesc)input.getConf();
            int[] index = rs.getValueIndex();
            ArrayList<ExprNodeColumnDesc> valueDesc = new ArrayList<ExprNodeColumnDesc>();
            ArrayList<ExprNodeDesc> filterDesc = new ArrayList<ExprNodeDesc>();
            Byte tag = (byte)rsDesc.getTag();
            if (omitOpts != null && omitOpts.contains(pos) && join.getPostJoinFilters().size() == 0) {
                exprMap.put(tag, valueDesc);
                filterMap.put(tag, filterDesc);
                rightOps[pos] = input;
                continue;
            }
            List<String> keyColNames = rsDesc.getOutputKeyColumnNames();
            List<String> valColNames = rsDesc.getOutputValueColumnNames();
            RowResolver inputRR = this.opParseCtx.get(input).getRowResolver();
            RowResolver parentRR = this.opParseCtx.get(parent).getRowResolver();
            posToAliasMap.put(pos, new HashSet<String>(inputRR.getTableNames()));
            List<ColumnInfo> columns = parentRR.getColumnInfos();
            for (int i = 0; i < index.length; ++i) {
                ColumnInfo prev = columns.get(i);
                String[] nm = parentRR.reverseLookup(prev.getInternalName());
                String[] nm2 = parentRR.getAlternateMappings(prev.getInternalName());
                if (outputRR.get(nm[0], nm[1]) != null) continue;
                ColumnInfo info = new ColumnInfo(prev);
                String field = index[i] >= 0 ? String.valueOf((Object)Utilities.ReduceField.KEY) + "." + keyColNames.get(index[i]) : String.valueOf((Object)Utilities.ReduceField.VALUE) + "." + valColNames.get(-index[i] - 1);
                String internalName = SemanticAnalyzer.getColumnInternalName(outputColumnNames.size());
                ExprNodeColumnDesc desc = new ExprNodeColumnDesc(info.getType(), field, info.getTabAlias(), info.getIsVirtualCol());
                info.setInternalName(internalName);
                colExprMap.put(internalName, desc);
                outputRR.put(nm[0], nm[1], info);
                if (nm2 != null) {
                    outputRR.addMappingOnly(nm2[0], nm2[1], info);
                }
                valueDesc.add(desc);
                outputColumnNames.add(internalName);
                reversedExprs.put(internalName, tag);
                if (omitOpts != null && omitOpts.contains(pos)) continue;
                topSelectInputColumns.add(info);
            }
            for (ASTNode cond : join.getFilters().get(tag.byteValue())) {
                filterDesc.add(this.genExprNodeDesc(cond, inputRR));
            }
            exprMap.put(tag, valueDesc);
            filterMap.put(tag, filterDesc);
            rightOps[pos] = input;
        }
        JoinCondDesc[] joinCondns = new JoinCondDesc[join.getJoinCond().length];
        for (int i = 0; i < join.getJoinCond().length; ++i) {
            JoinCond condn = join.getJoinCond()[i];
            joinCondns[i] = new JoinCondDesc(condn);
        }
        JoinDesc desc = new JoinDesc(exprMap, outputColumnNames, join.getNoOuterJoin(), joinCondns, filterMap, joinKeys, null);
        desc.setReversedExprs(reversedExprs);
        desc.setFilterMap(join.getFilterMap());
        if (!(join.getPostJoinFilters().size() == 0 || join.getNoOuterJoin() && join.getNoSemiJoin() && !HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_PUSH_RESIDUAL_INNER))) {
            this.LOG.debug("Generate JOIN with post-filtering conditions");
            ArrayList<ExprNodeDesc> residualFilterExprs = new ArrayList<ExprNodeDesc>();
            for (ASTNode cond : join.getPostJoinFilters()) {
                residualFilterExprs.add(this.genExprNodeDesc(cond, outputRR, false, this.isCBOExecuted()));
            }
            desc.setResidualFilterExprs(residualFilterExprs);
            join.getPostJoinFilters().clear();
        }
        JoinOperator joinOp = (JoinOperator)OperatorFactory.getAndMakeChild(this.getOpContext(), desc, new RowSchema(outputRR.getColumnInfos()), rightOps);
        joinOp.setColumnExprMap(colExprMap);
        joinOp.setPosToAliasMap(posToAliasMap);
        if (join.getNullSafes() != null) {
            boolean[] nullsafes = new boolean[join.getNullSafes().size()];
            for (int i = 0; i < nullsafes.length; ++i) {
                nullsafes[i] = join.getNullSafes().get(i);
            }
            desc.setNullSafes(nullsafes);
        }
        Operator<AbstractOperatorDesc> topOp = this.putOpInsertMap(joinOp, outputRR);
        if (omitOpts != null && !omitOpts.isEmpty() && desc.getResidualFilterExprs() != null && !desc.getResidualFilterExprs().isEmpty()) {
            ArrayList<ExprNodeDesc> topSelectExprs = new ArrayList<ExprNodeDesc>();
            ArrayList<String> topSelectOutputColNames = new ArrayList<String>();
            RowResolver topSelectRR = new RowResolver();
            HashMap<String, ExprNodeDesc> topSelectColExprMap = new HashMap<String, ExprNodeDesc>();
            for (ColumnInfo colInfo : topSelectInputColumns) {
                ExprNodeColumnDesc columnExpr = new ExprNodeColumnDesc(colInfo);
                topSelectExprs.add(columnExpr);
                topSelectOutputColNames.add(colInfo.getInternalName());
                topSelectColExprMap.put(colInfo.getInternalName(), columnExpr);
                String[] nm = outputRR.reverseLookup(columnExpr.getColumn());
                String[] nm2 = outputRR.getAlternateMappings(columnExpr.getColumn());
                topSelectRR.put(nm[0], nm[1], colInfo);
                if (nm2 == null) continue;
                topSelectRR.addMappingOnly(nm2[0], nm2[1], colInfo);
            }
            SelectDesc topSelect = new SelectDesc(topSelectExprs, topSelectOutputColNames);
            topOp = this.putOpInsertMap(OperatorFactory.getAndMakeChild(topSelect, new RowSchema(topSelectRR.getColumnInfos()), topOp, new Operator[0]), topSelectRR);
            topOp.setColumnExprMap(topSelectColExprMap);
        }
        return topOp;
    }

    private ExprNodeDesc[][] genJoinKeys(QBJoinTree joinTree, Operator[] inputs) throws SemanticException {
        ExprNodeDesc[][] joinKeys = new ExprNodeDesc[inputs.length][];
        for (int i = 0; i < inputs.length; ++i) {
            RowResolver inputRR = this.opParseCtx.get(inputs[i]).getRowResolver();
            List<ASTNode> expressions = joinTree.getExpressions().get(i);
            joinKeys[i] = new ExprNodeDesc[expressions.size()];
            for (int j = 0; j < joinKeys[i].length; ++j) {
                joinKeys[i][j] = this.genExprNodeDesc(expressions.get(j), inputRR, true, this.isCBOExecuted());
            }
        }
        return this.genJoinOperatorTypeCheck(joinKeys);
    }

    private Operator genJoinReduceSinkChild(ExprNodeDesc[] joinKeys, Operator<?> parent, String[] srcs, int tag) throws SemanticException {
        Operator dummy = Operator.createDummy();
        dummy.setParentOperators(Arrays.asList(parent));
        RowResolver inputRR = this.opParseCtx.get(parent).getRowResolver();
        RowResolver outputRR = new RowResolver();
        ArrayList<String> outputColumns = new ArrayList<String>();
        ArrayList<ExprNodeDesc> reduceKeys = new ArrayList<ExprNodeDesc>();
        ArrayList<ExprNodeDesc> reduceKeysBack = new ArrayList<ExprNodeDesc>();
        for (ExprNodeDesc joinKey : joinKeys) {
            reduceKeys.add(joinKey);
            reduceKeysBack.add(ExprNodeDescUtils.backtrack(joinKey, dummy, parent));
        }
        ArrayList<ExprNodeDesc> reduceValues = new ArrayList<ExprNodeDesc>();
        List<ColumnInfo> columns = inputRR.getColumnInfos();
        int[] index = new int[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            ColumnInfo colInfo = columns.get(i);
            String[] nm = inputRR.reverseLookup(colInfo.getInternalName());
            String[] nm2 = inputRR.getAlternateMappings(colInfo.getInternalName());
            ExprNodeColumnDesc expr = new ExprNodeColumnDesc(colInfo);
            ExprNodeDesc exprBack = ExprNodeDescUtils.backtrack(expr, dummy, parent);
            if (exprBack != null) {
                if (ExprNodeDescUtils.isConstant(exprBack)) {
                    int kindex = reduceKeysBack.indexOf(exprBack);
                    if (kindex >= 0) {
                        this.addJoinKeyToRowSchema(outputRR, index, i, colInfo, nm, nm2, kindex);
                        continue;
                    }
                } else {
                    int kindex;
                    int startIdx = 0;
                    while ((kindex = ExprNodeDescUtils.indexOf(exprBack, reduceKeysBack, startIdx)) >= 0) {
                        this.addJoinKeyToRowSchema(outputRR, index, i, colInfo, nm, nm2, kindex);
                        startIdx = kindex + 1;
                    }
                    if (startIdx > 0) continue;
                }
            }
            index[i] = -reduceValues.size() - 1;
            String outputColName = SemanticAnalyzer.getColumnInternalName(reduceValues.size());
            reduceValues.add(expr);
            ColumnInfo newColInfo = new ColumnInfo(colInfo);
            String internalColName = String.valueOf((Object)Utilities.ReduceField.VALUE) + "." + outputColName;
            newColInfo.setInternalName(internalColName);
            newColInfo.setTabAlias(nm[0]);
            outputRR.put(nm[0], nm[1], newColInfo);
            if (nm2 != null) {
                outputRR.addMappingOnly(nm2[0], nm2[1], newColInfo);
            }
            outputColumns.add(outputColName);
        }
        dummy.setParentOperators(null);
        int numReds = -1;
        if (reduceKeys.size() == 0) {
            numReds = 1;
            String error = HiveConf.StrictChecks.checkCartesian((Configuration)this.conf);
            if (error != null) {
                throw new SemanticException(error);
            }
        }
        ReduceSinkDesc rsDesc = PlanUtils.getReduceSinkDesc(reduceKeys, reduceValues, outputColumns, false, tag, reduceKeys.size(), numReds, AcidUtils.Operation.NOT_ACID, this.defaultNullOrder);
        HashMap<String, Object> translatorMap = new HashMap<String, Object>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        List<String> keyColNames = rsDesc.getOutputKeyColumnNames();
        for (int i = 0; i < keyColNames.size(); ++i) {
            String oldName = keyColNames.get(i);
            String newName = String.valueOf((Object)Utilities.ReduceField.KEY) + "." + oldName;
            colExprMap.put(newName, (ExprNodeDesc)reduceKeys.get(i));
            translatorMap.put(oldName, newName);
        }
        List<String> valColNames = rsDesc.getOutputValueColumnNames();
        for (int i = 0; i < valColNames.size(); ++i) {
            String oldName = valColNames.get(i);
            String newName = String.valueOf((Object)Utilities.ReduceField.VALUE) + "." + oldName;
            colExprMap.put(newName, reduceValues.get(i));
            translatorMap.put(oldName, newName);
        }
        RowSchema defaultRs = new RowSchema(outputRR.getColumnInfos());
        ArrayList<ColumnInfo> newColumnInfos = new ArrayList<ColumnInfo>();
        for (ColumnInfo ci : outputRR.getColumnInfos()) {
            if (translatorMap.containsKey(ci.getInternalName())) {
                ci = new ColumnInfo(ci);
                ci.setInternalName((String)translatorMap.get(ci.getInternalName()));
            }
            newColumnInfos.add(ci);
        }
        ReduceSinkOperator rsOp = (ReduceSinkOperator)this.putOpInsertMap(OperatorFactory.getAndMakeChild(rsDesc, new RowSchema(newColumnInfos), parent, new Operator[0]), outputRR);
        rsOp.setValueIndex(index);
        rsOp.setColumnExprMap(colExprMap);
        rsOp.setInputAliases(srcs);
        return rsOp;
    }

    private void addJoinKeyToRowSchema(RowResolver outputRR, int[] index, int i, ColumnInfo colInfo, String[] nm, String[] nm2, int kindex) {
        ColumnInfo newColInfo = new ColumnInfo(colInfo);
        String internalColName = String.valueOf((Object)Utilities.ReduceField.KEY) + ".reducesinkkey" + kindex;
        newColInfo.setInternalName(internalColName);
        newColInfo.setTabAlias(nm[0]);
        outputRR.put(nm[0], nm[1], newColInfo);
        if (nm2 != null) {
            outputRR.addMappingOnly(nm2[0], nm2[1], newColInfo);
        }
        index[i] = kindex;
    }

    private Operator genJoinOperator(QB qb, QBJoinTree joinTree, Map<String, Operator> map, Operator joiningOp) throws SemanticException {
        return this.genJoinOperator(qb, joinTree, map, joiningOp, false);
    }

    private Operator genJoinOperator(QB qb, QBJoinTree joinTree, Map<String, Operator> map, Operator joiningOp, boolean notInCheckPresent) throws SemanticException {
        QBJoinTree leftChild = joinTree.getJoinSrc();
        Operator joinSrcOp = joiningOp instanceof JoinOperator ? joiningOp : null;
        Operator OuterSrcOp = joiningOp;
        if (joinSrcOp == null && leftChild != null) {
            joinSrcOp = this.genJoinOperator(qb, leftChild, map, null);
        }
        if (joinSrcOp != null) {
            List<ASTNode> filter = joinTree.getFiltersForPushing().get(0);
            for (ASTNode cond : filter) {
                joinSrcOp = this.genFilterPlan(qb, cond, joinSrcOp, false);
            }
        }
        String[] baseSrc = joinTree.getBaseSrc();
        Operator[] srcOps = new Operator[baseSrc.length];
        HashSet<Integer> omitOpts = null;
        int pos = 0;
        for (String src : baseSrc) {
            if (src != null) {
                Operator srcOp = map.get(src.toLowerCase());
                List<ASTNode> fields = joinTree.getRHSSemijoinColumns(src);
                if (fields != null) {
                    if (omitOpts == null) {
                        omitOpts = new HashSet<Integer>();
                    }
                    omitOpts.add(pos);
                    srcOp = this.insertSelectForSemijoin(fields, srcOp);
                    srcOps[pos++] = this.genMapGroupByForSemijoin(fields, srcOp);
                    continue;
                }
                srcOps[pos++] = srcOp;
                continue;
            }
            assert (pos == 0);
            srcOps[pos++] = joinSrcOp;
        }
        ExprNodeDesc[][] joinKeys = this.genJoinKeys(joinTree, srcOps);
        for (int i = 0; i < srcOps.length; ++i) {
            String[] srcs;
            if (baseSrc[i] != null) {
                String[] stringArray = new String[1];
                v1 = stringArray;
                stringArray[0] = baseSrc[i];
            } else {
                v1 = srcs = joinTree.getLeftAliases();
            }
            if (!this.isCBOExecuted()) {
                boolean outerNotInCheck = notInCheckPresent && srcOps[i] == OuterSrcOp;
                srcOps[i] = this.genNotNullFilterForJoinSourcePlan(qb, srcOps[i], joinTree, joinKeys[i], outerNotInCheck);
            }
            srcOps[i] = this.genJoinReduceSinkChild(joinKeys[i], srcOps[i], srcs, joinTree.getNextTag());
        }
        Operator topOp = this.genJoinOperatorChildren(joinTree, joinSrcOp, srcOps, omitOpts, joinKeys);
        JoinOperator joinOp = topOp instanceof JoinOperator ? (JoinOperator)topOp : (JoinOperator)topOp.getParentOperators().get(0);
        ((JoinDesc)joinOp.getConf()).setQBJoinTreeProps(joinTree);
        this.joinContext.put(joinOp, joinTree);
        if (joinTree.getPostJoinFilters().size() != 0) {
            assert (joinTree.getNoOuterJoin());
            if (HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_PUSH_RESIDUAL_INNER)) {
                throw new SemanticException("Post-filtering conditions should have been added to the JOIN operator");
            }
            for (ASTNode condn : joinTree.getPostJoinFilters()) {
                topOp = this.genFilterPlan(qb, condn, topOp, false);
            }
        }
        return topOp;
    }

    private Operator insertSelectForSemijoin(List<ASTNode> fields, Operator<?> input) throws SemanticException {
        RowResolver inputRR = this.opParseCtx.get(input).getRowResolver();
        ArrayList<ExprNodeDesc> colList = new ArrayList<ExprNodeDesc>();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        RowResolver outputRR = new RowResolver();
        for (int i = 0; i < fields.size(); ++i) {
            String[] nm2;
            String[] nm;
            ASTNode field = fields.get(i);
            ExprNodeDesc expr = this.genExprNodeDesc(field, inputRR);
            if (expr instanceof ExprNodeColumnDesc) {
                ExprNodeColumnDesc columnExpr = (ExprNodeColumnDesc)expr;
                nm = inputRR.reverseLookup(columnExpr.getColumn());
                nm2 = inputRR.getAlternateMappings(columnExpr.getColumn());
            } else if (expr instanceof ExprNodeConstantDesc) {
                ExprNodeConstantDesc constantExpr = (ExprNodeConstantDesc)expr;
                String inputCol = constantExpr.getFoldedFromCol();
                nm = inputRR.reverseLookup(inputCol);
                nm2 = inputRR.getAlternateMappings(inputCol);
            } else {
                return input;
            }
            String colName = SemanticAnalyzer.getColumnInternalName(i);
            outputColumnNames.add(colName);
            ColumnInfo colInfo = new ColumnInfo(colName, expr.getTypeInfo(), "", false);
            outputRR.put(nm[0], nm[1], colInfo);
            if (nm2 != null) {
                outputRR.addMappingOnly(nm2[0], nm2[1], colInfo);
            }
            colList.add(expr);
            colExprMap.put(colName, expr);
        }
        Operator<SelectDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new SelectDesc(colList, outputColumnNames, false), new RowSchema(outputRR.getColumnInfos()), input, new Operator[0]), outputRR);
        output.setColumnExprMap(colExprMap);
        return output;
    }

    private Operator genMapGroupByForSemijoin(List<ASTNode> fields, Operator<?> input) throws SemanticException {
        RowResolver groupByInputRowResolver = this.opParseCtx.get(input).getRowResolver();
        RowResolver groupByOutputRowResolver = new RowResolver();
        ArrayList<ExprNodeDesc> groupByKeys = new ArrayList<ExprNodeDesc>();
        ArrayList<String> outputColumnNames = new ArrayList<String>();
        ArrayList<AggregationDesc> aggregations = new ArrayList<AggregationDesc>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        for (int i = 0; i < fields.size(); ++i) {
            String[] nm2;
            String[] nm;
            ASTNode colName = fields.get(i);
            ExprNodeDesc grpByExprNode = this.genExprNodeDesc(colName, groupByInputRowResolver);
            if (grpByExprNode instanceof ExprNodeColumnDesc) {
                ExprNodeColumnDesc columnExpr = (ExprNodeColumnDesc)grpByExprNode;
                nm = groupByInputRowResolver.reverseLookup(columnExpr.getColumn());
                nm2 = groupByInputRowResolver.getAlternateMappings(columnExpr.getColumn());
            } else if (grpByExprNode instanceof ExprNodeConstantDesc) {
                ExprNodeConstantDesc constantExpr = (ExprNodeConstantDesc)grpByExprNode;
                String inputCol = constantExpr.getFoldedFromCol();
                nm = groupByInputRowResolver.reverseLookup(inputCol);
                nm2 = groupByInputRowResolver.getAlternateMappings(inputCol);
            } else {
                return input;
            }
            groupByKeys.add(grpByExprNode);
            String field = SemanticAnalyzer.getColumnInternalName(i);
            outputColumnNames.add(field);
            ColumnInfo colInfo2 = new ColumnInfo(field, grpByExprNode.getTypeInfo(), "", false);
            groupByOutputRowResolver.put(nm[0], nm[1], colInfo2);
            if (nm2 != null) {
                groupByOutputRowResolver.addMappingOnly(nm2[0], nm2[1], colInfo2);
            }
            groupByOutputRowResolver.putExpression(colName, colInfo2);
            colExprMap.put(field, grpByExprNode);
        }
        float groupByMemoryUsage = HiveConf.getFloatVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAP_AGGR_HASH_MEMORY);
        float memoryThreshold = HiveConf.getFloatVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAP_AGGR_MEMORY_THRESHOLD);
        float minReductionHashAggr = HiveConf.getFloatVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAP_AGGR_HASH_MIN_REDUCTION);
        float minReductionHashAggrLowerBound = HiveConf.getFloatVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAP_AGGR_HASH_MIN_REDUCTION_LOWER_BOUND);
        float hashAggrFlushPercent = HiveConf.getFloatVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAP_AGGR_HASH_FLUSH_SIZE_PERCENT);
        Operator<GroupByDesc> op = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new GroupByDesc(GroupByDesc.Mode.HASH, outputColumnNames, groupByKeys, aggregations, false, groupByMemoryUsage, memoryThreshold, minReductionHashAggr, minReductionHashAggrLowerBound, hashAggrFlushPercent, null, false, -1, false), new RowSchema(groupByOutputRowResolver.getColumnInfos()), input, new Operator[0]), groupByOutputRowResolver);
        op.setColumnExprMap(colExprMap);
        return op;
    }

    private ExprNodeDesc[][] genJoinOperatorTypeCheck(ExprNodeDesc[][] keys) throws SemanticException {
        int keyLength = 0;
        for (int i = 0; i < keys.length; ++i) {
            if (i == 0) {
                keyLength = keys[i].length;
                continue;
            }
            assert (keyLength == keys[i].length);
        }
        for (int k = 0; k < keyLength; ++k) {
            int i;
            TypeInfo commonType = keys[0][k].getTypeInfo();
            for (i = 1; i < keys.length; ++i) {
                TypeInfo a = commonType;
                TypeInfo b = keys[i][k].getTypeInfo();
                if ((commonType = FunctionRegistry.getCommonClassForComparison(a, b)) != null) continue;
                throw new SemanticException("Cannot do equality join on different types: " + a.getTypeName() + " and " + b.getTypeName());
            }
            for (i = 0; i < keys.length; ++i) {
                if (TypeInfoUtils.isConversionRequiredForComparison((TypeInfo)keys[i][k].getTypeInfo(), (TypeInfo)commonType)) {
                    keys[i][k] = (ExprNodeDesc)ExprNodeTypeCheck.getExprNodeDefaultExprProcessor().createConversionCast(keys[i][k], (PrimitiveTypeInfo)commonType);
                    continue;
                }
                keys[i][k].setTypeInfo(commonType);
            }
        }
        return keys;
    }

    private Operator genJoinPlan(QB qb, Map<String, Operator> map) throws SemanticException {
        QBJoinTree joinTree = qb.getQbJoinTree();
        return this.genJoinOperator(qb, joinTree, map, null);
    }

    private void pushJoinFilters(QB qb, QBJoinTree joinTree, Map<String, Operator> map) throws SemanticException {
        this.pushJoinFilters(qb, joinTree, map, true);
    }

    private void pushJoinFilters(QB qb, QBJoinTree joinTree, Map<String, Operator> map, boolean recursively) throws SemanticException {
        if (recursively && joinTree.getJoinSrc() != null) {
            this.pushJoinFilters(qb, joinTree.getJoinSrc(), map);
        }
        List<List<ASTNode>> filters = joinTree.getFiltersForPushing();
        int pos = 0;
        for (String src : joinTree.getBaseSrc()) {
            if (src != null) {
                Operator srcOp = map.get(src);
                List<ASTNode> filter = filters.get(pos);
                for (ASTNode cond : filter) {
                    srcOp = this.genFilterPlan(qb, cond, srcOp, false);
                }
                map.put(src, srcOp);
            }
            ++pos;
        }
    }

    private List<String> getMapSideJoinTables(QB qb) {
        ArrayList<String> cols = new ArrayList<String>();
        ASTNode hints = qb.getParseInfo().getHints();
        for (int pos = 0; pos < hints.getChildCount(); ++pos) {
            ASTNode hint = (ASTNode)hints.getChild(pos);
            if (((ASTNode)hint.getChild(0)).getToken().getType() != 448) continue;
            if (!this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IGNORE_MAPJOIN_HINT) && !this.conf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez")) {
                ASTNode hintTblNames = (ASTNode)hint.getChild(1);
                int numCh = hintTblNames.getChildCount();
                for (int tblPos = 0; tblPos < numCh; ++tblPos) {
                    String tblName = ((ASTNode)hintTblNames.getChild(tblPos)).getText().toLowerCase();
                    if (cols.contains(tblName)) continue;
                    cols.add(tblName);
                }
                continue;
            }
            this.queryProperties.setMapJoinRemoved(true);
        }
        return cols;
    }

    private String getModifiedAlias(QB qb, String alias) {
        return QB.getAppendedAliasFromId(qb.getId(), alias);
    }

    private QBJoinTree genUniqueJoinTree(QB qb, ASTNode joinParseTree, Map<String, Operator> aliasToOpInfo) throws SemanticException {
        QBJoinTree joinTree = new QBJoinTree();
        joinTree.setNoOuterJoin(false);
        joinTree.setExpressions(new ArrayList<List<ASTNode>>());
        joinTree.setFilters(new ArrayList<List<ASTNode>>());
        joinTree.setFiltersForPushing(new ArrayList<List<ASTNode>>());
        ArrayList<String> rightAliases = new ArrayList<String>();
        ArrayList<String> leftAliases = new ArrayList<String>();
        ArrayList<String> baseSrc = new ArrayList<String>();
        ArrayList<Boolean> preserved = new ArrayList<Boolean>();
        boolean lastPreserved = false;
        int cols = -1;
        block6: for (int i = 0; i < joinParseTree.getChildCount(); ++i) {
            ASTNode child = (ASTNode)joinParseTree.getChild(i);
            switch (child.getToken().getType()) {
                case 1280: {
                    String alias;
                    String tableName = SemanticAnalyzer.getUnescapedUnqualifiedTableName((ASTNode)child.getChild(0));
                    String string = alias = child.getChildCount() == 1 ? tableName : SemanticAnalyzer.unescapeIdentifier(child.getChild(child.getChildCount() - 1).getText().toLowerCase());
                    if (i == 0) {
                        leftAliases.add(alias);
                        joinTree.setLeftAlias(alias);
                    } else {
                        rightAliases.add(alias);
                    }
                    joinTree.getAliasToOpInfo().put(this.getModifiedAlias(qb, alias), aliasToOpInfo.get(alias));
                    joinTree.setId(qb.getId());
                    baseSrc.add(alias);
                    preserved.add(lastPreserved);
                    lastPreserved = false;
                    continue block6;
                }
                case 1027: {
                    if (cols == -1 && child.getChildCount() != 0) {
                        cols = child.getChildCount();
                    } else if (child.getChildCount() != cols) {
                        throw new SemanticException("Tables with different or invalid number of keys in UNIQUEJOIN");
                    }
                    ArrayList<ASTNode> expressions = new ArrayList<ASTNode>();
                    ArrayList filt = new ArrayList();
                    ArrayList filters = new ArrayList();
                    for (Node exp : child.getChildren()) {
                        expressions.add((ASTNode)exp);
                    }
                    joinTree.getExpressions().add(expressions);
                    joinTree.getFilters().add(filt);
                    joinTree.getFiltersForPushing().add(filters);
                    continue block6;
                }
                case 270: {
                    lastPreserved = true;
                    continue block6;
                }
                case 1242: {
                    throw new SemanticException("Subqueries are not supported in UNIQUEJOIN");
                }
                default: {
                    throw new SemanticException("Unexpected UNIQUEJOIN structure");
                }
            }
        }
        joinTree.setBaseSrc(baseSrc.toArray(new String[0]));
        joinTree.setLeftAliases(leftAliases.toArray(new String[0]));
        joinTree.setRightAliases(rightAliases.toArray(new String[0]));
        JoinCond[] condn = new JoinCond[preserved.size()];
        for (int i = 0; i < condn.length; ++i) {
            condn[i] = new JoinCond((Boolean)preserved.get(i));
        }
        joinTree.setJoinCond(condn);
        if (qb.getParseInfo().getHints() != null && !this.conf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez")) {
            this.LOG.info("STREAMTABLE hint honored.");
            this.parseStreamTables(joinTree, qb);
        }
        return joinTree;
    }

    private QBJoinTree genSQJoinTree(QB qb, SubQueryUtils.ISubQueryJoinInfo subQuery, Operator joiningOp, Map<String, Operator> aliasToOpInfo) throws SemanticException {
        String[] children;
        QBJoinTree joinTree = new QBJoinTree();
        JoinCond[] condn = new JoinCond[1];
        switch (subQuery.getJoinType()) {
            case LEFTOUTER: {
                joinTree.setNoOuterJoin(false);
                condn[0] = new JoinCond(0, 1, JoinType.LEFTOUTER);
                break;
            }
            case RIGHTOUTER: {
                joinTree.setNoOuterJoin(false);
                condn[0] = new JoinCond(0, 1, JoinType.RIGHTOUTER);
                break;
            }
            case FULLOUTER: {
                joinTree.setNoOuterJoin(false);
                condn[0] = new JoinCond(0, 1, JoinType.FULLOUTER);
                break;
            }
            case LEFTSEMI: {
                joinTree.setNoSemiJoin(false);
                condn[0] = new JoinCond(0, 1, JoinType.LEFTSEMI);
                break;
            }
            case ANTI: {
                joinTree.setNoSemiJoin(false);
                condn[0] = new JoinCond(0, 1, JoinType.ANTI);
                break;
            }
            default: {
                condn[0] = new JoinCond(0, 1, JoinType.INNER);
                joinTree.setNoOuterJoin(true);
            }
        }
        joinTree.setJoinCond(condn);
        if (joiningOp instanceof JoinOperator) {
            QBJoinTree leftTree = this.joinContext.get(joiningOp);
            joinTree.setJoinSrc(leftTree);
            String[] leftChildAliases = leftTree.getLeftAliases();
            String[] leftAliases = new String[leftChildAliases.length + 1];
            for (int i = 0; i < leftChildAliases.length; ++i) {
                leftAliases[i] = leftChildAliases[i];
            }
            leftAliases[leftChildAliases.length] = leftTree.getRightAliases()[0];
            joinTree.setLeftAliases(leftAliases);
        } else {
            String alias = SemanticAnalyzer.unescapeIdentifier(SubQueryUtils.getAlias(joiningOp, aliasToOpInfo).toLowerCase());
            joinTree.setLeftAlias(alias);
            String[] leftAliases = new String[]{alias};
            joinTree.setLeftAliases(leftAliases);
            children = new String[2];
            children[0] = alias;
            joinTree.setBaseSrc(children);
            joinTree.setId(qb.getId());
            joinTree.getAliasToOpInfo().put(this.getModifiedAlias(qb, alias), aliasToOpInfo.get(alias));
        }
        String rightalias = SemanticAnalyzer.unescapeIdentifier(subQuery.getAlias().toLowerCase());
        String[] rightAliases = new String[]{rightalias};
        joinTree.setRightAliases(rightAliases);
        children = joinTree.getBaseSrc();
        if (children == null) {
            children = new String[2];
        }
        children[1] = rightalias;
        joinTree.setBaseSrc(children);
        joinTree.setId(qb.getId());
        joinTree.getAliasToOpInfo().put(this.getModifiedAlias(qb, rightalias), aliasToOpInfo.get(rightalias));
        if (!joinTree.getNoSemiJoin()) {
            joinTree.addRHSSemijoin(rightalias);
        }
        ArrayList<List<ASTNode>> expressions = new ArrayList<List<ASTNode>>();
        expressions.add(new ArrayList());
        expressions.add(new ArrayList());
        joinTree.setExpressions(expressions);
        ArrayList<Boolean> nullsafes = new ArrayList<Boolean>();
        joinTree.setNullSafes(nullsafes);
        ArrayList<List<ASTNode>> filters = new ArrayList<List<ASTNode>>();
        filters.add(new ArrayList());
        filters.add(new ArrayList());
        joinTree.setFilters(filters);
        joinTree.setFilterMap(new int[2][]);
        ArrayList<List<ASTNode>> filtersForPushing = new ArrayList<List<ASTNode>>();
        filtersForPushing.add(new ArrayList());
        filtersForPushing.add(new ArrayList());
        joinTree.setFiltersForPushing(filtersForPushing);
        ASTNode joinCond = subQuery.getJoinConditionAST();
        ArrayList<String> leftSrc = new ArrayList<String>();
        this.parseJoinCondition(joinTree, joinCond, leftSrc, aliasToOpInfo);
        if (leftSrc.size() == 1) {
            joinTree.setLeftAlias((String)leftSrc.get(0));
        }
        return joinTree;
    }

    private QBJoinTree genJoinTree(QB qb, ASTNode joinParseTree, Map<String, Operator> aliasToOpInfo) throws SemanticException {
        String[] children;
        String alias;
        boolean isJoinRightToken;
        boolean isValidLeftToken;
        QBJoinTree joinTree = new QBJoinTree();
        JoinCond[] condn = new JoinCond[1];
        switch (joinParseTree.getToken().getType()) {
            case 1082: {
                joinTree.setNoOuterJoin(false);
                condn[0] = new JoinCond(0, 1, JoinType.LEFTOUTER);
                break;
            }
            case 1189: {
                joinTree.setNoOuterJoin(false);
                condn[0] = new JoinCond(0, 1, JoinType.RIGHTOUTER);
                break;
            }
            case 1038: {
                joinTree.setNoOuterJoin(false);
                condn[0] = new JoinCond(0, 1, JoinType.FULLOUTER);
                break;
            }
            case 1083: {
                joinTree.setNoSemiJoin(false);
                condn[0] = new JoinCond(0, 1, JoinType.LEFTSEMI);
                break;
            }
            case 1081: {
                joinTree.setNoSemiJoin(false);
                condn[0] = new JoinCond(0, 1, JoinType.ANTI);
                break;
            }
            default: {
                condn[0] = new JoinCond(0, 1, JoinType.INNER);
                joinTree.setNoOuterJoin(true);
            }
        }
        joinTree.setJoinCond(condn);
        ASTNode left = (ASTNode)joinParseTree.getChild(0);
        ASTNode right = (ASTNode)joinParseTree.getChild(1);
        if (joinParseTree.getChildren().size() >= 4) {
            this.addPkFkInfo(joinTree, (ASTNode)joinParseTree.getChild(3));
        }
        boolean isJoinLeftToken = !(isValidLeftToken = this.isValidJoinSide(left)) && SemanticAnalyzer.isJoinToken(left);
        boolean isValidRightToken = this.isValidJoinSide(right);
        boolean bl = isJoinRightToken = !isValidRightToken && SemanticAnalyzer.isJoinToken(right);
        if (!isValidLeftToken && !isJoinLeftToken) {
            throw new SemanticException("Invalid token on the left side of the join: " + left.getToken().getText() + "; please rewrite your query");
        }
        if (!isValidRightToken) {
            String advice = "";
            if (isJoinRightToken && !isJoinLeftToken) {
                advice = "; for example, put the nested join on the left side, or nest joins differently";
            } else if (isJoinRightToken) {
                advice = "; for example, nest joins differently";
            }
            throw new SemanticException("Invalid token on the right side of the join: " + right.getToken().getText() + "; please rewrite your query" + advice);
        }
        if (isValidLeftToken) {
            alias = this.extractJoinAlias(left);
            joinTree.setLeftAlias(alias);
            String[] leftAliases = new String[]{alias};
            joinTree.setLeftAliases(leftAliases);
            children = new String[2];
            children[0] = alias;
            joinTree.setBaseSrc(children);
            joinTree.setId(qb.getId());
            joinTree.getAliasToOpInfo().put(this.getModifiedAlias(qb, alias), aliasToOpInfo.get(alias));
        } else if (isJoinLeftToken) {
            QBJoinTree leftTree = this.genJoinTree(qb, left, aliasToOpInfo);
            joinTree.setJoinSrc(leftTree);
            String[] leftChildAliases = leftTree.getLeftAliases();
            String[] leftAliases = new String[leftChildAliases.length + 1];
            for (int i = 0; i < leftChildAliases.length; ++i) {
                leftAliases[i] = leftChildAliases[i];
            }
            leftAliases[leftChildAliases.length] = leftTree.getRightAliases()[0];
            joinTree.setLeftAliases(leftAliases);
        } else assert (false);
        if (isValidRightToken) {
            alias = this.extractJoinAlias(right);
            String[] rightAliases = new String[]{alias};
            joinTree.setRightAliases(rightAliases);
            children = joinTree.getBaseSrc();
            if (children == null) {
                children = new String[2];
            }
            children[1] = alias;
            joinTree.setBaseSrc(children);
            joinTree.setId(qb.getId());
            joinTree.getAliasToOpInfo().put(this.getModifiedAlias(qb, alias), aliasToOpInfo.get(alias));
            if (!joinTree.getNoSemiJoin()) {
                joinTree.addRHSSemijoin(alias);
            }
        } else assert (false);
        ArrayList<List<ASTNode>> expressions = new ArrayList<List<ASTNode>>();
        expressions.add(new ArrayList());
        expressions.add(new ArrayList());
        joinTree.setExpressions(expressions);
        ArrayList<Boolean> nullsafes = new ArrayList<Boolean>();
        joinTree.setNullSafes(nullsafes);
        ArrayList<List<ASTNode>> filters = new ArrayList<List<ASTNode>>();
        filters.add(new ArrayList());
        filters.add(new ArrayList());
        joinTree.setFilters(filters);
        joinTree.setFilterMap(new int[2][]);
        ArrayList<List<ASTNode>> filtersForPushing = new ArrayList<List<ASTNode>>();
        filtersForPushing.add(new ArrayList());
        filtersForPushing.add(new ArrayList());
        joinTree.setFiltersForPushing(filtersForPushing);
        ASTNode joinCond = (ASTNode)joinParseTree.getChild(2);
        ArrayList<String> leftSrc = new ArrayList<String>();
        this.parseJoinCondition(joinTree, joinCond, leftSrc, aliasToOpInfo);
        if (leftSrc.size() == 1) {
            joinTree.setLeftAlias((String)leftSrc.get(0));
        }
        if (qb.getParseInfo().getHints() != null) {
            List<String> mapSideTables = this.getMapSideJoinTables(qb);
            List<String> mapAliases = joinTree.getMapAliases();
            for (String mapTbl : mapSideTables) {
                boolean mapTable = false;
                for (String leftAlias : joinTree.getLeftAliases()) {
                    if (!mapTbl.equalsIgnoreCase(leftAlias)) continue;
                    mapTable = true;
                }
                for (String rightAlias : joinTree.getRightAliases()) {
                    if (!mapTbl.equalsIgnoreCase(rightAlias)) continue;
                    mapTable = true;
                }
                if (!mapTable) continue;
                if (mapAliases == null) {
                    mapAliases = new ArrayList<String>();
                }
                mapAliases.add(mapTbl);
                joinTree.setMapSideJoin(true);
            }
            joinTree.setMapAliases(mapAliases);
            if (!this.conf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("tez")) {
                this.parseStreamTables(joinTree, qb);
            }
        }
        return joinTree;
    }

    private void addPkFkInfo(QBJoinTree joinTree, ASTNode hints) {
        Tree hint;
        if (hints.getToken().getType() == 445 && (hint = hints.getChild(0)).getType() == 443 && hint.getChild(0).getType() == 449) {
            Tree args = hint.getChild(1);
            joinTree.setFkJoinTableIndex(Integer.parseInt(args.getChild(0).getText()));
            joinTree.setNonFkSideIsFiltered("NON_FK_FILTERED".equals(args.getChild(1).getText()));
        }
    }

    private boolean isValidJoinSide(ASTNode right) {
        return right.getToken().getType() == 1280 || right.getToken().getType() == 1242 || right.getToken().getType() == 1159;
    }

    private String extractJoinAlias(ASTNode node) throws SemanticException {
        if (node.getType() == 1159) {
            return SemanticAnalyzer.unescapeIdentifier(node.getChild(1).getText().toLowerCase());
        }
        if (node.getChildCount() == 1) {
            return SemanticAnalyzer.getUnescapedUnqualifiedTableName((ASTNode)node.getChild(0)).toLowerCase();
        }
        for (int i = node.getChildCount() - 1; i >= 1; --i) {
            if (node.getChild(i).getType() != 24) continue;
            return SemanticAnalyzer.unescapeIdentifier(node.getChild(i).getText().toLowerCase());
        }
        throw new SemanticException("Unable to get join alias.");
    }

    private void parseStreamTables(QBJoinTree joinTree, QB qb) {
        List<String> streamAliases = joinTree.getStreamAliases();
        for (Node hintNode : qb.getParseInfo().getHints().getChildren()) {
            ASTNode hint = (ASTNode)hintNode;
            if (hint.getChild(0).getType() != 450) continue;
            for (int i = 0; i < hint.getChild(1).getChildCount(); ++i) {
                if (streamAliases == null) {
                    streamAliases = new ArrayList<String>();
                }
                streamAliases.add(hint.getChild(1).getChild(i).getText());
            }
        }
        joinTree.setStreamAliases(streamAliases);
    }

    private Map<String, List<SemiJoinHint>> parseSemiJoinHint(List<ASTNode> hints) throws SemanticException {
        if (hints == null || hints.size() == 0) {
            return null;
        }
        HashMap<String, List<SemiJoinHint>> result = null;
        for (ASTNode hintNode : hints) {
            for (Node node : hintNode.getChildren()) {
                String text;
                Tree args;
                ASTNode hint = (ASTNode)node;
                if (hint.getChild(0).getType() != 447 && hint.getChild(0).getType() != 446) continue;
                if (result == null) {
                    result = new HashMap<String, List<SemiJoinHint>>();
                }
                if ((args = hint.getChild(1)).getChildCount() == 1 && (text = args.getChild(0).getText()).equalsIgnoreCase("None")) {
                    return result;
                }
                int curIdx = 0;
                while (curIdx < args.getChildCount()) {
                    curIdx = this.parseSingleSemiJoinHint(args, curIdx, result);
                }
            }
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Semijoin hint parsed: " + String.valueOf(result));
        }
        return result;
    }

    private int parseSingleSemiJoinHint(Tree args, int curIdx, Map<String, List<SemiJoinHint>> result) throws SemanticException {
        String target;
        String colName;
        String source;
        int numEntriesLeft = args.getChildCount() - curIdx;
        if (numEntriesLeft < 3) {
            throw new SemanticException("User provided only 1 entry for the hint with alias " + args.getChild(curIdx).getText());
        }
        if (StringUtils.isNumeric((CharSequence)(source = args.getChild(curIdx++).getText()))) {
            throw new SemanticException("User provided bloom filter entries when source alias is expected. source:" + source);
        }
        if (StringUtils.isNumeric((CharSequence)(colName = args.getChild(curIdx++).getText()))) {
            throw new SemanticException("User provided bloom filter entries when column name is expected. colName:" + colName);
        }
        if (StringUtils.isNumeric((CharSequence)(target = args.getChild(curIdx++).getText()))) {
            throw new SemanticException("User provided bloom filter entries when target alias is expected. target: " + target);
        }
        Integer number = null;
        if (numEntriesLeft > 3) {
            try {
                number = Integer.parseInt(args.getChild(curIdx).getText());
                ++curIdx;
            }
            catch (NumberFormatException e) {
                this.LOG.warn("Number format exception when parsing " + number, (Throwable)e);
            }
        }
        result.computeIfAbsent(source, value -> new ArrayList()).add(new SemiJoinHint(colName, target, number));
        return curIdx;
    }

    private boolean disableMapJoinWithHint(List<ASTNode> hints) {
        if (hints == null || hints.size() == 0) {
            return false;
        }
        for (ASTNode hintNode : hints) {
            for (Node node : hintNode.getChildren()) {
                String text;
                Tree args;
                ASTNode hint = (ASTNode)node;
                if (hint.getChild(0).getType() != 448 || (args = hint.getChild(1)).getChildCount() != 1 || !(text = args.getChild(0).getText()).equalsIgnoreCase("None")) continue;
                return true;
            }
        }
        return false;
    }

    private void mergeJoins(QBJoinTree node, QBJoinTree target, int pos, int[] tgtToNodeExprMap) {
        int i;
        int i2;
        int i3;
        String[] nodeRightAliases = node.getRightAliases();
        String[] trgtRightAliases = target.getRightAliases();
        String[] rightAliases = new String[nodeRightAliases.length + trgtRightAliases.length];
        for (i3 = 0; i3 < trgtRightAliases.length; ++i3) {
            rightAliases[i3] = trgtRightAliases[i3];
        }
        for (i3 = 0; i3 < nodeRightAliases.length; ++i3) {
            rightAliases[i3 + trgtRightAliases.length] = nodeRightAliases[i3];
        }
        target.setRightAliases(rightAliases);
        target.getAliasToOpInfo().putAll(node.getAliasToOpInfo());
        String[] nodeBaseSrc = node.getBaseSrc();
        String[] trgtBaseSrc = target.getBaseSrc();
        String[] baseSrc = new String[nodeBaseSrc.length + trgtBaseSrc.length - 1];
        for (i2 = 0; i2 < trgtBaseSrc.length; ++i2) {
            baseSrc[i2] = trgtBaseSrc[i2];
        }
        for (i2 = 1; i2 < nodeBaseSrc.length; ++i2) {
            baseSrc[i2 + trgtBaseSrc.length - 1] = nodeBaseSrc[i2];
        }
        target.setBaseSrc(baseSrc);
        List<List<ASTNode>> expr = target.getExpressions();
        for (int i4 = 0; i4 < nodeRightAliases.length; ++i4) {
            List<ASTNode> nodeConds = node.getExpressions().get(i4 + 1);
            ArrayList<ASTNode> reordereNodeConds = new ArrayList<ASTNode>();
            for (int k = 0; k < tgtToNodeExprMap.length; ++k) {
                reordereNodeConds.add(nodeConds.get(tgtToNodeExprMap[k]));
            }
            expr.add(reordereNodeConds);
        }
        List<Boolean> nns = node.getNullSafes();
        List<Boolean> tns = target.getNullSafes();
        for (int i5 = 0; i5 < tns.size(); ++i5) {
            tns.set(i5, tns.get(i5) & nns.get(i5));
        }
        List<List<ASTNode>> filters = target.getFilters();
        for (int i6 = 0; i6 < nodeRightAliases.length; ++i6) {
            filters.add(node.getFilters().get(i6 + 1));
        }
        if (node.getFilters().get(0).size() != 0) {
            List<ASTNode> filterPos = filters.get(pos);
            filterPos.addAll((Collection<ASTNode>)node.getFilters().get(0));
        }
        int[][] nmap = node.getFilterMap();
        int[][] tmap = target.getFilterMap();
        int[][] newmap = new int[tmap.length + nmap.length - 1][];
        for (int[] mapping : nmap) {
            if (mapping == null) continue;
            for (int i7 = 0; i7 < mapping.length; i7 += 2) {
                if (pos <= 0 && mapping[i7] <= 0) continue;
                int n = i7;
                mapping[n] = mapping[n] + trgtRightAliases.length;
            }
        }
        if (nmap[0] != null) {
            if (tmap[pos] == null) {
                tmap[pos] = nmap[0];
            } else {
                int[] appended = new int[tmap[pos].length + nmap[0].length];
                System.arraycopy(tmap[pos], 0, appended, 0, tmap[pos].length);
                System.arraycopy(nmap[0], 0, appended, tmap[pos].length, nmap[0].length);
                tmap[pos] = appended;
            }
        }
        System.arraycopy(tmap, 0, newmap, 0, tmap.length);
        System.arraycopy(nmap, 1, newmap, tmap.length, nmap.length - 1);
        target.setFilterMap(newmap);
        List<List<ASTNode>> filter = target.getFiltersForPushing();
        for (int i8 = 0; i8 < nodeRightAliases.length; ++i8) {
            filter.add(node.getFiltersForPushing().get(i8 + 1));
        }
        if (node.getFiltersForPushing().get(0).size() != 0) {
            for (ASTNode nodeFilter : node.getFiltersForPushing().get(0)) {
                int fPos = ParseUtils.checkJoinFilterRefersOneAlias(target.getBaseSrc(), nodeFilter);
                if (fPos != -1) {
                    filter.get(fPos).add(nodeFilter);
                    continue;
                }
                target.addPostJoinFilter(nodeFilter);
            }
        }
        target.setNoOuterJoin(node.getNoOuterJoin() && target.getNoOuterJoin());
        target.setNoSemiJoin(node.getNoSemiJoin() && target.getNoSemiJoin());
        target.mergeRHSSemijoin(node);
        JoinCond[] nodeCondns = node.getJoinCond();
        int nodeCondnsSize = nodeCondns.length;
        JoinCond[] targetCondns = target.getJoinCond();
        int targetCondnsSize = targetCondns.length;
        JoinCond[] newCondns = new JoinCond[nodeCondnsSize + targetCondnsSize];
        for (i = 0; i < targetCondnsSize; ++i) {
            newCondns[i] = targetCondns[i];
        }
        for (i = 0; i < nodeCondnsSize; ++i) {
            JoinCond nodeCondn = nodeCondns[i];
            if (nodeCondn.getLeft() == 0) {
                nodeCondn.setLeft(pos);
            } else {
                nodeCondn.setLeft(nodeCondn.getLeft() + targetCondnsSize);
            }
            nodeCondn.setRight(nodeCondn.getRight() + targetCondnsSize);
            newCondns[targetCondnsSize + i] = nodeCondn;
        }
        target.setJoinCond(newCondns);
        if (target.isMapSideJoin()) {
            assert (node.isMapSideJoin());
            List<String> mapAliases = target.getMapAliases();
            for (String mapTbl : node.getMapAliases()) {
                if (mapAliases.contains(mapTbl)) continue;
                mapAliases.add(mapTbl);
            }
            target.setMapAliases(mapAliases);
        }
        if (node.getPostJoinFilters().size() != 0) {
            assert (node.getNoOuterJoin());
            assert (target.getPostJoinFilters().size() == 0 || target.getNoOuterJoin());
            for (ASTNode exprPostFilter : node.getPostJoinFilters()) {
                target.addPostJoinFilter(exprPostFilter);
            }
        }
    }

    private Pair<Integer, int[]> findMergePos(QBJoinTree node, QBJoinTree target) {
        int j;
        int res = -1;
        String leftAlias = node.getLeftAlias();
        if (!(leftAlias != null || node.getNoOuterJoin() && target.getNoOuterJoin())) {
            return Pair.of((Object)-1, null);
        }
        List<ASTNode> nodeCondn = node.getExpressions().get(0);
        List<ASTNode> targetCondn = null;
        if (leftAlias == null || leftAlias.equals(target.getLeftAlias())) {
            targetCondn = target.getExpressions().get(0);
            res = 0;
        } else {
            for (int i = 0; i < target.getRightAliases().length; ++i) {
                if (!leftAlias.equals(target.getRightAliases()[i])) continue;
                targetCondn = target.getExpressions().get(i + 1);
                res = i + 1;
                break;
            }
        }
        if (targetCondn == null || nodeCondn.size() != targetCondn.size()) {
            return Pair.of((Object)-1, null);
        }
        int[] tgtToNodeExprMap = new int[targetCondn.size()];
        boolean[] nodeFiltersMapped = new boolean[nodeCondn.size()];
        for (int i = 0; i < targetCondn.size(); ++i) {
            String tgtExprTree = targetCondn.get(i).toStringTree();
            tgtToNodeExprMap[i] = -1;
            for (j = 0; j < nodeCondn.size(); ++j) {
                if (!nodeCondn.get(j).toStringTree().equals(tgtExprTree)) continue;
                tgtToNodeExprMap[i] = j;
                nodeFiltersMapped[j] = true;
            }
            if (tgtToNodeExprMap[i] != -1) continue;
            return Pair.of((Object)-1, null);
        }
        for (j = 0; j < nodeCondn.size(); ++j) {
            if (nodeFiltersMapped[j]) continue;
            return Pair.of((Object)-1, null);
        }
        return Pair.of((Object)res, (Object)tgtToNodeExprMap);
    }

    boolean isCBOExecuted() {
        return false;
    }

    boolean isCBOSupportedLateralView(ASTNode lateralView) {
        return false;
    }

    boolean continueJoinMerge() {
        return true;
    }

    private boolean shouldMerge(QBJoinTree node, QBJoinTree target) {
        boolean isNodeOuterJoin = false;
        boolean isNodeSemiJoin = false;
        boolean hasNodePostJoinFilters = false;
        boolean isTargetOuterJoin = false;
        boolean isTargetSemiJoin = false;
        boolean hasTargetPostJoinFilters = false;
        isNodeOuterJoin = !node.getNoOuterJoin();
        isNodeSemiJoin = !node.getNoSemiJoin();
        hasNodePostJoinFilters = node.getPostJoinFilters().size() != 0;
        isTargetOuterJoin = !target.getNoOuterJoin();
        isTargetSemiJoin = !target.getNoSemiJoin();
        boolean bl = hasTargetPostJoinFilters = target.getPostJoinFilters().size() != 0;
        return !hasNodePostJoinFilters && !hasTargetPostJoinFilters || !isNodeOuterJoin && !isNodeSemiJoin && !isTargetOuterJoin && !isTargetSemiJoin;
    }

    private void mergeJoinTree(QB qb) {
        QBJoinTree tree = qb.getQbJoinTree();
        if (tree.getJoinSrc() == null) {
            return;
        }
        ArrayList<QBJoinTree> trees = new ArrayList<QBJoinTree>();
        while (tree != null) {
            trees.add(tree);
            tree = tree.getJoinSrc();
        }
        boolean mergedQBJTree = false;
        block1: for (int i = trees.size() - 1; i >= 0; --i) {
            QBJoinTree target = (QBJoinTree)trees.get(i);
            if (target == null) continue;
            JoinType prevType = null;
            boolean continueScanning = true;
            for (int j = i - 1; j >= 0 && continueScanning; --j) {
                QBJoinTree node = (QBJoinTree)trees.get(j);
                if (node == null) continue;
                JoinType currType = this.getType(node.getJoinCond());
                if (prevType != null && prevType != currType || !this.shouldMerge(node, target)) continue block1;
                Pair<Integer, int[]> mergeDetails = this.findMergePos(node, target);
                int pos = (Integer)mergeDetails.getLeft();
                if (pos >= 0) {
                    if (!(node.getNoOuterJoin() && target.getNoOuterJoin() || node.getRightAliases().length + target.getRightAliases().length + 1 <= 16)) {
                        this.LOG.info(ErrorMsg.JOINNODE_OUTERJOIN_MORETHAN_16.getErrorCodedMsg());
                        continueScanning = this.continueJoinMerge();
                        continue;
                    }
                    this.mergeJoins(node, target, pos, (int[])mergeDetails.getRight());
                    trees.set(j, null);
                    mergedQBJTree = true;
                    continue;
                }
                continueScanning = this.continueJoinMerge();
                if (prevType != null) continue;
                prevType = currType;
            }
        }
        if (trees.size() > 1 && mergedQBJTree) {
            QBJoinTree curQBJTree = null;
            QBJoinTree prevQBJTree = null;
            for (int i = trees.size() - 1; i >= 0; --i) {
                curQBJTree = (QBJoinTree)trees.get(i);
                if (curQBJTree == null) continue;
                if (prevQBJTree != null) {
                    ArrayList<String> newCurLeftAliases = new ArrayList<String>();
                    newCurLeftAliases.addAll(Arrays.asList(prevQBJTree.getLeftAliases()));
                    newCurLeftAliases.addAll(Arrays.asList(prevQBJTree.getRightAliases()));
                    curQBJTree.setLeftAliases(newCurLeftAliases.toArray(new String[newCurLeftAliases.size()]));
                }
                prevQBJTree = curQBJTree;
            }
        }
        QBJoinTree current = null;
        for (QBJoinTree target : trees) {
            if (target == null) continue;
            if (current == null) {
                current = target;
                qb.setQbJoinTree(current);
                continue;
            }
            current.setJoinSrc(target);
            current = target;
        }
    }

    private JoinType getType(JoinCond[] conds) {
        JoinType type = conds[0].getJoinType();
        return Arrays.stream(conds).allMatch(cond -> cond.getJoinType() == type) ? type : null;
    }

    private Operator genSelectAllDesc(Operator input) {
        OpParseContext inputCtx = this.opParseCtx.get(input);
        RowResolver inputRR = inputCtx.getRowResolver();
        List<ColumnInfo> columns = inputRR.getColumnInfos();
        ArrayList<ExprNodeDesc> colList = new ArrayList<ExprNodeDesc>();
        ArrayList<String> columnNames = new ArrayList<String>();
        HashMap<String, ExprNodeDesc> columnExprMap = new HashMap<String, ExprNodeDesc>();
        for (ColumnInfo col : columns) {
            colList.add(new ExprNodeColumnDesc(col, true));
            columnNames.add(col.getInternalName());
            columnExprMap.put(col.getInternalName(), new ExprNodeColumnDesc(col, true));
        }
        RowResolver outputRR = inputRR.duplicate();
        Operator<SelectDesc> output = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new SelectDesc(colList, columnNames, true), outputRR.getRowSchema(), input, new Operator[0]), outputRR);
        output.setColumnExprMap(columnExprMap);
        return output;
    }

    private List<List<String>> getCommonGroupByDestGroups(QB qb, Map<String, Operator<? extends OperatorDesc>> inputs) throws SemanticException {
        QBParseInfo qbp = qb.getParseInfo();
        TreeSet<String> ks = new TreeSet<String>(qbp.getClauseNames());
        ArrayList<List<String>> commonGroupByDestGroups = new ArrayList<List<String>>();
        if (ks.isEmpty()) {
            commonGroupByDestGroups.add(Collections.emptyList());
            return commonGroupByDestGroups;
        }
        if (ks.size() == 1) {
            commonGroupByDestGroups.add(Collections.singletonList((String)ks.iterator().next()));
            return commonGroupByDestGroups;
        }
        ArrayList<Operator<? extends OperatorDesc>> inputOperators = new ArrayList<Operator<? extends OperatorDesc>>(ks.size());
        ArrayList<List<ExprNodeDesc>> newSprayKeyLists = new ArrayList<List<ExprNodeDesc>>(ks.size());
        ArrayList<List<ExprNodeDesc>> newDistinctKeyLists = new ArrayList<List<ExprNodeDesc>>(ks.size());
        for (String dest : ks) {
            Operator<? extends OperatorDesc> input = inputs.get(dest);
            RowResolver inputRR = this.opParseCtx.get(input).getRowResolver();
            List<ExprNodeDesc> currentDistinctKeys = this.getDistinctExprs(qbp, dest, inputRR);
            List<ExprNodeDesc> currentSprayKeys = this.determineSprayKeys(qbp, dest, inputRR);
            boolean found = false;
            for (int i = 0; i < newSprayKeyLists.size(); ++i) {
                if (!input.equals(inputOperators.get(i))) continue;
                List targetSprayKeys = (List)newSprayKeyLists.get(i);
                List targetDistinctKeys = (List)newDistinctKeyLists.get(i);
                if (currentDistinctKeys.isEmpty() != targetDistinctKeys.isEmpty()) continue;
                if (currentDistinctKeys.isEmpty()) {
                    combinedList = this.combineExprNodeLists(targetSprayKeys, targetDistinctKeys);
                    if (!this.matchExprLists(combinedList, currentSprayKeys)) {
                        continue;
                    }
                } else {
                    if (targetDistinctKeys.isEmpty()) {
                        combinedList = this.combineExprNodeLists(currentSprayKeys, currentDistinctKeys);
                        if (!this.matchExprLists(combinedList, targetSprayKeys)) continue;
                        newDistinctKeyLists.remove(i);
                        newSprayKeyLists.remove(i);
                        newDistinctKeyLists.add(i, currentDistinctKeys);
                        newSprayKeyLists.add(i, currentSprayKeys);
                        ((List)commonGroupByDestGroups.get(i)).add(0, dest);
                        found = true;
                        break;
                    }
                    if (!this.matchExprLists(targetDistinctKeys, currentDistinctKeys) || !this.matchExprLists(targetSprayKeys, currentSprayKeys)) continue;
                }
                ((List)commonGroupByDestGroups.get(i)).add(dest);
                found = true;
                break;
            }
            if (found) continue;
            inputOperators.add(input);
            newSprayKeyLists.add(currentSprayKeys);
            newDistinctKeyLists.add(currentDistinctKeys);
            ArrayList<String> destGroup = new ArrayList<String>();
            destGroup.add(dest);
            commonGroupByDestGroups.add(destGroup);
        }
        return commonGroupByDestGroups;
    }

    private List<ExprNodeDesc> determineSprayKeys(QBParseInfo qbp, String dest, RowResolver inputRR) throws SemanticException {
        ArrayList<ExprNodeDesc> sprayKeys = new ArrayList<ExprNodeDesc>();
        List<ASTNode> grpByExprs = this.getGroupByForClause(qbp, dest);
        for (ASTNode grpByExpr : grpByExprs) {
            ExprNodeDesc exprDesc = this.genExprNodeDesc(grpByExpr, inputRR);
            if (ExprNodeDescUtils.indexOf(exprDesc, sprayKeys) >= 0) continue;
            sprayKeys.add(exprDesc);
        }
        return sprayKeys;
    }

    private List<ExprNodeDesc> combineExprNodeLists(List<ExprNodeDesc> list, List<ExprNodeDesc> list2) {
        ArrayList<ExprNodeDesc> result = new ArrayList<ExprNodeDesc>(list);
        for (ExprNodeDesc elem : list2) {
            if (result.contains(elem)) continue;
            result.add(elem);
        }
        return result;
    }

    private boolean matchExprLists(List<ExprNodeDesc> list1, List<ExprNodeDesc> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        for (ExprNodeDesc exprNodeDesc : list1) {
            if (ExprNodeDescUtils.indexOf(exprNodeDesc, list2) >= 0) continue;
            return false;
        }
        return true;
    }

    private List<ExprNodeDesc> getDistinctExprs(QBParseInfo qbp, String dest, RowResolver inputRR) throws SemanticException {
        List<ASTNode> distinctAggExprs = qbp.getDistinctFuncExprsForClause(dest);
        ArrayList<ExprNodeDesc> distinctExprs = new ArrayList<ExprNodeDesc>();
        for (ASTNode distinctAggExpr : distinctAggExprs) {
            for (int i = 1; i < distinctAggExpr.getChildCount(); ++i) {
                ASTNode parameter = (ASTNode)distinctAggExpr.getChild(i);
                ExprNodeDesc expr = this.genExprNodeDesc(parameter, inputRR);
                if (ExprNodeDescUtils.indexOf(expr, distinctExprs) >= 0) continue;
                distinctExprs.add(expr);
            }
        }
        return distinctExprs;
    }

    private Operator genBodyPlan(QB qb, Operator input, Map<String, Operator> aliasToOpInfo) throws SemanticException {
        QBParseInfo qbp = qb.getParseInfo();
        TreeSet<String> ks = new TreeSet<String>(qbp.getClauseNames());
        Map<String, Operator<? extends OperatorDesc>> inputs = this.createInputForDests(qb, input, ks);
        Operator curr = input;
        List<List<String>> commonGroupByDestGroups = null;
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_MULTI_GROUPBY_SINGLE_REDUCER)) {
            try {
                commonGroupByDestGroups = this.getCommonGroupByDestGroups(qb, inputs);
            }
            catch (SemanticException e) {
                this.LOG.error("Failed to group clauses by common spray keys.", (Throwable)e);
            }
        }
        if (commonGroupByDestGroups == null) {
            commonGroupByDestGroups = Collections.singletonList(new ArrayList<String>(ks));
        }
        if (!commonGroupByDestGroups.isEmpty()) {
            for (List<String> commonGroupByDestGroup : commonGroupByDestGroups) {
                if (commonGroupByDestGroup.isEmpty()) continue;
                String firstDest = commonGroupByDestGroup.get(0);
                input = inputs.get(firstDest);
                if (commonGroupByDestGroup.size() == 1 || qbp.getAggregationExprsForClause(firstDest).size() == 0 && this.getGroupByForClause(qbp, firstDest).size() == 0 || this.conf.getBoolVar(HiveConf.ConfVars.HIVE_GROUPBY_SKEW) || !this.conf.getBoolVar(HiveConf.ConfVars.HIVE_MULTI_GROUPBY_SINGLE_REDUCER)) {
                    for (String dest : commonGroupByDestGroup) {
                        curr = inputs.get(dest);
                        if (qbp.getWhrForClause(dest) != null) {
                            ASTNode whereExpr = qb.getParseInfo().getWhrForClause(dest);
                            curr = this.genFilterPlan((ASTNode)whereExpr.getChild(0), qb, curr, aliasToOpInfo, false, false);
                        }
                        Operator gbySource = curr;
                        if (!(qbp.getAggregationExprsForClause(dest).size() == 0 && this.getGroupByForClause(qbp, dest).size() <= 0 || qbp.getSelForClause(dest).getToken().getType() == 1197 && qbp.getWindowingExprsForClause(dest) != null)) {
                            ASTNode node;
                            if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_GROUPBY_SKEW) && qbp.getDistinctFuncExprsForClause(dest).size() > 1) {
                                throw new SemanticException(ErrorMsg.UNSUPPORTED_MULTIPLE_DISTINCTS.getMsg());
                            }
                            curr = this.genSelectAllDesc(curr);
                            ASTNode selExprList = qbp.getSelForClause(dest);
                            if (selExprList.getToken().getType() == 1197 && selExprList.getChildCount() == 1 && selExprList.getChild(0).getChildCount() == 1 && (node = (ASTNode)selExprList.getChild(0).getChild(0)).getToken().getType() == 843) {
                                curr = this.genSelectPlan(dest, qb, curr, curr);
                                RowResolver rr = this.opParseCtx.get(curr).getRowResolver();
                                qbp.setSelExprForClause(dest, this.genSelectDIAST(rr));
                            }
                            curr = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_MAPSIDE_AGGREGATE) ? (!this.conf.getBoolVar(HiveConf.ConfVars.HIVE_GROUPBY_SKEW) ? this.genGroupByPlanMapAggrNoSkew(dest, qb, curr) : this.genGroupByPlanMapAggr2MR(dest, qb, curr)) : (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_GROUPBY_SKEW) ? this.genGroupByPlan2MR(dest, qb, curr) : this.genGroupByPlan1MR(dest, qb, curr));
                        }
                        if (this.LOG.isDebugEnabled()) {
                            this.LOG.debug("RR before GB " + String.valueOf(this.opParseCtx.get(gbySource).getRowResolver()) + " after GB " + String.valueOf(this.opParseCtx.get(curr).getRowResolver()));
                        }
                        curr = this.genPostGroupByBodyPlan(curr, dest, qb, aliasToOpInfo, gbySource);
                    }
                    continue;
                }
                curr = this.genGroupByPlan1ReduceMultiGBY(commonGroupByDestGroup, qb, input, aliasToOpInfo);
            }
        }
        this.LOG.debug("Created Body Plan for Query Block {}", (Object)qb.getId());
        return curr;
    }

    private Map<String, Operator<? extends OperatorDesc>> createInputForDests(QB qb, Operator<? extends OperatorDesc> input, Set<String> dests) throws SemanticException {
        HashMap<String, Operator<? extends OperatorDesc>> inputs = new HashMap<String, Operator<? extends OperatorDesc>>();
        for (String dest : dests) {
            inputs.put(dest, this.genLateralViewPlanForDest(dest, qb, input));
        }
        return inputs;
    }

    private Operator genPostGroupByBodyPlan(Operator curr, String dest, QB qb, Map<String, Operator> aliasToOpInfo, Operator gbySource) throws SemanticException {
        QBParseInfo qbp = qb.getParseInfo();
        if (qbp.getHavingForClause(dest) != null) {
            if (this.getGroupByForClause(qbp, dest).size() == 0) {
                throw new SemanticException("HAVING specified without GROUP BY");
            }
            curr = this.genHavingPlan(dest, qb, curr, aliasToOpInfo);
        }
        if (this.queryProperties.hasWindowing() && qb.getWindowingSpec(dest) != null) {
            curr = this.genWindowingPlan(qb, qb.getWindowingSpec(dest), curr);
            if ((qbp.getAggregationExprsForClause(dest).size() != 0 || this.getGroupByForClause(qbp, dest).size() > 0) && qbp.getSelForClause(dest).getToken().getType() == 1197 && qbp.getWindowingExprsForClause(dest) != null) {
                curr = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_MAPSIDE_AGGREGATE) ? (!this.conf.getBoolVar(HiveConf.ConfVars.HIVE_GROUPBY_SKEW) ? this.genGroupByPlanMapAggrNoSkew(dest, qb, curr) : this.genGroupByPlanMapAggr2MR(dest, qb, curr)) : (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_GROUPBY_SKEW) ? this.genGroupByPlan2MR(dest, qb, curr) : this.genGroupByPlan1MR(dest, qb, curr));
            }
        }
        curr = this.genSelectPlan(dest, qb, curr, gbySource);
        Integer limit = qbp.getDestLimit(dest);
        int offset = qbp.getDestLimitOffset(dest) == null ? 0 : qbp.getDestLimitOffset(dest);
        boolean genReduceSink = false;
        int numReducers = -1;
        boolean hasOrderBy = false;
        if (qbp.getClusterByForClause(dest) != null) {
            genReduceSink = true;
        }
        if (qbp.getDistributeByForClause(dest) != null) {
            genReduceSink = true;
        }
        if (qbp.getOrderByForClause(dest) != null) {
            genReduceSink = true;
            numReducers = 1;
            hasOrderBy = true;
        }
        if (offset > 0 && !hasOrderBy) {
            HiveConf.StrictChecks.checkOffsetWithoutOrderBy((Configuration)this.conf);
            this.warn("OFFSET without ORDER BY is mostly non-deterministic and meaningless. Please make sure that you really don't need ORDER BY");
            assert (limit != null) : "OFFSET is always paired with LIMIT";
            genReduceSink = true;
            numReducers = 1;
            long offsetPlusLimit = (long)offset + (long)limit.intValue();
            if (offsetPlusLimit <= Integer.MAX_VALUE) {
                curr = this.genLimitPlan(dest, curr, 0, (int)offsetPlusLimit);
            }
        }
        if (qbp.getSortByForClause(dest) != null) {
            genReduceSink = true;
        }
        if (genReduceSink) {
            curr = this.genReduceSinkPlan(dest, qb, curr, numReducers, hasOrderBy);
        }
        if (qbp.getIsSubQ()) {
            if (limit != null) {
                boolean extraMRStep = limit != 0 && numReducers != 1;
                curr = this.genLimitMapRedPlan(dest, qb, curr, offset, limit, extraMRStep);
            }
        } else {
            if (limit != null) {
                boolean extraMRStep = true;
                if (limit == 0 || numReducers == 1 || qb.getIsQuery() && qbp.getClusterByForClause(dest) == null && qbp.getSortByForClause(dest) == null) {
                    extraMRStep = false;
                }
                curr = this.genLimitMapRedPlan(dest, qb, curr, offset, limit, extraMRStep);
                qb.getParseInfo().setOuterQueryLimit(limit);
            }
            if (!HiveOperation.CREATEVIEW.equals((Object)this.queryState.getHiveOperation())) {
                curr = this.genFileSinkPlan(dest, qb, curr);
            }
        }
        return curr;
    }

    private Operator genUnionPlan(String unionalias, String leftalias, Operator leftOp, String rightalias, Operator rightOp) throws SemanticException {
        UnionDesc uDesc;
        List<Operator<OperatorDesc>> parent;
        ArrayList<Operator<? extends OperatorDesc>> child;
        Operator<? extends OperatorDesc> oldChild;
        ASTNode tabref;
        RowResolver leftRR = this.opParseCtx.get(leftOp).getRowResolver();
        RowResolver rightRR = this.opParseCtx.get(rightOp).getRowResolver();
        Map<String, ColumnInfo> leftmap = leftRR.getFieldMap(leftalias);
        Map<String, ColumnInfo> rightmap = rightRR.getFieldMap(rightalias);
        ASTNode aSTNode = tabref = this.qb.getAliases().isEmpty() ? null : this.qb.getParseInfo().getSrcForAlias(this.qb.getAliases().get(0));
        if (leftmap.size() != rightmap.size()) {
            throw new SemanticException("Schema of both sides of union should match.");
        }
        RowResolver unionoutRR = new RowResolver();
        Iterator<Map.Entry<String, ColumnInfo>> lIter = leftmap.entrySet().iterator();
        Iterator<Map.Entry<String, ColumnInfo>> rIter = rightmap.entrySet().iterator();
        while (lIter.hasNext()) {
            Map.Entry<String, ColumnInfo> lEntry = lIter.next();
            Map.Entry<String, ColumnInfo> rEntry = rIter.next();
            ColumnInfo lInfo = lEntry.getValue();
            ColumnInfo rInfo = rEntry.getValue();
            String field = lEntry.getKey();
            TypeInfo commonTypeInfo = FunctionRegistry.getCommonClassForUnionAll(lInfo.getType(), rInfo.getType());
            if (commonTypeInfo == null) {
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage(tabref, "Schema of both sides of union should match: Column " + field + " is of type " + lInfo.getType().getTypeName() + " on first table and type " + rInfo.getType().getTypeName() + " on second table"));
            }
            ColumnInfo unionColInfo = new ColumnInfo(lInfo);
            unionColInfo.setType(commonTypeInfo);
            unionoutRR.put(unionalias, field, unionColInfo);
        }
        boolean isMR = HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE).equals("mr");
        if (!isMR || !(leftOp instanceof UnionOperator)) {
            leftOp = this.genInputSelectForUnion(leftOp, leftmap, leftalias, unionoutRR, unionalias);
        }
        if (!isMR || !(rightOp instanceof UnionOperator)) {
            rightOp = this.genInputSelectForUnion(rightOp, rightmap, rightalias, unionoutRR, unionalias);
        }
        if (leftOp instanceof UnionOperator || leftOp instanceof SelectOperator && leftOp.getParentOperators() != null && !leftOp.getParentOperators().isEmpty() && leftOp.getParentOperators().get(0) instanceof UnionOperator && ((SelectOperator)leftOp).isIdentitySelect()) {
            if (!(leftOp instanceof UnionOperator)) {
                oldChild = leftOp;
                leftOp = leftOp.getParentOperators().get(0);
                leftOp.removeChildAndAdoptItsChildren(oldChild);
            }
            child = new ArrayList<Operator<? extends OperatorDesc>>();
            child.add(leftOp);
            rightOp.setChildOperators(child);
            parent = leftOp.getParentOperators();
            parent.add(rightOp);
            uDesc = (UnionDesc)((UnionOperator)leftOp).getConf();
            uDesc.setNumInputs(uDesc.getNumInputs() + 1);
            return this.putOpInsertMap(leftOp, unionoutRR);
        }
        if (rightOp instanceof UnionOperator || rightOp instanceof SelectOperator && rightOp.getParentOperators() != null && !rightOp.getParentOperators().isEmpty() && rightOp.getParentOperators().get(0) instanceof UnionOperator && ((SelectOperator)rightOp).isIdentitySelect()) {
            if (!(rightOp instanceof UnionOperator)) {
                oldChild = rightOp;
                rightOp = rightOp.getParentOperators().get(0);
                rightOp.removeChildAndAdoptItsChildren(oldChild);
            }
            child = new ArrayList();
            child.add(rightOp);
            leftOp.setChildOperators(child);
            parent = rightOp.getParentOperators();
            parent.add(leftOp);
            uDesc = (UnionDesc)((UnionOperator)rightOp).getConf();
            uDesc.setNumInputs(uDesc.getNumInputs() + 1);
            return this.putOpInsertMap(rightOp, unionoutRR);
        }
        Operator<UnionDesc> unionforward = OperatorFactory.getAndMakeChild(this.getOpContext(), new UnionDesc(), new RowSchema(unionoutRR.getColumnInfos()));
        rightOp.setChildOperators(Lists.newArrayList((Object[])new Operator[]{unionforward}));
        leftOp.setChildOperators(Lists.newArrayList((Object[])new Operator[]{unionforward}));
        unionforward.setParentOperators(Lists.newArrayList((Object[])new Operator[]{leftOp, rightOp}));
        return this.putOpInsertMap(unionforward, unionoutRR);
    }

    private Operator<? extends OperatorDesc> genInputSelectForUnion(Operator<? extends OperatorDesc> origInputOp, Map<String, ColumnInfo> origInputFieldMap, String origInputAlias, RowResolver unionoutRR, String unionalias) throws SemanticException {
        Map<String, ColumnInfo> fieldMap = unionoutRR.getFieldMap(unionalias);
        Iterator<ColumnInfo> oIter = origInputFieldMap.values().iterator();
        Iterator<ColumnInfo> uIter = fieldMap.values().iterator();
        ArrayList<ExprNodeDesc> columns = new ArrayList<ExprNodeDesc>();
        boolean needsCast = false;
        while (oIter.hasNext()) {
            ColumnInfo oInfo = oIter.next();
            ColumnInfo uInfo = uIter.next();
            ExprNodeDesc column = new ExprNodeColumnDesc(oInfo.getType(), oInfo.getInternalName(), oInfo.getTabAlias(), oInfo.getIsVirtualCol(), oInfo.isSkewedCol());
            if (!oInfo.getType().equals((Object)uInfo.getType())) {
                needsCast = true;
                column = (ExprNodeDesc)ExprNodeTypeCheck.getExprNodeDefaultExprProcessor().createConversionCast(column, (PrimitiveTypeInfo)uInfo.getType());
            }
            columns.add(column);
        }
        if (!needsCast) {
            return origInputOp;
        }
        RowResolver rowResolver = new RowResolver();
        HashMap<String, ExprNodeDesc> columnExprMap = new HashMap<String, ExprNodeDesc>();
        ArrayList<String> colName = new ArrayList<String>();
        for (int i = 0; i < columns.size(); ++i) {
            String name = SemanticAnalyzer.getColumnInternalName(i);
            ColumnInfo col = new ColumnInfo(name, ((ExprNodeDesc)columns.get(i)).getTypeInfo(), "", false);
            rowResolver.put(origInputAlias, name, col);
            colName.add(name);
            columnExprMap.put(name, (ExprNodeDesc)columns.get(i));
        }
        Operator<SelectDesc> newInputOp = OperatorFactory.getAndMakeChild(new SelectDesc(columns, colName), new RowSchema(rowResolver.getColumnInfos()), columnExprMap, origInputOp, new Operator[0]);
        return this.putOpInsertMap(newInputOp, rowResolver);
    }

    private ExprNodeDesc genSamplePredicate(TableSample ts, List<String> bucketCols, boolean useBucketCols, String alias, RowResolver rwsch, ExprNodeDesc planExpr, int bucketingVersion) throws SemanticException {
        ExprNodeConstantDesc numeratorExpr = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.intTypeInfo, ts.getNumerator() - 1);
        ExprNodeConstantDesc denominatorExpr = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.intTypeInfo, ts.getDenominator());
        ExprNodeConstantDesc intMaxExpr = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.intTypeInfo, Integer.MAX_VALUE);
        ArrayList<ExprNodeDesc> args = new ArrayList<ExprNodeDesc>();
        if (planExpr != null) {
            args.add(planExpr);
        } else if (useBucketCols) {
            for (String col : bucketCols) {
                ColumnInfo ci = rwsch.get(alias, col);
                args.add(new ExprNodeColumnDesc(ci));
            }
        } else {
            for (ASTNode expr : ts.getExprs()) {
                args.add(this.genExprNodeDesc(expr, rwsch));
            }
        }
        ExprNodeDesc equalsExpr = null;
        ExprNodeGenericFuncDesc hashfnExpr = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.intTypeInfo, bucketingVersion == 2 ? new GenericUDFMurmurHash() : new GenericUDFHash(), args);
        this.LOG.info("hashfnExpr = " + String.valueOf(hashfnExpr));
        ExprNodeDesc andExpr = (ExprNodeDesc)ExprNodeTypeCheck.getExprNodeDefaultExprProcessor().getFuncExprNodeDesc("&", hashfnExpr, intMaxExpr);
        this.LOG.info("andExpr = " + String.valueOf(andExpr));
        ExprNodeDesc modExpr = (ExprNodeDesc)ExprNodeTypeCheck.getExprNodeDefaultExprProcessor().getFuncExprNodeDesc("%", andExpr, denominatorExpr);
        this.LOG.info("modExpr = " + String.valueOf(modExpr));
        this.LOG.info("numeratorExpr = " + String.valueOf(numeratorExpr));
        equalsExpr = (ExprNodeDesc)ExprNodeTypeCheck.getExprNodeDefaultExprProcessor().getFuncExprNodeDesc("==", modExpr, numeratorExpr);
        this.LOG.info("equalsExpr = " + String.valueOf(equalsExpr));
        return equalsExpr;
    }

    protected String getAliasId(String alias, QB qb) {
        return ((String)(qb.getId() == null ? alias : qb.getId() + ":" + alias)).toLowerCase();
    }

    private Operator genTablePlan(String alias, QB qb) throws SemanticException {
        RowResolver rwsch;
        String alias_id = this.getAliasId(alias, qb);
        org.apache.hadoop.hive.ql.metadata.Table tab = qb.getMetaData().getSrcForAlias(alias);
        TableScanOperator top = this.topOps.get(alias_id);
        Map<String, String> properties = qb.getTabPropsForAlias(alias);
        if (top == null) {
            SplitSample sample;
            rwsch = new RowResolver();
            try {
                if (properties != null) {
                    for (Map.Entry<String, String> prop : properties.entrySet()) {
                        if (tab.getSerdeParam(prop.getKey()) != null) {
                            this.LOG.warn("SerDe property in input query overrides stored SerDe property");
                        }
                        tab.setSerdeParam(prop.getKey(), prop.getValue());
                    }
                }
                Deserializer deserializer = tab.getDeserializer();
                StructObjectInspector rowObjectInspector = (StructObjectInspector)deserializer.getObjectInspector();
                deserializer.handleJobLevelConfiguration(this.conf);
                List fields = rowObjectInspector.getAllStructFieldRefs();
                HashSet partCols = tab.hasNonNativePartitionSupport() ? Sets.newHashSet(tab.getPartColNames()) : Collections.emptySet();
                for (int i = 0; i < fields.size(); ++i) {
                    ColumnInfo colInfo = new ColumnInfo(((StructField)fields.get(i)).getFieldName(), TypeInfoUtils.getTypeInfoFromObjectInspector((ObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()), alias, false);
                    if (partCols.contains(colInfo.getInternalName())) {
                        colInfo.setHiddenPartitionCol(true);
                    }
                    colInfo.setSkewedCol(this.isSkewedCol(alias, qb, ((StructField)fields.get(i)).getFieldName()));
                    rwsch.put(alias, ((StructField)fields.get(i)).getFieldName(), colInfo);
                }
            }
            catch (SerDeException e) {
                throw new RuntimeException(e);
            }
            for (FieldSchema part_col : tab.getPartCols()) {
                this.LOG.trace("Adding partition col: " + String.valueOf(part_col));
                rwsch.put(alias, part_col.getName(), new ColumnInfo(part_col.getName(), (TypeInfo)TypeInfoFactory.getPrimitiveTypeInfo((String)part_col.getType()), alias, true));
            }
            List<VirtualColumn> vcList = tab.getVirtualColumns();
            vcList.forEach(vc -> rwsch.put(alias, vc.getName().toLowerCase(), new ColumnInfo(vc.getName(), vc.getTypeInfo(), alias, true, vc.getIsHidden())));
            TableScanDesc tsDesc = new TableScanDesc(alias, vcList, tab);
            this.setupStats(tsDesc, qb.getParseInfo(), tab, alias, rwsch);
            Map<String, String> tblProperties = tab.getParameters();
            Map<String, String> tblPropertiesFromQuery = qb.getTabPropsForAlias(alias);
            AcidUtils.AcidOperationalProperties acidOperationalProperties = tsDesc.getAcidOperationalProperties();
            if (acidOperationalProperties != null) {
                tsDesc.getAcidOperationalProperties().setInsertOnlyFetchBucketId(tblProperties != null && Boolean.parseBoolean(tblProperties.get("insertonly.fetch.bucketid")) || tblPropertiesFromQuery != null && Boolean.parseBoolean(tblPropertiesFromQuery.get("insertonly.fetch.bucketid")));
                tsDesc.getAcidOperationalProperties().setFetchDeletedRows(tblProperties != null && Boolean.parseBoolean(tblProperties.get("acid.fetch.deleted.rows")) || tblPropertiesFromQuery != null && Boolean.parseBoolean(tblPropertiesFromQuery.get("acid.fetch.deleted.rows")));
            }
            if ((sample = this.nameToSplitSample.get(alias_id)) != null && sample.getRowCount() != null) {
                tsDesc.setRowLimit(sample.getRowCount());
                this.nameToSplitSample.remove(alias_id);
            }
            top = (TableScanOperator)this.putOpInsertMap(OperatorFactory.get(this.getOpContext(), tsDesc, new RowSchema(rwsch.getColumnInfos())), rwsch);
            top.setInsideView(qb.isInsideView() || qb.getAliasInsideView().contains(alias.toLowerCase()));
            this.topOps.put(alias_id, top);
            if (properties != null) {
                tsDesc.setOpProps(properties);
            }
        } else {
            rwsch = this.opParseCtx.get(top).getRowResolver();
            top.setChildOperators(null);
        }
        Operator op = top;
        TableSample ts = qb.getParseInfo().getTabSample(alias);
        if (ts != null) {
            TableScanOperator tableScanOp = top;
            ((TableScanDesc)tableScanOp.getConf()).setTableSample(ts);
            int num = ts.getNumerator();
            int den = ts.getDenominator();
            List<ASTNode> sampleExprs = ts.getExprs();
            List<String> tabBucketCols = tab.getBucketCols();
            int numBuckets = tab.getNumBuckets();
            if (tabBucketCols.size() == 0 && sampleExprs.size() == 0) {
                throw new SemanticException(ErrorMsg.NON_BUCKETED_TABLE.getMsg() + " " + tab.getTableName());
            }
            if (num > den) {
                throw new SemanticException(ErrorMsg.BUCKETED_NUMERATOR_BIGGER_DENOMINATOR.getMsg() + " " + tab.getTableName());
            }
            boolean colsEqual = true;
            if (sampleExprs.size() != tabBucketCols.size() && sampleExprs.size() != 0) {
                colsEqual = false;
            }
            for (int i = 0; i < sampleExprs.size() && colsEqual; ++i) {
                boolean colFound = false;
                for (int j = 0; j < tabBucketCols.size() && !colFound && sampleExprs.get(i).getToken().getType() == 1276; ++j) {
                    if (!sampleExprs.get(i).getChild(0).getText().equalsIgnoreCase(tabBucketCols.get(j))) continue;
                    colFound = true;
                }
                colsEqual = colFound;
            }
            ts.setInputPruning(sampleExprs.size() == 0 || colsEqual);
            if (!(sampleExprs.size() != 0 && !colsEqual || num != den && den % numBuckets != 0 && numBuckets % den != 0)) {
                this.LOG.info("No need for sample filter");
                ExprNodeDesc samplePredicate = this.genSamplePredicate(ts, tabBucketCols, colsEqual, alias, rwsch, null, tab.getBucketingVersion());
                FilterDesc filterDesc = new FilterDesc(samplePredicate, true, new FilterDesc.SampleDesc(ts.getNumerator(), ts.getDenominator(), tabBucketCols, true));
                filterDesc.setGenerated(true);
                op = OperatorFactory.getAndMakeChild(filterDesc, new RowSchema(rwsch.getColumnInfos()), (Operator)top, new Operator[0]);
            } else {
                this.LOG.info("Need sample filter");
                ExprNodeDesc samplePredicate = this.genSamplePredicate(ts, tabBucketCols, colsEqual, alias, rwsch, null, tab.getBucketingVersion());
                FilterDesc filterDesc = new FilterDesc(samplePredicate, true);
                filterDesc.setGenerated(true);
                op = OperatorFactory.getAndMakeChild(filterDesc, new RowSchema(rwsch.getColumnInfos()), (Operator)top, new Operator[0]);
            }
        } else {
            boolean testMode = this.conf.getBoolVar(HiveConf.ConfVars.HIVE_TEST_MODE);
            if (testMode) {
                String tabName = tab.getTableName();
                String unSampleTblList = this.conf.getVar(HiveConf.ConfVars.HIVE_TEST_MODE_NOSAMPLE);
                String[] unSampleTbls = unSampleTblList.split(",");
                boolean unsample = false;
                for (String unSampleTbl : unSampleTbls) {
                    if (!tabName.equalsIgnoreCase(unSampleTbl)) continue;
                    unsample = true;
                }
                if (!unsample) {
                    int numBuckets = tab.getNumBuckets();
                    if (numBuckets > 0) {
                        TableSample tsSample = new TableSample(1, numBuckets);
                        tsSample.setInputPruning(true);
                        qb.getParseInfo().setTabSample(alias, tsSample);
                        ExprNodeDesc samplePred = this.genSamplePredicate(tsSample, tab.getBucketCols(), true, alias, rwsch, null, tab.getBucketingVersion());
                        FilterDesc filterDesc = new FilterDesc(samplePred, true, new FilterDesc.SampleDesc(tsSample.getNumerator(), tsSample.getDenominator(), tab.getBucketCols(), true));
                        filterDesc.setGenerated(true);
                        op = OperatorFactory.getAndMakeChild(filterDesc, new RowSchema(rwsch.getColumnInfos()), (Operator)top, new Operator[0]);
                        this.LOG.info("No need for sample filter");
                    } else {
                        int freq = this.conf.getIntVar(HiveConf.ConfVars.HIVE_TEST_MODE_SAMPLE_FREQ);
                        TableSample tsSample = new TableSample(1, freq);
                        tsSample.setInputPruning(false);
                        qb.getParseInfo().setTabSample(alias, tsSample);
                        this.LOG.info("Need sample filter");
                        ExprNodeDesc randFunc = (ExprNodeDesc)ExprNodeTypeCheck.getExprNodeDefaultExprProcessor().getFuncExprNodeDesc("rand", new ExprNodeConstantDesc(460476415));
                        ExprNodeDesc samplePred = this.genSamplePredicate(tsSample, null, false, alias, rwsch, randFunc, tab.getBucketingVersion());
                        FilterDesc filterDesc = new FilterDesc(samplePred, true);
                        filterDesc.setGenerated(true);
                        op = OperatorFactory.getAndMakeChild(filterDesc, new RowSchema(rwsch.getColumnInfos()), (Operator)top, new Operator[0]);
                    }
                }
            }
        }
        Operator<TableScanDesc> output = this.putOpInsertMap(op, rwsch);
        if (tab.isMaterializedTable()) {
            top.setStatistics(this.ctx.getMaterializedTableStats(tab.getFullTableName()).clone());
        }
        this.LOG.debug("Created Table Plan for {} {}", (Object)alias, (Object)op);
        return output;
    }

    boolean isSkewedCol(String alias, QB qb, String colName) {
        return qb.getSkewedColumnNames(alias).stream().anyMatch(skewedCol -> skewedCol.equalsIgnoreCase(colName));
    }

    private void setupStats(TableScanDesc tsDesc, QBParseInfo qbp, org.apache.hadoop.hive.ql.metadata.Table tab, String alias, RowResolver rwsch) throws SemanticException {
        if (!qbp.isAnalyzeCommand() && qbp.getAnalyzeRewrite() == null) {
            tsDesc.setGatherStats(false);
            return;
        }
        if (HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_DBCLASS).equalsIgnoreCase(StatsSetupConst.StatDB.fs.name())) {
            String statsTmpLoc = this.ctx.getTempDirForInterimJobPath(tab.getPath()).toString();
            this.LOG.debug("Set stats collection dir : " + statsTmpLoc);
            tsDesc.setTmpStatsDir(statsTmpLoc);
        }
        tsDesc.setGatherStats(true);
        tsDesc.setStatsReliable(this.conf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_RELIABLE));
        Iterator<VirtualColumn> vcs = VirtualColumn.getStatsRegistry((Configuration)this.conf).iterator();
        ArrayList<VirtualColumn> vcList = new ArrayList<VirtualColumn>();
        while (vcs.hasNext()) {
            VirtualColumn vc = vcs.next();
            rwsch.put(alias, vc.getName(), new ColumnInfo(vc.getName(), vc.getTypeInfo(), alias, true, vc.getIsHidden()));
            vcList.add(vc);
        }
        tsDesc.addVirtualCols(vcList);
        String tblName = tab.getTableName();
        String k = FileUtils.escapePathName((String)tblName).toLowerCase() + "/";
        tsDesc.setStatsAggPrefix(FileUtils.escapePathName((String)tab.getDbName()).toLowerCase() + "." + k);
        WriteEntity we = new WriteEntity(tab, WriteEntity.WriteType.DDL_SHARED);
        we.setTxnAnalyze(true);
        this.outputs.add(we);
        if (AcidUtils.isTransactionalTable(tab)) {
            if (this.acidAnalyzeTable != null) {
                throw new IllegalStateException("Multiple ACID tables in analyze: " + String.valueOf(we) + ", " + String.valueOf(this.acidAnalyzeTable));
            }
            this.acidAnalyzeTable = we;
        }
        if (tab.isPartitioned() && !tab.hasNonNativePartitionSupport()) {
            ArrayList<String> cols = new ArrayList<String>();
            if (qbp.getAnalyzeRewrite() != null) {
                List<FieldSchema> partitionCols = tab.getPartCols();
                for (FieldSchema fs : partitionCols) {
                    cols.add(fs.getName());
                }
                tsDesc.setPartColumns(cols);
                return;
            }
            BaseSemanticAnalyzer.TableSpec tblSpec = qbp.getTableSpec(alias);
            Map<String, String> partSpec = tblSpec.getPartSpec();
            if (partSpec == null) {
                throw new SemanticException(ErrorMsg.NEED_PARTITION_SPECIFICATION.getMsg());
            }
            cols.addAll(partSpec.keySet());
            tsDesc.setPartColumns(cols);
            List<org.apache.hadoop.hive.ql.metadata.Partition> partitions = qbp.getTableSpec().partitions;
            if (partitions != null) {
                for (org.apache.hadoop.hive.ql.metadata.Partition partn : partitions) {
                    WriteEntity pwe = new WriteEntity(partn, WriteEntity.WriteType.DDL_NO_LOCK);
                    pwe.setTxnAnalyze(true);
                    this.outputs.add(pwe);
                }
            }
        }
    }

    private Operator genPlan(QB parent, QBExpr qbexpr) throws SemanticException {
        if (qbexpr.getOpcode() == QBExpr.Opcode.EXCEPT || qbexpr.getOpcode() == QBExpr.Opcode.EXCEPTALL || qbexpr.getOpcode() == QBExpr.Opcode.INTERSECT || qbexpr.getOpcode() == QBExpr.Opcode.INTERSECTALL) {
            throw new SemanticException("EXCEPT and INTERSECT operations are only supported with Cost Based Optimizations enabled. Please set 'hive.cbo.enable' to true!");
        }
        if (qbexpr.getOpcode() == QBExpr.Opcode.NULLOP) {
            boolean skipAmbiguityCheck = this.viewSelect == null && parent.isTopLevelSelectStarQuery();
            return this.genPlan(qbexpr.getQB(), skipAmbiguityCheck);
        }
        if (qbexpr.getOpcode() == QBExpr.Opcode.UNION) {
            Operator qbexpr1Ops = this.genPlan(parent, qbexpr.getQBExpr1());
            Operator qbexpr2Ops = this.genPlan(parent, qbexpr.getQBExpr2());
            return this.genUnionPlan(qbexpr.getAlias(), qbexpr.getQBExpr1().getAlias(), qbexpr1Ops, qbexpr.getQBExpr2().getAlias(), qbexpr2Ops);
        }
        return null;
    }

    Operator genPlan(QB qb) throws SemanticException {
        return this.genPlan(qb, false);
    }

    private Operator genPlan(QB qb, boolean skipAmbiguityCheck) throws SemanticException {
        HashMap<ASTNode, PTFInvocationSpec> ptfNodeToSpec;
        if (!this.ctx.isCboSucceeded() && qb.getParseInfo().hasQualifyClause()) {
            throw new SemanticException(ErrorMsg.CBO_IS_REQUIRED.getErrorCodedMsg(new String[]{"Qualify clause"}));
        }
        LinkedHashMap<String, Operator> aliasToOpInfo = new LinkedHashMap<String, Operator>();
        for (String alias : qb.getSubqAliases()) {
            QBExpr qbexpr = qb.getSubqForAlias(alias);
            Operator<OperatorDesc> operator = this.genPlan(qb, qbexpr);
            aliasToOpInfo.put(alias, operator);
            if (!qb.getViewToTabSchema().containsKey(alias)) continue;
            if (operator instanceof LimitOperator) {
                operator = operator.getParentOperators().get(0);
            }
            if (operator instanceof SelectOperator) {
                if (this.viewProjectToTableSchema == null) {
                    this.viewProjectToTableSchema = new LinkedHashMap<SelectOperator, org.apache.hadoop.hive.ql.metadata.Table>();
                }
                this.viewProjectToTableSchema.put((SelectOperator)operator, qb.getViewToTabSchema().get(alias));
                continue;
            }
            throw new SemanticException("View " + alias + " is corresponding to " + operator.getType().name() + ", rather than a SelectOperator.");
        }
        for (String alias : qb.getTabAliases()) {
            if (alias.equals(DUMMY_TABLE)) continue;
            Operator op = this.genTablePlan(alias, qb);
            aliasToOpInfo.put(alias, op);
        }
        if (aliasToOpInfo.isEmpty()) {
            qb.getMetaData().setSrcForAlias(DUMMY_TABLE, this.getDummyTable());
            TableScanOperator op = (TableScanOperator)this.genTablePlan(DUMMY_TABLE, qb);
            ((TableScanDesc)op.getConf()).setRowLimit(1);
            qb.addAlias(DUMMY_TABLE);
            qb.setTabAlias(DUMMY_TABLE, DUMMY_TABLE);
            aliasToOpInfo.put(DUMMY_TABLE, op);
        }
        Operator srcOpInfo = null;
        Operator lastPTFOp = null;
        if (this.queryProperties.hasPTF() && (ptfNodeToSpec = qb.getPTFNodeToSpec()) != null) {
            for (Map.Entry entry : ptfNodeToSpec.entrySet()) {
                ASTNode ast = (ASTNode)entry.getKey();
                PTFInvocationSpec spec = (PTFInvocationSpec)entry.getValue();
                String inputAlias = spec.getQueryInputName();
                Operator inOp = (Operator)aliasToOpInfo.get(inputAlias);
                if (inOp == null) {
                    throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ast, "Cannot resolve input Operator for PTF invocation"));
                }
                lastPTFOp = this.genPTFPlan(spec, inOp);
                String ptfAlias = spec.getFunction().getAlias();
                if (ptfAlias == null) continue;
                aliasToOpInfo.put(ptfAlias, lastPTFOp);
            }
        }
        this.genLateralViewPlans(aliasToOpInfo, qb);
        if (qb.getParseInfo().getJoinExpr() != null) {
            ASTNode joinExpr = qb.getParseInfo().getJoinExpr();
            if (joinExpr.getToken().getType() == 1305) {
                joinTree = this.genUniqueJoinTree(qb, joinExpr, aliasToOpInfo);
                qb.setQbJoinTree(joinTree);
            } else {
                joinTree = this.genJoinTree(qb, joinExpr, aliasToOpInfo);
                qb.setQbJoinTree(joinTree);
                Set<String> set = qb.getParseInfo().getClauseNames();
                if (set.size() == 1 && joinTree.getNoOuterJoin()) {
                    String dest = set.iterator().next();
                    ASTNode whereClause = qb.getParseInfo().getWhrForClause(dest);
                    if (whereClause != null) {
                        this.extractJoinCondsFromWhereClause(joinTree, (ASTNode)whereClause.getChild(0), aliasToOpInfo);
                    }
                }
                if (!this.disableJoinMerge) {
                    this.mergeJoinTree(qb);
                }
            }
            this.pushJoinFilters(qb, qb.getQbJoinTree(), aliasToOpInfo);
            srcOpInfo = this.genJoinPlan(qb, aliasToOpInfo);
        } else {
            srcOpInfo = (Operator)aliasToOpInfo.values().iterator().next();
            srcOpInfo = lastPTFOp != null ? lastPTFOp : srcOpInfo;
        }
        Operator bodyOpInfo = this.genBodyPlan(qb, srcOpInfo, aliasToOpInfo);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Created Plan for Query Block " + qb.getId());
        }
        if (qb.getAlias() != null) {
            this.rewriteRRForSubQ(qb.getAlias(), bodyOpInfo, skipAmbiguityCheck);
        }
        this.setQB(qb);
        return bodyOpInfo;
    }

    private void rewriteRRForSubQ(String alias, Operator operator, boolean skipAmbiguityCheck) throws SemanticException {
        RowResolver rr = this.opParseCtx.get(operator).getRowResolver();
        RowResolver newRR = new RowResolver();
        for (ColumnInfo colInfo : rr.getColumnInfos()) {
            String name = colInfo.getInternalName();
            String[] tmp = rr.reverseLookup(name);
            if ("".equals(tmp[0]) || tmp[1] == null) {
                tmp[1] = colInfo.getInternalName();
            } else if (newRR.get(alias, tmp[1]) != null) {
                if (!skipAmbiguityCheck) {
                    throw new SemanticException(ErrorMsg.AMBIGUOUS_COLUMN.getMsg(tmp[1] + " in " + alias));
                }
                tmp[1] = colInfo.getInternalName();
            }
            newRR.put(alias, tmp[1], colInfo);
        }
        this.opParseCtx.get(operator).setRowResolver(newRR);
    }

    public org.apache.hadoop.hive.ql.metadata.Table getDummyTable() throws SemanticException {
        if (this.dummyPath == null) {
            this.dummyPath = this.createDummyFile();
        }
        org.apache.hadoop.hive.ql.metadata.Table desc = new org.apache.hadoop.hive.ql.metadata.Table(DUMMY_DATABASE, DUMMY_TABLE);
        desc.getTTable().getSd().setLocation(this.dummyPath.toString());
        desc.getTTable().getSd().getSerdeInfo().setSerializationLib(NullStructSerDe.class.getName());
        desc.setInputFormatClass(NullRowsInputFormat.class);
        desc.setOutputFormatClass(HiveIgnoreKeyTextOutputFormat.class);
        return desc;
    }

    private Path createDummyFile() throws SemanticException {
        Path dummyPath = new Path(this.ctx.getMRScratchDir(), "dummy_path");
        Path dummyFile = new Path(dummyPath, "dummy_file");
        FSDataOutputStream fout = null;
        try {
            FileSystem fs = dummyFile.getFileSystem((Configuration)this.conf);
            if (fs.exists(dummyFile)) {
                Path path = dummyPath;
                return path;
            }
            fout = fs.create(dummyFile);
            fout.write(1);
            fout.close();
            IOUtils.closeStream((Closeable)fout);
        }
        catch (IOException e) {
            throw new SemanticException((Throwable)e);
        }
        finally {
            IOUtils.closeStream(fout);
        }
        return dummyPath;
    }

    private void genLateralViewPlans(Map<String, Operator> aliasToOpInfo, QB qb) throws SemanticException {
        Map<String, List<ASTNode>> aliasToLateralViews = qb.getParseInfo().getAliasToLateralViews();
        for (Map.Entry<String, Operator> e : aliasToOpInfo.entrySet()) {
            String alias = e.getKey();
            List<ASTNode> lateralViews = aliasToLateralViews.get(alias);
            if (lateralViews == null) continue;
            Operator op = e.getValue();
            for (ASTNode lateralViewTree : aliasToLateralViews.get(alias)) {
                op = this.genLateralViewPlan(qb, op, lateralViewTree);
            }
            e.setValue(op);
        }
    }

    private Operator genLateralViewPlanForDest(String dest, QB qb, Operator op) throws SemanticException {
        ASTNode lateralViewTree = qb.getParseInfo().getDestToLateralView().get(dest);
        if (lateralViewTree != null) {
            return this.genLateralViewPlan(qb, op, lateralViewTree);
        }
        return op;
    }

    private Operator genLateralViewPlan(QB qb, Operator op, ASTNode lateralViewTree) throws SemanticException {
        RowResolver lvForwardRR = new RowResolver();
        RowResolver source = this.opParseCtx.get(op).getRowResolver();
        HashMap<String, ExprNodeDesc> lvfColExprMap = new HashMap<String, ExprNodeDesc>();
        HashMap<String, ExprNodeDesc> selColExprMap = new HashMap<String, ExprNodeDesc>();
        ArrayList<ExprNodeDesc> colList = new ArrayList<ExprNodeDesc>();
        ArrayList<String> colNames = new ArrayList<String>();
        for (ColumnInfo col : source.getColumnInfos()) {
            String[] tabCol = source.reverseLookup(col.getInternalName());
            lvForwardRR.put(tabCol[0], tabCol[1], col);
            ExprNodeColumnDesc colExpr = new ExprNodeColumnDesc(col);
            colList.add(colExpr);
            colNames.add(colExpr.getColumn());
            lvfColExprMap.put(col.getInternalName(), colExpr);
            selColExprMap.put(col.getInternalName(), colExpr.clone());
        }
        Operator<LateralViewForwardDesc> lvForward = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new LateralViewForwardDesc(), new RowSchema(lvForwardRR.getColumnInfos()), op, new Operator[0]), lvForwardRR);
        lvForward.setColumnExprMap(lvfColExprMap);
        RowResolver allPathRR = this.opParseCtx.get(lvForward).getRowResolver();
        SelectDesc sDesc = new SelectDesc(colList, colNames, false);
        sDesc.setSelStarNoCompute(true);
        Operator<SelectDesc> allPath = this.putOpInsertMap(OperatorFactory.getAndMakeChild(sDesc, new RowSchema(allPathRR.getColumnInfos()), lvForward, new Operator[0]), allPathRR);
        allPath.setColumnExprMap(selColExprMap);
        int allColumns = allPathRR.getColumnInfos().size();
        QB blankQb = new QB(null, null, false);
        Operator<?> udtfPath = this.genSelectPlan(null, (ASTNode)lateralViewTree.getChild(0), blankQb, lvForward, null, lateralViewTree.getType() == 1080);
        for (String udtfAlias : blankQb.getAliases()) {
            qb.addAlias(udtfAlias);
        }
        RowResolver udtfPathRR = this.opParseCtx.get(udtfPath).getRowResolver();
        RowResolver lateralViewRR = new RowResolver();
        ArrayList<String> outputInternalColNames = new ArrayList<String>();
        HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
        this.LVmergeRowResolvers(allPathRR, lateralViewRR, colExprMap, outputInternalColNames);
        this.LVmergeRowResolvers(udtfPathRR, lateralViewRR, colExprMap, outputInternalColNames);
        Operator<LateralViewJoinDesc> lateralViewJoin = this.putOpInsertMap(OperatorFactory.getAndMakeChild(new LateralViewJoinDesc(allColumns, outputInternalColNames), new RowSchema(lateralViewRR.getColumnInfos()), allPath, udtfPath), lateralViewRR);
        lateralViewJoin.setColumnExprMap(colExprMap);
        return lateralViewJoin;
    }

    private void LVmergeRowResolvers(RowResolver source, RowResolver dest, Map<String, ExprNodeDesc> colExprMap, List<String> outputInternalColNames) {
        for (ColumnInfo c : source.getColumnInfos()) {
            String internalName = SemanticAnalyzer.getColumnInternalName(outputInternalColNames.size());
            outputInternalColNames.add(internalName);
            ColumnInfo newCol = new ColumnInfo(internalName, c.getType(), c.getTabAlias(), c.getIsVirtualCol(), c.isHiddenVirtualCol());
            String[] tableCol = source.reverseLookup(c.getInternalName());
            String tableAlias = tableCol[0];
            String colAlias = tableCol[1];
            dest.put(tableAlias, colAlias, newCol);
            colExprMap.put(internalName, new ExprNodeColumnDesc(c));
        }
    }

    protected Phase1Ctx initPhase1Ctx() {
        Phase1Ctx ctx_1 = new Phase1Ctx();
        ctx_1.nextNum = 0;
        ctx_1.dest = "reduce";
        return ctx_1;
    }

    @Override
    public void init(boolean clearPartsCache) {
        this.reset(clearPartsCache);
        this.qb = new QB(null, null, false);
    }

    @Override
    public void analyzeInternal(ASTNode ast) throws SemanticException {
        this.analyzeInternal(ast, PlannerContext::new);
    }

    protected org.apache.hadoop.hive.ql.metadata.Table getTableObjectByName(String tableName, boolean throwException) throws HiveException {
        if (!this.tabNameToTabObject.containsKey(tableName)) {
            org.apache.hadoop.hive.ql.metadata.Table table = this.db.getTable(tableName, throwException);
            if (table != null) {
                this.tabNameToTabObject.put(tableName, table);
            }
            return table;
        }
        return this.tabNameToTabObject.get(tableName);
    }

    public org.apache.hadoop.hive.ql.metadata.Table getTableObjectByName(String tableName) throws HiveException {
        return this.getTableObjectByName(tableName, true);
    }

    private void walkASTMarkTABREF(TableMask tableMask, ASTNode ast, Set<String> cteAlias, Context ctx) throws SemanticException {
        LinkedList<Object> queue = new LinkedList<Object>();
        queue.add(ast);
        LinkedHashMap<HivePrivilegeObject, MaskAndFilterInfo> basicInfos = new LinkedHashMap<HivePrivilegeObject, MaskAndFilterInfo>();
        while (!queue.isEmpty()) {
            ASTNode astNode = (ASTNode)queue.poll();
            if (astNode.getToken().getType() == 1280) {
                int aliasIndex = 0;
                StringBuilder additionalTabInfo = new StringBuilder();
                for (int index = 1; index < astNode.getChildCount(); ++index) {
                    ASTNode ct = (ASTNode)astNode.getChild(index);
                    if (ct.getToken().getType() == 1257 || ct.getToken().getType() == 1275 || ct.getToken().getType() == 1264) {
                        additionalTabInfo.append(ctx.getTokenRewriteStream().toString(ct.getTokenStartIndex(), ct.getTokenStopIndex()));
                        continue;
                    }
                    aliasIndex = index;
                }
                ASTNode tableTree = (ASTNode)astNode.getChild(0);
                String tabIdName = SemanticAnalyzer.getUnescapedName(tableTree);
                String alias = aliasIndex != 0 ? SemanticAnalyzer.unescapeIdentifier(astNode.getChild(aliasIndex).getText()) : SemanticAnalyzer.getUnescapedUnqualifiedTableName(tableTree);
                if (cteAlias.contains(tabIdName)) continue;
                org.apache.hadoop.hive.ql.metadata.Table table = null;
                try {
                    table = this.getTableObjectByName(tabIdName, false);
                }
                catch (HiveException e) {
                    throw new SemanticException("Got exception though getTableObjectByName method should ignore it");
                }
                if (table == null) {
                    STATIC_LOG.debug("Table " + tabIdName + " is not found in walkASTMarkTABREF.");
                    continue;
                }
                if (table.isMaterializedView()) {
                    for (SourceTable sourceTable : table.getMVMetadata().getSourceTables()) {
                        String qualifiedTableName = TableName.getDbTable((String)sourceTable.getTable().getDbName(), (String)sourceTable.getTable().getTableName());
                        try {
                            table = this.getTableObjectByName(qualifiedTableName, true);
                        }
                        catch (HiveException e) {
                            throw new SemanticException("Table " + qualifiedTableName + " not found when trying to obtain it to check masking/filtering policies");
                        }
                        ArrayList<String> colNames = new ArrayList<String>();
                        this.extractColumnInfos(table, colNames, new ArrayList<String>());
                        basicInfos.put(new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW, table.getCatName(), table.getDbName(), table.getTableName(), null, colNames, HivePrivilegeObject.HivePrivObjectActionType.OTHER, null, null, table.getOwner(), table.getOwnerType()), null);
                    }
                } else {
                    List<String> colTypes;
                    List<String> colNames;
                    if (this.ctx.isCboSucceeded() && this.columnAccessInfo != null && (colNames = this.columnAccessInfo.getTableToColumnAllAccessMap().get(table.getCompleteName())) != null) {
                        Map<String, String> colNameToType = table.getAllCols().stream().collect(Collectors.toMap(FieldSchema::getName, FieldSchema::getType));
                        colTypes = colNames.stream().map(colNameToType::get).collect(Collectors.toList());
                    } else {
                        colNames = new ArrayList<String>();
                        colTypes = new ArrayList<String>();
                        this.extractColumnInfos(table, colNames, colTypes);
                    }
                    basicInfos.put(new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW, table.getCatName(), table.getDbName(), table.getTableName(), null, colNames, HivePrivilegeObject.HivePrivObjectActionType.OTHER, null, null, table.getOwner(), table.getOwnerType()), new MaskAndFilterInfo(colTypes, additionalTabInfo.toString(), alias, astNode, table.isView(), table.isNonNative()));
                }
            }
            if (astNode.getChildCount() <= 0 || IGNORED_TOKENS.contains(astNode.getToken().getType())) continue;
            for (Node child : astNode.getChildren()) {
                queue.offer(child);
            }
        }
        ArrayList<HivePrivilegeObject> basicPrivObjs = new ArrayList<HivePrivilegeObject>(basicInfos.keySet());
        List<HivePrivilegeObject> needRewritePrivObjs = tableMask.applyRowFilterAndColumnMasking(basicPrivObjs);
        if (needRewritePrivObjs != null && !needRewritePrivObjs.isEmpty()) {
            for (HivePrivilegeObject privObj : needRewritePrivObjs) {
                MaskAndFilterInfo info = (MaskAndFilterInfo)basicInfos.get(privObj);
                if (!tableMask.needsMaskingOrFiltering(privObj) || SessionState.get().isCompaction()) continue;
                if (info == null) {
                    throw new SemanticException(ErrorMsg.MASKING_FILTERING_ON_MATERIALIZED_VIEWS_SOURCES, new String[]{privObj.getCatName(), privObj.getDbname(), privObj.getObjectName()});
                }
                String replacementText = tableMask.create(privObj, info);
                if (ctx.getIsUpdateDeleteMerge()) {
                    throw new SemanticException(ErrorMsg.MASKING_FILTERING_ON_ACID_NOT_SUPPORTED, new String[]{privObj.getCatName(), privObj.getDbname(), privObj.getObjectName()});
                }
                tableMask.setNeedsRewrite(true);
                tableMask.addTranslation(info.astNode, replacementText);
            }
        }
    }

    private void extractColumnInfos(org.apache.hadoop.hive.ql.metadata.Table table, List<String> colNames, List<String> colTypes) {
        for (FieldSchema col : table.getAllCols()) {
            colNames.add(col.getName());
            colTypes.add(col.getType());
        }
    }

    private ParseResult rewriteASTWithMaskAndFilter(TableMask tableMask, ASTNode ast, TokenRewriteStream tokenRewriteStream, Context ctx, Hive db) throws SemanticException {
        HashSet<String> cteAlias = new HashSet<String>();
        if (ast.getChildCount() > 0 && 971 == ((ASTNode)ast.getChild(0)).getToken().getType()) {
            int index;
            ASTNode cte = (ASTNode)ast.getChild(0);
            for (index = cte.getChildCount() - 1; index >= 0; --index) {
                ASTNode subq = (ASTNode)cte.getChild(index);
                String alias = SemanticAnalyzer.unescapeIdentifier(subq.getChild(1).getText());
                if (cteAlias.contains(alias)) {
                    throw new SemanticException("Duplicate definition of " + alias);
                }
                cteAlias.add(alias);
                this.walkASTMarkTABREF(tableMask, subq, cteAlias, ctx);
            }
            for (index = 1; index < ast.getChildCount(); ++index) {
                this.walkASTMarkTABREF(tableMask, (ASTNode)ast.getChild(index), cteAlias, ctx);
            }
        } else {
            this.walkASTMarkTABREF(tableMask, ast, cteAlias, ctx);
        }
        if (tableMask.needsRewrite()) {
            this.quoteIdentifierTokens(tokenRewriteStream);
            tableMask.applyTranslations(tokenRewriteStream);
            String rewrittenQuery = tokenRewriteStream.toString(ast.getTokenStartIndex(), ast.getTokenStopIndex());
            try {
                Context rewriteCtx = new Context((Configuration)this.conf);
                ctx.addSubContext(rewriteCtx);
                ASTNode rewrittenTree = ParseUtils.parse(rewrittenQuery, rewriteCtx);
                return new ParseResult(rewrittenTree, rewriteCtx.getTokenRewriteStream(), rewriteCtx.getParsedTables());
            }
            catch (ParseException e) {
                throw new SemanticException((Throwable)e);
            }
        }
        return new ParseResult(ast, ctx.getTokenRewriteStream(), ctx.getParsedTables());
    }

    protected void gatherUserSuppliedFunctions(ASTNode ast) throws SemanticException {
        int tokenType = ast.getToken().getType();
        if ((tokenType == 1039 || tokenType == 1040 || tokenType == 1041) && ast.getChild(0).getType() == 24) {
            try {
                String functionName = SemanticAnalyzer.unescapeIdentifier(ast.getChild(0).getText()).toLowerCase();
                String[] qualifiedFunctionName = FunctionUtils.getQualifiedFunctionNameParts(functionName);
                this.userSuppliedFunctions.add(qualifiedFunctionName[0] + "." + qualifiedFunctionName[1]);
            }
            catch (HiveException ex) {
                throw new SemanticException(ex.getMessage(), (Throwable)ex);
            }
        }
        for (int i = 0; i < ast.getChildCount(); ++i) {
            this.gatherUserSuppliedFunctions((ASTNode)ast.getChild(i));
        }
    }

    /*
     * Unable to fully structure code
     */
    protected boolean genResolvedParseTree(ASTNode ast, PlannerContext plannerCtx) throws SemanticException {
        child = ast;
        this.ast = ast;
        this.viewsExpanded = new ArrayList<String>();
        this.queryState.setCommandType(HiveOperation.QUERY);
        if (ast.getToken().getType() == 964) {
            child = this.analyzeCreateView(ast, this.qb, plannerCtx);
            if (child == null) {
                return false;
            }
            this.viewSelect = child;
            this.viewsExpanded.add(this.createVwDesc.getViewName());
        }
        if (this.forViewCreation) {
            this.viewsExpanded.add(this.fqViewName);
        }
        switch (ast.getToken().getType()) {
            case 1204: {
                if (!SemanticAnalyzer.$assertionsDisabled && ast.getChildCount() != 1) {
                    throw new AssertionError();
                }
                if (ast.getChild(0).getType() != 1295) ** GOTO lbl22
                this.setAutoCommitValue(true);
                ** GOTO lbl27
lbl22:
                // 1 sources

                if (ast.getChild(0).getType() != 1030) ** GOTO lbl25
                this.setAutoCommitValue(false);
                ** GOTO lbl27
lbl25:
                // 1 sources

                if (!SemanticAnalyzer.$assertionsDisabled) {
                    throw new AssertionError((Object)("Unexpected child of TOK_SET_AUTOCOMMIT: " + ast.getChild(0).getType()));
                }
            }
lbl27:
            // 5 sources

            case 949: 
            case 1191: 
            case 1236: {
                if (!this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEST) && !this.conf.getBoolVar(HiveConf.ConfVars.HIVE_IN_TEZ_TEST)) {
                    throw new IllegalStateException(String.valueOf((Object)HiveOperation.operationForToken(ast.getToken().getType())) + " is not supported yet.");
                }
                this.queryState.setCommandType(HiveOperation.operationForToken(ast.getToken().getType()));
                return false;
            }
        }
        return this.analyzeAndResolveChildTree(child, plannerCtx);
    }

    protected boolean analyzeAndResolveChildTree(ASTNode child, PlannerContext plannerCtx) throws SemanticException {
        this.tableMask = new TableMask(this, this.conf, this.ctx.isSkipTableMasking());
        this.gatherUserSuppliedFunctions(child);
        Phase1Ctx ctx_1 = this.initPhase1Ctx();
        if (!this.doPhase1(child, this.qb, ctx_1, plannerCtx)) {
            return false;
        }
        this.LOG.info("Completed phase 1 of Semantic Analysis");
        this.getMetaData(this.qb, this.createVwDesc == null && !this.forViewCreation);
        this.LOG.info("Completed getting MetaData in Semantic Analysis");
        return true;
    }

    void getHintsFromQB(QB qb, List<ASTNode> hints) {
        if (qb.getParseInfo().getHints() != null) {
            hints.add(qb.getParseInfo().getHints());
        }
        Set<String> aliases = qb.getSubqAliases();
        for (String alias : aliases) {
            this.getHintsFromQB(qb.getSubqForAlias(alias), hints);
        }
    }

    private void getHintsFromQB(QBExpr qbExpr, List<ASTNode> hints) {
        QBExpr qbExpr1 = qbExpr.getQBExpr1();
        QBExpr qbExpr2 = qbExpr.getQBExpr2();
        QB qb = qbExpr.getQB();
        if (qbExpr1 != null) {
            this.getHintsFromQB(qbExpr1, hints);
        }
        if (qbExpr2 != null) {
            this.getHintsFromQB(qbExpr2, hints);
        }
        if (qb != null) {
            this.getHintsFromQB(qb, hints);
        }
    }

    Operator genOPTree(ASTNode ast, PlannerContext plannerCtx) throws SemanticException {
        ArrayList<ASTNode> hintsList = new ArrayList<ASTNode>();
        this.getHintsFromQB(this.qb, hintsList);
        this.getQB().getParseInfo().setHintList(hintsList);
        return this.genPlan(this.qb);
    }

    private void removeOBInSubQuery(QBExpr qbExpr) {
        if (qbExpr == null) {
            return;
        }
        if (qbExpr.getOpcode() == QBExpr.Opcode.NULLOP) {
            QB subQB = qbExpr.getQB();
            QBParseInfo parseInfo = subQB.getParseInfo();
            String alias = qbExpr.getAlias();
            Map<String, ASTNode> destToOrderBy = parseInfo.getDestToOrderBy();
            Map<String, ASTNode> destToSortBy = parseInfo.getDestToSortBy();
            String warning = "WARNING: Order/Sort by without limit in sub query or view [" + alias + "] is removed, as it's pointless and bad for performance.";
            if (destToOrderBy != null) {
                for (String dest : destToOrderBy.keySet()) {
                    if (parseInfo.getDestLimit(dest) != null) continue;
                    this.removeASTChild(destToOrderBy.get(dest));
                    destToOrderBy.remove(dest);
                    this.console.printInfo(warning);
                }
            }
            if (destToSortBy != null) {
                for (String dest : destToSortBy.keySet()) {
                    if (parseInfo.getDestLimit(dest) != null) continue;
                    this.removeASTChild(destToSortBy.get(dest));
                    destToSortBy.remove(dest);
                    this.console.printInfo(warning);
                }
            }
        } else {
            this.removeOBInSubQuery(qbExpr.getQBExpr1());
            this.removeOBInSubQuery(qbExpr.getQBExpr2());
        }
    }

    private void removeASTChild(ASTNode node) {
        Optional.ofNullable(node.getParent()).ifPresent(parent -> {
            parent.deleteChild(node.getChildIndex());
            node.setParent(null);
        });
    }

    protected void compilePlan(ParseContext pCtx) throws SemanticException {
        if (!this.ctx.getExplainLogical()) {
            TaskCompiler compiler = TaskCompilerFactory.getCompiler(this.conf, pCtx);
            compiler.init(this.queryState, this.console, this.db);
            compiler.compile(pCtx, this.rootTasks, this.inputs, this.outputs);
            this.fetchTask = pCtx.getFetchTask();
        }
    }

    void analyzeInternal(ASTNode ast, Supplier<PlannerContext> pcf) throws SemanticException {
        FileSinkOperator fileSinkOperator;
        Optional<HiveStorageHandler> handler;
        ParseResult rewrittenResult;
        ASTNode rewrittenAST;
        this.LOG.info("Starting Semantic Analysis");
        PerfLogger perfLogger = SessionState.getPerfLogger();
        perfLogger.perfLogBegin(this.getClass().getName(), "Generate Resolved ParseTree");
        boolean needsTransform = this.needsTransform();
        this.processPositionAlias(ast);
        PlannerContext plannerCtx = pcf.get();
        if (!this.genResolvedParseTree(ast, plannerCtx)) {
            return;
        }
        this.openTxnAndSetValidTxnList();
        if (HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_REMOVE_ORDERBY_IN_SUBQUERY)) {
            for (String alias : this.qb.getSubqAliases()) {
                this.removeOBInSubQuery(this.qb.getSubqForAlias(alias));
            }
        }
        String llapIOETLSkipFormat = HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_IO_ETL_SKIP_FORMAT);
        if (this.qb.getParseInfo().hasInsertTables() || this.qb.isCTAS()) {
            if (llapIOETLSkipFormat.equalsIgnoreCase("encode")) {
                this.conf.setBoolean(HiveConf.ConfVars.LLAP_IO_ENCODE_ENABLED.varname, false);
                this.LOG.info("Disabling LLAP IO encode as ETL query is detected");
            } else if (llapIOETLSkipFormat.equalsIgnoreCase("all")) {
                this.conf.setBoolean(HiveConf.ConfVars.LLAP_IO_ENABLED.varname, false);
                this.LOG.info("Disabling LLAP IO as ETL query is detected");
            }
        }
        boolean isCacheEnabled = this.isResultsCacheEnabled();
        QueryResultsCache.LookupInfo lookupInfo = null;
        if (isCacheEnabled && !needsTransform && this.queryTypeCanUseCache(this.qb) && this.checkResultsCache(lookupInfo = this.createLookupInfoForQuery(ast), false)) {
            return;
        }
        ASTNode astForMasking = this.isCBOExecuted() && needsTransform && (this.qb.isCTAS() || this.forViewCreation || this.qb.isMaterializedView() || this.qb.isMultiDestQuery()) ? (ASTNode)ParseDriver.adaptor.dupTree((Object)ast) : ast;
        perfLogger.perfLogEnd(this.getClass().getName(), "Generate Resolved ParseTree");
        perfLogger.perfLogBegin(this.getClass().getName(), "Logical Plan and hive Operator Tree");
        this.sinkOp = this.genOPTree(ast, plannerCtx);
        boolean usesMasking = false;
        if (!this.forViewCreation && ast.getToken().getType() != 964 && this.tableMask.isEnabled() && this.analyzeRewrite == null && astForMasking != (rewrittenAST = (rewrittenResult = this.rewriteASTWithMaskAndFilter(this.tableMask, astForMasking, this.ctx.getTokenRewriteStream(), this.ctx, this.db)).getTree())) {
            usesMasking = true;
            plannerCtx = pcf.get();
            this.ctx.setSkipTableMasking(true);
            this.ctx.setTokenRewriteStream(rewrittenResult.getTokenRewriteStream());
            this.init(true);
            this.processPositionAlias(rewrittenAST);
            this.genResolvedParseTree(rewrittenAST, plannerCtx);
            if (this instanceof CalcitePlanner) {
                ((CalcitePlanner)this).resetCalciteConfiguration();
            }
            this.sinkOp = this.genOPTree(rewrittenAST, plannerCtx);
        }
        if (this.sinkOp instanceof FileSinkOperator && (handler = Optional.ofNullable(fileSinkOperator = (FileSinkOperator)this.sinkOp).map(Operator::getConf).map(FileSinkDesc::getTable).map(org.apache.hadoop.hive.ql.metadata.Table::getStorageHandler)).isPresent()) {
            handler.get().validateSinkDesc((FileSinkDesc)fileSinkOperator.getConf());
        }
        if (isCacheEnabled && needsTransform && !usesMasking && this.queryTypeCanUseCache(this.qb) && this.checkResultsCache(lookupInfo = this.createLookupInfoForQuery(ast), false)) {
            return;
        }
        perfLogger.perfLogEnd(this.getClass().getName(), "Logical Plan and hive Operator Tree");
        perfLogger.perfLogBegin(this.getClass().getName(), "Deduce ResultsetSchema");
        if ((this.forViewCreation || this.createVwDesc != null) && !this.ctx.isCboSucceeded()) {
            this.resultSchema = this.convertRowSchemaToViewSchema(this.opParseCtx.get(this.sinkOp).getRowResolver());
        } else if (this.resultSchema == null) {
            this.resultSchema = this.convertRowSchemaToResultSetSchema(this.opParseCtx.get(this.sinkOp).getRowResolver(), HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_RESULTSET_USE_UNIQUE_COLUMN_NAMES));
        }
        perfLogger.perfLogEnd(this.getClass().getName(), "Deduce ResultsetSchema");
        perfLogger.perfLogBegin(this.getClass().getName(), "Parse Context generation");
        this.copyInfoToQueryProperties(this.queryProperties);
        ParseContext pCtx = new ParseContext(this.queryState, this.opToPartPruner, this.opToPartList, this.topOps, new HashSet<JoinOperator>(this.joinContext.keySet()), new HashSet<SMBMapJoinOperator>(this.smbMapJoinContext.keySet()), this.loadTableWork, this.loadFileWork, this.columnStatsAutoGatherContexts, this.ctx, this.idToTableNameMap, this.destTableId, this.uCtx, this.listMapJoinOpsNoReducer, this.prunedPartitions, this.tabNameToTabObject, this.opToSamplePruner, this.globalLimitCtx, this.nameToSplitSample, this.inputs, this.rootTasks, this.opToPartToSkewedPruner, this.viewAliasToInput, this.reduceSinkOperatorsAddedByEnforceBucketingSorting, this.analyzeRewrite, this.tableDesc, this.createVwDesc, this.materializedViewUpdateDesc, this.queryProperties, this.viewProjectToTableSchema);
        pCtx.setSemiJoinHints(this.parseSemiJoinHint(this.getQB().getParseInfo().getHintList()));
        pCtx.setDisableMapJoin(this.disableMapJoinWithHint(this.getQB().getParseInfo().getHintList()));
        if (this.forViewCreation && HiveConf.shouldComputeLineage((HiveConf)this.conf)) {
            ArrayList<Transform> transformations = new ArrayList<Transform>();
            transformations.add(new HiveOpConverterPostProc());
            transformations.add(Generator.fromConf(this.conf));
            for (Transform t : transformations) {
                pCtx = t.transform(pCtx);
            }
        }
        perfLogger.perfLogEnd(this.getClass().getName(), "Parse Context generation");
        perfLogger.perfLogBegin(this.getClass().getName(), "Save and Validate View Creation");
        if (this.createVwDesc != null) {
            if (this.ctx.getExplainAnalyze() == ExplainConfiguration.AnalyzeState.RUNNING) {
                return;
            }
            if (!this.ctx.isCboSucceeded()) {
                this.saveViewDefinition();
            }
            this.validateCreateView();
            this.createVwDesc.setTablesUsed(pCtx.getTablesUsed());
        }
        perfLogger.perfLogEnd(this.getClass().getName(), "Save and Validate View Creation");
        perfLogger.perfLogBegin(this.getClass().getName(), "Logical Optimization");
        if (!this.forViewCreation || this.getColumnAccessInfo() == null) {
            boolean isColumnInfoNeedForAuth;
            if (HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_COLLECT_TABLEKEYS)) {
                TableAccessAnalyzer tableAccessAnalyzer = new TableAccessAnalyzer(pCtx);
                this.setTableAccessInfo(tableAccessAnalyzer.analyzeTableAccess());
            }
            AuxOpTreeSignature.linkAuxSignatures(pCtx);
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Before logical optimization\n" + Operator.toString(pCtx.getTopOps().values()));
            }
            Optimizer optm = new Optimizer();
            optm.setPctx(pCtx);
            optm.initialize(this.conf);
            pCtx = optm.optimize();
            if (pCtx.getColumnAccessInfo() != null) {
                this.setColumnAccessInfo(pCtx.getColumnAccessInfo());
            }
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("After logical optimization\n" + Operator.toString(pCtx.getTopOps().values()));
            }
            boolean bl = isColumnInfoNeedForAuth = SessionState.get().isAuthorizationModeV2() && HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_AUTHORIZATION_ENABLED);
            if (isColumnInfoNeedForAuth || HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_COLLECT_SCANCOLS)) {
                ColumnAccessAnalyzer columnAccessAnalyzer = new ColumnAccessAnalyzer(pCtx);
                this.setColumnAccessInfo(columnAccessAnalyzer.analyzeColumnAccess(this.getColumnAccessInfo()));
            }
        }
        perfLogger.perfLogEnd(this.getClass().getName(), "Logical Optimization");
        if (this.forViewCreation) {
            return;
        }
        perfLogger.perfLogBegin(this.getClass().getName(), "Physical Optimization");
        this.compilePlan(pCtx);
        perfLogger.perfLogEnd(this.getClass().getName(), "Physical Optimization");
        perfLogger.perfLogBegin(this.getClass().getName(), "Post Processing");
        new QueryPlanPostProcessor(this.rootTasks, this.acidFileSinks, this.ctx.getExecutionId());
        Optional<TezTask> optionalTezTask = this.rootTasks.stream().filter(task -> task instanceof TezTask).map(task -> (TezTask)task).findFirst();
        if (optionalTezTask.isPresent()) {
            TezTask tezTask = optionalTezTask.get();
            this.rootTasks.stream().filter(task -> task.getWork() instanceof DDLWork).map(task -> (DDLWork)task.getWork()).filter(ddlWork -> ddlWork.getDDLDesc() instanceof PreInsertTableDesc).map(ddlWork -> (PreInsertTableDesc)ddlWork.getDDLDesc()).map(desc -> new InsertCommitHookDesc(desc.getTable(), desc.isOverwrite())).forEach(insertCommitHookDesc -> tezTask.addDependentTask(TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), (DDLDesc)insertCommitHookDesc), this.conf)));
        }
        this.LOG.info("Completed plan generation");
        if (HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_COLLECT_SCANCOLS)) {
            this.putAccessedColumnsToReadEntity(this.inputs, this.columnAccessInfo);
        }
        if (isCacheEnabled && lookupInfo != null && this.queryCanBeCached()) {
            if (this.checkResultsCache(lookupInfo, true)) {
                this.LOG.info("Cached result found on second lookup");
            } else {
                QueryResultsCache.QueryInfo queryInfo = this.createCacheQueryInfoForQuery(lookupInfo);
                this.setCacheUsage(new CacheUsage(CacheUsage.CacheStatus.CAN_CACHE_QUERY_RESULTS, queryInfo));
            }
        }
        perfLogger.perfLogEnd(this.getClass().getName(), "Post Processing");
    }

    private void putAccessedColumnsToReadEntity(Set<ReadEntity> inputs, ColumnAccessInfo columnAccessInfo) {
        Map<String, List<String>> tableToColumnAccessMap = columnAccessInfo.getTableToColumnAccessMap();
        if (tableToColumnAccessMap != null && !tableToColumnAccessMap.isEmpty()) {
            for (ReadEntity entity : inputs) {
                switch (entity.getType()) {
                    case TABLE: {
                        List<String> cols = tableToColumnAccessMap.get(entity.getTable().getCompleteName());
                        if (cols == null || cols.isEmpty()) break;
                        entity.getAccessedColumns().addAll(cols);
                        break;
                    }
                    case PARTITION: {
                        List<String> cols = tableToColumnAccessMap.get(entity.getPartition().getTable().getCompleteName());
                        if (cols == null || cols.isEmpty()) break;
                        entity.getAccessedColumns().addAll(cols);
                        break;
                    }
                }
            }
        }
    }

    @Override
    public List<FieldSchema> getResultSchema() {
        return this.resultSchema;
    }

    public List<FieldSchema> getOriginalResultSchema() {
        return this.originalResultSchema;
    }

    protected void saveViewDefinition() throws SemanticException {
        int derivedColCount;
        int explicitColCount;
        ArrayList<FieldSchema> derivedSchema = new ArrayList<FieldSchema>(this.resultSchema);
        ParseUtils.validateColumnNameUniqueness(derivedSchema);
        List<FieldSchema> imposedSchema = this.createVwDesc.getCols();
        if (imposedSchema != null && (explicitColCount = imposedSchema.size()) != (derivedColCount = derivedSchema.size())) {
            throw new SemanticException(SemanticAnalyzer.generateErrorMessage(this.viewSelect, ErrorMsg.VIEW_COL_MISMATCH.getMsg()));
        }
        if (this.createVwDesc.getViewOriginalText() == null) {
            String originalText = this.ctx.getTokenRewriteStream().toString(this.viewSelect.getTokenStartIndex(), this.viewSelect.getTokenStopIndex());
            this.createVwDesc.setViewOriginalText(originalText);
        }
        this.unparseTranslator.applyTranslations(this.ctx.getTokenRewriteStream());
        String expandedText = this.ctx.getTokenRewriteStream().toString(this.viewSelect.getTokenStartIndex(), this.viewSelect.getTokenStopIndex());
        if (this.createVwDesc.getPartColNames() != null) {
            boolean first = true;
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT ");
            for (FieldSchema fieldSchema : derivedSchema) {
                if (this.createVwDesc.getPartColNames().contains(fieldSchema.getName())) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(HiveUtils.unparseIdentifier(fieldSchema.getName(), (Configuration)this.conf));
            }
            for (String partColName : this.createVwDesc.getPartColNames()) {
                sb.append(", ");
                sb.append(HiveUtils.unparseIdentifier(partColName, (Configuration)this.conf));
            }
            sb.append(" FROM (");
            sb.append(expandedText);
            sb.append(") ");
            sb.append(HiveUtils.unparseIdentifier(Utilities.getDbTableName(this.createVwDesc.getViewName())[1], (Configuration)this.conf));
            expandedText = sb.toString();
        }
        this.createVwDesc.setCols(derivedSchema);
        this.createVwDesc.setViewExpandedText(expandedText);
    }

    private List<FieldSchema> convertRowSchemaToViewSchema(RowResolver rr) throws SemanticException {
        List<FieldSchema> fieldSchema = this.convertRowSchemaToResultSetSchema(rr, false);
        ParseUtils.validateColumnNameUniqueness(fieldSchema);
        return fieldSchema;
    }

    List<FieldSchema> convertRowSchemaToResultSetSchema(RowResolver rr, boolean useTabAliasIfAvailable) {
        ArrayList<FieldSchema> fieldSchemas = new ArrayList<FieldSchema>();
        for (ColumnInfo colInfo : rr.getColumnInfos()) {
            if (colInfo.isHiddenVirtualCol()) continue;
            String[] qualifiedColName = rr.reverseLookup(colInfo.getInternalName());
            Object colName = useTabAliasIfAvailable && qualifiedColName[0] != null && !qualifiedColName[0].isEmpty() && !qualifiedColName[0].startsWith("__u") ? qualifiedColName[0] + "." + qualifiedColName[1] : qualifiedColName[1];
            fieldSchemas.add(new FieldSchema((String)colName, colInfo.getType().getTypeName(), null));
        }
        return fieldSchemas;
    }

    public ExprNodeDesc genExprNodeDesc(ASTNode expr, RowResolver input) throws SemanticException {
        return this.genExprNodeDesc(expr, input, true, false);
    }

    public ExprNodeDesc genExprNodeDesc(ASTNode expr, RowResolver input, boolean useCaching, boolean foldExpr) throws SemanticException {
        TypeCheckCtx tcCtx = new TypeCheckCtx(input, useCaching, foldExpr);
        return this.genExprNodeDesc(expr, input, tcCtx);
    }

    Map<ASTNode, ExprNodeDesc> genAllExprNodeDesc(ASTNode expr, RowResolver input) throws SemanticException {
        TypeCheckCtx tcCtx = new TypeCheckCtx(input);
        return this.genAllExprNodeDesc(expr, input, tcCtx);
    }

    ExprNodeDesc genExprNodeDesc(ASTNode expr, RowResolver input, TypeCheckCtx tcCtx) throws SemanticException {
        ExprNodeDesc cached = null;
        if (tcCtx.isUseCaching()) {
            cached = this.getExprNodeDescCached(expr, input);
        }
        if (cached == null) {
            Map<ASTNode, ExprNodeDesc> allExprs = this.genAllExprNodeDesc(expr, input, tcCtx);
            return allExprs.get(expr);
        }
        return cached;
    }

    private ExprNodeDesc getExprNodeDescCached(ASTNode expr, RowResolver input) throws SemanticException {
        ColumnInfo colInfo = input.getExpression(expr);
        if (colInfo != null) {
            ASTNode source = input.getExpressionSource(expr);
            if (source != null) {
                this.unparseTranslator.addCopyTranslation(expr, source);
            }
            return new ExprNodeColumnDesc(colInfo.getType(), colInfo.getInternalName(), colInfo.getTabAlias(), colInfo.getIsVirtualCol(), colInfo.isSkewedCol());
        }
        return null;
    }

    Map<ASTNode, ExprNodeDesc> genAllExprNodeDesc(ASTNode expr, RowResolver input, TypeCheckCtx tcCtx) throws SemanticException {
        tcCtx.setUnparseTranslator(this.unparseTranslator);
        Map<ASTNode, ExprNodeDesc> nodeOutputs = ExprNodeTypeCheck.genExprNode(expr, tcCtx);
        ExprNodeDesc desc = nodeOutputs.get(expr);
        if (desc == null) {
            String tableOrCol = BaseSemanticAnalyzer.unescapeIdentifier(expr.getChild(0).getText());
            ColumnInfo colInfo = input.get(null, tableOrCol);
            String errMsg = colInfo == null && input.getIsExprResolver() ? ASTErrorUtils.getMsg((String)ErrorMsg.NON_KEY_EXPR_IN_GROUPBY.getMsg(), (ASTNode)expr) : tcCtx.getError();
            throw new SemanticException(Optional.ofNullable(errMsg).orElse("Error in parsing "));
        }
        if (desc instanceof ExprNodeColumnListDesc) {
            throw new SemanticException("TOK_ALLCOLREF is not supported in current context");
        }
        if (!this.unparseTranslator.isEnabled()) {
            return nodeOutputs;
        }
        ArrayList<ASTNode> fieldDescList = new ArrayList<ASTNode>();
        for (Map.Entry<ASTNode, ExprNodeDesc> entry : nodeOutputs.entrySet()) {
            if (!(entry.getValue() instanceof ExprNodeColumnDesc)) {
                if (!(entry.getValue() instanceof ExprNodeFieldDesc)) continue;
                fieldDescList.add(entry.getKey());
                continue;
            }
            ASTNode node = entry.getKey();
            ExprNodeColumnDesc columnDesc = (ExprNodeColumnDesc)entry.getValue();
            if (columnDesc.getTabAlias() == null || columnDesc.getTabAlias().length() == 0) continue;
            String[] tmp = input.reverseLookup(columnDesc.getColumn());
            if (tcCtx.getOuterRR() != null && (tmp == null || tmp[0] != null && columnDesc.getTabAlias() != null && !tmp[0].equals(columnDesc.getTabAlias()))) {
                tmp = tcCtx.getOuterRR().reverseLookup(columnDesc.getColumn());
            }
            StringBuilder replacementText = new StringBuilder();
            replacementText.append(HiveUtils.unparseIdentifier(tmp[0], (Configuration)this.conf));
            replacementText.append(".");
            replacementText.append(HiveUtils.unparseIdentifier(tmp[1], (Configuration)this.conf));
            this.unparseTranslator.addTranslation(node, replacementText.toString());
        }
        for (ASTNode node : fieldDescList) {
            Map<ASTNode, String> map = SemanticAnalyzer.translateFieldDesc(node, this.conf);
            for (Map.Entry<ASTNode, String> entry : map.entrySet()) {
                this.unparseTranslator.addTranslation(entry.getKey(), entry.getValue().toLowerCase());
            }
        }
        return nodeOutputs;
    }

    public static final Map<ASTNode, String> translateFieldDesc(ASTNode node, HiveConf conf) {
        HashMap<ASTNode, String> map = new HashMap<ASTNode, String>();
        if (node.getType() == 16) {
            for (Node child : node.getChildren()) {
                map.putAll(SemanticAnalyzer.translateFieldDesc((ASTNode)child, conf));
            }
        } else if (node.getType() == 24) {
            map.put(node, HiveUtils.unparseIdentifier(node.getText(), (Configuration)conf));
        }
        return map;
    }

    @Override
    public void validate() throws SemanticException {
        org.apache.hadoop.hive.ql.metadata.Table tbl;
        Entity.Type type;
        boolean wasAcidChecked = false;
        for (ReadEntity readEntity : this.getAllInputs()) {
            type = readEntity.getType();
            if (type != Entity.Type.TABLE && type != Entity.Type.PARTITION) continue;
            tbl = readEntity.getTable();
            org.apache.hadoop.hive.ql.metadata.Partition p = readEntity.getPartition();
            if (p != null) {
                tbl = p.getTable();
            }
            if (tbl == null || !AcidUtils.isTransactionalTable(tbl)) continue;
            this.transactionalInQuery = true;
            if (!wasAcidChecked) {
                this.checkAcidTxnManager(tbl);
            }
            wasAcidChecked = true;
        }
        for (WriteEntity writeEntity : this.getAllOutputs()) {
            type = writeEntity.getType();
            if (type == Entity.Type.PARTITION || type == Entity.Type.DUMMYPARTITION) {
                String conflictingArchive = null;
                try {
                    org.apache.hadoop.hive.ql.metadata.Partition usedp = writeEntity.getPartition();
                    org.apache.hadoop.hive.ql.metadata.Table tbl2 = usedp.getTable();
                    if (AcidUtils.isTransactionalTable(tbl2)) {
                        this.transactionalInQuery = true;
                        if (!wasAcidChecked) {
                            this.checkAcidTxnManager(tbl2);
                        }
                        wasAcidChecked = true;
                    }
                    this.LOG.debug("validated " + usedp.getName());
                    this.LOG.debug(usedp.getTable().getTableName());
                    if (!AcidUtils.isTransactionalTable(tbl2) && this.conf.getBoolVar(HiveConf.ConfVars.HIVE_ARCHIVE_ENABLED)) {
                        conflictingArchive = ArchiveUtils.conflictingArchiveNameOrNull(this.db, tbl2, usedp.getSpec());
                    }
                }
                catch (HiveException e) {
                    throw new SemanticException((Throwable)e);
                }
                if (conflictingArchive != null) {
                    String message = String.format("Insert conflict with existing archive: %s", conflictingArchive);
                    throw new SemanticException(message);
                }
            } else if (type == Entity.Type.TABLE && AcidUtils.isTransactionalTable(tbl = writeEntity.getTable())) {
                this.transactionalInQuery = true;
                if (!wasAcidChecked) {
                    this.checkAcidTxnManager(tbl);
                }
                wasAcidChecked = true;
            }
            if (type == Entity.Type.TABLE || type == Entity.Type.PARTITION) continue;
            this.LOG.debug("not validating writeEntity, because entity is neither table nor partition");
        }
        boolean reworkMapredWork = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_REWORK_MAPREDWORK);
        for (Task rootTask : this.rootTasks) {
            this.validate(rootTask, reworkMapredWork);
        }
    }

    private void validate(Task<?> task, boolean reworkMapredWork) throws SemanticException {
        Utilities.reworkMapRedWork(task, reworkMapredWork, this.conf);
        if (task.getChildTasks() == null) {
            return;
        }
        for (Task<?> childTask : task.getChildTasks()) {
            this.validate(childTask, reworkMapredWork);
        }
    }

    protected Map<String, String> convertToAcidByDefault(StorageFormat storageFormat, String qualifiedTableName, List<Order> sortCols, Map<String, String> retValue) {
        try {
            Class<?> outputFormatClass;
            Class<?> inputFormatClass = storageFormat.getInputFormat() == null ? null : Class.forName(storageFormat.getInputFormat());
            Class<?> clazz = outputFormatClass = storageFormat.getOutputFormat() == null ? null : Class.forName(storageFormat.getOutputFormat());
            if (inputFormatClass == null || outputFormatClass == null || !AcidInputFormat.class.isAssignableFrom(inputFormatClass) || !AcidOutputFormat.class.isAssignableFrom(outputFormatClass)) {
                return retValue;
            }
        }
        catch (ClassNotFoundException e) {
            this.LOG.warn("Could not verify InputFormat=" + storageFormat.getInputFormat() + " or OutputFormat=" + storageFormat.getOutputFormat() + "  for " + qualifiedTableName);
            return retValue;
        }
        if (sortCols != null && !sortCols.isEmpty()) {
            return retValue;
        }
        retValue.put("transactional", "true");
        retValue.put("transactional_properties", "default");
        this.LOG.info("Automatically chose to make " + qualifiedTableName + " acid.");
        return retValue;
    }

    protected void validateStorageFormat(StorageFormat storageFormat, Map<String, String> tblProps, boolean partitionTransformSpecExists) throws SemanticException {
        HiveStorageHandler handler;
        try {
            handler = HiveUtils.getStorageHandler((Configuration)this.conf, storageFormat.getStorageHandler());
        }
        catch (HiveException e) {
            throw new SemanticException("Failed to load storage handler:  " + e.getMessage());
        }
        if (handler != null) {
            if (partitionTransformSpecExists && !handler.supportsPartitionTransform()) {
                throw new SemanticException("Partition transform is not supported for " + handler.getClass().getName());
            }
            String fileFormatPropertyKey = handler.getFileFormatPropertyKey();
            if (fileFormatPropertyKey != null && tblProps != null && tblProps.containsKey(fileFormatPropertyKey) && storageFormat.getSerdeProps() != null && storageFormat.getSerdeProps().containsKey(fileFormatPropertyKey)) {
                String fileFormat = tblProps.get(fileFormatPropertyKey);
                throw new SemanticException("Provide only one of the following: STORED BY " + fileFormat + " or WITH SERDEPROPERTIES('" + fileFormatPropertyKey + "'='" + fileFormat + "') or TBLPROPERTIES('" + fileFormatPropertyKey + "'='" + fileFormat + "')");
            }
        } else if (partitionTransformSpecExists) {
            throw new SemanticException(ErrorMsg.UNEXPECTED_PARTITION_TRANSFORM_SPEC.getMsg());
        }
    }

    protected void addDbAndTabToOutputs(String[] qualifiedTabName, TableType type, boolean isTemporary, Map<String, String> tblProps, StorageFormat storageFormat) throws SemanticException {
        Database database = this.getDatabase(qualifiedTabName[0]);
        this.outputs.add(new WriteEntity(database, WriteEntity.WriteType.DDL_SHARED));
        org.apache.hadoop.hive.ql.metadata.Table t = new org.apache.hadoop.hive.ql.metadata.Table(qualifiedTabName[0], qualifiedTabName[1]);
        t.setParameters(tblProps);
        t.setTableType(type);
        t.setTemporary(isTemporary);
        HiveStorageHandler storageHandler = null;
        if (storageFormat.getStorageHandler() != null) {
            try {
                storageHandler = (HiveStorageHandler)ReflectionUtils.newInstance((Class)this.conf.getClassByName(storageFormat.getStorageHandler()), (Configuration)SessionState.get().getConf());
                t.setProperty("storage_handler", storageHandler.getClass().getName());
            }
            catch (ClassNotFoundException ex) {
                this.LOG.error("Class not found. Storage handler will be set to null: " + ex.getMessage(), (Throwable)ex);
            }
        }
        t.setStorageHandler(storageHandler);
        for (Map.Entry<String, String> serdeMap : storageFormat.getSerdeProps().entrySet()) {
            t.setSerdeParam(serdeMap.getKey(), serdeMap.getValue());
        }
        WriteEntity.WriteType lockType = tblProps != null && Boolean.parseBoolean(tblProps.get("created_with_ctas")) && AcidUtils.isExclusiveCTASEnabled((Configuration)this.conf) && (t.getStorageHandler() == null || !t.getStorageHandler().directInsert()) ? WriteEntity.WriteType.CTAS : WriteEntity.WriteType.DDL_NO_LOCK;
        this.outputs.add(new WriteEntity(t, lockType));
    }

    protected ASTNode analyzeCreateView(ASTNode ast, QB qb, PlannerContext plannerCtx) throws SemanticException {
        TableName qualTabName = SemanticAnalyzer.getQualifiedTableName((ASTNode)ast.getChild(0));
        String dbDotTable = qualTabName.getNotEmptyDbTable();
        List<FieldSchema> cols = null;
        boolean ifNotExists = false;
        boolean rewriteEnabled = true;
        String comment = null;
        ASTNode selectStmt = null;
        Map<String, String> tblProps = null;
        List<String> partColNames = null;
        List<String> sortColNames = null;
        List<String> distributeColNames = null;
        String location = null;
        BaseSemanticAnalyzer.RowFormatParams rowFormatParams = new BaseSemanticAnalyzer.RowFormatParams();
        StorageFormat storageFormat = new StorageFormat((Configuration)this.conf);
        boolean partitionTransformSpecExists = false;
        this.LOG.info("Creating view " + dbDotTable + " position=" + ast.getCharPositionInLine());
        int numCh = ast.getChildCount();
        this.queryProperties.setQueryType(QueryProperties.QueryType.DDL);
        block18: for (int num = 1; num < numCh; ++num) {
            ASTNode child = (ASTNode)ast.getChild(num);
            if (storageFormat.fillStorageFormat(child)) continue;
            switch (child.getToken().getType()) {
                case 1055: {
                    ifNotExists = true;
                    continue block18;
                }
                case 1187: {
                    rewriteEnabled = false;
                    continue block18;
                }
                case 1161: {
                    if (plannerCtx != null) {
                        plannerCtx.setViewToken(child);
                    }
                    selectStmt = child;
                    continue block18;
                }
                case 1253: {
                    cols = this.getColumns(child);
                    continue block18;
                }
                case 1258: {
                    comment = SemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    continue block18;
                }
                case 1264: {
                    tblProps = SemanticAnalyzer.getProps((ASTNode)child.getChild(0));
                    continue block18;
                }
                case 1321: {
                    partColNames = SemanticAnalyzer.getColumnNames((ASTNode)child.getChild(0));
                    continue block18;
                }
                case 1319: {
                    assert (distributeColNames == null && sortColNames == null);
                    distributeColNames = SemanticAnalyzer.getColumnNames((ASTNode)child.getChild(0));
                    sortColNames = new ArrayList<String>(distributeColNames);
                    continue block18;
                }
                case 1320: {
                    assert (distributeColNames == null);
                    distributeColNames = SemanticAnalyzer.getColumnNames((ASTNode)child.getChild(0));
                    continue block18;
                }
                case 1322: {
                    assert (sortColNames == null);
                    sortColNames = SemanticAnalyzer.getColumnNames((ASTNode)child.getChild(0));
                    continue block18;
                }
                case 1267: {
                    rowFormatParams.analyzeRowFormat(child);
                    continue block18;
                }
                case 1260: {
                    location = SemanticAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    location = EximUtil.relativeToAbsolutePath(this.conf, location);
                    this.inputs.add(this.toReadEntity(location));
                    continue block18;
                }
                case 1273: {
                    child = (ASTNode)child.getChild(0);
                    storageFormat.setSerde(SemanticAnalyzer.unescapeSQLString(child.getChild(0).getText()));
                    if (child.getChildCount() != 2) continue block18;
                    SemanticAnalyzer.readProps((ASTNode)child.getChild(1).getChild(0), storageFormat.getSerdeProps());
                    continue block18;
                }
                case 1263: {
                    SessionStateUtil.addResourceOrThrow((Configuration)this.conf, "partition_transform_spec", PartitionTransform.getPartitionTransformSpec(child));
                    partitionTransformSpecExists = true;
                    continue block18;
                }
                default: {
                    assert (false);
                    continue block18;
                }
            }
        }
        this.validateStorageFormat(storageFormat, tblProps, partitionTransformSpecExists);
        storageFormat.fillDefaultStorageFormat(false, true);
        if (!ifNotExists) {
            try {
                org.apache.hadoop.hive.ql.metadata.Table dumpTable = this.db.newTable(dbDotTable);
                if (null != this.db.getTable(dumpTable.getDbName(), dumpTable.getTableName(), false) && !this.ctx.isExplainSkipExecution()) {
                    throw new SemanticException(ErrorMsg.TABLE_ALREADY_EXISTS.getMsg(dbDotTable));
                }
            }
            catch (HiveException e) {
                throw new SemanticException((Throwable)e);
            }
        }
        if (partColNames != null && (distributeColNames != null || sortColNames != null)) {
            HashSet<String> partColNamesSet = new HashSet<String>(partColNames);
            if (distributeColNames != null) {
                for (String colName : distributeColNames) {
                    if (!partColNamesSet.contains(colName)) continue;
                    throw new SemanticException("Same column cannot be present in partition and cluster/distribute clause. Column name: " + colName);
                }
            }
            if (sortColNames != null) {
                for (String colName : sortColNames) {
                    if (!partColNamesSet.contains(colName)) continue;
                    throw new SemanticException("Same column cannot be present in partition and cluster/sort clause. Column name: " + colName);
                }
            }
        }
        this.unparseTranslator.enable();
        if (this.makeAcid()) {
            if (tblProps == null) {
                tblProps = new HashMap<String, String>();
            }
            tblProps = this.convertToAcidByDefault(storageFormat, dbDotTable, null, tblProps);
        }
        if (tblProps == null) {
            tblProps = new HashMap<String, String>();
        }
        tblProps.put("created_with_ctas", "true");
        this.createVwDesc = new CreateMaterializedViewDesc(dbDotTable, cols, comment, tblProps, partColNames, sortColNames, distributeColNames, ifNotExists, rewriteEnabled, storageFormat.getInputFormat(), storageFormat.getOutputFormat(), location, storageFormat.getSerde(), storageFormat.getStorageHandler(), storageFormat.getSerdeProps());
        this.addDbAndTabToOutputs(new String[]{qualTabName.getDb(), qualTabName.getTable()}, TableType.MATERIALIZED_VIEW, false, tblProps, storageFormat);
        this.queryState.setCommandType(HiveOperation.CREATE_MATERIALIZED_VIEW);
        qb.setViewDesc(this.createVwDesc);
        return selectStmt;
    }

    protected boolean makeAcid() {
        return MetastoreConf.getBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.CREATE_TABLES_AS_ACID) && HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SUPPORT_CONCURRENCY) && DbTxnManager.class.getCanonicalName().equals(HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_TXN_MANAGER));
    }

    private void validateCreateView() throws SemanticException {
        try {
            AbstractCreateViewAnalyzer.validateTablesUsed(this);
            if (this.createVwDesc.isRewriteEnabled()) {
                int nativeAcidCount = 0;
                int supportsSnapshotCount = 0;
                for (TableScanOperator ts : this.topOps.values()) {
                    org.apache.hadoop.hive.ql.metadata.Table table = ((TableScanDesc)ts.getConf()).getTableMetadata();
                    if (DUMMY_TABLE.equals(table.getTableName())) continue;
                    if (AcidUtils.isTransactionalTable(table)) {
                        ++nativeAcidCount;
                    } else if (table.isNonNative() && table.getStorageHandler().areSnapshotsSupported()) {
                        ++supportsSnapshotCount;
                    } else {
                        throw new SemanticException("Automatic rewriting for materialized view cannot be enabled if the materialized view uses non-transactional tables");
                    }
                    if (!StringUtils.isNotBlank((CharSequence)((TableScanDesc)ts.getConf()).getAsOfTimestamp()) && !StringUtils.isNotBlank((CharSequence)((TableScanDesc)ts.getConf()).getAsOfVersion())) continue;
                    throw new SemanticException("Automatic rewriting for materialized view cannot be enabled if the materialized view uses time travel query.");
                }
                if (nativeAcidCount > 0 && supportsSnapshotCount > 0) {
                    throw new SemanticException("All materialized view source tables either must be native ACID tables or must support table snapshots.");
                }
            }
            if (!this.qb.hasTableDefined()) {
                throw new SemanticException("Materialized view must have a table defined.");
            }
            if (this.createVwDesc.isRewriteEnabled()) {
                String errorMessage;
                if (!this.ctx.isCboSucceeded()) {
                    Object msg = "Cannot enable automatic rewriting for materialized view.";
                    msg = this.ctx.getCboInfo() != null ? (String)msg + " " + this.ctx.getCboInfo() : (String)msg + " Check CBO is turned on: set " + HiveConf.ConfVars.HIVE_CBO_ENABLED.varname;
                    throw new SemanticException((String)msg);
                }
                if (this.materializationValidationResult.getSupportedRewriteAlgorithms().isEmpty()) {
                    this.createVwDesc.setRewriteEnabled(false);
                }
                if (StringUtils.isNotBlank((CharSequence)(errorMessage = this.materializationValidationResult.getErrorMessage()))) {
                    this.console.printError(errorMessage);
                }
            }
        }
        catch (HiveException e) {
            throw new SemanticException(e.getMessage(), (Throwable)e);
        }
    }

    void processPositionAlias(ASTNode ast) throws SemanticException {
        boolean isBothByPos = HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_GROUPBY_ORDERBY_POSITION_ALIAS);
        boolean isGbyByPos = isBothByPos || HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_GROUPBY_POSITION_ALIAS);
        boolean isObyByPos = isBothByPos || HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_ORDERBY_POSITION_ALIAS);
        ArrayDeque<ASTNode> stack = new ArrayDeque<ASTNode>();
        stack.push(ast);
        while (!stack.isEmpty()) {
            ASTNode next = (ASTNode)stack.pop();
            if (next.getChildCount() == 0) continue;
            ASTNode selectNode = null;
            ASTNode groupbyNode = null;
            ASTNode orderbyNode = null;
            int child_count = next.getChildCount();
            for (int child_pos = 0; child_pos < child_count; ++child_pos) {
                ASTNode node = (ASTNode)next.getChild(child_pos);
                int type = node.getToken().getType();
                if (type == 1196 || type == 1197) {
                    selectNode = node;
                    continue;
                }
                if (type == 1048) {
                    groupbyNode = node;
                    continue;
                }
                if (type != 1130) continue;
                orderbyNode = node;
            }
            if (selectNode != null) {
                int selectExpCnt = selectNode.getChildCount();
                if (groupbyNode != null) {
                    for (int child_pos = 0; child_pos < groupbyNode.getChildCount(); ++child_pos) {
                        ASTNode node = (ASTNode)groupbyNode.getChild(child_pos);
                        if (node.getToken().getType() != 427) continue;
                        if (isGbyByPos) {
                            int pos = Integer.parseInt(node.getText());
                            if (pos > 0 && pos <= selectExpCnt) {
                                groupbyNode.setChild(child_pos, selectNode.getChild(pos - 1).getChild(0));
                                continue;
                            }
                            throw new SemanticException(ErrorMsg.INVALID_POSITION_ALIAS_IN_GROUPBY.getMsg("Position alias: " + pos + " does not exist\nThe Select List is indexed from 1 to " + selectExpCnt));
                        }
                        this.warn("Using constant number  " + node.getText() + " in group by. If you try to use position alias when hive.groupby.position.alias is false, the position alias will be ignored.");
                    }
                }
                if (!HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CBO_ENABLED) && orderbyNode != null) {
                    int child_pos;
                    boolean isAllCol = false;
                    for (child_pos = 0; child_pos < selectNode.getChildCount(); ++child_pos) {
                        ASTNode node = (ASTNode)selectNode.getChild(child_pos).getChild(0);
                        if (node == null || node.getToken().getType() != 843) continue;
                        isAllCol = true;
                    }
                    for (child_pos = 0; child_pos < orderbyNode.getChildCount(); ++child_pos) {
                        ASTNode colNode = null;
                        ASTNode node = null;
                        if (orderbyNode.getChildCount() > 0 && (colNode = (ASTNode)orderbyNode.getChild(child_pos).getChild(0)).getChildCount() > 0) {
                            node = (ASTNode)colNode.getChild(0);
                        }
                        if (node == null || node.getToken().getType() != 427) continue;
                        if (isObyByPos) {
                            if (!isAllCol) {
                                int pos = Integer.parseInt(node.getText());
                                if (pos > 0 && pos <= selectExpCnt && selectNode.getChild(pos - 1).getChildCount() > 0) {
                                    colNode.setChild(0, selectNode.getChild(pos - 1).getChild(0));
                                    continue;
                                }
                                throw new SemanticException(ErrorMsg.INVALID_POSITION_ALIAS_IN_ORDERBY.getMsg("Position alias: " + pos + " does not exist\nThe Select List is indexed from 1 to " + selectExpCnt));
                            }
                            throw new SemanticException(ErrorMsg.NO_SUPPORTED_ORDERBY_ALLCOLREF_POS.getMsg());
                        }
                        this.warn("Using constant number " + node.getText() + " in order by. If you try to use position alias when hive.orderby.position.alias is false, the position alias will be ignored.");
                    }
                }
            }
            List childrenList = next.getChildren();
            for (int i = childrenList.size() - 1; i >= 0; --i) {
                stack.push((ASTNode)childrenList.get(i));
            }
        }
    }

    protected void processNoScanCommand(ASTNode tree) throws SemanticException {
        this.checkNoScan(tree);
        if (this.noscan) {
            this.validateAnalyzeNoscan(tree);
        }
    }

    private void validateAnalyzeNoscan(ASTNode tree) throws SemanticException {
        org.apache.hadoop.hive.ql.metadata.Table tbl;
        String tableName = SemanticAnalyzer.getUnescapedName((ASTNode)tree.getChild(0).getChild(0));
        try {
            tbl = this.getTableObjectByName(tableName);
        }
        catch (InvalidTableException e) {
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(tableName), (Throwable)((Object)e));
        }
        catch (HiveException e) {
            throw new SemanticException(e.getMessage(), (Throwable)e);
        }
        if (tbl.isNonNative()) {
            throw new SemanticException(ErrorMsg.ANALYZE_TABLE_NOSCAN_NON_NATIVE.getMsg(tbl.getTableName()));
        }
    }

    private void checkNoScan(ASTNode tree) {
        ASTNode child1;
        ASTNode child0;
        if (tree.getChildCount() > 1 && (child0 = (ASTNode)tree.getChild(0)).getToken().getType() == 1249 && (child0 = (ASTNode)child0.getChild(0)).getToken().getType() == 1279 && (child1 = (ASTNode)tree.getChild(1)).getToken().getType() == 233) {
            this.noscan = true;
        }
    }

    public QB getQB() {
        return this.qb;
    }

    void setQB(QB qb) {
        this.qb = qb;
    }

    private PTFInvocationSpec.PTFInputSpec processPTFSource(QB qb, ASTNode inputNode) throws SemanticException {
        PTFInvocationSpec.PTFInputSpec qInSpec = null;
        int type = inputNode.getType();
        switch (type) {
            case 1280: {
                String alias = this.processTable(qb, inputNode);
                qInSpec = new PTFInvocationSpec.PTFQueryInputSpec();
                ((PTFInvocationSpec.PTFQueryInputSpec)qInSpec).setType(PTFInvocationSpec.PTFQueryInputType.TABLE);
                ((PTFInvocationSpec.PTFQueryInputSpec)qInSpec).setSource(alias);
                break;
            }
            case 1242: {
                String alias = this.processSubQuery(qb, inputNode);
                qInSpec = new PTFInvocationSpec.PTFQueryInputSpec();
                ((PTFInvocationSpec.PTFQueryInputSpec)qInSpec).setType(PTFInvocationSpec.PTFQueryInputType.SUBQUERY);
                ((PTFInvocationSpec.PTFQueryInputSpec)qInSpec).setSource(alias);
                break;
            }
            case 1159: {
                qInSpec = this.processPTFChain(qb, inputNode);
                break;
            }
            default: {
                throw new SemanticException(SemanticAnalyzer.generateErrorMessage(inputNode, "Unknown input type to PTF"));
            }
        }
        qInSpec.setAstNode(inputNode);
        return qInSpec;
    }

    private PTFInvocationSpec.PartitionedTableFunctionSpec processPTFChain(QB qb, ASTNode ptf) throws SemanticException {
        ASTNode pSpecNode;
        int child_count = ptf.getChildCount();
        if (child_count < 2) {
            throw new SemanticException(SemanticAnalyzer.generateErrorMessage(ptf, "Not enough Children " + child_count));
        }
        PTFInvocationSpec.PartitionedTableFunctionSpec ptfSpec = new PTFInvocationSpec.PartitionedTableFunctionSpec();
        ptfSpec.setAstNode(ptf);
        ASTNode nameNode = (ASTNode)ptf.getChild(0);
        ptfSpec.setName(nameNode.getText());
        int inputIdx = 1;
        ASTNode secondChild = (ASTNode)ptf.getChild(1);
        if (secondChild.getType() == 24) {
            ptfSpec.setAlias(secondChild.getText());
            ++inputIdx;
        }
        ASTNode inputNode = (ASTNode)ptf.getChild(inputIdx);
        ptfSpec.setInput(this.processPTFSource(qb, inputNode));
        int argStartIdx = inputIdx + 1;
        int pSpecIdx = inputIdx + 1;
        ASTNode aSTNode = pSpecNode = ptf.getChildCount() > inputIdx ? (ASTNode)ptf.getChild(pSpecIdx) : null;
        if (pSpecNode != null && pSpecNode.getType() == 1134) {
            PTFInvocationSpec.PartitioningSpec partitioning = this.processPTFPartitionSpec(pSpecNode);
            ptfSpec.setPartitioning(partitioning);
            ++argStartIdx;
        }
        for (int i = argStartIdx; i < ptf.getChildCount(); ++i) {
            ptfSpec.addArg((ASTNode)ptf.getChild(i));
        }
        return ptfSpec;
    }

    private void processPTF(QB qb, ASTNode ptf) throws SemanticException {
        PTFInvocationSpec.PartitionedTableFunctionSpec ptfSpec = this.processPTFChain(qb, ptf);
        Optional.ofNullable(ptfSpec.getAlias()).ifPresent(qb::addAlias);
        PTFInvocationSpec spec = new PTFInvocationSpec();
        spec.setFunction(ptfSpec);
        qb.addPTFNodeToSpec(ptf, spec);
    }

    private void handleQueryWindowClauses(QB qb, Phase1Ctx ctx_1, ASTNode node) throws SemanticException {
        WindowingSpec spec = qb.getWindowingSpec(ctx_1.dest);
        for (Node child : node.getChildren()) {
            this.processQueryWindowClause(spec, (ASTNode)child);
        }
    }

    private PTFInvocationSpec.PartitionSpec processPartitionSpec(ASTNode node) {
        PTFInvocationSpec.PartitionSpec pSpec = new PTFInvocationSpec.PartitionSpec();
        for (Node child : node.getChildren()) {
            PTFInvocationSpec.PartitionExpression exprSpec = new PTFInvocationSpec.PartitionExpression();
            exprSpec.setExpression((ASTNode)child);
            pSpec.addExpression(exprSpec);
        }
        return pSpec;
    }

    private PTFInvocationSpec.PartitioningSpec processPTFPartitionSpec(ASTNode pSpecNode) {
        PTFInvocationSpec.PartitioningSpec partitioning = new PTFInvocationSpec.PartitioningSpec();
        ASTNode firstChild = (ASTNode)pSpecNode.getChild(0);
        int type = firstChild.getType();
        if (type == 1002 || type == 946) {
            ASTNode sortNode;
            PTFInvocationSpec.PartitionSpec pSpec = this.processPartitionSpec(firstChild);
            partitioning.setPartSpec(pSpec);
            ASTNode aSTNode = sortNode = pSpecNode.getChildCount() > 1 ? (ASTNode)pSpecNode.getChild(1) : null;
            if (sortNode != null) {
                PTFInvocationSpec.OrderSpec oSpec = this.processOrderSpec(sortNode);
                partitioning.setOrderSpec(oSpec);
            }
        } else if (type == 1235 || type == 1130) {
            PTFInvocationSpec.OrderSpec oSpec = this.processOrderSpec(firstChild);
            partitioning.setOrderSpec(oSpec);
        }
        return partitioning;
    }

    private WindowingSpec.WindowFunctionSpec processWindowFunction(ASTNode node, ASTNode wsNode) throws SemanticException {
        WindowingSpec.WindowFunctionSpec wfSpec = new WindowingSpec.WindowFunctionSpec();
        switch (node.getType()) {
            case 1041: {
                wfSpec.setStar(true);
                break;
            }
            case 1040: {
                wfSpec.setDistinct(true);
            }
        }
        wfSpec.setExpression(node);
        ASTNode nameNode = (ASTNode)node.getChild(0);
        wfSpec.setName(nameNode.getText());
        for (int i = 1; i < node.getChildCount() - 1; ++i) {
            ASTNode child = (ASTNode)node.getChild(i);
            wfSpec.addArg(child);
        }
        if (wsNode != null) {
            WindowFunctionInfo functionInfo = FunctionRegistry.getWindowFunctionInfo(wfSpec.name);
            if (functionInfo == null) {
                throw new SemanticException(ErrorMsg.INVALID_FUNCTION.getMsg(wfSpec.name));
            }
            wfSpec.setRespectNulls(this.processRespectIgnoreNulls(functionInfo, wsNode));
            wfSpec.setWindowSpec(this.processWindowSpec(wsNode));
        }
        return wfSpec;
    }

    private boolean processRespectIgnoreNulls(WindowFunctionInfo functionInfo, ASTNode node) throws SemanticException {
        for (int i = 0; i < node.getChildCount(); ++i) {
            int type = node.getChild(i).getType();
            switch (type) {
                case 1182: {
                    if (!functionInfo.isSupportsNullTreatment()) {
                        throw new SemanticException(ErrorMsg.NULL_TREATMENT_NOT_SUPPORTED, new String[]{functionInfo.getDisplayName()});
                    }
                    return true;
                }
                case 1056: {
                    if (!functionInfo.isSupportsNullTreatment()) {
                        throw new SemanticException(ErrorMsg.NULL_TREATMENT_NOT_SUPPORTED, new String[]{functionInfo.getDisplayName()});
                    }
                    return false;
                }
            }
        }
        return true;
    }

    private boolean containsLeadLagUDF(ASTNode expressionTree) {
        int exprTokenType = expressionTree.getToken().getType();
        if (exprTokenType == 1039) {
            assert (expressionTree.getChildCount() != 0);
            if (expressionTree.getChild(0).getType() == 24) {
                String functionName = SemanticAnalyzer.unescapeIdentifier(expressionTree.getChild(0).getText());
                if ("lag".equals(functionName = functionName.toLowerCase()) || "lead".equals(functionName)) {
                    return true;
                }
            }
        }
        for (int i = 0; i < expressionTree.getChildCount(); ++i) {
            if (!this.containsLeadLagUDF((ASTNode)expressionTree.getChild(i))) continue;
            return true;
        }
        return false;
    }

    private void processQueryWindowClause(WindowingSpec spec, ASTNode node) throws SemanticException {
        ASTNode nameNode = (ASTNode)node.getChild(0);
        ASTNode wsNode = (ASTNode)node.getChild(1);
        if (spec.getWindowSpecs() != null && spec.getWindowSpecs().containsKey(nameNode.getText())) {
            throw new SemanticException(SemanticAnalyzer.generateErrorMessage(nameNode, "Duplicate definition of window " + nameNode.getText() + " is not allowed"));
        }
        WindowingSpec.WindowSpec ws = this.processWindowSpec(wsNode);
        spec.addWindowSpec(nameNode.getText(), ws);
    }

    private WindowingSpec.WindowSpec processWindowSpec(ASTNode node) throws SemanticException {
        boolean hasSrcId = false;
        boolean hasPartSpec = false;
        boolean hasWF = false;
        int srcIdIdx = -1;
        int partIdx = -1;
        int wfIdx = -1;
        block5: for (int i = 0; i < node.getChildCount(); ++i) {
            int type = node.getChild(i).getType();
            switch (type) {
                case 24: {
                    hasSrcId = true;
                    srcIdIdx = i;
                    continue block5;
                }
                case 1134: {
                    hasPartSpec = true;
                    partIdx = i;
                    continue block5;
                }
                case 1325: 
                case 1327: {
                    hasWF = true;
                    wfIdx = i;
                }
            }
        }
        WindowingSpec.WindowSpec ws = new WindowingSpec.WindowSpec();
        if (hasSrcId) {
            ASTNode nameNode = (ASTNode)node.getChild(srcIdIdx);
            ws.setSourceId(nameNode.getText());
        }
        if (hasPartSpec) {
            ASTNode partNode = (ASTNode)node.getChild(partIdx);
            PTFInvocationSpec.PartitioningSpec partitioning = this.processPTFPartitionSpec(partNode);
            ws.setPartitioning(partitioning);
        }
        if (hasWF) {
            ASTNode wfNode = (ASTNode)node.getChild(wfIdx);
            WindowingSpec.WindowFrameSpec wfSpec = this.processWindowFrame(wfNode);
            ws.setWindowFrame(wfSpec);
        }
        return ws;
    }

    private WindowingSpec.WindowFrameSpec processWindowFrame(ASTNode node) throws SemanticException {
        int type = node.getType();
        WindowingSpec.BoundarySpec end = null;
        WindowingSpec.BoundarySpec start = this.processBoundary((ASTNode)node.getChild(0));
        if (node.getChildCount() > 1) {
            end = this.processBoundary((ASTNode)node.getChild(1));
        }
        return new WindowingSpec.WindowFrameSpec(type == 1327 ? WindowingSpec.WindowType.RANGE : WindowingSpec.WindowType.ROWS, start, end);
    }

    private WindowingSpec.BoundarySpec processBoundary(ASTNode node) throws SemanticException {
        WindowingSpec.BoundarySpec bs = new WindowingSpec.BoundarySpec();
        int type = node.getType();
        boolean hasAmt = true;
        switch (type) {
            case 267: {
                bs.setDirection(WindowingSpec.Direction.PRECEDING);
                break;
            }
            case 156: {
                bs.setDirection(WindowingSpec.Direction.FOLLOWING);
                break;
            }
            case 90: {
                bs.setDirection(WindowingSpec.Direction.CURRENT);
                hasAmt = false;
                break;
            }
        }
        if (hasAmt) {
            ASTNode amtNode = (ASTNode)node.getChild(0);
            if (amtNode.getType() == 376) {
                bs.setAmt(Integer.MAX_VALUE);
            } else {
                int amt = Integer.parseInt(amtNode.getText());
                if (amt < 0) {
                    throw new SemanticException("Window Frame Boundary Amount must be a non-negative integer, provided amount is: " + amt);
                }
                if (amt == 0) {
                    this.LOG.info("Converting 0 {} to CURRENT ROW", (Object)bs.getDirection());
                    bs.setDirection(WindowingSpec.Direction.CURRENT);
                    hasAmt = false;
                } else {
                    bs.setAmt(amt);
                }
            }
        }
        return bs;
    }

    private PTFDesc translatePTFInvocationSpec(PTFInvocationSpec ptfQSpec, RowResolver inputRR) throws SemanticException {
        PTFTranslator translator = new PTFTranslator();
        return translator.translate(ptfQSpec, this, this.conf, inputRR, this.unparseTranslator);
    }

    private Operator genPTFPlan(PTFInvocationSpec ptfQSpec, Operator input) throws SemanticException {
        ArrayList<PTFInvocationSpec> componentQueries = PTFTranslator.componentize(ptfQSpec);
        for (PTFInvocationSpec ptfSpec : componentQueries) {
            input = this.genPTFPlanForComponentQuery(ptfSpec, input);
        }
        this.LOG.debug("Created PTF Plan ");
        return input;
    }

    private void buildPTFReduceSinkDetails(PartitionedTableFunctionDef tabDef, List<ExprNodeDesc> partCols, List<ExprNodeDesc> orderCols, StringBuilder orderString, StringBuilder nullOrderString) {
        List<PTFExpressionDef> partColList = tabDef.getPartition().getExpressions();
        for (PTFExpressionDef colDef : partColList) {
            ExprNodeDesc exprNode = colDef.getExprNode();
            if (ExprNodeDescUtils.indexOf(exprNode, partCols) >= 0) continue;
            partCols.add(exprNode);
            orderCols.add(exprNode);
            orderString.append('+');
            nullOrderString.append('a');
        }
        List<OrderExpressionDef> orderColList = tabDef.getOrder().getExpressions();
        for (OrderExpressionDef colDef : orderColList) {
            char orderChar = colDef.getOrder() == PTFInvocationSpec.Order.ASC ? (char)'+' : '-';
            char nullOrderChar = colDef.getNullOrder() == PTFInvocationSpec.NullOrder.NULLS_FIRST ? (char)'a' : 'z';
            int index = ExprNodeDescUtils.indexOf(colDef.getExprNode(), orderCols);
            if (index >= 0) {
                orderString.setCharAt(index, orderChar);
                nullOrderString.setCharAt(index, nullOrderChar);
                continue;
            }
            orderCols.add(colDef.getExprNode());
            orderString.append(orderChar);
            nullOrderString.append(nullOrderChar);
        }
    }

    private Operator genPTFPlanForComponentQuery(PTFInvocationSpec ptfQSpec, Operator input) throws SemanticException {
        RowResolver rr = this.opParseCtx.get(input).getRowResolver();
        PTFDesc ptfDesc = this.translatePTFInvocationSpec(ptfQSpec, rr);
        PartitionedTableFunctionDef tabDef = ptfDesc.getStartOfChain();
        if (tabDef.isTransformsRawInput()) {
            RowResolver ptfMapRR = tabDef.getRawInputShape().getRr();
            ptfDesc.setMapSide(true);
            input = this.putOpInsertMap(OperatorFactory.getAndMakeChild(ptfDesc, new RowSchema(ptfMapRR.getColumnInfos()), (Operator)input, new Operator[0]), ptfMapRR);
            rr = this.opParseCtx.get(input).getRowResolver();
        }
        ArrayList<ExprNodeDesc> partCols = new ArrayList<ExprNodeDesc>();
        ArrayList<ExprNodeDesc> orderCols = new ArrayList<ExprNodeDesc>();
        StringBuilder orderString = new StringBuilder();
        StringBuilder nullOrderString = new StringBuilder();
        this.buildPTFReduceSinkDetails(tabDef, partCols, orderCols, orderString, nullOrderString);
        input = this.genReduceSinkPlan(input, partCols, orderCols, orderString.toString(), nullOrderString.toString(), -1, AcidUtils.Operation.NOT_ACID, false);
        rr = this.opParseCtx.get(input).getRowResolver();
        ptfDesc = this.translatePTFInvocationSpec(ptfQSpec, rr);
        RowResolver ptfOpRR = ptfDesc.getFuncDef().getOutputShape().getRr();
        input = this.putOpInsertMap(OperatorFactory.getAndMakeChild(ptfDesc, new RowSchema(ptfOpRR.getColumnInfos()), (Operator)input, new Operator[0]), ptfOpRR);
        return input;
    }

    private Operator genWindowingPlan(QB qb, WindowingSpec wSpec, Operator input) throws SemanticException {
        wSpec.validateAndMakeEffective();
        if (!this.isCBOExecuted() && !qb.getParseInfo().getDestToGroupBy().isEmpty()) {
            String selClauseName = qb.getParseInfo().getClauseNames().iterator().next();
            boolean cubeRollupGrpSetPresent = !qb.getParseInfo().getDestRollups().isEmpty() || !qb.getParseInfo().getDestGroupingSets().isEmpty() || !qb.getParseInfo().getDestCubes().isEmpty();
            for (WindowingSpec.WindowExpressionSpec wExprSpec : wSpec.getWindowExpressions()) {
                wExprSpec.setExpression(this.rewriteGroupingFunctionAST(this.getGroupByForClause(qb.getParseInfo(), selClauseName), wExprSpec.getExpression(), !cubeRollupGrpSetPresent));
            }
        }
        WindowingComponentizer groups = new WindowingComponentizer(wSpec);
        RowResolver rr = this.opParseCtx.get(input).getRowResolver();
        while (groups.hasNext()) {
            wSpec = groups.next(this.conf, this, this.unparseTranslator, rr);
            input = this.genReduceSinkPlanForWindowing(wSpec, rr, input);
            rr = this.opParseCtx.get(input).getRowResolver();
            PTFTranslator translator = new PTFTranslator();
            PTFDesc ptfDesc = translator.translate(wSpec, this, this.conf, rr, this.unparseTranslator);
            RowResolver ptfOpRR = ptfDesc.getFuncDef().getOutputShape().getRr();
            input = this.putOpInsertMap(OperatorFactory.getAndMakeChild(ptfDesc, new RowSchema(ptfOpRR.getColumnInfos()), input, new Operator[0]), ptfOpRR);
            input = this.genSelectAllDesc(input);
            rr = ptfOpRR;
        }
        return input;
    }

    private Operator genReduceSinkPlanForWindowing(WindowingSpec spec, RowResolver inputRR, Operator input) throws SemanticException {
        ArrayList<ExprNodeDesc> partCols = new ArrayList<ExprNodeDesc>();
        ArrayList<ExprNodeDesc> orderCols = new ArrayList<ExprNodeDesc>();
        StringBuilder order = new StringBuilder();
        StringBuilder nullOrder = new StringBuilder();
        for (PTFInvocationSpec.PartitionExpression partCol : spec.getQueryPartitionSpec().getExpressions()) {
            ExprNodeDesc partExpr = this.genExprNodeDesc(partCol.getExpression(), inputRR);
            if (ExprNodeDescUtils.indexOf(partExpr, partCols) >= 0) continue;
            partCols.add(partExpr);
            orderCols.add(partExpr);
            order.append('+');
            nullOrder.append('a');
        }
        if (spec.getQueryOrderSpec() != null) {
            for (PTFInvocationSpec.OrderExpression orderCol : spec.getQueryOrderSpec().getExpressions()) {
                ExprNodeDesc orderExpr = this.genExprNodeDesc(orderCol.getExpression(), inputRR);
                char orderChar = orderCol.getOrder() == PTFInvocationSpec.Order.ASC ? (char)'+' : '-';
                char nullOrderChar = orderCol.getNullOrder() == PTFInvocationSpec.NullOrder.NULLS_FIRST ? (char)'a' : 'z';
                int index = ExprNodeDescUtils.indexOf(orderExpr, orderCols);
                if (index >= 0) {
                    order.setCharAt(index, orderChar);
                    nullOrder.setCharAt(index, nullOrderChar);
                    continue;
                }
                orderCols.add(this.genExprNodeDesc(orderCol.getExpression(), inputRR));
                order.append(orderChar);
                nullOrder.append(nullOrderChar);
            }
        }
        return this.genReduceSinkPlan(input, partCols, orderCols, order.toString(), nullOrder.toString(), -1, AcidUtils.Operation.NOT_ACID, false);
    }

    public static List<WindowingSpec.WindowExpressionSpec> parseSelect(String selectExprStr) throws SemanticException {
        ASTNode selNode = null;
        try {
            ParseDriver pd = new ParseDriver();
            selNode = pd.parseSelect(selectExprStr, null).getTree();
        }
        catch (ParseException pe) {
            throw new SemanticException((Throwable)pe);
        }
        ArrayList<WindowingSpec.WindowExpressionSpec> selSpec = new ArrayList<WindowingSpec.WindowExpressionSpec>();
        int childCount = selNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ASTNode selExpr = (ASTNode)selNode.getChild(i);
            if (selExpr.getType() != 1198) {
                throw new SemanticException(String.format("Only Select expressions supported in dynamic select list: %s", selectExprStr));
            }
            ASTNode expr = (ASTNode)selExpr.getChild(0);
            if (expr.getType() == 843) {
                throw new SemanticException(String.format("'%s' column not allowed in dynamic select list", selectExprStr));
            }
            ASTNode aliasNode = selExpr.getChildCount() > 1 && selExpr.getChild(1).getType() == 24 ? (ASTNode)selExpr.getChild(1) : null;
            String alias = null;
            if (aliasNode != null) {
                alias = aliasNode.getText();
            } else {
                String[] tabColAlias = SemanticAnalyzer.getColAlias(selExpr, null, null, true, -1);
                alias = tabColAlias[1];
            }
            WindowingSpec.WindowExpressionSpec exprSpec = new WindowingSpec.WindowExpressionSpec();
            exprSpec.setAlias(alias);
            exprSpec.setExpression(expr);
            selSpec.add(exprSpec);
        }
        return selSpec;
    }

    private void addAlternateGByKeyMappings(ASTNode gByExpr, ColumnInfo colInfo, Operator<? extends OperatorDesc> reduceSinkOp, RowResolver gByRR) {
        if (gByExpr.getType() == 16 && gByExpr.getChild(0).getType() == 1276) {
            String tab_alias = BaseSemanticAnalyzer.unescapeIdentifier(gByExpr.getChild(0).getChild(0).getText().toLowerCase());
            String col_alias = BaseSemanticAnalyzer.unescapeIdentifier(gByExpr.getChild(1).getText().toLowerCase());
            gByRR.put(tab_alias, col_alias, colInfo);
        } else if (gByExpr.getType() == 1276) {
            String col_alias = BaseSemanticAnalyzer.unescapeIdentifier(gByExpr.getChild(0).getText().toLowerCase());
            String tab_alias = null;
            Operator<? extends OperatorDesc> parent = reduceSinkOp;
            while (parent instanceof ReduceSinkOperator || parent instanceof GroupByOperator) {
                parent = parent.getParentOperators().get(0);
            }
            RowResolver parentRR = this.opParseCtx.get(parent).getRowResolver();
            try {
                tab_alias = Optional.ofNullable(parentRR.get(null, col_alias)).map(ColumnInfo::getTabAlias).orElse(null);
            }
            catch (SemanticException semanticException) {
                // empty catch block
            }
            gByRR.put(tab_alias, col_alias, colInfo);
        }
    }

    private WriteEntity.WriteType determineWriteType(LoadTableDesc ltd, String dest) {
        if (ltd == null) {
            return WriteEntity.WriteType.INSERT_OVERWRITE;
        }
        return ltd.getLoadFileType() == LoadTableDesc.LoadFileType.REPLACE_ALL || ltd.isInsertOverwrite() ? WriteEntity.WriteType.INSERT_OVERWRITE : this.getWriteType(dest);
    }

    private WriteEntity.WriteType getWriteType(String dest) {
        return this.updating(dest) ? WriteEntity.WriteType.UPDATE : (this.deleting(dest) ? WriteEntity.WriteType.DELETE : WriteEntity.WriteType.INSERT);
    }

    private boolean isAcidOutputFormat(Class<? extends OutputFormat> of) {
        return Arrays.asList(of.getInterfaces()).contains(AcidOutputFormat.class);
    }

    private AcidUtils.Operation getAcidType(String destination) {
        return this.deleting(destination) ? AcidUtils.Operation.DELETE : (this.updating(destination) ? AcidUtils.Operation.UPDATE : AcidUtils.Operation.INSERT);
    }

    private Context.Operation getWriteOperation(String destination) {
        return this.deleting(destination) ? Context.Operation.DELETE : (this.updating(destination) ? Context.Operation.UPDATE : (this.merging(destination) ? Context.Operation.MERGE : Context.Operation.OTHER));
    }

    private AcidUtils.Operation getAcidType(Class<? extends OutputFormat> of, String dest, boolean isMM) {
        if (isMM) {
            return this.getAcidType(dest);
        }
        if (SessionState.get() == null || !this.getTxnMgr().supportsAcid()) {
            return AcidUtils.Operation.NOT_ACID;
        }
        if (this.isAcidOutputFormat(of)) {
            return this.getAcidType(dest);
        }
        return AcidUtils.Operation.NOT_ACID;
    }

    protected boolean updating(String destination) {
        return destination.startsWith(Context.DestClausePrefix.UPDATE.toString());
    }

    private boolean deleting(String destination) {
        return destination.startsWith(Context.DestClausePrefix.DELETE.toString());
    }

    private boolean merging(String destination) {
        return destination.startsWith(Context.DestClausePrefix.MERGE.toString());
    }

    private void checkAcidTxnManager(org.apache.hadoop.hive.ql.metadata.Table table) throws SemanticException {
        if (SessionState.get() != null && !this.getTxnMgr().supportsAcid() && !HiveConf.getBoolVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_IN_TEST_REPL)) {
            throw new SemanticException(ErrorMsg.TXNMGR_NOT_ACID, new String[]{table.getDbName(), table.getTableName()});
        }
    }

    ASTNode genSelectDIAST(RowResolver rr) {
        Map<String, Map<String, ColumnInfo>> map = rr.getRslvMap();
        ASTNode selectDI = new ASTNode((Token)SELECTDI_TOKEN);
        for (String tabAlias : map.keySet()) {
            for (Map.Entry<String, ColumnInfo> entry : map.get(tabAlias).entrySet()) {
                selectDI.addChild((Tree)this.buildSelExprSubTree(tabAlias, entry.getKey()));
            }
        }
        return selectDI;
    }

    private ASTNode buildSelExprSubTree(String tableAlias, String col) {
        tableAlias = StringInternUtils.internIfNotNull((String)tableAlias);
        col = StringInternUtils.internIfNotNull((String)col);
        ASTNode selexpr = new ASTNode((Token)SELEXPR_TOKEN);
        ASTNode tableOrCol = new ASTNode((Token)TABLEORCOL_TOKEN);
        ASTNode dot = new ASTNode((Token)DOT_TOKEN);
        tableOrCol.addChild((Tree)new ASTNode((Token)new CommonToken(24, tableAlias)));
        dot.addChild((Tree)tableOrCol);
        dot.addChild((Tree)new ASTNode((Token)new CommonToken(24, col)));
        selexpr.addChild((Tree)dot);
        return selexpr;
    }

    private void copyInfoToQueryProperties(QueryProperties queryProperties) {
        if (this.qb != null) {
            queryProperties.setQuery(this.qb.getIsQuery() && !this.forViewCreation);
            queryProperties.setAnalyzeCommand(this.qb.getParseInfo().isAnalyzeCommand());
            queryProperties.setNoScanAnalyzeCommand(this.qb.getParseInfo().isNoScanAnalyzeCommand());
            queryProperties.setAnalyzeRewrite(this.qb.isAnalyzeRewrite());
            queryProperties.setCTAS(this.qb.getTableDesc() != null);
            if (this.qb.getParseInfo().hasInsertTables()) {
                queryProperties.setQueryType(QueryProperties.QueryType.DML);
            }
            queryProperties.setHasOuterOrderBy(!this.qb.getParseInfo().getIsSubQ() && !this.qb.getParseInfo().getDestToOrderBy().isEmpty());
            queryProperties.setOuterQueryLimit(this.qb.getParseInfo().getOuterQueryLimit());
            queryProperties.setView(this.forViewCreation);
            queryProperties.setMaterializedView(this.qb.isMaterializedView());
        }
    }

    private void warn(String msg) {
        SessionState.getConsole().printInfo(String.format("Warning: %s", msg));
    }

    public List<LoadFileDesc> getLoadFileWork() {
        return this.loadFileWork;
    }

    public List<LoadTableDesc> getLoadTableWork() {
        return this.loadTableWork;
    }

    public void setLoadFileWork(List<LoadFileDesc> loadFileWork) {
        this.loadFileWork = loadFileWork;
    }

    public void setLoadTableWork(List<LoadTableDesc> tblWork) {
        this.loadTableWork = tblWork;
    }

    private void quoteIdentifierTokens(TokenRewriteStream tokenRewriteStream) {
        if (this.conf.getVar(HiveConf.ConfVars.HIVE_QUOTEDID_SUPPORT).equals("none")) {
            return;
        }
        for (int idx = 0; idx <= tokenRewriteStream.size() - 1; ++idx) {
            Token curTok = tokenRewriteStream.get(idx);
            if (curTok.getType() != 24) continue;
            String escapedTokenText = curTok.getText().replaceAll("`", "``");
            tokenRewriteStream.replace(curTok, (Object)("`" + escapedTokenText + "`"));
        }
    }

    private String getQueryStringForCache(ASTNode ast) {
        this.unparseTranslator.applyTranslations(this.ctx.getTokenRewriteStream(), RESULTS_CACHE_KEY_TOKEN_REWRITE_PROGRAM);
        return this.ctx.getTokenRewriteStream().toString(RESULTS_CACHE_KEY_TOKEN_REWRITE_PROGRAM, ast.getTokenStartIndex(), ast.getTokenStopIndex());
    }

    private void openTxnAndSetValidTxnList() throws SemanticException {
        if (this.tablesFromReadEntities(this.inputs).stream().noneMatch(AcidUtils::isTransactionalTable) || SessionState.get().isCompaction()) {
            return;
        }
        if (this.queryState.getHMSCache() != null) {
            this.getValidTxnWriteIdList();
        } else {
            this.queryState.getValidTxnList();
        }
    }

    private ValidTxnWriteIdList getValidTxnWriteIdList() throws SemanticException {
        List<String> transactionalTables = this.tablesFromReadEntities(this.inputs).stream().filter(AcidUtils::isTransactionalTable).map(org.apache.hadoop.hive.ql.metadata.Table::getFullyQualifiedName).toList();
        if (transactionalTables.isEmpty()) {
            return null;
        }
        String txnString = this.queryState.getValidTxnList();
        try {
            return this.getTxnMgr().getValidWriteIds(transactionalTables, txnString);
        }
        catch (Exception err) {
            String msg = "Error while getting the txnWriteIdList for tables " + String.valueOf(transactionalTables) + " and validTxnList " + txnString;
            throw new SemanticException(msg, (Throwable)err);
        }
    }

    private QueryResultsCache.LookupInfo createLookupInfoForQuery(ASTNode astNode) throws SemanticException {
        QueryResultsCache.LookupInfo lookupInfo = null;
        String queryString = this.getQueryStringForCache(astNode);
        if (queryString != null) {
            ValidTxnWriteIdList writeIdList = this.getValidTxnWriteIdList();
            Set<Long> involvedTables = this.tablesFromReadEntities(this.inputs).stream().map(org.apache.hadoop.hive.ql.metadata.Table::getTTable).map(Table::getId).collect(Collectors.toSet());
            lookupInfo = new QueryResultsCache.LookupInfo(queryString, () -> writeIdList, involvedTables);
        }
        return lookupInfo;
    }

    private boolean isResultsCacheEnabled() {
        return this.conf.getBoolVar(HiveConf.ConfVars.HIVE_QUERY_RESULTS_CACHE_ENABLED) && (!SessionState.get().isHiveServerQuery() || !this.conf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS));
    }

    private void useCachedResult(QueryResultsCache.CacheEntry cacheEntry, boolean needsReset) {
        if (needsReset) {
            this.reset(true);
            this.inputs.clear();
        }
        FetchTask fetchTask = (FetchTask)TaskFactory.get(cacheEntry.getFetchWork());
        this.setFetchTask(fetchTask);
        this.queryState.setCommandType(cacheEntry.getQueryInfo().getHiveOperation());
        this.resultSchema = cacheEntry.getQueryInfo().getResultSchema();
        this.setTableAccessInfo(cacheEntry.getQueryInfo().getTableAccessInfo());
        this.setColumnAccessInfo(cacheEntry.getQueryInfo().getColumnAccessInfo());
        this.inputs.addAll(cacheEntry.getQueryInfo().getInputs());
        this.conf.setBoolean("mapreduce.input.fileinputformat.input.dir.recursive", true);
        this.setCacheUsage(new CacheUsage(CacheUsage.CacheStatus.QUERY_USING_CACHE, cacheEntry));
    }

    private QueryResultsCache.QueryInfo createCacheQueryInfoForQuery(QueryResultsCache.LookupInfo lookupInfo) {
        long queryTime = SessionState.get().getQueryCurrentTimestamp().toEpochMilli();
        return new QueryResultsCache.QueryInfo(queryTime, lookupInfo, this.queryState.getHiveOperation(), this.resultSchema, this.getTableAccessInfo(), this.getColumnAccessInfo(), this.inputs);
    }

    private boolean queryTypeCanUseCache(QB qb) {
        if (qb == null || qb.getParseInfo() == null) {
            return false;
        }
        if (this instanceof ColumnStatsSemanticAnalyzer) {
            this.LOG.debug("Query type cannot use cache (ColumnStatsSemanticAnalyzer)");
            return false;
        }
        if (this.queryState.getHiveOperation() != HiveOperation.QUERY) {
            this.LOG.debug("Query type cannot use cache (HiveOperation is not a QUERY)");
            return false;
        }
        if (Optional.of(qb.getParseInfo()).filter(pi -> pi.isAnalyzeCommand() || pi.hasInsertTables() || pi.isInsertOverwriteDirectory()).isPresent()) {
            this.LOG.debug("Query type cannot use cache (analyze, insert, or IOWD)");
            return false;
        }
        if (this.ctx.getExplainAnalyze() != null) {
            this.LOG.debug("Query type cannot use cache (explain analyze command)");
            return false;
        }
        return true;
    }

    private boolean needsTransform() {
        return SessionState.get().getAuthorizerV2() != null && SessionState.get().getAuthorizerV2().needTransform();
    }

    private boolean queryCanBeCached() {
        List<org.apache.hadoop.hive.ql.metadata.Table> nonTransactionalTables;
        if (!this.queryTypeCanUseCache(this.qb)) {
            this.LOG.info("Not eligible for results caching - wrong query type");
            return false;
        }
        if (this.getFetchTask() == null) {
            this.LOG.info("Not eligible for results caching - no fetch task");
            return false;
        }
        if (Utilities.getNumClusterJobs(this.getRootTasks()) == 0) {
            this.LOG.info("Not eligible for results caching - no mr/tez jobs");
            return false;
        }
        if (!this.ctx.isCboSucceeded()) {
            this.LOG.info("Caching of query results is disabled if CBO was not run.");
            QueryResultsCache.incrementMetric("qc_invalid_for_caching");
            return false;
        }
        if (!this.isValidQueryCaching()) {
            this.LOG.info("Not eligible for results caching - {}", (Object)this.getInvalidResultCacheReason());
            QueryResultsCache.incrementMetric("qc_invalid_for_caching");
            return false;
        }
        if (!this.conf.getBoolVar(HiveConf.ConfVars.HIVE_QUERY_RESULTS_CACHE_NONTRANSACTIONAL_TABLES_ENABLED) && (nonTransactionalTables = this.getNonTransactionalTables()).size() > 0) {
            this.LOG.info("Not eligible for results caching - query contains non-transactional tables {}", nonTransactionalTables);
            return false;
        }
        return true;
    }

    private Set<org.apache.hadoop.hive.ql.metadata.Table> tablesFromReadEntities(Set<ReadEntity> readEntities) {
        return readEntities.stream().filter(entity -> entity.getType() == Entity.Type.TABLE).map(Entity::getTable).collect(Collectors.toSet());
    }

    private List<org.apache.hadoop.hive.ql.metadata.Table> getNonTransactionalTables() {
        return this.tablesFromReadEntities(this.inputs).stream().filter(table -> !table.isView()).filter(table -> !AcidUtils.isTransactionalTable(table)).collect(Collectors.toList());
    }

    private boolean checkResultsCache(QueryResultsCache.LookupInfo lookupInfo, boolean needsReset) {
        block5: {
            QueryResultsCache.CacheEntry cacheEntry;
            boolean isExplainQuery;
            block6: {
                block7: {
                    if (lookupInfo == null) {
                        return false;
                    }
                    try {
                        QueryResultsCache.initialize(this.conf);
                    }
                    catch (Exception err) {
                        throw new IllegalStateException(err);
                    }
                    isExplainQuery = this.ctx.getExplainConfig() != null;
                    cacheEntry = QueryResultsCache.getInstance().lookup(lookupInfo);
                    if (cacheEntry == null) break block5;
                    if (cacheEntry.getStatus() != QueryResultsCache.CacheEntryStatus.PENDING) break block6;
                    if (isExplainQuery || !this.conf.getBoolVar(HiveConf.ConfVars.HIVE_QUERY_RESULTS_CACHE_WAIT_FOR_PENDING_RESULTS) || !this.conf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_PARALLEL_COMPILATION)) break block7;
                    if (cacheEntry.waitForValidStatus()) break block6;
                    this.LOG.info("Waiting on pending cacheEntry, but it failed to become valid");
                    break block5;
                }
                this.LOG.info("Not waiting for pending cacheEntry");
                return false;
            }
            if (cacheEntry.getStatus() == QueryResultsCache.CacheEntryStatus.VALID) {
                if (!isExplainQuery && !cacheEntry.addReader()) {
                    return false;
                }
                this.useCachedResult(cacheEntry, needsReset);
                return true;
            }
        }
        return false;
    }

    public MaterializationValidationResult getMaterializationValidationResult() {
        return this.materializationValidationResult;
    }

    public void setMaterializationValidationResult(MaterializationValidationResult materializationValidationResult) {
        this.materializationValidationResult = materializationValidationResult;
    }

    public String getInvalidResultCacheReason() {
        return this.invalidResultCacheReason;
    }

    public void setInvalidResultCacheReason(String invalidQueryMaterializationReason) {
        this.invalidResultCacheReason = invalidQueryMaterializationReason;
    }

    public boolean isValidQueryCaching() {
        return this.invalidResultCacheReason == null;
    }

    public void forViewCreation(String fqViewName) {
        this.fqViewName = fqViewName;
        this.forViewCreation = true;
    }

    public Map<String, TableScanOperator> getTopOps() {
        return this.topOps;
    }

    public Map<String, ReadEntity> getViewAliasToInput() {
        return this.viewAliasToInput;
    }

    public Operator getSinkOp() {
        return this.sinkOp;
    }

    protected void addPartitionColsToInsert(List<FieldSchema> partCols, StringBuilder rewrittenQueryStr) {
        this.addPartitionColsToInsert(partCols, null, rewrittenQueryStr);
    }

    protected void addPartitionColsToInsert(List<FieldSchema> partCols, Map<String, String> partSpec, StringBuilder rewrittenQueryStr) {
        if (partCols != null && partCols.size() > 0) {
            rewrittenQueryStr.append(" partition (");
            boolean first = true;
            for (FieldSchema fschema : partCols) {
                if (first) {
                    first = false;
                } else {
                    rewrittenQueryStr.append(", ");
                }
                rewrittenQueryStr.append(HiveUtils.unparseIdentifier(fschema.getName(), (Configuration)this.conf));
                String partVal = partSpec != null ? partSpec.get(fschema.getName()) : null;
                if (partVal == null) continue;
                rewrittenQueryStr.append("=").append(partVal);
            }
            rewrittenQueryStr.append(")");
        }
    }

    @Override
    public WriteEntity getAcidAnalyzeTable() {
        return this.acidAnalyzeTable;
    }

    @Override
    public void executeUnParseTranslations() {
        this.unparseTranslator.applyTranslations(this.ctx.getTokenRewriteStream());
    }

    @Override
    public void startAnalysis() {
        if (this.conf.getBoolVar(HiveConf.ConfVars.HIVE_OPTIMIZE_HMS_QUERY_CACHE_ENABLED)) {
            this.queryState.createHMSCache();
        }
    }

    private static /* synthetic */ boolean lambda$genConversionSelectOperator$3(String destPartitionName, FieldSchema dynamicPartition) {
        return dynamicPartition.getName().equals(destPartitionName);
    }

    protected static enum MaterializationRebuildMode {
        NONE,
        INSERT_OVERWRITE_REBUILD,
        AGGREGATE_INSERT_REBUILD,
        AGGREGATE_INSERT_DELETE_REBUILD,
        JOIN_INSERT_REBUILD;

    }

    class CTEClause {
        String alias;
        ASTNode cteNode;
        ASTNode withColList;
        boolean materialize;
        int reference;
        QBExpr qbExpr;
        List<CTEClause> parents = new ArrayList<CTEClause>();
        SemanticAnalyzer source;

        CTEClause(SemanticAnalyzer this$0, String alias, ASTNode cteNode, ASTNode withColList) {
            this.alias = alias;
            this.cteNode = cteNode;
            this.withColList = withColList;
        }

        List<Task<?>> getTasks() {
            return this.source == null ? null : this.source.rootTasks;
        }

        List<CTEClause> asExecutionOrder() {
            ArrayList<CTEClause> execution = new ArrayList<CTEClause>();
            this.asExecutionOrder(new HashSet<CTEClause>(), execution);
            return execution;
        }

        void asExecutionOrder(Set<CTEClause> visited, List<CTEClause> execution) {
            for (CTEClause parent : this.parents) {
                if (!visited.add(parent)) continue;
                parent.asExecutionOrder(visited, execution);
            }
            execution.add(this);
        }

        public String toString() {
            return this.alias == null ? "<root>" : this.alias;
        }
    }

    public static class Phase1Ctx {
        String dest;
        int nextNum;
    }

    public static class PlannerContext {
        public void setCTASToken(ASTNode child) {
        }

        void setViewToken(ASTNode child) {
        }

        void setInsertToken(ASTNode ast, boolean isTmpFileDest) {
        }

        void setMultiInsertToken(ASTNode child) {
        }

        void resetToken() {
        }
    }

    public static class GenericUDAFInfo {
        public List<ExprNodeDesc> convertedParameters;
        public GenericUDAFEvaluator genericUDAFEvaluator;
        public TypeInfo returnType;
    }

    private static class SortBucketRSCtx {
        List<ExprNodeDesc> partnCols = null;
        boolean multiFileSpray = false;
        int numFiles = 1;
        int totalFiles = 1;

        public List<ExprNodeDesc> getPartnCols() {
            return this.partnCols;
        }

        public void setPartnCols(List<ExprNodeDesc> partnCols) {
            this.partnCols = partnCols;
        }

        public boolean isMultiFileSpray() {
            return this.multiFileSpray;
        }

        public void setMultiFileSpray(boolean multiFileSpray) {
            this.multiFileSpray = multiFileSpray;
        }

        public int getNumFiles() {
            return this.numFiles;
        }

        public void setNumFiles(int numFiles) {
            this.numFiles = numFiles;
        }

        public int getTotalFiles() {
            return this.totalFiles;
        }

        public void setTotalFiles(int totalFiles) {
            this.totalFiles = totalFiles;
        }
    }

    private static final class ColsAndTypes {
        public String cols;
        public String colTypes;

        public ColsAndTypes(String cols, String colTypes) {
            this.cols = cols;
            this.colTypes = colTypes;
        }
    }
}

