/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.iceberg.StatisticsFile;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.UpdateStatistics;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

public class SetStatistics
implements UpdateStatistics {
    private final TableOperations ops;
    private final Map<Long, Optional<StatisticsFile>> statisticsToSet = Maps.newHashMap();

    public SetStatistics(TableOperations ops) {
        this.ops = ops;
    }

    @Override
    public UpdateStatistics setStatistics(StatisticsFile statisticsFile) {
        this.statisticsToSet.put(statisticsFile.snapshotId(), Optional.of(statisticsFile));
        return this;
    }

    @Override
    public UpdateStatistics removeStatistics(long snapshotId) {
        this.statisticsToSet.put(snapshotId, Optional.empty());
        return this;
    }

    @Override
    public List<StatisticsFile> apply() {
        return this.internalApply(this.ops.current()).statisticsFiles();
    }

    @Override
    public void commit() {
        TableMetadata base = this.ops.current();
        TableMetadata newMetadata = this.internalApply(base);
        this.ops.commit(base, newMetadata);
    }

    private TableMetadata internalApply(TableMetadata base) {
        TableMetadata.Builder builder = TableMetadata.buildFrom(base);
        this.statisticsToSet.forEach((snapshotId, statistics) -> {
            if (statistics.isPresent()) {
                builder.setStatistics((StatisticsFile)statistics.get());
            } else {
                builder.removeStatistics((long)snapshotId);
            }
        });
        return builder.build();
    }
}

