/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.requests;

import java.util.List;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.rest.RESTRequest;
import org.apache.iceberg.rest.requests.UpdateTableRequest;

public class CommitTransactionRequest
implements RESTRequest {
    private final List<UpdateTableRequest> tableChanges;

    public CommitTransactionRequest(List<UpdateTableRequest> tableChanges) {
        this.tableChanges = tableChanges;
        this.validate();
    }

    public List<UpdateTableRequest> tableChanges() {
        return ImmutableList.copyOf(this.tableChanges);
    }

    @Override
    public void validate() {
        Preconditions.checkArgument(null != this.tableChanges, "Invalid table changes: null");
        Preconditions.checkArgument(!this.tableChanges.isEmpty(), "Invalid table changes: empty");
        for (UpdateTableRequest tableChange : this.tableChanges) {
            Preconditions.checkArgument(null != tableChange.identifier(), "Invalid table changes: table identifier is required");
        }
    }
}

