/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.tezplugins.endpoint;

import com.google.protobuf.BlockingService;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.LlapUtil;
import org.apache.hadoop.hive.llap.plugin.rpc.LlapPluginProtocolProtos;
import org.apache.hadoop.hive.llap.protocol.LlapPluginProtocolPB;
import org.apache.hadoop.hive.llap.tezplugins.LlapTaskSchedulerService;
import org.apache.hadoop.hive.llap.tezplugins.endpoint.LlapPluginPolicyProvider;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.service.AbstractService;
import org.apache.tez.common.security.JobTokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapPluginServerImpl
extends AbstractService
implements LlapPluginProtocolPB {
    private static final Logger LOG = LoggerFactory.getLogger(LlapPluginServerImpl.class);
    private RPC.Server server;
    private final SecretManager<JobTokenIdentifier> secretManager;
    private final int numHandlers;
    private final LlapTaskSchedulerService parent;
    private final AtomicReference<InetSocketAddress> bindAddress = new AtomicReference();
    private final int port;

    public LlapPluginServerImpl(SecretManager<JobTokenIdentifier> secretManager, int numHandlers, LlapTaskSchedulerService parent, int port) {
        super("LlapPluginServerImpl");
        this.secretManager = secretManager;
        this.numHandlers = numHandlers;
        this.parent = parent;
        this.port = port <= 0 ? 0 : port;
        LOG.info("Llap plugin server using port: {} #handlers: {}", (Object)port, (Object)numHandlers);
    }

    public LlapPluginProtocolProtos.UpdateQueryResponseProto updateQuery(RpcController controller, LlapPluginProtocolProtos.UpdateQueryRequestProto request) throws ServiceException {
        this.parent.updateQuery(request);
        return LlapPluginProtocolProtos.UpdateQueryResponseProto.getDefaultInstance();
    }

    public void serviceStart() {
        Configuration conf = this.getConfig();
        BlockingService daemonImpl = LlapPluginProtocolProtos.LlapPluginProtocol.newReflectiveBlockingService((LlapPluginProtocolProtos.LlapPluginProtocol.BlockingInterface)this);
        this.server = LlapUtil.startProtocolServer((int)this.port, (int)this.numHandlers, this.bindAddress, (Configuration)conf, (BlockingService)daemonImpl, LlapPluginProtocolPB.class, this.secretManager, (PolicyProvider)new LlapPluginPolicyProvider(), (HiveConf.ConfVars[])new HiveConf.ConfVars[]{HiveConf.ConfVars.LLAP_PLUGIN_ACL, HiveConf.ConfVars.LLAP_PLUGIN_ACL_DENY});
        LOG.info("Starting the plugin endpoint on port " + this.bindAddress.get().getPort());
    }

    public void serviceStop() {
        if (this.server != null) {
            this.server.stop();
        }
    }

    public int getActualPort() {
        InetSocketAddress bindAddress = this.bindAddress.get();
        if (bindAddress == null) {
            throw new RuntimeException("Cannot get port before the service is started");
        }
        return bindAddress.getPort();
    }
}

