/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.fieldmanager;

import java.sql.ResultSet;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ExecutionContext;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.metadata.RelationType;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.fieldmanager.AbstractFieldManager;
import org.datanucleus.store.rdbms.mapping.java.EmbeddedPCMapping;
import org.datanucleus.store.rdbms.mapping.java.JavaTypeMapping;
import org.datanucleus.store.rdbms.mapping.java.ReferenceMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedPCMapping;
import org.datanucleus.store.rdbms.mapping.java.SerialisedReferenceMapping;
import org.datanucleus.store.rdbms.query.PersistentClassROF;
import org.datanucleus.store.rdbms.query.StatementClassMapping;
import org.datanucleus.store.rdbms.query.StatementMappingIndex;
import org.datanucleus.store.types.SCOUtils;
import org.datanucleus.store.types.containers.ElementContainerHandler;

public class ResultSetGetter
extends AbstractFieldManager {
    protected final ExecutionContext ec;
    protected final ResultSet rs;
    protected final StatementClassMapping resultMappings;
    protected DNStateManager sm;
    protected AbstractClassMetaData cmd;

    public ResultSetGetter(ExecutionContext ec, ResultSet rs, StatementClassMapping resultMappings, AbstractClassMetaData cmd) {
        this.ec = ec;
        this.rs = rs;
        this.resultMappings = resultMappings;
        this.sm = null;
        this.cmd = cmd;
    }

    public void setStateManager(DNStateManager sm) {
        this.sm = sm;
        this.cmd = sm.getClassMetaData();
    }

    public boolean fetchBooleanField(int fieldNumber) {
        StatementMappingIndex mapIdx = this.resultMappings.getMappingForMemberPosition(fieldNumber);
        return mapIdx.getMapping().getBoolean(this.ec, this.rs, mapIdx.getColumnPositions());
    }

    public char fetchCharField(int fieldNumber) {
        StatementMappingIndex mapIdx = this.resultMappings.getMappingForMemberPosition(fieldNumber);
        return mapIdx.getMapping().getChar(this.ec, this.rs, mapIdx.getColumnPositions());
    }

    public byte fetchByteField(int fieldNumber) {
        StatementMappingIndex mapIdx = this.resultMappings.getMappingForMemberPosition(fieldNumber);
        return mapIdx.getMapping().getByte(this.ec, this.rs, mapIdx.getColumnPositions());
    }

    public short fetchShortField(int fieldNumber) {
        StatementMappingIndex mapIdx = this.resultMappings.getMappingForMemberPosition(fieldNumber);
        return mapIdx.getMapping().getShort(this.ec, this.rs, mapIdx.getColumnPositions());
    }

    public int fetchIntField(int fieldNumber) {
        StatementMappingIndex mapIdx = this.resultMappings.getMappingForMemberPosition(fieldNumber);
        return mapIdx.getMapping().getInt(this.ec, this.rs, mapIdx.getColumnPositions());
    }

    public long fetchLongField(int fieldNumber) {
        StatementMappingIndex mapIdx = this.resultMappings.getMappingForMemberPosition(fieldNumber);
        return mapIdx.getMapping().getLong(this.ec, this.rs, mapIdx.getColumnPositions());
    }

    public float fetchFloatField(int fieldNumber) {
        StatementMappingIndex mapIdx = this.resultMappings.getMappingForMemberPosition(fieldNumber);
        return mapIdx.getMapping().getFloat(this.ec, this.rs, mapIdx.getColumnPositions());
    }

    public double fetchDoubleField(int fieldNumber) {
        StatementMappingIndex mapIdx = this.resultMappings.getMappingForMemberPosition(fieldNumber);
        return mapIdx.getMapping().getDouble(this.ec, this.rs, mapIdx.getColumnPositions());
    }

    public String fetchStringField(int fieldNumber) {
        StatementMappingIndex mapIdx = this.resultMappings.getMappingForMemberPosition(fieldNumber);
        return mapIdx.getMapping().getString(this.ec, this.rs, mapIdx.getColumnPositions());
    }

    public Object fetchObjectField(int fieldNumber) {
        StatementClassMapping relationMappings;
        Object value;
        StatementMappingIndex mapIdx = this.resultMappings.getMappingForMemberPosition(fieldNumber);
        JavaTypeMapping mapping = mapIdx.getMapping();
        AbstractMemberMetaData mmd = this.cmd.getMetaDataForManagedMemberAtAbsolutePosition(fieldNumber);
        RelationType relationType = mmd.getRelationType(this.ec.getClassLoaderResolver());
        if (mapping instanceof EmbeddedPCMapping || mapping instanceof SerialisedPCMapping || mapping instanceof SerialisedReferenceMapping) {
            value = mapping.getObject(this.ec, this.rs, mapIdx.getColumnPositions(), this.sm, fieldNumber);
        } else if (mmd.isSingleCollection()) {
            relationMappings = this.resultMappings.getMappingDefinitionForMemberPosition(fieldNumber);
            if (relationMappings != null) {
                Class type = this.ec.getClassLoaderResolver().classForName(mmd.getCollection().getElementType());
                value = this.processSubObjectFields(mapping, type, relationMappings);
                ElementContainerHandler containerHandler = (ElementContainerHandler)this.ec.getTypeManager().getContainerHandler(mmd.getType());
                value = containerHandler.newContainer(mmd, new Object[]{value});
            } else {
                value = mapping.getObject(this.ec, this.rs, mapIdx.getColumnPositions());
            }
        } else {
            value = RelationType.isRelationSingleValued((RelationType)relationType) ? ((relationMappings = this.resultMappings.getMappingDefinitionForMemberPosition(fieldNumber)) != null ? this.processSubObjectFields(mapping, mmd.getType(), relationMappings) : mapping.getObject(this.ec, this.rs, mapIdx.getColumnPositions())) : mapping.getObject(this.ec, this.rs, mapIdx.getColumnPositions());
        }
        if (this.sm != null) {
            AbstractMemberMetaData[] relMmds;
            DNStateManager otherSM;
            if (relationType == RelationType.ONE_TO_ONE_BI && value != null && (otherSM = this.ec.findStateManager(value)) != null && !otherSM.isFieldLoaded((relMmds = mmd.getRelatedMemberMetaData(this.ec.getClassLoaderResolver()))[0].getAbsoluteFieldNumber()) && relMmds[0].getType().isAssignableFrom(this.sm.getObject().getClass())) {
                otherSM.storeFieldValue(relMmds[0].getAbsoluteFieldNumber(), this.sm.getExternalObjectId());
            }
            if (this.cmd.getSCOMutableMemberFlags()[fieldNumber]) {
                return SCOUtils.wrapSCOField((DNStateManager)this.sm, (int)fieldNumber, (Object)value, (boolean)false);
            }
            if (RelationType.isRelationSingleValued((RelationType)relationType) && mmd.getEmbeddedMetaData() != null && mmd.getEmbeddedMetaData().getOwnerMember() != null) {
                this.sm.updateOwnerFieldInEmbeddedField(fieldNumber, value);
                return value;
            }
        }
        return value;
    }

    private Object processSubObjectFields(JavaTypeMapping mapping, Class<?> fieldType, StatementClassMapping relationMappings) {
        JavaTypeMapping[] subMappings;
        ReferenceMapping refMapping;
        ClassLoaderResolver clr = this.ec.getClassLoaderResolver();
        AbstractClassMetaData relatedCmd = this.ec.getMetaDataManager().getMetaDataForClass(fieldType, clr);
        if (mapping instanceof ReferenceMapping && (refMapping = (ReferenceMapping)mapping).getMappingStrategy() == 0 && (subMappings = refMapping.getJavaTypeMapping()) != null && subMappings.length == 1) {
            relatedCmd = this.ec.getMetaDataManager().getMetaDataForClass(subMappings[0].getType(), clr);
            fieldType = clr.classForName(subMappings[0].getType());
        }
        PersistentClassROF relationROF = new PersistentClassROF(this.ec, this.rs, this.ec.getFetchPlan(), relationMappings, relatedCmd, fieldType);
        return relationROF.getObject();
    }
}

