/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.flush;

import org.datanucleus.flush.SCOOperation;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.types.scostore.CollectionStore;
import org.datanucleus.store.types.scostore.Store;

public class CollectionClearOperation
implements SCOOperation {
    final DNStateManager sm;
    final int fieldNumber;
    final CollectionStore store;

    public CollectionClearOperation(DNStateManager sm, CollectionStore store) {
        this.sm = sm;
        this.fieldNumber = store.getOwnerMemberMetaData().getAbsoluteFieldNumber();
        this.store = store;
    }

    public CollectionClearOperation(DNStateManager sm, int fieldNum) {
        this.sm = sm;
        this.fieldNumber = fieldNum;
        this.store = null;
    }

    @Override
    public AbstractMemberMetaData getMemberMetaData() {
        return this.store != null ? this.store.getOwnerMemberMetaData() : this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(this.fieldNumber);
    }

    @Override
    public void perform() {
        if (this.store != null) {
            this.store.clear(this.sm);
        }
    }

    @Override
    public Store getStore() {
        return this.store;
    }

    @Override
    public DNStateManager getStateManager() {
        return this.sm;
    }

    public String toString() {
        return "COLLECTION CLEAR : " + this.sm + " field=" + this.getMemberMetaData().getName();
    }
}

