---
title: "Talks"
---
<!--
 - Licensed to the Apache Software Foundation (ASF) under one or more
 - contributor license agreements.  See the NOTICE file distributed with
 - this work for additional information regarding copyright ownership.
 - The ASF licenses this file to You under the Apache License, Version 2.0
 - (the "License"); you may not use this file except in compliance with
 - the License.  You may obtain a copy of the License at
 -
 -   http://www.apache.org/licenses/LICENSE-2.0
 -
 - Unless required by applicable law or agreed to in writing, software
 - distributed under the License is distributed on an "AS IS" BASIS,
 - WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 - See the License for the specific language governing permissions and
 - limitations under the License.
 -->

## Iceberg Talks

Here is a list of talks and other videos related to Iceberg.
### [Supporting S3 Tables in Daft](https://www.youtube.com/watch?v=WHFlHmFqDsI)
**Date**: February 27, 2025, **Authors**: R. Conner Howell

### [Iceberg Catalogs](https://www.youtube.com/watch?v=P57XWsoL_Bg)
**Date**: February 27, 2025, **Authors**: Arsham Eslami

### [Security for an Apache Iceberg Lakehouse](https://www.youtube.com/watch?v=wfiNR_JI-dU)
**Date**: February 27, 2025, **Authors**: Emre Saglam

### [The Invisible Ink of Iceberg Deletions](https://www.youtube.com/watch?v=gA6jG7gv10A)
**Date**: February 27, 2025, **Authors**: Aniruth Narayanan

### [Iceberg table format version - Iceberg v3 spec](https://www.youtube.com/watch?v=oLHEl-iJ6nw)
**Date**: February 21, 2025, **Authors**: Tomohiro Tanaka

### [Apache Iceberg Case Study in LY Corporation](https://www.youtube.com/watch?v=BZvSlIHihvw)
**Date**: February 21, 2025, **Authors**: Tasuku Okuda

### [Conflict resolution mechanism in Iceberg](https://www.youtube.com/watch?v=e_4T827wLCM)
**Date**: February 21, 2025, **Authors**: Sotaro Hikita

### [Getting Started with Iceberg on Snowflake](https://www.youtube.com/watch?v=n2hh35QlTWI)
**Date**: February 21, 2025, **Authors**: Akira Sakatoku

### [Databricks Frozen Over - Bringing the best of data catalogs and Iceberg together](https://www.youtube.com/watch?v=oLHEl-iJ6nw)
**Date**: February 21, 2025, **Authors**: Victoria Bukta

### [Optimizing Query Performance for Apache Iceberg at Scale](https://www.youtube.com/watch?v=qPE09kUeiFk)
**Date**: January 30, 2025, **Authors**: Yan (Ryan) Zhang

### [Streaming data to Apache Iceberg with Redpanda](https://www.youtube.com/watch?v=bCms63U8xPE)
**Date**: January 30, 2025, **Authors**: Andrew Wong

### [Automated ERD construction on Iceberg data lakes with Kurve](https://www.youtube.com/watch?v=o0Q7Eiie-JI)
**Date**: January 30, 2025, **Authors**: Wes Madrigal

### [From Logs to Insights](https://www.youtube.com/watch?v=VzQ-rBByKdw)
**Date**: January 30, 2025, **Authors**: Danfeng Xu

### [From Passive to Powerful, How Storage-Acceleration can Supercharge Iceberg Query Performance](https://www.youtube.com/watch?v=3aZlxPFJR2s)
**Date**: January 30, 2025, **Authors**: Kartik Kulkarni 

### [Iceberg Metadata for Variant Support](https://youtu.be/MKqllL_D-fs)
**Date**: January 30, 2025, **Authors**: Aihua Xu

### [Fireside Chat with Denny Lee & Jason Reid](https://www.youtube.com/watch?v=KwvwB_j_6V4&list=PL3IALGSANhzWxlZpyGgwZiRYjhIStmBdq&index=8&pp=iAQB)
**Date**: January 30, 2025, **Authors**: Denny Lee, Jason Reid

### [Optimizing Iceberg Query Performance by Automatically generating NDVs](https://www.youtube.com/watch?v=xeDuiR_0WnY&list=PL3IALGSANhzWxlZpyGgwZiRYjhIStmBdq&index=9&pp=iAQB)
**Date**: January 30, 2025, **Authors**: Sandeep Adwankar

### [Towards Actionable Metadata](https://www.youtube.com/watch?v=zBcReOD5KH8&list=PL3IALGSANhzWxlZpyGgwZiRYjhIStmBdq&index=10&pp=iAQB)
**Date**: January 30, 2025, **Authors**: Viktor Kessler

### [Apache Iceberg V3 and Beyond](https://www.youtube.com/watch?v=0C8CLOzNVEU)
**Date**: January 30, 2025, **Authors**: Daniel Weeks

### [Evolution of Position Deletes](https://www.youtube.com/watch?v=vjgJridq8G0)
**Date**: January 30, 2025, **Authors**: Anton Okolnychyi

### [Data-Centric AI with Iceberg Data Products](https://www.youtube.com/watch?v=jHHsbNLli-M)
**Date**: January 30, 2025, **Authors**: Andrew C. Madson

### [Ursa Augmenting Iceberg with Kafka-Compatible Data Streaming Capabilities](https://www.youtube.com/watch?v=eensn8_PWow)
**Date**: January 30, 2025, **Authors**: Sijie Guo

### [Navigating Iceberg Adoption and Impact at Pinterest](https://www.youtube.com/watch?v=k4Yu8delcac)
**Date**: January 30, 2025, **Authors**: Ashish Singh, Chunyan Wang

### [Bridging Python and Apache Iceberg The Power of PyIceberg](https://www.youtube.com/watch?v=METmUaUTI7o)
**Date**: January 30, 2025, **Authors**: Rushan (Jonas) Jiang

### [Lakekeeper: Rust based Iceberg Catalog](https://www.youtube.com/watch?v=p0nVQSolnuY)
**Date**: November 4, 2024, **Authors**: Christian Thiel

### [Iceberg at Netflix](https://www.youtube.com/watch?v=tLgeemU6XUg)
**Date**: November 4, 2024, **Authors**: Snehal Chennuru

### [How We Implemented the Iceberg Connector in Rust!](https://www.youtube.com/watch?v=5Hcde2h-1Y4)
**Date**: November 4, 2024, **Authors**: Yingjun Wu

### [Accelerate your Iceberg workloads on S3](https://www.youtube.com/watch?v=nfNy7Lqo60U)
**Date**: November 4, 2024, **Authors**: Jack Ye

### [Lessons From Building Iceberg Capabilities In Daft, A Distributed Query Engine](https://www.youtube.com/watch?v=-2Vd02A_Jy4)
**Date**: November 4, 2024, **Authors**: Kevin Wang

### [Eliminating Shuffles in DELETE, UPDATE, MERGE](https://www.youtube.com/watch?v=AIZjy6_K0ws)
**Date**: July 27, 2023, **Authors**: Anton Okolnychyi, Chao Sun

### [Write Distribution Modes in Apache Iceberg](https://www.youtube.com/watch?v=4bOCDP-rhuM)
**Date**: March 15, 2023, **Author**: Russell Spitzer

### [Technical Evolution of Apache Iceberg](https://www.youtube.com/watch?v=CHs9_h9VLCs)
**Date**: March 15, 2023, **Author**: Anton Okolnychyi

### [Iceberg's Best Secret Exploring Metadata Tables](https://www.youtube.com/watch?v=s5eKriX6_EU)
**Date**: January 12, 2023, **Author**: Szehon Ho

### [Data architecture in 2022](https://www.youtube.com/watch?v=1oXmBbB77ak)
**Date**: May 5, 2022, **Authors**: Ryan Blue

### [Why You Shouldn’t Care About Iceberg | Tabular](https://www.youtube.com/watch?v=_GW3GYZK66U)
**Date**: March 24, 2022, **Authors**: Ryan Blue

### [Managing Data Files in Apache Iceberg](https://www.dremio.com/resources/webinars/managing-data-files-in-apache-iceberg/)
**Date**: March 2, 2022, **Author**: Russell Spitzer

### [Tuning Row-Level Operations in Apache Iceberg](https://www.dremio.com/resources/webinars/tuning-row-level-operations-in-apache-iceberg/)
**Date**: March 2, 2022, **Author**: Anton Okolnychyi

### [Multi Dimensional Clustering with Z Ordering](https://www.youtube.com/watch?v=YLVkITvF6KU)
**Date**: December 6, 2021, **Author**: Russell Spitzer

### [Expert Roundtable: The Future of Metadata After Hive Metastore](https://www.youtube.com/watch?v=7_Pt1g2x-XE)
**Date**: November 15, 2021, **Authors**: Lior Ebel, Seshu Adunuthula, Ryan Blue & Oz Katz

### [Presto and Apache Iceberg: Building out Modern Open Data Lakes](https://www.youtube.com/watch?v=OJQHVPChYHw)
**Date**: November 10, 2021, **Authors**: Daniel Weeks, Chunxu Tang

### [Iceberg Case Studies](https://www.youtube.com/watch?v=Al8feI9QEBc)
**Date**: September 29, 2021, **Authors**: Ryan Blue

### [Deep Dive into Iceberg SQL Extensions](https://www.dremio.com/resources/webinars/deep-dive-into-iceberg-sql-extensions/)
**Date**: July 13, 2021, **Author**: Anton Okolnychyi

### [Building efficient and reliable data lakes with Apache Iceberg](https://www.youtube.com/watch?v=QNmSXMQ-gY4)
**Date**: October 21, 2020, **Authors**: Anton Okolnychyi, Vishwa Lakkundi

### [Spark and Iceberg at Apple's Scale - Leveraging differential files for efficient upserts and deletes](https://www.youtube.com/watch?v=IzkSGKoUxcQ)
**Date**: October 21, 2020, **Authors**: Anton Okolnychyi, Vishwa Lakkundi

### [Apache Iceberg - A Table Format for Huge Analytic Datasets](https://www.youtube.com/watch?v=mf8Hb0coI6o)
**Date**: October 21, 2020, **Author**: Ryan Blue 
