/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.compute;

import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.deployment.DeploymentUnit;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalNode;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologyEventListener;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologyService;
import org.apache.ignite.internal.cluster.management.topology.api.LogicalTopologySnapshot;
import org.apache.ignite.internal.compute.CancellableJobExecution;
import org.apache.ignite.internal.compute.ComputeComponent;
import org.apache.ignite.internal.compute.ComputeJobDataHolder;
import org.apache.ignite.internal.compute.ExecutionOptions;
import org.apache.ignite.internal.compute.FailSafeJobExecution;
import org.apache.ignite.internal.compute.NextWorkerSelector;
import org.apache.ignite.internal.compute.RemoteExecutionContext;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.network.TopologyService;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.network.ClusterNode;
import org.jetbrains.annotations.Nullable;

class ComputeJobFailover {
    private static final IgniteLogger LOG = Loggers.forClass(ComputeJobFailover.class);
    private final Executor executor;
    private final ComputeComponent computeComponent;
    private final LogicalTopologyService logicalTopologyService;
    private final TopologyService topologyService;
    private final NextWorkerSelector nextWorkerSelector;
    private final AtomicReference<ClusterNode> runningWorkerNode;
    private final RemoteExecutionContext jobContext;

    ComputeJobFailover(ComputeComponent computeComponent, LogicalTopologyService logicalTopologyService, TopologyService topologyService, ClusterNode workerNode, NextWorkerSelector nextWorkerSelector, Executor executor, List<DeploymentUnit> units, String jobClassName, ExecutionOptions executionOptions, @Nullable ComputeJobDataHolder arg) {
        this.computeComponent = computeComponent;
        this.runningWorkerNode = new AtomicReference<ClusterNode>(workerNode);
        this.logicalTopologyService = logicalTopologyService;
        this.topologyService = topologyService;
        this.nextWorkerSelector = nextWorkerSelector;
        this.jobContext = new RemoteExecutionContext(units, jobClassName, executionOptions, arg);
        this.executor = executor;
    }

    CancellableJobExecution<ComputeJobDataHolder> failSafeExecute() {
        CancellableJobExecution<ComputeJobDataHolder> jobExecution = this.launchJobOn(this.runningWorkerNode.get());
        this.jobContext.initJobExecution(new FailSafeJobExecution<ComputeJobDataHolder>(jobExecution));
        OnNodeLeft nodeLeftEventListener = new OnNodeLeft();
        this.logicalTopologyService.addEventListener((LogicalTopologyEventListener)nodeLeftEventListener);
        jobExecution.resultAsync().whenComplete((r, e) -> this.logicalTopologyService.removeEventListener(nodeLeftEventListener));
        return this.jobContext.failSafeJobExecution();
    }

    private CancellableJobExecution<ComputeJobDataHolder> launchJobOn(ClusterNode runningWorkerNode) {
        if (runningWorkerNode.name().equals(this.topologyService.localMember().name())) {
            return this.computeComponent.executeLocally(this.jobContext.executionOptions(), this.jobContext.units(), this.jobContext.jobClassName(), this.jobContext.arg(), null);
        }
        return this.computeComponent.executeRemotely(this.jobContext.executionOptions(), runningWorkerNode, this.jobContext.units(), this.jobContext.jobClassName(), this.jobContext.arg(), null);
    }

    class OnNodeLeft
    implements LogicalTopologyEventListener {
        OnNodeLeft() {
        }

        public void onNodeLeft(LogicalNode leftNode, LogicalTopologySnapshot newTopology) {
            if (!ComputeJobFailover.this.runningWorkerNode.get().id().equals(leftNode.id())) {
                return;
            }
            LOG.info("Worker node {} has left the cluster.", new Object[]{leftNode.name()});
            ComputeJobFailover.this.executor.execute(this::selectNewWorker);
        }

        private void selectNewWorker() {
            ComputeJobFailover.this.nextWorkerSelector.next().thenAccept(nextWorker -> {
                if (nextWorker == null) {
                    LOG.warn("No more worker nodes to restart the job. Failing the job {}.", new Object[]{ComputeJobFailover.this.jobContext.jobClassName()});
                    FailSafeJobExecution<ComputeJobDataHolder> failSafeJobExecution = ComputeJobFailover.this.jobContext.failSafeJobExecution();
                    failSafeJobExecution.completeExceptionally((Exception)new IgniteInternalException(ErrorGroups.Compute.COMPUTE_JOB_FAILED_ERR));
                    return;
                }
                if (ComputeJobFailover.this.topologyService.getByConsistentId(nextWorker.name()) == null) {
                    LOG.warn("Worker node {} is not found in the cluster", new Object[]{nextWorker.name()});
                    ComputeJobFailover.this.executor.execute(this::selectNewWorker);
                    return;
                }
                LOG.info("Restarting the job {} on node {}.", new Object[]{ComputeJobFailover.this.jobContext.jobClassName(), nextWorker.name()});
                ComputeJobFailover.this.runningWorkerNode.set((ClusterNode)nextWorker);
                CancellableJobExecution<ComputeJobDataHolder> jobExecution = ComputeJobFailover.this.launchJobOn(ComputeJobFailover.this.runningWorkerNode.get());
                ComputeJobFailover.this.jobContext.updateJobExecution(jobExecution);
            });
        }
    }
}

