/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.deployment;

import io.micronaut.http.multipart.CompletedFileUpload;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.deployunit.DeploymentUnit;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class CompletedFileUploadSubscriber
implements Subscriber<CompletedFileUpload>,
AutoCloseable {
    private static final IgniteLogger LOG = Loggers.forClass(CompletedFileUploadSubscriber.class);
    private final CompletableFuture<DeploymentUnit> result = new CompletableFuture();
    private final Map<String, InputStream> content = new HashMap<String, InputStream>();
    private IOException ex;

    CompletedFileUploadSubscriber() {
    }

    public void onSubscribe(Subscription subscription) {
        subscription.request(Long.MAX_VALUE);
    }

    public void onNext(CompletedFileUpload item) {
        try {
            this.content.put(item.getFilename(), item.getInputStream());
        }
        catch (IOException e) {
            LOG.error("Failed to read file: " + item.getFilename(), (Throwable)e);
            if (this.ex != null) {
                this.ex.addSuppressed(e);
            }
            this.ex = e;
        }
    }

    public void onError(Throwable throwable) {
        this.result.completeExceptionally(throwable);
    }

    public void onComplete() {
        if (this.ex != null) {
            this.result.completeExceptionally(this.ex);
        } else {
            this.result.complete(new DeploymentUnit(this.content));
        }
    }

    public CompletableFuture<DeploymentUnit> result() {
        return this.result;
    }

    @Override
    public void close() throws Exception {
        this.result.thenAccept(it -> {
            try {
                it.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }
}

