/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.netty.channel.converters;

import io.micronaut.context.annotation.Requires;
import io.micronaut.context.env.Environment;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.TypeHint;
import io.micronaut.core.reflect.GenericTypeUtils;
import io.micronaut.core.reflect.ReflectionUtils;
import io.micronaut.http.netty.channel.converters.ChannelOptionFactory;
import io.micronaut.http.netty.channel.converters.EpollChannelOptionFactory;
import io.micronaut.http.netty.channel.converters.KQueueChannelOptionFactory;
import io.netty.channel.ChannelOption;
import jakarta.inject.Singleton;
import java.lang.reflect.Field;
import java.util.Optional;

@Internal
@Requires(missingBeans={EpollChannelOptionFactory.class, KQueueChannelOptionFactory.class})
@Singleton
@TypeHint(value={ChannelOption.class}, accessType={TypeHint.AccessType.ALL_DECLARED_FIELDS})
public class DefaultChannelOptionFactory
implements ChannelOptionFactory {
    private static Object processChannelOptionValue(Class<? extends ChannelOption> cls, String name, Object value, Environment env) {
        Optional typeArg;
        Optional declaredField = ReflectionUtils.findField(cls, (String)name);
        if (declaredField.isPresent() && (typeArg = GenericTypeUtils.resolveGenericTypeArgument((Field)((Field)declaredField.get()))).isPresent()) {
            Optional converted = env.convert(value, (Class)typeArg.get());
            value = converted.orElse(value);
        }
        return value;
    }

    static Object convertValue(ChannelOption<?> option, Class<? extends ChannelOption> cls, Object value, Environment env) {
        String name = option.name();
        if (ChannelOption.exists((String)name)) {
            int idx = name.lastIndexOf(35);
            String optionName = idx > 0 && idx < name.length() - 1 ? name.substring(idx) : name;
            return DefaultChannelOptionFactory.processChannelOptionValue(cls, optionName, value, env);
        }
        return value;
    }

    static ChannelOption<?> channelOption(String name, Class<?> ... classes) {
        for (Class<?> cls : classes) {
            String composedName = cls.getName() + '#' + name;
            if (!ChannelOption.exists((String)composedName)) continue;
            return ChannelOption.valueOf((String)composedName);
        }
        return ChannelOption.valueOf((String)name);
    }
}

