/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.storage;

import java.io.IOException;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogTableDescriptor;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite.internal.catalog.events.CreateIndexEventParameters;
import org.apache.ignite.internal.catalog.storage.Fireable;
import org.apache.ignite.internal.catalog.storage.UpdateEntry;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogObjectSerializer;
import org.apache.ignite.internal.catalog.storage.serialization.CatalogSerializationUtils;
import org.apache.ignite.internal.catalog.storage.serialization.MarshallableEntryType;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.io.IgniteDataInput;
import org.apache.ignite.internal.util.io.IgniteDataOutput;

public class NewIndexEntry
implements UpdateEntry,
Fireable {
    public static final CatalogObjectSerializer<NewIndexEntry> SERIALIZER = new NewIndexEntrySerializer();
    private final CatalogIndexDescriptor descriptor;

    public NewIndexEntry(CatalogIndexDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public CatalogIndexDescriptor descriptor() {
        return this.descriptor;
    }

    @Override
    public int typeId() {
        return MarshallableEntryType.NEW_INDEX.id();
    }

    @Override
    public CatalogEvent eventType() {
        return CatalogEvent.INDEX_CREATE;
    }

    @Override
    public CatalogEventParameters createEventParameters(long causalityToken, int catalogVersion) {
        return new CreateIndexEventParameters(causalityToken, catalogVersion, this.descriptor);
    }

    @Override
    public Catalog applyUpdate(Catalog catalog, long causalityToken) {
        CatalogTableDescriptor table = CatalogUtils.tableOrThrow(catalog, this.descriptor.tableId());
        CatalogSchemaDescriptor schema = CatalogUtils.schemaOrThrow(catalog, table.schemaId());
        this.descriptor.updateToken(causalityToken);
        return new Catalog(catalog.version(), catalog.time(), catalog.objectIdGenState(), catalog.zones(), CatalogUtils.replaceSchema(new CatalogSchemaDescriptor(schema.id(), schema.name(), schema.tables(), (CatalogIndexDescriptor[])ArrayUtils.concat((Object[])schema.indexes(), (Object[])new CatalogIndexDescriptor[]{this.descriptor}), schema.systemViews(), causalityToken), catalog.schemas()), CatalogUtils.defaultZoneIdOpt(catalog));
    }

    public String toString() {
        return S.toString((Object)this);
    }

    private static class NewIndexEntrySerializer
    implements CatalogObjectSerializer<NewIndexEntry> {
        private NewIndexEntrySerializer() {
        }

        @Override
        public NewIndexEntry readFrom(IgniteDataInput input) throws IOException {
            CatalogIndexDescriptor descriptor = CatalogSerializationUtils.IDX_SERIALIZER.readFrom(input);
            return new NewIndexEntry(descriptor);
        }

        @Override
        public void writeTo(NewIndexEntry entry, IgniteDataOutput output) throws IOException {
            CatalogSerializationUtils.IDX_SERIALIZER.writeTo(entry.descriptor(), output);
        }
    }
}

