/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Intersect;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.Minus;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMdColumnUniqueness;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RelMdUniqueKeys
implements MetadataHandler<BuiltInMetadata.UniqueKeys> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(new RelMdUniqueKeys(), BuiltInMetadata.UniqueKeys.Handler.class);

    private RelMdUniqueKeys() {
    }

    @Override
    public MetadataDef<BuiltInMetadata.UniqueKeys> getDef() {
        return BuiltInMetadata.UniqueKeys.DEF;
    }

    public @Nullable Set<ImmutableBitSet> getUniqueKeys(Filter rel, RelMetadataQuery mq, boolean ignoreNulls) {
        Set<ImmutableBitSet> uniqueKeys = mq.getUniqueKeys(rel.getInput(), ignoreNulls);
        if (uniqueKeys == null) {
            return null;
        }
        RelOptPredicateList predicates = mq.getPulledUpPredicates(rel);
        if (RelOptPredicateList.isEmpty(predicates)) {
            return uniqueKeys;
        }
        ImmutableBitSet constantColumns = RelMdColumnUniqueness.getConstantColumnSet(predicates);
        return uniqueKeys.stream().map(key -> key.except(constantColumns)).collect(Collectors.toSet());
    }

    public @Nullable Set<ImmutableBitSet> getUniqueKeys(Sort rel, RelMetadataQuery mq, boolean ignoreNulls) {
        Double maxRowCount = mq.getMaxRowCount(rel);
        if (maxRowCount != null && maxRowCount <= 1.0) {
            return ImmutableSet.of((Object)ImmutableBitSet.of());
        }
        return mq.getUniqueKeys(rel.getInput(), ignoreNulls);
    }

    public @Nullable Set<ImmutableBitSet> getUniqueKeys(Correlate rel, RelMetadataQuery mq, boolean ignoreNulls) {
        return mq.getUniqueKeys(rel.getLeft(), ignoreNulls);
    }

    public @Nullable Set<ImmutableBitSet> getUniqueKeys(TableModify rel, RelMetadataQuery mq, boolean ignoreNulls) {
        return mq.getUniqueKeys(rel.getInput(), ignoreNulls);
    }

    public Set<ImmutableBitSet> getUniqueKeys(Project rel, RelMetadataQuery mq, boolean ignoreNulls) {
        return RelMdUniqueKeys.getProjectUniqueKeys(rel, mq, ignoreNulls, rel.getProjects());
    }

    public @Nullable Set<ImmutableBitSet> getUniqueKeys(Calc rel, RelMetadataQuery mq, boolean ignoreNulls) {
        RexProgram program = rel.getProgram();
        return RelMdUniqueKeys.getProjectUniqueKeys(rel, mq, ignoreNulls, Util.transform(program.getProjectList(), program::expandLocalRef));
    }

    private static Set<ImmutableBitSet> getProjectUniqueKeys(SingleRel rel, RelMetadataQuery mq, boolean ignoreNulls, List<RexNode> projExprs) {
        ImmutableMultimap.Builder inToOutPosBuilder = ImmutableMultimap.builder();
        ImmutableBitSet.Builder mappedInColumnsBuilder = ImmutableBitSet.builder();
        for (int i = 0; i < projExprs.size(); ++i) {
            RexNode projExpr = projExprs.get(i);
            if (!(projExpr instanceof RexInputRef)) continue;
            int inputIndex = ((RexInputRef)projExpr).getIndex();
            inToOutPosBuilder.put((Object)inputIndex, (Object)i);
            mappedInColumnsBuilder.set(inputIndex);
        }
        ImmutableBitSet inColumnsUsed = mappedInColumnsBuilder.build();
        if (inColumnsUsed.isEmpty()) {
            return ImmutableSet.of();
        }
        Set<ImmutableBitSet> childUniqueKeySet = mq.getUniqueKeys(rel.getInput(), ignoreNulls);
        if (childUniqueKeySet == null) {
            return ImmutableSet.of();
        }
        Map mapInToOutPos = Maps.transformValues((Map)inToOutPosBuilder.build().asMap(), ImmutableBitSet::of);
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        for (ImmutableBitSet colMask : childUniqueKeySet) {
            if (!inColumnsUsed.contains(colMask)) continue;
            Iterable product = Linq4j.product(Util.transform(colMask, in -> Util.filter(((ImmutableBitSet)Objects.requireNonNull(mapInToOutPos.get(in), () -> "no entry for column " + in + " in mapInToOutPos: " + mapInToOutPos)).powerSet(), bs -> !bs.isEmpty())));
            resultBuilder.addAll(Util.transform(product, ImmutableBitSet::union));
        }
        return resultBuilder.build();
    }

    public @Nullable Set<ImmutableBitSet> getUniqueKeys(Join rel, RelMetadataQuery mq, boolean ignoreNulls) {
        if (!rel.getJoinType().projectsRight()) {
            return mq.getUniqueKeys(rel.getLeft(), ignoreNulls);
        }
        RelNode left = rel.getLeft();
        RelNode right = rel.getRight();
        HashSet<ImmutableBitSet> retSet = new HashSet<ImmutableBitSet>();
        Set<ImmutableBitSet> leftSet = mq.getUniqueKeys(left, ignoreNulls);
        HashSet<ImmutableBitSet> rightSet = null;
        Set<ImmutableBitSet> tmpRightSet = mq.getUniqueKeys(right, ignoreNulls);
        int nFieldsOnLeft = left.getRowType().getFieldCount();
        if (tmpRightSet != null) {
            rightSet = new HashSet<ImmutableBitSet>();
            for (ImmutableBitSet colMask : tmpRightSet) {
                ImmutableBitSet.Builder tmpMask = ImmutableBitSet.builder();
                for (int bit : colMask) {
                    tmpMask.set(bit + nFieldsOnLeft);
                }
                rightSet.add(tmpMask.build());
            }
            if (leftSet != null) {
                for (ImmutableBitSet colMaskRight : rightSet) {
                    for (ImmutableBitSet colMaskLeft : leftSet) {
                        retSet.add(colMaskLeft.union(colMaskRight));
                    }
                }
            }
        }
        JoinInfo joinInfo = rel.analyzeCondition();
        Boolean leftUnique = mq.areColumnsUnique(left, joinInfo.leftSet(), ignoreNulls);
        Boolean rightUnique = mq.areColumnsUnique(right, joinInfo.rightSet(), ignoreNulls);
        if (rightUnique != null && rightUnique.booleanValue() && leftSet != null && !rel.getJoinType().generatesNullsOnLeft()) {
            ImmutableBitSet leftConstants = RelMdUniqueKeys.getConstantJoinKeys(joinInfo.leftKeys, joinInfo.rightKeys, right, mq);
            leftSet.stream().map(set -> set.except(leftConstants)).forEach(retSet::add);
        }
        if (leftUnique != null && leftUnique.booleanValue() && rightSet != null && !rel.getJoinType().generatesNullsOnRight()) {
            ImmutableBitSet rightConstants = RelMdUniqueKeys.getConstantJoinKeys(joinInfo.rightKeys, joinInfo.leftKeys, left, mq);
            rightSet.stream().map(set -> set.except(rightConstants)).forEach(retSet::add);
        }
        HashSet<ImmutableBitSet> reducedSet = new HashSet<ImmutableBitSet>();
        for (ImmutableBitSet bigger : retSet) {
            if (!retSet.stream().filter(smaller -> !bigger.equals(smaller)).noneMatch(bigger::contains)) continue;
            reducedSet.add(bigger);
        }
        return reducedSet;
    }

    private static ImmutableBitSet getConstantJoinKeys(ImmutableIntList keys, ImmutableIntList otherKeys, RelNode otherRel, RelMetadataQuery mq) {
        ImmutableBitSet otherConstants;
        Double maxRowCount = mq.getMaxRowCount(otherRel);
        if (maxRowCount != null && maxRowCount <= 1.0) {
            int size = otherRel.getRowType().getFieldList().size();
            otherConstants = ImmutableBitSet.range(size);
        } else {
            otherConstants = RelMdColumnUniqueness.getConstantColumnSet(mq.getPulledUpPredicates(otherRel));
        }
        ImmutableBitSet.Builder builder = ImmutableBitSet.builder();
        for (int i = 0; i < keys.size(); ++i) {
            if (!otherConstants.get(otherKeys.get(i))) continue;
            builder.set(keys.get(i));
        }
        return builder.build();
    }

    public Set<ImmutableBitSet> getUniqueKeys(Aggregate rel, RelMetadataQuery mq, boolean ignoreNulls) {
        if (Aggregate.isSimple(rel)) {
            ImmutableSet keysInGroupBy;
            ImmutableBitSet groupKeys = rel.getGroupSet();
            RelOptPredicateList pulledUpPredicates = mq.getPulledUpPredicates(rel);
            ImmutableBitSet reducedGroupKeys = groupKeys.except(RelMdColumnUniqueness.getConstantColumnSet(pulledUpPredicates));
            Set<ImmutableBitSet> inputUniqueKeys = mq.getUniqueKeys(rel.getInput(), ignoreNulls);
            ImmutableSet preciseUniqueKeys = inputUniqueKeys == null ? ImmutableSet.of((Object)reducedGroupKeys) : ((keysInGroupBy = inputUniqueKeys.stream().filter(reducedGroupKeys::contains).collect(Collectors.toSet())).isEmpty() ? ImmutableSet.of((Object)reducedGroupKeys) : keysInGroupBy);
            ImmutableSet.Builder keysBuilder = ImmutableSet.builder();
            if (inputUniqueKeys != null) {
                for (ImmutableBitSet inputKey : inputUniqueKeys) {
                    keysBuilder.addAll(RelMdUniqueKeys.getPassedThroughCols(inputKey, rel));
                }
            }
            return RelMdUniqueKeys.filterSupersets((Set<ImmutableBitSet>)Sets.union((Set)preciseUniqueKeys, (Set)keysBuilder.build()));
        }
        if (ignoreNulls) {
            return ImmutableSet.of((Object)rel.getGroupSet());
        }
        return ImmutableSet.of();
    }

    private static Set<ImmutableBitSet> filterSupersets(Set<ImmutableBitSet> uniqueKeys) {
        HashSet<ImmutableBitSet> minimalKeys = new HashSet<ImmutableBitSet>();
        block0: for (ImmutableBitSet candidateKey : uniqueKeys) {
            for (ImmutableBitSet possibleSubset : uniqueKeys) {
                if (candidateKey.equals(possibleSubset) || !candidateKey.contains(possibleSubset)) continue;
                continue block0;
            }
            minimalKeys.add(candidateKey);
        }
        return minimalKeys;
    }

    private static Set<ImmutableBitSet> getPassedThroughCols(ImmutableBitSet inputColumns, Aggregate rel) {
        Preconditions.checkArgument((boolean)Aggregate.isSimple(rel));
        HashSet<ImmutableBitSet> conbinations = new HashSet<ImmutableBitSet>();
        conbinations.add(ImmutableBitSet.of());
        for (Integer inputColumn : inputColumns.asSet()) {
            ImmutableBitSet passedThroughCols = RelMdUniqueKeys.getPassedThroughCols(inputColumn, rel);
            HashSet<ImmutableBitSet> crossProduct = new HashSet<ImmutableBitSet>();
            for (ImmutableBitSet set : conbinations) {
                for (Integer passedThroughCol : passedThroughCols) {
                    crossProduct.add(set.rebuild().set(passedThroughCol).build());
                }
            }
            conbinations = crossProduct;
        }
        return conbinations;
    }

    private static ImmutableBitSet getPassedThroughCols(Integer inputColumn, Aggregate rel) {
        ImmutableBitSet.Builder builder = ImmutableBitSet.builder();
        if (rel.getGroupSet().get(inputColumn)) {
            builder.set(inputColumn);
        }
        int aggCallsOffset = rel.getGroupSet().length();
        int size = rel.getAggCallList().size();
        for (int i = 0; i < size; ++i) {
            AggregateCall call = rel.getAggCallList().get(i);
            if (!RelMdColumnUniqueness.PASSTHROUGH_AGGREGATIONS.contains((Object)call.getAggregation().getKind()) || !call.getArgList().get(0).equals(inputColumn)) continue;
            builder.set(i + aggCallsOffset);
        }
        return builder.build();
    }

    public Set<ImmutableBitSet> getUniqueKeys(Union rel, RelMetadataQuery mq, boolean ignoreNulls) {
        if (!rel.all) {
            return ImmutableSet.of((Object)ImmutableBitSet.range(rel.getRowType().getFieldCount()));
        }
        return ImmutableSet.of();
    }

    public Set<ImmutableBitSet> getUniqueKeys(Intersect rel, RelMetadataQuery mq, boolean ignoreNulls) {
        ImmutableSet.Builder keys = new ImmutableSet.Builder();
        for (RelNode input : rel.getInputs()) {
            Set<ImmutableBitSet> uniqueKeys = mq.getUniqueKeys(input, ignoreNulls);
            if (uniqueKeys == null) continue;
            keys.addAll(uniqueKeys);
        }
        ImmutableSet uniqueKeys = keys.build();
        if (!uniqueKeys.isEmpty()) {
            return uniqueKeys;
        }
        if (!rel.all) {
            return ImmutableSet.of((Object)ImmutableBitSet.range(rel.getRowType().getFieldCount()));
        }
        return ImmutableSet.of();
    }

    public Set<ImmutableBitSet> getUniqueKeys(Minus rel, RelMetadataQuery mq, boolean ignoreNulls) {
        Set<ImmutableBitSet> uniqueKeys = mq.getUniqueKeys(rel.getInput(0), ignoreNulls);
        if (uniqueKeys != null) {
            return uniqueKeys;
        }
        if (!rel.all) {
            return ImmutableSet.of((Object)ImmutableBitSet.range(rel.getRowType().getFieldCount()));
        }
        return ImmutableSet.of();
    }

    public @Nullable Set<ImmutableBitSet> getUniqueKeys(TableScan rel, RelMetadataQuery mq, boolean ignoreNulls) {
        BuiltInMetadata.UniqueKeys.Handler handler = rel.getTable().unwrap(BuiltInMetadata.UniqueKeys.Handler.class);
        if (handler != null) {
            return handler.getUniqueKeys(rel, mq, ignoreNulls);
        }
        List<ImmutableBitSet> keys = rel.getTable().getKeys();
        if (keys == null) {
            return null;
        }
        for (ImmutableBitSet key : keys) {
            assert (rel.getTable().isKey(key));
        }
        return ImmutableSet.copyOf(keys);
    }

    public @Nullable Set<ImmutableBitSet> getUniqueKeys(Values rel, RelMetadataQuery mq, boolean ignoreNulls) {
        ImmutableList<ImmutableList<RexLiteral>> tuples = rel.tuples;
        if (tuples.size() <= 1) {
            return ImmutableSet.of((Object)ImmutableBitSet.of());
        }
        ArrayList ranges = new ArrayList();
        int rowSize = ((ImmutableList)tuples.get(0)).size();
        for (int i = 0; i < rowSize; ++i) {
            ranges.add(new HashSet());
        }
        for (ImmutableList tuple : tuples) {
            for (int i = 0; i < rowSize; ++i) {
                ((Set)ranges.get(i)).add(tuple.get(i));
            }
        }
        ImmutableSet.Builder keySetBuilder = ImmutableSet.builder();
        for (int i = 0; i < ranges.size(); ++i) {
            Set range = (Set)ranges.get(i);
            if (range.size() != tuples.size()) continue;
            keySetBuilder.add((Object)ImmutableBitSet.of(i));
        }
        return keySetBuilder.build();
    }

    public @Nullable Set<ImmutableBitSet> getUniqueKeys(RelNode rel, RelMetadataQuery mq, boolean ignoreNulls) {
        return null;
    }
}

