/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util.format.postgresql.format.compiled;

import java.text.ParseException;
import java.text.ParsePosition;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Locale;
import java.util.Set;
import org.apache.calcite.util.format.postgresql.ChronoUnitEnum;
import org.apache.calcite.util.format.postgresql.PatternModifier;
import org.apache.calcite.util.format.postgresql.format.compiled.CompiledPattern;

public class BcAdCompiledPattern
extends CompiledPattern {
    private final boolean upperCase;
    private final boolean includePeriods;

    public BcAdCompiledPattern(Set<PatternModifier> modifiers, boolean upperCase, boolean includePeriods) {
        super(ChronoUnitEnum.ERAS, modifiers);
        this.upperCase = upperCase;
        this.includePeriods = includePeriods;
    }

    @Override
    public String convertToString(ZonedDateTime dateTime, Locale locale) {
        String stringValue;
        int intValue = dateTime.get(ChronoField.ERA);
        if (intValue == 0) {
            stringValue = this.includePeriods ? "b.c." : "bc";
        } else {
            String string = stringValue = this.includePeriods ? "a.d." : "ad";
        }
        if (this.upperCase) {
            return stringValue.toUpperCase(Locale.ROOT);
        }
        return stringValue;
    }

    @Override
    public int parseValue(ParsePosition inputPosition, String input, boolean enforceLength, Locale locale) throws ParseException {
        String inputTrimmed;
        String pmValue;
        String bcValue = this.includePeriods ? "b.c." : "bc";
        String string = pmValue = this.includePeriods ? "a.d." : "ad";
        if (this.upperCase) {
            bcValue = bcValue.toUpperCase(Locale.ROOT);
            pmValue = pmValue.toUpperCase(Locale.ROOT);
        }
        if ((inputTrimmed = input.substring(inputPosition.getIndex())).startsWith(bcValue)) {
            inputPosition.setIndex(inputPosition.getIndex() + bcValue.length());
            return 0;
        }
        if (inputTrimmed.startsWith(pmValue)) {
            inputPosition.setIndex(inputPosition.getIndex() + pmValue.length());
            return 1;
        }
        throw new ParseException("Unable to parse value", inputPosition.getIndex());
    }

    @Override
    protected int getBaseFormatPatternLength() {
        return this.includePeriods ? 4 : 2;
    }
}

