/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.html.renderer;

import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.util.html.Attributes;
import com.vladsch.flexmark.util.html.MutableAttributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolvedLink {
    @NotNull
    private final LinkType myLinkType;
    @NotNull
    private final String myUrl;
    @NotNull
    private final LinkStatus myStatus;
    @Nullable
    private MutableAttributes myAttributes;

    public ResolvedLink(@NotNull LinkType linkType, @NotNull CharSequence url) {
        this(linkType, url, null, LinkStatus.UNKNOWN);
    }

    public ResolvedLink(@NotNull LinkType linkType, @NotNull CharSequence url, @Nullable Attributes attributes) {
        this(linkType, url, attributes, LinkStatus.UNKNOWN);
    }

    @Nullable
    public Attributes getAttributes() {
        return this.myAttributes == null ? null : this.myAttributes.toImmutable();
    }

    @NotNull
    public Attributes getNonNullAttributes() {
        if (this.myAttributes == null) {
            this.myAttributes = new MutableAttributes();
        }
        return this.myAttributes.toImmutable();
    }

    @NotNull
    public MutableAttributes getMutableAttributes() {
        if (this.myAttributes == null) {
            this.myAttributes = new MutableAttributes();
        }
        return this.myAttributes;
    }

    public ResolvedLink(@NotNull LinkType linkType, CharSequence url, @Nullable Attributes attributes, @NotNull LinkStatus status) {
        this.myLinkType = linkType;
        this.myUrl = String.valueOf(url);
        this.myStatus = status;
        if (attributes != null) {
            this.getMutableAttributes().addValues(attributes);
        }
    }

    public ResolvedLink withLinkType(@NotNull LinkType linkType) {
        return linkType == this.myLinkType ? this : new ResolvedLink(linkType, this.myUrl, (Attributes)this.myAttributes, this.myStatus);
    }

    public ResolvedLink withStatus(@NotNull LinkStatus status) {
        return status == this.myStatus ? this : new ResolvedLink(this.myLinkType, this.myUrl, (Attributes)this.myAttributes, status);
    }

    @NotNull
    public LinkType getLinkType() {
        return this.myLinkType;
    }

    @NotNull
    public LinkStatus getStatus() {
        return this.myStatus;
    }

    @NotNull
    public ResolvedLink withUrl(@NotNull CharSequence url) {
        String useUrl = String.valueOf(url);
        return this.myUrl.equals(useUrl) ? this : new ResolvedLink(this.myLinkType, useUrl, (Attributes)this.myAttributes, this.myStatus);
    }

    @NotNull
    public String getUrl() {
        return this.myUrl;
    }

    @NotNull
    public String getPageRef() {
        int pos = this.myUrl.indexOf(35);
        if (pos < 0) {
            return this.myUrl;
        }
        return this.myUrl.substring(0, pos);
    }

    @Nullable
    public String getAnchorRef() {
        int pos = this.myUrl.indexOf(35);
        if (pos < 0) {
            return null;
        }
        return this.myUrl.substring(pos + 1);
    }

    @NotNull
    public ResolvedLink withTitle(@Nullable CharSequence title) {
        String haveTitle;
        String string = haveTitle = this.myAttributes == null ? null : this.myAttributes.getValue((CharSequence)"title");
        if (title == haveTitle || haveTitle != null && title != null && haveTitle.contentEquals(title)) {
            return this;
        }
        MutableAttributes attributes = new MutableAttributes((Attributes)this.myAttributes);
        if (title == null) {
            attributes.remove((CharSequence)"title");
            if (attributes.isEmpty()) {
                attributes = null;
            }
        } else {
            attributes.replaceValue((CharSequence)"title", title);
        }
        return new ResolvedLink(this.myLinkType, this.myUrl, (Attributes)attributes, this.myStatus);
    }

    @Nullable
    public String getTitle() {
        return this.myAttributes == null ? null : this.myAttributes.getValue((CharSequence)"title");
    }

    @NotNull
    public ResolvedLink withTarget(@Nullable CharSequence target) {
        String haveTarget;
        String string = haveTarget = this.myAttributes == null ? null : this.myAttributes.getValue((CharSequence)"target");
        if (target == haveTarget || haveTarget != null && target != null && haveTarget.contentEquals(target)) {
            return this;
        }
        MutableAttributes attributes = new MutableAttributes((Attributes)this.myAttributes);
        if (target == null) {
            attributes.remove((CharSequence)"target");
            if (attributes.isEmpty()) {
                attributes = null;
            }
        } else {
            attributes.replaceValue((CharSequence)"target", target);
        }
        return new ResolvedLink(this.myLinkType, this.myUrl, (Attributes)attributes, this.myStatus);
    }

    public String getTarget() {
        return this.myAttributes == null ? null : this.myAttributes.getValue((CharSequence)"target");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResolvedLink)) {
            return false;
        }
        ResolvedLink link = (ResolvedLink)o;
        if (!this.myLinkType.equals(link.myLinkType)) {
            return false;
        }
        if (!this.myUrl.equals(link.myUrl)) {
            return false;
        }
        return this.myStatus.equals(link.myStatus);
    }

    public int hashCode() {
        int result = this.myLinkType.hashCode();
        result = 31 * result + this.myUrl.hashCode();
        result = 31 * result + this.myStatus.hashCode();
        return result;
    }
}

