/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.raft;

import java.util.List;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotMvDataResponse;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotMvDataResponseBuilder;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;

class SnapshotMvDataResponseDeserializer
implements MessageDeserializer<SnapshotMvDataResponse> {
    private final SnapshotMvDataResponseBuilder msg;

    SnapshotMvDataResponseDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.snapshotMvDataResponse();
    }

    public Class<SnapshotMvDataResponse> klass() {
        return SnapshotMvDataResponse.class;
    }

    public SnapshotMvDataResponse getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                boolean tmp = reader.readBoolean("finish");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.finish(tmp);
                reader.incrementState();
            }
            case 1: {
                List tmp = reader.readList("rows", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.rows(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(SnapshotMvDataResponse.class);
    }
}

