/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.raft;

import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotMvDataResponse;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotMvDataResponseBuilder;
import org.apache.ignite.internal.partition.replicator.network.raft.SnapshotMvDataResponseSerializer;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class SnapshotMvDataResponseImpl
implements SnapshotMvDataResponse,
Cloneable {
    public static final short GROUP_TYPE = 9;
    public static final short TYPE = 14;
    @IgniteToStringInclude
    private final boolean finish;
    @IgniteToStringInclude
    private final List<SnapshotMvDataResponse.ResponseEntry> rows;

    private SnapshotMvDataResponseImpl(boolean finish, List<SnapshotMvDataResponse.ResponseEntry> rows) {
        this.finish = finish;
        this.rows = rows;
    }

    @Override
    public boolean finish() {
        return this.finish;
    }

    @Override
    public List<SnapshotMvDataResponse.ResponseEntry> rows() {
        return this.rows;
    }

    public MessageSerializer serializer() {
        return SnapshotMvDataResponseSerializer.INSTANCE;
    }

    public short groupType() {
        return 9;
    }

    public String toString() {
        return S.toString(SnapshotMvDataResponseImpl.class, (Object)this);
    }

    public short messageType() {
        return 14;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        SnapshotMvDataResponseImpl otherMessage = (SnapshotMvDataResponseImpl)other;
        return Objects.equals(this.rows, otherMessage.rows) && this.finish == otherMessage.finish;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.finish, this.rows);
        return result;
    }

    public SnapshotMvDataResponseImpl clone() {
        try {
            return (SnapshotMvDataResponseImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static SnapshotMvDataResponseBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.rows != null) {
            for (SnapshotMvDataResponse.ResponseEntry obj : this.rows) {
                if (obj == null) continue;
                obj.prepareMarshal(usedDescriptors, marshaller);
            }
        }
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.rows != null) {
            for (SnapshotMvDataResponse.ResponseEntry obj : this.rows) {
                if (obj == null) continue;
                obj.unmarshal(marshaller, descriptorsObj);
            }
        }
    }

    private static class Builder
    implements SnapshotMvDataResponseBuilder {
        private boolean finish;
        private List<SnapshotMvDataResponse.ResponseEntry> rows;

        private Builder() {
        }

        @Override
        public SnapshotMvDataResponseBuilder finish(boolean finish) {
            this.finish = finish;
            return this;
        }

        @Override
        public SnapshotMvDataResponseBuilder rows(List<SnapshotMvDataResponse.ResponseEntry> rows) {
            Objects.requireNonNull(rows, "rows is not marked @Nullable");
            this.rows = rows;
            return this;
        }

        @Override
        public boolean finish() {
            return this.finish;
        }

        @Override
        public List<SnapshotMvDataResponse.ResponseEntry> rows() {
            return this.rows;
        }

        @Override
        public SnapshotMvDataResponse build() {
            return new SnapshotMvDataResponseImpl(this.finish, Objects.requireNonNull(this.rows, "rows is not marked @Nullable"));
        }
    }
}

