/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.replicator.TablePartitionId;
import org.apache.ignite.internal.replicator.message.ReplicaMessageUtils;
import org.apache.ignite.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite.internal.tx.TransactionMeta;
import org.apache.ignite.internal.tx.TxState;
import org.apache.ignite.internal.tx.TxStateMeta;
import org.apache.ignite.internal.tx.message.TxMessagesFactory;
import org.apache.ignite.internal.tx.message.TxStateMetaFinishingMessage;
import org.jetbrains.annotations.Nullable;

public class TxStateMetaFinishing
extends TxStateMeta {
    private static final long serialVersionUID = 9122953981654023665L;
    private final CompletableFuture<TransactionMeta> txFinishFuture = new CompletableFuture();

    public TxStateMetaFinishing(@Nullable UUID txCoordinatorId, @Nullable TablePartitionId commitPartitionId) {
        super(TxState.FINISHING, txCoordinatorId, commitPartitionId, null);
    }

    public CompletableFuture<TransactionMeta> txFinishFuture() {
        return this.txFinishFuture;
    }

    @Override
    @Nullable
    public HybridTimestamp commitTimestamp() {
        throw new UnsupportedOperationException("Can't get commit timestamp from FINISHING transaction state meta.");
    }

    @Override
    public TxStateMetaFinishingMessage toTransactionMetaMessage(ReplicaMessagesFactory replicaMessagesFactory, TxMessagesFactory txMessagesFactory) {
        TablePartitionId commitPartitionId = this.commitPartitionId();
        return txMessagesFactory.txStateMetaFinishingMessage().txState(this.txState()).txCoordinatorId(this.txCoordinatorId()).commitPartitionId(commitPartitionId == null ? null : ReplicaMessageUtils.toTablePartitionIdMessage((ReplicaMessagesFactory)replicaMessagesFactory, (TablePartitionId)commitPartitionId)).commitTimestamp(this.commitTimestamp()).initialVacuumObservationTimestamp(this.initialVacuumObservationTimestamp()).cleanupCompletionTimestamp(this.cleanupCompletionTimestamp()).build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TxStateMetaFinishing that = (TxStateMetaFinishing)o;
        return this.txFinishFuture.equals(that.txFinishFuture);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.txFinishFuture.hashCode();
        return result;
    }
}

