/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.tx.storage.state.rocksdb;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.IntSupplier;
import java.util.stream.Collectors;
import org.apache.ignite.internal.close.ManuallyCloseable;
import org.apache.ignite.internal.components.LogSyncer;
import org.apache.ignite.internal.lang.IgniteInternalException;
import org.apache.ignite.internal.rocksdb.flush.RocksDbFlusher;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.Options;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.WriteOptions;

public class TxStateRocksDbSharedStorage
implements ManuallyCloseable {
    private static final String TX_STATE_CF;
    private volatile RocksDB db;
    private volatile DBOptions dbOptions;
    final WriteOptions writeOptions = new WriteOptions().setDisableWAL(true);
    final ReadOptions readOptions = new ReadOptions();
    private final Path dbPath;
    private volatile RocksDbFlusher flusher;
    private final AtomicBoolean stopGuard = new AtomicBoolean();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();
    private final ScheduledExecutorService scheduledExecutor;
    private final ExecutorService threadPool;
    private final IntSupplier flushDelaySupplier;
    private final LogSyncer logSyncer;

    public TxStateRocksDbSharedStorage(Path dbPath, ScheduledExecutorService scheduledExecutor, ExecutorService threadPool, LogSyncer logSyncer, IntSupplier flushDelaySupplier) {
        this.dbPath = dbPath;
        this.scheduledExecutor = scheduledExecutor;
        this.threadPool = threadPool;
        this.flushDelaySupplier = flushDelaySupplier;
        this.logSyncer = logSyncer;
    }

    RocksDB db() {
        return this.db;
    }

    CompletableFuture<Void> awaitFlush(boolean schedule) {
        return this.flusher.awaitFlush(schedule);
    }

    public void start() {
        try {
            List cfDescriptors;
            Files.createDirectories(this.dbPath, new FileAttribute[0]);
            this.flusher = new RocksDbFlusher("tx state storage", this.busyLock, this.scheduledExecutor, this.threadPool, this.flushDelaySupplier, this.logSyncer, () -> {});
            this.dbOptions = new DBOptions().setCreateIfMissing(true).setAtomicFlush(true).setListeners(List.of(this.flusher.listener())).setAvoidFlushDuringShutdown(true);
            try (Options opts = new Options();){
                cfDescriptors = RocksDB.listColumnFamilies((Options)opts, (String)this.dbPath.toAbsolutePath().toString()).stream().map(nameBytes -> new ColumnFamilyDescriptor(nameBytes, new ColumnFamilyOptions())).collect(Collectors.toList());
                cfDescriptors = cfDescriptors.isEmpty() ? List.of(new ColumnFamilyDescriptor(TX_STATE_CF.getBytes(StandardCharsets.UTF_8), new ColumnFamilyOptions())) : cfDescriptors;
            }
            ArrayList cfHandles = new ArrayList(cfDescriptors.size());
            this.db = RocksDB.open((DBOptions)this.dbOptions, (String)this.dbPath.toString(), cfDescriptors, cfHandles);
            this.flusher.init(this.db, cfHandles);
        }
        catch (Exception e) {
            throw new IgniteInternalException("Could not create transaction state storage", (Throwable)e);
        }
    }

    public void close() throws Exception {
        if (!this.stopGuard.compareAndSet(false, true)) {
            return;
        }
        this.busyLock.block();
        ArrayList<AutoCloseable> resources = new ArrayList<AutoCloseable>();
        resources.add(() -> ((RocksDbFlusher)this.flusher).stop());
        resources.add((AutoCloseable)this.readOptions);
        resources.add((AutoCloseable)this.writeOptions);
        resources.add((AutoCloseable)this.dbOptions);
        resources.add((AutoCloseable)this.db);
        Collections.reverse(resources);
        IgniteUtils.closeAll(resources);
    }

    static {
        RocksDB.loadLibrary();
        TX_STATE_CF = new String(RocksDB.DEFAULT_COLUMN_FAMILY, StandardCharsets.UTF_8);
    }
}

