/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.entity;

import java.util.Collection;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.entity.EntryMetaBuilder;
import org.apache.ignite.raft.jraft.entity.EnumOutter;
import org.apache.ignite.raft.jraft.entity.RaftOutter;

class EntryMetaDeserializer
implements MessageDeserializer<RaftOutter.EntryMeta> {
    private final EntryMetaBuilder msg;

    EntryMetaDeserializer(RaftMessagesFactory messageFactory) {
        this.msg = messageFactory.entryMeta();
    }

    public Class<RaftOutter.EntryMeta> klass() {
        return RaftOutter.EntryMeta.class;
    }

    public RaftOutter.EntryMeta getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                long tmp = reader.readLong("checksum");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.checksum(tmp);
                reader.incrementState();
            }
            case 1: {
                long tmp = reader.readLong("dataLen");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.dataLen(tmp);
                reader.incrementState();
            }
            case 2: {
                boolean tmp = reader.readBoolean("hasChecksum");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.hasChecksum(tmp);
                reader.incrementState();
            }
            case 3: {
                Collection tmp = reader.readCollection("learnersList", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.learnersList(tmp);
                reader.incrementState();
            }
            case 4: {
                Collection tmp = reader.readCollection("oldLearnersList", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.oldLearnersList(tmp);
                reader.incrementState();
            }
            case 5: {
                Collection tmp = reader.readCollection("oldPeersList", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.oldPeersList(tmp);
                reader.incrementState();
            }
            case 6: {
                Collection tmp = reader.readCollection("peersList", MessageCollectionItemType.STRING);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.peersList(tmp);
                reader.incrementState();
            }
            case 7: {
                long tmp = reader.readLong("term");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.term(tmp);
                reader.incrementState();
            }
            case 8: {
                int ordinalShifted = reader.readInt("type");
                if (!reader.isLastRead()) {
                    return false;
                }
                EnumOutter.EntryType tmp = ordinalShifted == 0 ? null : EnumOutter.EntryType.fromOrdinal(ordinalShifted - 1);
                this.msg.type(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(RaftOutter.EntryMeta.class);
    }
}

