/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.exec.ddl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogCommand;
import org.apache.ignite.internal.catalog.CatalogManager;
import org.apache.ignite.internal.catalog.DistributionZoneExistsValidationException;
import org.apache.ignite.internal.catalog.DistributionZoneNotFoundValidationException;
import org.apache.ignite.internal.catalog.IndexExistsValidationException;
import org.apache.ignite.internal.catalog.IndexNotFoundValidationException;
import org.apache.ignite.internal.catalog.SchemaExistsException;
import org.apache.ignite.internal.catalog.SchemaNotFoundException;
import org.apache.ignite.internal.catalog.TableExistsValidationException;
import org.apache.ignite.internal.catalog.TableNotFoundValidationException;
import org.apache.ignite.internal.catalog.commands.AbstractCreateIndexCommand;
import org.apache.ignite.internal.catalog.commands.AlterTableAddColumnCommand;
import org.apache.ignite.internal.catalog.commands.AlterTableAlterColumnCommand;
import org.apache.ignite.internal.catalog.commands.AlterTableDropColumnCommand;
import org.apache.ignite.internal.catalog.commands.AlterZoneCommand;
import org.apache.ignite.internal.catalog.commands.AlterZoneSetDefaultCommand;
import org.apache.ignite.internal.catalog.commands.CatalogUtils;
import org.apache.ignite.internal.catalog.commands.CreateSchemaCommand;
import org.apache.ignite.internal.catalog.commands.CreateTableCommand;
import org.apache.ignite.internal.catalog.commands.CreateZoneCommand;
import org.apache.ignite.internal.catalog.commands.DropIndexCommand;
import org.apache.ignite.internal.catalog.commands.DropSchemaCommand;
import org.apache.ignite.internal.catalog.commands.DropTableCommand;
import org.apache.ignite.internal.catalog.commands.DropZoneCommand;
import org.apache.ignite.internal.catalog.commands.RenameZoneCommand;
import org.apache.ignite.internal.catalog.descriptors.CatalogIndexDescriptor;
import org.apache.ignite.internal.catalog.descriptors.CatalogSchemaDescriptor;
import org.apache.ignite.internal.catalog.events.CatalogEvent;
import org.apache.ignite.internal.catalog.events.CatalogEventParameters;
import org.apache.ignite.internal.catalog.events.MakeIndexAvailableEventParameters;
import org.apache.ignite.internal.catalog.events.RemoveIndexEventParameters;
import org.apache.ignite.internal.event.Event;
import org.apache.ignite.internal.event.EventListener;
import org.apache.ignite.internal.future.InFlightFutures;
import org.apache.ignite.internal.hlc.ClockService;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.lang.NodeStoppingException;
import org.apache.ignite.internal.sql.engine.exec.LifecycleAware;
import org.apache.ignite.internal.util.IgniteSpinBusyLock;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.lang.ErrorGroups;
import org.apache.ignite.sql.SqlException;
import org.jetbrains.annotations.Nullable;

public class DdlCommandHandler
implements LifecycleAware {
    private final CatalogManager catalogManager;
    private final ClockService clockService;
    private final InFlightFutures inFlightFutures = new InFlightFutures();
    private final IgniteSpinBusyLock busyLock = new IgniteSpinBusyLock();

    public DdlCommandHandler(CatalogManager catalogManager, ClockService clockService) {
        this.catalogManager = catalogManager;
        this.clockService = clockService;
    }

    public CompletableFuture<@Nullable Long> handle(CatalogCommand cmd) {
        if (cmd instanceof CreateSchemaCommand) {
            return this.handleCreateSchema((CreateSchemaCommand)cmd);
        }
        if (cmd instanceof DropSchemaCommand) {
            return this.handleDropSchema((DropSchemaCommand)cmd);
        }
        if (cmd instanceof CreateTableCommand) {
            return this.handleCreateTable((CreateTableCommand)cmd);
        }
        if (cmd instanceof DropTableCommand) {
            return this.handleDropTable((DropTableCommand)cmd);
        }
        if (cmd instanceof AlterTableAddColumnCommand) {
            return this.handleAlterAddColumn((AlterTableAddColumnCommand)cmd);
        }
        if (cmd instanceof AlterTableDropColumnCommand) {
            return this.handleAlterDropColumn((AlterTableDropColumnCommand)cmd);
        }
        if (cmd instanceof AlterTableAlterColumnCommand) {
            return this.handleAlterColumn((AlterTableAlterColumnCommand)cmd);
        }
        if (cmd instanceof AbstractCreateIndexCommand) {
            return this.handleCreateIndex((AbstractCreateIndexCommand)cmd);
        }
        if (cmd instanceof DropIndexCommand) {
            return this.handleDropIndex((DropIndexCommand)cmd);
        }
        if (cmd instanceof CreateZoneCommand) {
            return this.handleCreateZone((CreateZoneCommand)cmd);
        }
        if (cmd instanceof RenameZoneCommand) {
            return this.handleRenameZone((RenameZoneCommand)cmd);
        }
        if (cmd instanceof AlterZoneCommand) {
            return this.handleAlterZone((AlterZoneCommand)cmd);
        }
        if (cmd instanceof AlterZoneSetDefaultCommand) {
            return this.handleAlterZoneSetDefault((AlterZoneSetDefaultCommand)cmd);
        }
        if (cmd instanceof DropZoneCommand) {
            return this.handleDropZone((DropZoneCommand)cmd);
        }
        return CompletableFuture.failedFuture((Throwable)new SqlException(ErrorGroups.Sql.STMT_VALIDATION_ERR, "Unsupported DDL operation [cmdName=" + (cmd == null ? null : cmd.getClass().getSimpleName()) + "; cmd=\"" + String.valueOf(cmd) + "\"]"));
    }

    private CompletableFuture<@Nullable Long> handleCreateZone(CreateZoneCommand cmd) {
        return this.catalogManager.execute((CatalogCommand)cmd).handle(this.handleModificationResult(cmd.ifNotExists(), DistributionZoneExistsValidationException.class));
    }

    private CompletableFuture<@Nullable Long> handleRenameZone(RenameZoneCommand cmd) {
        return this.catalogManager.execute((CatalogCommand)cmd).handle(this.handleModificationResult(cmd.ifExists(), DistributionZoneNotFoundValidationException.class));
    }

    private CompletableFuture<@Nullable Long> handleAlterZone(AlterZoneCommand cmd) {
        return this.catalogManager.execute((CatalogCommand)cmd).handle(this.handleModificationResult(cmd.ifExists(), DistributionZoneNotFoundValidationException.class));
    }

    private CompletableFuture<@Nullable Long> handleAlterZoneSetDefault(AlterZoneSetDefaultCommand cmd) {
        return this.catalogManager.execute((CatalogCommand)cmd).handle(this.handleModificationResult(cmd.ifExists(), DistributionZoneNotFoundValidationException.class));
    }

    private CompletableFuture<@Nullable Long> handleDropZone(DropZoneCommand cmd) {
        return this.catalogManager.execute((CatalogCommand)cmd).handle(this.handleModificationResult(cmd.ifExists(), DistributionZoneNotFoundValidationException.class));
    }

    private CompletableFuture<@Nullable Long> handleCreateTable(CreateTableCommand cmd) {
        return this.catalogManager.execute((CatalogCommand)cmd).handle(this.handleModificationResult(cmd.ifTableExists(), TableExistsValidationException.class));
    }

    private CompletableFuture<@Nullable Long> handleDropTable(DropTableCommand cmd) {
        return this.catalogManager.execute((CatalogCommand)cmd).handle(this.handleModificationResult(cmd.ifTableExists(), TableNotFoundValidationException.class));
    }

    private CompletableFuture<@Nullable Long> handleAlterAddColumn(AlterTableAddColumnCommand cmd) {
        return this.catalogManager.execute((CatalogCommand)cmd).handle(this.handleModificationResult(cmd.ifTableExists(), TableNotFoundValidationException.class));
    }

    private CompletableFuture<@Nullable Long> handleAlterDropColumn(AlterTableDropColumnCommand cmd) {
        return this.catalogManager.execute((CatalogCommand)cmd).handle(this.handleModificationResult(cmd.ifTableExists(), TableNotFoundValidationException.class));
    }

    private CompletableFuture<@Nullable Long> handleAlterColumn(AlterTableAlterColumnCommand cmd) {
        return this.catalogManager.execute((CatalogCommand)cmd).handle(this.handleModificationResult(cmd.ifTableExists(), TableNotFoundValidationException.class));
    }

    private CompletableFuture<@Nullable Long> handleCreateIndex(AbstractCreateIndexCommand cmd) {
        return ((CompletableFuture)this.catalogManager.execute((CatalogCommand)cmd).thenCompose(catalogVersion -> (CompletionStage)IgniteUtils.inBusyLock((IgniteSpinBusyLock)this.busyLock, () -> this.waitTillIndexBecomesAvailableOrRemoved(cmd, (Integer)catalogVersion)))).handle(this.handleModificationResult(cmd.ifNotExists(), IndexExistsValidationException.class));
    }

    private CompletableFuture<@Nullable Long> handleDropIndex(DropIndexCommand cmd) {
        return this.catalogManager.execute((CatalogCommand)cmd).handle(this.handleModificationResult(cmd.ifExists(), IndexNotFoundValidationException.class));
    }

    private CompletableFuture<Long> handleCreateSchema(CreateSchemaCommand cmd) {
        return this.catalogManager.execute((CatalogCommand)cmd).handle(this.handleModificationResult(cmd.ifNotExists(), SchemaExistsException.class));
    }

    private CompletableFuture<Long> handleDropSchema(DropSchemaCommand cmd) {
        return this.catalogManager.execute((CatalogCommand)cmd).handle(this.handleModificationResult(cmd.ifExists(), SchemaNotFoundException.class));
    }

    private BiFunction<Integer, Throwable, @Nullable Long> handleModificationResult(boolean ignoreExpectedError, Class<?> expErrCls) {
        return (ver, err) -> {
            if (err == null) {
                Catalog catalog = this.catalogManager.catalog(ver.intValue());
                assert (catalog != null);
                return catalog.time();
            }
            if (ignoreExpectedError) {
                Throwable err0;
                Throwable throwable = err0 = err instanceof CompletionException ? err.getCause() : err;
                if (expErrCls.isAssignableFrom(err0.getClass())) {
                    return null;
                }
            }
            throw err instanceof RuntimeException ? (RuntimeException)err : new CompletionException((Throwable)err);
        };
    }

    private CompletionStage<Integer> waitTillIndexBecomesAvailableOrRemoved(AbstractCreateIndexCommand cmd, Integer creationCatalogVersion) {
        CompletableFuture future = this.inFlightFutures.registerFuture(new CompletableFuture());
        Catalog catalog = this.catalogManager.catalog(creationCatalogVersion.intValue());
        assert (catalog != null) : creationCatalogVersion;
        CatalogSchemaDescriptor schema = catalog.schema(cmd.schemaName());
        assert (schema != null) : "Did not find schema " + cmd.schemaName() + " in version " + creationCatalogVersion;
        CatalogIndexDescriptor index = schema.aliveIndex(cmd.indexName());
        assert (index != null) : "Did not find index " + cmd.indexName() + " in schema " + cmd.schemaName() + " in version " + creationCatalogVersion;
        EventListener availabilityListener = EventListener.fromConsumer(event -> {
            if (((MakeIndexAvailableEventParameters)event).indexId() == index.id()) {
                this.completeFutureWhenEventVersionActivates((CompletableFuture<Void>)future, (CatalogEventParameters)event);
            }
        });
        this.catalogManager.listen((Event)CatalogEvent.INDEX_AVAILABLE, availabilityListener);
        EventListener removalListener = EventListener.fromConsumer(event -> {
            if (((RemoveIndexEventParameters)event).indexId() == index.id()) {
                future.complete(null);
            }
        });
        this.catalogManager.listen((Event)CatalogEvent.INDEX_REMOVED, removalListener);
        int latestVersion = this.catalogManager.latestCatalogVersion();
        for (int version = creationCatalogVersion + 1; version <= latestVersion; ++version) {
            CatalogIndexDescriptor indexAtVersion = this.catalogManager.index(index.id(), version);
            if (indexAtVersion == null) {
                future.complete(null);
                break;
            }
            if (!indexAtVersion.status().isAvailableOrLater()) continue;
            this.completeFutureWhenEventVersionActivates((CompletableFuture<Void>)future, version);
            break;
        }
        return ((CompletableFuture)future.whenComplete((res, ex) -> {
            this.catalogManager.removeListener((Event)CatalogEvent.INDEX_AVAILABLE, availabilityListener);
            this.catalogManager.removeListener((Event)CatalogEvent.INDEX_REMOVED, removalListener);
        })).thenApply(none -> creationCatalogVersion);
    }

    private void completeFutureWhenEventVersionActivates(CompletableFuture<Void> future, CatalogEventParameters event) {
        this.completeFutureWhenEventVersionActivates(future, event.catalogVersion());
    }

    private void completeFutureWhenEventVersionActivates(CompletableFuture<Void> future, int catalogVersion) {
        Catalog catalog = this.catalogManager.catalog(catalogVersion);
        assert (catalog != null);
        HybridTimestamp tsToWait = CatalogUtils.clusterWideEnsuredActivationTimestamp((long)catalog.time(), (long)this.clockService.maxClockSkewMillis());
        this.clockService.waitFor(tsToWait).whenComplete((res, ex) -> future.complete(null));
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() throws Exception {
        this.busyLock.block();
        this.inFlightFutures.failInFlightFutures((Exception)new NodeStoppingException());
    }
}

