/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.property;

import java.util.Iterator;
import java.util.Map;
import org.apache.ignite.internal.lang.IgniteStringFormatter;
import org.apache.ignite.internal.sql.engine.property.Property;
import org.apache.ignite.internal.sql.engine.property.PropertyNotFoundException;
import org.apache.ignite.internal.sql.engine.property.SqlProperties;
import org.jetbrains.annotations.Nullable;

class SqlPropertiesImpl
implements SqlProperties {
    private final Map<Property<?>, Object> props;

    SqlPropertiesImpl(Map<Property<?>, Object> props) {
        this.props = Map.copyOf(props);
    }

    @Override
    public <T> T get(Property<T> prop) {
        T val = this.get0(prop);
        if (val == null) {
            throw new PropertyNotFoundException(prop);
        }
        return val;
    }

    @Override
    public <T> T getOrDefault(Property<T> prop, T defaultValue) {
        T val = this.get0(prop);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    @Override
    public boolean hasProperty(Property<?> prop) {
        return this.props.containsKey(prop);
    }

    @Override
    public Iterator<Map.Entry<Property<?>, Object>> iterator() {
        return this.props.entrySet().iterator();
    }

    @Nullable
    private <T> T get0(Property<T> prop) {
        Object val = this.props.get(prop);
        if (val == null) {
            return null;
        }
        assert (prop.cls.isAssignableFrom(val.getClass())) : IgniteStringFormatter.format((String)"Unexpected property value [name={}, expCls={}, actCls={}, val={}]", (Object[])new Object[]{prop.name, prop.cls, val.getClass(), val});
        return (T)prop.cls.cast(val);
    }
}

