/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.schema;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.ColumnStrategy;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql2rel.InitializerContext;
import org.apache.calcite.sql2rel.NullInitializerExpressionFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite.internal.sql.engine.schema.ColumnDescriptor;
import org.apache.ignite.internal.sql.engine.schema.DefaultValueStrategy;
import org.apache.ignite.internal.sql.engine.schema.TableDescriptor;
import org.apache.ignite.internal.sql.engine.sql.fun.IgniteSqlOperatorTable;
import org.apache.ignite.internal.sql.engine.trait.IgniteDistribution;
import org.apache.ignite.internal.sql.engine.type.IgniteTypeFactory;
import org.apache.ignite.internal.sql.engine.type.UuidType;
import org.apache.ignite.internal.sql.engine.util.Commons;
import org.apache.ignite.internal.sql.engine.util.TypeUtils;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public class TableDescriptorImpl
extends NullInitializerExpressionFactory
implements TableDescriptor {
    private static final ColumnDescriptor[] DUMMY = new ColumnDescriptor[0];
    private final ColumnDescriptor[] descriptors;
    private final Map<String, ColumnDescriptor> descriptorsMap;
    private final IgniteDistribution distribution;
    private final RelDataType rowType;
    private final RelDataType rowTypeSansHidden;

    public TableDescriptorImpl(List<ColumnDescriptor> columnDescriptors, IgniteDistribution distribution) {
        this.distribution = distribution;
        HashMap descriptorsMap = IgniteUtils.newHashMap((int)columnDescriptors.size());
        IgniteTypeFactory factory = Commons.typeFactory();
        RelDataTypeFactory.Builder typeBuilder = new RelDataTypeFactory.Builder((RelDataTypeFactory)factory);
        RelDataTypeFactory.Builder typeSansHiddenBuilder = new RelDataTypeFactory.Builder((RelDataTypeFactory)factory);
        for (ColumnDescriptor descriptor : columnDescriptors) {
            RelDataType columnType = this.deriveLogicalType((RelDataTypeFactory)factory, descriptor);
            typeBuilder.add(descriptor.name(), columnType);
            if (!descriptor.hidden()) {
                typeSansHiddenBuilder.add(descriptor.name(), columnType);
            }
            descriptorsMap.put(descriptor.name(), descriptor);
        }
        this.descriptors = columnDescriptors.toArray(DUMMY);
        this.descriptorsMap = descriptorsMap;
        this.rowType = typeBuilder.build();
        this.rowTypeSansHidden = typeSansHiddenBuilder.build();
    }

    @Override
    public Iterator<ColumnDescriptor> iterator() {
        return Arrays.stream(this.descriptors).iterator();
    }

    @Override
    public IgniteDistribution distribution() {
        return this.distribution;
    }

    public ColumnStrategy generationStrategy(RelOptTable tbl, int colIdx) {
        if (this.descriptors[colIdx].virtual()) {
            return ColumnStrategy.VIRTUAL;
        }
        if (this.descriptors[colIdx].defaultStrategy() != DefaultValueStrategy.DEFAULT_NULL) {
            return ColumnStrategy.DEFAULT;
        }
        return super.generationStrategy(tbl, colIdx);
    }

    public RexNode newColumnDefaultValue(RelOptTable tbl, int colIdx, InitializerContext ctx) {
        ColumnDescriptor descriptor = this.descriptors[colIdx];
        RexBuilder rexBuilder = ctx.getRexBuilder();
        switch (descriptor.defaultStrategy()) {
            case DEFAULT_NULL: {
                RelDataType fieldType = ((RelDataTypeField)tbl.getRowType().getFieldList().get(colIdx)).getType();
                return rexBuilder.makeNullLiteral(fieldType);
            }
            case DEFAULT_CONSTANT: {
                Class<?> storageType = Commons.nativeTypeToClass(descriptor.physicalType());
                Object defaultVal = descriptor.defaultValue();
                Object internalValue = TypeUtils.toInternal(defaultVal, storageType);
                RelDataType relDataType = this.deriveLogicalType(rexBuilder.getTypeFactory(), descriptor);
                if (internalValue != null && relDataType instanceof UuidType) {
                    assert (internalValue instanceof UUID);
                    RelDataType charType = rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR);
                    RexNode literal = rexBuilder.makeLiteral((Object)internalValue.toString(), charType, false);
                    return rexBuilder.makeCast(relDataType, literal);
                }
                return rexBuilder.makeLiteral(internalValue, relDataType, false);
            }
            case DEFAULT_COMPUTED: {
                if (descriptor.virtual()) {
                    return rexBuilder.makeInputRef(((RelDataTypeField)tbl.getRowType().getFieldList().get(colIdx)).getType(), colIdx);
                }
                assert (descriptor.key()) : "DEFAULT_COMPUTED is only supported for primary key columns. Column: " + descriptor.name();
                return rexBuilder.makeCall((SqlOperator)IgniteSqlOperatorTable.RAND_UUID, new RexNode[0]);
            }
        }
        throw new IllegalStateException("Unknown default strategy: " + String.valueOf((Object)descriptor.defaultStrategy()));
    }

    @Override
    public RelDataType rowType(IgniteTypeFactory factory, @Nullable ImmutableBitSet usedColumns) {
        if (usedColumns == null || usedColumns.cardinality() == this.descriptors.length) {
            return this.rowType;
        }
        RelDataTypeFactory.Builder builder = new RelDataTypeFactory.Builder((RelDataTypeFactory)factory);
        List fieldList = this.rowType.getFieldList();
        Iterator iterator = usedColumns.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            builder.add((RelDataTypeField)fieldList.get(i));
        }
        return builder.build();
    }

    @Override
    public RelDataType rowTypeSansHidden() {
        return this.rowTypeSansHidden;
    }

    @Override
    public ColumnDescriptor columnDescriptor(String fieldName) {
        return fieldName == null ? null : this.descriptorsMap.get(fieldName);
    }

    @Override
    public ColumnDescriptor columnDescriptor(int idx) {
        return idx < 0 || idx >= this.descriptors.length ? null : this.descriptors[idx];
    }

    @Override
    public int columnsCount() {
        return this.descriptors.length;
    }

    private RelDataType deriveLogicalType(RelDataTypeFactory factory, ColumnDescriptor desc) {
        return TypeUtils.native2relationalType(factory, desc.physicalType(), desc.nullable());
    }
}

