/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.sql.engine.type;

import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.internal.type.NativeType;
import org.apache.ignite.sql.ColumnType;

public final class IgniteCustomTypeSpec {
    private final String typeName;
    private final NativeType nativeType;
    private final ColumnType columnType;
    private final Class<?> storageType;
    private final Method castFunction;

    public IgniteCustomTypeSpec(String typeName, NativeType nativeType, ColumnType columnType, Class<? extends Comparable<?>> storageType, Method castFunction) {
        this.typeName = typeName;
        this.nativeType = nativeType;
        this.columnType = columnType;
        this.storageType = storageType;
        this.castFunction = castFunction;
    }

    public String typeName() {
        return this.typeName;
    }

    public NativeType nativeType() {
        return this.nativeType;
    }

    public ColumnType columnType() {
        return this.columnType;
    }

    public Class<?> storageType() {
        return this.storageType;
    }

    public Method castFunction() {
        return this.castFunction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IgniteCustomTypeSpec that = (IgniteCustomTypeSpec)o;
        return this.typeName.equals(that.typeName) && this.nativeType.equals((Object)that.nativeType) && this.storageType.equals(that.storageType) && this.columnType == that.columnType;
    }

    public static Method getCastFunction(Class<?> clazz, String method) {
        try {
            return clazz.getMethod(method, Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Incorrect cast function method: " + method, e);
        }
    }

    public int hashCode() {
        return Objects.hash(this.typeName, this.nativeType, this.storageType, this.columnType);
    }

    public String toString() {
        return S.toString(IgniteCustomTypeSpec.class, (Object)this);
    }
}

