/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.command;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.metastorage.command.MetaStorageCommandsFactory;
import org.apache.ignite.internal.metastorage.command.RemoveByPrefixCommand;
import org.apache.ignite.internal.metastorage.command.RemoveByPrefixCommandBuilder;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;

class RemoveByPrefixCommandDeserializer
implements MessageDeserializer<RemoveByPrefixCommand> {
    private final RemoveByPrefixCommandBuilder msg;

    RemoveByPrefixCommandDeserializer(MetaStorageCommandsFactory messageFactory) {
        this.msg = messageFactory.removeByPrefixCommand();
    }

    public Class<RemoveByPrefixCommand> klass() {
        return RemoveByPrefixCommand.class;
    }

    public RemoveByPrefixCommand getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readHybridTimestamp("initiatorTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.initiatorTime((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readByteBuffer("prefix");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.prefix((ByteBuffer)tmp);
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readHybridTimestamp("safeTime");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.safeTime((HybridTimestamp)tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(RemoveByPrefixCommand.class);
    }
}

