/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.asm;

import com.facebook.presto.bytecode.BytecodeBlock;
import com.facebook.presto.bytecode.BytecodeNode;
import com.facebook.presto.bytecode.ClassDefinition;
import com.facebook.presto.bytecode.ClassGenerator;
import com.facebook.presto.bytecode.FieldDefinition;
import com.facebook.presto.bytecode.MethodDefinition;
import com.facebook.presto.bytecode.ParameterizedType;
import com.facebook.presto.bytecode.expression.BytecodeExpression;
import com.facebook.presto.bytecode.expression.BytecodeExpressions;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ignite.configuration.ConfigurationWrongPolymorphicTypeIdException;
import org.apache.ignite.configuration.RootKey;
import org.apache.ignite.configuration.annotation.AbstractConfiguration;
import org.apache.ignite.configuration.annotation.Config;
import org.apache.ignite.configuration.annotation.ConfigurationRoot;
import org.apache.ignite.configuration.annotation.NamedConfigValue;
import org.apache.ignite.configuration.annotation.PublicName;
import org.apache.ignite.internal.configuration.DynamicConfiguration;
import org.apache.ignite.internal.configuration.DynamicConfigurationChanger;
import org.apache.ignite.internal.configuration.TypeUtils;
import org.apache.ignite.internal.configuration.asm.AbstractAsmGenerator;
import org.apache.ignite.internal.configuration.asm.ConfigurationImplAsmGenerator;
import org.apache.ignite.internal.configuration.asm.DirectProxyAsmGenerator;
import org.apache.ignite.internal.configuration.asm.InnerNodeAsmGenerator;
import org.apache.ignite.internal.configuration.asm.SchemaClassesInfo;
import org.apache.ignite.internal.configuration.asm.StringSwitchBuilder;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.apache.ignite.internal.configuration.tree.NamedListNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;
import org.apache.ignite.internal.util.ArrayUtils;
import org.apache.ignite.internal.util.CollectionUtils;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;

public class ConfigurationAsmGenerator {
    private final Map<Class<?>, SchemaClassesInfo> schemasInfo = new HashMap();
    private final ClassGenerator generator = ClassGenerator.classGenerator((ClassLoader)this.getClass().getClassLoader());

    public synchronized InnerNode instantiateNode(Class<?> schemaClass) {
        SchemaClassesInfo info = this.schemasInfo.get(schemaClass);
        assert (info != null && info.nodeClass != null) : schemaClass;
        try {
            Constructor<? extends InnerNode> constructor = info.nodeClass.getConstructor(new Class[0]);
            assert (constructor.canAccess(null));
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public synchronized DynamicConfiguration<?, ?> instantiateCfg(RootKey<?, ?> rootKey, DynamicConfigurationChanger changer) {
        SchemaClassesInfo info = this.schemasInfo.get(rootKey.schemaClass());
        assert (info != null && info.cfgImplClass != null);
        try {
            Constructor<DynamicConfiguration<?, ?>> constructor = info.cfgImplClass.getConstructor(List.class, String.class, RootKey.class, DynamicConfigurationChanger.class, Boolean.TYPE);
            assert (constructor.canAccess(null));
            return constructor.newInstance(Collections.emptyList(), rootKey.key(), rootKey, changer, false);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public synchronized void compileRootSchema(Class<?> rootSchemaClass, Map<Class<?>, Set<Class<?>>> schemaExtensions, Map<Class<?>, Set<Class<?>>> polymorphicSchemaExtensions) {
        if (this.schemasInfo.containsKey(rootSchemaClass)) {
            return;
        }
        ArrayDeque compileQueue = new ArrayDeque();
        compileQueue.add(rootSchemaClass);
        this.schemasInfo.put(rootSchemaClass, new SchemaClassesInfo(rootSchemaClass));
        HashSet<Class> schemas = new HashSet<Class>();
        ArrayList<ClassDefinition> classDefs = new ArrayList<ClassDefinition>();
        while (!compileQueue.isEmpty()) {
            Class schemaClass = (Class)compileQueue.poll();
            assert (schemaClass.isAnnotationPresent(ConfigurationRoot.class) || schemaClass.isAnnotationPresent(Config.class) || ConfigurationUtil.isPolymorphicConfig(schemaClass)) : String.valueOf(schemaClass) + " is not properly annotated";
            assert (this.schemasInfo.containsKey(schemaClass)) : schemaClass;
            Set<Class<?>> extensions = schemaExtensions.getOrDefault(schemaClass, Set.of());
            Set<Class<?>> polymorphicExtensions = polymorphicSchemaExtensions.getOrDefault(schemaClass, Set.of());
            assert (extensions.isEmpty() || polymorphicExtensions.isEmpty()) : "Configuration and polymorphic extensions are not allowed at the same time: " + String.valueOf(schemaClass);
            if (ConfigurationUtil.isPolymorphicConfig(schemaClass) && polymorphicExtensions.isEmpty()) {
                throw new IllegalArgumentException(String.valueOf(schemaClass) + " is polymorphic but polymorphic extensions are absent");
            }
            Class schemaSuperClass = schemaClass.getSuperclass();
            List schemaFields = schemaSuperClass.isAnnotationPresent(AbstractConfiguration.class) ? CollectionUtils.concat((List[])new List[]{ConfigurationUtil.schemaFields(schemaClass), ConfigurationUtil.schemaFields(schemaSuperClass)}) : ConfigurationUtil.schemaFields(schemaClass);
            Set<Class<?>> publicExtensions = extensions.stream().filter(ConfigurationUtil::isPublicExtension).collect(Collectors.toSet());
            Set<Class<?>> internalExtensions = extensions.stream().filter(ConfigurationUtil::isInternalExtension).collect(Collectors.toSet());
            Collection<Field> publicExtensionFields = ConfigurationUtil.extensionsFields(publicExtensions, true);
            Collection<Field> internalExtensionFields = ConfigurationUtil.extensionsFields(internalExtensions, true);
            Collection<Field> polymorphicExtensionsFields = ConfigurationUtil.extensionsFields(polymorphicExtensions, false);
            Field internalIdField = this.internalIdField(schemaClass, extensions);
            for (Field field : CollectionUtils.concat((Collection[])new Collection[]{schemaFields, publicExtensionFields, internalExtensionFields, polymorphicExtensionsFields})) {
                Class<?> subSchemaClass;
                if (!ConfigurationUtil.isConfigValue(field) && !ConfigurationUtil.isNamedConfigValue(field) || this.schemasInfo.containsKey(subSchemaClass = field.getType())) continue;
                compileQueue.offer(subSchemaClass);
                this.schemasInfo.put(subSchemaClass, new SchemaClassesInfo(subSchemaClass));
            }
            for (Class clazz : polymorphicExtensions) {
                this.schemasInfo.put(clazz, new SchemaClassesInfo(clazz));
            }
            schemas.add(schemaClass);
            classDefs.addAll(new InnerNodeAsmGenerator(this, schemaClass, extensions, polymorphicExtensions, schemaFields, publicExtensionFields, internalExtensionFields, polymorphicExtensionsFields, internalIdField).generate());
            classDefs.addAll(new ConfigurationImplAsmGenerator(this, schemaClass, extensions, polymorphicExtensions, schemaFields, publicExtensionFields, internalExtensionFields, polymorphicExtensionsFields, internalIdField).generate());
            classDefs.addAll(new DirectProxyAsmGenerator(this, schemaClass, extensions, schemaFields, publicExtensionFields, internalExtensionFields, internalIdField).generate());
        }
        Map definedClasses = this.generator.defineClasses(classDefs);
        for (Class schemaClass : schemas) {
            SchemaClassesInfo info = this.schemasInfo.get(schemaClass);
            info.nodeClass = (Class)definedClasses.get(info.nodeClassName);
            info.cfgImplClass = (Class)definedClasses.get(info.cfgImplClassName);
        }
    }

    synchronized SchemaClassesInfo schemaInfo(Class<?> schemaClass) {
        return this.schemasInfo.get(schemaClass);
    }

    @Nullable
    private Field internalIdField(Class<?> schemaClass, Set<Class<?>> schemaExtensions) {
        List internalIdFields = Stream.concat(Stream.of(schemaClass), schemaExtensions.stream()).map(Class::getDeclaredFields).flatMap(Arrays::stream).filter(ConfigurationUtil::isInternalId).collect(Collectors.toList());
        if (internalIdFields.isEmpty()) {
            return null;
        }
        assert (internalIdFields.size() == 1) : internalIdFields;
        return (Field)internalIdFields.get(0);
    }

    BytecodeExpression newOrCopyNodeField(Field schemaField, BytecodeExpression getFieldCode) {
        ParameterizedType nodeType = ParameterizedType.typeFromJavaClassName((String)this.schemasInfo.get(schemaField.getType()).nodeClassName);
        return BytecodeExpressions.inlineIf((BytecodeExpression)BytecodeExpressions.isNull((BytecodeExpression)getFieldCode), (BytecodeExpression)BytecodeExpressions.newInstance((ParameterizedType)nodeType, (BytecodeExpression[])new BytecodeExpression[0]), (BytecodeExpression)this.copyNodeField(schemaField, getFieldCode));
    }

    BytecodeExpression copyNodeField(Field schemaField, BytecodeExpression getFieldCode) {
        ParameterizedType nodeType = ConfigurationUtil.isNamedConfigValue(schemaField) ? ParameterizedType.type(NamedListNode.class) : ParameterizedType.typeFromJavaClassName((String)this.schemasInfo.get(schemaField.getType()).nodeClassName);
        return getFieldCode.invoke(AbstractAsmGenerator.COPY, new BytecodeExpression[0]).cast(nodeType);
    }

    private static BytecodeExpression newNamedListElementLambda(String nodeClassName) {
        return BytecodeExpressions.invokeDynamic((Method)AbstractAsmGenerator.LAMBDA_METAFACTORY, Arrays.asList(Type.getMethodType((Type)Type.getType(Object.class), (Type[])new Type[0]), new Handle(8, ConfigurationAsmGenerator.internalName(nodeClassName), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false), Type.getMethodType((Type)ParameterizedType.typeFromJavaClassName((String)nodeClassName).getAsmType(), (Type[])new Type[0])), (String)"get", (MethodType)MethodType.methodType(Supplier.class), (BytecodeExpression[])new BytecodeExpression[0]);
    }

    private static String capitalize(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    static String internalName(String className) {
        return className.replace('.', '/');
    }

    public static Class<?> box(Class<?> clazz) {
        Class<?> boxed = TypeUtils.boxed(clazz);
        return boxed == null ? clazz : boxed;
    }

    static ParameterizedType[] nodeClassInterfaces(Class<?> schemaClass, Set<Class<?>> schemaExtensions) {
        ArrayList<ParameterizedType> res = new ArrayList<ParameterizedType>();
        for (Class cls : CollectionUtils.concat((Collection[])new Collection[]{List.of(schemaClass), schemaExtensions})) {
            res.add(ParameterizedType.typeFromJavaClassName((String)SchemaClassesInfo.viewClassName(cls)));
            res.add(ParameterizedType.typeFromJavaClassName((String)SchemaClassesInfo.changeClassName(cls)));
        }
        return (ParameterizedType[])res.toArray(ParameterizedType[]::new);
    }

    ParameterizedType[] configClassInterfaces(Class<?> schemaClass, Set<Class<?>> schemaExtensions) {
        List result = Stream.concat(Stream.of(schemaClass), schemaExtensions.stream()).map(cls -> ParameterizedType.typeFromJavaClassName((String)SchemaClassesInfo.configurationClassName(cls))).collect(Collectors.toCollection(ArrayList::new));
        return result.toArray(new ParameterizedType[0]);
    }

    static BytecodeBlock throwException(Class<? extends Throwable> throwableClass, BytecodeExpression ... parameters) {
        return new BytecodeBlock().append((BytecodeNode)BytecodeExpressions.newInstance(throwableClass, (BytecodeExpression[])parameters)).throwObject();
    }

    static String fieldName(Field f) {
        return ConfigurationUtil.isPolymorphicConfigInstance(f.getDeclaringClass()) ? f.getName() + "#" + ConfigurationUtil.polymorphicInstanceId(f.getDeclaringClass()) : f.getName();
    }

    public static String publicName(Field f) {
        PublicName annotation = f.getAnnotation(PublicName.class);
        return annotation == null ? f.getName() : annotation.value();
    }

    static StringSwitchBuilder typeIdSwitchBuilder(MethodDefinition mtdDef, FieldDefinition typeIdFieldDef) {
        BytecodeExpression typeIdVar = mtdDef.getThis().getField(typeIdFieldDef);
        return new StringSwitchBuilder(mtdDef.getScope()).expression(typeIdVar).defaultCase((BytecodeNode)ConfigurationAsmGenerator.throwException(ConfigurationWrongPolymorphicTypeIdException.class, typeIdVar));
    }

    static BytecodeExpression getThisFieldCode(MethodDefinition mtdDef, FieldDefinition ... fieldDefs) {
        assert (!ArrayUtils.nullOrEmpty((Object[])fieldDefs));
        BytecodeExpression getFieldCode = mtdDef.getThis().getField(fieldDefs[0]);
        for (int i = 1; i < fieldDefs.length; ++i) {
            getFieldCode = getFieldCode.getField(fieldDefs[i]);
        }
        return getFieldCode;
    }

    static BytecodeExpression setThisFieldCode(MethodDefinition mtdDef, BytecodeExpression value, FieldDefinition ... fieldDefs) {
        assert (!ArrayUtils.nullOrEmpty((Object[])fieldDefs));
        if (fieldDefs.length == 1) {
            return mtdDef.getThis().setField(fieldDefs[0], value);
        }
        BytecodeExpression getFieldCode = mtdDef.getThis().getField(fieldDefs[0]);
        for (int i = 1; i < fieldDefs.length - 1; ++i) {
            getFieldCode = getFieldCode.getField(fieldDefs[i]);
        }
        return getFieldCode.setField(fieldDefs[fieldDefs.length - 1], value);
    }

    @Nullable
    static Field polymorphicIdField(Class<?> schemaClass) {
        assert (ConfigurationUtil.isPolymorphicConfig(schemaClass)) : schemaClass.getName();
        for (Field f : schemaClass.getDeclaredFields()) {
            if (!ConfigurationUtil.isPolymorphicId(f)) continue;
            return f;
        }
        return null;
    }

    static String changeMethodName(String schemaField) {
        return "change" + ConfigurationAsmGenerator.capitalize(schemaField);
    }

    BytecodeExpression newNamedListNode(Field schemaField) {
        assert (ConfigurationUtil.isNamedConfigValue(schemaField)) : schemaField;
        Class<?> fieldType = schemaField.getType();
        SchemaClassesInfo fieldClassNames = this.schemasInfo.get(fieldType);
        String syntheticKeyName = Arrays.stream(schemaField.getType().getDeclaredFields()).filter(ConfigurationUtil::isInjectedName).map(Field::getName).findFirst().orElse(schemaField.getAnnotation(NamedConfigValue.class).syntheticKeyName());
        return BytecodeExpressions.newInstance(NamedListNode.class, (BytecodeExpression[])new BytecodeExpression[]{BytecodeExpressions.constantString((String)syntheticKeyName), ConfigurationAsmGenerator.newNamedListElementLambda(fieldClassNames.nodeClassName), ConfigurationUtil.isPolymorphicConfig(fieldType) ? BytecodeExpressions.constantString((String)ConfigurationAsmGenerator.polymorphicIdField(fieldType).getName()) : BytecodeExpressions.constantNull(String.class)});
    }
}

