/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.notifications;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.ignite.configuration.notifications.ConfigurationListener;
import org.apache.ignite.configuration.notifications.ConfigurationNamedListListener;
import org.apache.ignite.internal.configuration.ConfigurationNode;
import org.apache.ignite.internal.configuration.DynamicConfiguration;
import org.apache.ignite.internal.configuration.DynamicProperty;
import org.apache.ignite.internal.configuration.NamedListConfiguration;
import org.apache.ignite.internal.configuration.tree.InnerNode;
import org.jetbrains.annotations.Nullable;

class ConfigurationNotificationUtils {
    private ConfigurationNotificationUtils() {
    }

    @Nullable
    static DynamicProperty<Serializable> dynamicProperty(DynamicConfiguration<InnerNode, ?> dynamicConfig, String nodeName) {
        return (DynamicProperty)dynamicConfig.members().get(nodeName);
    }

    @Nullable
    static DynamicConfiguration<InnerNode, ?> dynamicConfig(DynamicConfiguration<InnerNode, ?> dynamicConfig, String nodeName) {
        return (DynamicConfiguration)dynamicConfig.members().get(nodeName);
    }

    @Nullable
    static NamedListConfiguration<?, InnerNode, ?> namedDynamicConfig(DynamicConfiguration<InnerNode, ?> dynamicConfig, String nodeName) {
        return (NamedListConfiguration)dynamicConfig.members().get(nodeName);
    }

    static <T> Iterator<ConfigurationListener<T>> listeners(@Nullable ConfigurationNode<T> node, long notificationNumber) {
        return node == null ? Collections.emptyIterator() : node.listeners(notificationNumber);
    }

    static <T> Iterator<ConfigurationNamedListListener<T>> extendedListeners(@Nullable NamedListConfiguration<?, T, ?> node, long notificationNumber) {
        return node == null ? Collections.emptyIterator() : node.extendedListeners(notificationNumber);
    }

    @Nullable
    static DynamicConfiguration<InnerNode, ?> any(@Nullable NamedListConfiguration<?, InnerNode, ?> namedConfig) {
        return namedConfig == null ? null : (DynamicConfiguration)namedConfig.any();
    }

    static Iterable<DynamicConfiguration<InnerNode, ?>> mergeAnyConfigs(Iterable<DynamicConfiguration<InnerNode, ?>> anyConfigs, final @Nullable DynamicConfiguration<InnerNode, ?> anyConfig) {
        if (anyConfig == null) {
            return anyConfigs;
        }
        return () -> {
            final Iterator innerIterator = anyConfigs.iterator();
            return new Iterator<DynamicConfiguration<InnerNode, ?>>(){
                boolean finished = false;

                @Override
                public boolean hasNext() {
                    return innerIterator.hasNext() || !this.finished;
                }

                @Override
                public DynamicConfiguration<InnerNode, ?> next() {
                    if (this.finished) {
                        throw new NoSuchElementException();
                    }
                    if (innerIterator.hasNext()) {
                        return (DynamicConfiguration)innerIterator.next();
                    }
                    this.finished = true;
                    return anyConfig;
                }
            };
        };
    }
}

