/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.storage.pagememory;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.ignite.configuration.NamedListView;
import org.apache.ignite.internal.components.LogSyncer;
import org.apache.ignite.internal.components.LongJvmPauseDetector;
import org.apache.ignite.internal.failure.FailureManager;
import org.apache.ignite.internal.fileio.AsyncFileIoFactory;
import org.apache.ignite.internal.fileio.FileIoFactory;
import org.apache.ignite.internal.fileio.RandomAccessFileIoFactory;
import org.apache.ignite.internal.hlc.HybridClock;
import org.apache.ignite.internal.lang.IgniteInternalCheckedException;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.internal.pagememory.configuration.schema.PersistentPageMemoryProfileConfiguration;
import org.apache.ignite.internal.pagememory.configuration.schema.PersistentPageMemoryProfileView;
import org.apache.ignite.internal.pagememory.io.PageIoRegistry;
import org.apache.ignite.internal.pagememory.persistence.PartitionMetaManager;
import org.apache.ignite.internal.pagememory.persistence.checkpoint.CheckpointManager;
import org.apache.ignite.internal.pagememory.persistence.store.FilePageStoreManager;
import org.apache.ignite.internal.storage.StorageException;
import org.apache.ignite.internal.storage.configurations.StorageConfiguration;
import org.apache.ignite.internal.storage.engine.MvTableStorage;
import org.apache.ignite.internal.storage.engine.StorageTableDescriptor;
import org.apache.ignite.internal.storage.index.StorageIndexDescriptorSupplier;
import org.apache.ignite.internal.storage.pagememory.AbstractPageMemoryStorageEngine;
import org.apache.ignite.internal.storage.pagememory.PersistentPageMemoryDataRegion;
import org.apache.ignite.internal.storage.pagememory.PersistentPageMemoryTableStorage;
import org.apache.ignite.internal.storage.pagememory.StoragePartitionMeta;
import org.apache.ignite.internal.storage.pagememory.configuration.schema.PersistentPageMemoryStorageEngineConfiguration;
import org.apache.ignite.internal.thread.NamedThreadFactory;
import org.apache.ignite.internal.util.IgniteUtils;
import org.jetbrains.annotations.Nullable;

public class PersistentPageMemoryStorageEngine
extends AbstractPageMemoryStorageEngine {
    public static final String ENGINE_NAME = "aipersist";
    public static final int MAX_DESTRUCTION_WORK_UNITS = 1000;
    private static final IgniteLogger LOG = Loggers.forClass(PersistentPageMemoryStorageEngine.class);
    private final String igniteInstanceName;
    private final PersistentPageMemoryStorageEngineConfiguration engineConfig;
    private final StorageConfiguration storageConfig;
    private final PageIoRegistry ioRegistry;
    private final Path storagePath;
    @Nullable
    private final LongJvmPauseDetector longJvmPauseDetector;
    private final Map<String, PersistentPageMemoryDataRegion> regions = new ConcurrentHashMap<String, PersistentPageMemoryDataRegion>();
    @Nullable
    private volatile FilePageStoreManager filePageStoreManager;
    @Nullable
    private volatile PartitionMetaManager partitionMetaManager;
    @Nullable
    private volatile CheckpointManager checkpointManager;
    private volatile ExecutorService destructionExecutor;
    private final FailureManager failureManager;
    private final LogSyncer logSyncer;

    public PersistentPageMemoryStorageEngine(String igniteInstanceName, PersistentPageMemoryStorageEngineConfiguration engineConfig, StorageConfiguration storageConfig, PageIoRegistry ioRegistry, Path storagePath, @Nullable LongJvmPauseDetector longJvmPauseDetector, FailureManager failureManager, LogSyncer logSyncer, HybridClock clock) {
        super(clock);
        this.igniteInstanceName = igniteInstanceName;
        this.engineConfig = engineConfig;
        this.storageConfig = storageConfig;
        this.ioRegistry = ioRegistry;
        this.storagePath = storagePath;
        this.longJvmPauseDetector = longJvmPauseDetector;
        this.failureManager = failureManager;
        this.logSyncer = logSyncer;
    }

    public PersistentPageMemoryStorageEngineConfiguration configuration() {
        return this.engineConfig;
    }

    public String name() {
        return ENGINE_NAME;
    }

    public void start() throws StorageException {
        int pageSize = (Integer)this.engineConfig.pageSize().value();
        try {
            AsyncFileIoFactory fileIoFactory = (Boolean)this.engineConfig.checkpoint().useAsyncFileIoFactory().value() != false ? new AsyncFileIoFactory() : new RandomAccessFileIoFactory();
            this.filePageStoreManager = this.createFilePageStoreManager(this.igniteInstanceName, this.storagePath, (FileIoFactory)fileIoFactory, pageSize, this.failureManager);
            this.filePageStoreManager.start();
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error starting file page store manager", (Throwable)e);
        }
        this.partitionMetaManager = new PartitionMetaManager(this.ioRegistry, pageSize, StoragePartitionMeta.FACTORY);
        try {
            this.checkpointManager = new CheckpointManager(this.igniteInstanceName, null, this.longJvmPauseDetector, this.failureManager, this.engineConfig.checkpoint(), this.filePageStoreManager, this.partitionMetaManager, this.regions.values(), this.ioRegistry, this.logSyncer, pageSize);
            this.checkpointManager.start();
        }
        catch (IgniteInternalCheckedException e) {
            throw new StorageException("Error starting checkpoint manager", (Throwable)e);
        }
        ((NamedListView)this.storageConfig.profiles().value()).stream().forEach(p -> {
            if (p instanceof PersistentPageMemoryProfileView) {
                this.addDataRegion(p.name());
            }
        });
        ThreadPoolExecutor executor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 100L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)NamedThreadFactory.create((String)this.igniteInstanceName, (String)"persistent-mv-partition-destruction", (IgniteLogger)LOG));
        executor.allowCoreThreadTimeOut(true);
        this.destructionExecutor = executor;
    }

    public void stop() throws StorageException {
        try {
            Stream<AutoCloseable> closeRegions = this.regions.values().stream().map(region -> region::stop);
            ExecutorService destructionExecutor = this.destructionExecutor;
            CheckpointManager checkpointManager = this.checkpointManager;
            FilePageStoreManager filePageStoreManager = this.filePageStoreManager;
            Stream<AutoCloseable> resources = Stream.of(destructionExecutor == null ? null : () -> IgniteUtils.shutdownAndAwaitTermination((ExecutorService)destructionExecutor, (long)30L, (TimeUnit)TimeUnit.SECONDS), checkpointManager == null ? null : () -> ((CheckpointManager)checkpointManager).stop(), filePageStoreManager == null ? null : () -> ((FilePageStoreManager)filePageStoreManager).stop());
            IgniteUtils.closeAll(Stream.concat(resources, closeRegions));
        }
        catch (Exception e) {
            throw new StorageException("Error when stopping components", (Throwable)e);
        }
    }

    public boolean isVolatile() {
        return false;
    }

    public MvTableStorage createMvTable(StorageTableDescriptor tableDescriptor, StorageIndexDescriptorSupplier indexDescriptorSupplier) throws StorageException {
        PersistentPageMemoryDataRegion dataRegion = this.regions.get(tableDescriptor.getStorageProfile());
        assert (dataRegion != null) : "tableId=" + tableDescriptor.getId() + ", dataRegion=" + tableDescriptor.getStorageProfile();
        return new PersistentPageMemoryTableStorage(tableDescriptor, indexDescriptorSupplier, this, dataRegion, this.destructionExecutor);
    }

    public void dropMvTable(int tableId) {
        FilePageStoreManager filePageStoreManager = this.filePageStoreManager;
        assert (filePageStoreManager != null) : "Component has not started";
        try {
            filePageStoreManager.destroyGroupIfExists(tableId);
        }
        catch (IOException e) {
            throw new StorageException("Failed to destroy table directory: {}", (Throwable)e, new Object[]{tableId});
        }
    }

    @Nullable
    public CheckpointManager checkpointManager() {
        return this.checkpointManager;
    }

    protected FilePageStoreManager createFilePageStoreManager(String igniteInstanceName, Path storagePath, FileIoFactory fileIoFactory, int pageSize, FailureManager failureManager) throws IgniteInternalCheckedException {
        return new FilePageStoreManager(igniteInstanceName, storagePath, fileIoFactory, pageSize, failureManager);
    }

    private void addDataRegion(String name) {
        PersistentPageMemoryProfileConfiguration storageProfileConfiguration = (PersistentPageMemoryProfileConfiguration)this.storageConfig.profiles().get(name);
        int pageSize = (Integer)this.engineConfig.pageSize().value();
        PersistentPageMemoryDataRegion dataRegion = new PersistentPageMemoryDataRegion(storageProfileConfiguration, this.ioRegistry, this.filePageStoreManager, this.partitionMetaManager, this.checkpointManager, pageSize);
        dataRegion.start();
        this.regions.put(name, dataRegion);
    }
}

