/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metrics.message;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.Objects;
import org.apache.ignite.internal.metrics.message.MetricSourceDto;
import org.apache.ignite.internal.metrics.message.MetricSourcesResponse;
import org.apache.ignite.internal.metrics.message.MetricSourcesResponseBuilder;
import org.apache.ignite.internal.metrics.message.MetricSourcesResponseSerializer;
import org.apache.ignite.internal.network.serialization.MessageSerializer;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;

public class MetricSourcesResponseImpl
implements MetricSourcesResponse,
Cloneable {
    public static final short GROUP_TYPE = 16;
    public static final short TYPE = 5;
    @IgniteToStringInclude
    private Collection<MetricSourceDto> sources;
    private byte[] sourcesByteArray;
    @IgniteToStringInclude
    private Throwable throwable;
    private byte[] throwableByteArray;

    private MetricSourcesResponseImpl(Collection<MetricSourceDto> sources, byte[] sourcesByteArray, Throwable throwable, byte[] throwableByteArray) {
        this.sources = sources;
        this.sourcesByteArray = sourcesByteArray;
        this.throwable = throwable;
        this.throwableByteArray = throwableByteArray;
    }

    byte[] sourcesByteArray() {
        return this.sourcesByteArray;
    }

    @Override
    public Collection<MetricSourceDto> sources() {
        return this.sources;
    }

    byte[] throwableByteArray() {
        return this.throwableByteArray;
    }

    @Override
    public Throwable throwable() {
        return this.throwable;
    }

    public MessageSerializer serializer() {
        return MetricSourcesResponseSerializer.INSTANCE;
    }

    public short groupType() {
        return 16;
    }

    public String toString() {
        return S.toString(MetricSourcesResponseImpl.class, (Object)this);
    }

    public short messageType() {
        return 5;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MetricSourcesResponseImpl otherMessage = (MetricSourcesResponseImpl)other;
        return Objects.equals(this.sources, otherMessage.sources) && Objects.equals(this.throwable, otherMessage.throwable);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.sources, this.throwable);
        return result;
    }

    public MetricSourcesResponseImpl clone() {
        try {
            return (MetricSourcesResponseImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static MetricSourcesResponseBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject sourcesByteArraymo = marshaller.marshal(this.sources);
        usedDescriptors.addAll((IntCollection)sourcesByteArraymo.usedDescriptorIds());
        this.sourcesByteArray = sourcesByteArraymo.bytes();
        MarshalledObject throwableByteArraymo = marshaller.marshal((Object)this.throwable);
        usedDescriptors.addAll((IntCollection)throwableByteArraymo.usedDescriptorIds());
        this.throwableByteArray = throwableByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.sources = (Collection)marshaller.unmarshal(this.sourcesByteArray, descriptorsObj);
        this.sourcesByteArray = null;
        this.throwable = (Throwable)marshaller.unmarshal(this.throwableByteArray, descriptorsObj);
        this.throwableByteArray = null;
    }

    private static class Builder
    implements MetricSourcesResponseBuilder {
        private Collection<MetricSourceDto> sources;
        private byte[] sourcesByteArray;
        private Throwable throwable;
        private byte[] throwableByteArray;

        private Builder() {
        }

        @Override
        public MetricSourcesResponseBuilder sources(Collection<MetricSourceDto> sources) {
            this.sources = sources;
            return this;
        }

        @Override
        public MetricSourcesResponseBuilder sourcesByteArray(byte[] sourcesByteArray) {
            this.sourcesByteArray = sourcesByteArray;
            return this;
        }

        @Override
        public MetricSourcesResponseBuilder throwable(Throwable throwable) {
            this.throwable = throwable;
            return this;
        }

        @Override
        public MetricSourcesResponseBuilder throwableByteArray(byte[] throwableByteArray) {
            this.throwableByteArray = throwableByteArray;
            return this;
        }

        @Override
        public Collection<MetricSourceDto> sources() {
            return this.sources;
        }

        @Override
        public byte[] sourcesByteArray() {
            return this.sourcesByteArray;
        }

        @Override
        public Throwable throwable() {
            return this.throwable;
        }

        @Override
        public byte[] throwableByteArray() {
            return this.throwableByteArray;
        }

        @Override
        public MetricSourcesResponse build() {
            return new MetricSourcesResponseImpl(this.sources, this.sourcesByteArray, this.throwable, this.throwableByteArray);
        }
    }
}

