/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.index;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.ignite3.internal.components.NodeProperties;
import org.apache.ignite3.internal.failure.FailureContext;
import org.apache.ignite3.internal.failure.FailureProcessor;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.index.IndexBuildCompletionListener;
import org.apache.ignite3.internal.index.IndexBuildTaskId;
import org.apache.ignite3.internal.index.IndexManagementUtils;
import org.apache.ignite3.internal.lang.IgniteStringFormatter;
import org.apache.ignite3.internal.lang.NodeStoppingException;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.internal.network.InternalClusterNode;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite3.internal.partition.replicator.network.replication.BuildIndexReplicaRequest;
import org.apache.ignite3.internal.raft.GroupOverloadedException;
import org.apache.ignite3.internal.replicator.ReplicaService;
import org.apache.ignite3.internal.replicator.TablePartitionId;
import org.apache.ignite3.internal.replicator.ZonePartitionId;
import org.apache.ignite3.internal.replicator.exception.PrimaryReplicaMissException;
import org.apache.ignite3.internal.replicator.exception.ReplicationTimeoutException;
import org.apache.ignite3.internal.replicator.message.ReplicaMessageUtils;
import org.apache.ignite3.internal.replicator.message.ReplicaMessagesFactory;
import org.apache.ignite3.internal.replicator.message.ReplicaRequest;
import org.apache.ignite3.internal.replicator.message.ReplicationGroupIdMessage;
import org.apache.ignite3.internal.storage.MvPartitionStorage;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.StorageClosedException;
import org.apache.ignite3.internal.storage.index.IndexStorage;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.ExceptionUtils;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.apache.ignite3.internal.util.TrackerClosedException;

class IndexBuildTask {
    private static final IgniteLogger LOG = Loggers.forClass(IndexBuildTask.class);
    private static final PartitionReplicationMessagesFactory PARTITION_REPLICATION_MESSAGES_FACTORY = new PartitionReplicationMessagesFactory();
    private static final ReplicaMessagesFactory REPLICA_MESSAGES_FACTORY = new ReplicaMessagesFactory();
    private final IndexBuildTaskId taskId;
    private final IndexStorage indexStorage;
    private final MvPartitionStorage partitionStorage;
    private final ReplicaService replicaService;
    private final FailureProcessor failureProcessor;
    private final NodeProperties nodeProperties;
    private final Executor executor;
    private final IgniteSpinBusyLock busyLock;
    private final int batchSize;
    private final InternalClusterNode node;
    private final List<IndexBuildCompletionListener> listeners;
    private final long enlistmentConsistencyToken;
    private final boolean afterDisasterRecovery;
    private final IgniteSpinBusyLock taskBusyLock = new IgniteSpinBusyLock();
    private final AtomicBoolean taskStopGuard = new AtomicBoolean();
    private final CompletableFuture<Void> taskFuture = new CompletableFuture();
    private final HybridTimestamp initialOperationTimestamp;

    IndexBuildTask(IndexBuildTaskId taskId, IndexStorage indexStorage, MvPartitionStorage partitionStorage, ReplicaService replicaService, FailureProcessor failureProcessor, NodeProperties nodeProperties, Executor executor, IgniteSpinBusyLock busyLock, int batchSize, InternalClusterNode node, List<IndexBuildCompletionListener> listeners, long enlistmentConsistencyToken, boolean afterDisasterRecovery, HybridTimestamp initialOperationTimestamp) {
        this.taskId = taskId;
        this.indexStorage = indexStorage;
        this.partitionStorage = partitionStorage;
        this.replicaService = replicaService;
        this.failureProcessor = failureProcessor;
        this.nodeProperties = nodeProperties;
        this.executor = executor;
        this.busyLock = busyLock;
        this.batchSize = batchSize;
        this.node = node;
        this.listeners = listeners;
        this.enlistmentConsistencyToken = enlistmentConsistencyToken;
        this.afterDisasterRecovery = afterDisasterRecovery;
        this.initialOperationTimestamp = initialOperationTimestamp;
    }

    void start() {
        if (!this.enterBusy()) {
            this.taskFuture.complete(null);
            return;
        }
        LOG.info("Start building the index: [{}]", this.createCommonIndexInfo());
        try {
            ((CompletableFuture)CompletableFuture.supplyAsync(this::handleNextBatch, this.executor).thenCompose(Function.identity())).whenComplete((unused, throwable) -> {
                if (throwable != null) {
                    if (IndexBuildTask.ignorable(throwable)) {
                        LOG.debug("Index build error: [{}]", (Throwable)throwable, (Object)this.createCommonIndexInfo());
                    } else {
                        String errorMessage = String.format("Index build error: [%s]", this.createCommonIndexInfo());
                        this.failureProcessor.process(new FailureContext((Throwable)throwable, errorMessage));
                    }
                    this.taskFuture.completeExceptionally((Throwable)throwable);
                } else {
                    this.taskFuture.complete(null);
                }
            });
        }
        catch (Throwable t) {
            this.taskFuture.completeExceptionally(t);
            throw t;
        }
        finally {
            this.leaveBusy();
        }
    }

    private static boolean ignorable(Throwable throwable) {
        return ExceptionUtils.hasCause(throwable, PrimaryReplicaMissException.class, TrackerClosedException.class, StorageClosedException.class, NodeStoppingException.class);
    }

    void stop() {
        if (!this.taskStopGuard.compareAndSet(false, true)) {
            return;
        }
        this.taskBusyLock.block();
    }

    CompletableFuture<Void> getTaskFuture() {
        return this.taskFuture;
    }

    private CompletableFuture<Void> handleNextBatch() {
        if (!this.enterBusy()) {
            return CompletableFutures.nullCompletedFuture();
        }
        try {
            List<RowId> batchRowIds = this.createBatchRowIds();
            CompletionStage completionStage = ((CompletableFuture)this.replicaService.invoke(this.node, (ReplicaRequest)this.createBuildIndexReplicaRequest(batchRowIds, this.initialOperationTimestamp)).handleAsync((unused, throwable) -> {
                if (throwable != null) {
                    Throwable cause = ExceptionUtils.unwrapRootCause(throwable);
                    if (!(cause instanceof ReplicationTimeoutException) && !(cause instanceof GroupOverloadedException)) {
                        return CompletableFuture.failedFuture(cause);
                    }
                } else if (this.indexStorage.getNextRowIdToBuild() == null) {
                    LOG.info("Index build completed: [{}]", this.createCommonIndexInfo());
                    this.notifyListeners(this.taskId);
                    return CompletableFutures.nullCompletedFuture();
                }
                return this.handleNextBatch();
            }, this.executor)).thenCompose(Function.identity());
            return completionStage;
        }
        catch (Throwable t) {
            CompletableFuture<Void> completableFuture = CompletableFuture.failedFuture(t);
            return completableFuture;
        }
        finally {
            this.leaveBusy();
        }
    }

    private List<RowId> createBatchRowIds() {
        RowId nextRowIdToBuild = this.indexStorage.getNextRowIdToBuild();
        ArrayList<RowId> batch = new ArrayList<RowId>(this.batchSize);
        for (int i = 0; i < this.batchSize && nextRowIdToBuild != null && (nextRowIdToBuild = this.partitionStorage.closestRowId(nextRowIdToBuild)) != null; nextRowIdToBuild = nextRowIdToBuild.increment(), ++i) {
            batch.add(nextRowIdToBuild);
        }
        return batch;
    }

    private BuildIndexReplicaRequest createBuildIndexReplicaRequest(List<RowId> rowIds, HybridTimestamp initialOperationTimestamp) {
        boolean finish = rowIds.size() < this.batchSize;
        ReplicationGroupIdMessage groupIdMessage = this.nodeProperties.colocationEnabled() ? ReplicaMessageUtils.toZonePartitionIdMessage(REPLICA_MESSAGES_FACTORY, new ZonePartitionId(this.taskId.getZoneId(), this.taskId.getPartitionId())) : ReplicaMessageUtils.toTablePartitionIdMessage(REPLICA_MESSAGES_FACTORY, new TablePartitionId(this.taskId.getTableId(), this.taskId.getPartitionId()));
        return PARTITION_REPLICATION_MESSAGES_FACTORY.buildIndexReplicaRequest().groupId(groupIdMessage).tableId(this.taskId.getTableId()).indexId(this.taskId.getIndexId()).rowIds(rowIds.stream().map(RowId::uuid).collect(Collectors.toList())).finish(finish).enlistmentConsistencyToken(this.enlistmentConsistencyToken).timestamp(initialOperationTimestamp).build();
    }

    private boolean enterBusy() {
        return IndexManagementUtils.enterBusy(this.busyLock, this.taskBusyLock);
    }

    private void leaveBusy() {
        IndexManagementUtils.leaveBusy(this.busyLock, this.taskBusyLock);
    }

    private String createCommonIndexInfo() {
        return IgniteStringFormatter.format("zoneId = {}, tableId={}, partitionId={}, indexId={}", this.taskId.getZoneId(), this.taskId.getTableId(), this.taskId.getPartitionId(), this.taskId.getIndexId());
    }

    private void notifyListeners(IndexBuildTaskId taskId) {
        for (IndexBuildCompletionListener listener : this.listeners) {
            if (this.afterDisasterRecovery) {
                listener.onBuildCompletionAfterDisasterRecovery(taskId.getIndexId(), taskId.getTableId(), taskId.getPartitionId());
                continue;
            }
            listener.onBuildCompletion(taskId.getIndexId(), taskId.getTableId(), taskId.getPartitionId());
        }
    }
}

