/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.message;

import java.util.UUID;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.sql.engine.message.QueryCloseMessage;
import org.apache.ignite3.internal.sql.engine.message.QueryCloseMessageBuilder;
import org.apache.ignite3.internal.sql.engine.message.SqlQueryMessagesFactory;

class QueryCloseMessageDeserializer
implements MessageDeserializer<QueryCloseMessage> {
    private final QueryCloseMessageBuilder msg;

    QueryCloseMessageDeserializer(SqlQueryMessagesFactory messageFactory) {
        this.msg = messageFactory.queryCloseMessage();
    }

    @Override
    public Class<QueryCloseMessage> klass() {
        return QueryCloseMessage.class;
    }

    @Override
    public QueryCloseMessage getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                int tmp = reader.readInt("executionToken");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.executionToken(tmp);
                reader.incrementState();
            }
            case 1: {
                UUID tmp = reader.readUuid("queryId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.queryId(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(QueryCloseMessage.class);
    }
}

