/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.reader;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteOrder;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.function.Consumer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.pagemem.wal.WALIterator;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.ByteBufferExpander;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileDescriptor;
import org.apache.ignite.internal.processors.cache.persistence.wal.FileWriteAheadLogManager;
import org.apache.ignite.internal.processors.cache.persistence.wal.WALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.FileInput;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SegmentFileInputFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SegmentIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SimpleSegmentFileInputFactory;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.StandaloneGridKernalContext;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.StandaloneIgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.wal.reader.StandaloneWalRecordsIterator;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordV1Serializer;
import org.apache.ignite.internal.util.typedef.T2;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgniteWalIteratorFactory {
    private final IgniteLogger log;
    private final SegmentFileInputFactory segmentFileInputFactory = new SimpleSegmentFileInputFactory();

    public IgniteWalIteratorFactory() {
        this(ConsoleLogger.INSTANCE);
    }

    public IgniteWalIteratorFactory(@NotNull IgniteLogger log) {
        this.log = log;
    }

    public WALIterator iterator(File ... filesOrDirs) throws IgniteCheckedException, IllegalArgumentException {
        return this.iterator(new IteratorParametersBuilder().filesOrDirs(filesOrDirs));
    }

    public WALIterator iterator(@NotNull WALPointer replayFrom, File ... filesOrDirs) throws IgniteCheckedException, IllegalArgumentException {
        return this.iterator(new IteratorParametersBuilder().from(replayFrom).filesOrDirs(filesOrDirs));
    }

    public WALIterator iterator(String ... filesOrDirs) throws IgniteCheckedException, IllegalArgumentException {
        return this.iterator(new IteratorParametersBuilder().filesOrDirs(filesOrDirs));
    }

    public WALIterator iterator(@NotNull WALPointer replayFrom, String ... filesOrDirs) throws IgniteCheckedException, IllegalArgumentException {
        return this.iterator(new IteratorParametersBuilder().from(replayFrom).filesOrDirs(filesOrDirs));
    }

    public WALIterator iterator(@NotNull IteratorParametersBuilder iteratorParametersBuilder) throws IgniteCheckedException, IllegalArgumentException {
        iteratorParametersBuilder.validate();
        if (iteratorParametersBuilder.sharedCtx == null) {
            final GridCacheSharedContext sctx = this.prepareSharedCtx(iteratorParametersBuilder);
            StandaloneGridKernalContext.startAllComponents(sctx.kernalContext());
            return new StandaloneWalRecordsIterator(iteratorParametersBuilder.log == null ? this.log : iteratorParametersBuilder.log, sctx, iteratorParametersBuilder.ioFactory, this.resolveWalFiles(iteratorParametersBuilder), iteratorParametersBuilder.filter, iteratorParametersBuilder.lowBound, iteratorParametersBuilder.highBound, iteratorParametersBuilder.keepBinary, iteratorParametersBuilder.bufferSize, iteratorParametersBuilder.strictBoundsCheck){

                @Override
                protected void onClose() throws IgniteCheckedException {
                    super.onClose();
                    StandaloneGridKernalContext.closeAllComponents(sctx.kernalContext());
                }
            };
        }
        return new StandaloneWalRecordsIterator(iteratorParametersBuilder.log == null ? this.log : iteratorParametersBuilder.log, iteratorParametersBuilder.sharedCtx, iteratorParametersBuilder.ioFactory, this.resolveWalFiles(iteratorParametersBuilder), iteratorParametersBuilder.filter, iteratorParametersBuilder.lowBound, iteratorParametersBuilder.highBound, iteratorParametersBuilder.keepBinary, iteratorParametersBuilder.bufferSize, iteratorParametersBuilder.strictBoundsCheck);
    }

    public List<T2<Long, Long>> hasGaps(String ... filesOrDirs) throws IllegalArgumentException {
        return this.hasGaps(new IteratorParametersBuilder().filesOrDirs(filesOrDirs));
    }

    public List<T2<Long, Long>> hasGaps(File ... filesOrDirs) throws IllegalArgumentException {
        return this.hasGaps(new IteratorParametersBuilder().filesOrDirs(filesOrDirs));
    }

    public List<T2<Long, Long>> hasGaps(@NotNull IteratorParametersBuilder iteratorParametersBuilder) throws IllegalArgumentException {
        iteratorParametersBuilder.validate();
        return this.hasGaps(this.resolveWalFiles(iteratorParametersBuilder));
    }

    public List<T2<Long, Long>> hasGaps(@NotNull List<FileDescriptor> descriptors) throws IllegalArgumentException {
        ArrayList<T2<Long, Long>> gaps = new ArrayList<T2<Long, Long>>();
        Iterator<FileDescriptor> it = descriptors.iterator();
        FileDescriptor prevFd = null;
        while (it.hasNext()) {
            FileDescriptor nextFd = it.next();
            if (prevFd == null) {
                prevFd = nextFd;
                continue;
            }
            if (prevFd.idx() + 1L != nextFd.idx()) {
                gaps.add(new T2<Long, Long>(prevFd.idx(), nextFd.idx()));
            }
            prevFd = nextFd;
        }
        return gaps;
    }

    public List<FileDescriptor> resolveWalFiles(IteratorParametersBuilder iteratorParametersBuilder) {
        File[] filesOrDirs = iteratorParametersBuilder.filesOrDirs;
        if (filesOrDirs == null || filesOrDirs.length == 0) {
            return Collections.emptyList();
        }
        final FileIOFactory ioFactory = iteratorParametersBuilder.ioFactory;
        final TreeSet<FileDescriptor> descriptors = new TreeSet<FileDescriptor>();
        for (File file : filesOrDirs) {
            if (file.isDirectory()) {
                try {
                    Files.walkFileTree(file.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) {
                            IgniteWalIteratorFactory.this.addFileDescriptor(path.toFile(), ioFactory, descriptors);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                catch (IOException e) {
                    U.error(this.log, "Failed to walk directories from root [" + file + "]. Skipping this directory.", e);
                }
                continue;
            }
            this.addFileDescriptor(file, ioFactory, descriptors);
        }
        return new ArrayList<FileDescriptor>(descriptors);
    }

    private void addFileDescriptor(File file, FileIOFactory ioFactory, TreeSet<FileDescriptor> descriptors) {
        if (file.length() < 29L) {
            return;
        }
        String fileName = file.getName();
        if (!FileWriteAheadLogManager.WAL_NAME_PATTERN.matcher(fileName).matches() && !FileWriteAheadLogManager.WAL_SEGMENT_FILE_COMPACTED_PATTERN.matcher(fileName).matches()) {
            return;
        }
        FileDescriptor desc = this.readFileDescriptor(file, ioFactory);
        if (desc != null) {
            descriptors.add(desc);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private FileDescriptor readFileDescriptor(File file, FileIOFactory ioFactory) {
        FileDescriptor ds = new FileDescriptor(file);
        try (SegmentIO fileIO = ds.toReadOnlyIO(ioFactory);){
            FileInput in;
            ByteBufferExpander buf;
            block16: {
                buf = new ByteBufferExpander(29, ByteOrder.nativeOrder());
                try {
                    in = this.segmentFileInputFactory.createFileInput(fileIO, buf);
                    int type = in.readUnsignedByte();
                    if (type != 0) break block16;
                    if (this.log.isInfoEnabled()) {
                        this.log.info("Reached logical end of the segment for file " + file);
                    }
                    FileDescriptor fileDescriptor = null;
                    buf.close();
                    return fileDescriptor;
                }
                catch (Throwable throwable) {
                    try {
                        buf.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            WALPointer ptr = RecordV1Serializer.readPosition(in);
            FileDescriptor fileDescriptor = new FileDescriptor(file, ptr.index());
            buf.close();
            return fileDescriptor;
        }
        catch (IOException e) {
            U.warn(this.log, "Failed to scan index from file [" + file + "]. Skipping this file during iteration", e);
            return null;
        }
    }

    @NotNull
    private GridCacheSharedContext prepareSharedCtx(final IteratorParametersBuilder iteratorParametersBuilder) throws IgniteCheckedException {
        StandaloneGridKernalContext kernalCtx = new StandaloneGridKernalContext(this.log, iteratorParametersBuilder.binaryMetadataFileStoreDir, iteratorParametersBuilder.marshallerMappingFileStoreDir){

            @Override
            protected IgniteConfiguration prepareIgniteConfiguration() {
                IgniteConfiguration cfg = super.prepareIgniteConfiguration();
                Consumer<IgniteConfiguration> modifier = iteratorParametersBuilder.ignCfgMod;
                if (modifier != null) {
                    modifier.accept(cfg);
                }
                return cfg;
            }
        };
        StandaloneIgniteCacheDatabaseSharedManager dbMgr = new StandaloneIgniteCacheDatabaseSharedManager(kernalCtx);
        dbMgr.setPageSize(iteratorParametersBuilder.pageSize);
        return GridCacheSharedContext.builder().setDatabaseManager(dbMgr).build(kernalCtx, null);
    }

    public static class ConsoleLogger
    implements IgniteLogger {
        public static final ConsoleLogger INSTANCE = new ConsoleLogger();
        private static final PrintStream OUT = System.out;
        private static final PrintStream ERR = System.err;

        private ConsoleLogger() {
        }

        @Override
        public IgniteLogger getLogger(Object ctgr) {
            return this;
        }

        @Override
        public void trace(String msg) {
        }

        @Override
        public void debug(String msg) {
        }

        @Override
        public void info(String msg) {
            OUT.println(msg);
        }

        @Override
        public void warning(String msg, @Nullable Throwable e) {
            OUT.println(msg);
            if (e != null) {
                e.printStackTrace(OUT);
            }
        }

        @Override
        public void error(String msg, @Nullable Throwable e) {
            ERR.println(msg);
            if (e != null) {
                e.printStackTrace(ERR);
            }
        }

        @Override
        public boolean isTraceEnabled() {
            return false;
        }

        @Override
        public boolean isDebugEnabled() {
            return false;
        }

        @Override
        public boolean isInfoEnabled() {
            return true;
        }

        @Override
        public boolean isQuiet() {
            return false;
        }

        @Override
        public String fileName() {
            return "SYSTEM.OUT";
        }
    }

    public static class IteratorParametersBuilder {
        private IgniteLogger log;
        public static final WALPointer DFLT_LOW_BOUND = new WALPointer(Long.MIN_VALUE, 0, 0);
        public static final WALPointer DFLT_HIGH_BOUND = new WALPointer(Long.MAX_VALUE, Integer.MAX_VALUE, 0);
        private File[] filesOrDirs;
        private int pageSize = 4096;
        private int bufferSize = 0x200000;
        private boolean keepBinary;
        private FileIOFactory ioFactory = new DataStorageConfiguration().getFileIOFactory();
        @Nullable
        private File binaryMetadataFileStoreDir;
        @Nullable
        private File marshallerMappingFileStoreDir;
        @Nullable
        private GridCacheSharedContext sharedCtx;
        @Nullable
        private Consumer<IgniteConfiguration> ignCfgMod;
        @Nullable
        private IgniteBiPredicate<WALRecord.RecordType, WALPointer> filter;
        private WALPointer lowBound = DFLT_LOW_BOUND;
        private WALPointer highBound = DFLT_HIGH_BOUND;
        private boolean strictBoundsCheck;

        public static IteratorParametersBuilder withIteratorParameters() {
            return new IteratorParametersBuilder();
        }

        public IteratorParametersBuilder log(IgniteLogger log) {
            this.log = log;
            return this;
        }

        public IteratorParametersBuilder filesOrDirs(String ... filesOrDirs) {
            File[] filesOrDirs0 = new File[filesOrDirs.length];
            for (int i = 0; i < filesOrDirs.length; ++i) {
                filesOrDirs0[i] = new File(filesOrDirs[i]);
            }
            return this.filesOrDirs(filesOrDirs0);
        }

        public IteratorParametersBuilder filesOrDirs(File ... filesOrDirs) {
            this.filesOrDirs = this.filesOrDirs == null ? filesOrDirs : this.merge(this.filesOrDirs, filesOrDirs);
            return this;
        }

        public IteratorParametersBuilder pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public IteratorParametersBuilder bufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public IteratorParametersBuilder keepBinary(boolean keepBinary) {
            this.keepBinary = keepBinary;
            return this;
        }

        public IteratorParametersBuilder ioFactory(FileIOFactory ioFactory) {
            this.ioFactory = ioFactory;
            return this;
        }

        public IteratorParametersBuilder binaryMetadataFileStoreDir(File binaryMetadataFileStoreDir) {
            this.binaryMetadataFileStoreDir = binaryMetadataFileStoreDir;
            return this;
        }

        public IteratorParametersBuilder marshallerMappingFileStoreDir(File marshallerMappingFileStoreDir) {
            this.marshallerMappingFileStoreDir = marshallerMappingFileStoreDir;
            return this;
        }

        public IteratorParametersBuilder sharedContext(GridCacheSharedContext sharedCtx) {
            this.sharedCtx = sharedCtx;
            return this;
        }

        public IteratorParametersBuilder igniteConfigurationModifier(Consumer<IgniteConfiguration> ignCfgMod) {
            this.ignCfgMod = ignCfgMod;
            return this;
        }

        public IteratorParametersBuilder filter(IgniteBiPredicate<WALRecord.RecordType, WALPointer> filter) {
            this.filter = filter;
            return this;
        }

        public IteratorParametersBuilder addFilter(IgniteBiPredicate<WALRecord.RecordType, WALPointer> filter) {
            this.filter = this.filter == null ? filter : this.filter.and(filter);
            return this;
        }

        public IteratorParametersBuilder from(WALPointer lowBound) {
            this.lowBound = lowBound;
            return this;
        }

        public IteratorParametersBuilder to(WALPointer highBound) {
            this.highBound = highBound;
            return this;
        }

        public IteratorParametersBuilder strictBoundsCheck(boolean flag) {
            this.strictBoundsCheck = flag;
            return this;
        }

        public IteratorParametersBuilder copy() {
            return new IteratorParametersBuilder().filesOrDirs(this.filesOrDirs).pageSize(this.pageSize).bufferSize(this.bufferSize).keepBinary(this.keepBinary).ioFactory(this.ioFactory).binaryMetadataFileStoreDir(this.binaryMetadataFileStoreDir).marshallerMappingFileStoreDir(this.marshallerMappingFileStoreDir).sharedContext(this.sharedCtx).from(this.lowBound).to(this.highBound).filter(this.filter).strictBoundsCheck(this.strictBoundsCheck);
        }

        public void validate() throws IllegalArgumentException {
            A.ensure(this.pageSize >= 1024 && this.pageSize <= 16384, "Page size must be between 1kB and 16kB.");
            A.ensure(U.isPow2(this.pageSize), "Page size must be a power of 2.");
            A.ensure(this.bufferSize >= this.pageSize * 2, "Buffer to small.");
            A.ensure(this.sharedCtx == null || this.binaryMetadataFileStoreDir == null && this.marshallerMappingFileStoreDir == null, "GridCacheSharedContext and binaryMetadataFileStoreDir/marshallerMappingFileStoreDir can't be specified in the same time");
        }

        private File[] merge(File[] f1, File[] f2) {
            File[] merged = new File[f1.length + f2.length];
            System.arraycopy(f1, 0, merged, 0, f1.length);
            System.arraycopy(f2, 0, merged, f1.length, f2.length);
            return merged;
        }
    }
}

