/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.datastructures;

import org.apache.ignite.IgniteAtomicLong;
import org.apache.ignite.IgniteAtomicReference;
import org.apache.ignite.IgniteAtomicSequence;
import org.apache.ignite.IgniteAtomicStamped;
import org.apache.ignite.IgniteCountDownLatch;
import org.apache.ignite.IgniteLock;
import org.apache.ignite.IgniteQueue;
import org.apache.ignite.IgniteSemaphore;
import org.apache.ignite.IgniteSet;
import org.jetbrains.annotations.Nullable;

public enum DataStructureType {
    ATOMIC_LONG(IgniteAtomicLong.class.getSimpleName()),
    ATOMIC_REF(IgniteAtomicReference.class.getSimpleName()),
    ATOMIC_SEQ(IgniteAtomicSequence.class.getSimpleName()),
    ATOMIC_STAMPED(IgniteAtomicStamped.class.getSimpleName()),
    COUNT_DOWN_LATCH(IgniteCountDownLatch.class.getSimpleName()),
    QUEUE(IgniteQueue.class.getSimpleName()),
    SET(IgniteSet.class.getSimpleName()),
    SEMAPHORE(IgniteSemaphore.class.getSimpleName()),
    REENTRANT_LOCK(IgniteLock.class.getSimpleName());

    private static final DataStructureType[] VALS;
    private String name;

    private DataStructureType(String name) {
        this.name = name;
    }

    public String className() {
        return this.name;
    }

    public boolean isVolatile() {
        return this == REENTRANT_LOCK || this == SEMAPHORE || this == COUNT_DOWN_LATCH;
    }

    public boolean isCollection() {
        return this == SET || this == QUEUE;
    }

    @Nullable
    public static DataStructureType fromOrdinal(int ord) {
        return ord >= 0 && ord < VALS.length ? VALS[ord] : null;
    }

    static {
        VALS = DataStructureType.values();
    }
}

