/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.datastreamer;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Map;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.binary.BinaryRawWriterEx;
import org.apache.ignite.internal.processors.platform.PlatformAbstractPredicate;
import org.apache.ignite.internal.processors.platform.PlatformContext;
import org.apache.ignite.internal.processors.platform.PlatformTargetProxyImpl;
import org.apache.ignite.internal.processors.platform.cache.PlatformCache;
import org.apache.ignite.internal.processors.platform.datastreamer.PlatformStreamReceiver;
import org.apache.ignite.internal.processors.platform.memory.PlatformMemory;
import org.apache.ignite.internal.processors.platform.memory.PlatformOutputStream;
import org.apache.ignite.internal.processors.platform.utils.PlatformUtils;
import org.apache.ignite.resources.IgniteInstanceResource;

public class PlatformStreamReceiverImpl
extends PlatformAbstractPredicate
implements PlatformStreamReceiver {
    private static final long serialVersionUID = 0L;
    private boolean keepBinary;

    public PlatformStreamReceiverImpl() {
    }

    public PlatformStreamReceiverImpl(Object pred, long ptr, boolean keepBinary, PlatformContext ctx) {
        super(pred, ptr, ctx);
        assert (pred != null);
        this.keepBinary = keepBinary;
    }

    @Override
    public void receive(IgniteCache<Object, Object> cache, Collection<Map.Entry<Object, Object>> collection) throws IgniteException {
        assert (this.ctx != null);
        try (PlatformMemory mem = this.ctx.memory().allocate();){
            PlatformOutputStream out = mem.output();
            out.writeLong(this.ptr);
            out.writeBoolean(this.keepBinary);
            BinaryRawWriterEx writer = this.ctx.writer(out);
            writer.writeObject(this.pred);
            writer.writeInt(collection.size());
            for (Map.Entry<Object, Object> e : collection) {
                writer.writeObject(e.getKey());
                writer.writeObject(e.getValue());
            }
            out.synchronize();
            PlatformCache cache0 = new PlatformCache(this.ctx, cache, this.keepBinary);
            PlatformTargetProxyImpl cacheProxy = new PlatformTargetProxyImpl(cache0, this.ctx);
            this.ctx.gateway().dataStreamerStreamReceiverInvoke(this.ptr, cacheProxy, mem.pointer(), this.keepBinary);
        }
    }

    @IgniteInstanceResource
    public void setIgniteInstance(Ignite ignite) {
        this.ctx = PlatformUtils.platformContext(ignite);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.keepBinary);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.keepBinary = in.readBoolean();
    }
}

