/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.crs.geo;

import mil.nga.crs.CRSType;
import mil.nga.crs.common.ReferenceFrame;
import mil.nga.crs.geo.Ellipsoid;
import mil.nga.crs.geo.GeoDatum;
import mil.nga.crs.geo.PrimeMeridian;

public class GeoReferenceFrame
extends ReferenceFrame
implements GeoDatum {
    private Ellipsoid ellipsoid = null;
    private PrimeMeridian primeMeridian = null;

    public GeoReferenceFrame() {
        this(CRSType.GEODETIC);
    }

    public GeoReferenceFrame(CRSType type) {
        super(type);
    }

    public GeoReferenceFrame(String name, Ellipsoid ellipsoid) {
        this(name, CRSType.GEODETIC, ellipsoid);
    }

    public GeoReferenceFrame(String name, CRSType type, Ellipsoid ellipsoid) {
        super(name, type);
        this.setEllipsoid(ellipsoid);
    }

    @Override
    public Ellipsoid getEllipsoid() {
        return this.ellipsoid;
    }

    @Override
    public void setEllipsoid(Ellipsoid ellipsoid) {
        this.ellipsoid = ellipsoid;
    }

    @Override
    public PrimeMeridian getPrimeMeridian() {
        return this.primeMeridian;
    }

    @Override
    public boolean hasPrimeMeridian() {
        return this.getPrimeMeridian() != null;
    }

    @Override
    public void setPrimeMeridian(PrimeMeridian primeMeridian) {
        this.primeMeridian = primeMeridian;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.ellipsoid == null ? 0 : this.ellipsoid.hashCode());
        result = 31 * result + (this.primeMeridian == null ? 0 : this.primeMeridian.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GeoReferenceFrame other = (GeoReferenceFrame)obj;
        if (this.ellipsoid == null ? other.ellipsoid != null : !this.ellipsoid.equals(other.ellipsoid)) {
            return false;
        }
        return !(this.primeMeridian == null ? other.primeMeridian != null : !this.primeMeridian.equals(other.primeMeridian));
    }
}

