/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client;

import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Objects;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;

final class IgnoreHostsTrustManager
extends X509ExtendedTrustManager {
    private final X509ExtendedTrustManager delegate;
    private final Set<String> insecureHosts;

    static IgnoreHostsTrustManager of(Set<String> insecureHosts) {
        X509ExtendedTrustManager delegate = null;
        try {
            TrustManager[] trustManagers;
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            for (TrustManager tm : trustManagers = trustManagerFactory.getTrustManagers()) {
                if (!(tm instanceof X509ExtendedTrustManager)) continue;
                delegate = (X509ExtendedTrustManager)tm;
                break;
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            // empty catch block
        }
        Objects.requireNonNull(delegate, "cannot resolve default trust manager");
        return new IgnoreHostsTrustManager(delegate, ImmutableSet.copyOf(insecureHosts));
    }

    IgnoreHostsTrustManager(X509ExtendedTrustManager delegate, Set<String> insecureHosts) {
        this.delegate = delegate;
        this.insecureHosts = insecureHosts;
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String authType, Socket socket) throws CertificateException {
        if (!this.insecureHosts.contains(((InetSocketAddress)socket.getRemoteSocketAddress()).getHostString())) {
            this.delegate.checkServerTrusted(x509Certificates, authType, socket);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String authType, SSLEngine sslEngine) throws CertificateException {
        if (!this.insecureHosts.contains(sslEngine.getPeerHost())) {
            this.delegate.checkServerTrusted(x509Certificates, authType, sslEngine);
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String authType, Socket socket) throws CertificateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String authType, SSLEngine sslEngine) throws CertificateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509Certificates, String authType) throws CertificateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.delegate.getAcceptedIssuers();
    }
}

