/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.provider.AbstractStereographic;
import org.apache.sis.referencing.operation.provider.LambertConformal1SP;
import org.apache.sis.referencing.operation.provider.Mercator1SP;
import org.apache.sis.referencing.operation.provider.ObliqueStereographic;
import org.apache.sis.util.internal.Numerics;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;

@XmlTransient
public final class PolarStereographicA
extends AbstractStereographic {
    private static final long serialVersionUID = 538262714055500925L;
    public static final String NAME = "Polar Stereographic (variant A)";
    public static final String IDENTIFIER = "9810";
    public static final ParameterDescriptor<Double> LATITUDE_OF_ORIGIN;
    public static final ParameterDescriptor<Double> LONGITUDE_OF_ORIGIN;
    public static final ParameterDescriptor<Double> SCALE_FACTOR;
    static final ParameterDescriptorGroup PARAMETERS;
    public static final int UPS_SHIFT = 2000000;

    public PolarStereographicA() {
        super(PARAMETERS);
    }

    public static String setParameters(ParameterValueGroup group, boolean north) {
        group.parameter("latitude_of_origin").setValue(north ? 90.0 : -90.0, Units.DEGREE);
        group.parameter("central_meridian").setValue(0.0, Units.DEGREE);
        group.parameter("scale_factor").setValue(0.994, Units.UNITY);
        group.parameter("false_easting").setValue(2000000.0, Units.METRE);
        group.parameter("false_northing").setValue(2000000.0, Units.METRE);
        return "Universal Polar Stereographic " + (north ? "North" : "South");
    }

    public static int isUPS(ParameterValueGroup group) {
        if (Numerics.epsilonEqual((double)group.parameter("scale_factor").doubleValue(Units.UNITY), (double)0.994, (double)1.0E-13) && Numerics.epsilonEqual((double)group.parameter("false_easting").doubleValue(Units.METRE), (double)2000000.0, (double)0.01) && Numerics.epsilonEqual((double)group.parameter("false_northing").doubleValue(Units.METRE), (double)2000000.0, (double)0.01) && Numerics.epsilonEqual((double)group.parameter("central_meridian").doubleValue(Units.DEGREE), (double)0.0, (double)8.999280057595393E-8)) {
            double \u03c6 = group.parameter("latitude_of_origin").doubleValue(Units.DEGREE);
            if (Numerics.epsilonEqual((double)\u03c6, (double)90.0, (double)8.999280057595393E-8)) {
                return 1;
            }
            if (Numerics.epsilonEqual((double)\u03c6, (double)-90.0, (double)8.999280057595393E-8)) {
                return -1;
            }
        }
        return 0;
    }

    static {
        SCALE_FACTOR = Mercator1SP.SCALE_FACTOR;
        ParameterBuilder builder = PolarStereographicA.builder();
        LATITUDE_OF_ORIGIN = PolarStereographicA.createMandatoryLatitude((ParameterBuilder)((ParameterBuilder)builder.addNamesAndIdentifiers((IdentifiedObject)LambertConformal1SP.LATITUDE_OF_ORIGIN)).setRemarks((CharSequence)Resources.formatInternational((short)71)));
        LONGITUDE_OF_ORIGIN = PolarStereographicA.createLongitude((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addNamesAndIdentifiers((IdentifiedObject)ObliqueStereographic.LONGITUDE_OF_ORIGIN)).reidentify((Citation)Citations.GEOTIFF, "3095")).rename((Citation)Citations.GEOTIFF, "StraightVertPoleLong"));
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)((ParameterBuilder)builder.addIdentifier(IDENTIFIER)).addName(NAME)).addName((Citation)Citations.OGC, "Polar_Stereographic")).addName((Citation)Citations.PROJ4, "stere")).createGroupForMapProjection(LATITUDE_OF_ORIGIN, LONGITUDE_OF_ORIGIN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING);
    }
}

