/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform1D;
import org.apache.sis.referencing.operation.transform.ConstantTransform1D;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.LinearTransform1D;
import org.apache.sis.referencing.operation.transform.LogarithmicTransform1D;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.referencing.operation.transform.PowerTransform1D;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.internal.Numerics;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.FactoryException;

final class ExponentialTransform1D
extends AbstractMathTransform1D
implements Serializable {
    private static final long serialVersionUID = 5331178990358868947L;
    final double base;
    final double lnBase;
    final double scale;
    private MathTransform1D inverse;

    ExponentialTransform1D(LogarithmicTransform1D inverse) {
        this.base = inverse.base();
        this.lnBase = inverse.lnBase();
        this.scale = inverse.pow(-inverse.offset());
        this.inverse = inverse;
    }

    protected ExponentialTransform1D(double base, double scale) {
        this.base = base;
        this.scale = scale;
        this.lnBase = Math.log(base);
    }

    public static MathTransform1D create(double base, double scale) {
        if (base == 0.0 || scale == 0.0) {
            return ConstantTransform1D.ZERO;
        }
        if (base == 1.0) {
            return LinearTransform1D.create(scale, null);
        }
        return new ExponentialTransform1D(base, scale);
    }

    @Override
    public synchronized MathTransform1D inverse() {
        if (this.inverse == null) {
            this.inverse = LogarithmicTransform1D.create(this);
        }
        return this.inverse;
    }

    @Override
    public double derivative(double value) {
        return this.lnBase * this.transform(value);
    }

    @Override
    public double transform(double value) {
        return this.scale * Math.pow(this.base, value);
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        if (srcPts != dstPts || srcOff >= dstOff) {
            while (--numPts >= 0) {
                dstPts[dstOff++] = this.scale * Math.pow(this.base, srcPts[srcOff++]);
            }
        } else {
            srcOff += numPts;
            dstOff += numPts;
            while (--numPts >= 0) {
                dstPts[--dstOff] = this.scale * Math.pow(this.base, srcPts[--srcOff]);
            }
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        if (srcPts != dstPts || srcOff >= dstOff) {
            while (--numPts >= 0) {
                dstPts[dstOff++] = (float)(this.scale * Math.pow(this.base, srcPts[srcOff++]));
            }
        } else {
            srcOff += numPts;
            dstOff += numPts;
            while (--numPts >= 0) {
                dstPts[--dstOff] = (float)(this.scale * Math.pow(this.base, srcPts[--srcOff]));
            }
        }
    }

    @Override
    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) {
        while (--numPts >= 0) {
            dstPts[dstOff++] = (float)(this.scale * Math.pow(this.base, srcPts[srcOff++]));
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        while (--numPts >= 0) {
            dstPts[dstOff++] = this.scale * Math.pow(this.base, srcPts[srcOff++]);
        }
    }

    @Override
    protected MathTransform tryConcatenate(boolean applyOtherFirst, MathTransform other, MathTransformFactory factory) throws FactoryException {
        if (other instanceof LinearTransform) {
            LinearTransform1D linear = (LinearTransform1D)other;
            if (applyOtherFirst) {
                double newBase = Math.pow(this.base, linear.scale);
                double newScale = Math.pow(this.base, linear.offset) * this.scale;
                if (!Double.isNaN(newBase) && !Double.isNaN(newScale)) {
                    return ExponentialTransform1D.create(newBase, newScale);
                }
            } else if (linear.offset == 0.0) {
                return ExponentialTransform1D.create(this.base, this.scale * linear.scale);
            }
        } else if (other instanceof LogarithmicTransform1D) {
            return this.concatenateLog((LogarithmicTransform1D)other, applyOtherFirst);
        }
        return super.tryConcatenate(applyOtherFirst, other, factory);
    }

    final MathTransform concatenateLog(LogarithmicTransform1D other, boolean applyOtherFirst) {
        double newScale = this.lnBase / other.lnBase();
        if (applyOtherFirst) {
            return MathTransforms.concatenate(PowerTransform1D.create(newScale), LinearTransform1D.create(this.scale * Math.pow(this.base, other.offset()), null));
        }
        double newOffset = this.scale > 0.0 ? other.log(this.scale) + other.offset() : other.log(this.scale * other.offset() * other.lnBase());
        if (!Double.isNaN(newOffset)) {
            return LinearTransform1D.create(newScale, newOffset);
        }
        return null;
    }

    @Override
    protected int computeHashCode() {
        return Long.hashCode(Double.doubleToLongBits(this.base) + 31L * Double.doubleToLongBits(this.scale)) ^ super.computeHashCode();
    }

    @Override
    public boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, mode)) {
            ExponentialTransform1D that = (ExponentialTransform1D)object;
            return Numerics.equals((double)this.base, (double)that.base) && Numerics.equals((double)this.scale, (double)that.scale);
        }
        return false;
    }
}

