/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.stream;

import java.util.Spliterator;
import java.util.stream.StreamSupport;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.collection.BackingStoreException;
import org.apache.sis.util.stream.StreamWrapper;

public abstract class DeferredStream<T>
extends StreamWrapper<T> {
    private final CloseHandler closeHandler;

    protected DeferredStream(int characteristics, boolean parallel) {
        this.source = StreamSupport.stream(this::terminal, characteristics, parallel);
        this.closeHandler = new CloseHandler();
        this.source.onClose(this.closeHandler);
        this.toClose = this.source;
    }

    private Spliterator<T> terminal() {
        this.source = null;
        try {
            return this.createSourceIterator();
        }
        catch (Exception cause) {
            BackingStoreException ex = cause instanceof BackingStoreException ? (BackingStoreException)cause : new BackingStoreException((Throwable)Exceptions.unwrap((Exception)cause));
            throw ex;
        }
    }

    protected abstract Spliterator<T> createSourceIterator() throws Exception;

    protected final void setCloseHandler(AutoCloseable handler) {
        this.closeHandler.handler = handler;
    }

    private static final class CloseHandler
    implements Runnable {
        AutoCloseable handler;

        private CloseHandler() {
        }

        @Override
        public void run() {
            AutoCloseable h = this.handler;
            this.handler = null;
            if (h != null) {
                try {
                    h.close();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BackingStoreException((Throwable)e);
                }
            }
        }
    }
}

