/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelOperation;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;

public class UpdateBloomFilterOperation
extends HotRodOperation<Void>
implements ChannelOperation {
    private final SocketAddress address;
    private final byte[] bloomBits;

    protected UpdateBloomFilterOperation(Codec codec, ChannelFactory channelFactory, byte[] cacheName, AtomicInteger topologyId, int flags, Configuration cfg, SocketAddress address, byte[] bloomBits) {
        super((short)67, (short)68, codec, flags, cfg, cacheName, topologyId, channelFactory);
        this.address = address;
        this.bloomBits = bloomBits;
    }

    @Override
    public CompletableFuture<Void> execute() {
        try {
            this.channelFactory.fetchChannelAndInvoke(this.address, this);
        }
        catch (Exception e) {
            this.completeExceptionally(e);
        }
        return this;
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        this.complete(null);
    }

    @Override
    public void invoke(Channel channel) {
        this.scheduleRead(channel);
        this.sendArrayOperation(channel, this.bloomBits);
        this.releaseChannel(channel);
    }

    @Override
    public void cancel(SocketAddress address, Throwable cause) {
        this.completeExceptionally(cause);
    }
}

